/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRDesignPackage;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRModelElement;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRNotationType;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRPresentationElement;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public abstract class MIRDiagram
extends MIRModelObject {
    protected transient int aBackgroundColor = 0xFFFFFF;
    protected transient int aMaxDefinitionLength = 40;
    protected transient byte aNotation = 0;
    protected transient MIRDesignPackage hasDefaultOfDesignPackage = null;
    protected transient MIRDesignPackage hasDesignPackage = null;
    protected transient MIRObjectCollection<MIRModelElement> modelElements = null;
    protected transient MIRObjectCollection<MIRPresentationElement> presentationElements = null;
    private static MIRMetaClass metaClass = MIRDiagram.staticGetMetaClass();

    @Override
    public short getElementType() {
        return 10;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)10)) {
            this.setBackgroundColor(((MIRDiagram)mIR_Object).getBackgroundColor());
            this.setMaxDefinitionLength(((MIRDiagram)mIR_Object).getMaxDefinitionLength());
            this.setNotation(((MIRDiagram)mIR_Object).getNotation());
        }
    }

    @Override
    public MIRObject getParent() {
        if (this.hasDesignPackage != null) {
            return this.hasDesignPackage;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasDesignPackage != null ? 1 : 0) + super.getParentCount();
    }

    public final void setBackgroundColor(int n) {
        this.aBackgroundColor = n;
    }

    public final int getBackgroundColor() {
        return this.aBackgroundColor;
    }

    public final void setMaxDefinitionLength(int n) {
        this.aMaxDefinitionLength = n;
    }

    public final int getMaxDefinitionLength() {
        return this.aMaxDefinitionLength;
    }

    public final void setNotation(byte by) {
        this.aNotation = by;
    }

    public final byte getNotation() {
        return this.aNotation;
    }

    public final void addDefaultOfDesignPackage(MIRDesignPackage mIRDesignPackage) {
        if (mIRDesignPackage == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Diagram", "DefaultOfDesignPackage"));
        }
        if (mIRDesignPackage._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Diagram", "DefaultOfDesignPackage"));
        }
        if (this.hasDefaultOfDesignPackage != null) {
            if (this.hasDefaultOfDesignPackage._equals(mIRDesignPackage)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Diagram", "DefaultOfDesignPackage"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Diagram", "DefaultOfDesignPackage"));
        }
        if (mIRDesignPackage.hasDefaultDiagram != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("DesignPackage", "DefaultDiagram"));
        }
        this.hasDefaultOfDesignPackage = mIRDesignPackage;
        mIRDesignPackage.hasDefaultDiagram = this;
    }

    public final MIRDesignPackage getDefaultOfDesignPackage() {
        return this.hasDefaultOfDesignPackage;
    }

    public final boolean removeDefaultOfDesignPackage() {
        if (this.hasDefaultOfDesignPackage != null) {
            this.hasDefaultOfDesignPackage.hasDefaultDiagram = null;
            this.hasDefaultOfDesignPackage = null;
            return true;
        }
        return false;
    }

    public final void addDesignPackage(MIRDesignPackage mIRDesignPackage) {
        if (mIRDesignPackage == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Diagram", "DesignPackage"));
        }
        if (mIRDesignPackage._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Diagram", "DesignPackage"));
        }
        if (this.hasDesignPackage != null) {
            if (this.hasDesignPackage._equals(mIRDesignPackage)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Diagram", "DesignPackage"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Diagram", "DesignPackage"));
        }
        if (mIRDesignPackage.diagrams != null && !mIRDesignPackage._allowName(mIRDesignPackage.diagrams, this)) {
            throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("DesignPackage", mIRDesignPackage.getPath(), "Diagram", "Object", this.getName()));
        }
        this.hasDesignPackage = mIRDesignPackage;
        mIRDesignPackage.getDiagramCollection().add(this);
    }

    public final MIRDesignPackage getDesignPackage() {
        return this.hasDesignPackage;
    }

    public final boolean removeDesignPackage() {
        if (this.hasDesignPackage != null) {
            this.hasDesignPackage.diagrams.remove(this);
            if (this.hasDesignPackage.diagrams.isEmpty()) {
                this.hasDesignPackage.diagrams = null;
            }
            this.hasDesignPackage = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRModelElement> getModelElementCollection() {
        this.modelElements = MIRObjectCollections.get(this.modelElements, MIRSdkCollection.Type.OBJECT);
        return this.modelElements;
    }

    public SortedSet<MIRModelElement> getModelElements() {
        return MIRObjectCollections.sortedSet(this.modelElements);
    }

    public final void addModelElement(MIRModelElement mIRModelElement) {
        if (mIRModelElement == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Diagram", "ModelElement"));
        }
        if (mIRModelElement._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Diagram", "ModelElement"));
        }
        if (this.modelElements != null && this.modelElements.contains(mIRModelElement)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Diagram", "ModelElement"));
        }
        this.getModelElementCollection().add(mIRModelElement);
        mIRModelElement.getDiagramCollection().add(this);
    }

    public final int getModelElementCount() {
        if (this.modelElements != null) {
            return this.modelElements.size();
        }
        return 0;
    }

    public final boolean containsModelElement(MIRModelElement mIRModelElement) {
        if (mIRModelElement != null && this.modelElements != null) {
            return this.modelElements.contains(mIRModelElement);
        }
        return false;
    }

    public final MIRModelElement getModelElement(String string) {
        if (this.modelElements != null) {
            return this.modelElements.get(string);
        }
        return null;
    }

    public final Iterator<MIRModelElement> getModelElementIterator() {
        if (this.modelElements != null) {
            return this.modelElements.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeModelElement(MIRModelElement mIRModelElement) {
        if (mIRModelElement != null && this.modelElements != null && this.modelElements.remove(mIRModelElement)) {
            mIRModelElement.diagrams.remove(this);
            if (mIRModelElement.diagrams.isEmpty()) {
                mIRModelElement.diagrams = null;
            }
            if (this.modelElements.isEmpty()) {
                this.modelElements = null;
            }
            return true;
        }
        return false;
    }

    public final void removeModelElements() {
        if (this.modelElements != null) {
            for (MIRModelElement mIRModelElement : this.modelElements) {
                mIRModelElement.diagrams.remove(this);
                if (!mIRModelElement.diagrams.isEmpty()) continue;
                mIRModelElement.diagrams = null;
            }
            this.modelElements = null;
        }
    }

    protected MIRObjectCollection<MIRPresentationElement> getPresentationElementCollection() {
        this.presentationElements = MIRObjectCollections.get(this.presentationElements, MIRSdkCollection.Type.OBJECT);
        return this.presentationElements;
    }

    public SortedSet<MIRPresentationElement> getPresentationElements() {
        return MIRObjectCollections.sortedSet(this.presentationElements);
    }

    public final void addPresentationElement(MIRPresentationElement mIRPresentationElement) {
        if (mIRPresentationElement == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Diagram", "PresentationElement"));
        }
        if (mIRPresentationElement._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Diagram", "PresentationElement"));
        }
        if (mIRPresentationElement.hasDiagram != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("PresentationElement", "Diagram"));
        }
        if (this.presentationElements != null && this.presentationElements.contains(mIRPresentationElement)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Diagram", "PresentationElement"));
        }
        this.getPresentationElementCollection().add(mIRPresentationElement);
        mIRPresentationElement.hasDiagram = this;
    }

    public final int getPresentationElementCount() {
        if (this.presentationElements != null) {
            return this.presentationElements.size();
        }
        return 0;
    }

    public final boolean containsPresentationElement(MIRPresentationElement mIRPresentationElement) {
        if (mIRPresentationElement != null && this.presentationElements != null) {
            return this.presentationElements.contains(mIRPresentationElement);
        }
        return false;
    }

    public final MIRPresentationElement getPresentationElement(String string) {
        if (this.presentationElements != null) {
            return this.presentationElements.get(string);
        }
        return null;
    }

    public final Iterator<MIRPresentationElement> getPresentationElementIterator() {
        if (this.presentationElements != null) {
            return this.presentationElements.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removePresentationElement(MIRPresentationElement mIRPresentationElement) {
        if (mIRPresentationElement != null && this.presentationElements != null && this.presentationElements.remove(mIRPresentationElement)) {
            mIRPresentationElement.hasDiagram = null;
            if (this.presentationElements.isEmpty()) {
                this.presentationElements = null;
            }
            return true;
        }
        return false;
    }

    public final void removePresentationElements() {
        if (this.presentationElements != null) {
            for (MIRPresentationElement mIRPresentationElement : this.presentationElements) {
                mIRPresentationElement.hasDiagram = null;
            }
            this.presentationElements = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRModelObject.staticGetMetaClass(), 10, "Diagram", true);
            new MIRMetaAttribute(metaClass, 459, "Notation", "java.lang.Byte", MIRNotationType.class, new Byte(0));
            new MIRMetaAttribute(metaClass, 458, "MaxDefinitionLength", "java.lang.Integer", null, new Integer(40));
            new MIRMetaAttribute(metaClass, 506, "BackgroundColor", "java.lang.Integer", null, new Integer(0xFFFFFF));
            new MIRMetaLink(metaClass, 273, "DefaultOfDesignPackage", true, 0, 9, 309);
            new MIRMetaLink(metaClass, 88, "DesignPackage", true, 2, 9, 196);
            new MIRMetaLink(metaClass, 89, "ModelElement", false, 0, 12, 181);
            new MIRMetaLink(metaClass, 90, "PresentationElement", false, 3, 61, 210);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRDiagram.staticGetMetaClass();
    }

    @Override
    protected boolean _isValidName() {
        if (this.hasDesignPackage != null && !this.hasDesignPackage._allowName(this.hasDesignPackage.diagrams, this)) {
            return false;
        }
        return super._isValidName();
    }

    @Override
    protected void _rename(String string) {
        if (this.hasDesignPackage != null) {
            this.hasDesignPackage.diagrams.rename(this, string);
        }
        if (this.modelElements != null) {
            for (MIRModelElement mIRModelElement : this.modelElements) {
                mIRModelElement.diagrams.rename(this, string);
            }
        }
        super._rename(string);
    }
}

