/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRCubeDimensionAssociation;
import MITI.sdk.MIRFilter;
import MITI.sdk.MIRJoin;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public class MIRCube
extends MIRClassifier {
    protected transient MIRObjectCollection<MIRCubeDimensionAssociation> cubeDimensionAssociations = null;
    protected transient MIRObjectCollection<MIRFilter> filters = null;
    protected transient MIRObjectCollection<MIRJoin> joins = null;
    private static MIRMetaClass metaClass = MIRCube.staticGetMetaClass();

    public MIRCube() {
    }

    public MIRCube(MIRCube mIRCube) {
        this.setFrom(mIRCube);
    }

    @Override
    public Object clone() {
        return new MIRCube(this);
    }

    @Override
    public short getElementType() {
        return 85;
    }

    protected MIRObjectCollection<MIRCubeDimensionAssociation> getCubeDimensionAssociationCollection() {
        this.cubeDimensionAssociations = MIRObjectCollections.get(this.cubeDimensionAssociations, MIRSdkCollection.Type.OBJECT);
        return this.cubeDimensionAssociations;
    }

    public SortedSet<MIRCubeDimensionAssociation> getCubeDimensionAssociations() {
        return MIRObjectCollections.sortedSet(this.cubeDimensionAssociations);
    }

    public final void addCubeDimensionAssociation(MIRCubeDimensionAssociation mIRCubeDimensionAssociation) {
        if (mIRCubeDimensionAssociation == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Cube", "CubeDimensionAssociation"));
        }
        if (mIRCubeDimensionAssociation._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Cube", "CubeDimensionAssociation"));
        }
        if (mIRCubeDimensionAssociation.hasCube != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("CubeDimensionAssociation", "Cube"));
        }
        if (this.cubeDimensionAssociations != null && this.cubeDimensionAssociations.contains(mIRCubeDimensionAssociation)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Cube", "CubeDimensionAssociation"));
        }
        this.getCubeDimensionAssociationCollection().add(mIRCubeDimensionAssociation);
        mIRCubeDimensionAssociation.hasCube = this;
    }

    public final int getCubeDimensionAssociationCount() {
        if (this.cubeDimensionAssociations != null) {
            return this.cubeDimensionAssociations.size();
        }
        return 0;
    }

    public final boolean containsCubeDimensionAssociation(MIRCubeDimensionAssociation mIRCubeDimensionAssociation) {
        if (mIRCubeDimensionAssociation != null && this.cubeDimensionAssociations != null) {
            return this.cubeDimensionAssociations.contains(mIRCubeDimensionAssociation);
        }
        return false;
    }

    public final MIRCubeDimensionAssociation getCubeDimensionAssociation(String string) {
        if (this.cubeDimensionAssociations != null) {
            return this.cubeDimensionAssociations.get(string);
        }
        return null;
    }

    public final Iterator<MIRCubeDimensionAssociation> getCubeDimensionAssociationIterator() {
        if (this.cubeDimensionAssociations != null) {
            return this.cubeDimensionAssociations.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeCubeDimensionAssociation(MIRCubeDimensionAssociation mIRCubeDimensionAssociation) {
        if (mIRCubeDimensionAssociation != null && this.cubeDimensionAssociations != null && this.cubeDimensionAssociations.remove(mIRCubeDimensionAssociation)) {
            mIRCubeDimensionAssociation.hasCube = null;
            if (this.cubeDimensionAssociations.isEmpty()) {
                this.cubeDimensionAssociations = null;
            }
            return true;
        }
        return false;
    }

    public final void removeCubeDimensionAssociations() {
        if (this.cubeDimensionAssociations != null) {
            for (MIRCubeDimensionAssociation mIRCubeDimensionAssociation : this.cubeDimensionAssociations) {
                mIRCubeDimensionAssociation.hasCube = null;
            }
            this.cubeDimensionAssociations = null;
        }
    }

    protected MIRObjectCollection<MIRFilter> getFilterCollection() {
        this.filters = MIRObjectCollections.get(this.filters, MIRSdkCollection.Type.OBJECT);
        return this.filters;
    }

    public SortedSet<MIRFilter> getFilters() {
        return MIRObjectCollections.sortedSet(this.filters);
    }

    public final void addFilter(MIRFilter mIRFilter) {
        if (mIRFilter == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Cube", "Filter"));
        }
        if (mIRFilter._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Cube", "Filter"));
        }
        if (this.filters != null && this.filters.contains(mIRFilter)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Cube", "Filter"));
        }
        this.getFilterCollection().add(mIRFilter);
        mIRFilter.getCubeCollection().add(this);
    }

    public final int getFilterCount() {
        if (this.filters != null) {
            return this.filters.size();
        }
        return 0;
    }

    public final boolean containsFilter(MIRFilter mIRFilter) {
        if (mIRFilter != null && this.filters != null) {
            return this.filters.contains(mIRFilter);
        }
        return false;
    }

    public final MIRFilter getFilter(String string) {
        if (this.filters != null) {
            return this.filters.get(string);
        }
        return null;
    }

    public final Iterator<MIRFilter> getFilterIterator() {
        if (this.filters != null) {
            return this.filters.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeFilter(MIRFilter mIRFilter) {
        if (mIRFilter != null && this.filters != null && this.filters.remove(mIRFilter)) {
            mIRFilter.cubes.remove(this);
            if (mIRFilter.cubes.isEmpty()) {
                mIRFilter.cubes = null;
            }
            if (this.filters.isEmpty()) {
                this.filters = null;
            }
            return true;
        }
        return false;
    }

    public final void removeFilters() {
        if (this.filters != null) {
            for (MIRFilter mIRFilter : this.filters) {
                mIRFilter.cubes.remove(this);
                if (!mIRFilter.cubes.isEmpty()) continue;
                mIRFilter.cubes = null;
            }
            this.filters = null;
        }
    }

    protected MIRObjectCollection<MIRJoin> getJoinCollection() {
        this.joins = MIRObjectCollections.get(this.joins, MIRSdkCollection.Type.OBJECT);
        return this.joins;
    }

    public SortedSet<MIRJoin> getJoins() {
        return MIRObjectCollections.sortedSet(this.joins);
    }

    public final void addJoin(MIRJoin mIRJoin) {
        if (mIRJoin == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Cube", "Join"));
        }
        if (mIRJoin._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Cube", "Join"));
        }
        if (this.joins != null && this.joins.contains(mIRJoin)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Cube", "Join"));
        }
        this.getJoinCollection().add(mIRJoin);
        mIRJoin.getCubeCollection().add(this);
    }

    public final int getJoinCount() {
        if (this.joins != null) {
            return this.joins.size();
        }
        return 0;
    }

    public final boolean containsJoin(MIRJoin mIRJoin) {
        if (mIRJoin != null && this.joins != null) {
            return this.joins.contains(mIRJoin);
        }
        return false;
    }

    public final MIRJoin getJoin(String string) {
        if (this.joins != null) {
            return this.joins.get(string);
        }
        return null;
    }

    public final Iterator<MIRJoin> getJoinIterator() {
        if (this.joins != null) {
            return this.joins.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeJoin(MIRJoin mIRJoin) {
        if (mIRJoin != null && this.joins != null && this.joins.remove(mIRJoin)) {
            mIRJoin.cubes.remove(this);
            if (mIRJoin.cubes.isEmpty()) {
                mIRJoin.cubes = null;
            }
            if (this.joins.isEmpty()) {
                this.joins = null;
            }
            return true;
        }
        return false;
    }

    public final void removeJoins() {
        if (this.joins != null) {
            for (MIRJoin mIRJoin : this.joins) {
                mIRJoin.cubes.remove(this);
                if (!mIRJoin.cubes.isEmpty()) continue;
                mIRJoin.cubes = null;
            }
            this.joins = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRClassifier.staticGetMetaClass(), 85, "Cube", false);
            new MIRMetaLink(metaClass, 77, "CubeDimensionAssociation", false, 3, 86, 78);
            new MIRMetaLink(metaClass, 75, "Filter", false, 0, 89, 120);
            new MIRMetaLink(metaClass, 76, "Join", false, 0, 92, 149);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRCube.staticGetMetaClass();
    }

    @Override
    protected void _rename(String string) {
        if (this.filters != null) {
            for (MIRFilter mIRClassifier : this.filters) {
                mIRClassifier.cubes.rename(this, string);
            }
        }
        if (this.joins != null) {
            for (MIRJoin mIRJoin : this.joins) {
                mIRJoin.cubes.rename(this, string);
            }
        }
        super._rename(string);
    }
}

