/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRConnectionDataSet;
import MITI.sdk.MIRFlatFileDescriptor;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRTransformation;
import MITI.sdk.MIRUsedParameter;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public abstract class MIRConnectedTransformation
extends MIRTransformation {
    protected transient String aConnectionName = "";
    protected transient boolean aPositionBasedQuery = false;
    protected transient boolean aUserDefinedQuery = false;
    protected transient MIRObjectCollection<MIRConnectionDataSet> connectionDataSets = null;
    protected transient MIRFlatFileDescriptor hasFlatFileDescriptor = null;
    protected transient MIRObjectCollection<MIRUsedParameter> usedParameters = null;
    private static MIRMetaClass metaClass = MIRConnectedTransformation.staticGetMetaClass();

    @Override
    public short getElementType() {
        return 220;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)220)) {
            this.setConnectionName(((MIRConnectedTransformation)mIR_Object).getConnectionName());
            this.setPositionBasedQuery(((MIRConnectedTransformation)mIR_Object).getPositionBasedQuery());
            this.setUserDefinedQuery(((MIRConnectedTransformation)mIR_Object).getUserDefinedQuery());
        }
    }

    public final void setConnectionName(String string) {
        this.aConnectionName = string == null ? "" : string;
    }

    public final String getConnectionName() {
        return this.aConnectionName;
    }

    public final void setPositionBasedQuery(boolean bl) {
        this.aPositionBasedQuery = bl;
    }

    public final boolean getPositionBasedQuery() {
        return this.aPositionBasedQuery;
    }

    public final void setUserDefinedQuery(boolean bl) {
        this.aUserDefinedQuery = bl;
    }

    public final boolean getUserDefinedQuery() {
        return this.aUserDefinedQuery;
    }

    protected MIRObjectCollection<MIRConnectionDataSet> getConnectionDataSetCollection() {
        this.connectionDataSets = MIRObjectCollections.get(this.connectionDataSets, MIRSdkCollection.Type.OBJECT);
        return this.connectionDataSets;
    }

    public SortedSet<MIRConnectionDataSet> getConnectionDataSets() {
        return MIRObjectCollections.sortedSet(this.connectionDataSets);
    }

    public final void addConnectionDataSet(MIRConnectionDataSet mIRConnectionDataSet) {
        if (mIRConnectionDataSet == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ConnectedTransformation", "ConnectionDataSet"));
        }
        if (mIRConnectionDataSet._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ConnectedTransformation", "ConnectionDataSet"));
        }
        if (mIRConnectionDataSet.hasConnectedTransformation != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ConnectionDataSet", "ConnectedTransformation"));
        }
        if (this.connectionDataSets != null && this.connectionDataSets.contains(mIRConnectionDataSet)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ConnectedTransformation", "ConnectionDataSet"));
        }
        this.getConnectionDataSetCollection().add(mIRConnectionDataSet);
        mIRConnectionDataSet.hasConnectedTransformation = this;
    }

    public final int getConnectionDataSetCount() {
        if (this.connectionDataSets != null) {
            return this.connectionDataSets.size();
        }
        return 0;
    }

    public final boolean containsConnectionDataSet(MIRConnectionDataSet mIRConnectionDataSet) {
        if (mIRConnectionDataSet != null && this.connectionDataSets != null) {
            return this.connectionDataSets.contains(mIRConnectionDataSet);
        }
        return false;
    }

    public final MIRConnectionDataSet getConnectionDataSet(String string) {
        if (this.connectionDataSets != null) {
            return this.connectionDataSets.get(string);
        }
        return null;
    }

    public final Iterator<MIRConnectionDataSet> getConnectionDataSetIterator() {
        if (this.connectionDataSets != null) {
            return this.connectionDataSets.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeConnectionDataSet(MIRConnectionDataSet mIRConnectionDataSet) {
        if (mIRConnectionDataSet != null && this.connectionDataSets != null && this.connectionDataSets.remove(mIRConnectionDataSet)) {
            mIRConnectionDataSet.hasConnectedTransformation = null;
            if (this.connectionDataSets.isEmpty()) {
                this.connectionDataSets = null;
            }
            return true;
        }
        return false;
    }

    public final void removeConnectionDataSets() {
        if (this.connectionDataSets != null) {
            for (MIRConnectionDataSet mIRConnectionDataSet : this.connectionDataSets) {
                mIRConnectionDataSet.hasConnectedTransformation = null;
            }
            this.connectionDataSets = null;
        }
    }

    public final void addFlatFileDescriptor(MIRFlatFileDescriptor mIRFlatFileDescriptor) {
        if (mIRFlatFileDescriptor == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ConnectedTransformation", "FlatFileDescriptor"));
        }
        if (mIRFlatFileDescriptor._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ConnectedTransformation", "FlatFileDescriptor"));
        }
        if (this.hasFlatFileDescriptor != null) {
            if (this.hasFlatFileDescriptor._equals(mIRFlatFileDescriptor)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ConnectedTransformation", "FlatFileDescriptor"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ConnectedTransformation", "FlatFileDescriptor"));
        }
        if (mIRFlatFileDescriptor.hasConnectedTransformation != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("FlatFileDescriptor", "ConnectedTransformation"));
        }
        this.hasFlatFileDescriptor = mIRFlatFileDescriptor;
        mIRFlatFileDescriptor.hasConnectedTransformation = this;
    }

    public final MIRFlatFileDescriptor getFlatFileDescriptor() {
        return this.hasFlatFileDescriptor;
    }

    public final boolean removeFlatFileDescriptor() {
        if (this.hasFlatFileDescriptor != null) {
            this.hasFlatFileDescriptor.hasConnectedTransformation = null;
            this.hasFlatFileDescriptor = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRUsedParameter> getUsedParameterCollection() {
        this.usedParameters = MIRObjectCollections.get(this.usedParameters, MIRSdkCollection.Type.NAME);
        return this.usedParameters;
    }

    public SortedSet<MIRUsedParameter> getUsedParameters() {
        return MIRObjectCollections.sortedSet(this.usedParameters);
    }

    public final void addUsedParameter(MIRUsedParameter mIRUsedParameter) {
        if (mIRUsedParameter == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ConnectedTransformation", "UsedParameter"));
        }
        if (mIRUsedParameter._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ConnectedTransformation", "UsedParameter"));
        }
        if (mIRUsedParameter.hasConnectedTransformation != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("UsedParameter", "ConnectedTransformation"));
        }
        if (this.usedParameters != null) {
            if (this.usedParameters.contains(mIRUsedParameter)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ConnectedTransformation", "UsedParameter"));
            }
            if (!this._allowName(this.usedParameters, mIRUsedParameter)) {
                throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("ConnectedTransformation", this.getPath(), "UsedParameter", "Name", mIRUsedParameter.getPath()));
            }
        }
        this.getUsedParameterCollection().add(mIRUsedParameter);
        mIRUsedParameter.hasConnectedTransformation = this;
    }

    public final boolean addUsedParameterUniqueName(MIRUsedParameter mIRUsedParameter) {
        return this.addUsedParameterUniqueName(mIRUsedParameter, '/');
    }

    public final boolean addUsedParameterUniqueName(MIRUsedParameter mIRUsedParameter, char c) {
        if (mIRUsedParameter == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ConnectedTransformation", "UsedParameter"));
        }
        if (mIRUsedParameter._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ConnectedTransformation", "UsedParameter"));
        }
        if (mIRUsedParameter.hasConnectedTransformation != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("UsedParameter", "ConnectedTransformation"));
        }
        boolean bl = false;
        if (this.usedParameters != null) {
            if (this.usedParameters.contains(mIRUsedParameter)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ConnectedTransformation", "UsedParameter"));
            }
            if (!this._allowName(this.usedParameters, mIRUsedParameter)) {
                mIRUsedParameter._rename(mIRUsedParameter._setUniqueName(this.usedParameters, c));
                bl = true;
            }
        }
        this.getUsedParameterCollection().add(mIRUsedParameter);
        mIRUsedParameter.hasConnectedTransformation = this;
        return bl;
    }

    public final int getUsedParameterCount() {
        if (this.usedParameters != null) {
            return this.usedParameters.size();
        }
        return 0;
    }

    public final boolean containsUsedParameter(MIRUsedParameter mIRUsedParameter) {
        if (mIRUsedParameter != null && this.usedParameters != null) {
            return this.usedParameters.contains(mIRUsedParameter);
        }
        return false;
    }

    public final MIRUsedParameter getUsedParameter(String string) {
        if (this.usedParameters != null) {
            return this.usedParameters.get(string);
        }
        return null;
    }

    public final Iterator<MIRUsedParameter> getUsedParameterIterator() {
        if (this.usedParameters != null) {
            return this.usedParameters.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeUsedParameter(MIRUsedParameter mIRUsedParameter) {
        if (mIRUsedParameter != null && this.usedParameters != null && this.usedParameters.remove(mIRUsedParameter)) {
            mIRUsedParameter.hasConnectedTransformation = null;
            if (this.usedParameters.isEmpty()) {
                this.usedParameters = null;
            }
            return true;
        }
        return false;
    }

    public final void removeUsedParameters() {
        if (this.usedParameters != null) {
            for (MIRUsedParameter mIRUsedParameter : this.usedParameters) {
                mIRUsedParameter.hasConnectedTransformation = null;
            }
            this.usedParameters = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRTransformation.staticGetMetaClass(), 220, "ConnectedTransformation", true);
            new MIRMetaAttribute(metaClass, 342, "ConnectionName", "java.lang.String", null, "");
            new MIRMetaAttribute(metaClass, 357, "PositionBasedQuery", "java.lang.Boolean", null, new Boolean(false));
            new MIRMetaAttribute(metaClass, 456, "UserDefinedQuery", "java.lang.Boolean", null, new Boolean(false));
            new MIRMetaLink(metaClass, 645, "ConnectionDataSet", false, 3, 254, 646);
            new MIRMetaLink(metaClass, 1002, "FlatFileDescriptor", true, 3, 327, 1003);
            new MIRMetaLink(metaClass, 798, "UsedParameter", false, 3, 268, 797);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRConnectedTransformation.staticGetMetaClass();
    }
}

