/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRConnection;
import MITI.sdk.MIRFolderContentModel;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public class MIRConfigurationModel
extends MIRFolderContentModel {
    protected transient MIRObjectCollection<MIRConnection> ignoredConnections = null;
    private static MIRMetaClass metaClass = MIRConfigurationModel.staticGetMetaClass();

    public MIRConfigurationModel() {
    }

    public MIRConfigurationModel(MIRConfigurationModel mIRConfigurationModel) {
        this.setFrom(mIRConfigurationModel);
    }

    @Override
    public Object clone() {
        return new MIRConfigurationModel(this);
    }

    @Override
    public short getElementType() {
        return 274;
    }

    protected MIRObjectCollection<MIRConnection> getIgnoredConnectionCollection() {
        this.ignoredConnections = MIRObjectCollections.get(this.ignoredConnections, MIRSdkCollection.Type.OBJECT);
        return this.ignoredConnections;
    }

    public SortedSet<MIRConnection> getIgnoredConnections() {
        return MIRObjectCollections.sortedSet(this.ignoredConnections);
    }

    public final void addIgnoredConnection(MIRConnection mIRConnection) {
        if (mIRConnection == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ConfigurationModel", "IgnoredConnection"));
        }
        if (mIRConnection._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ConfigurationModel", "IgnoredConnection"));
        }
        if (mIRConnection.hasConfigurationModel != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Connection", "ConfigurationModel"));
        }
        if (this.ignoredConnections != null && this.ignoredConnections.contains(mIRConnection)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ConfigurationModel", "IgnoredConnection"));
        }
        this.getIgnoredConnectionCollection().add(mIRConnection);
        mIRConnection.hasConfigurationModel = this;
    }

    public final int getIgnoredConnectionCount() {
        if (this.ignoredConnections != null) {
            return this.ignoredConnections.size();
        }
        return 0;
    }

    public final boolean containsIgnoredConnection(MIRConnection mIRConnection) {
        if (mIRConnection != null && this.ignoredConnections != null) {
            return this.ignoredConnections.contains(mIRConnection);
        }
        return false;
    }

    public final MIRConnection getIgnoredConnection(String string) {
        if (this.ignoredConnections != null) {
            return this.ignoredConnections.get(string);
        }
        return null;
    }

    public final Iterator<MIRConnection> getIgnoredConnectionIterator() {
        if (this.ignoredConnections != null) {
            return this.ignoredConnections.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeIgnoredConnection(MIRConnection mIRConnection) {
        if (mIRConnection != null && this.ignoredConnections != null && this.ignoredConnections.remove(mIRConnection)) {
            mIRConnection.hasConfigurationModel = null;
            if (this.ignoredConnections.isEmpty()) {
                this.ignoredConnections = null;
            }
            return true;
        }
        return false;
    }

    public final void removeIgnoredConnections() {
        if (this.ignoredConnections != null) {
            for (MIRConnection mIRConnection : this.ignoredConnections) {
                mIRConnection.hasConfigurationModel = null;
            }
            this.ignoredConnections = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRFolderContentModel.staticGetMetaClass(), 274, "ConfigurationModel", false);
            new MIRMetaLink(metaClass, 989, "IgnoredConnection", false, 0, 213, 990);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRConfigurationModel.staticGetMetaClass();
    }
}

