/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRConnectionDataPackage;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRJoinRelationship;
import MITI.sdk.MIRJoinRole;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRModelElement;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRReport;
import MITI.sdk.MIRSQLViewAssociation;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;

public abstract class MIRClassifier
extends MIRModelElement {
    protected transient int aLineageOptions = 0;
    protected transient MIRObjectCollection<MIRJoinRole> associatedJoinRoles = null;
    protected transient MIRClassifierMap hasClassifierMap = null;
    protected transient MIRConnectionDataPackage hasConnectionDataPackage = null;
    protected transient MIRObjectCollection<MIRClassifierMap> controlOfClassifierMaps = null;
    protected transient MIRObjectCollection<MIRClassifierMap> destinationOfClassifierMaps = null;
    protected transient MIRObjectCollection<MIRFeature> features = null;
    protected transient MIRObjectCollection<MIRJoinRelationship> leftOfJoinRelationships = null;
    protected transient MIRReport hasReport = null;
    protected transient MIRObjectCollection<MIRJoinRelationship> rightOfJoinRelationships = null;
    protected transient MIRObjectCollection<MIRClassifierMap> sourceOfClassifierMaps = null;
    protected transient MIRObjectCollection<MIRSQLViewAssociation> sourceOfSQLViewAssociations = null;
    private static MIRMetaClass metaClass = MIRClassifier.staticGetMetaClass();

    @Override
    public short getElementType() {
        return 75;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)75)) {
            this.setLineageOptions(((MIRClassifier)mIR_Object).getLineageOptions());
        }
    }

    @Override
    public MIRObject getParent() {
        if (this.hasReport != null) {
            return this.hasReport;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasReport != null ? 1 : 0) + super.getParentCount();
    }

    public final void setLineageOptions(int n) {
        this.aLineageOptions = n;
    }

    public final int getLineageOptions() {
        return this.aLineageOptions;
    }

    protected MIRObjectCollection<MIRJoinRole> getAssociatedJoinRoleCollection() {
        this.associatedJoinRoles = MIRObjectCollections.get(this.associatedJoinRoles, MIRSdkCollection.Type.OBJECT);
        return this.associatedJoinRoles;
    }

    public SortedSet<MIRJoinRole> getAssociatedJoinRoles() {
        return MIRObjectCollections.sortedSet(this.associatedJoinRoles);
    }

    public final void addAssociatedJoinRole(MIRJoinRole mIRJoinRole) {
        if (mIRJoinRole == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Classifier", "AssociatedJoinRole"));
        }
        if (mIRJoinRole._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Classifier", "AssociatedJoinRole"));
        }
        if (mIRJoinRole.hasClassifier != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("JoinRole", "Classifier"));
        }
        if (this.associatedJoinRoles != null && this.associatedJoinRoles.contains(mIRJoinRole)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Classifier", "AssociatedJoinRole"));
        }
        this.getAssociatedJoinRoleCollection().add(mIRJoinRole);
        mIRJoinRole.hasClassifier = this;
    }

    public final int getAssociatedJoinRoleCount() {
        if (this.associatedJoinRoles != null) {
            return this.associatedJoinRoles.size();
        }
        return 0;
    }

    public final boolean containsAssociatedJoinRole(MIRJoinRole mIRJoinRole) {
        if (mIRJoinRole != null && this.associatedJoinRoles != null) {
            return this.associatedJoinRoles.contains(mIRJoinRole);
        }
        return false;
    }

    public final MIRJoinRole getAssociatedJoinRole(String string) {
        if (this.associatedJoinRoles != null) {
            return this.associatedJoinRoles.get(string);
        }
        return null;
    }

    public final Iterator<MIRJoinRole> getAssociatedJoinRoleIterator() {
        if (this.associatedJoinRoles != null) {
            return this.associatedJoinRoles.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeAssociatedJoinRole(MIRJoinRole mIRJoinRole) {
        if (mIRJoinRole != null && this.associatedJoinRoles != null && this.associatedJoinRoles.remove(mIRJoinRole)) {
            mIRJoinRole.hasClassifier = null;
            if (this.associatedJoinRoles.isEmpty()) {
                this.associatedJoinRoles = null;
            }
            return true;
        }
        return false;
    }

    public final void removeAssociatedJoinRoles() {
        if (this.associatedJoinRoles != null) {
            for (MIRJoinRole mIRJoinRole : this.associatedJoinRoles) {
                mIRJoinRole.hasClassifier = null;
            }
            this.associatedJoinRoles = null;
        }
    }

    public final void addClassifierMap(MIRClassifierMap mIRClassifierMap) {
        if (mIRClassifierMap == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Classifier", "ClassifierMap"));
        }
        if (mIRClassifierMap._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Classifier", "ClassifierMap"));
        }
        if (this.hasClassifierMap != null) {
            if (this.hasClassifierMap._equals(mIRClassifierMap)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Classifier", "ClassifierMap"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Classifier", "ClassifierMap"));
        }
        if (mIRClassifierMap.hasClassifier != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ClassifierMap", "Classifier"));
        }
        this.hasClassifierMap = mIRClassifierMap;
        mIRClassifierMap.hasClassifier = this;
    }

    public final MIRClassifierMap getClassifierMap() {
        return this.hasClassifierMap;
    }

    public final boolean removeClassifierMap() {
        if (this.hasClassifierMap != null) {
            this.hasClassifierMap.hasClassifier = null;
            this.hasClassifierMap = null;
            return true;
        }
        return false;
    }

    public final void addConnectionDataPackage(MIRConnectionDataPackage mIRConnectionDataPackage) {
        if (mIRConnectionDataPackage == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Classifier", "ConnectionDataPackage"));
        }
        if (mIRConnectionDataPackage._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Classifier", "ConnectionDataPackage"));
        }
        if (this.hasConnectionDataPackage != null) {
            if (this.hasConnectionDataPackage._equals(mIRConnectionDataPackage)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Classifier", "ConnectionDataPackage"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Classifier", "ConnectionDataPackage"));
        }
        this.hasConnectionDataPackage = mIRConnectionDataPackage;
        mIRConnectionDataPackage.getClassifierCollection().add(this);
    }

    public final MIRConnectionDataPackage getConnectionDataPackage() {
        return this.hasConnectionDataPackage;
    }

    public final boolean removeConnectionDataPackage() {
        if (this.hasConnectionDataPackage != null) {
            this.hasConnectionDataPackage.classifiers.remove(this);
            if (this.hasConnectionDataPackage.classifiers.isEmpty()) {
                this.hasConnectionDataPackage.classifiers = null;
            }
            this.hasConnectionDataPackage = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRClassifierMap> getControlOfClassifierMapCollection() {
        this.controlOfClassifierMaps = MIRObjectCollections.get(this.controlOfClassifierMaps, MIRSdkCollection.Type.OBJECT);
        return this.controlOfClassifierMaps;
    }

    public SortedSet<MIRClassifierMap> getControlOfClassifierMaps() {
        return MIRObjectCollections.sortedSet(this.controlOfClassifierMaps);
    }

    public final void addControlOfClassifierMap(MIRClassifierMap mIRClassifierMap) {
        if (mIRClassifierMap == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Classifier", "ControlOfClassifierMap"));
        }
        if (mIRClassifierMap._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Classifier", "ControlOfClassifierMap"));
        }
        if (this.controlOfClassifierMaps != null && this.controlOfClassifierMaps.contains(mIRClassifierMap)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Classifier", "ControlOfClassifierMap"));
        }
        this.getControlOfClassifierMapCollection().add(mIRClassifierMap);
        mIRClassifierMap.getControlClassifierCollection().add(this);
    }

    public final int getControlOfClassifierMapCount() {
        if (this.controlOfClassifierMaps != null) {
            return this.controlOfClassifierMaps.size();
        }
        return 0;
    }

    public final boolean containsControlOfClassifierMap(MIRClassifierMap mIRClassifierMap) {
        if (mIRClassifierMap != null && this.controlOfClassifierMaps != null) {
            return this.controlOfClassifierMaps.contains(mIRClassifierMap);
        }
        return false;
    }

    public final MIRClassifierMap getControlOfClassifierMap(String string) {
        if (this.controlOfClassifierMaps != null) {
            return this.controlOfClassifierMaps.get(string);
        }
        return null;
    }

    public final Iterator<MIRClassifierMap> getControlOfClassifierMapIterator() {
        if (this.controlOfClassifierMaps != null) {
            return this.controlOfClassifierMaps.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeControlOfClassifierMap(MIRClassifierMap mIRClassifierMap) {
        if (mIRClassifierMap != null && this.controlOfClassifierMaps != null && this.controlOfClassifierMaps.remove(mIRClassifierMap)) {
            mIRClassifierMap.controlClassifiers.remove(this);
            if (mIRClassifierMap.controlClassifiers.isEmpty()) {
                mIRClassifierMap.controlClassifiers = null;
            }
            if (this.controlOfClassifierMaps.isEmpty()) {
                this.controlOfClassifierMaps = null;
            }
            return true;
        }
        return false;
    }

    public final void removeControlOfClassifierMaps() {
        if (this.controlOfClassifierMaps != null) {
            for (MIRClassifierMap mIRClassifierMap : this.controlOfClassifierMaps) {
                mIRClassifierMap.controlClassifiers.remove(this);
                if (!mIRClassifierMap.controlClassifiers.isEmpty()) continue;
                mIRClassifierMap.controlClassifiers = null;
            }
            this.controlOfClassifierMaps = null;
        }
    }

    protected MIRObjectCollection<MIRClassifierMap> getDestinationOfClassifierMapCollection() {
        this.destinationOfClassifierMaps = MIRObjectCollections.get(this.destinationOfClassifierMaps, MIRSdkCollection.Type.OBJECT);
        return this.destinationOfClassifierMaps;
    }

    public SortedSet<MIRClassifierMap> getDestinationOfClassifierMaps() {
        return MIRObjectCollections.sortedSet(this.destinationOfClassifierMaps);
    }

    public final void addDestinationOfClassifierMap(MIRClassifierMap mIRClassifierMap) {
        if (mIRClassifierMap == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Classifier", "DestinationOfClassifierMap"));
        }
        if (mIRClassifierMap._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Classifier", "DestinationOfClassifierMap"));
        }
        if (mIRClassifierMap.hasDestinationClassifier != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ClassifierMap", "DestinationClassifier"));
        }
        if (this.destinationOfClassifierMaps != null && this.destinationOfClassifierMaps.contains(mIRClassifierMap)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Classifier", "DestinationOfClassifierMap"));
        }
        this.getDestinationOfClassifierMapCollection().add(mIRClassifierMap);
        mIRClassifierMap.hasDestinationClassifier = this;
    }

    public final int getDestinationOfClassifierMapCount() {
        if (this.destinationOfClassifierMaps != null) {
            return this.destinationOfClassifierMaps.size();
        }
        return 0;
    }

    public final boolean containsDestinationOfClassifierMap(MIRClassifierMap mIRClassifierMap) {
        if (mIRClassifierMap != null && this.destinationOfClassifierMaps != null) {
            return this.destinationOfClassifierMaps.contains(mIRClassifierMap);
        }
        return false;
    }

    public final MIRClassifierMap getDestinationOfClassifierMap(String string) {
        if (this.destinationOfClassifierMaps != null) {
            return this.destinationOfClassifierMaps.get(string);
        }
        return null;
    }

    public final Iterator<MIRClassifierMap> getDestinationOfClassifierMapIterator() {
        if (this.destinationOfClassifierMaps != null) {
            return this.destinationOfClassifierMaps.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeDestinationOfClassifierMap(MIRClassifierMap mIRClassifierMap) {
        if (mIRClassifierMap != null && this.destinationOfClassifierMaps != null && this.destinationOfClassifierMaps.remove(mIRClassifierMap)) {
            mIRClassifierMap.hasDestinationClassifier = null;
            if (this.destinationOfClassifierMaps.isEmpty()) {
                this.destinationOfClassifierMaps = null;
            }
            return true;
        }
        return false;
    }

    public final void removeDestinationOfClassifierMaps() {
        if (this.destinationOfClassifierMaps != null) {
            for (MIRClassifierMap mIRClassifierMap : this.destinationOfClassifierMaps) {
                mIRClassifierMap.hasDestinationClassifier = null;
            }
            this.destinationOfClassifierMaps = null;
        }
    }

    protected MIRObjectCollection<MIRFeature> getFeatureCollection() {
        this.features = MIRObjectCollections.get(this.features, MIRSdkCollection.Type.NAME);
        return this.features;
    }

    public SortedSet<MIRFeature> getFeatures() {
        return MIRObjectCollections.sortedSet(this.features);
    }

    public final void addFeature(MIRFeature mIRFeature) {
        if (mIRFeature == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Classifier", "Feature"));
        }
        if (mIRFeature._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Classifier", "Feature"));
        }
        if (mIRFeature.hasClassifier != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Feature", "Classifier"));
        }
        if (this.features != null) {
            if (this.features.contains(mIRFeature)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Classifier", "Feature"));
            }
            if (!this._allowName(this.features, mIRFeature)) {
                throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("Classifier", this.getPath(), "Feature", "Name", mIRFeature.getPath()));
            }
        }
        this.getFeatureCollection().add(mIRFeature);
        mIRFeature.hasClassifier = this;
    }

    public final boolean addFeatureUniqueName(MIRFeature mIRFeature) {
        return this.addFeatureUniqueName(mIRFeature, '/');
    }

    public final boolean addFeatureUniqueName(MIRFeature mIRFeature, char c) {
        if (mIRFeature == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Classifier", "Feature"));
        }
        if (mIRFeature._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Classifier", "Feature"));
        }
        if (mIRFeature.hasClassifier != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Feature", "Classifier"));
        }
        boolean bl = false;
        if (this.features != null) {
            if (this.features.contains(mIRFeature)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Classifier", "Feature"));
            }
            if (!this._allowName(this.features, mIRFeature)) {
                mIRFeature._rename(mIRFeature._setUniqueName(this.features, c));
                bl = true;
            }
        }
        this.getFeatureCollection().add(mIRFeature);
        mIRFeature.hasClassifier = this;
        return bl;
    }

    public final int getFeatureCount() {
        if (this.features != null) {
            return this.features.size();
        }
        return 0;
    }

    public final boolean containsFeature(MIRFeature mIRFeature) {
        if (mIRFeature != null && this.features != null) {
            return this.features.contains(mIRFeature);
        }
        return false;
    }

    public final MIRFeature getFeature(String string) {
        if (this.features != null) {
            return this.features.get(string);
        }
        return null;
    }

    public final Iterator<MIRFeature> getFeatureIterator() {
        if (this.features != null) {
            return this.features.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final List<MIRFeature> getFeatureByPosition() {
        if (this.features != null) {
            ArrayList<MIRFeature> arrayList = new ArrayList<MIRFeature>();
            arrayList.addAll(this.features.values());
            MIRObjectCollections.sort(arrayList, MIRFeature.ByPosition);
            return arrayList;
        }
        return MIRObjectCollections.emptyList();
    }

    public final boolean removeFeature(MIRFeature mIRFeature) {
        if (mIRFeature != null && this.features != null && this.features.remove(mIRFeature)) {
            mIRFeature.hasClassifier = null;
            if (this.features.isEmpty()) {
                this.features = null;
            }
            return true;
        }
        return false;
    }

    public final void removeFeatures() {
        if (this.features != null) {
            for (MIRFeature mIRFeature : this.features) {
                mIRFeature.hasClassifier = null;
            }
            this.features = null;
        }
    }

    protected MIRObjectCollection<MIRJoinRelationship> getLeftOfJoinRelationshipCollection() {
        this.leftOfJoinRelationships = MIRObjectCollections.get(this.leftOfJoinRelationships, MIRSdkCollection.Type.OBJECT);
        return this.leftOfJoinRelationships;
    }

    public SortedSet<MIRJoinRelationship> getLeftOfJoinRelationships() {
        return MIRObjectCollections.sortedSet(this.leftOfJoinRelationships);
    }

    public final void addLeftOfJoinRelationship(MIRJoinRelationship mIRJoinRelationship) {
        if (mIRJoinRelationship == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Classifier", "LeftOfJoinRelationship"));
        }
        if (mIRJoinRelationship._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Classifier", "LeftOfJoinRelationship"));
        }
        if (mIRJoinRelationship.hasLeftClassifier != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("JoinRelationship", "LeftClassifier"));
        }
        if (this.leftOfJoinRelationships != null && this.leftOfJoinRelationships.contains(mIRJoinRelationship)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Classifier", "LeftOfJoinRelationship"));
        }
        this.getLeftOfJoinRelationshipCollection().add(mIRJoinRelationship);
        mIRJoinRelationship.hasLeftClassifier = this;
    }

    public final int getLeftOfJoinRelationshipCount() {
        if (this.leftOfJoinRelationships != null) {
            return this.leftOfJoinRelationships.size();
        }
        return 0;
    }

    public final boolean containsLeftOfJoinRelationship(MIRJoinRelationship mIRJoinRelationship) {
        if (mIRJoinRelationship != null && this.leftOfJoinRelationships != null) {
            return this.leftOfJoinRelationships.contains(mIRJoinRelationship);
        }
        return false;
    }

    public final MIRJoinRelationship getLeftOfJoinRelationship(String string) {
        if (this.leftOfJoinRelationships != null) {
            return this.leftOfJoinRelationships.get(string);
        }
        return null;
    }

    public final Iterator<MIRJoinRelationship> getLeftOfJoinRelationshipIterator() {
        if (this.leftOfJoinRelationships != null) {
            return this.leftOfJoinRelationships.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeLeftOfJoinRelationship(MIRJoinRelationship mIRJoinRelationship) {
        if (mIRJoinRelationship != null && this.leftOfJoinRelationships != null && this.leftOfJoinRelationships.remove(mIRJoinRelationship)) {
            mIRJoinRelationship.hasLeftClassifier = null;
            if (this.leftOfJoinRelationships.isEmpty()) {
                this.leftOfJoinRelationships = null;
            }
            return true;
        }
        return false;
    }

    public final void removeLeftOfJoinRelationships() {
        if (this.leftOfJoinRelationships != null) {
            for (MIRJoinRelationship mIRJoinRelationship : this.leftOfJoinRelationships) {
                mIRJoinRelationship.hasLeftClassifier = null;
            }
            this.leftOfJoinRelationships = null;
        }
    }

    public final void addReport(MIRReport mIRReport) {
        if (mIRReport == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Classifier", "Report"));
        }
        if (mIRReport._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Classifier", "Report"));
        }
        if (this.hasReport != null) {
            if (this.hasReport._equals(mIRReport)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Classifier", "Report"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Classifier", "Report"));
        }
        this.hasReport = mIRReport;
        mIRReport.getClassifierCollection().add(this);
    }

    public final MIRReport getReport() {
        return this.hasReport;
    }

    public final boolean removeReport() {
        if (this.hasReport != null) {
            this.hasReport.classifiers.remove(this);
            if (this.hasReport.classifiers.isEmpty()) {
                this.hasReport.classifiers = null;
            }
            this.hasReport = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRJoinRelationship> getRightOfJoinRelationshipCollection() {
        this.rightOfJoinRelationships = MIRObjectCollections.get(this.rightOfJoinRelationships, MIRSdkCollection.Type.OBJECT);
        return this.rightOfJoinRelationships;
    }

    public SortedSet<MIRJoinRelationship> getRightOfJoinRelationships() {
        return MIRObjectCollections.sortedSet(this.rightOfJoinRelationships);
    }

    public final void addRightOfJoinRelationship(MIRJoinRelationship mIRJoinRelationship) {
        if (mIRJoinRelationship == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Classifier", "RightOfJoinRelationship"));
        }
        if (mIRJoinRelationship._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Classifier", "RightOfJoinRelationship"));
        }
        if (mIRJoinRelationship.hasRightClassifier != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("JoinRelationship", "RightClassifier"));
        }
        if (this.rightOfJoinRelationships != null && this.rightOfJoinRelationships.contains(mIRJoinRelationship)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Classifier", "RightOfJoinRelationship"));
        }
        this.getRightOfJoinRelationshipCollection().add(mIRJoinRelationship);
        mIRJoinRelationship.hasRightClassifier = this;
    }

    public final int getRightOfJoinRelationshipCount() {
        if (this.rightOfJoinRelationships != null) {
            return this.rightOfJoinRelationships.size();
        }
        return 0;
    }

    public final boolean containsRightOfJoinRelationship(MIRJoinRelationship mIRJoinRelationship) {
        if (mIRJoinRelationship != null && this.rightOfJoinRelationships != null) {
            return this.rightOfJoinRelationships.contains(mIRJoinRelationship);
        }
        return false;
    }

    public final MIRJoinRelationship getRightOfJoinRelationship(String string) {
        if (this.rightOfJoinRelationships != null) {
            return this.rightOfJoinRelationships.get(string);
        }
        return null;
    }

    public final Iterator<MIRJoinRelationship> getRightOfJoinRelationshipIterator() {
        if (this.rightOfJoinRelationships != null) {
            return this.rightOfJoinRelationships.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeRightOfJoinRelationship(MIRJoinRelationship mIRJoinRelationship) {
        if (mIRJoinRelationship != null && this.rightOfJoinRelationships != null && this.rightOfJoinRelationships.remove(mIRJoinRelationship)) {
            mIRJoinRelationship.hasRightClassifier = null;
            if (this.rightOfJoinRelationships.isEmpty()) {
                this.rightOfJoinRelationships = null;
            }
            return true;
        }
        return false;
    }

    public final void removeRightOfJoinRelationships() {
        if (this.rightOfJoinRelationships != null) {
            for (MIRJoinRelationship mIRJoinRelationship : this.rightOfJoinRelationships) {
                mIRJoinRelationship.hasRightClassifier = null;
            }
            this.rightOfJoinRelationships = null;
        }
    }

    protected MIRObjectCollection<MIRClassifierMap> getSourceOfClassifierMapCollection() {
        this.sourceOfClassifierMaps = MIRObjectCollections.get(this.sourceOfClassifierMaps, MIRSdkCollection.Type.OBJECT);
        return this.sourceOfClassifierMaps;
    }

    public SortedSet<MIRClassifierMap> getSourceOfClassifierMaps() {
        return MIRObjectCollections.sortedSet(this.sourceOfClassifierMaps);
    }

    public final void addSourceOfClassifierMap(MIRClassifierMap mIRClassifierMap) {
        if (mIRClassifierMap == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Classifier", "SourceOfClassifierMap"));
        }
        if (mIRClassifierMap._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Classifier", "SourceOfClassifierMap"));
        }
        if (this.sourceOfClassifierMaps != null && this.sourceOfClassifierMaps.contains(mIRClassifierMap)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Classifier", "SourceOfClassifierMap"));
        }
        this.getSourceOfClassifierMapCollection().add(mIRClassifierMap);
        mIRClassifierMap.getSourceClassifierCollection().add(this);
    }

    public final int getSourceOfClassifierMapCount() {
        if (this.sourceOfClassifierMaps != null) {
            return this.sourceOfClassifierMaps.size();
        }
        return 0;
    }

    public final boolean containsSourceOfClassifierMap(MIRClassifierMap mIRClassifierMap) {
        if (mIRClassifierMap != null && this.sourceOfClassifierMaps != null) {
            return this.sourceOfClassifierMaps.contains(mIRClassifierMap);
        }
        return false;
    }

    public final MIRClassifierMap getSourceOfClassifierMap(String string) {
        if (this.sourceOfClassifierMaps != null) {
            return this.sourceOfClassifierMaps.get(string);
        }
        return null;
    }

    public final Iterator<MIRClassifierMap> getSourceOfClassifierMapIterator() {
        if (this.sourceOfClassifierMaps != null) {
            return this.sourceOfClassifierMaps.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeSourceOfClassifierMap(MIRClassifierMap mIRClassifierMap) {
        if (mIRClassifierMap != null && this.sourceOfClassifierMaps != null && this.sourceOfClassifierMaps.remove(mIRClassifierMap)) {
            mIRClassifierMap.sourceClassifiers.remove(this);
            if (mIRClassifierMap.sourceClassifiers.isEmpty()) {
                mIRClassifierMap.sourceClassifiers = null;
            }
            if (this.sourceOfClassifierMaps.isEmpty()) {
                this.sourceOfClassifierMaps = null;
            }
            return true;
        }
        return false;
    }

    public final void removeSourceOfClassifierMaps() {
        if (this.sourceOfClassifierMaps != null) {
            for (MIRClassifierMap mIRClassifierMap : this.sourceOfClassifierMaps) {
                mIRClassifierMap.sourceClassifiers.remove(this);
                if (!mIRClassifierMap.sourceClassifiers.isEmpty()) continue;
                mIRClassifierMap.sourceClassifiers = null;
            }
            this.sourceOfClassifierMaps = null;
        }
    }

    protected MIRObjectCollection<MIRSQLViewAssociation> getSourceOfSQLViewAssociationCollection() {
        this.sourceOfSQLViewAssociations = MIRObjectCollections.get(this.sourceOfSQLViewAssociations, MIRSdkCollection.Type.OBJECT);
        return this.sourceOfSQLViewAssociations;
    }

    public SortedSet<MIRSQLViewAssociation> getSourceOfSQLViewAssociations() {
        return MIRObjectCollections.sortedSet(this.sourceOfSQLViewAssociations);
    }

    public final void addSourceOfSQLViewAssociation(MIRSQLViewAssociation mIRSQLViewAssociation) {
        if (mIRSQLViewAssociation == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Classifier", "SourceOfSQLViewAssociation"));
        }
        if (mIRSQLViewAssociation._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Classifier", "SourceOfSQLViewAssociation"));
        }
        if (mIRSQLViewAssociation.hasSourceClassifier != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("SQLViewAssociation", "SourceClassifier"));
        }
        if (this.sourceOfSQLViewAssociations != null && this.sourceOfSQLViewAssociations.contains(mIRSQLViewAssociation)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Classifier", "SourceOfSQLViewAssociation"));
        }
        this.getSourceOfSQLViewAssociationCollection().add(mIRSQLViewAssociation);
        mIRSQLViewAssociation.hasSourceClassifier = this;
    }

    public final int getSourceOfSQLViewAssociationCount() {
        if (this.sourceOfSQLViewAssociations != null) {
            return this.sourceOfSQLViewAssociations.size();
        }
        return 0;
    }

    public final boolean containsSourceOfSQLViewAssociation(MIRSQLViewAssociation mIRSQLViewAssociation) {
        if (mIRSQLViewAssociation != null && this.sourceOfSQLViewAssociations != null) {
            return this.sourceOfSQLViewAssociations.contains(mIRSQLViewAssociation);
        }
        return false;
    }

    public final MIRSQLViewAssociation getSourceOfSQLViewAssociation(String string) {
        if (this.sourceOfSQLViewAssociations != null) {
            return this.sourceOfSQLViewAssociations.get(string);
        }
        return null;
    }

    public final Iterator<MIRSQLViewAssociation> getSourceOfSQLViewAssociationIterator() {
        if (this.sourceOfSQLViewAssociations != null) {
            return this.sourceOfSQLViewAssociations.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeSourceOfSQLViewAssociation(MIRSQLViewAssociation mIRSQLViewAssociation) {
        if (mIRSQLViewAssociation != null && this.sourceOfSQLViewAssociations != null && this.sourceOfSQLViewAssociations.remove(mIRSQLViewAssociation)) {
            mIRSQLViewAssociation.hasSourceClassifier = null;
            if (this.sourceOfSQLViewAssociations.isEmpty()) {
                this.sourceOfSQLViewAssociations = null;
            }
            return true;
        }
        return false;
    }

    public final void removeSourceOfSQLViewAssociations() {
        if (this.sourceOfSQLViewAssociations != null) {
            for (MIRSQLViewAssociation mIRSQLViewAssociation : this.sourceOfSQLViewAssociations) {
                mIRSQLViewAssociation.hasSourceClassifier = null;
            }
            this.sourceOfSQLViewAssociations = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRModelElement.staticGetMetaClass(), 75, "Classifier", true);
            new MIRMetaAttribute(metaClass, 503, "LineageOptions", "java.lang.Integer", null, new Integer(0));
            new MIRMetaLink(metaClass, 67, "AssociatedJoinRole", false, 0, 93, 152);
            new MIRMetaLink(metaClass, 543, "ClassifierMap", true, 3, 76, 544);
            new MIRMetaLink(metaClass, 634, "ConnectionDataPackage", true, 1, 356, 633);
            new MIRMetaLink(metaClass, 546, "ControlOfClassifierMap", false, 1, 76, 545);
            new MIRMetaLink(metaClass, 64, "DestinationOfClassifierMap", false, 1, 76, 71);
            new MIRMetaLink(metaClass, 65, "Feature", false, 3, 77, 115);
            new MIRMetaLink(metaClass, 1104, "LeftOfJoinRelationship", false, 3, 346, 1107);
            new MIRMetaLink(metaClass, 372, "Report", true, 2, 119, 371);
            new MIRMetaLink(metaClass, 1105, "RightOfJoinRelationship", false, 0, 346, 1108);
            new MIRMetaLink(metaClass, 63, "SourceOfClassifierMap", false, 1, 76, 70);
            new MIRMetaLink(metaClass, 66, "SourceOfSQLViewAssociation", false, 0, 27, 227);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRClassifier.staticGetMetaClass();
    }

    public MIRClassifierMap getDestinationOfClassifierMap() {
        return this.getDestinationOfClassifierMap(null);
    }

    public void setLineageOption(int n) {
        this.aLineageOptions |= n;
    }

    public void unsetLineageOption(int n) {
        this.aLineageOptions &= ~n;
    }

    public boolean hasLineageOption(int n) {
        return (this.aLineageOptions & n) != 0;
    }

    @Override
    protected void _rename(String string) {
        if (this.hasConnectionDataPackage != null) {
            this.hasConnectionDataPackage.classifiers.rename(this, string);
        }
        if (this.controlOfClassifierMaps != null) {
            for (MIRClassifierMap mIRClassifierMap : this.controlOfClassifierMaps) {
                mIRClassifierMap.controlClassifiers.rename(this, string);
            }
        }
        if (this.hasReport != null) {
            this.hasReport.classifiers.rename(this, string);
        }
        if (this.sourceOfClassifierMaps != null) {
            for (MIRClassifierMap mIRClassifierMap : this.sourceOfClassifierMaps) {
                mIRClassifierMap.sourceClassifiers.rename(this, string);
            }
        }
        super._rename(string);
    }
}

