/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRClass;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRType;
import MITI.sdk.MIRTypeValue;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;

public class MIRClassType
extends MIRType {
    protected transient MIRClass hasAssociatedClass = null;
    private static MIRMetaClass metaClass = MIRClassType.staticGetMetaClass();

    public MIRClassType() {
    }

    public MIRClassType(MIRClassType mIRClassType) {
        this.setFrom(mIRClassType);
    }

    @Override
    public Object clone() {
        return new MIRClassType(this);
    }

    @Override
    public short getElementType() {
        return 66;
    }

    @Override
    public String getDataType() {
        if (this.getNativeType().startsWith("Array")) {
            return "SQL_ARRAY";
        }
        if (this.getNativeType().startsWith("Object")) {
            return "SQL_REF";
        }
        return "undefined";
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public String getInitialValue() {
        return "";
    }

    @Override
    public String getLowerBound() {
        return "";
    }

    @Override
    public String getUpperBound() {
        return "";
    }

    @Override
    public boolean getUserDefined() {
        return true;
    }

    @Override
    public String getNativeDataType() {
        if (this.getNativeType().startsWith("Array") || this.getNativeType().startsWith("Object")) {
            return this.getName();
        }
        return this.hasAssociatedClass != null ? this.hasAssociatedClass.getName() : "";
    }

    @Override
    public boolean getUserDataType() {
        return false;
    }

    @Override
    public String getNativeLogicalDataType() {
        return "";
    }

    public final void addAssociatedClass(MIRClass mIRClass) {
        if (mIRClass == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ClassType", "AssociatedClass"));
        }
        if (mIRClass._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ClassType", "AssociatedClass"));
        }
        if (this.hasAssociatedClass != null) {
            if (this.hasAssociatedClass._equals(mIRClass)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ClassType", "AssociatedClass"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ClassType", "AssociatedClass"));
        }
        if (mIRClass.hasClassType != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Class", "ClassType"));
        }
        this.hasAssociatedClass = mIRClass;
        mIRClass.hasClassType = this;
    }

    public final MIRClass getAssociatedClass() {
        return this.hasAssociatedClass;
    }

    public final boolean removeAssociatedClass() {
        if (this.hasAssociatedClass != null) {
            this.hasAssociatedClass.hasClassType = null;
            this.hasAssociatedClass = null;
            return true;
        }
        return false;
    }

    @Override
    public SortedSet<MIRTypeValue> getTypeValues() {
        return MIRObjectCollections.emptySet();
    }

    @Override
    public int getTypeValueCount() {
        return 0;
    }

    @Override
    public boolean containsTypeValue(MIRTypeValue mIRTypeValue) {
        return false;
    }

    @Override
    public MIRTypeValue getTypeValue(String string) {
        return null;
    }

    @Override
    public Iterator<MIRTypeValue> getTypeValueIterator() {
        return MIRObjectCollections.emptySet().iterator();
    }

    @Override
    public List<MIRTypeValue> getTypeValueByPosition() {
        return MIRObjectCollections.emptyList();
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRType.staticGetMetaClass(), 66, "ClassType", false);
            new MIRMetaLink(metaClass, 62, "AssociatedClass", true, 0, 13, 51);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRClassType.staticGetMetaClass();
    }
}

