/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import java.util.HashMap;

public class MIRBaseTypeList {
    public static final String DATATYPE_UNDEFINED = "undefined";
    public static final String DATATYPE_NAME_UNDEFINED = "undefined";
    public static final String DATATYPE_BINARY = "SQL_BINARY";
    public static final String DATATYPE_NAME_BINARY = "binary";
    public static final String DATATYPE_CHAR = "SQL_CHAR";
    public static final String DATATYPE_NAME_CHAR = "char";
    public static final String DATATYPE_INTEGER = "SQL_INTEGER";
    public static final String DATATYPE_NAME_INTEGER = "int";
    public static final String DATATYPE_NUMERIC = "SQL_NUMERIC";
    public static final String DATATYPE_NAME_NUMERIC = "numeric";
    public static final String DATATYPE_DOUBLE = "SQL_DOUBLE";
    public static final String DATATYPE_NAME_DOUBLE = "double";
    public static final String DATATYPE_LONGVARBINARY = "SQL_LONGVARBINARY";
    public static final String DATATYPE_NAME_LONGVARBINARY = "longvarbinary";
    public static final String DATATYPE_LONGVARCHAR = "SQL_LONGVARCHAR";
    public static final String DATATYPE_NAME_LONGVARCHAR = "longvarchar";
    public static final String DATATYPE_REAL = "SQL_REAL";
    public static final String DATATYPE_NAME_REAL = "real";
    public static final String DATATYPE_SMALLINT = "SQL_SMALLINT";
    public static final String DATATYPE_NAME_SMALLINT = "smallint";
    public static final String DATATYPE_TINYINT = "SQL_TINYINT";
    public static final String DATATYPE_NAME_TINYINT = "tinyint";
    public static final String DATATYPE_VARBINARY = "SQL_VARBINARY";
    public static final String DATATYPE_NAME_VARBINARY = "varbinary";
    public static final String DATATYPE_VARCHAR = "SQL_VARCHAR";
    public static final String DATATYPE_NAME_VARCHAR = "varchar";
    public static final String DATATYPE_TIMESTAMP = "SQL_TIMESTAMP";
    public static final String DATATYPE_NAME_TIMESTAMP = "timestamp";
    public static final String DATATYPE_TIME = "SQL_TIME";
    public static final String DATATYPE_NAME_TIME = "time";
    public static final String DATATYPE_DATE = "SQL_DATE";
    public static final String DATATYPE_NAME_DATE = "date";
    public static final String DATATYPE_AUTOINCREMENT = "AUTOINCREMENT";
    public static final String DATATYPE_NAME_AUTOINCREMENT = "autoincrement";
    public static final String DATATYPE_BIGINT = "SQL_BIGINT";
    public static final String DATATYPE_NAME_BIGINT = "bigint";
    public static final String DATATYPE_BLOB = "SQL_BLOB";
    public static final String DATATYPE_NAME_BLOB = "blob";
    public static final String DATATYPE_BOOLEAN = "SQL_BOOLEAN";
    public static final String DATATYPE_NAME_BOOLEAN = "boolean";
    public static final String DATATYPE_CLOB = "SQL_CLOB";
    public static final String DATATYPE_NAME_CLOB = "clob";
    public static final String DATATYPE_NCHAR = "SQL_NCHAR";
    public static final String DATATYPE_NAME_NCHAR = "nchar";
    public static final String DATATYPE_NVARCHAR = "SQL_NVARCHAR";
    public static final String DATATYPE_NAME_NVARCHAR = "nvarchar";
    public static final String DATATYPE_NLONGVARCHAR = "SQL_NLONGVARCHAR";
    public static final String DATATYPE_NAME_NLONGVARCHAR = "nlongvarchar";
    public static final String DATATYPE_NCLOB = "SQL_NCLOB";
    public static final String DATATYPE_NAME_NCLOB = "nclob";
    public static final String DATATYPE_DATALINK = "SQL_DATALINK";
    public static final String DATATYPE_NAME_DATALINK = "datalink";
    public static final String DATATYPE_DECIMAL = "SQL_DECIMAL";
    public static final String DATATYPE_NAME_DECIMAL = "decimal";
    public static final String DATATYPE_FLOAT = "SQL_FLOAT";
    public static final String DATATYPE_NAME_FLOAT = "float";
    public static final String DATATYPE_INTERVAL_MONTH = "SQL_INTERVAL_MONTH";
    public static final String DATATYPE_NAME_INTERVAL_MONTH = "interval month";
    public static final String DATATYPE_INTERVAL_YEAR = "SQL_INTERVAL_YEAR";
    public static final String DATATYPE_NAME_INTERVAL_YEAR = "interval year";
    public static final String DATATYPE_INTERVAL_YEAR_TO_MONTH = "SQL_INTERVAL_YEAR_TO_MONTH";
    public static final String DATATYPE_NAME_INTERVAL_YEAR_TO_MONTH = "interval year to month";
    public static final String DATATYPE_INTERVAL_DAY = "SQL_INTERVAL_DAY";
    public static final String DATATYPE_NAME_INTERVAL_DAY = "interval day";
    public static final String DATATYPE_INTERVAL_HOUR = "SQL_INTERVAL_HOUR";
    public static final String DATATYPE_NAME_INTERVAL_HOUR = "interval hour";
    public static final String DATATYPE_INTERVAL_MINUTE = "SQL_INTERVAL_MINUTE";
    public static final String DATATYPE_NAME_INTERVAL_MINUTE = "interval minute";
    public static final String DATATYPE_INTERVAL_SECOND = "SQL_INTERVAL_SECOND";
    public static final String DATATYPE_NAME_INTERVAL_SECOND = "interval second";
    public static final String DATATYPE_INTERVAL_DAY_TO_HOUR = "SQL_INTERVAL_DAY_TO_HOUR";
    public static final String DATATYPE_NAME_INTERVAL_DAY_TO_HOUR = "interval day to hour";
    public static final String DATATYPE_INTERVAL_DAY_TO_MINUTE = "SQL_INTERVAL_DAY_TO_MINUTE";
    public static final String DATATYPE_NAME_INTERVAL_DAY_TO_MINUTE = "interval day to minute";
    public static final String DATATYPE_INTERVAL_DAY_TO_SECOND = "SQL_INTERVAL_DAY_TO_SECOND";
    public static final String DATATYPE_NAME_INTERVAL_DAY_TO_SECOND = "interval day to second";
    public static final String DATATYPE_INTERVAL_HOUR_TO_MINUTE = "SQL_INTERVAL_HOUR_TO_MINUTE";
    public static final String DATATYPE_NAME_INTERVAL_HOUR_TO_MINUTE = "interval hour to minute";
    public static final String DATATYPE_INTERVAL_HOUR_TO_SECOND = "SQL_INTERVAL_HOUR_TO_SECOND";
    public static final String DATATYPE_NAME_INTERVAL_HOUR_TO_SECOND = "interval hour to second";
    public static final String DATATYPE_INTERVAL_MINUTE_TO_SECOND = "SQL_INTERVAL_MINUTE_TO_SECOND";
    public static final String DATATYPE_NAME_INTERVAL_MINUTE_TO_SECOND = "interval minute to second";
    public static final String DATATYPE_REF = "SQL_REF";
    public static final String DATATYPE_NAME_REF = "ref";
    public static final String DATATYPE_TIME_WITH_TIME_ZONE = "SQL_TIME_WITH_TIME_ZONE";
    public static final String DATATYPE_NAME_TIME_WITH_TIME_ZONE = "time with time zone";
    public static final String DATATYPE_TIMESTAMP_WITH_TIME_ZONE = "SQL_TIMESTAMP_WITH_TIME_ZONE";
    public static final String DATATYPE_NAME_TIMESTAMP_WITH_TIME_ZONE = "timestamp with time zone";
    public static final String DATATYPE_ARRAY = "SQL_ARRAY";
    public static final String DATATYPE_NAME_ARRAY = "array";
    public static final String LOGICAL_UNDEFINED = "undefined";
    public static final String LOGICAL_BINARY = "binary";
    public static final String LOGICAL_BOOLEAN = "boolean";
    public static final String LOGICAL_CHAR = "char";
    public static final String LOGICAL_INTEGER = "int";
    public static final String LOGICAL_NUMBER = "number";
    public static final String LOGICAL_TEXT = "text";
    public static final String LOGICAL_DATETIME = "datetime";
    private static final HashMap<String, String> dataType2Logical = new HashMap(15);
    private static final HashMap<String, String> dataTypeDisplayNames = new HashMap(15);
    private static final HashMap<String, String> logical2DataType = new HashMap(8);

    public static String getLogicalName(String string) {
        String string2 = dataType2Logical.get(string);
        if (string2 == null) {
            return "undefined";
        }
        return string2;
    }

    public static String getDataTypeName(String string) {
        String string2 = logical2DataType.get(string);
        if (string2 == null) {
            return "undefined";
        }
        return string2;
    }

    public static String getDataTypeDisplayName(String string) {
        String string2 = dataTypeDisplayNames.get(string);
        if (string2 == null) {
            return "undefined";
        }
        return string2;
    }

    public static String[] getDataTypes() {
        return dataTypeDisplayNames.keySet().toArray(new String[dataTypeDisplayNames.size()]);
    }

    public static String[] getLogicalNames() {
        return logical2DataType.keySet().toArray(new String[logical2DataType.size()]);
    }

    public static boolean isMIRBinary(String string) {
        return string.equals(DATATYPE_BLOB) | string.equals(DATATYPE_BINARY) | string.equals(DATATYPE_VARBINARY) | string.equals(DATATYPE_LONGVARBINARY);
    }

    public static boolean isMIRDate(String string) {
        return string.equals(DATATYPE_TIME) | string.equals(DATATYPE_TIME_WITH_TIME_ZONE) | string.equals(DATATYPE_TIMESTAMP) | string.equals(DATATYPE_TIMESTAMP_WITH_TIME_ZONE) | string.equals(DATATYPE_DATE) | string.equals(DATATYPE_INTERVAL_MONTH) | string.equals(DATATYPE_INTERVAL_YEAR) | string.equals(DATATYPE_INTERVAL_YEAR_TO_MONTH) | string.equals(DATATYPE_INTERVAL_DAY) | string.equals(DATATYPE_INTERVAL_HOUR) | string.equals(DATATYPE_INTERVAL_MINUTE) | string.equals(DATATYPE_INTERVAL_SECOND) | string.equals(DATATYPE_INTERVAL_DAY_TO_HOUR) | string.equals(DATATYPE_INTERVAL_DAY_TO_MINUTE) | string.equals(DATATYPE_INTERVAL_DAY_TO_SECOND) | string.equals(DATATYPE_INTERVAL_HOUR_TO_MINUTE) | string.equals(DATATYPE_INTERVAL_HOUR_TO_SECOND) | string.equals(DATATYPE_INTERVAL_MINUTE_TO_SECOND);
    }

    public static boolean isMIRNumeric(String string) {
        return string.equals(DATATYPE_BOOLEAN) | string.equals(DATATYPE_TINYINT) | string.equals(DATATYPE_SMALLINT) | string.equals(DATATYPE_INTEGER) | string.equals(DATATYPE_AUTOINCREMENT) | string.equals(DATATYPE_BIGINT) | string.equals(DATATYPE_REAL) | string.equals(DATATYPE_FLOAT) | string.equals(DATATYPE_DECIMAL) | string.equals(DATATYPE_NUMERIC) | string.equals(DATATYPE_DOUBLE);
    }

    public static boolean isMIRString(String string) {
        return string.equals(DATATYPE_CHAR) | string.equals(DATATYPE_NCHAR) | string.equals(DATATYPE_VARCHAR) | string.equals(DATATYPE_NVARCHAR) | string.equals(DATATYPE_LONGVARCHAR) | string.equals(DATATYPE_NLONGVARCHAR) | string.equals(DATATYPE_CLOB) | string.equals(DATATYPE_NCLOB);
    }

    public static boolean isMIRUndefined(String string) {
        return string.equals("undefined");
    }

    public static int getMIRTypeCount() {
        return dataTypeDisplayNames.size();
    }

    public static boolean isMIRType(String string) {
        return dataTypeDisplayNames.containsKey(string);
    }

    static {
        dataType2Logical.put("undefined", "undefined");
        dataType2Logical.put(DATATYPE_BINARY, "binary");
        dataType2Logical.put(DATATYPE_CHAR, "char");
        dataType2Logical.put(DATATYPE_INTEGER, "int");
        dataType2Logical.put(DATATYPE_NUMERIC, LOGICAL_NUMBER);
        dataType2Logical.put(DATATYPE_DOUBLE, LOGICAL_NUMBER);
        dataType2Logical.put(DATATYPE_REAL, LOGICAL_NUMBER);
        dataType2Logical.put(DATATYPE_SMALLINT, "int");
        dataType2Logical.put(DATATYPE_TINYINT, "int");
        dataType2Logical.put(DATATYPE_VARBINARY, "binary");
        dataType2Logical.put(DATATYPE_VARCHAR, LOGICAL_TEXT);
        dataType2Logical.put(DATATYPE_LONGVARBINARY, "binary");
        dataType2Logical.put(DATATYPE_LONGVARCHAR, LOGICAL_TEXT);
        dataType2Logical.put(DATATYPE_TIMESTAMP, LOGICAL_DATETIME);
        dataType2Logical.put(DATATYPE_TIME, LOGICAL_DATETIME);
        dataType2Logical.put(DATATYPE_DATE, LOGICAL_DATETIME);
        dataType2Logical.put(DATATYPE_AUTOINCREMENT, "int");
        dataType2Logical.put(DATATYPE_ARRAY, "undefined");
        dataType2Logical.put(DATATYPE_BIGINT, "int");
        dataType2Logical.put(DATATYPE_BLOB, "binary");
        dataType2Logical.put(DATATYPE_BOOLEAN, "boolean");
        dataType2Logical.put(DATATYPE_CLOB, LOGICAL_TEXT);
        dataType2Logical.put(DATATYPE_NCHAR, "char");
        dataType2Logical.put(DATATYPE_NVARCHAR, LOGICAL_TEXT);
        dataType2Logical.put(DATATYPE_NLONGVARCHAR, LOGICAL_TEXT);
        dataType2Logical.put(DATATYPE_NCLOB, LOGICAL_TEXT);
        dataType2Logical.put(DATATYPE_DATALINK, LOGICAL_TEXT);
        dataType2Logical.put(DATATYPE_DECIMAL, LOGICAL_NUMBER);
        dataType2Logical.put(DATATYPE_FLOAT, LOGICAL_NUMBER);
        dataType2Logical.put(DATATYPE_INTERVAL_MONTH, LOGICAL_DATETIME);
        dataType2Logical.put(DATATYPE_INTERVAL_YEAR, LOGICAL_DATETIME);
        dataType2Logical.put(DATATYPE_INTERVAL_YEAR_TO_MONTH, LOGICAL_DATETIME);
        dataType2Logical.put(DATATYPE_INTERVAL_DAY, LOGICAL_DATETIME);
        dataType2Logical.put(DATATYPE_INTERVAL_HOUR, LOGICAL_DATETIME);
        dataType2Logical.put(DATATYPE_INTERVAL_MINUTE, LOGICAL_DATETIME);
        dataType2Logical.put(DATATYPE_INTERVAL_SECOND, LOGICAL_DATETIME);
        dataType2Logical.put(DATATYPE_INTERVAL_DAY_TO_HOUR, LOGICAL_DATETIME);
        dataType2Logical.put(DATATYPE_INTERVAL_DAY_TO_MINUTE, LOGICAL_DATETIME);
        dataType2Logical.put(DATATYPE_INTERVAL_DAY_TO_SECOND, LOGICAL_DATETIME);
        dataType2Logical.put(DATATYPE_INTERVAL_HOUR_TO_MINUTE, LOGICAL_DATETIME);
        dataType2Logical.put(DATATYPE_INTERVAL_HOUR_TO_SECOND, LOGICAL_DATETIME);
        dataType2Logical.put(DATATYPE_INTERVAL_MINUTE_TO_SECOND, LOGICAL_DATETIME);
        dataType2Logical.put(DATATYPE_REF, "undefined");
        dataType2Logical.put(DATATYPE_TIME_WITH_TIME_ZONE, LOGICAL_DATETIME);
        dataType2Logical.put(DATATYPE_TIMESTAMP_WITH_TIME_ZONE, LOGICAL_DATETIME);
        dataTypeDisplayNames.put("undefined", "undefined");
        dataTypeDisplayNames.put(DATATYPE_BINARY, "binary");
        dataTypeDisplayNames.put(DATATYPE_CHAR, "char");
        dataTypeDisplayNames.put(DATATYPE_INTEGER, "int");
        dataTypeDisplayNames.put(DATATYPE_NUMERIC, DATATYPE_NAME_NUMERIC);
        dataTypeDisplayNames.put(DATATYPE_DOUBLE, DATATYPE_NAME_DOUBLE);
        dataTypeDisplayNames.put(DATATYPE_REAL, DATATYPE_NAME_REAL);
        dataTypeDisplayNames.put(DATATYPE_SMALLINT, DATATYPE_NAME_SMALLINT);
        dataTypeDisplayNames.put(DATATYPE_TINYINT, DATATYPE_NAME_TINYINT);
        dataTypeDisplayNames.put(DATATYPE_VARBINARY, DATATYPE_NAME_VARBINARY);
        dataTypeDisplayNames.put(DATATYPE_VARCHAR, DATATYPE_NAME_VARCHAR);
        dataTypeDisplayNames.put(DATATYPE_LONGVARBINARY, DATATYPE_NAME_LONGVARBINARY);
        dataTypeDisplayNames.put(DATATYPE_LONGVARCHAR, DATATYPE_NAME_LONGVARCHAR);
        dataTypeDisplayNames.put(DATATYPE_TIMESTAMP, DATATYPE_NAME_TIMESTAMP);
        dataTypeDisplayNames.put(DATATYPE_TIME, DATATYPE_NAME_TIME);
        dataTypeDisplayNames.put(DATATYPE_DATE, DATATYPE_NAME_DATE);
        dataTypeDisplayNames.put(DATATYPE_AUTOINCREMENT, DATATYPE_NAME_AUTOINCREMENT);
        dataTypeDisplayNames.put(DATATYPE_ARRAY, DATATYPE_NAME_ARRAY);
        dataTypeDisplayNames.put(DATATYPE_BIGINT, DATATYPE_NAME_BIGINT);
        dataTypeDisplayNames.put(DATATYPE_BLOB, DATATYPE_NAME_BLOB);
        dataTypeDisplayNames.put(DATATYPE_BOOLEAN, "boolean");
        dataTypeDisplayNames.put(DATATYPE_CLOB, DATATYPE_NAME_CLOB);
        dataTypeDisplayNames.put(DATATYPE_NCHAR, DATATYPE_NAME_NCHAR);
        dataTypeDisplayNames.put(DATATYPE_NVARCHAR, DATATYPE_NAME_NVARCHAR);
        dataTypeDisplayNames.put(DATATYPE_NLONGVARCHAR, DATATYPE_NAME_NLONGVARCHAR);
        dataTypeDisplayNames.put(DATATYPE_NCLOB, DATATYPE_NAME_NCLOB);
        dataTypeDisplayNames.put(DATATYPE_DATALINK, DATATYPE_NAME_DATALINK);
        dataTypeDisplayNames.put(DATATYPE_DECIMAL, DATATYPE_NAME_DECIMAL);
        dataTypeDisplayNames.put(DATATYPE_FLOAT, DATATYPE_NAME_FLOAT);
        dataTypeDisplayNames.put(DATATYPE_INTERVAL_MONTH, DATATYPE_NAME_INTERVAL_MONTH);
        dataTypeDisplayNames.put(DATATYPE_INTERVAL_YEAR, DATATYPE_NAME_INTERVAL_YEAR);
        dataTypeDisplayNames.put(DATATYPE_INTERVAL_YEAR_TO_MONTH, DATATYPE_NAME_INTERVAL_YEAR_TO_MONTH);
        dataTypeDisplayNames.put(DATATYPE_INTERVAL_DAY, DATATYPE_NAME_INTERVAL_DAY);
        dataTypeDisplayNames.put(DATATYPE_INTERVAL_HOUR, DATATYPE_NAME_INTERVAL_HOUR);
        dataTypeDisplayNames.put(DATATYPE_INTERVAL_MINUTE, DATATYPE_NAME_INTERVAL_MINUTE);
        dataTypeDisplayNames.put(DATATYPE_INTERVAL_SECOND, DATATYPE_NAME_INTERVAL_SECOND);
        dataTypeDisplayNames.put(DATATYPE_INTERVAL_DAY_TO_HOUR, DATATYPE_NAME_INTERVAL_DAY_TO_HOUR);
        dataTypeDisplayNames.put(DATATYPE_INTERVAL_DAY_TO_MINUTE, DATATYPE_NAME_INTERVAL_DAY_TO_MINUTE);
        dataTypeDisplayNames.put(DATATYPE_INTERVAL_DAY_TO_SECOND, DATATYPE_NAME_INTERVAL_DAY_TO_SECOND);
        dataTypeDisplayNames.put(DATATYPE_INTERVAL_HOUR_TO_MINUTE, DATATYPE_NAME_INTERVAL_HOUR_TO_MINUTE);
        dataTypeDisplayNames.put(DATATYPE_INTERVAL_HOUR_TO_SECOND, DATATYPE_NAME_INTERVAL_HOUR_TO_SECOND);
        dataTypeDisplayNames.put(DATATYPE_INTERVAL_MINUTE_TO_SECOND, DATATYPE_NAME_INTERVAL_MINUTE_TO_SECOND);
        dataTypeDisplayNames.put(DATATYPE_REF, DATATYPE_NAME_REF);
        dataTypeDisplayNames.put(DATATYPE_TIME_WITH_TIME_ZONE, DATATYPE_NAME_TIME_WITH_TIME_ZONE);
        dataTypeDisplayNames.put(DATATYPE_TIMESTAMP_WITH_TIME_ZONE, DATATYPE_NAME_TIMESTAMP_WITH_TIME_ZONE);
        logical2DataType.put("undefined", "undefined");
        logical2DataType.put("char", DATATYPE_CHAR);
        logical2DataType.put(LOGICAL_DATETIME, DATATYPE_TIMESTAMP);
        logical2DataType.put("int", DATATYPE_INTEGER);
        logical2DataType.put(LOGICAL_NUMBER, DATATYPE_NUMERIC);
        logical2DataType.put("binary", DATATYPE_LONGVARBINARY);
        logical2DataType.put(LOGICAL_TEXT, DATATYPE_LONGVARCHAR);
        logical2DataType.put("boolean", DATATYPE_BOOLEAN);
    }
}

