/*
 * Decompiled with CFR 0.152.
 */
package com.sas.entities.persist;

import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DataTypeUtil;
import com.sas.entities.AttributeDescriptor;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeGroup;
import com.sas.entities.AttributeGroupInterface;
import com.sas.entities.AttributeSetException;
import com.sas.entities.AttributeTypeFactory;
import com.sas.entities.AttributeTypeInterface;
import com.sas.entities.Entity;
import com.sas.entities.RemoteEntityInterface;
import com.sas.entities.persist.ConfigurationXMLPersistenceUtility;
import com.sas.entities.persist.EnumerationItem;
import com.sas.entities.persist.ParsedConfigurationXMLObject;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.ColorDefinitionInterface;
import com.sas.prompts.definitions.DateDefinitionInterface;
import com.sas.prompts.definitions.DoubleDefinitionInterface;
import com.sas.prompts.definitions.IntegerDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.SelectableDefinitionInterface;
import com.sas.prompts.definitions.TextDefinitionInterface;
import com.sas.prompts.definitions.ValueProviderDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.storage.valueprovider.StaticValueProvider;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.storage.valueprovider.ValueType;
import com.sas.util.DateTypes;
import com.sas.util.LocalizableString;
import com.sas.util.ValueItem;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class PromptToEntityConverter {
    private static long unnamedAttributeIndex = 0L;

    private PromptToEntityConverter() {
    }

    public static AttributeGroupInterface convertPromptGroupToAttributeGroup(PromptGroupInterface promptGroup) {
        AttributeGroup attributeGroup = new AttributeGroup();
        PromptToEntityConverter.configureAttributeGroupProperties(promptGroup, (AttributeGroupInterface)attributeGroup);
        List promptsAndGroups = promptGroup.getPromptDefinitionsAndSubgroups();
        for (Object next : promptsAndGroups) {
            if (next instanceof PromptDefinitionInterface) {
                AttributeDescriptorInterface attribute = PromptToEntityConverter.newAttributeFromPromptDefinition((PromptDefinitionInterface)next);
                if (attribute == null) continue;
                attributeGroup.addAttributeDescriptor(attribute, -1);
                continue;
            }
            if (!(next instanceof PromptGroupInterface)) continue;
            AttributeGroupInterface subAttributeGroup = PromptToEntityConverter.convertPromptGroupToAttributeGroup((PromptGroupInterface)next);
            if (attributeGroup == null) continue;
            attributeGroup.addAttributeGroup(subAttributeGroup, -1);
        }
        return attributeGroup;
    }

    public static RemoteEntityInterface convertPromptGroupToEntity(PromptGroupInterface promptGroup) {
        return PromptToEntityConverter.convertPromptGroupToEntity((RemoteEntityInterface)new Entity(), promptGroup);
    }

    public static RemoteEntityInterface convertPromptGroupToEntity(RemoteEntityInterface entity, PromptGroupInterface promptGroup) {
        return PromptToEntityConverter.convertPromptValuesToEntity(entity, (PromptValuesInterface)new PromptValues(promptGroup));
    }

    public static RemoteEntityInterface convertPromptValuesToEntity(PromptValuesInterface promptValues) {
        return PromptToEntityConverter.convertPromptValuesToEntity((RemoteEntityInterface)new Entity(), promptValues);
    }

    public static RemoteEntityInterface convertPromptValuesToEntity(RemoteEntityInterface entity, PromptValuesInterface promptValues) {
        AttributeGroupInterface attributeGroup = PromptToEntityConverter.convertPromptGroupToAttributeGroup(promptValues.getPromptGroup());
        if (entity == null) {
            entity = new Entity();
        }
        try {
            entity.getAttributeGroup().addAttributeGroups(attributeGroup.getAttributeGroups());
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        AttributeDescriptorInterface[] rootAttrs = attributeGroup.getAttributeDescriptors(false);
        for (int i = 0; i < rootAttrs.length; ++i) {
            try {
                entity.getAttributeGroup().addAttributeDescriptor(rootAttrs[i], -1);
                continue;
            }
            catch (IllegalArgumentException iae) {
                iae.printStackTrace();
                continue;
            }
            catch (IndexOutOfBoundsException ioobe) {
                ioobe.printStackTrace();
                continue;
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
        }
        try {
            PromptToEntityConverter.configureAttributeGroupProperties(promptValues.getPromptGroup(), entity.getAttributeGroup());
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        AttributeDescriptorInterface[] descs = attributeGroup.getAttributeDescriptors(true);
        for (int i = 0; i < descs.length; ++i) {
            String name = descs[i].getName();
            PromptDefinitionInterface prompt = promptValues.getPromptDefinition(name, true);
            if (!promptValues.isPromptValueSet(prompt)) continue;
            try {
                Object value = promptValues.getPromptValue(prompt);
                value = PromptToEntityConverter.convertPromptValueToAttributeValue(prompt, descs[i], value);
                entity.setAttribute(name, value);
                continue;
            }
            catch (RemoteException remoteException) {
                continue;
            }
            catch (AttributeSetException attributeSetException) {
                continue;
            }
            catch (PromptValueNotFoundException promptValueNotFoundException) {
                // empty catch block
            }
        }
        return entity;
    }

    private static void configureAttributeGroupProperties(PromptGroupInterface promptGroup, AttributeGroupInterface attributeGroup) {
        String textForLocale;
        attributeGroup.setName(promptGroup.getPromptGroupLabel(Locale.US));
        attributeGroup.setExpert(false);
        LocalizableString labels = promptGroup.getPromptGroupDescriptions();
        List locales = labels.getLocales();
        for (Locale locale : locales) {
            textForLocale = labels.getText(locale);
            if (textForLocale == null) continue;
            attributeGroup.setDescription(locale, textForLocale);
        }
        labels = promptGroup.getPromptGroupLabels();
        locales = labels.getLocales();
        for (Locale locale : locales) {
            textForLocale = labels.getText(locale);
            if (textForLocale == null) continue;
            attributeGroup.setLabel(locale, textForLocale);
        }
        attributeGroup.setVisible(!promptGroup.isPromptGroupHidden());
    }

    private static void configureAttributeDescriptorProperties(PromptDefinitionInterface prompt, AttributeDescriptorInterface attribute, ParsedConfigurationXMLObject configXML) {
        String textForLocale;
        String name = prompt.getPromptName();
        if (name != null) {
            attribute.setName(prompt.getPromptName());
        } else {
            attribute.setName("unnamedAttribute" + unnamedAttributeIndex++);
        }
        attribute.setExpert(false);
        LocalizableString labels = prompt.getPromptDescriptions();
        List locales = labels.getLocales();
        for (Locale locale : locales) {
            textForLocale = labels.getText(locale);
            if (textForLocale == null) continue;
            attribute.setDescription(locale, textForLocale);
        }
        labels = prompt.getPromptLabels();
        locales = labels.getLocales();
        for (Locale locale : locales) {
            textForLocale = labels.getText(locale);
            if (textForLocale == null) continue;
            attribute.setLabel(locale, textForLocale);
        }
        attribute.setDefaultValueHasBeenSet(prompt.isDefaultValueSet());
        if (prompt.isDefaultValueSet()) {
            Object attributeDefault = PromptToEntityConverter.convertPromptValueToAttributeValue(prompt, attribute, prompt.getDefaultValue());
            attribute.setDefault(attributeDefault);
        }
        attribute.setRequired(prompt.isRequired());
        attribute.setModifiable(!prompt.isFixed());
        attribute.setVisible(!prompt.isHidden());
        PromptToEntityConverter.configureAttributeFromValueProvider(attribute, prompt, configXML);
        PromptToEntityConverter.configureAttributeFromDefinition(attribute, prompt, configXML);
        String configXMLString = ConfigurationXMLPersistenceUtility.writeConfigurationXML(configXML);
        attribute.setConfigurationXML(configXMLString);
    }

    private static AttributeDescriptorInterface newAttributeFromPromptDefinition(PromptDefinitionInterface prompt) {
        if (prompt instanceof TextDefinitionInterface) {
            if (PromptToEntityConverter.isBooleanPrompt(prompt, Locale.US)) {
                return PromptToEntityConverter.newBooleanAttributeFromTextDefinition(prompt);
            }
            return PromptToEntityConverter.newAttributeFromTextDefinition(prompt);
        }
        if (prompt instanceof IntegerDefinitionInterface) {
            return PromptToEntityConverter.newAttributeFromIntegerDefinition(prompt);
        }
        if (prompt instanceof DoubleDefinitionInterface) {
            return PromptToEntityConverter.newAttributeFromDoubleDefinition(prompt);
        }
        if (prompt instanceof DateDefinitionInterface) {
            return PromptToEntityConverter.newAttributeFromDateDefinition(prompt);
        }
        if (prompt instanceof ColorDefinitionInterface) {
            return PromptToEntityConverter.newAttributeFromColorDefinition(prompt);
        }
        return null;
    }

    private static AttributeDescriptorInterface newBooleanAttributeFromTextDefinition(PromptDefinitionInterface prompt) {
        TextDefinitionInterface definition = (TextDefinitionInterface)prompt;
        AttributeDescriptor attribute = new AttributeDescriptor();
        attribute.setType((AttributeTypeInterface)AttributeTypeFactory.BOOLEAN_ATTRIBUTE_TYPE);
        ParsedConfigurationXMLObject configXML = new ParsedConfigurationXMLObject();
        PromptToEntityConverter.configureAttributeDescriptorProperties(prompt, (AttributeDescriptorInterface)attribute, configXML);
        return attribute;
    }

    private static AttributeDescriptorInterface newAttributeFromTextDefinition(PromptDefinitionInterface prompt) {
        TextDefinitionInterface definition = (TextDefinitionInterface)prompt;
        AttributeDescriptor attribute = new AttributeDescriptor();
        if (definition.getSelectionType() == 300) {
            attribute.setType((AttributeTypeInterface)AttributeTypeFactory.STRING_ATTRIBUTE_TYPE);
        } else if (definition.getSelectionType() == 301 || definition.getSelectionType() == 302) {
            attribute.setType((AttributeTypeInterface)AttributeTypeFactory.STRING_ATTRIBUTE_TYPE);
        }
        ParsedConfigurationXMLObject configXML = new ParsedConfigurationXMLObject();
        HashMap<String, Integer> stringLengthOptions = new HashMap<String, Integer>(2);
        if (definition.getMinimumLength() > 0) {
            stringLengthOptions.put("min", new Integer(definition.getMinimumLength()));
        }
        if (definition.getMaximumLength() > 0) {
            stringLengthOptions.put("max", new Integer(definition.getMaximumLength()));
        }
        if (stringLengthOptions.size() > 0) {
            configXML.setStringLengthRange(stringLengthOptions);
        }
        PromptToEntityConverter.configureAttributeDescriptorProperties(prompt, (AttributeDescriptorInterface)attribute, configXML);
        return attribute;
    }

    private static AttributeDescriptorInterface newAttributeFromIntegerDefinition(PromptDefinitionInterface prompt) {
        IntegerDefinitionInterface definition = (IntegerDefinitionInterface)prompt;
        AttributeDescriptor attribute = new AttributeDescriptor();
        if (definition.getSelectionType() == 300) {
            attribute.setType((AttributeTypeInterface)AttributeTypeFactory.INT_ATTRIBUTE_TYPE);
        } else if (definition.getSelectionType() == 301 || definition.getSelectionType() == 302) {
            attribute.setType((AttributeTypeInterface)AttributeTypeFactory.INT_ATTRIBUTE_TYPE);
        }
        ParsedConfigurationXMLObject configXML = new ParsedConfigurationXMLObject();
        HashMap<String, Double> valueRangeOptions = new HashMap<String, Double>(2);
        if (definition.getMinimum() != Integer.MIN_VALUE) {
            valueRangeOptions.put("min", new Double(definition.getMinimum()));
        }
        if (definition.getMaximum() != Integer.MAX_VALUE) {
            valueRangeOptions.put("max", new Double(definition.getMaximum()));
        }
        if (valueRangeOptions.size() > 0) {
            configXML.setNumericRange(valueRangeOptions);
        }
        PromptToEntityConverter.configureAttributeDescriptorProperties(prompt, (AttributeDescriptorInterface)attribute, configXML);
        return attribute;
    }

    private static AttributeDescriptorInterface newAttributeFromDoubleDefinition(PromptDefinitionInterface prompt) {
        DoubleDefinitionInterface definition = (DoubleDefinitionInterface)prompt;
        AttributeDescriptor attribute = new AttributeDescriptor();
        if (definition.getSelectionType() == 300) {
            attribute.setType((AttributeTypeInterface)AttributeTypeFactory.DOUBLE_ATTRIBUTE_TYPE);
        } else if (definition.getSelectionType() == 301 || definition.getSelectionType() == 302) {
            attribute.setType((AttributeTypeInterface)AttributeTypeFactory.DOUBLE_ATTRIBUTE_TYPE);
        }
        ParsedConfigurationXMLObject configXML = new ParsedConfigurationXMLObject();
        HashMap<String, Double> valueRangeOptions = new HashMap<String, Double>(2);
        if (definition.getMinimum() != -2.147483648E9) {
            valueRangeOptions.put("min", new Double(definition.getMinimum()));
        }
        if (definition.getMaximum() != 2.147483647E9) {
            valueRangeOptions.put("max", new Double(definition.getMaximum()));
        }
        if (valueRangeOptions.size() > 0) {
            configXML.setNumericRange(valueRangeOptions);
        }
        PromptToEntityConverter.configureAttributeDescriptorProperties(prompt, (AttributeDescriptorInterface)attribute, configXML);
        return attribute;
    }

    private static AttributeDescriptorInterface newAttributeFromDateDefinition(PromptDefinitionInterface prompt) {
        DateDefinitionInterface definition = (DateDefinitionInterface)prompt;
        AttributeDescriptor attribute = new AttributeDescriptor();
        if (definition.getSelectionType() == 300) {
            if (definition.getDateType() == DateTypes.DATE) {
                attribute.setType((AttributeTypeInterface)AttributeTypeFactory.DATE_ATTRIBUTE_TYPE);
            } else if (definition.getDateType() == DateTypes.TIME) {
                attribute.setType((AttributeTypeInterface)AttributeTypeFactory.TIME_ATTRIBUTE_TYPE);
            } else if (definition.getDateType() == DateTypes.TIMESTAMP) {
                attribute.setType((AttributeTypeInterface)AttributeTypeFactory.TIMESTAMP_ATTRIBUTE_TYPE);
            }
        } else if (definition.getSelectionType() == 301 || definition.getSelectionType() == 302) {
            // empty if block
        }
        ParsedConfigurationXMLObject configXML = new ParsedConfigurationXMLObject();
        PromptToEntityConverter.configureAttributeDescriptorProperties(prompt, (AttributeDescriptorInterface)attribute, configXML);
        return attribute;
    }

    private static AttributeDescriptorInterface newAttributeFromColorDefinition(PromptDefinitionInterface prompt) {
        ColorDefinitionInterface definition = (ColorDefinitionInterface)prompt;
        AttributeDescriptor attribute = new AttributeDescriptor();
        attribute.setType((AttributeTypeInterface)AttributeTypeFactory.COLOR_STRING_ATTRIBUTE_TYPE);
        ParsedConfigurationXMLObject configXML = new ParsedConfigurationXMLObject();
        PromptToEntityConverter.configureAttributeDescriptorProperties(prompt, (AttributeDescriptorInterface)attribute, configXML);
        return attribute;
    }

    private static Object convertPromptValueToAttributeValue(PromptDefinitionInterface prompt, AttributeDescriptorInterface attribute, Object value) {
        if (attribute.getType().equals(AttributeTypeFactory.BOOLEAN_ATTRIBUTE_TYPE) && value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        value = prompt.getPromptDataType().coerceValue(value, Locale.US);
        return value;
    }

    private static void configureAttributeFromValueProvider(AttributeDescriptorInterface attribute, PromptDefinitionInterface prompt, ParsedConfigurationXMLObject configXML) {
        if (prompt instanceof ValueProviderDefinitionInterface) {
            ValueProviderInterface valueProvider;
            ValueProviderDefinitionInterface valueProviderPrompt = (ValueProviderDefinitionInterface)prompt;
            if (valueProviderPrompt.isAllowUserValues()) {
                HashMap<String, Boolean> options = configXML.getEnumerationOptions();
                if (options == null) {
                    options = new HashMap<String, Boolean>(1);
                }
                options.put("isOthersAllowed", new Boolean(valueProviderPrompt.isAllowUserValues()));
                configXML.setEnumerationOptions(options);
            }
            if ((valueProvider = valueProviderPrompt.getValueProvider()) instanceof StaticValueProvider) {
                ArrayList<EnumerationItem> items = new ArrayList<EnumerationItem>();
                StaticValueProvider svp = (StaticValueProvider)valueProvider;
                Collection locales = svp.getLocales();
                for (Locale locale : locales) {
                    try {
                        List values = (List)svp.getValues(locale, ValueType.LIST);
                        for (int i = 0; i < values.size(); ++i) {
                            ValueItem valueItem = (ValueItem)values.get(i);
                            EnumerationItem item = new EnumerationItem();
                            DataTypeInterface dataType = DataTypeUtil.getContainedDataType((DataTypeInterface)prompt.getPromptDataType());
                            item.setValue(dataType.getValueAsString(valueItem.getValue(), Locale.US));
                            item.setTextLabel(Locale.US, valueItem.getLabel());
                            items.add(item);
                        }
                    }
                    catch (ValueProviderException e) {
                        e.printStackTrace();
                    }
                }
                configXML.setEnumerationData(items);
            }
        }
    }

    private static boolean isBooleanPrompt(PromptDefinitionInterface prompt, Locale locale) {
        ValueProviderInterface valueProvider;
        if (prompt instanceof TextDefinitionInterface && (valueProvider = ((TextDefinitionInterface)prompt).getValueProvider()) instanceof StaticValueProvider) {
            try {
                List items;
                Object itemsObj = valueProvider.getValues(locale);
                if (itemsObj instanceof List && (items = (List)itemsObj).size() == 2) {
                    ValueItem item1 = (ValueItem)items.get(0);
                    ValueItem item2 = (ValueItem)items.get(1);
                    if (item1.getValue() != null && item1.getValue().equals("true") && item2.getValue() != null && item2.getValue().equals("false")) {
                        return true;
                    }
                }
            }
            catch (ValueProviderException valueProviderException) {
                // empty catch block
            }
        }
        return false;
    }

    private static void configureAttributeFromDefinition(AttributeDescriptorInterface attribute, PromptDefinitionInterface prompt, ParsedConfigurationXMLObject configXML) {
        if (prompt instanceof SelectableDefinitionInterface) {
            int minValueCount = 0;
            int maxValueCount = 1;
            SelectableDefinitionInterface selectablePrompt = (SelectableDefinitionInterface)prompt;
            if (selectablePrompt.isRequired()) {
                minValueCount = 1;
            }
            if (selectablePrompt.getMinimumValueCount() > 0) {
                minValueCount = selectablePrompt.getMinimumValueCount();
            }
            if (selectablePrompt.getMaximumValueCount() > 0) {
                maxValueCount = selectablePrompt.getMaximumValueCount();
            } else if (selectablePrompt.getMaximumValueCount() == -1) {
                maxValueCount = Integer.MAX_VALUE;
            }
            HashMap<String, Integer> selectionRange = new HashMap<String, Integer>(2);
            selectionRange.put("min", new Integer(minValueCount));
            selectionRange.put("max", new Integer(maxValueCount));
            configXML.setSelectionRange(selectionRange);
        }
    }
}

