/*
 * Decompiled with CFR 0.152.
 */
package com.sas.entities.persist;

import com.sas.codepolicy.SASScope;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeGroupInterface;
import com.sas.entities.AttributeTypeInterface;
import com.sas.entities.persist.DOMDoc;
import com.sas.util.Strings;
import com.sas.util.xmlpersist.XmlUtil;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

@SASScope(value="ALL")
public class PersistenceUtil {
    public static final String RB_KEY = "PersistenceUtil.";
    public static final String EMPTY_STRING = "$$emptyString$$";
    public static final String EMPTY_STRING_VALUE = "";
    public static char[] xmlSpecial = new char[]{'&', '\"', '<', '>', '\''};
    public static String[] xmlReplacements = new String[]{"&amp;", "&quot;", "&lt;", "&gt;", "&apos;"};
    public static final String VALUE = "Value";
    public static final String VALUE_LC = "value";
    public static final String UNDERSCORE = "_";
    public static final String TEXT = "Text";
    public static final String XML_LANG = "xml:lang";
    public static final String NAME = "name";
    public static final String VERSION = "version";
    public static String version_9_1 = "9.1.2";
    public static String version_9_1_SP2 = "9.1.3.2";
    public static String version_9_1_SP4 = "9.1.3.4";
    public static final String CONFIGURATION = "Configuration";

    public static void writeLocaleSensitiveElement(DOMDoc domDoc, Element entityAttribute, String attributeName, Map attributeMap, AttributeDescriptorInterface adi) {
        PersistenceUtil.writeLocaleSensitiveElement(domDoc, entityAttribute, attributeName, attributeMap, adi, Boolean.TRUE);
    }

    public static void writeLocaleSensitiveElement(Document domDoc, Element entityAttribute, String attributeName, Map attributeMap, AttributeDescriptorInterface adi, boolean escapeChars) {
        if (attributeMap != null && attributeMap.size() > 0) {
            Object attributeValue = null;
            Element value = domDoc.createElement(VALUE);
            entityAttribute.appendChild(value);
            Attr name = domDoc.createAttribute(NAME);
            value.setAttributeNode(name);
            name.setValue(attributeName);
            for (Locale locale : attributeMap.keySet()) {
                String localeValue = (String)attributeMap.get(locale);
                if (localeValue != null && localeValue.equals(EMPTY_STRING_VALUE)) {
                    localeValue = EMPTY_STRING;
                }
                Element textElement = domDoc.createElement(TEXT);
                value.appendChild(textElement);
                if (locale != null) {
                    Attr xmlLang = domDoc.createAttribute(XML_LANG);
                    textElement.setAttributeNode(xmlLang);
                    xmlLang.setValue(XmlUtil.localeToXml((Locale)locale));
                }
                Text textNode = null;
                if (localeValue == null) {
                    textNode = domDoc.createTextNode(localeValue);
                    textElement.appendChild(textNode);
                    continue;
                }
                textNode = escapeChars ? domDoc.createTextNode(PersistenceUtil.replaceStringsWithSpecialChars(localeValue)) : domDoc.createTextNode(localeValue);
                textElement.appendChild(textNode);
            }
        }
    }

    public static String replaceStringsWithSpecialChars(String inputString) {
        if (inputString == null) {
            return null;
        }
        return Strings.replace((String)inputString, (char[])xmlSpecial, (String[])xmlReplacements);
    }

    public static boolean isValidVersionNumber(String versionNumber) {
        return versionNumber.equals(version_9_1) || versionNumber.equals(version_9_1_SP2) || versionNumber.equals(version_9_1_SP4);
    }

    public static String getLatestVersionNumber() {
        return version_9_1_SP4;
    }

    public static String getLatestVersionNumber(String firstVersion, String secondVersion) {
        return PersistenceUtil.intVersion(firstVersion) > PersistenceUtil.intVersion(secondVersion) ? firstVersion : secondVersion;
    }

    private static int intVersion(String versionNumberString) {
        int i = 0;
        if (versionNumberString.equals(version_9_1)) {
            return i;
        }
        if (versionNumberString.equals(version_9_1_SP2)) {
            return i + 2;
        }
        if (versionNumberString.equals(version_9_1_SP4)) {
            return i + 4;
        }
        return i;
    }

    protected static Locale parseLocaleItem(String localeCode) {
        Locale locale;
        block11: {
            int tokenCount;
            StringTokenizer tokenizer;
            block14: {
                block13: {
                    block12: {
                        block10: {
                            locale = null;
                            if (localeCode.indexOf("-") > 0) {
                                locale = XmlUtil.xmlToLocale((String)localeCode);
                                return locale;
                            }
                            tokenizer = new StringTokenizer(localeCode, UNDERSCORE, true);
                            tokenCount = tokenizer.countTokens();
                            if (tokenCount != 1) break block10;
                            locale = new Locale(tokenizer.nextToken().trim());
                            break block11;
                        }
                        if (tokenCount != 2) break block12;
                        for (int i = 0; i < tokenCount; ++i) {
                            String theToken = tokenizer.nextToken().trim();
                            if (theToken.equals(UNDERSCORE)) continue;
                            locale = new Locale(EMPTY_STRING_VALUE, theToken);
                        }
                        break block11;
                    }
                    if (tokenCount != 3) break block13;
                    String langCode = null;
                    for (int i = 0; i < tokenCount; ++i) {
                        String theToken = tokenizer.nextToken().trim();
                        if (i == 0) {
                            langCode = theToken;
                        }
                        if (i != 2) continue;
                        locale = new Locale(langCode, theToken);
                    }
                    break block11;
                }
                if (tokenCount != 4) break block14;
                String parameter = null;
                int x = 0;
                for (int i = 0; i < tokenCount; ++i) {
                    String theToken = tokenizer.nextToken().trim();
                    if (i == 0) {
                        x = theToken.equals(UNDERSCORE) ? 1 : 0;
                    }
                    if (i == x) {
                        parameter = theToken;
                    }
                    if (i != 3) continue;
                    locale = x == 0 ? new Locale(parameter, EMPTY_STRING_VALUE, theToken) : new Locale(EMPTY_STRING_VALUE, parameter, theToken);
                }
                break block11;
            }
            if (tokenCount != 5) break block11;
            String langCode = null;
            String countryCode = null;
            for (int i = 0; i < tokenCount; ++i) {
                String theToken = tokenizer.nextToken().trim();
                if (i == 0) {
                    langCode = theToken;
                }
                if (i == 2) {
                    countryCode = theToken;
                }
                if (i != 4) continue;
                locale = new Locale(langCode, countryCode, theToken);
            }
        }
        return locale;
    }

    public static boolean isDefaultValueForAttributeGroupProperty(AttributeGroupInterface agi, String propertyName) {
        if (propertyName.equals("modifiable")) {
            return !agi.isModifiable();
        }
        if (propertyName.equals("visible")) {
            return !agi.isVisible();
        }
        return false;
    }

    public static boolean isDefaultValueForAttributeTypeProperty(AttributeTypeInterface ati, String propertyName) {
        if (propertyName.equals(NAME)) {
            return ati.getName() == null;
        }
        if (propertyName.equals("objectType")) {
            return ati.getObjectType() == null;
        }
        return false;
    }

    public static boolean isDefaultValueForAttributeDescriptorProperty(AttributeDescriptorInterface adi, String propertyName) {
        if (propertyName.equals("expert")) {
            return !adi.isExpert();
        }
        if (propertyName.equals("required")) {
            return !adi.isRequired();
        }
        if (propertyName.equals("property")) {
            return !adi.isProperty();
        }
        if (propertyName.equals("defaultValueHasBeenSet")) {
            return !adi.isDefaultValueHasBeenSet();
        }
        if (propertyName.equals("modifiable")) {
            return adi.isModifiable();
        }
        if (propertyName.equals("visible")) {
            return adi.isVisible();
        }
        return false;
    }
}

