/*
 * Decompiled with CFR 0.152.
 */
package com.sas.entities.persist;

import com.sas.MissingValues;
import com.sas.codepolicy.SASScope;
import com.sas.entities.AttributeDescriptor;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeGroup;
import com.sas.entities.AttributeGroupInterface;
import com.sas.entities.AttributeSetException;
import com.sas.entities.AttributeType;
import com.sas.entities.AttributeTypeInterface;
import com.sas.entities.AttributeTypeUtility;
import com.sas.entities.Entity;
import com.sas.entities.EntityInterface;
import com.sas.entities.persist.ConfigurationXMLPersistenceUtility;
import com.sas.entities.persist.DOMDoc;
import com.sas.entities.persist.ParsedConfigurationXMLObject;
import com.sas.entities.persist.PersistenceUtil;
import com.sas.entities.persist.RB;
import com.sas.util.Classes;
import com.sas.util.Strings;
import com.sas.util.transforms.MissingValuesToStringTransform;
import com.sas.util.transforms.StringToMissingValuesTransform;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@SASScope(value="ALL")
public class EntityPersistenceUtility {
    public static final String RB_KEY = "EntityPersistenceUtility.";
    static final char[] ENTITYREF = new char[]{'&', '<', '>', '\"', '\'', '\n'};
    static final String NULL_STRING = "$$nullValue$$";
    static final String EMPTY_STRING = "$$emptyString$$";
    private static char[] xmlSpecial = new char[]{'&', '\"', '<', '>', '\''};
    private static String[] xmlReplacements = new String[]{"&amp;", "&quot;", "&lt;", "&gt;", "&apos;"};
    public static final String ATTRIBUTE_DESCRIPTOR = "AttributeDescriptor";
    public static final String ATTRIBUTE_GROUP = "AttributeGroup";
    public static final String ENTITY = "Entity";
    public static final String EDITOR = "Editor";
    public static final String TYPE = "Type";
    public static final String CUSTOMIZER = "Customizer";
    public static final String DESCRIPTION = "description";
    public static final String LABEL = "label";
    public static final String SMALL_ICON_URL = "smallIconURL";
    public static final String LARGE_ICON_URL = "largeIconURL";
    public static final String CONFIGURATION_XML = "ConfigurationXML";
    public static final String SUPPLEMENTAL_PROPERTY = "SupplementalProperty";
    public static final String VALUE = "Value";
    public static final String UNDERSCORE = "_";
    private static final String VISIBLE = "visible";
    private static final String MODIFIABLE = "modifiable";
    private static final String EXPERT = "expert";
    private static final String ENTITY_KEY = "entityKey";
    private static final String REQUIRED = "required";
    private static final String DEFAULT_VALUE_SET = "attributeHasDefaultValueSet";
    private static final String DEFAULT_VALUE = "defaultValue";
    private static final String CURRENT_VALUE = "currentValue";
    private static final String CONTEXT = "context";
    private static final String SQLTYPE = "sqlType";
    private static final String CLASSNAME = "className";
    private static final String CLASSTYPE = "classType";
    private static final String PROPERTY = "property";
    private static final String DEFAULT_VALUES = "DefaultValues";
    private static final String CURRENT_VALUES = "CurrentValues";

    public static String writeXMLToString(EntityInterface ei) {
        return EntityPersistenceUtility.writeXMLToString(ei, false, true, null);
    }

    public static String writeXMLToString(EntityInterface ei, Map map) {
        return EntityPersistenceUtility.writeXMLToString(ei, false, true, map);
    }

    public static String writeXMLToString(EntityInterface ei, boolean writeCurrentValue) {
        return EntityPersistenceUtility.writeXMLToString(ei, writeCurrentValue, true, null);
    }

    public static String writeXMLToString(EntityInterface ei, boolean writeCurrentValue, Map map) {
        return EntityPersistenceUtility.writeXMLToString(ei, writeCurrentValue, true, map);
    }

    public static String writeXMLToString(EntityInterface ei, boolean writeCurrentValue, boolean includeHeaders) {
        return EntityPersistenceUtility.writeXMLToString(ei, writeCurrentValue, includeHeaders, null);
    }

    public static Element write(EntityInterface ei, Node parentNode, boolean writeCurrentValue, Map map) {
        if (parentNode == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullNode.ex.txt"));
        }
        String versionNumber = PersistenceUtil.version_9_1_SP4;
        Document domDoc = parentNode.getOwnerDocument();
        Element entity = domDoc.createElement(ENTITY);
        parentNode.appendChild(entity);
        Element entityElement = EntityPersistenceUtility.writeNodes(ei, entity, writeCurrentValue, map, versionNumber, false);
        return entity;
    }

    public static String writeXMLToString(EntityInterface ei, boolean writeCurrentValue, boolean includeHeaders, Map map) {
        Object xmlString = null;
        String versionNumber = null;
        versionNumber = map == null ? "2.0" : PersistenceUtil.version_9_1;
        DOMDoc domDoc = new DOMDoc();
        StringWriter stringWriter = new StringWriter();
        domDoc.newDocument(false);
        Element entity = domDoc.createElement(ENTITY);
        domDoc.appendChild(entity);
        EntityPersistenceUtility.writeNodes(ei, entity, writeCurrentValue, map, versionNumber, true);
        domDoc.writeDocument(stringWriter, true, includeHeaders);
        return stringWriter.toString();
    }

    protected static void writeLocaleSensitiveElement(DOMDoc domDoc, Element entityAttribute, String attributeName, Map attributeMap, AttributeDescriptorInterface adi) {
        if (attributeMap != null && attributeMap.size() > 0) {
            Object attributeValue = null;
            Element value = domDoc.createElement(VALUE);
            entityAttribute.appendChild(value);
            Attr name = domDoc.createAttribute("name");
            value.setAttributeNode(name);
            name.setValue(attributeName);
            for (Locale locale : attributeMap.keySet()) {
                Text textNode;
                String localeValue = (String)attributeMap.get(locale);
                if (localeValue != null && localeValue.equals("")) {
                    localeValue = EMPTY_STRING;
                }
                Element textElement = domDoc.createElement("Text");
                value.appendChild(textElement);
                if (locale != null) {
                    Attr xmlLang = domDoc.createAttribute("xml:lang");
                    textElement.setAttributeNode(xmlLang);
                    xmlLang.setValue(locale.toString());
                }
                if (localeValue == null) {
                    textNode = domDoc.createTextNode(localeValue);
                    textElement.appendChild(textNode);
                    continue;
                }
                textNode = domDoc.createTextNode(Strings.replace((String)localeValue, (char[])xmlSpecial, (String[])xmlReplacements));
                textElement.appendChild(textNode);
            }
        }
    }

    public static EntityInterface createEntityFromXML(String docString) {
        if (docString == null || docString.length() == 0) {
            return null;
        }
        Object version = null;
        DOMDoc doc = new DOMDoc();
        doc.loadDocument(new StringReader(docString), false);
        Element rootElement = doc.getDocumentElement();
        return EntityPersistenceUtility.readNodes(rootElement);
    }

    public static EntityInterface readNodes(Element rootElement) {
        String version = null;
        Entity entity = new Entity();
        AttributeGroup attributeGroup = (AttributeGroup)entity.getAttributeGroup();
        ArrayList attributeNames = new ArrayList();
        if (rootElement.getTagName().equals(ENTITY)) {
            NamedNodeMap rootAttributesMap = rootElement.getAttributes();
            if (rootAttributesMap.getLength() > 0) {
                entity.setEntityKey(rootAttributesMap.getNamedItem(ENTITY_KEY).getNodeValue());
                Node versionNode = rootAttributesMap.getNamedItem("version");
                if (versionNode != null) {
                    version = versionNode.getNodeValue();
                }
            }
            if (version.equals("1.0") || version.equals("2.0") || PersistenceUtil.isValidVersionNumber(version)) {
                NodeList nl = rootElement.getElementsByTagName(ATTRIBUTE_GROUP);
                int nodeLength = nl.getLength();
                for (int i = 0; i < nodeLength; ++i) {
                    Node groupElement = nl.item(i);
                    if (groupElement.hasAttributes()) {
                        Node visibleNode;
                        Node modifiableNode;
                        String groupName;
                        NamedNodeMap groupAttributesMap = groupElement.getAttributes();
                        Node nameNode = groupAttributesMap.getNamedItem("name");
                        if (nameNode != null && (groupName = nameNode.getNodeValue()) != null) {
                            attributeGroup.setName(nameNode.getNodeValue());
                        }
                        if ((modifiableNode = groupAttributesMap.getNamedItem(MODIFIABLE)) != null) {
                            attributeGroup.setModifiable(new Boolean(modifiableNode.getNodeValue()).booleanValue());
                        }
                        if ((visibleNode = groupAttributesMap.getNamedItem(VISIBLE)) != null) {
                            attributeGroup.setVisible(new Boolean(visibleNode.getNodeValue()).booleanValue());
                        }
                    }
                    NodeList adList = rootElement.getElementsByTagName(ATTRIBUTE_DESCRIPTOR);
                    int adListLength = adList.getLength();
                    for (int j = 0; j < adListLength; ++j) {
                        AttributeDescriptor ad = new AttributeDescriptor();
                        String attributeCurrentValue = null;
                        boolean hasCurrentValue = false;
                        String currentDefaultValue = null;
                        boolean haveNullDefaultValue = false;
                        ArrayList<Object> defaultValues = null;
                        ArrayList<Object> currentValues = null;
                        Node attributeElement = adList.item(j);
                        NamedNodeMap attributesMap = attributeElement.getAttributes();
                        int attributesMapLength = attributesMap.getLength();
                        Node attributeNode = null;
                        String attributeName = null;
                        for (int k = 0; k < attributesMapLength; ++k) {
                            attributeNode = attributesMap.item(k);
                            attributeName = attributeNode.getNodeName();
                            if (attributeName.equals("name")) {
                                ad.setName(attributeNode.getNodeValue());
                                continue;
                            }
                            if (attributeName.equals(DEFAULT_VALUE_SET)) {
                                ad.setDefaultValueHasBeenSet(new Boolean(attributeNode.getNodeValue()).booleanValue());
                                continue;
                            }
                            if (attributeName.equals(DEFAULT_VALUE)) {
                                if (!ad.isDefaultValueHasBeenSet()) continue;
                                String attributeNodeValue = attributeNode.getNodeValue();
                                if (attributeNodeValue.equals(NULL_STRING)) {
                                    haveNullDefaultValue = true;
                                    ad.setDefault(null);
                                    continue;
                                }
                                currentDefaultValue = attributeNodeValue;
                                continue;
                            }
                            if (attributeName.equals(CURRENT_VALUE)) {
                                hasCurrentValue = true;
                                attributeCurrentValue = attributeNode.getNodeValue();
                                continue;
                            }
                            if (attributeName.equals(EXPERT)) {
                                ad.setExpert(new Boolean(attributeNode.getNodeValue()).booleanValue());
                                continue;
                            }
                            if (attributeName.equals(MODIFIABLE)) {
                                ad.setModifiable(new Boolean(attributeNode.getNodeValue()).booleanValue());
                                continue;
                            }
                            if (attributeName.equals(PROPERTY)) {
                                ad.setProperty(new Boolean(attributeNode.getNodeValue()).booleanValue());
                                continue;
                            }
                            if (attributeName.equals(REQUIRED)) {
                                ad.setRequired(new Boolean(attributeNode.getNodeValue()).booleanValue());
                                continue;
                            }
                            if (attributeName.equals(VISIBLE)) {
                                ad.setVisible(new Boolean(attributeNode.getNodeValue()).booleanValue());
                                continue;
                            }
                            if (attributeName.equals(LABEL)) {
                                ad.setLabel(null, attributeNode.getNodeValue());
                                continue;
                            }
                            if (attributeName.equals(DESCRIPTION)) {
                                ad.setDescription(null, attributeNode.getNodeValue());
                                continue;
                            }
                            if (attributeName.equals(SMALL_ICON_URL)) {
                                ad.setSmallIconURL(null, attributeNode.getNodeValue());
                                continue;
                            }
                            if (!attributeName.equals(LARGE_ICON_URL)) continue;
                            ad.setLargeIconURL(null, attributeNode.getNodeValue());
                        }
                        NodeList remainingAttributesList = attributeElement.getChildNodes();
                        int remainingAttributesListLength = remainingAttributesList.getLength();
                        Node remainingNode = null;
                        String remainingNodeName = null;
                        for (int m = 0; m < remainingAttributesListLength; ++m) {
                            String nodeValue;
                            Node childElement;
                            NodeList childList;
                            Node nameNode;
                            Object typeName;
                            NamedNodeMap typeAttributesMap;
                            AttributeTypeInterface ati;
                            NodeList childList2;
                            Node valueElement;
                            NodeList valueList;
                            Node nameNode2;
                            Node contextNode;
                            String context;
                            remainingNode = remainingAttributesList.item(m);
                            remainingNodeName = remainingNode.getNodeName();
                            if (version.equals("1.0")) {
                                if (remainingNodeName.equals(LABEL)) {
                                    ad.setLabel(null, EntityPersistenceUtility.getValueForLocaleSensitiveItem(remainingNode));
                                } else if (remainingNodeName.equals(DESCRIPTION)) {
                                    ad.setDescription(null, EntityPersistenceUtility.getValueForLocaleSensitiveItem(remainingNode));
                                } else if (remainingNodeName.equals(SMALL_ICON_URL)) {
                                    ad.setSmallIconURL(null, EntityPersistenceUtility.getValueForLocaleSensitiveItem(remainingNode));
                                } else if (remainingNodeName.equals(LARGE_ICON_URL)) {
                                    ad.setLargeIconURL(null, EntityPersistenceUtility.getValueForLocaleSensitiveItem(remainingNode));
                                }
                            } else if ((version.equals("2.0") || PersistenceUtil.isValidVersionNumber(version)) && remainingNodeName.equals(VALUE)) {
                                String attributeValue = null;
                                if (remainingNode.hasAttributes()) {
                                    NamedNodeMap nodeMap = remainingNode.getAttributes();
                                    attributeValue = nodeMap.getNamedItem("name").getNodeValue();
                                    EntityPersistenceUtility.createLocaleSensitiveProperties(remainingNode, attributeValue, (AttributeDescriptorInterface)ad);
                                } else {
                                    throw new IllegalStateException(RB.getStringResource(RB_KEY, "missingNameAttr.ex.txt"));
                                }
                            }
                            if (remainingNodeName.equals(EDITOR)) {
                                Node classNameNode;
                                if (!remainingNode.hasAttributes()) continue;
                                NamedNodeMap editorAttributesMap = remainingNode.getAttributes();
                                context = null;
                                contextNode = editorAttributesMap.getNamedItem(CONTEXT);
                                if (contextNode != null) {
                                    context = contextNode.getNodeValue();
                                }
                                if ((classNameNode = editorAttributesMap.getNamedItem(CLASSNAME)) == null) continue;
                                ad.setEditor(context, classNameNode.getNodeValue());
                                continue;
                            }
                            if (remainingNodeName.equals(CUSTOMIZER)) {
                                Node classNameNode;
                                if (!remainingNode.hasAttributes()) continue;
                                NamedNodeMap customizerAttributesMap = remainingNode.getAttributes();
                                context = null;
                                contextNode = customizerAttributesMap.getNamedItem(CONTEXT);
                                if (contextNode != null) {
                                    context = contextNode.getNodeValue();
                                }
                                if ((classNameNode = customizerAttributesMap.getNamedItem(CLASSNAME)) == null) continue;
                                ad.setCustomizer(context, classNameNode.getNodeValue());
                                continue;
                            }
                            if (remainingNodeName.equals(TYPE)) {
                                Node sqlTypeNode;
                                if (!remainingNode.hasAttributes()) continue;
                                NamedNodeMap typeAttributesMap2 = remainingNode.getAttributes();
                                String typeName2 = null;
                                nameNode2 = typeAttributesMap2.getNamedItem("name");
                                if (nameNode2 != null) {
                                    typeName2 = nameNode2.getNodeValue();
                                }
                                if ((sqlTypeNode = typeAttributesMap2.getNamedItem(SQLTYPE)) == null) continue;
                                int sqlType = new Integer(sqlTypeNode.getNodeValue());
                                AttributeType at = new AttributeType(typeName2, sqlType);
                                ad.setType((AttributeTypeInterface)at);
                                continue;
                            }
                            if (remainingNodeName.equals(SUPPLEMENTAL_PROPERTY)) {
                                NodeList valueList2;
                                if (!remainingNode.hasAttributes()) continue;
                                NamedNodeMap supPropertyAttributesMap = remainingNode.getAttributes();
                                String name = null;
                                nameNode2 = supPropertyAttributesMap.getNamedItem("name");
                                if (nameNode2 != null) {
                                    name = nameNode2.getNodeValue();
                                }
                                String classType = null;
                                Node classTypeNode = supPropertyAttributesMap.getNamedItem(CLASSTYPE);
                                if (classTypeNode != null) {
                                    classType = classTypeNode.getNodeValue();
                                }
                                String attributeValue = null;
                                if (remainingNode.hasChildNodes() && (valueList2 = remainingNode.getChildNodes()).getLength() > 0) {
                                    Node valueElement2 = valueList2.item(0);
                                    if (valueElement2.hasChildNodes()) {
                                        NodeList childList3 = valueElement2.getChildNodes();
                                        Node childElement2 = childList3.item(0);
                                        attributeValue = childElement2.getNodeValue();
                                    } else {
                                        attributeValue = "";
                                    }
                                }
                                if (classType != null) {
                                    Class[] stringArgsClass = new Class[]{String.class};
                                    try {
                                        Class c = Classes.loadClass((String)classType, null, null);
                                        Constructor stringArgsConstructor = c.getConstructor(stringArgsClass);
                                        Object[] stringArgs = new Object[]{attributeValue};
                                        Object o = stringArgsConstructor.newInstance(stringArgs);
                                        ad.setSupplementalProperty(name, o);
                                    }
                                    catch (Exception c) {}
                                    continue;
                                }
                                ad.setSupplementalProperty(name, null);
                                continue;
                            }
                            if (remainingNodeName.equals(CURRENT_VALUE)) {
                                if (!remainingNode.hasChildNodes() || (valueList = remainingNode.getChildNodes()).getLength() <= 0 || !(valueElement = valueList.item(0)).hasChildNodes()) continue;
                                childList2 = valueElement.getChildNodes();
                                Node childElement3 = childList2.item(0);
                                hasCurrentValue = true;
                                attributeCurrentValue = childElement3.getNodeValue();
                                continue;
                            }
                            if (remainingNodeName.equals(DEFAULT_VALUE)) {
                                if (!remainingNode.hasChildNodes() || (valueList = remainingNode.getChildNodes()).getLength() <= 0 || !(valueElement = valueList.item(0)).hasChildNodes()) continue;
                                childList2 = valueElement.getChildNodes();
                                Node childElement4 = childList2.item(0);
                                currentDefaultValue = childElement4.getNodeValue();
                                continue;
                            }
                            if (remainingNodeName.equals(DEFAULT_VALUES)) {
                                NodeList defaultValueList;
                                int listLength;
                                if (!remainingNode.hasChildNodes() || (listLength = (defaultValueList = remainingNode.getChildNodes()).getLength()) <= 0) continue;
                                defaultValues = new ArrayList<Object>();
                                ati = ad.getType();
                                for (int p = 0; p < listLength; ++p) {
                                    Node valueElement3 = defaultValueList.item(p);
                                    if (valueElement3.hasAttributes()) {
                                        typeAttributesMap = valueElement3.getAttributes();
                                        typeName = null;
                                        nameNode = typeAttributesMap.getNamedItem("value");
                                        if (nameNode == null) continue;
                                        String nodeValue2 = nameNode.getNodeValue();
                                        if (ati != null) {
                                            int sqlType = ati.getSQLType();
                                            if (sqlType == 8 || sqlType == 6) {
                                                Object o = StringToMissingValuesTransform.defaultInstance.transform((Object)nodeValue2);
                                                defaultValues.add(o);
                                                continue;
                                            }
                                            if (sqlType == 92) {
                                                long timeValue = new Long(nodeValue2);
                                                defaultValues.add(new Time(new Long(nodeValue2)));
                                                continue;
                                            }
                                            if (sqlType == 93) {
                                                defaultValues.add(new Timestamp(new Long(nodeValue2)));
                                                continue;
                                            }
                                            if (nodeValue2.equals(NULL_STRING)) {
                                                defaultValues.add(null);
                                                continue;
                                            }
                                            defaultValues.add(nodeValue2);
                                            continue;
                                        }
                                        defaultValues.add(nodeValue2);
                                        continue;
                                    }
                                    if (!valueElement3.hasChildNodes()) continue;
                                    childList = valueElement3.getChildNodes();
                                    childElement = childList.item(0);
                                    nodeValue = childElement.getNodeValue();
                                    if (ati != null) {
                                        int sqlType = ati.getSQLType();
                                        if (sqlType == 8 || sqlType == 6) {
                                            Object o = StringToMissingValuesTransform.defaultInstance.transform((Object)nodeValue);
                                            defaultValues.add(o);
                                            continue;
                                        }
                                        defaultValues.add(nodeValue);
                                        continue;
                                    }
                                    defaultValues.add(nodeValue);
                                }
                                continue;
                            }
                            if (remainingNodeName.equals(CURRENT_VALUES)) {
                                NodeList currentValueList;
                                int listLength;
                                if (!remainingNode.hasChildNodes() || (listLength = (currentValueList = remainingNode.getChildNodes()).getLength()) <= 0) continue;
                                currentValues = new ArrayList<Object>();
                                ati = ad.getType();
                                for (int q = 0; q < listLength; ++q) {
                                    Node valueElement4 = currentValueList.item(q);
                                    if (valueElement4.hasAttributes()) {
                                        typeAttributesMap = valueElement4.getAttributes();
                                        typeName = null;
                                        nameNode = typeAttributesMap.getNamedItem("value");
                                        if (nameNode == null) continue;
                                        String nodeValue3 = nameNode.getNodeValue();
                                        if (ati != null) {
                                            int sqlType = ati.getSQLType();
                                            if (sqlType == 8 || sqlType == 6) {
                                                Object o = StringToMissingValuesTransform.defaultInstance.transform((Object)nodeValue3);
                                                currentValues.add(o);
                                                continue;
                                            }
                                            if (sqlType == 92) {
                                                long timeValue = new Long(nodeValue3);
                                                currentValues.add(new Time(new Long(nodeValue3)));
                                                continue;
                                            }
                                            if (sqlType == 93) {
                                                currentValues.add(new Timestamp(new Long(nodeValue3)));
                                                continue;
                                            }
                                            if (nodeValue3.equals(NULL_STRING)) {
                                                currentValues.add(null);
                                                continue;
                                            }
                                            currentValues.add(nodeValue3);
                                            continue;
                                        }
                                        currentValues.add(nodeValue3);
                                        continue;
                                    }
                                    if (!valueElement4.hasChildNodes()) continue;
                                    childList = valueElement4.getChildNodes();
                                    childElement = childList.item(0);
                                    nodeValue = childElement.getNodeValue();
                                    if (ati != null) {
                                        int sqlType = ati.getSQLType();
                                        if (sqlType == 8 || sqlType == 6) {
                                            Object o = StringToMissingValuesTransform.defaultInstance.transform((Object)nodeValue);
                                            currentValues.add(o);
                                            continue;
                                        }
                                        currentValues.add(nodeValue);
                                        continue;
                                    }
                                    currentValues.add(nodeValue);
                                }
                                hasCurrentValue = true;
                                continue;
                            }
                            if (remainingNodeName.equals(CONFIGURATION_XML)) {
                                NodeList childList4;
                                if (!remainingNode.hasChildNodes() || (childList4 = remainingNode.getChildNodes()).getLength() <= 0) continue;
                                Node childElement5 = childList4.item(0);
                                ad.setConfigurationXML(childElement5.getNodeValue());
                                continue;
                            }
                            if (!remainingNodeName.equals("Configuration")) continue;
                            Element configElement = (Element)remainingNode;
                            ParsedConfigurationXMLObject parsedObject = ConfigurationXMLPersistenceUtility.createParsedConfigurationXMLObjectFromNode(configElement, null);
                            ad.setConfigurationXML(ConfigurationXMLPersistenceUtility.writeConfigurationXML(parsedObject));
                        }
                        if (ad.isDefaultValueHasBeenSet()) {
                            if (defaultValues != null) {
                                ad.setDefault(defaultValues);
                            } else {
                                AttributeTypeInterface ati = ad.getType();
                                int sqlType = ati.getSQLType();
                                if (ati != null) {
                                    if (sqlType == 8 || sqlType == 6) {
                                        ad.setDefault(StringToMissingValuesTransform.defaultInstance.transform((Object)currentDefaultValue));
                                    } else if (sqlType == 92) {
                                        long timeValue = new Long(currentDefaultValue);
                                        ad.setDefault((Object)new Time(new Long(currentDefaultValue)));
                                    } else if (sqlType == 93) {
                                        ad.setDefault((Object)new Timestamp(new Long(currentDefaultValue)));
                                    } else {
                                        ad.setDefault((Object)currentDefaultValue);
                                    }
                                } else {
                                    ad.setDefault((Object)currentDefaultValue);
                                }
                            }
                        }
                        attributeGroup.addAttributeDescriptor((AttributeDescriptorInterface)ad, -1);
                        if (!hasCurrentValue) continue;
                        try {
                            if (attributeCurrentValue != null && attributeCurrentValue.equals(NULL_STRING)) {
                                entity.setAttribute(ad.getName(), null);
                                continue;
                            }
                            AttributeTypeInterface ati = ad.getType();
                            int sqlType = ati.getSQLType();
                            if (ati == null || ati.getSQLType() == 0) {
                                throw new IllegalArgumentException(MessageFormat.format(RB.getStringResource(RB_KEY, "nullAttributeType.ex.txt"), attributeCurrentValue));
                            }
                            if (currentValues != null) {
                                entity.setAttribute(ad.getName(), currentValues);
                                continue;
                            }
                            if (ati.getSQLType() == 8 || sqlType == 6) {
                                Object o = StringToMissingValuesTransform.defaultInstance.transform((Object)attributeCurrentValue);
                                entity.setAttribute(ad.getName(), AttributeTypeUtility.transformAttributeValue((Object)o, (AttributeDescriptorInterface)ad));
                                continue;
                            }
                            if (sqlType == 92) {
                                entity.setAttribute(ad.getName(), (Object)new Time(new Long(attributeCurrentValue)));
                                continue;
                            }
                            if (sqlType == 93) {
                                entity.setAttribute(ad.getName(), (Object)new Timestamp(new Long(attributeCurrentValue)));
                                continue;
                            }
                            entity.setAttribute(ad.getName(), (Object)attributeCurrentValue);
                            continue;
                        }
                        catch (AttributeSetException attributeSetException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return entity;
    }

    public static EntityInterface read(Element rootElement) {
        String version = null;
        Entity entity = new Entity();
        AttributeGroup attributeGroup = (AttributeGroup)entity.getAttributeGroup();
        ArrayList attributeNames = new ArrayList();
        if (rootElement.getTagName().equals(ENTITY)) {
            NamedNodeMap rootAttributesMap = rootElement.getAttributes();
            if (rootAttributesMap.getLength() > 0) {
                entity.setEntityKey(rootAttributesMap.getNamedItem(ENTITY_KEY).getNodeValue());
                Node versionNode = rootAttributesMap.getNamedItem("version");
                if (versionNode != null) {
                    version = versionNode.getNodeValue();
                }
            }
            if (version.equals("1.0") || version.equals("2.0") || PersistenceUtil.isValidVersionNumber(version)) {
                NodeList nl = rootElement.getElementsByTagName(ATTRIBUTE_GROUP);
                int nodeLength = nl.getLength();
                for (int i = 0; i < nodeLength; ++i) {
                    Node groupElement = nl.item(i);
                    if (groupElement.hasAttributes()) {
                        Node visibleNode;
                        Node modifiableNode;
                        String groupName;
                        NamedNodeMap groupAttributesMap = groupElement.getAttributes();
                        Node nameNode = groupAttributesMap.getNamedItem("name");
                        if (nameNode != null && (groupName = nameNode.getNodeValue()) != null) {
                            attributeGroup.setName(nameNode.getNodeValue());
                        }
                        if ((modifiableNode = groupAttributesMap.getNamedItem(MODIFIABLE)) != null) {
                            attributeGroup.setModifiable(new Boolean(modifiableNode.getNodeValue()).booleanValue());
                        }
                        if ((visibleNode = groupAttributesMap.getNamedItem(VISIBLE)) != null) {
                            attributeGroup.setVisible(new Boolean(visibleNode.getNodeValue()).booleanValue());
                        }
                    }
                    NodeList adList = rootElement.getElementsByTagName(ATTRIBUTE_DESCRIPTOR);
                    int adListLength = adList.getLength();
                    for (int j = 0; j < adListLength; ++j) {
                        AttributeDescriptor ad = new AttributeDescriptor();
                        String attributeCurrentValue = null;
                        boolean hasCurrentValue = false;
                        String currentDefaultValue = null;
                        boolean haveNullDefaultValue = false;
                        ArrayList<Object> defaultValues = null;
                        ArrayList<Object> currentValues = null;
                        Node attributeElement = adList.item(j);
                        NamedNodeMap attributesMap = attributeElement.getAttributes();
                        int attributesMapLength = attributesMap.getLength();
                        Node attributeNode = null;
                        String attributeName = null;
                        for (int k = 0; k < attributesMapLength; ++k) {
                            attributeNode = attributesMap.item(k);
                            attributeName = attributeNode.getNodeName();
                            if (attributeName.equals("name")) {
                                ad.setName(attributeNode.getNodeValue());
                                continue;
                            }
                            if (attributeName.equals(DEFAULT_VALUE_SET)) {
                                ad.setDefaultValueHasBeenSet(new Boolean(attributeNode.getNodeValue()).booleanValue());
                                continue;
                            }
                            if (attributeName.equals(DEFAULT_VALUE)) {
                                if (!ad.isDefaultValueHasBeenSet()) continue;
                                String attributeNodeValue = attributeNode.getNodeValue();
                                if (attributeNodeValue.equals(NULL_STRING)) {
                                    haveNullDefaultValue = true;
                                    ad.setDefault(null);
                                    continue;
                                }
                                currentDefaultValue = attributeNodeValue;
                                continue;
                            }
                            if (attributeName.equals(CURRENT_VALUE)) {
                                hasCurrentValue = true;
                                attributeCurrentValue = attributeNode.getNodeValue();
                                continue;
                            }
                            if (attributeName.equals(EXPERT)) {
                                ad.setExpert(new Boolean(attributeNode.getNodeValue()).booleanValue());
                                continue;
                            }
                            if (attributeName.equals(MODIFIABLE)) {
                                ad.setModifiable(new Boolean(attributeNode.getNodeValue()).booleanValue());
                                continue;
                            }
                            if (attributeName.equals(PROPERTY)) {
                                ad.setProperty(new Boolean(attributeNode.getNodeValue()).booleanValue());
                                continue;
                            }
                            if (attributeName.equals(REQUIRED)) {
                                ad.setRequired(new Boolean(attributeNode.getNodeValue()).booleanValue());
                                continue;
                            }
                            if (attributeName.equals(VISIBLE)) {
                                ad.setVisible(new Boolean(attributeNode.getNodeValue()).booleanValue());
                                continue;
                            }
                            if (attributeName.equals(LABEL)) {
                                ad.setLabel(null, attributeNode.getNodeValue());
                                continue;
                            }
                            if (attributeName.equals(DESCRIPTION)) {
                                ad.setDescription(null, attributeNode.getNodeValue());
                                continue;
                            }
                            if (attributeName.equals(SMALL_ICON_URL)) {
                                ad.setSmallIconURL(null, attributeNode.getNodeValue());
                                continue;
                            }
                            if (!attributeName.equals(LARGE_ICON_URL)) continue;
                            ad.setLargeIconURL(null, attributeNode.getNodeValue());
                        }
                        NodeList remainingAttributesList = attributeElement.getChildNodes();
                        int remainingAttributesListLength = remainingAttributesList.getLength();
                        Node remainingNode = null;
                        String remainingNodeName = null;
                        for (int m = 0; m < remainingAttributesListLength; ++m) {
                            String nodeValue;
                            Node childElement;
                            NodeList childList;
                            Node nameNode;
                            Object typeName;
                            NamedNodeMap typeAttributesMap;
                            AttributeTypeInterface ati;
                            NodeList childList2;
                            Node valueElement;
                            NodeList valueList;
                            Node nameNode2;
                            Node contextNode;
                            String context;
                            remainingNode = remainingAttributesList.item(m);
                            remainingNodeName = remainingNode.getNodeName();
                            if (version.equals("1.0")) {
                                if (remainingNodeName.equals(LABEL)) {
                                    ad.setLabel(null, EntityPersistenceUtility.getValueForLocaleSensitiveItem(remainingNode));
                                } else if (remainingNodeName.equals(DESCRIPTION)) {
                                    ad.setDescription(null, EntityPersistenceUtility.getValueForLocaleSensitiveItem(remainingNode));
                                } else if (remainingNodeName.equals(SMALL_ICON_URL)) {
                                    ad.setSmallIconURL(null, EntityPersistenceUtility.getValueForLocaleSensitiveItem(remainingNode));
                                } else if (remainingNodeName.equals(LARGE_ICON_URL)) {
                                    ad.setLargeIconURL(null, EntityPersistenceUtility.getValueForLocaleSensitiveItem(remainingNode));
                                }
                            } else if ((version.equals("2.0") || PersistenceUtil.isValidVersionNumber(version)) && remainingNodeName.equals(VALUE)) {
                                String attributeValue = null;
                                if (remainingNode.hasAttributes()) {
                                    NamedNodeMap nodeMap = remainingNode.getAttributes();
                                    attributeValue = nodeMap.getNamedItem("name").getNodeValue();
                                    EntityPersistenceUtility.createLocaleSensitiveProperties(remainingNode, attributeValue, (AttributeDescriptorInterface)ad);
                                } else {
                                    throw new IllegalStateException(RB.getStringResource(RB_KEY, "missingNameAttr.ex.txt"));
                                }
                            }
                            if (remainingNodeName.equals(EDITOR)) {
                                Node classNameNode;
                                if (!remainingNode.hasAttributes()) continue;
                                NamedNodeMap editorAttributesMap = remainingNode.getAttributes();
                                context = null;
                                contextNode = editorAttributesMap.getNamedItem(CONTEXT);
                                if (contextNode != null) {
                                    context = contextNode.getNodeValue();
                                }
                                if ((classNameNode = editorAttributesMap.getNamedItem(CLASSNAME)) == null) continue;
                                ad.setEditor(context, classNameNode.getNodeValue());
                                continue;
                            }
                            if (remainingNodeName.equals(CUSTOMIZER)) {
                                Node classNameNode;
                                if (!remainingNode.hasAttributes()) continue;
                                NamedNodeMap customizerAttributesMap = remainingNode.getAttributes();
                                context = null;
                                contextNode = customizerAttributesMap.getNamedItem(CONTEXT);
                                if (contextNode != null) {
                                    context = contextNode.getNodeValue();
                                }
                                if ((classNameNode = customizerAttributesMap.getNamedItem(CLASSNAME)) == null) continue;
                                ad.setCustomizer(context, classNameNode.getNodeValue());
                                continue;
                            }
                            if (remainingNodeName.equals(TYPE)) {
                                Node sqlTypeNode;
                                if (!remainingNode.hasAttributes()) continue;
                                NamedNodeMap typeAttributesMap2 = remainingNode.getAttributes();
                                String typeName2 = null;
                                nameNode2 = typeAttributesMap2.getNamedItem("name");
                                if (nameNode2 != null) {
                                    typeName2 = nameNode2.getNodeValue();
                                }
                                if ((sqlTypeNode = typeAttributesMap2.getNamedItem(SQLTYPE)) == null) continue;
                                int sqlType = new Integer(sqlTypeNode.getNodeValue());
                                AttributeType at = new AttributeType(typeName2, sqlType);
                                ad.setType((AttributeTypeInterface)at);
                                continue;
                            }
                            if (remainingNodeName.equals(SUPPLEMENTAL_PROPERTY)) {
                                NodeList valueList2;
                                if (!remainingNode.hasAttributes()) continue;
                                NamedNodeMap supPropertyAttributesMap = remainingNode.getAttributes();
                                String name = null;
                                nameNode2 = supPropertyAttributesMap.getNamedItem("name");
                                if (nameNode2 != null) {
                                    name = nameNode2.getNodeValue();
                                }
                                String classType = null;
                                Node classTypeNode = supPropertyAttributesMap.getNamedItem(CLASSTYPE);
                                if (classTypeNode != null) {
                                    classType = classTypeNode.getNodeValue();
                                }
                                String attributeValue = null;
                                if (remainingNode.hasChildNodes() && (valueList2 = remainingNode.getChildNodes()).getLength() > 0) {
                                    Node valueElement2 = valueList2.item(0);
                                    if (valueElement2.hasChildNodes()) {
                                        NodeList childList3 = valueElement2.getChildNodes();
                                        Node childElement2 = childList3.item(0);
                                        attributeValue = childElement2.getNodeValue();
                                    } else if (valueElement2 instanceof Text) {
                                        Node sibling = valueElement2.getNextSibling();
                                        if (sibling instanceof Element && sibling.hasChildNodes()) {
                                            NodeList childList4 = sibling.getChildNodes();
                                            Node childElement3 = childList4.item(0);
                                            attributeValue = childElement3.getNodeValue();
                                        }
                                    } else {
                                        attributeValue = "";
                                    }
                                }
                                if (classType != null) {
                                    Class[] stringArgsClass = new Class[]{String.class};
                                    try {
                                        Class c = Classes.loadClass((String)classType, null, null);
                                        Constructor stringArgsConstructor = c.getConstructor(stringArgsClass);
                                        Object[] stringArgs = new Object[]{attributeValue};
                                        Object o = stringArgsConstructor.newInstance(stringArgs);
                                        ad.setSupplementalProperty(name, o);
                                    }
                                    catch (Exception c) {}
                                    continue;
                                }
                                ad.setSupplementalProperty(name, null);
                                continue;
                            }
                            if (remainingNodeName.equals(CURRENT_VALUE)) {
                                if (!remainingNode.hasChildNodes() || (valueList = remainingNode.getChildNodes()).getLength() <= 0 || !(valueElement = valueList.item(0)).hasChildNodes()) continue;
                                childList2 = valueElement.getChildNodes();
                                Node childElement4 = childList2.item(0);
                                hasCurrentValue = true;
                                attributeCurrentValue = childElement4.getNodeValue();
                                continue;
                            }
                            if (remainingNodeName.equals(DEFAULT_VALUE)) {
                                if (!remainingNode.hasChildNodes() || (valueList = remainingNode.getChildNodes()).getLength() <= 0 || !(valueElement = valueList.item(0)).hasChildNodes()) continue;
                                childList2 = valueElement.getChildNodes();
                                Node childElement5 = childList2.item(0);
                                currentDefaultValue = childElement5.getNodeValue();
                                continue;
                            }
                            if (remainingNodeName.equals(DEFAULT_VALUES)) {
                                NodeList defaultValueList;
                                int listLength;
                                if (!remainingNode.hasChildNodes() || (listLength = (defaultValueList = remainingNode.getChildNodes()).getLength()) <= 0) continue;
                                defaultValues = new ArrayList<Object>();
                                ati = ad.getType();
                                for (int p = 0; p < listLength; ++p) {
                                    Node valueElement3 = defaultValueList.item(p);
                                    if (valueElement3.hasAttributes()) {
                                        typeAttributesMap = valueElement3.getAttributes();
                                        typeName = null;
                                        nameNode = typeAttributesMap.getNamedItem("value");
                                        if (nameNode == null) continue;
                                        String nodeValue2 = nameNode.getNodeValue();
                                        if (ati != null) {
                                            int sqlType = ati.getSQLType();
                                            if (sqlType == 8 || sqlType == 6) {
                                                Object o = StringToMissingValuesTransform.defaultInstance.transform((Object)nodeValue2);
                                                defaultValues.add(o);
                                                continue;
                                            }
                                            if (sqlType == 92) {
                                                long timeValue = new Long(nodeValue2);
                                                defaultValues.add(new Time(new Long(nodeValue2)));
                                                continue;
                                            }
                                            if (sqlType == 93) {
                                                defaultValues.add(new Timestamp(new Long(nodeValue2)));
                                                continue;
                                            }
                                            if (nodeValue2.equals(NULL_STRING)) {
                                                defaultValues.add(null);
                                                continue;
                                            }
                                            defaultValues.add(nodeValue2);
                                            continue;
                                        }
                                        defaultValues.add(nodeValue2);
                                        continue;
                                    }
                                    if (!valueElement3.hasChildNodes()) continue;
                                    childList = valueElement3.getChildNodes();
                                    childElement = childList.item(0);
                                    nodeValue = childElement.getNodeValue();
                                    if (ati != null) {
                                        int sqlType = ati.getSQLType();
                                        if (sqlType == 8 || sqlType == 6) {
                                            Object o = StringToMissingValuesTransform.defaultInstance.transform((Object)nodeValue);
                                            defaultValues.add(o);
                                            continue;
                                        }
                                        defaultValues.add(nodeValue);
                                        continue;
                                    }
                                    defaultValues.add(nodeValue);
                                }
                                continue;
                            }
                            if (remainingNodeName.equals(CURRENT_VALUES)) {
                                NodeList currentValueList;
                                int listLength;
                                if (!remainingNode.hasChildNodes() || (listLength = (currentValueList = remainingNode.getChildNodes()).getLength()) <= 0) continue;
                                currentValues = new ArrayList<Object>();
                                ati = ad.getType();
                                for (int q = 0; q < listLength; ++q) {
                                    Node valueElement4 = currentValueList.item(q);
                                    if (valueElement4.hasAttributes()) {
                                        typeAttributesMap = valueElement4.getAttributes();
                                        typeName = null;
                                        nameNode = typeAttributesMap.getNamedItem("value");
                                        if (nameNode == null) continue;
                                        String nodeValue3 = nameNode.getNodeValue();
                                        if (ati != null) {
                                            int sqlType = ati.getSQLType();
                                            if (sqlType == 8 || sqlType == 6) {
                                                Object o = StringToMissingValuesTransform.defaultInstance.transform((Object)nodeValue3);
                                                currentValues.add(o);
                                                continue;
                                            }
                                            if (sqlType == 92) {
                                                long timeValue = new Long(nodeValue3);
                                                currentValues.add(new Time(new Long(nodeValue3)));
                                                continue;
                                            }
                                            if (sqlType == 93) {
                                                currentValues.add(new Timestamp(new Long(nodeValue3)));
                                                continue;
                                            }
                                            if (nodeValue3.equals(NULL_STRING)) {
                                                currentValues.add(null);
                                                continue;
                                            }
                                            currentValues.add(nodeValue3);
                                            continue;
                                        }
                                        currentValues.add(nodeValue3);
                                        continue;
                                    }
                                    if (!valueElement4.hasChildNodes()) continue;
                                    childList = valueElement4.getChildNodes();
                                    childElement = childList.item(0);
                                    nodeValue = childElement.getNodeValue();
                                    if (ati != null) {
                                        int sqlType = ati.getSQLType();
                                        if (sqlType == 8 || sqlType == 6) {
                                            Object o = StringToMissingValuesTransform.defaultInstance.transform((Object)nodeValue);
                                            currentValues.add(o);
                                            continue;
                                        }
                                        currentValues.add(nodeValue);
                                        continue;
                                    }
                                    currentValues.add(nodeValue);
                                }
                                hasCurrentValue = true;
                                continue;
                            }
                            if (!remainingNodeName.equals("Configuration")) continue;
                            Element configElement = (Element)remainingNode;
                            ParsedConfigurationXMLObject parsedObject = ConfigurationXMLPersistenceUtility.createParsedConfigurationXMLObjectFromNode(configElement, null);
                            ad.setConfigurationXML(ConfigurationXMLPersistenceUtility.writeConfigurationXML(parsedObject));
                        }
                        if (ad.isDefaultValueHasBeenSet()) {
                            if (defaultValues != null) {
                                ad.setDefault(defaultValues);
                            } else {
                                AttributeTypeInterface ati = ad.getType();
                                int sqlType = ati.getSQLType();
                                if (ati != null) {
                                    if (sqlType == 8 || sqlType == 6) {
                                        ad.setDefault(StringToMissingValuesTransform.defaultInstance.transform((Object)currentDefaultValue));
                                    } else if (sqlType == 92) {
                                        long timeValue = new Long(currentDefaultValue);
                                        ad.setDefault((Object)new Time(new Long(currentDefaultValue)));
                                    } else if (sqlType == 93) {
                                        ad.setDefault((Object)new Timestamp(new Long(currentDefaultValue)));
                                    } else {
                                        ad.setDefault((Object)currentDefaultValue);
                                    }
                                } else {
                                    ad.setDefault((Object)currentDefaultValue);
                                }
                            }
                        }
                        attributeGroup.addAttributeDescriptor((AttributeDescriptorInterface)ad, -1);
                        if (!hasCurrentValue) continue;
                        try {
                            if (attributeCurrentValue != null && attributeCurrentValue.equals(NULL_STRING)) {
                                entity.setAttribute(ad.getName(), null);
                                continue;
                            }
                            AttributeTypeInterface ati = ad.getType();
                            if (ati == null) {
                                throw new IllegalArgumentException(MessageFormat.format(RB.getStringResource(RB_KEY, "nullAttributeType.ex.txt"), attributeCurrentValue));
                            }
                            int sqlType = ati.getSQLType();
                            if (ati.getSQLType() == 0) {
                                throw new IllegalArgumentException(MessageFormat.format(RB.getStringResource(RB_KEY, "nullAttributeType.ex.txt"), attributeCurrentValue));
                            }
                            if (currentValues != null) {
                                entity.setAttribute(ad.getName(), currentValues);
                                continue;
                            }
                            if (sqlType == 8 || sqlType == 6) {
                                Object o = StringToMissingValuesTransform.defaultInstance.transform((Object)attributeCurrentValue);
                                entity.setAttribute(ad.getName(), AttributeTypeUtility.transformAttributeValue((Object)o, (AttributeDescriptorInterface)ad));
                                continue;
                            }
                            if (sqlType == 92) {
                                entity.setAttribute(ad.getName(), (Object)new Time(new Long(attributeCurrentValue)));
                                continue;
                            }
                            if (sqlType == 93) {
                                entity.setAttribute(ad.getName(), (Object)new Timestamp(new Long(attributeCurrentValue)));
                                continue;
                            }
                            entity.setAttribute(ad.getName(), (Object)attributeCurrentValue);
                            continue;
                        }
                        catch (AttributeSetException attributeSetException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return entity;
    }

    protected static String getValueForLocaleSensitiveItem(Node remainingNode) {
        String value = null;
        NodeList dataList = remainingNode.getChildNodes();
        if (dataList.getLength() > 0) {
            Node textNode = dataList.item(0);
            NodeList valueList = textNode.getChildNodes();
            Node textValueNode = valueList.item(0);
            value = textValueNode.getNodeValue();
        }
        return value;
    }

    private static EntityInterface createOldEntityFromXML(String docString) {
        Entity entity = new Entity();
        if (docString.indexOf("configurationXML=\"<?xml version=") > -1) {
            docString = EntityPersistenceUtility._fixBadConfigXML(docString);
        }
        if (docString == null || docString.length() == 0) {
            return null;
        }
        DOMDoc doc = new DOMDoc();
        doc.loadDocument(new StringReader(docString), false);
        Element rootElement = doc.getDocumentElement();
        AttributeGroup ag = (AttributeGroup)entity.getAttributeGroup();
        ArrayList attributeNames = new ArrayList();
        if (rootElement.getTagName().equals("entities")) {
            NodeList nl = rootElement.getElementsByTagName("*");
            int nodeLength = nl.getLength();
            for (int i = 0; i < nodeLength; ++i) {
                Node attributeElement = nl.item(i);
                String nodeName = attributeElement.getNodeName();
                short nodeType = attributeElement.getNodeType();
                if (nodeName.equals("entity")) {
                    NamedNodeMap keyNodeMap = attributeElement.getAttributes();
                    if (keyNodeMap.getLength() <= 0) continue;
                    entity.setEntityKey(keyNodeMap.item(0).getNodeValue());
                    continue;
                }
                if (!nodeName.equals("entityAttribute") || !attributeElement.hasAttributes()) continue;
                NamedNodeMap nodeMap = attributeElement.getAttributes();
                String attributeDescriptorName = nodeMap.getNamedItem("name").getNodeValue();
                if (!attributeDescriptorName.equals(ENTITY_KEY)) {
                    AttributeDescriptor ad = new AttributeDescriptor(attributeDescriptorName);
                    if (attributeElement.hasChildNodes()) {
                        NodeList childList = attributeElement.getChildNodes();
                        int nLength = childList.getLength();
                        for (int k = 0; k < nLength; ++k) {
                            Node childElement = childList.item(k);
                            if (childElement.getNodeType() != 4) continue;
                            String configurationXML = childElement.getNodeValue();
                            ad.setConfigurationXML(configurationXML);
                        }
                    }
                    int nodeMapLength = nodeMap.getLength();
                    for (int j = 0; j < nodeMapLength; ++j) {
                        Node attributeDescriptorNode = nodeMap.item(j);
                        String attrDescriptorName = attributeDescriptorNode.getNodeName();
                        if (attrDescriptorName.equals(DEFAULT_VALUE_SET)) {
                            ad.setDefaultValueHasBeenSet(new Boolean(attributeDescriptorNode.getNodeValue()).booleanValue());
                            continue;
                        }
                        if (attrDescriptorName.equals(EXPERT)) {
                            ad.setExpert(new Boolean(attributeDescriptorNode.getNodeValue()).booleanValue());
                            continue;
                        }
                        if (attrDescriptorName.equals(MODIFIABLE)) {
                            ad.setModifiable(new Boolean(attributeDescriptorNode.getNodeValue()).booleanValue());
                            continue;
                        }
                        if (attrDescriptorName.equals(PROPERTY)) {
                            ad.setProperty(new Boolean(attributeDescriptorNode.getNodeValue()).booleanValue());
                            continue;
                        }
                        if (attrDescriptorName.equals(REQUIRED)) {
                            ad.setRequired(new Boolean(attributeDescriptorNode.getNodeValue()).booleanValue());
                            continue;
                        }
                        if (attrDescriptorName.equals(VISIBLE)) {
                            ad.setVisible(new Boolean(attributeDescriptorNode.getNodeValue()).booleanValue());
                            continue;
                        }
                        if (attrDescriptorName.equals("configurationXML")) {
                            ad.setConfigurationXML(attributeDescriptorNode.getNodeValue());
                            continue;
                        }
                        if (attrDescriptorName.equals(DEFAULT_VALUE)) {
                            if (!ad.isDefaultValueHasBeenSet()) continue;
                            ad.setDefault((Object)attributeDescriptorNode.getNodeValue());
                            continue;
                        }
                        if (attrDescriptorName.equals(DESCRIPTION)) {
                            ad.setDescription(null, attributeDescriptorNode.getNodeValue());
                            continue;
                        }
                        if (attrDescriptorName.equals("editorJava")) {
                            ad.setEditor("Java", attributeDescriptorNode.getNodeValue());
                            continue;
                        }
                        if (attrDescriptorName.equals("editorServlet")) {
                            ad.setEditor("Servlet", attributeDescriptorNode.getNodeValue());
                            continue;
                        }
                        if (attrDescriptorName.equals(LABEL)) {
                            ad.setLabel(null, attributeDescriptorNode.getNodeValue());
                            continue;
                        }
                        if (!attrDescriptorName.equals("type")) continue;
                        AttributeType type = new AttributeType("String", "java.lang.String");
                        type.setType(attributeDescriptorNode.getNodeValue());
                        ad.setType((AttributeTypeInterface)type);
                    }
                    ag.addAttributeDescriptor((AttributeDescriptorInterface)ad, -1);
                    Object defaultValue = entity.getAttributeDescriptor(attributeDescriptorName).getDefault();
                    ((HashMap)entity.getDelegate()).put(attributeDescriptorName, defaultValue);
                    continue;
                }
                Node entityKeyNode = nodeMap.getNamedItem(ENTITY_KEY);
                entity.setEntityKey(entityKeyNode.getNodeValue());
            }
        }
        return entity;
    }

    private static String _fixBadConfigXML(String entityAsString) {
        String newString = "";
        String oldString = entityAsString;
        String holding = "";
        int i = 0;
        while (-1 != (i = oldString.indexOf("configurationXML=\"<?xml version="))) {
            newString = newString + oldString.substring(0, i);
            int j = (oldString = oldString.substring(i)).indexOf("</Configuration>\"");
            if (j == -1) break;
            holding = "\n<![CDATA[." + oldString.substring(18, j + 16) + ".]]>\n";
            oldString = oldString.substring(j + 17);
            int k1 = oldString.indexOf("/>");
            int k2 = oldString.indexOf("</entityAttribute>");
            if (k1 == -1 && k2 == -1) break;
            if (k1 != -1 && (k2 == -1 || k2 > k1)) {
                newString = newString + oldString.substring(0, k1);
                newString = newString + ">" + holding + "</entityAttribute";
                oldString = oldString.substring(k1 + 1);
                continue;
            }
            newString = newString + oldString.substring(0, k2);
            newString = newString + holding;
            oldString = oldString.substring(k2);
        }
        if (oldString.length() > 0) {
            newString = newString + oldString;
        }
        return newString;
    }

    private static boolean containsEntityRef(String enumerationValue) {
        for (int i = 0; i < ENTITYREF.length; ++i) {
            if (enumerationValue.indexOf(ENTITYREF[i]) == -1) continue;
            return true;
        }
        return false;
    }

    protected static void createLocaleSensitiveProperties(Node valueNode, String propertyName, AttributeDescriptorInterface ad) {
        if (valueNode.hasChildNodes()) {
            NodeList textList = valueNode.getChildNodes();
            Node textElement = null;
            String textName = null;
            int textListLength = textList.getLength();
            for (int m = 0; m < textListLength; ++m) {
                NamedNodeMap localesMap;
                Node xmlLangNode;
                textElement = textList.item(m);
                textName = textElement.getNodeName();
                if (!textName.equals("Text")) continue;
                Locale locale = null;
                if (textElement.hasAttributes() && (xmlLangNode = (localesMap = textElement.getAttributes()).getNamedItem("xml:lang")) != null) {
                    String localeCode = xmlLangNode.getNodeValue();
                    if (localeCode != null) {
                        locale = PersistenceUtil.parseLocaleItem(localeCode);
                    } else {
                        throw new IllegalStateException(RB.getStringResource(RB_KEY, "localeParsing.ex.txt"));
                    }
                }
                if (!textElement.hasChildNodes()) continue;
                NodeList textChildList = textElement.getChildNodes();
                String listValue = null;
                Node childElement = textChildList.item(0);
                if (!childElement.hasChildNodes()) {
                    listValue = childElement.getNodeValue();
                    if (listValue.equals(EMPTY_STRING)) {
                        listValue = "";
                    }
                } else {
                    throw new IllegalStateException(RB.getStringResource(RB_KEY, "missingNameAttr.ex.txt"));
                }
                if (propertyName.equals(LABEL)) {
                    ad.setLabel(locale, listValue);
                    continue;
                }
                if (propertyName.equals(DESCRIPTION)) {
                    ad.setDescription(locale, listValue);
                    continue;
                }
                if (propertyName.equals(SMALL_ICON_URL)) {
                    ad.setSmallIconURL(locale, listValue);
                    continue;
                }
                if (!propertyName.equals(LARGE_ICON_URL)) continue;
                ad.setLargeIconURL(locale, listValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Element writeNodes(EntityInterface ei, Element entity, boolean writeCurrentValue, Map map, String versionNumber, boolean escapeChars) {
        Document domDoc = entity.getOwnerDocument();
        Attr entityVersion = domDoc.createAttribute("version");
        entity.setAttributeNode(entityVersion);
        Attr entityKey = domDoc.createAttribute(ENTITY_KEY);
        entity.setAttributeNode(entityKey);
        try {
            String[] keys = ei.getAttributeGroup().getAttributeDescriptorNames(true);
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (!key.equals(ENTITY_KEY)) continue;
                entityKey.setValue((String)ei.getAttribute(key));
                break;
            }
            Element entityAttributeGroup = domDoc.createElement(ATTRIBUTE_GROUP);
            entity.appendChild(entityAttributeGroup);
            AttributeGroupInterface agi = ei.getAttributeGroup();
            String attributeGroupName = agi.getName();
            if (attributeGroupName != null) {
                Attr groupName = domDoc.createAttribute("name");
                entityAttributeGroup.setAttributeNode(groupName);
                if (escapeChars) {
                    groupName.setValue(Strings.replace((String)attributeGroupName, (char[])xmlSpecial, (String[])xmlReplacements));
                } else {
                    groupName.setValue(attributeGroupName);
                }
            }
            if (!PersistenceUtil.isDefaultValueForAttributeGroupProperty(agi, MODIFIABLE)) {
                Attr modifiable = domDoc.createAttribute(MODIFIABLE);
                entityAttributeGroup.setAttributeNode(modifiable);
                modifiable.setValue(new Boolean(agi.isModifiable()).toString());
            }
            if (!PersistenceUtil.isDefaultValueForAttributeGroupProperty(agi, VISIBLE)) {
                Attr visible = domDoc.createAttribute(VISIBLE);
                entityAttributeGroup.setAttributeNode(visible);
                visible.setValue(new Boolean(agi.isVisible()).toString());
            }
            for (int j = 0; j < keys.length; ++j) {
                Map supplementalPropertiesMap;
                Map customizerMap;
                Map editorMap;
                Date date;
                int sqlType;
                String attributeValue;
                Attr value;
                Object listItem;
                Object o;
                AttributeTypeInterface attributeType;
                AttributeDescriptorInterface adi;
                String entityAttributeName = keys[j];
                if (entityAttributeName != null && entityAttributeName.equals(ENTITY_KEY)) continue;
                Element entityAttribute = domDoc.createElement(ATTRIBUTE_DESCRIPTOR);
                entityAttributeGroup.appendChild(entityAttribute);
                if (entityAttributeName != null) {
                    Attr attributeName = domDoc.createAttribute("name");
                    entityAttribute.setAttributeNode(attributeName);
                    if (escapeChars) {
                        attributeName.setValue(Strings.replace((String)entityAttributeName, (char[])xmlSpecial, (String[])xmlReplacements));
                    } else {
                        attributeName.setValue(entityAttributeName);
                    }
                }
                if (!PersistenceUtil.isDefaultValueForAttributeDescriptorProperty(adi = agi.getAttributeDescriptor(entityAttributeName, true), EXPERT)) {
                    Attr expert = domDoc.createAttribute(EXPERT);
                    entityAttribute.setAttributeNode(expert);
                    expert.setValue(new Boolean(adi.isExpert()).toString());
                }
                if (!PersistenceUtil.isDefaultValueForAttributeDescriptorProperty(adi, MODIFIABLE)) {
                    Attr attributeModifiable = domDoc.createAttribute(MODIFIABLE);
                    entityAttribute.setAttributeNode(attributeModifiable);
                    attributeModifiable.setValue(new Boolean(adi.isModifiable()).toString());
                }
                if (!PersistenceUtil.isDefaultValueForAttributeDescriptorProperty(adi, PROPERTY)) {
                    Attr property = domDoc.createAttribute(PROPERTY);
                    entityAttribute.setAttributeNode(property);
                    property.setValue(new Boolean(adi.isProperty()).toString());
                }
                if (!PersistenceUtil.isDefaultValueForAttributeDescriptorProperty(adi, REQUIRED)) {
                    Attr required = domDoc.createAttribute(REQUIRED);
                    entityAttribute.setAttributeNode(required);
                    required.setValue(new Boolean(adi.isRequired()).toString());
                }
                if (!PersistenceUtil.isDefaultValueForAttributeDescriptorProperty(adi, VISIBLE)) {
                    Attr attributeVisible = domDoc.createAttribute(VISIBLE);
                    entityAttribute.setAttributeNode(attributeVisible);
                    attributeVisible.setValue(new Boolean(adi.isVisible()).toString());
                }
                if (!PersistenceUtil.isDefaultValueForAttributeDescriptorProperty(adi, "defaultValueHasBeenSet")) {
                    Attr attributeHasDefaultValueSet = domDoc.createAttribute(DEFAULT_VALUE_SET);
                    entityAttribute.setAttributeNode(attributeHasDefaultValueSet);
                    attributeHasDefaultValueSet.setValue(new Boolean(adi.isDefaultValueHasBeenSet()).toString());
                }
                if ((attributeType = adi.getType()) != null) {
                    Element typeElement = domDoc.createElement(TYPE);
                    entityAttribute.appendChild(typeElement);
                    if (!PersistenceUtil.isDefaultValueForAttributeTypeProperty(attributeType, "name")) {
                        Attr attributeTypeName = domDoc.createAttribute("name");
                        String attrTypeName = attributeType.getName();
                        if (escapeChars) {
                            attributeTypeName.setValue(Strings.replace((String)attrTypeName, (char[])xmlSpecial, (String[])xmlReplacements));
                        } else {
                            attributeTypeName.setValue(attrTypeName);
                        }
                        typeElement.setAttributeNode(attributeTypeName);
                    }
                    Attr sqlType2 = domDoc.createAttribute(SQLTYPE);
                    sqlType2.setValue(new Integer(attributeType.getSQLType()).toString());
                    typeElement.setAttributeNode(sqlType2);
                    if (!PersistenceUtil.isDefaultValueForAttributeTypeProperty(attributeType, "objectType")) {
                        String objectType = attributeType.getObjectType();
                        Attr objectTypeAttr = domDoc.createAttribute("objectType");
                        objectTypeAttr.setValue(objectType);
                        typeElement.setAttributeNode(objectTypeAttr);
                    }
                }
                if (adi.isDefaultValueHasBeenSet()) {
                    o = adi.getDefault();
                    if (o == null) {
                        Attr defaultValue = domDoc.createAttribute(DEFAULT_VALUE);
                        entityAttribute.setAttributeNode(defaultValue);
                        defaultValue.setValue(NULL_STRING);
                    } else if (o instanceof List) {
                        int listSize = ((List)o).size();
                        if (listSize > 0) {
                            Element defaultValues = domDoc.createElement(DEFAULT_VALUES);
                            entityAttribute.appendChild(defaultValues);
                            for (int k = 0; k < listSize; ++k) {
                                Element defaultValue = domDoc.createElement("DefaultValue");
                                defaultValues.appendChild(defaultValue);
                                listItem = ((List)o).get(k);
                                value = domDoc.createAttribute("value");
                                attributeValue = null;
                                sqlType = attributeType.getSQLType();
                                if (listItem == null) {
                                    attributeValue = NULL_STRING;
                                } else if (listItem instanceof MissingValues) {
                                    attributeValue = (String)MissingValuesToStringTransform.defaultInstance.transform(listItem);
                                } else if (AttributeTypeUtility.isColorStringClass((AttributeTypeInterface)attributeType)) {
                                    attributeValue = AttributeTypeUtility.transformValueToSASFormat(listItem, (AttributeTypeInterface)attributeType);
                                } else if (attributeType != null && sqlType == 91) {
                                    attributeValue = AttributeTypeUtility.transformValueToSASFormat(listItem, (AttributeTypeInterface)attributeType);
                                } else if (sqlType == 92 || sqlType == 93) {
                                    date = (Date)listItem;
                                    attributeValue = new Long(date.getTime()).toString();
                                    versionNumber = PersistenceUtil.version_9_1_SP4;
                                } else {
                                    attributeValue = listItem.toString();
                                }
                                defaultValue.setAttributeNode(value);
                                value.setValue(Strings.replace((String)attributeValue, (char[])xmlSpecial, (String[])xmlReplacements));
                            }
                        }
                    } else {
                        String attributeValue2 = null;
                        int sqlType3 = attributeType.getSQLType();
                        if (o instanceof MissingValues) {
                            attributeValue2 = (String)MissingValuesToStringTransform.defaultInstance.transform(o);
                        } else if (AttributeTypeUtility.isColorStringClass((AttributeTypeInterface)attributeType)) {
                            attributeValue2 = adi.getStringDefault();
                        } else if (attributeType != null && sqlType3 == 91) {
                            attributeValue2 = adi.getStringDefault();
                        } else if (sqlType3 == 92 || sqlType3 == 93) {
                            Date date2 = (Date)adi.getDefault();
                            attributeValue2 = new Long(date2.getTime()).toString();
                            versionNumber = PersistenceUtil.version_9_1_SP4;
                        } else {
                            attributeValue2 = o.toString();
                        }
                        Attr defaultValueAttr = domDoc.createAttribute(DEFAULT_VALUE);
                        entityAttribute.setAttributeNode(defaultValueAttr);
                        if (escapeChars) {
                            defaultValueAttr.setValue(Strings.replace((String)attributeValue2, (char[])xmlSpecial, (String[])xmlReplacements));
                        } else {
                            defaultValueAttr.setValue(attributeValue2);
                        }
                    }
                }
                if (writeCurrentValue && ei.containsAttributeNamed(keys[j])) {
                    o = ei.getAttribute(entityAttributeName);
                    if (o == null) {
                        Attr currentValueAttr = domDoc.createAttribute(CURRENT_VALUE);
                        entityAttribute.setAttributeNode(currentValueAttr);
                        currentValueAttr.setValue(NULL_STRING);
                    } else if (o instanceof List) {
                        int listSize = ((List)o).size();
                        if (listSize > 0) {
                            Element currentValues = domDoc.createElement(CURRENT_VALUES);
                            entityAttribute.appendChild(currentValues);
                            for (int m = 0; m < listSize; ++m) {
                                Element currentValue = domDoc.createElement("CurrentValue");
                                currentValues.appendChild(currentValue);
                                listItem = ((List)o).get(m);
                                value = domDoc.createAttribute("value");
                                attributeValue = null;
                                sqlType = attributeType.getSQLType();
                                if (listItem == null) {
                                    attributeValue = NULL_STRING;
                                } else if (listItem instanceof MissingValues) {
                                    attributeValue = (String)MissingValuesToStringTransform.defaultInstance.transform(listItem);
                                } else if (AttributeTypeUtility.isColorStringClass((AttributeTypeInterface)attributeType)) {
                                    attributeValue = AttributeTypeUtility.transformValueToSASFormat(listItem, (AttributeTypeInterface)attributeType);
                                } else if (attributeType != null && sqlType == 91) {
                                    attributeValue = AttributeTypeUtility.transformValueToSASFormat(listItem, (AttributeTypeInterface)attributeType);
                                } else if (sqlType == 92 || sqlType == 93) {
                                    date = (Date)listItem;
                                    attributeValue = new Long(date.getTime()).toString();
                                    versionNumber = PersistenceUtil.version_9_1_SP4;
                                } else {
                                    attributeValue = listItem.toString();
                                }
                                currentValue.setAttributeNode(value);
                                value.setValue(Strings.replace((String)attributeValue, (char[])xmlSpecial, (String[])xmlReplacements));
                            }
                        }
                    } else {
                        String attributeValue3 = null;
                        int sqlType4 = attributeType.getSQLType();
                        if (o instanceof MissingValues) {
                            attributeValue3 = (String)MissingValuesToStringTransform.defaultInstance.transform(o);
                        } else if (AttributeTypeUtility.isColorStringClass((AttributeTypeInterface)attributeType)) {
                            attributeValue3 = ei.getStringAttribute(entityAttributeName, adi.getStringDefault());
                        } else if (attributeType != null && sqlType4 == 91) {
                            attributeValue3 = ei.getStringAttribute(entityAttributeName, adi.getStringDefault());
                        } else if (sqlType4 == 92 || sqlType4 == 93) {
                            Date date3 = (Date)ei.getAttribute(entityAttributeName);
                            attributeValue3 = new Long(date3.getTime()).toString();
                            versionNumber = PersistenceUtil.version_9_1_SP4;
                        } else {
                            attributeValue3 = o.toString();
                        }
                        Attr currentValueAttr = domDoc.createAttribute(CURRENT_VALUE);
                        entityAttribute.setAttributeNode(currentValueAttr);
                        if (escapeChars) {
                            currentValueAttr.setValue(Strings.replace((String)attributeValue3, (char[])xmlSpecial, (String[])xmlReplacements));
                        } else {
                            currentValueAttr.setValue(attributeValue3);
                        }
                    }
                } else {
                    int sqlType5;
                    AttributeTypeInterface ati = adi.getType();
                    if (ati != null && ((sqlType5 = ati.getSQLType()) == 92 || sqlType5 == 93)) {
                        versionNumber = PersistenceUtil.version_9_1_SP4;
                    }
                }
                PersistenceUtil.writeLocaleSensitiveElement(domDoc, entityAttribute, LABEL, adi.getLabels(), adi, escapeChars);
                PersistenceUtil.writeLocaleSensitiveElement(domDoc, entityAttribute, DESCRIPTION, adi.getDescriptions(), adi, escapeChars);
                PersistenceUtil.writeLocaleSensitiveElement(domDoc, entityAttribute, SMALL_ICON_URL, adi.getSmallIconURLs(), adi, escapeChars);
                PersistenceUtil.writeLocaleSensitiveElement(domDoc, entityAttribute, LARGE_ICON_URL, adi.getLargeIconURLs(), adi, escapeChars);
                String configXML = adi.getConfigurationXML();
                if (configXML != null) {
                    try {
                        String latestVersionNumber;
                        boolean isLatestVersion;
                        ParsedConfigurationXMLObject parsedObject = ConfigurationXMLPersistenceUtility.createParsedConfigurationXMLObject(configXML);
                        if (map != null && !(isLatestVersion = versionNumber.equals(latestVersionNumber = PersistenceUtil.getLatestVersionNumber()))) {
                            String currentAttributeVersionNumber = parsedObject.getVersion();
                            versionNumber = PersistenceUtil.getLatestVersionNumber(currentAttributeVersionNumber, versionNumber);
                        }
                        if (escapeChars) {
                            Element configXMLElement = domDoc.createElement(CONFIGURATION_XML);
                            entityAttribute.appendChild(configXMLElement);
                            Text textNode = domDoc.createTextNode(Strings.replace((String)configXML, (char[])xmlSpecial, (String[])xmlReplacements));
                            configXMLElement.appendChild(textNode);
                        } else {
                            ConfigurationXMLPersistenceUtility.write(parsedObject, entityAttribute);
                        }
                    }
                    catch (Exception parsedObject) {
                        // empty catch block
                    }
                }
                if ((editorMap = adi.getAttributeEditors()) != null) {
                    Iterator iter = editorMap.keySet().iterator();
                    Element editorElement = null;
                    while (iter.hasNext()) {
                        String context = (String)iter.next();
                        String nameOfEditor = (String)editorMap.get(context);
                        if (nameOfEditor == null) continue;
                        editorElement = domDoc.createElement(EDITOR);
                        entityAttribute.appendChild(editorElement);
                        Attr editorContext = domDoc.createAttribute(CONTEXT);
                        editorContext.setValue(context);
                        editorElement.setAttributeNode(editorContext);
                        Attr editorName = domDoc.createAttribute(CLASSNAME);
                        editorName.setValue(Strings.replace((String)nameOfEditor, (char[])xmlSpecial, (String[])xmlReplacements));
                        editorElement.setAttributeNode(editorName);
                    }
                }
                if ((customizerMap = adi.getAttributeCustomizers()) != null) {
                    Iterator iter = customizerMap.keySet().iterator();
                    Element customizerElement = null;
                    while (iter.hasNext()) {
                        String context = (String)iter.next();
                        String nameOfCustomizer = (String)customizerMap.get(context);
                        if (nameOfCustomizer == null) continue;
                        customizerElement = domDoc.createElement(CUSTOMIZER);
                        entityAttribute.appendChild(customizerElement);
                        Attr customizerContext = domDoc.createAttribute(CONTEXT);
                        customizerContext.setValue(context);
                        customizerElement.setAttributeNode(customizerContext);
                        Attr customizerName = domDoc.createAttribute(CLASSNAME);
                        customizerName.setValue(Strings.replace((String)nameOfCustomizer, (char[])xmlSpecial, (String[])xmlReplacements));
                        customizerElement.setAttributeNode(customizerName);
                    }
                }
                if ((supplementalPropertiesMap = adi.getSupplementalProperties()) == null) continue;
                Iterator iter = supplementalPropertiesMap.keySet().iterator();
                Element supplementalPropertyElement = null;
                Object supPropertyValue = null;
                Class<?> supPropertyClass = null;
                while (iter.hasNext()) {
                    String supPropertyName = (String)iter.next();
                    supplementalPropertyElement = domDoc.createElement(SUPPLEMENTAL_PROPERTY);
                    entityAttribute.appendChild(supplementalPropertyElement);
                    Attr attrName = domDoc.createAttribute("name");
                    supplementalPropertyElement.setAttributeNode(attrName);
                    attrName.setValue(Strings.replace((String)supPropertyName, (char[])xmlSpecial, (String[])xmlReplacements));
                    supPropertyValue = supplementalPropertiesMap.get(supPropertyName);
                    if (supPropertyValue != null) {
                        Attr attrClassName = domDoc.createAttribute(CLASSTYPE);
                        supplementalPropertyElement.setAttributeNode(attrClassName);
                        supPropertyClass = supPropertyValue.getClass();
                        String className = supPropertyClass.getName();
                        attrClassName.setValue(className);
                    }
                    Element valueElement = domDoc.createElement(VALUE);
                    supplementalPropertyElement.appendChild(valueElement);
                    if (supPropertyValue != null) {
                        String supplementalPropertyValue = supPropertyValue.toString();
                        Text textNode = null;
                        textNode = domDoc.createTextNode(Strings.replace((String)supplementalPropertyValue, (char[])xmlSpecial, (String[])xmlReplacements));
                        valueElement.appendChild(textNode);
                        continue;
                    }
                    Text textNode = domDoc.createTextNode(null);
                    valueElement.appendChild(textNode);
                }
            }
            entityVersion.setValue(versionNumber);
            if (map != null) {
                map.put("version", versionNumber);
            }
        }
        catch (RemoteException remoteException) {}
        finally {
            return entity;
        }
    }

    protected static Locale parseLocaleItem(String localeCode) {
        Locale locale;
        block10: {
            int tokenCount;
            StringTokenizer tokenizer;
            block13: {
                block12: {
                    block11: {
                        block9: {
                            locale = null;
                            tokenizer = new StringTokenizer(localeCode, UNDERSCORE, true);
                            tokenCount = tokenizer.countTokens();
                            if (tokenCount != 1) break block9;
                            locale = new Locale(tokenizer.nextToken().trim());
                            break block10;
                        }
                        if (tokenCount != 2) break block11;
                        for (int i = 0; i < tokenCount; ++i) {
                            String theToken = tokenizer.nextToken().trim();
                            if (theToken.equals(UNDERSCORE)) continue;
                            locale = new Locale("", theToken);
                        }
                        break block10;
                    }
                    if (tokenCount != 3) break block12;
                    String langCode = null;
                    for (int i = 0; i < tokenCount; ++i) {
                        String theToken = tokenizer.nextToken().trim();
                        if (i == 0) {
                            langCode = theToken;
                        }
                        if (i != 2) continue;
                        locale = new Locale(langCode, theToken);
                    }
                    break block10;
                }
                if (tokenCount != 4) break block13;
                String parameter = null;
                int x = 0;
                for (int i = 0; i < tokenCount; ++i) {
                    String theToken = tokenizer.nextToken().trim();
                    if (i == 0) {
                        x = theToken.equals(UNDERSCORE) ? 1 : 0;
                    }
                    if (i == x) {
                        parameter = theToken;
                    }
                    if (i != 3) continue;
                    locale = x == 0 ? new Locale(parameter, "", theToken) : new Locale("", parameter, theToken);
                }
                break block10;
            }
            if (tokenCount != 5) break block10;
            String langCode = null;
            String countryCode = null;
            for (int i = 0; i < tokenCount; ++i) {
                String theToken = tokenizer.nextToken().trim();
                if (i == 0) {
                    langCode = theToken;
                }
                if (i == 2) {
                    countryCode = theToken;
                }
                if (i != 4) continue;
                locale = new Locale(langCode, countryCode, theToken);
            }
        }
        return locale;
    }
}

