/*
 * Decompiled with CFR 0.152.
 */
package com.sas.entities.persist;

import com.sas.codepolicy.SASScope;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeTypeInterface;
import com.sas.entities.EntityUtil;
import com.sas.entities.persist.ConfigurationXMLPersistenceUtility;
import com.sas.entities.persist.DOMDOCException;
import com.sas.entities.persist.ParsedConfigurationXMLObject;
import java.util.Map;

@SASScope(value="ALL")
public class EntityHelper {
    public static final String RB_KEY = "EntityHelper.";

    public static boolean isMultiValueStructured(AttributeDescriptorInterface adi, ParsedConfigurationXMLObject parsedObject) {
        Object value;
        AttributeTypeInterface ati = adi.getType();
        if (ati.getSQLType() == 16) {
            return false;
        }
        if (EntityUtil.attributeDescriptorHasSupplementalProperty((AttributeDescriptorInterface)adi, (String)"multiValueStructured") && (value = adi.getSupplementalProperty("multiValueStructured")) instanceof Boolean) {
            return (Boolean)adi.getSupplementalProperty("multiValueStructured");
        }
        try {
            Map selectionRange;
            String configXML = adi.getConfigurationXML();
            if (parsedObject == null) {
                if (configXML == null) {
                    return false;
                }
                parsedObject = ConfigurationXMLPersistenceUtility.createParsedConfigurationXMLObject(configXML);
            }
            return (selectionRange = parsedObject.getSelectionRange()) != null;
        }
        catch (Exception domex) {
            return false;
        }
    }

    public static boolean isMultipleValuesAllowed(AttributeDescriptorInterface adi, ParsedConfigurationXMLObject parsedObject) {
        if (!EntityHelper.isMultiValueStructured(adi, parsedObject)) {
            return false;
        }
        if (parsedObject == null) {
            String configXML = adi.getConfigurationXML();
            if (configXML == null) {
                return true;
            }
            try {
                parsedObject = ConfigurationXMLPersistenceUtility.createParsedConfigurationXMLObject(adi.getConfigurationXML());
            }
            catch (DOMDOCException domex) {
                return false;
            }
        }
        Map selectionRange = parsedObject.getSelectionRange();
        Map supplementalProperties = adi.getSupplementalProperties();
        if (supplementalProperties != null && supplementalProperties.containsKey("multiValueStructured") && selectionRange == null) {
            return true;
        }
        if (selectionRange.containsKey("max")) {
            Integer maxSel = (Integer)selectionRange.get("max");
            return maxSel == null || maxSel > 1;
        }
        return true;
    }
}

