/*
 * Decompiled with CFR 0.152.
 */
package com.sas.entities.persist;

import com.sas.MissingValues;
import com.sas.datatypes.CollectionType;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.StringType;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeGroupInterface;
import com.sas.entities.EntityUtil;
import com.sas.entities.RemoteEntityInterface;
import com.sas.entities.persist.ConfigurationXMLPersistenceUtility;
import com.sas.entities.persist.EntityHelper;
import com.sas.entities.persist.EnumerationItem;
import com.sas.entities.persist.ParsedConfigurationXMLObject;
import com.sas.entities.persist.RB;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.MutableIdentifiablePromptInterface;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.BaseDefinitionRange;
import com.sas.prompts.definitions.ColorDefinition;
import com.sas.prompts.definitions.DateDefinition;
import com.sas.prompts.definitions.DoubleDefinition;
import com.sas.prompts.definitions.IntegerDefinition;
import com.sas.prompts.definitions.MutableHintableDefinitionInterface;
import com.sas.prompts.definitions.MutablePromptDefinitionInterface;
import com.sas.prompts.definitions.MutableSelectableDefinitionInterface;
import com.sas.prompts.definitions.MutableTextDefinitionInterface;
import com.sas.prompts.definitions.MutableValueProviderDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.TextDefinition;
import com.sas.prompts.groups.PromptGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.storage.valueprovider.AllowUserValuesInterface;
import com.sas.storage.valueprovider.StaticValueProvider;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.util.DateTypes;
import com.sas.util.MutableUserInfoInterface;
import com.sas.util.PreorderTreeModelIterator;
import com.sas.util.Strings;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.ValidateArg;
import com.sas.util.ValueItem;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.ComponentLogFactoryInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

public class EntityConverter {
    public static final String RB_KEY = "EntityConverter.";
    public static final EntityConverter DEFAULT_INSTANCE = new EntityConverter();
    private static StaticValueProvider booleanValueProvider;

    public PromptDefinitionInterface newPromptDefinition(AttributeDescriptorInterface ad, LoggerFactoryInterface factory) {
        return this.newPromptDefinition(ad, factory, null);
    }

    public PromptDefinitionInterface newPromptDefinition(AttributeDescriptorInterface ad, LoggerFactoryInterface factory, String promptDefinitionIDPrefix) {
        ValidateArg.notNull((Object)ad, (String)"AttributeDescriptorInterface");
        if (Strings.equal((String)"entityKey", (String)ad.getName(), (boolean)false, (boolean)false)) {
            return null;
        }
        PromptDefinitionInterface retVal = null;
        CommonLoggerInterface logger = LoggerRepository2.getLogger((String)EntityConverter.class.getName(), (LoggerFactoryInterface)factory);
        ParsedConfigurationXMLObject parsedObj = this.getParsedConfigurationXMLObject(ad);
        if (null != parsedObj) {
            logger.debug("Found configuration XML in: ", ad.getName());
        }
        if (null != (retVal = this.createPromptDefinition(ad, parsedObj, logger))) {
            if (logger.isDebugEnabled()) {
                logger.debug("Getting these properties from the attribute descriptor...");
                logger.debug("name:", ad.getName());
                logger.debug("visible:", Boolean.toString(ad.isVisible()));
                logger.debug("required:", Boolean.toString(ad.isRequired()));
            }
            if (retVal instanceof ComponentLogFactoryInterface) {
                ((ComponentLogFactoryInterface)retVal).setLoggerFactory(factory);
            }
            if (null != parsedObj && retVal instanceof MutableSelectableDefinitionInterface) {
                MutableSelectableDefinitionInterface msdi = (MutableSelectableDefinitionInterface)retVal;
                if (EntityConverter.isExplicitMinSetInAttributeDescriptor(parsedObj)) {
                    int min = EntityConverter.getExplicitMinSetInAttributeDescriptor(parsedObj);
                    msdi.setMinimumValueCount(min);
                    logger.debug("Set mininumValueCount to", String.valueOf(min));
                }
                if (EntityConverter.isExplicitMaxSetInAttributeDescriptor(parsedObj)) {
                    int max = EntityConverter.getExplicitMaxSetInAttributeDescriptor(parsedObj);
                    msdi.setMaximumValueCount(max);
                    logger.debug("Set maximumValueCount to", String.valueOf(max));
                }
            }
            if (retVal instanceof MutablePromptDefinitionInterface) {
                ((MutablePromptDefinitionInterface)retVal).setFixed(!ad.isModifiable());
                ((MutablePromptDefinitionInterface)retVal).setHidden(EntityConverter.visible2Hidden(ad.isVisible()));
                EntityConverter.copyByLocale(ad, (MutablePromptDefinitionInterface)retVal);
                ((MutablePromptDefinitionInterface)retVal).setPromptName(ad.getName());
            }
            if (retVal instanceof MutableSelectableDefinitionInterface) {
                if (ad.isRequired() && ((MutableSelectableDefinitionInterface)retVal).getMinimumValueCount() < 1) {
                    ((MutableSelectableDefinitionInterface)retVal).setMinimumValueCount(1);
                }
                if (null != parsedObj && ((MutableSelectableDefinitionInterface)retVal).getMaximumValueCount() == 1) {
                    boolean b = EntityHelper.isMultipleValuesAllowed(ad, parsedObj);
                    logger.debug("multiValuesAllowed:", Boolean.toString(b));
                    if (b) {
                        ((MutableSelectableDefinitionInterface)retVal).setMaximumValueCount(-1);
                    }
                }
            } else if (retVal instanceof ColorDefinition) {
                ((ColorDefinition)retVal).setRequired(ad.isRequired());
            } else if (retVal instanceof BaseDefinitionRange) {
                ((BaseDefinitionRange)retVal).setRequired(ad.isRequired());
            }
            if (ad.isDefaultValueHasBeenSet() && retVal instanceof MutablePromptDefinitionInterface) {
                logger.debug("SetDefaultValue to", ad.getDefault().toString());
                Object dv = EntityConverter.convertEntityValueToPromptValue(ad.getDefault());
                if (!(dv instanceof String) || ((String)dv).length() > 0) {
                    ((MutablePromptDefinitionInterface)retVal).setDefaultValue(dv);
                }
            }
            if (retVal instanceof MutablePromptDefinitionInterface) {
                MutableUserInfoInterface userInfo = ((MutablePromptDefinitionInterface)retVal).getMutableUserInfo();
                Map supProp = ad.getSupplementalProperties();
                if (supProp != null) {
                    for (String key : supProp.keySet()) {
                        Object value = supProp.get(key);
                        if (key.equals("SASEditorInstructionText")) {
                            if (!(retVal instanceof MutableHintableDefinitionInterface) || !(value instanceof String)) continue;
                            ((MutableHintableDefinitionInterface)retVal).setHint((String)value, Locale.getDefault());
                            continue;
                        }
                        if (key.equals("promptValueUpperCased")) {
                            if (!(retVal instanceof MutableTextDefinitionInterface) || !(value instanceof Boolean) || !((Boolean)value).booleanValue()) continue;
                            ArrayList<String> transforms = new ArrayList<String>();
                            transforms.add("UPPERCASE");
                            ((MutableTextDefinitionInterface)retVal).setValueTransforms(transforms);
                            continue;
                        }
                        if (key.equals("promptValuesDisplayFormatted")) {
                            if (!(retVal instanceof MutableValueProviderDefinitionInterface) || !(value instanceof Boolean)) continue;
                            continue;
                        }
                        if (key.equals("multiValueStructured")) {
                            if (!(retVal instanceof MutableSelectableDefinitionInterface) || !(value instanceof Boolean)) continue;
                            boolean multi = (Boolean)value;
                            if (!multi) {
                                ((MutableSelectableDefinitionInterface)retVal).setMaximumValueCount(1);
                                continue;
                            }
                            if (((MutableSelectableDefinitionInterface)retVal).getMaximumValueCount() != 1 && ((MutableSelectableDefinitionInterface)retVal).getMaximumValueCount() != 0 && ((MutableSelectableDefinitionInterface)retVal).getMaximumValueCount() >= -1) continue;
                            ((MutableSelectableDefinitionInterface)retVal).setMaximumValueCount(-1);
                            continue;
                        }
                        if (key.equals("IQ_Prompt_Type") && "IDENTITYDRIVEN".equals(value)) {
                            if (retVal instanceof MutableValueProviderDefinitionInterface) {
                                ValueProviderInterface vp = null;
                                try {
                                    Class<?> clazz = Class.forName("com.sas.prompts.valueprovider.dynamic.iq.IQIdentityValueProvider");
                                    vp = (ValueProviderInterface)clazz.newInstance();
                                }
                                catch (ClassNotFoundException e) {
                                    logger.error("Unable to load class com.sas.prompts.valueprovider.dynamic.iq.IQIdentityValueProvider.", (Throwable)e);
                                }
                                catch (InstantiationException e) {
                                    logger.error("Unable to load class com.sas.prompts.valueprovider.dynamic.iq.IQIdentityValueProvider.", (Throwable)e);
                                }
                                catch (IllegalAccessException e) {
                                    logger.error("Unable to load class com.sas.prompts.valueprovider.dynamic.iq.IQIdentityValueProvider.", (Throwable)e);
                                }
                                if (vp != null) {
                                    ((MutableValueProviderDefinitionInterface)retVal).setValueProvider(vp);
                                }
                            }
                            userInfo.put((String)value, " ");
                            continue;
                        }
                        if (value instanceof String) {
                            userInfo.put(key, (String)value);
                            continue;
                        }
                        if (!(value instanceof Boolean)) continue;
                        userInfo.put(key, ((Boolean)value).toString());
                    }
                }
            }
            if (null != parsedObj && retVal instanceof MutableValueProviderDefinitionInterface) {
                ValueProviderInterface vp;
                MutableValueProviderDefinitionInterface mvpdi = (MutableValueProviderDefinitionInterface)retVal;
                if (parsedObj.isEnumerationOthersAllowedSet()) {
                    mvpdi.setAllowUserValues(parsedObj.isEnumerationOthersAllowed());
                }
                if ((vp = this.createValueProvider(retVal, ad, parsedObj, logger)) != null) {
                    mvpdi.setValueProvider(vp);
                    if (!parsedObj.isEnumerationOthersAllowedSet()) {
                        mvpdi.setAllowUserValues(false);
                    }
                }
            }
        }
        if (retVal != null && promptDefinitionIDPrefix != null && retVal instanceof MutableIdentifiablePromptInterface) {
            ((MutableIdentifiablePromptInterface)retVal).setPromptID(promptDefinitionIDPrefix + retVal.getPromptName());
        }
        return retVal;
    }

    protected ParsedConfigurationXMLObject getParsedConfigurationXMLObject(AttributeDescriptorInterface ad) {
        String xml = ad.getConfigurationXML();
        if (null != xml) {
            ParsedConfigurationXMLObject parsedObj = ConfigurationXMLPersistenceUtility.createParsedConfigurationXMLObject(xml);
            return parsedObj;
        }
        return null;
    }

    protected int getSQLTypeForAttributeDescriptor(AttributeDescriptorInterface ad) {
        if (null != ad.getType()) {
            return ad.getType().getSQLType();
        }
        return -10000;
    }

    protected PromptDefinitionInterface createPromptDefinition(AttributeDescriptorInterface ad, ParsedConfigurationXMLObject parsedObj, CommonLoggerInterface logger) {
        DateDefinition retVal = null;
        int sql = this.getSQLTypeForAttributeDescriptor(ad);
        switch (sql) {
            case -1: 
            case 12: 
            case 16: {
                boolean isText = true;
                if (ad.getType() != null && ad.getType().getName() != null && ad.getType().getName().equals("Color")) {
                    isText = false;
                    retVal = new ColorDefinition();
                    logger.debug("Making ColorDefinition for:", ad.getName());
                }
                if (!isText) break;
                retVal = new TextDefinition();
                if (sql == -1) {
                    ((TextDefinition)retVal).setAllowMultipleLines(true);
                }
                logger.debug("Making TextDefinition for:", ad.getName());
                if (null != parsedObj) {
                    EntityConverter.convertXML2StandardText(parsedObj, (TextDefinition)retVal, logger);
                }
                if (sql != 16) break;
                ((TextDefinition)retVal).setValueProvider(this.getBooleanValueProvider());
                ((TextDefinition)retVal).setAllowUserValues(false);
                break;
            }
            case 91: {
                retVal = new DateDefinition();
                logger.debug("Making DateDefinition for:", ad.getName());
                break;
            }
            case 92: {
                retVal = new DateDefinition();
                retVal.setDateType(DateTypes.TIME);
                logger.debug("Making DateDefinition-Time for:", ad.getName());
                break;
            }
            case 93: {
                retVal = new DateDefinition();
                retVal.setDateType(DateTypes.TIMESTAMP);
                logger.debug("Making DateDefinition-Timestamp for:", ad.getName());
                break;
            }
            case 8: {
                retVal = new DoubleDefinition();
                logger.debug("Making DoubleDefinition for:", ad.getName());
                if (null == parsedObj || null == parsedObj.getNumericRange()) break;
                EntityConverter.convertXML2Double(parsedObj, (DoubleDefinition)retVal);
                break;
            }
            case 6: {
                logger.debug("Making DoubleDefinition for:", ad.getName());
                retVal = new DoubleDefinition();
                if (null == parsedObj || null == parsedObj.getNumericRange()) break;
                EntityConverter.convertXML2Double(parsedObj, (DoubleDefinition)retVal);
                break;
            }
            case 4: {
                logger.debug("Making IntegerDefinition for:", ad.getName());
                retVal = new IntegerDefinition();
                if (null == parsedObj || null == parsedObj.getIntegerRange()) break;
                EntityConverter.convertXML2Integer(parsedObj, (IntegerDefinition)retVal);
                break;
            }
        }
        return retVal;
    }

    private ValueProviderInterface getBooleanValueProvider() {
        if (booleanValueProvider == null) {
            booleanValueProvider = new StaticValueProvider();
            booleanValueProvider.setDataType((DataTypeInterface)StringType.DEFAULT_INSTANCE);
            Locale[] locales = new Locale[]{Locale.US, Locale.FRENCH, Locale.GERMAN, Locale.ITALIAN, new Locale("pl"), new Locale("es"), new Locale("ru"), new Locale("hu"), new Locale("cs"), new Locale("sv"), new Locale("tr"), Locale.SIMPLIFIED_CHINESE, Locale.TRADITIONAL_CHINESE, Locale.KOREAN, Locale.JAPANESE};
            for (int i = 0; i < locales.length; ++i) {
                ArrayList<ValueItem> values = new ArrayList<ValueItem>(2);
                String t = RB.getStringResource(RB_KEY, "true.txt", locales[i]);
                String f = RB.getStringResource(RB_KEY, "false.txt", locales[i]);
                values.add(new ValueItem((Object)t, (Object)"True"));
                values.add(new ValueItem((Object)f, (Object)"False"));
                booleanValueProvider.setValues(values, locales[i]);
            }
        }
        return booleanValueProvider;
    }

    static void copyByLocale(AttributeDescriptorInterface ad, MutablePromptDefinitionInterface prompt) {
        Map map = ad.getLabels();
        if (map.isEmpty()) {
            prompt.setPromptLabel(ad.getName(), null);
        } else {
            for (Locale locale : map.keySet()) {
                prompt.setPromptLabel((String)map.get(locale), locale);
            }
        }
        map = ad.getDescriptions();
        if (map.isEmpty()) {
            map = ad.getLabels();
            if (map.isEmpty()) {
                prompt.setPromptDescription(ad.getName(), null);
            } else {
                for (Locale locale : map.keySet()) {
                    prompt.setPromptDescription((String)map.get(locale), locale);
                }
            }
        } else {
            for (Locale locale : map.keySet()) {
                prompt.setPromptDescription((String)map.get(locale), locale);
            }
        }
    }

    static void copyByLocale(AttributeGroupInterface group, PromptGroup promptGroup) {
        Map map = group.getLabels();
        if (map.isEmpty()) {
            promptGroup.setPromptGroupLabel(group.getName(), null);
        } else {
            for (Locale locale : map.keySet()) {
                promptGroup.setPromptGroupLabel((String)map.get(locale), locale);
            }
        }
        map = group.getDescriptions();
        if (map.isEmpty()) {
            map = group.getLabels();
            if (map.isEmpty()) {
                promptGroup.setPromptGroupDescription(group.getName(), null);
            } else {
                for (Locale locale : map.keySet()) {
                    promptGroup.setPromptGroupDescription((String)map.get(locale), locale);
                }
            }
        } else {
            for (Locale locale : map.keySet()) {
                promptGroup.setPromptGroupDescription((String)map.get(locale), locale);
            }
        }
    }

    static boolean visible2Hidden(boolean visible) {
        return !visible;
    }

    PromptGroupInterface newGroup(AttributeGroupInterface attributeGroup, LoggerFactoryInterface factory, String promptDefinitionIDPrefix) {
        PromptGroup promptGroup = new PromptGroup();
        promptGroup.setPromptGroupHidden(EntityConverter.visible2Hidden(attributeGroup.isVisible()));
        EntityConverter.copyByLocale(attributeGroup, promptGroup);
        AttributeDescriptorInterface[] ad = attributeGroup.getAttributeDescriptors(false);
        promptGroup.addPromptDefinitions(this.descriptors2Definitions(ad, factory, promptDefinitionIDPrefix));
        return promptGroup;
    }

    public PromptGroupInterface newPromptGroup(RemoteEntityInterface entity, LoggerFactoryInterface factory) throws BackingStoreException {
        return this.newPromptGroup(entity, factory, null);
    }

    public PromptGroupInterface newPromptGroup(RemoteEntityInterface entity, LoggerFactoryInterface factory, String promptDefinitionIDPrefix) throws BackingStoreException {
        CommonLoggerInterface logger = LoggerRepository2.getLogger((String)EntityConverter.class.getName(), (LoggerFactoryInterface)factory);
        if (promptDefinitionIDPrefix == null) {
            try {
                promptDefinitionIDPrefix = entity.getEntityKey() + "_";
            }
            catch (RemoteException re) {
                logger.error(re.getLocalizedMessage(), (Throwable)re);
                throw new BackingStoreException(re);
            }
        }
        PromptGroupInterface retVal = null;
        AttributeGroupInterface agi = null;
        try {
            agi = entity.getAttributeGroup();
        }
        catch (RemoteException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new BackingStoreException(e);
        }
        logger.debug("Making groups for attribute root group named: ", agi.getName());
        DefaultTreeModel groups = EntityUtil.getAttributeGroupsTreeModel((AttributeGroupInterface)agi, (boolean)true, (boolean)true);
        PreorderTreeModelIterator it = new PreorderTreeModelIterator((TreeModel)groups);
        HashMap<String, PromptGroupInterface> map = new HashMap<String, PromptGroupInterface>();
        while (it.hasNext()) {
            AttributeGroupInterface parentGroup;
            PromptGroupInterface parent;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)it.next();
            AttributeGroupInterface currentGroup = (AttributeGroupInterface)node.getUserObject();
            logger.debug("Making prompt definition group for attribute group: ", currentGroup.getName());
            PromptGroupInterface pdg = this.newGroup(currentGroup, factory, promptDefinitionIDPrefix);
            map.put(currentGroup.getName(), pdg);
            DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)node.getParent();
            if (null == node2 || null == (parent = (PromptGroupInterface)map.get((parentGroup = (AttributeGroupInterface)node2.getUserObject()).getName()))) continue;
            parent.addPromptSubgroup(pdg);
            logger.debug("Added subgroup to parent group: ", parent.getPromptGroupLabel(Locale.getDefault()));
        }
        retVal = (PromptGroupInterface)map.get(agi.getName());
        map.clear();
        return retVal;
    }

    List descriptors2Definitions(AttributeDescriptorInterface[] adi, LoggerFactoryInterface factory, String promptDefinitionIDPrefix) {
        ArrayList<PromptDefinitionInterface> list = new ArrayList<PromptDefinitionInterface>();
        for (int i = 0; i < adi.length; ++i) {
            PromptDefinitionInterface p = this.newPromptDefinition(adi[i], factory, promptDefinitionIDPrefix);
            if (null == p) continue;
            list.add(p);
        }
        return list;
    }

    static void convertXML2Integer(ParsedConfigurationXMLObject parsedObject, IntegerDefinition pd) {
        if (parsedObject.isIntegerRangeMinimumSet()) {
            pd.setMinimum(parsedObject.getIntegerRangeMinimum());
        }
        if (parsedObject.isIntegerRangeMaximumSet()) {
            pd.setMaximum(parsedObject.getIntegerRangeMaximum());
        }
    }

    static void convertXML2Double(ParsedConfigurationXMLObject parsedObject, DoubleDefinition pd) {
        if (parsedObject.isNumericRangeMinimumSet()) {
            Number minimum = parsedObject.getNumericRangeMinimum();
            double minValue = minimum.doubleValue();
            if (minimum instanceof Float) {
                minValue = Double.parseDouble(Float.toString(minimum.floatValue()));
            }
            pd.setMinimum(minValue);
        }
        if (parsedObject.isNumericRangeMaximumSet()) {
            Number maximum = parsedObject.getNumericRangeMaximum();
            double maxValue = maximum.doubleValue();
            if (maximum instanceof Float) {
                maxValue = Double.parseDouble(Float.toString(maximum.floatValue()));
            }
            pd.setMaximum(maxValue);
        }
        SupportedSpecialValues specialValues = pd.getSupportedSpecialValues();
        specialValues.setMissingValuesSupported(true);
        specialValues.setMissingValuesHiddenIfSupported(true);
        pd.setSupportedSpecialValues(specialValues);
    }

    static void convertXML2StandardText(ParsedConfigurationXMLObject parsedObject, TextDefinition pd, CommonLoggerInterface logger) {
        Map stringLengthRangeMap = parsedObject.getStringLengthRange();
        if (stringLengthRangeMap != null) {
            Object i;
            if (stringLengthRangeMap.containsKey("max") && (i = stringLengthRangeMap.get("max")) instanceof Number) {
                pd.setMaximumLength(((Number)i).intValue());
                logger.debug("TextDefinition.setMaximumLength to", i.toString());
            }
            if (stringLengthRangeMap.containsKey("min") && (i = stringLengthRangeMap.get("min")) instanceof Number) {
                pd.setMinimumLength(((Number)i).intValue());
                logger.debug("TextDefinition.setMinimumLength to", i.toString());
            }
        }
    }

    public static ValueProviderInterface getValueProvider(AttributeDescriptorInterface ad, LoggerFactoryInterface factory) {
        CommonLoggerInterface logger = LoggerRepository2.getLogger((String)EntityConverter.class.getName(), (LoggerFactoryInterface)factory);
        ParsedConfigurationXMLObject parsedObj = DEFAULT_INSTANCE.getParsedConfigurationXMLObject(ad);
        if (parsedObj != null) {
            logger.debug("Found configuration XML in: ", ad.getName());
            return DEFAULT_INSTANCE.createValueProvider(null, ad, parsedObj, logger);
        }
        return null;
    }

    protected ValueProviderInterface createValueProvider(AttributeDescriptorInterface ad, ParsedConfigurationXMLObject parsedObject, CommonLoggerInterface logger) {
        return this.createValueProvider(ad, parsedObject, logger);
    }

    protected ValueProviderInterface createValueProvider(PromptDefinitionInterface newPrompt, AttributeDescriptorInterface ad, ParsedConfigurationXMLObject parsedObject, CommonLoggerInterface logger) {
        List eItems = parsedObject.getEnumerationItems();
        if (null != eItems) {
            StaticValueProvider provider = new StaticValueProvider();
            if (newPrompt != null) {
                StringType dataType = StringType.DEFAULT_INSTANCE;
                dataType = newPrompt.getPromptDataType();
                while (dataType instanceof CollectionType) {
                    dataType = ((CollectionType)dataType).getTypeOfData();
                }
                provider.setDataType((DataTypeInterface)dataType);
            }
            HashMap values = new HashMap();
            for (EnumerationItem eItem : eItems) {
                if (eItem == null) continue;
                Object eItemValue = eItem.getValue();
                try {
                    eItemValue = provider.getDataType().coerceValue(eItemValue, Locale.US);
                }
                catch (IllegalArgumentException ex) {
                    logger.info(ex.getMessage());
                    continue;
                }
                ArrayList<String> alreadyQualifiedLabels = new ArrayList<String>();
                Map labels = eItem.getTextLabels();
                if (labels != null && !labels.isEmpty()) {
                    Set entries = labels.entrySet();
                    for (Map.Entry entry : entries) {
                        ValueItem valueItem = new ValueItem(entry.getValue(), eItemValue);
                        if (values.containsKey(entry.getKey())) {
                            List valueItemList = (List)values.get(entry.getKey());
                            String valueItemLabel = valueItem.getLabel();
                            if (alreadyQualifiedLabels.contains(valueItemLabel)) {
                                valueItem.setLabel(valueItem.getLabel() + " [" + valueItem.getValueAsString() + "]");
                            } else if (valueItemLabel != null) {
                                for (ValueItem valueItemToCheck : valueItemList) {
                                    if (valueItemToCheck.getLabel() == null || !valueItemToCheck.getLabel().equals(valueItem.getLabel())) continue;
                                    alreadyQualifiedLabels.add(valueItem.getLabel());
                                    valueItemToCheck.setLabel(valueItemToCheck.getLabel() + " [" + valueItemToCheck.getValueAsString() + "]");
                                    valueItem.setLabel(valueItem.getLabel() + " [" + valueItem.getValueAsString() + "]");
                                    break;
                                }
                            }
                            valueItemList.add(valueItem);
                            logger.debug("Set a ValueItem of", valueItem.toString());
                            continue;
                        }
                        ArrayList<ValueItem> list = new ArrayList<ValueItem>(1);
                        list.add(valueItem);
                        values.put(entry.getKey(), list);
                    }
                    continue;
                }
                Object textLabel = eItem.getTextLabel();
                if (textLabel != null) {
                    textLabel = eItem.getValue();
                }
                ValueItem valueItem = new ValueItem(textLabel, eItemValue);
                logger.debug("Set a ValueItem of", valueItem.toString());
                if (values.containsKey(null)) {
                    ((List)values.get(null)).add(valueItem);
                    continue;
                }
                ArrayList<ValueItem> list = new ArrayList<ValueItem>();
                list.add(valueItem);
                values.put(null, list);
            }
            Set valueSet = values.entrySet();
            for (Map.Entry entry : valueSet) {
                Locale locale = (Locale)entry.getKey();
                if (locale == null) {
                    locale = Locale.getDefault();
                }
                provider.setValues((List)entry.getValue(), locale);
                if (newPrompt == null) continue;
                try {
                    PromptUtil.removeInvalidValuesInStaticValueProvider((StaticValueProvider)provider, null, (PromptDefinitionInterface)newPrompt, (CommonLoggerInterface)logger, (Locale)locale);
                    if (!newPrompt.isDefaultValueSet() || !(newPrompt instanceof MutablePromptDefinitionInterface) || !(newPrompt instanceof AllowUserValuesInterface) || ((AllowUserValuesInterface)newPrompt).isAllowUserValues()) continue;
                    List vals = (List)provider.getValues(locale);
                    Object dv = newPrompt.getDefaultValue();
                    if (dv instanceof Collection) {
                        Collection col = (Collection)dv;
                        ArrayList newDv = new ArrayList();
                        boolean update = false;
                        for (Object element : col) {
                            if (!this.valueItemListContainsOneValue(provider.getDataType(), vals, element, locale)) {
                                update = true;
                                continue;
                            }
                            newDv.add(element);
                        }
                        if (!update) continue;
                        ((MutablePromptDefinitionInterface)newPrompt).setDefaultValue(newDv);
                        continue;
                    }
                    if (this.valueItemListContainsOneValue(provider.getDataType(), vals, dv, locale)) continue;
                    newPrompt.clearDefaultValue();
                }
                catch (ValueProviderException ex) {
                    if (logger == null) continue;
                    logger.error(ex.getLocalizedMessage(), (Throwable)ex);
                }
            }
            return provider;
        }
        return null;
    }

    private boolean valueItemListContainsOneValue(DataTypeInterface dataType, List values, Object value, Locale locale) {
        for (ValueItem item : values) {
            Object itemValue = item.getValue();
            if (!PromptUtil.isPromptValuesEqual((Object)(itemValue = dataType.coerceValue(itemValue, locale)), (Object)value, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    static boolean isExplicitMaxSetInAttributeDescriptor(ParsedConfigurationXMLObject configObj) {
        Map rangeMap = configObj.getSelectionRange();
        if (rangeMap == null) {
            return false;
        }
        Object maxCandidate = rangeMap.get("max");
        return maxCandidate instanceof Number;
    }

    static int getExplicitMaxSetInAttributeDescriptor(ParsedConfigurationXMLObject configObj) {
        Map rangeMap = configObj.getSelectionRange();
        if (rangeMap == null) {
            return -1;
        }
        Object maxCandidate = rangeMap.get("max");
        if (maxCandidate instanceof Number) {
            return ((Number)maxCandidate).intValue();
        }
        return -1;
    }

    static boolean isExplicitMinSetInAttributeDescriptor(ParsedConfigurationXMLObject configObj) {
        Map rangeMap = configObj.getSelectionRange();
        if (rangeMap == null) {
            return false;
        }
        Object minCandidate = rangeMap.get("min");
        return minCandidate instanceof Number;
    }

    static int getExplicitMinSetInAttributeDescriptor(ParsedConfigurationXMLObject configObj) {
        Map rangeMap = configObj.getSelectionRange();
        if (rangeMap == null) {
            return -1;
        }
        Object minCandidate = rangeMap.get("min");
        if (minCandidate instanceof Number) {
            return ((Number)minCandidate).intValue();
        }
        return -1;
    }

    public PromptValuesInterface newPromptValues(RemoteEntityInterface entity, LoggerFactoryInterface factory) throws BackingStoreException {
        return this.newPromptValues(entity, factory, null);
    }

    public PromptValuesInterface newPromptValues(RemoteEntityInterface entity, LoggerFactoryInterface factory, String promptDefinitionIDPrefix) throws BackingStoreException {
        PromptGroupInterface promptGroup = this.newPromptGroup(entity, factory, promptDefinitionIDPrefix);
        CommonLoggerInterface logger = LoggerRepository2.getLogger((String)EntityConverter.class.getName(), (LoggerFactoryInterface)factory);
        PromptValues promptValues = new PromptValues(promptGroup, null);
        try {
            String[] entityAttributeNames = entity.listAttributeNames();
            int n = entityAttributeNames.length;
            for (int i = 0; i < n; ++i) {
                if (!entity.isAttributeAssigned(entityAttributeNames[i])) continue;
                Object entityAttributeValue = entity.getAttribute(entityAttributeNames[i]);
                PromptDefinitionInterface promptDef = promptGroup.getPromptDefinition(entityAttributeNames[i], true);
                promptValues.setPromptValue(promptDef, EntityConverter.convertEntityValueToPromptValue(entityAttributeValue));
            }
        }
        catch (RemoteException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new BackingStoreException(e);
        }
        catch (InvalidPromptValueException ipve) {
            logger.error(ipve.getLocalizedMessage(), (Throwable)ipve);
            throw new BackingStoreException(ipve);
        }
        return promptValues;
    }

    private static Object convertEntityValueToPromptValue(Object value) {
        if (value instanceof Boolean) {
            if (value.equals(Boolean.TRUE)) {
                return "True";
            }
            return "False";
        }
        if (value instanceof Float) {
            if (value.equals(new Float(Float.NEGATIVE_INFINITY))) {
                return new Double(-1.7976931348623157E308);
            }
            if (value.equals(new Float(Float.POSITIVE_INFINITY))) {
                return new Double(Double.MAX_VALUE);
            }
            if (Float.isNaN(((Float)value).floatValue())) {
                return MissingValues.Dot;
            }
            return new Double(Double.parseDouble(value.toString()));
        }
        return value;
    }
}

