/*
 * Decompiled with CFR 0.152.
 */
package com.sas.entities.persist;

import com.sas.codepolicy.SASScope;
import com.sas.entities.edit.models.providers.DynamicValuesHandlerInterface;
import com.sas.entities.edit.models.providers.DynamicValuesProviderInterface;
import com.sas.entities.edit.models.providers.ProviderNotFoundProvider;
import com.sas.entities.persist.DOMDOCException;
import com.sas.entities.persist.DOMDoc;
import com.sas.entities.persist.EnumerationItem;
import com.sas.entities.persist.ParsedConfigurationXMLObject;
import com.sas.entities.persist.PersistenceUtil;
import com.sas.entities.persist.RB;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@SASScope(value="ALL")
public class ConfigurationXMLPersistenceUtility {
    static String versionNumber;
    static HashMap enumerationOptions;
    private static char[] xmlSpecial;
    private static String[] xmlReplacements;
    public static final String ENUMERATION = "Enumeration";
    public static final String ENUMERATION_OPTIONS = "EnumerationOptions";
    public static final String ENUMERATION_MINIMUM_SELECTIONS = "EnumerationMinimumSelections";
    public static final String ENUMERATION_MAXIMUM_SELECTIONS = "EnumerationMaximumSelections";
    public static final String ENUMERATION_OTHERS_ALLOWED = "isOthersAllowed";
    public static final String SELECTION_RANGE = "SelectionRange";
    public static final String INTEGER_RANGE = "IntegerRange";
    public static final String NUMERIC_RANGE = "NumericRange";
    public static final String CLASS_TYPE = "classType";
    public static final String RANGE_INCREMENT = "increment";
    public static final String MINIMUM = "min";
    public static final String MINIMUM_EXCLUSIVE = "minExclusive";
    public static final String MAXIMUM = "max";
    public static final String MAXIMUM_EXCLUSIVE = "maxExclusive";
    public static final String STRING_LENGTH_RANGE = "StringLengthRange";
    private static final String CONFIGURATION = "Configuration";
    private static final String VALUE = "Value";
    private static final String TEXT = "Text";
    public static final String DYNAMIC_VALUES = "DynamicValues";

    public static String writeConfigurationXML(Map dataTypesMap) {
        Object xmlString = null;
        versionNumber = PersistenceUtil.version_9_1;
        DOMDoc domDoc = new DOMDoc();
        domDoc.newDocument(false);
        Element configuration = domDoc.createElement(CONFIGURATION);
        domDoc.appendChild(configuration);
        Attr entityVersion = domDoc.createAttribute("version");
        configuration.setAttributeNode(entityVersion);
        Set keySet = dataTypesMap.keySet();
        Iterator iter = keySet.iterator();
        Element enumerationElement = null;
        while (iter.hasNext()) {
            String elementName = (String)iter.next();
            Element eachElement = domDoc.createElement(elementName);
            configuration.appendChild(eachElement);
            if (elementName.equals(ENUMERATION)) {
                boolean haveEnumerationOptions;
                enumerationElement = eachElement;
                Object type = dataTypesMap.get(elementName);
                boolean bl = haveEnumerationOptions = enumerationOptions.size() > 0;
                if (haveEnumerationOptions && enumerationOptions.containsKey(ENUMERATION_OTHERS_ALLOWED)) {
                    Boolean othersAllowedValue = (Boolean)enumerationOptions.get(ENUMERATION_OTHERS_ALLOWED);
                    Attr othersAllowed = domDoc.createAttribute(ENUMERATION_OTHERS_ALLOWED);
                    eachElement.setAttributeNode(othersAllowed);
                    othersAllowed.setValue(othersAllowedValue.toString());
                }
                if (type instanceof List) {
                    ConfigurationXMLPersistenceUtility.writeEnumerationElement(domDoc, eachElement, (List)dataTypesMap.get(elementName));
                } else if (type instanceof Map) {
                    ConfigurationXMLPersistenceUtility.writeEnumerationElement(domDoc, eachElement, (Map)dataTypesMap.get(elementName));
                } else if (type instanceof Node) {
                    ConfigurationXMLPersistenceUtility.writeDynamicValuesElement(domDoc, eachElement, (Node)dataTypesMap.get(elementName));
                    if (!versionNumber.equals(PersistenceUtil.getLatestVersionNumber())) {
                        versionNumber = PersistenceUtil.version_9_1_SP2;
                    }
                }
                if (enumerationOptions.size() > 0 && enumerationOptions.containsKey(SELECTION_RANGE)) {
                    if (!versionNumber.equals(PersistenceUtil.getLatestVersionNumber())) {
                        versionNumber = ConfigurationXMLPersistenceUtility.determineVersionNumberFromSelectionRangeSetting();
                    }
                    ConfigurationXMLPersistenceUtility.writeSelectionRangeElement(domDoc, eachElement);
                }
                ConfigurationXMLPersistenceUtility.setEnumerationOptions(enumerationOptions);
                continue;
            }
            if (elementName.equals(INTEGER_RANGE)) {
                ConfigurationXMLPersistenceUtility.writeIntegerRangeElement(domDoc, eachElement, (Map)dataTypesMap.get(elementName));
                continue;
            }
            if (elementName.equals(NUMERIC_RANGE)) {
                ConfigurationXMLPersistenceUtility.writeNumericRangeElement(domDoc, eachElement, (Map)dataTypesMap.get(elementName));
                continue;
            }
            if (!elementName.equals(STRING_LENGTH_RANGE)) continue;
            ConfigurationXMLPersistenceUtility.writeIntegerRangeElement(domDoc, eachElement, (Map)dataTypesMap.get(elementName));
        }
        entityVersion.setValue(versionNumber);
        StringWriter stringWriter = new StringWriter();
        domDoc.writeDocument(stringWriter, true);
        return stringWriter.toString();
    }

    public static void write(ParsedConfigurationXMLObject parsedObject, Node parentNode) {
        Map dataTypesMap = ConfigurationXMLPersistenceUtility.createConfigurationMap(parsedObject);
        versionNumber = PersistenceUtil.version_9_1;
        Document domDoc = parentNode.getOwnerDocument();
        Element configuration = domDoc.createElement(CONFIGURATION);
        parentNode.appendChild(configuration);
        Attr entityVersion = domDoc.createAttribute("version");
        configuration.setAttributeNode(entityVersion);
        Set keySet = dataTypesMap.keySet();
        Iterator iter = keySet.iterator();
        Element enumerationElement = null;
        while (iter.hasNext()) {
            String elementName = (String)iter.next();
            Element eachElement = domDoc.createElement(elementName);
            configuration.appendChild(eachElement);
            if (elementName.equals(ENUMERATION)) {
                boolean haveEnumerationOptions;
                enumerationElement = eachElement;
                Object type = dataTypesMap.get(elementName);
                boolean bl = haveEnumerationOptions = enumerationOptions.size() > 0;
                if (haveEnumerationOptions && enumerationOptions.containsKey(ENUMERATION_OTHERS_ALLOWED)) {
                    Boolean othersAllowedValue = (Boolean)enumerationOptions.get(ENUMERATION_OTHERS_ALLOWED);
                    Attr othersAllowed = domDoc.createAttribute(ENUMERATION_OTHERS_ALLOWED);
                    eachElement.setAttributeNode(othersAllowed);
                    othersAllowed.setValue(othersAllowedValue.toString());
                }
                if (type instanceof List) {
                    ConfigurationXMLPersistenceUtility.writeEnumerationElement(domDoc, eachElement, (List)dataTypesMap.get(elementName), false);
                } else if (type instanceof Map) {
                    ConfigurationXMLPersistenceUtility.writeEnumerationElement(domDoc, eachElement, (Map)dataTypesMap.get(elementName), false);
                } else if (type instanceof Node) {
                    ConfigurationXMLPersistenceUtility.writeDynamicValuesElement(domDoc, eachElement, (Node)dataTypesMap.get(elementName));
                    versionNumber = PersistenceUtil.getLatestVersionNumber(versionNumber, PersistenceUtil.version_9_1_SP2);
                }
                if (enumerationOptions.size() > 0 && enumerationOptions.containsKey(SELECTION_RANGE)) {
                    if (!versionNumber.equals(PersistenceUtil.getLatestVersionNumber())) {
                        versionNumber = ConfigurationXMLPersistenceUtility.determineVersionNumberFromSelectionRangeSetting();
                    }
                    ConfigurationXMLPersistenceUtility.writeSelectionRangeElement(domDoc, eachElement);
                }
                ConfigurationXMLPersistenceUtility.setEnumerationOptions(enumerationOptions);
                continue;
            }
            if (elementName.equals(INTEGER_RANGE)) {
                ConfigurationXMLPersistenceUtility.writeIntegerRangeElement(domDoc, eachElement, (Map)dataTypesMap.get(elementName));
                continue;
            }
            if (elementName.equals(NUMERIC_RANGE)) {
                ConfigurationXMLPersistenceUtility.writeNumericRangeElement(domDoc, eachElement, (Map)dataTypesMap.get(elementName));
                continue;
            }
            if (!elementName.equals(STRING_LENGTH_RANGE)) continue;
            ConfigurationXMLPersistenceUtility.writeIntegerRangeElement(domDoc, eachElement, (Map)dataTypesMap.get(elementName));
        }
        entityVersion.setValue(versionNumber);
    }

    public static String writeConfigurationXML(ParsedConfigurationXMLObject parsedObject) {
        Map numericRange;
        Map integerRange;
        Map stringLengthRangeMap;
        HashMap<String, Object> configDataMap = new HashMap<String, Object>();
        if (parsedObject.hasEnumeration()) {
            Map selectionRange;
            if (parsedObject.hasLocalizedLabels()) {
                HashMap<Object, Map> localizedValuesMap = new HashMap<Object, Map>();
                List enumItemList = parsedObject.getEnumerationItems();
                int enumItemListLength = enumItemList.size();
                for (int i = 0; i < enumItemListLength; ++i) {
                    EnumerationItem enumItem = (EnumerationItem)enumItemList.get(i);
                    localizedValuesMap.put(enumItem.getValue(), enumItem.getTextLabels());
                }
                configDataMap.put(ENUMERATION, localizedValuesMap);
            } else if (parsedObject.hasUniqueTextLabels(null)) {
                Map valuesLabelsMap = parsedObject.getEnumerationValuesLabelsMap(null);
                configDataMap.put(ENUMERATION, valuesLabelsMap);
            } else {
                List valuesList = parsedObject.getEnumerationValues();
                configDataMap.put(ENUMERATION, valuesList);
            }
            HashMap<String, Object> optionsMap = null;
            boolean isAttributeSet = parsedObject.isEnumerationOthersAllowedSet();
            if (isAttributeSet) {
                boolean attributeValue = parsedObject.isEnumerationOthersAllowed();
                optionsMap = new HashMap<String, Object>();
                optionsMap.put(ENUMERATION_OTHERS_ALLOWED, new Boolean(attributeValue));
            }
            if ((selectionRange = parsedObject.getSelectionRange()) != null) {
                if (optionsMap == null) {
                    optionsMap = new HashMap();
                }
                optionsMap.put(SELECTION_RANGE, selectionRange);
            }
            if (optionsMap != null) {
                ConfigurationXMLPersistenceUtility.setEnumerationOptions(optionsMap);
            }
        }
        if ((stringLengthRangeMap = parsedObject.getStringLengthRange()) != null) {
            HashMap stringLengthRange = new HashMap();
            if (stringLengthRangeMap.containsKey(MINIMUM)) {
                stringLengthRange.put(MINIMUM, stringLengthRangeMap.get(MINIMUM));
            }
            if (stringLengthRangeMap.containsKey(MAXIMUM)) {
                stringLengthRange.put(MAXIMUM, stringLengthRangeMap.get(MAXIMUM));
            }
            if (configDataMap == null) {
                configDataMap = new HashMap();
            }
            configDataMap.put(STRING_LENGTH_RANGE, stringLengthRange);
        }
        if ((integerRange = parsedObject.getIntegerRange()) != null) {
            HashMap<String, Integer> intRange = new HashMap<String, Integer>();
            if (parsedObject.isIntegerRangeMinimumSet()) {
                intRange.put(MINIMUM, new Integer(parsedObject.getIntegerRangeMinimum()));
            }
            if (parsedObject.isIntegerRangeMaximumSet()) {
                intRange.put(MAXIMUM, new Integer(parsedObject.getIntegerRangeMaximum()));
            }
            if (parsedObject.isIntegerRangeIncrementSet()) {
                intRange.put(RANGE_INCREMENT, new Integer(parsedObject.getIntegerRangeIncrement()));
            }
            if (configDataMap == null) {
                configDataMap = new HashMap();
            }
            configDataMap.put(INTEGER_RANGE, intRange);
        }
        if ((numericRange = parsedObject.getNumericRange()) != null) {
            HashMap<String, Number> numRange = new HashMap<String, Number>();
            if (parsedObject.isNumericRangeMinimumSet()) {
                Number minimum = parsedObject.getNumericRangeMinimum();
                if (parsedObject.isNumericRangeMinimumExclusive()) {
                    if (minimum instanceof Float) {
                        numRange.put(MINIMUM_EXCLUSIVE, (Float)minimum);
                    } else {
                        numRange.put(MINIMUM_EXCLUSIVE, (Double)minimum);
                    }
                } else if (minimum instanceof Float) {
                    numRange.put(MINIMUM, (Float)minimum);
                } else {
                    numRange.put(MINIMUM, (Double)minimum);
                }
            }
            if (parsedObject.isNumericRangeMaximumSet()) {
                Number maximum = parsedObject.getNumericRangeMaximum();
                if (parsedObject.isNumericRangeMinimumExclusive()) {
                    if (maximum instanceof Float) {
                        numRange.put(MAXIMUM_EXCLUSIVE, (Float)maximum);
                    } else {
                        numRange.put(MAXIMUM_EXCLUSIVE, (Double)maximum);
                    }
                } else if (maximum instanceof Float) {
                    numRange.put(MAXIMUM, (Float)maximum);
                } else {
                    numRange.put(MAXIMUM, (Double)maximum);
                }
            }
            if (parsedObject.isNumericRangeIncrementSet()) {
                Number increment = parsedObject.getNumericRangeIncrement();
                if (increment instanceof Float) {
                    numRange.put(RANGE_INCREMENT, (Float)increment);
                } else {
                    numRange.put(RANGE_INCREMENT, (Double)increment);
                }
            }
            if (configDataMap == null) {
                configDataMap = new HashMap();
            }
            configDataMap.put(NUMERIC_RANGE, numRange);
        }
        return ConfigurationXMLPersistenceUtility.writeConfigurationXML(configDataMap);
    }

    protected static void writeEnumerationElement(DOMDoc domDoc, Element eachElement, Map valuesMap) {
        ConfigurationXMLPersistenceUtility.writeEnumerationElement((Document)domDoc, eachElement, valuesMap, true);
    }

    protected static void writeEnumerationElement(Document domDoc, Element eachElement, Map valuesMap, boolean escapeChars) {
        Iterator iter = valuesMap.keySet().iterator();
        Element value = null;
        boolean foundClassType = false;
        boolean haveSetClassType = false;
        while (iter.hasNext()) {
            Object o;
            Object omapValue = iter.next();
            String mapValue = null;
            if (omapValue != null) {
                mapValue = omapValue.toString();
            }
            if ((o = valuesMap.get(mapValue)) instanceof Map) {
                PersistenceUtil.writeLocaleSensitiveElement(domDoc, eachElement, mapValue, (Map)valuesMap.get(mapValue), null, true);
                continue;
            }
            value = domDoc.createElement(VALUE);
            eachElement.appendChild(value);
            Attr name = domDoc.createAttribute("name");
            value.setAttributeNode(name);
            if (omapValue instanceof Time || omapValue instanceof Timestamp) {
                Date date = (Date)omapValue;
                name.setValue(new Long(date.getTime()).toString());
                foundClassType = true;
            } else if (omapValue instanceof String && escapeChars) {
                name.setValue(PersistenceUtil.replaceStringsWithSpecialChars(mapValue));
            } else {
                name.setValue(mapValue);
            }
            if (foundClassType && !haveSetClassType) {
                Attr rClassType = domDoc.createAttribute(CLASS_TYPE);
                eachElement.setAttributeNode(rClassType);
                rClassType.setValue(omapValue.getClass().getName());
                haveSetClassType = true;
            }
            Element textElement = domDoc.createElement(TEXT);
            value.appendChild(textElement);
            Text textNode = null;
            textNode = escapeChars ? domDoc.createTextNode(PersistenceUtil.replaceStringsWithSpecialChars((String)valuesMap.get(omapValue))) : domDoc.createTextNode((String)valuesMap.get(omapValue));
            textElement.appendChild(textNode);
        }
    }

    protected static void writeSelectionRangeElement(DOMDoc domDoc, Element enumerationElement) {
        Element selectionRange = domDoc.createElement(SELECTION_RANGE);
        enumerationElement.appendChild(selectionRange);
        Object selectionValue = null;
        if (enumerationOptions.containsKey(SELECTION_RANGE)) {
            Map rangeOptions = (Map)enumerationOptions.get(SELECTION_RANGE);
            ConfigurationXMLPersistenceUtility.writeIntegerRangeElement(domDoc, selectionRange, rangeOptions);
        }
    }

    protected static void writeSelectionRangeElement(Document domDoc, Element enumerationElement) {
        Element selectionRange = domDoc.createElement(SELECTION_RANGE);
        enumerationElement.appendChild(selectionRange);
        Object selectionValue = null;
        if (enumerationOptions.containsKey(SELECTION_RANGE)) {
            Map rangeOptions = (Map)enumerationOptions.get(SELECTION_RANGE);
            ConfigurationXMLPersistenceUtility.writeIntegerRangeElement(domDoc, selectionRange, rangeOptions);
        }
    }

    private static String determineVersionNumberFromSelectionRangeSetting() {
        if (enumerationOptions.containsKey(SELECTION_RANGE)) {
            Map rangeOptions = (Map)enumerationOptions.get(SELECTION_RANGE);
            if (rangeOptions == null || rangeOptions.size() == 0) {
                versionNumber = PersistenceUtil.getLatestVersionNumber(versionNumber, PersistenceUtil.version_9_1_SP2);
            } else if (rangeOptions.containsKey(MAXIMUM)) {
                Integer maxSel = (Integer)rangeOptions.get(MAXIMUM);
                if (!(maxSel != null && maxSel <= 1 || versionNumber.equals(PersistenceUtil.getLatestVersionNumber()))) {
                    versionNumber = PersistenceUtil.getLatestVersionNumber(versionNumber, PersistenceUtil.version_9_1_SP2);
                }
            } else if (!versionNumber.equals(PersistenceUtil.getLatestVersionNumber())) {
                versionNumber = PersistenceUtil.version_9_1_SP2;
            }
        }
        return versionNumber;
    }

    protected static void writeEnumerationElement(DOMDoc domDoc, Element eachElement, List valuesList) {
        ConfigurationXMLPersistenceUtility.writeEnumerationElement((Document)domDoc, eachElement, valuesList, true);
    }

    protected static void writeEnumerationElement(Document domDoc, Element eachElement, List valuesList, boolean escapeChars) {
        int listSize = valuesList.size();
        Object listValue = null;
        Element value = null;
        for (int i = 0; i < listSize; ++i) {
            listValue = valuesList.get(i);
            value = domDoc.createElement(VALUE);
            eachElement.appendChild(value);
            Attr name = domDoc.createAttribute("name");
            value.setAttributeNode(name);
            if (listValue == null) {
                name.setValue(null);
                continue;
            }
            if (listValue instanceof String) {
                if (escapeChars) {
                    name.setValue(PersistenceUtil.replaceStringsWithSpecialChars((String)listValue));
                    continue;
                }
                name.setValue((String)listValue);
                continue;
            }
            boolean foundClassType = false;
            boolean haveSetClassType = false;
            Class<?> listValueClass = listValue.getClass();
            if (listValue instanceof Integer) {
                Integer intValue = (Integer)listValue;
                name.setValue(intValue.toString());
                foundClassType = true;
            } else if (listValue instanceof Float) {
                Float floatValue = (Float)listValue;
                name.setValue(floatValue.toString());
                foundClassType = true;
            } else if (listValue instanceof Time || listValue instanceof Timestamp) {
                Date date = (Date)listValue;
                name.setValue(new Long(date.getTime()).toString());
                foundClassType = true;
                versionNumber = PersistenceUtil.version_9_1_SP4;
            }
            if (!foundClassType || haveSetClassType) continue;
            Attr rClassType = domDoc.createAttribute(CLASS_TYPE);
            eachElement.setAttributeNode(rClassType);
            rClassType.setValue(listValueClass.getName());
            haveSetClassType = true;
        }
    }

    protected static void writeDynamicValuesElement(DOMDoc domDoc, Element eachElement, Node dynamicValuesNode) {
        Node importNode = domDoc.importNode(dynamicValuesNode.getFirstChild(), true);
        eachElement.appendChild(importNode);
    }

    protected static void writeDynamicValuesElement(Document domDoc, Element eachElement, Node dynamicValuesNode) {
        Node importNode = domDoc.importNode(dynamicValuesNode.getFirstChild(), true);
        eachElement.appendChild(importNode);
    }

    protected static void writeIntegerRangeElement(DOMDoc domDoc, Element rangeElement, Map valuesMap) {
        ConfigurationXMLPersistenceUtility.writeIntegerRangeElement((Document)domDoc, rangeElement, valuesMap);
    }

    protected static void writeIntegerRangeElement(Document domDoc, Element rangeElement, Map valuesMap) {
        Set keySet = valuesMap.keySet();
        for (String rangePoint : keySet) {
            if (!ConfigurationXMLPersistenceUtility.isValidKeyWord(rangePoint)) {
                throw new IllegalArgumentException();
            }
            Integer rangeValue = (Integer)valuesMap.get(rangePoint);
            Attr rPoint = domDoc.createAttribute(rangePoint);
            rangeElement.setAttributeNode(rPoint);
            rPoint.setValue(rangeValue.toString());
        }
    }

    protected static boolean isValidKeyWord(String value) {
        if (value.equals(RANGE_INCREMENT)) {
            return true;
        }
        if (value.equals(MINIMUM)) {
            return true;
        }
        if (value.equals(MINIMUM_EXCLUSIVE)) {
            return true;
        }
        if (value.equals(MAXIMUM)) {
            return true;
        }
        return value.equals(MAXIMUM_EXCLUSIVE);
    }

    protected static void writeNumericRangeElement(DOMDoc domDoc, Element rangeElement, Map valuesMap) {
        boolean haveSetNumericType = false;
        Set keySet = valuesMap.keySet();
        for (String rangePoint : keySet) {
            if (!ConfigurationXMLPersistenceUtility.isValidKeyWord(rangePoint)) {
                throw new IllegalArgumentException();
            }
            if (!haveSetNumericType) {
                Object o = valuesMap.get(rangePoint);
                Class<?> c = o.getClass();
                Number rangeValue = (Number)valuesMap.get(rangePoint);
                Attr rClassType = domDoc.createAttribute(CLASS_TYPE);
                rangeElement.setAttributeNode(rClassType);
                rClassType.setValue(c.getName());
                haveSetNumericType = true;
            }
            Number rangeValue = (Number)valuesMap.get(rangePoint);
            Attr rPoint = domDoc.createAttribute(rangePoint);
            rangeElement.setAttributeNode(rPoint);
            rPoint.setValue(rangeValue.toString());
        }
    }

    protected static void writeNumericRangeElement(Document domDoc, Element rangeElement, Map valuesMap) {
        boolean haveSetNumericType = false;
        Set keySet = valuesMap.keySet();
        for (String rangePoint : keySet) {
            if (!ConfigurationXMLPersistenceUtility.isValidKeyWord(rangePoint)) {
                throw new IllegalArgumentException();
            }
            if (!haveSetNumericType) {
                Object o = valuesMap.get(rangePoint);
                Class<?> c = o.getClass();
                Number rangeValue = (Number)valuesMap.get(rangePoint);
                Attr rClassType = domDoc.createAttribute(CLASS_TYPE);
                rangeElement.setAttributeNode(rClassType);
                rClassType.setValue(c.getName());
                haveSetNumericType = true;
            }
            Number rangeValue = (Number)valuesMap.get(rangePoint);
            Attr rPoint = domDoc.createAttribute(rangePoint);
            rangeElement.setAttributeNode(rPoint);
            rPoint.setValue(rangeValue.toString());
        }
    }

    public static ParsedConfigurationXMLObject createParsedConfigurationXMLObject(String docString) {
        return ConfigurationXMLPersistenceUtility.createParsedConfigurationXMLObject(docString, null);
    }

    public static ParsedConfigurationXMLObject createParsedConfigurationXMLObject(String docString, Map dvHandlers) {
        ParsedConfigurationXMLObject parsedObject = null;
        try {
            if (docString == null) {
                throw new DOMDOCException(RB.getStringResource("emptyXML.ex.txt"));
            }
            byte[] xmlBytes = docString.getBytes("UTF-8");
            if (xmlBytes == null || xmlBytes.length == 0) {
                throw new DOMDOCException(RB.getStringResource("emptyXML.ex.txt"));
            }
            DOMDoc doc = new DOMDoc();
            try {
                boolean bl = doc.loadDocument(new ByteArrayInputStream(xmlBytes), false);
            }
            catch (Exception e) {
                DOMDOCException de = new DOMDOCException(e.getMessage());
                de.initCause(e);
                throw de;
            }
            Element rootElement = doc.getDocumentElement();
            ArrayList attributeNames = new ArrayList();
            if (!rootElement.getTagName().equals(CONFIGURATION)) {
                throw new DOMDOCException(RB.getStringResource("malformedXML.ex.txt"));
            }
            parsedObject = ConfigurationXMLPersistenceUtility.createParsedConfigurationXMLObjectFromNode(rootElement, dvHandlers);
        }
        catch (UnsupportedEncodingException uee) {
            DOMDOCException de = new DOMDOCException(uee.getMessage());
            de.initCause(uee);
            throw de;
        }
        return parsedObject;
    }

    public static Map createConfigurationMap(ParsedConfigurationXMLObject parsedObject) {
        Map numericRange;
        Map integerRange;
        Map stringLengthRangeMap;
        HashMap<String, Object> configDataMap = new HashMap<String, Object>();
        if (parsedObject.hasEnumeration()) {
            Map selectionRange;
            if (parsedObject.hasLocalizedLabels()) {
                HashMap<Object, Map> localizedValuesMap = new HashMap<Object, Map>();
                List enumItemList = parsedObject.getEnumerationItems();
                int enumItemListLength = enumItemList.size();
                for (int i = 0; i < enumItemListLength; ++i) {
                    EnumerationItem enumItem = (EnumerationItem)enumItemList.get(i);
                    localizedValuesMap.put(enumItem.getValue(), enumItem.getTextLabels());
                }
                configDataMap.put(ENUMERATION, localizedValuesMap);
            } else if (parsedObject.hasUniqueTextLabels(null)) {
                Map valuesLabelsMap = parsedObject.getEnumerationValuesLabelsMap(null);
                configDataMap.put(ENUMERATION, valuesLabelsMap);
            } else {
                List valuesList = parsedObject.getEnumerationValues();
                configDataMap.put(ENUMERATION, valuesList);
            }
            HashMap<String, Object> optionsMap = null;
            boolean isAttributeSet = parsedObject.isEnumerationOthersAllowedSet();
            if (isAttributeSet) {
                boolean attributeValue = parsedObject.isEnumerationOthersAllowed();
                optionsMap = new HashMap<String, Object>();
                optionsMap.put(ENUMERATION_OTHERS_ALLOWED, new Boolean(attributeValue));
            }
            if ((selectionRange = parsedObject.getSelectionRange()) != null) {
                if (optionsMap == null) {
                    optionsMap = new HashMap();
                }
                optionsMap.put(SELECTION_RANGE, selectionRange);
            }
            if (optionsMap != null) {
                ConfigurationXMLPersistenceUtility.setEnumerationOptions(optionsMap);
            }
        }
        if ((stringLengthRangeMap = parsedObject.getStringLengthRange()) != null) {
            HashMap stringLengthRange = new HashMap();
            if (stringLengthRangeMap.containsKey(MINIMUM)) {
                stringLengthRange.put(MINIMUM, stringLengthRangeMap.get(MINIMUM));
            }
            if (stringLengthRangeMap.containsKey(MAXIMUM)) {
                stringLengthRange.put(MAXIMUM, stringLengthRangeMap.get(MAXIMUM));
            }
            configDataMap.put(STRING_LENGTH_RANGE, stringLengthRange);
        }
        if ((integerRange = parsedObject.getIntegerRange()) != null) {
            HashMap<String, Integer> intRange = new HashMap<String, Integer>();
            if (parsedObject.isIntegerRangeMinimumSet()) {
                intRange.put(MINIMUM, new Integer(parsedObject.getIntegerRangeMinimum()));
            }
            if (parsedObject.isIntegerRangeMaximumSet()) {
                intRange.put(MAXIMUM, new Integer(parsedObject.getIntegerRangeMaximum()));
            }
            if (parsedObject.isIntegerRangeIncrementSet()) {
                intRange.put(RANGE_INCREMENT, new Integer(parsedObject.getIntegerRangeIncrement()));
            }
            configDataMap.put(INTEGER_RANGE, intRange);
        }
        if ((numericRange = parsedObject.getNumericRange()) != null) {
            HashMap<String, Number> numRange = new HashMap<String, Number>();
            if (parsedObject.isNumericRangeMinimumSet()) {
                Number minimum = parsedObject.getNumericRangeMinimum();
                if (parsedObject.isNumericRangeMinimumExclusive()) {
                    if (minimum instanceof Float) {
                        numRange.put(MINIMUM_EXCLUSIVE, (Float)minimum);
                    } else {
                        numRange.put(MINIMUM_EXCLUSIVE, (Double)minimum);
                    }
                } else if (minimum instanceof Float) {
                    numRange.put(MINIMUM, (Float)minimum);
                } else {
                    numRange.put(MINIMUM, (Double)minimum);
                }
            }
            if (parsedObject.isNumericRangeMaximumSet()) {
                Number maximum = parsedObject.getNumericRangeMaximum();
                if (parsedObject.isNumericRangeMinimumExclusive()) {
                    if (maximum instanceof Float) {
                        numRange.put(MAXIMUM_EXCLUSIVE, (Float)maximum);
                    } else {
                        numRange.put(MAXIMUM_EXCLUSIVE, (Double)maximum);
                    }
                } else if (maximum instanceof Float) {
                    numRange.put(MAXIMUM, (Float)maximum);
                } else {
                    numRange.put(MAXIMUM, (Double)maximum);
                }
            }
            if (parsedObject.isNumericRangeIncrementSet()) {
                Number increment = parsedObject.getNumericRangeIncrement();
                if (increment instanceof Float) {
                    numRange.put(RANGE_INCREMENT, (Float)increment);
                } else {
                    numRange.put(RANGE_INCREMENT, (Double)increment);
                }
            }
            configDataMap.put(NUMERIC_RANGE, numRange);
        }
        return configDataMap;
    }

    public static Object createClassType(String nodeValue, String className) {
        if (className.equals("java.lang.Double")) {
            return new Double(nodeValue);
        }
        if (className.equals("java.lang.Float")) {
            return new Float(nodeValue);
        }
        if (className.equals("java.lang.Integer")) {
            return new Integer(nodeValue);
        }
        if (className.equals("java.sql.Time")) {
            return new Time(new Long(nodeValue));
        }
        if (className.equals("java.sql.Timestamp")) {
            return new Timestamp(new Long(nodeValue));
        }
        return new Double(nodeValue);
    }

    public static void setEnumerationOptions(Map options) {
        enumerationOptions.clear();
        if (options != null) {
            enumerationOptions.putAll(options);
        }
    }

    public static ParsedConfigurationXMLObject createOldParsedConfigurationXMLObject(String docString) {
        ParsedConfigurationXMLObject parsedObject = new ParsedConfigurationXMLObject();
        try {
            byte[] xmlBytes = docString.getBytes("UTF-8");
            if (xmlBytes == null || xmlBytes.length == 0) {
                return null;
            }
            DOMDoc doc = new DOMDoc();
            doc.loadDocument(new ByteArrayInputStream(xmlBytes), false);
            Element rootElement = doc.getDocumentElement();
            ArrayList attributeNames = new ArrayList();
            if (rootElement.getTagName().equals(CONFIGURATION)) {
                NodeList nl = rootElement.getElementsByTagName("*");
                int nodeLength = nl.getLength();
                for (int i = 0; i < nodeLength; ++i) {
                    Number nodeValue;
                    int nodeMapLength;
                    NamedNodeMap nodeMap;
                    HashMap<String, Integer> numericMap;
                    int j;
                    Node attributeElement = nl.item(i);
                    String nodeName = attributeElement.getNodeName();
                    if (nodeName.equals(ENUMERATION)) {
                        ArrayList<String> al = new ArrayList<String>();
                        NodeList valueType = attributeElement.getChildNodes();
                        int valueTypeLength = valueType.getLength();
                        for (j = 0; j < valueTypeLength; ++j) {
                            NodeList childList;
                            Node childElement;
                            Node valueElement = valueType.item(j);
                            String valueName = valueElement.getNodeName();
                            if (!valueName.equals(VALUE)) continue;
                            if (valueElement.hasAttributes()) {
                                NamedNodeMap nodeMap2 = valueElement.getAttributes();
                                String attributeValue = nodeMap2.getNamedItem("name").getNodeValue();
                                al.add(attributeValue);
                                continue;
                            }
                            if (!valueElement.hasChildNodes() || (childElement = (childList = valueElement.getChildNodes()).item(0)).getNodeType() != 4) continue;
                            String listValue = childElement.getNodeValue();
                            al.add(listValue);
                        }
                        parsedObject.setEnumerationData(al);
                        continue;
                    }
                    if (nodeName.equals(INTEGER_RANGE)) {
                        numericMap = new HashMap<String, Integer>();
                        nodeMap = attributeElement.getAttributes();
                        nodeMapLength = nodeMap.getLength();
                        for (j = 0; j < nodeMapLength; ++j) {
                            Node intElement = nodeMap.item(j);
                            String intName = intElement.getNodeName();
                            nodeValue = new Integer(intElement.getNodeValue());
                            numericMap.put(intName, (Integer)nodeValue);
                        }
                        if (numericMap.size() <= 0) continue;
                        parsedObject.setIntegerRange(numericMap);
                        continue;
                    }
                    if (!nodeName.equals(NUMERIC_RANGE)) continue;
                    numericMap = new HashMap();
                    nodeMap = attributeElement.getAttributes();
                    nodeMapLength = nodeMap.getLength();
                    for (j = 0; j < nodeMapLength; ++j) {
                        Node numericElement = nodeMap.item(j);
                        String numericName = numericElement.getNodeName();
                        nodeValue = new Double(numericElement.getNodeValue());
                        numericMap.put(numericName, (Integer)nodeValue);
                    }
                    if (numericMap.size() <= 0) continue;
                    parsedObject.setNumericRange(numericMap);
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return parsedObject;
    }

    public static ParsedConfigurationXMLObject createParsedConfigurationXMLObjectFromNode(Element rootElement, Map dvHandlers) {
        Document doc = rootElement.getOwnerDocument();
        ParsedConfigurationXMLObject parsedObject = new ParsedConfigurationXMLObject();
        NamedNodeMap rootAttributesMap = rootElement.getAttributes();
        Node versionNode = rootAttributesMap.getNamedItem("version");
        if (versionNode != null) {
            parsedObject.setVersion(versionNode.getNodeValue());
        } else {
            parsedObject.setVersion(PersistenceUtil.version_9_1);
        }
        NodeList nl = rootElement.getElementsByTagName("*");
        int nodeLength = nl.getLength();
        Object enumerationMap = null;
        HashMap<String, Boolean> enumerationOptions = null;
        for (int i = 0; i < nodeLength; ++i) {
            Integer nodeValue;
            NamedNodeMap nodeMap;
            HashMap<String, Integer> numericMap;
            Node attributeElement = nl.item(i);
            String nodeName = attributeElement.getNodeName();
            if (nodeName.equals(ENUMERATION)) {
                ArrayList<EnumerationItem> al = new ArrayList<EnumerationItem>();
                String enumerationType = null;
                if (attributeElement.hasAttributes()) {
                    NamedNodeMap nodeMap2 = attributeElement.getAttributes();
                    int mapLength = nodeMap2.getLength();
                    for (int w = 0; w < mapLength; ++w) {
                        Node enumOption = nodeMap2.item(w);
                        String enumNodeName = enumOption.getNodeName();
                        if (enumNodeName.equals(ENUMERATION_OTHERS_ALLOWED)) {
                            Boolean nodeValue2 = new Boolean(enumOption.getNodeValue());
                            if (enumerationOptions != null) continue;
                            enumerationOptions = new HashMap<String, Boolean>();
                            enumerationOptions.put(ENUMERATION_OTHERS_ALLOWED, nodeValue2);
                            parsedObject.setEnumerationOptions(enumerationOptions);
                            continue;
                        }
                        if (!enumNodeName.equals(CLASS_TYPE)) continue;
                        String classType = enumOption.getNodeValue();
                        nodeMap2.removeNamedItem(CLASS_TYPE);
                        enumerationType = classType;
                    }
                }
                NodeList valueType = attributeElement.getChildNodes();
                int valueTypeLength = valueType.getLength();
                for (int j = 0; j < valueTypeLength; ++j) {
                    EnumerationItem eItem = new EnumerationItem();
                    Node subtagElement = valueType.item(j);
                    String subtagName = subtagElement.getNodeName();
                    if (subtagName.equals(VALUE)) {
                        String attributeValue = null;
                        if (subtagElement.hasAttributes()) {
                            NamedNodeMap nodeMap3 = subtagElement.getAttributes();
                            attributeValue = nodeMap3.getNamedItem("name").getNodeValue();
                            if (enumerationType == null) {
                                eItem.setValue(attributeValue);
                            } else {
                                eItem.setValue(ConfigurationXMLPersistenceUtility.createClassType(attributeValue, enumerationType));
                            }
                        } else {
                            NodeList dataList = subtagElement.getChildNodes();
                            if (dataList.getLength() > 0) {
                                Node childElement = dataList.item(0);
                                String listValue = childElement.getNodeValue();
                                eItem.setValue(listValue);
                            }
                        }
                        NodeList textType = subtagElement.getChildNodes();
                        int textTypeLength = textType.getLength();
                        if (subtagElement.hasChildNodes()) {
                            NodeList textList = subtagElement.getChildNodes();
                            Node textElement = null;
                            String textName = null;
                            int textListLength = textList.getLength();
                            for (int m = 0; m < textListLength; ++m) {
                                NamedNodeMap localesMap;
                                Node xmlLangNode;
                                textElement = textList.item(m);
                                textName = textElement.getNodeName();
                                if (!textName.equals(TEXT)) continue;
                                Locale locale = null;
                                if (textElement.hasAttributes() && (xmlLangNode = (localesMap = textElement.getAttributes()).getNamedItem("xml:lang")) != null) {
                                    String localeCode = xmlLangNode.getNodeValue();
                                    if (localeCode != null) {
                                        locale = PersistenceUtil.parseLocaleItem(localeCode);
                                    } else {
                                        throw new IllegalStateException(RB.getStringResource("EntityPersistenceUtility.localeParsing.ex.txt"));
                                    }
                                }
                                if (textElement.hasChildNodes()) {
                                    NodeList textChildList = textElement.getChildNodes();
                                    for (int p = 0; p < textChildList.getLength(); ++p) {
                                        Node childElement = textChildList.item(p);
                                        String listValue = childElement.getNodeValue();
                                        eItem.setTextLabel(locale, listValue);
                                    }
                                    continue;
                                }
                                eItem.setTextLabel("");
                            }
                        }
                        al.add(eItem);
                        continue;
                    }
                    if (subtagName.equals(DYNAMIC_VALUES)) {
                        NodeList dynamicValuesList = subtagElement.getChildNodes();
                        int dynamicValuesListLength = dynamicValuesList.getLength();
                        for (int m = 0; m < dynamicValuesListLength; ++m) {
                            Node dynamicValuesElement = dynamicValuesList.item(m);
                            String dynamicValuesName = dynamicValuesElement.getNodeName();
                            if (dvHandlers == null || dvHandlers.size() == 0) {
                                parsedObject.setDynamicValuesProvider((DynamicValuesProviderInterface)new ProviderNotFoundProvider());
                                continue;
                            }
                            if (dvHandlers.containsKey(dynamicValuesName)) {
                                Object o = dvHandlers.get(dynamicValuesName);
                                if (!(o instanceof DynamicValuesHandlerInterface)) continue;
                                DocumentFragment dynamicValuesNode = doc.createDocumentFragment();
                                Node cloneNode = dynamicValuesElement.cloneNode(true);
                                dynamicValuesNode.appendChild(cloneNode);
                                DynamicValuesProviderInterface dvpi = ((DynamicValuesHandlerInterface)o).handleDynamicValues((Node)dynamicValuesNode);
                                parsedObject.setDynamicValuesProvider(dvpi);
                                parsedObject.setQueryType(dynamicValuesName);
                                continue;
                            }
                            parsedObject.setDynamicValuesProvider((DynamicValuesProviderInterface)new ProviderNotFoundProvider());
                        }
                        continue;
                    }
                    if (!subtagName.equals(SELECTION_RANGE)) continue;
                    HashMap<String, Integer> numericMap2 = new HashMap<String, Integer>();
                    NamedNodeMap nodeMap4 = subtagElement.getAttributes();
                    int nodeMapLength = nodeMap4.getLength();
                    for (int k = 0; k < nodeMapLength; ++k) {
                        Node intElement = nodeMap4.item(k);
                        String intName = intElement.getNodeName();
                        Integer nodeValue3 = new Integer(intElement.getNodeValue());
                        numericMap2.put(intName, nodeValue3);
                    }
                    parsedObject.setSelectionRange(numericMap2);
                }
                parsedObject.setEnumerationData(al);
                continue;
            }
            if (nodeName.equals(INTEGER_RANGE)) {
                numericMap = new HashMap<String, Integer>();
                nodeMap = attributeElement.getAttributes();
                int nodeMapLength = nodeMap.getLength();
                for (int j = 0; j < nodeMapLength; ++j) {
                    Node intElement = nodeMap.item(j);
                    String intName = intElement.getNodeName();
                    nodeValue = new Integer(intElement.getNodeValue());
                    numericMap.put(intName, nodeValue);
                }
                if (numericMap.size() <= 0) continue;
                parsedObject.setIntegerRange(numericMap);
                continue;
            }
            if (nodeName.equals(NUMERIC_RANGE)) {
                String numericType = null;
                HashMap<String, Number> numericMap3 = new HashMap<String, Number>();
                NamedNodeMap nodeMap5 = attributeElement.getAttributes();
                Node classTypeNode = nodeMap5.getNamedItem(CLASS_TYPE);
                if (classTypeNode != null) {
                    String classType = classTypeNode.getNodeValue();
                    nodeMap5.removeNamedItem(CLASS_TYPE);
                    numericType = classType;
                } else {
                    numericType = "java.lang.Double";
                }
                int nodeMapLength = nodeMap5.getLength();
                for (int j = 0; j < nodeMapLength; ++j) {
                    Node numericElement = nodeMap5.item(j);
                    String numericName = numericElement.getNodeName();
                    String nodeValue4 = numericElement.getNodeValue();
                    numericMap3.put(numericName, (Number)ConfigurationXMLPersistenceUtility.createClassType(nodeValue4, numericType));
                }
                if (numericMap3.size() <= 0) continue;
                parsedObject.setNumericRange(numericMap3);
                continue;
            }
            if (!nodeName.equals(STRING_LENGTH_RANGE)) continue;
            numericMap = new HashMap();
            nodeMap = attributeElement.getAttributes();
            int nodeMapLength = nodeMap.getLength();
            for (int j = 0; j < nodeMapLength; ++j) {
                Node intElement = nodeMap.item(j);
                String intName = intElement.getNodeName();
                nodeValue = new Integer(intElement.getNodeValue());
                numericMap.put(intName, nodeValue);
            }
            if (numericMap.size() <= 0) continue;
            parsedObject.setStringLengthRange(numericMap);
        }
        return parsedObject;
    }

    static {
        enumerationOptions = new HashMap();
        xmlSpecial = new char[]{'&', '\"', '<', '>', '\''};
        xmlReplacements = new String[]{"&amp;", "&quot;", "&lt;", "&gt;", "&apos;"};
    }
}

