/*
 * Decompiled with CFR 0.152.
 */
package com.sas.entities.edit.visuals.swing;

import com.sas.codepolicy.SASScope;
import com.sas.entities.RemoteEntityInterface;
import com.sas.entities.edit.visuals.AttributeValueEditorInterface;
import com.sas.swing.visuals.tableview.DefaultTableCellRenderer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeCellEditor;

@SASScope(value="ALL")
public class MultiLineTextValueEditor
extends AbstractCellEditor
implements AttributeValueEditorInterface,
TableCellEditor,
TreeCellEditor {
    protected JComponent m_cmpEditor;
    protected cEditorDelegate m_delegate;
    protected int m_nClicksToStart = 2;
    protected RemoteEntityInterface entity;
    protected String attributeName;

    public MultiLineTextValueEditor() {
        this(new JScrollPane(new JTextArea(3, 8)));
    }

    public MultiLineTextValueEditor(JScrollPane txtAreaEditor) {
        this.m_cmpEditor = txtAreaEditor;
        this.m_nClicksToStart = 2;
        this.m_delegate = new cTextAreaDelegate(txtAreaEditor);
    }

    public JComponent getComponent() {
        return this.m_cmpEditor;
    }

    public void setClicksToStart(int nClicksToStart) {
        this.m_nClicksToStart = nClicksToStart;
    }

    public int getClickCountToStart() {
        return this.m_nClicksToStart;
    }

    public void setCellEditorValue(Object value) {
        this.m_delegate.setValue(value);
    }

    @Override
    public Object getCellEditorValue() {
        return this.m_delegate.getValue();
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        return this.m_delegate.isCellEditable(e);
    }

    @Override
    public boolean shouldSelectCell(EventObject e) {
        return this.m_delegate.shouldSelectCell(e);
    }

    @Override
    public boolean stopCellEditing() {
        return this.m_delegate.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this.m_delegate.cancelCellEditing();
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean bSelected, boolean bExpanded, boolean bLeaf, int iRow) {
        String sValue = tree.convertValueToText(value, bSelected, bExpanded, bLeaf, iRow, false);
        this.m_delegate.layout(tree, iRow);
        this.m_delegate.setValue(sValue);
        return this.m_cmpEditor;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean bSelected, int iRow, int iColumn) {
        this.m_delegate.layout(table, iRow, iColumn);
        this.m_delegate.setValue(value);
        return this.m_cmpEditor;
    }

    @Override
    public void setEditInfo(RemoteEntityInterface entity, String attributeName) {
        this.entity = entity;
        this.attributeName = attributeName;
    }

    @Override
    public Object getEditGUI() {
        return this;
    }

    @Override
    public Object getRendererGUI() {
        return new DefaultTableCellRenderer();
    }

    @SASScope
    protected class cTextAreaDelegate
    extends cEditorDelegate {
        JTextArea m_txtEditor;

        cTextAreaDelegate(JScrollPane txtEditor) {
            this.m_txtEditor = (JTextArea)txtEditor.getViewport().getView();
        }

        @Override
        public void setValue(Object value) {
            this.m_txtEditor.setText(value != null ? value.toString() : "");
        }

        @Override
        public Object getValue() {
            return this.m_txtEditor.getText();
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent) {
                return ((MouseEvent)e).getClickCount() >= MultiLineTextValueEditor.this.m_nClicksToStart;
            }
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject e) {
            return true;
        }

        @Override
        public boolean startCellEditing(EventObject e) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            MultiLineTextValueEditor.this.fireEditingStopped();
            return true;
        }

        @Override
        public void cancelCellEditing() {
            MultiLineTextValueEditor.this.fireEditingCanceled();
        }
    }

    @SASScope
    protected class cEditorDelegate
    implements ActionListener,
    ItemListener {
        protected Object m_value;

        protected cEditorDelegate() {
        }

        public Object getValue() {
            return this.m_value;
        }

        public void setValue(Object value) {
            this.m_value = value;
        }

        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent) {
                return ((MouseEvent)e).getClickCount() >= MultiLineTextValueEditor.this.m_nClicksToStart;
            }
            return true;
        }

        public boolean shouldSelectCell(EventObject e) {
            return true;
        }

        public boolean startCellEditing(EventObject e) {
            return true;
        }

        public boolean stopCellEditing() {
            MultiLineTextValueEditor.this.fireEditingStopped();
            return true;
        }

        public void cancelCellEditing() {
            MultiLineTextValueEditor.this.fireEditingCanceled();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MultiLineTextValueEditor.this.stopCellEditing();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            MultiLineTextValueEditor.this.stopCellEditing();
        }

        public void layout(JTree tree, int iRow) {
        }

        public void layout(JTable table, int iRow, int iColumn) {
        }
    }
}

