/*
 * Decompiled with CFR 0.152.
 */
package com.sas.entities.edit.visuals.swing;

import com.sas.RB;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.codepolicy.SASScope;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeGroup;
import com.sas.entities.AttributeGroupInterface;
import com.sas.entities.AttributeTypeInterface;
import com.sas.entities.EntityUtil;
import com.sas.entities.RemoteEntityInterface;
import com.sas.entities.edit.models.EntityToTableModelAdapter;
import com.sas.entities.edit.visuals.AttributeValueEditorInterface;
import com.sas.entities.edit.visuals.EntityEditors;
import com.sas.entities.edit.visuals.swing.ComboValueEditor;
import com.sas.entities.edit.visuals.swing.GroupComboRenderer;
import com.sas.entities.edit.visuals.swing.MultiLineTextValueEditor;
import com.sas.entities.persist.ConfigurationXMLPersistenceUtility;
import com.sas.entities.persist.ParsedConfigurationXMLObject;
import com.sas.swing.visuals.tableview.DefaultTableCellEditor;
import com.sas.swing.visuals.tableview.DefaultTableCellRenderer;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.util.Classes;
import com.sas.util.errorhandlers.GenericErrorHandlerInterface;
import com.sas.util.errorhandlers.JOptionPaneErrorHandler;
import com.sas.util.errorhandlers.SupportsGenericErrorHandlerInterface;
import com.sas.util.transforms.StringToDateTransform;
import com.sas.util.transforms.StringToDoubleTransform;
import com.sas.util.transforms.StringToFloatTransform;
import com.sas.util.transforms.TransformInterface;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

@SASScope(value="ALL")
public class EntityPropertySheet
extends JComponent
implements ActionListener,
PropertyChangeListener {
    public static final String RB_KEY = "EntityPropertySheet.";
    protected static final String DEFAULT_EDITOR = EntityEditors.getEditorClassName(EntityEditors.STRING_EDITOR, "Java");
    protected static final String LABEL_EDITOR = EntityEditors.getEditorClassName(EntityEditors.STATIC_STRING_EDITOR, "Java");
    protected RemoteEntityInterface model;
    protected TableView tableView;
    protected EntityToTableModelAdapter tableModel;
    protected AttributeGroup attributeGroup;
    private Locale locale;
    private String noDefaultValueSetString;
    private JComboBox groupCombo;
    protected Map editorMappings;
    protected boolean noDefaultValueSetSpecified;
    private boolean displaySubgroups;
    private boolean displayExpertGroups;
    private boolean comboPopulated;
    protected int messageType;
    static int defaultWidth = 300;
    static int defaultHeight = 150;

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultWidth(int newDefaultWidth) {
        defaultWidth = newDefaultWidth;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static synchronized void setDefaultHeight(int newDefaultHeight) {
        defaultHeight = newDefaultHeight;
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "defaultWidth"}, {"Default value", "300"}, {"Description", RB.getStringResource((String)"VisualInterface.defaultWidth.pd.txt")}}, {{"Name", "defaultHeight"}, {"Default value", "150"}, {"Description", RB.getStringResource((String)"VisualInterface.defaultHeight.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public EntityPropertySheet() {
        this.initialize();
        this.locale = Locale.getDefault();
    }

    public EntityPropertySheet(Locale locale) {
        this.locale = locale;
        this.initialize();
    }

    public EntityPropertySheet(boolean displaySubgroups) {
        this.displaySubgroups = displaySubgroups;
        this.locale = Locale.getDefault();
        this.initialize();
    }

    public EntityPropertySheet(boolean displaySubgroups, boolean displayExpertGroups) {
        this.displaySubgroups = displaySubgroups;
        this.displayExpertGroups = displayExpertGroups;
        this.locale = Locale.getDefault();
        this.initialize();
    }

    public EntityPropertySheet(TableView tableView) {
        this.tableView = tableView;
        this.locale = Locale.getDefault();
        this.initialize();
    }

    protected void initialize() {
        if (this.tableView == null) {
            this.tableView = new TableView();
        }
        this.tableView.getRowHeader().setCellsToSizeCount(-1);
        this.tableView.setRowAutoResizeMode(6);
        this.messageType = 0;
        int numberOfEntries = 2;
        if (!this.displaySubgroups) {
            numberOfEntries = 1;
        }
        this.editorMappings = new HashMap();
        AutoSizingGridLayout layout = new AutoSizingGridLayout(numberOfEntries, 1, 10, 10, true, true, true);
        this.setLayout((LayoutManager)layout);
        if (this.displaySubgroups) {
            this.groupCombo = new JComboBox();
            this.groupCombo.setRenderer(new GroupComboRenderer());
            this.add(this.groupCombo);
        }
        JScrollPane tablePane = new JScrollPane((Component)this.tableView);
        tablePane.setPreferredSize(new Dimension(300, 150));
        tablePane.getViewport().add((Component)this.tableView);
        this.add(tablePane);
        this.tableView.setRowHeaderVisible(false);
        this.tableView.setPopupMenuEnabled(false);
        this.tableView.setAutoResizeMode(2);
        this.tableView.setRowSelectionAllowed(true);
        this.tableView.setColumnSelectionAllowed(false);
        this.tableView.setCellSelectionEnabled(false);
        JTableHeader header = this.tableView.getTableHeader();
        if (header != null) {
            header.setReorderingAllowed(false);
        }
    }

    public RemoteEntityInterface getModel() {
        return this.model;
    }

    public void setModel(RemoteEntityInterface entityModel, AttributeGroupInterface ag) {
        this.attributeGroup = (AttributeGroup)ag;
        if (entityModel != null) {
            this.model = entityModel;
            if (this.attributeGroup == null) {
                try {
                    this.attributeGroup = (AttributeGroup)this.model.getAttributeGroup();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.tableModel = new EntityToTableModelAdapter(this.model, (AttributeGroupInterface)this.attributeGroup, this.displaySubgroups, this.displayExpertGroups);
            this.tableModel.setContext("Java");
            this.createAttributeEditors();
            this.tableModel.setEditorMappings(this.editorMappings);
            if (this.noDefaultValueSetSpecified) {
                this.tableModel.setNoDefaultValueSetString(this.noDefaultValueSetString);
            }
            this.tableModel.setLocale(this.locale);
            this.tableView.setLocale(this.locale);
            this.tableView.setModel((TableModel)this.tableModel);
            this.tableView.setSelectionMode(0);
            ListSelectionModel rowSM = this.tableView.getSelectionModel();
            rowSM.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int selectedRow;
                    TableCellEditor editor;
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                    if (!lsm.isSelectionEmpty() && (editor = EntityPropertySheet.this.tableView.getCellEditor(selectedRow = lsm.getMinSelectionIndex(), 1)) instanceof MultiLineTextValueEditor) {
                        EntityPropertySheet.this.tableView.setRowHeight(selectedRow, EntityPropertySheet.this.tableView.getRowHeight(selectedRow) * 3);
                    }
                }
            });
            if (this.displaySubgroups && !this.comboPopulated) {
                DefaultTreeModel groups = EntityUtil.getAttributeGroupsTreeModel((AttributeGroupInterface)this.attributeGroup, (boolean)this.displayExpertGroups);
                DefaultMutableTreeNode root = (DefaultMutableTreeNode)groups.getRoot();
                Enumeration<TreeNode> nodes = root.preorderEnumeration();
                Object groupName = null;
                int attributeCount = 0;
                while (nodes.hasMoreElements()) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodes.nextElement();
                    if (!(node.getUserObject() instanceof AttributeGroupInterface) || (attributeCount = ((AttributeGroupInterface)node.getUserObject()).count(false)) <= 0 && node.isLeaf()) continue;
                    this.groupCombo.addItem(node.getUserObject());
                }
                this.groupCombo.addActionListener(this);
                this.comboPopulated = true;
            }
        }
    }

    public void setModel(RemoteEntityInterface entityModel) {
        if (entityModel != null) {
            this.model = entityModel;
            try {
                this.attributeGroup = (AttributeGroup)entityModel.getAttributeGroup();
                this.setModel(entityModel, (AttributeGroupInterface)this.attributeGroup);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (this.groupCombo.getSelectedItem() instanceof AttributeGroupInterface) {
            this.setModel(this.model, (AttributeGroupInterface)this.groupCombo.getSelectedItem());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createAttributeEditors() {
        ArrayList al = (ArrayList)this.tableModel.getAttributeNames();
        int listSize = al.size();
        AttributeValueEditorInterface editor = null;
        Class editorClass = null;
        AttributeTypeInterface ati = null;
        String editorName = null;
        for (int i = 0; i < listSize; ++i) {
            AttributeDescriptorInterface adi = this.attributeGroup.getAttributeDescriptor((String)al.get(i), true);
            ati = adi.getType();
            editorName = adi == null ? null : (!adi.isModifiable() ? LABEL_EDITOR : adi.getEditor("Java"));
            try {
                if (editorName == null) {
                    String configXML = adi.getConfigurationXML();
                    if (configXML == null) {
                        editorClass = Classes.loadClass((String)DEFAULT_EDITOR, null, (Object)this);
                        editor = this.createDefaultEditor();
                        continue;
                    }
                    ParsedConfigurationXMLObject parsedObject = ConfigurationXMLPersistenceUtility.createParsedConfigurationXMLObject(configXML);
                    if (parsedObject.getEnumerationItems() != null) {
                        String editorClassName = EntityEditors.getEditorClassName(EntityEditors.COMBO_EDITOR, "Java");
                        editorClass = Classes.loadClass((String)editorClassName, null, (Object)this);
                        editor = (AttributeValueEditorInterface)editorClass.newInstance();
                        continue;
                    }
                    editorClass = Classes.loadClass((String)DEFAULT_EDITOR, null, (Object)this);
                    editor = this.createDefaultEditor();
                    continue;
                }
                editorClass = Classes.loadClass((String)editorName, null, (Object)this);
                editor = (AttributeValueEditorInterface)editorClass.newInstance();
                if (!(editor instanceof ComboValueEditor)) continue;
                this.noDefaultValueSetSpecified = true;
                this.noDefaultValueSetString = ((ComboValueEditor)editor).getNoDefaultValueSetString();
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                String className = EntityEditors.getEditorClassName(editorName, "Java");
                if (className != null) {
                    try {
                        editorClass = Classes.loadClass((String)className, null, (Object)this);
                        editor = (AttributeValueEditorInterface)editorClass.newInstance();
                        if (!(editor instanceof ComboValueEditor)) continue;
                        this.noDefaultValueSetSpecified = true;
                        this.noDefaultValueSetString = ((ComboValueEditor)editor).getNoDefaultValueSetString();
                    }
                    catch (Exception e) {
                        editor = this.createDefaultEditor();
                    }
                    continue;
                }
                editor = this.createDefaultEditor();
                continue;
            }
            catch (InstantiationException ie) {
                editor = this.createDefaultEditor();
                continue;
            }
            catch (IllegalAccessException ie) {
                editor = this.createDefaultEditor();
                continue;
            }
            finally {
                if (editor instanceof SupportsGenericErrorHandlerInterface) {
                    JOptionPaneErrorHandler errorHandler = new JOptionPaneErrorHandler((Component)this.tableView);
                    errorHandler.setMessageType(this.messageType);
                    ((SupportsGenericErrorHandlerInterface)editor).setGenericErrorHandler((GenericErrorHandlerInterface)errorHandler);
                }
                this.editorMappings.put(adi, editor);
                if (editor instanceof DefaultTableCellEditor) {
                    ((DefaultTableCellEditor)editor).setLocale(this.getLocale());
                    if (ati != null) {
                        if (ati.getSQLType() == 8) {
                            ((DefaultTableCellEditor)editor).setOutputTransform((TransformInterface)new StringToDoubleTransform(Locale.US));
                        } else if (ati.getSQLType() == 6) {
                            ((DefaultTableCellEditor)editor).setOutputTransform((TransformInterface)new StringToFloatTransform(Locale.US));
                        } else if (ati.getSQLType() == 91) {
                            StringToDateTransform dateTransform = new StringToDateTransform(this.getLocale());
                            dateTransform.setDateFormatter((DateFormat)new SimpleDateFormat("ddMMMyy", Locale.US));
                            ((DefaultTableCellEditor)editor).setOutputTransform((TransformInterface)dateTransform);
                        }
                    }
                }
                editor.setEditInfo(this.model, (String)al.get(i));
                this.tableView.setCellEditor(i + 1, 2, (TableCellEditor)editor.getEditGUI());
                DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)editor.getRendererGUI();
                renderer.setLocale(this.locale);
                this.tableView.setCellRenderer(i + 1, 2, (TableCellRenderer)renderer);
                if (editor instanceof MultiLineTextValueEditor) {
                    this.tableView.addPropertyChangeListener((PropertyChangeListener)this);
                }
            }
        }
    }

    protected AttributeValueEditorInterface createDefaultEditor() {
        AttributeValueEditorInterface editor = null;
        try {
            Class editorClass = Classes.loadClass((String)DEFAULT_EDITOR, null, (Object)this);
            editor = (AttributeValueEditorInterface)editorClass.newInstance();
            return editor;
        }
        catch (ClassNotFoundException classNotFoundException) {}
        catch (InstantiationException instantiationException) {}
        catch (IllegalAccessException illegalAccessException) {}
        finally {
            return editor;
        }
    }

    public TableView getTableView() {
        return this.tableView;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
        if (this.tableModel != null) {
            this.tableModel.setLocale(locale);
            this.tableView.setLocale(locale);
        }
    }

    public String getColumnName(int columnIndex) {
        if (this.tableModel != null) {
            return this.tableModel.getColumnName(columnIndex);
        }
        return null;
    }

    public void setColumnName(String columnName, int columnIndex) {
        if (this.tableModel != null) {
            this.tableModel.setColumnName(columnName, columnIndex);
        }
    }

    public boolean isDisplayExpertGroups() {
        return this.displayExpertGroups;
    }

    public void setDisplayExpertGroups(boolean displayExpertGroups) {
        this.displayExpertGroups = displayExpertGroups;
    }

    public void setDisplaySubgroups(boolean displaySubgroups) {
        this.displaySubgroups = displaySubgroups;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("tableCellEditor") && evt.getNewValue() != null) {
            int row = this.tableView.getSelectedRow();
            TableCellEditor editor = this.tableView.getCellEditor(row, 1);
            if (evt.getNewValue() instanceof MultiLineTextValueEditor) {
                this.tableView.setRowHeight(row, this.tableView.getRowHeight() * 3);
            }
        }
    }

    public void setGenericErrorHandlerMessageType(int messageType) {
        this.messageType = messageType == 1 ? messageType : (messageType == 2 ? messageType : (messageType == 3 ? messageType : (messageType == -1 ? messageType : 0)));
    }
}

