/*
 * Decompiled with CFR 0.152.
 */
package com.sas.entities.edit.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.entities.edit.visuals.RB;
import com.sas.text.Message;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

@SASScope(value="ALL")
public class EntityEditors {
    public static final String RB_KEY = "EntityEditors.";
    protected static Map editorInfo;
    static String m_bundlePath;
    static ResourceBundle m_bundle;
    public static String STRING_EDITOR;
    public static String STATIC_STRING_EDITOR;
    public static String COMBO_EDITOR;
    public static String STRING_ARRAY_EDITOR;

    public static String getEditorClassName(String editor, String context) {
        return EntityEditors.getResourceString(editor + "." + context);
    }

    protected static void createEditorInfo() {
        editorInfo = new HashMap();
        Properties properties = new Properties();
        try {
            properties.load(EntityEditors.class.getResourceAsStream("EntityEditors.config"));
            editorInfo.putAll(properties);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe.getMessage());
        }
    }

    protected static String getResourceBundlePath(Class source) {
        String strBundlePath = source.getName();
        return strBundlePath;
    }

    protected static ResourceBundle getResourceBundle(Class source) {
        String strBundlePath = EntityEditors.getResourceBundlePath(source);
        Locale locale = Locale.getDefault();
        ResourceBundle returnValue = null;
        try {
            returnValue = ResourceBundle.getBundle(strBundlePath, locale);
        }
        catch (Throwable e) {
            try {
                returnValue = PropertyResourceBundle.getBundle(strBundlePath, locale);
            }
            catch (Throwable e2) {
                return null;
            }
        }
        return returnValue;
    }

    protected static String getResourceString(String key) {
        if (editorInfo == null) {
            EntityEditors.createEditorInfo();
        }
        if (!editorInfo.containsKey(key)) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource(RB_KEY, "missingResource.pd.txt"), (Object)key));
        }
        return editorInfo.get(key).toString();
    }

    static {
        m_bundlePath = EntityEditors.getResourceBundlePath(EntityEditors.class);
        m_bundle = EntityEditors.getResourceBundle(EntityEditors.class);
        STRING_EDITOR = "StringEditor";
        STATIC_STRING_EDITOR = "StaticStringEditor";
        COMBO_EDITOR = "ComboEditor";
        STRING_ARRAY_EDITOR = "StringArrayEditor";
    }
}

