/*
 * Decompiled with CFR 0.152.
 */
package com.sas.entities.edit.models;

import com.sas.beans.PropertyChangeSource;
import com.sas.codepolicy.SASScope;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeGroupInterface;
import com.sas.entities.AttributeSetException;
import com.sas.entities.AttributeTypeInterface;
import com.sas.entities.EntityUtil;
import com.sas.entities.RemoteEntityInterface;
import com.sas.entities.edit.models.RB;
import com.sas.entities.edit.visuals.AttributeValueEditorInterface;
import com.sas.entities.edit.visuals.ComboValueEditorInterface;
import com.sas.entities.edit.visuals.EntityEditors;
import com.sas.entities.edit.visuals.ListLabelsInterface;
import com.sas.entities.edit.visuals.StringArrayValueEditorInterface;
import com.sas.table.UpdateRowInterface;
import com.sas.util.Classes;
import com.sas.util.Util;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.swing.event.EventListenerList;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

@SASScope(value="ALL")
public class EntityToTableModelAdapter
extends AbstractTableModel
implements PropertyChangeSource,
UpdateRowInterface {
    public static final String RB_KEY = "EntityToTableModelAdapter.";
    protected ArrayList propertyNames;
    protected RemoteEntityInterface model;
    protected String[] columnNames;
    protected boolean tableEditable;
    protected SwingPropertyChangeSupport spcs;
    protected EventListenerList listenerList = new EventListenerList();
    protected AttributeGroupInterface attributeGroup;
    protected Locale locale;
    private String noDefaultValueSetString;
    private String context;
    private boolean displaySubgroups;
    private boolean displayExpertGroups;
    protected Map editorMap;

    public EntityToTableModelAdapter() {
        this.initialize();
    }

    public EntityToTableModelAdapter(RemoteEntityInterface ei) {
        this(ei, null, false, false);
    }

    public EntityToTableModelAdapter(RemoteEntityInterface ei, AttributeGroupInterface agi) {
        this(ei, agi, false, false);
    }

    public EntityToTableModelAdapter(RemoteEntityInterface ei, AttributeGroupInterface agi, boolean displaySubgroups) {
        this(ei, agi, displaySubgroups, false);
    }

    public EntityToTableModelAdapter(RemoteEntityInterface ei, AttributeGroupInterface agi, boolean displaySubgroups, boolean displayExpertGroups) {
        this.initialize();
        this.displaySubgroups = displaySubgroups;
        this.displayExpertGroups = displayExpertGroups;
        if (agi != null) {
            this.setAttributeGroup(agi);
        } else if (ei != null) {
            try {
                this.setAttributeGroup(ei.getAttributeGroup());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.model = ei;
    }

    protected void initialize() {
        this.tableEditable = true;
        this.editorMap = new HashMap();
        this.columnNames = new String[2];
        this.spcs = new SwingPropertyChangeSupport(this);
        this.propertyNames = new ArrayList();
    }

    public void extractAttributeNames(AttributeGroupInterface agi) {
        this.propertyNames.clear();
        if (agi != null) {
            if (!this.displaySubgroups) {
                if (this.displayExpertGroups) {
                    AttributeDescriptorInterface[] attributes = agi.getAttributeDescriptors(true);
                    this.addAttributes(attributes, false);
                } else {
                    DefaultTreeModel groups = EntityUtil.getAttributeGroupsTreeModel((AttributeGroupInterface)agi, (boolean)this.displayExpertGroups);
                    DefaultMutableTreeNode root = (DefaultMutableTreeNode)groups.getRoot();
                    Enumeration<TreeNode> nodes = root.preorderEnumeration();
                    Object groupName = null;
                    boolean attributeCount = false;
                    DefaultMutableTreeNode node = null;
                    AttributeGroupInterface subgroup = null;
                    while (nodes.hasMoreElements()) {
                        node = (DefaultMutableTreeNode)nodes.nextElement();
                        if (!(node.getUserObject() instanceof AttributeGroupInterface)) continue;
                        subgroup = (AttributeGroupInterface)node.getUserObject();
                        AttributeDescriptorInterface[] attributes = subgroup.getAttributeDescriptors(false);
                        this.addAttributes(attributes, true);
                    }
                }
            } else {
                AttributeDescriptorInterface[] attributes = agi.getAttributeDescriptors(false);
                if (this.displayExpertGroups) {
                    this.addAttributes(attributes, false);
                } else if (!agi.isExpert()) {
                    this.addAttributes(attributes, true);
                }
            }
        }
    }

    protected void addAttributes(AttributeDescriptorInterface[] attributes, boolean filterExpertAttributes) {
        int numberOfProperties = attributes.length;
        String attributeName = null;
        for (int i = 0; i < numberOfProperties; ++i) {
            attributeName = attributes[i].getName();
            if (attributeName.equals("entityKey") || attributeName.equals("prototype") || !attributes[i].isVisible()) continue;
            if (filterExpertAttributes) {
                if (attributes[i].isExpert()) continue;
                this.propertyNames.add(attributeName);
                continue;
            }
            this.propertyNames.add(attributeName);
        }
    }

    public void setAttributeGroup(AttributeGroupInterface agi) {
        this.attributeGroup = agi;
        this.extractAttributeNames(agi);
    }

    public List getAttributeNames() {
        return this.propertyNames;
    }

    @Override
    public int getRowCount() {
        return this.propertyNames.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String propertyName = (String)this.propertyNames.get(rowIndex);
        Object returnObject = null;
        AttributeDescriptorInterface ad = null;
        boolean processedListLabels = false;
        if (columnIndex == 0) {
            ad = this.attributeGroup.getAttributeDescriptor(propertyName, true);
            return ad.getLabel(this.locale);
        }
        if (columnIndex != 1) throw new IllegalArgumentException();
        try {
            try {
                ad = this.attributeGroup.getAttributeDescriptor(propertyName, true);
                AttributeTypeInterface ati = ad.getType();
                Object attributeEditor = this.editorMap.get(ad);
                if (ad.isDefaultValueHasBeenSet() || this.model.containsAttributeNamed(propertyName)) {
                    returnObject = ati != null && ati.getName() != null && ati.getName().equals("Color") ? this.model.getStringAttribute(propertyName, ad.getStringDefault()) : (ati != null && ati.getSQLType() == 91 ? this.model.getStringAttribute(propertyName, ad.getStringDefault()) : this.model.getAttribute(propertyName, ad.getDefault()));
                    if (attributeEditor instanceof ListLabelsInterface) {
                        returnObject = ((ListLabelsInterface)attributeEditor).getLabelForValue(returnObject, this.locale);
                        processedListLabels = true;
                    }
                }
                if (returnObject == null) {
                    String editorName = ad.getEditor(this.context);
                    Class editorClass = null;
                    if (editorName == null) return returnObject;
                    try {
                        editorClass = Classes.loadClass((String)editorName, null, (Object)this);
                        AttributeValueEditorInterface editor = (AttributeValueEditorInterface)editorClass.newInstance();
                        if (!(editor instanceof ComboValueEditorInterface)) return returnObject;
                        return this.noDefaultValueSetString;
                    }
                    catch (ClassNotFoundException cnfe) {
                        String className = EntityEditors.getEditorClassName(editorName, "Servlet");
                        if (className == null) return returnObject;
                        try {
                            editorClass = Classes.loadClass((String)className, null, (Object)this);
                            AttributeValueEditorInterface editor = (AttributeValueEditorInterface)editorClass.newInstance();
                            if (!(editor instanceof ComboValueEditorInterface)) return returnObject;
                            return this.noDefaultValueSetString;
                        }
                        catch (Exception editor) {
                            return returnObject;
                        }
                    }
                    catch (InstantiationException cnfe) {
                        return returnObject;
                    }
                    catch (IllegalAccessException cnfe) {
                        return returnObject;
                    }
                }
                if (!(attributeEditor instanceof StringArrayValueEditorInterface)) {
                    if (!(attributeEditor instanceof ListLabelsInterface)) return returnObject;
                    if (processedListLabels) return returnObject;
                    return ((ListLabelsInterface)attributeEditor).getLabelForValue(returnObject, this.locale);
                }
                Class<?> objectClass = returnObject.getClass();
                if (!objectClass.isArray()) return returnObject;
                StringBuffer sb = new StringBuffer();
                List<String> list = Arrays.asList((String[])returnObject);
                int lsize = list.size();
                for (int i = 0; i < lsize; ++i) {
                    sb.append((Object)list.get(i));
                    if (i == lsize - 1) continue;
                    sb.append(", ");
                }
                if (sb.length() <= 0) return null;
                String valueString = sb.toString();
                return valueString;
            }
            catch (RemoteException remoteException) {
                return returnObject;
            }
        }
        catch (Throwable throwable) {
            return returnObject;
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        try {
            String attributeName = (String)this.propertyNames.get(rowIndex);
            AttributeDescriptorInterface ad = this.attributeGroup.getAttributeDescriptor(attributeName, true);
            if (!this.model.containsAttributeNamed(attributeName)) {
                if (Util.unequal((Object)aValue, (Object)this.noDefaultValueSetString) && ad.isModifiable()) {
                    Object attributeEditor = this.editorMap.get(ad);
                    if (attributeEditor instanceof StringArrayValueEditorInterface) {
                        this.convertToStringArray(aValue, attributeName);
                    } else if (attributeEditor instanceof ListLabelsInterface) {
                        if (aValue != null) {
                            String valueLabel;
                            if (aValue instanceof Date) {
                                SimpleDateFormat formatter = new SimpleDateFormat("ddMMMyyyy", Locale.US);
                                formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
                                valueLabel = formatter.format(aValue);
                            } else {
                                valueLabel = aValue.toString();
                            }
                            Object realValue = ((ListLabelsInterface)attributeEditor).getValueForLabel(valueLabel);
                            if (aValue instanceof Date) {
                                this.model.setAttribute(attributeName, (Object)valueLabel);
                            } else {
                                this.model.setAttribute(attributeName, realValue);
                            }
                        } else if (aValue == null || aValue.toString().length() == 0) {
                            this.model.clearAttribute(attributeName);
                        } else {
                            this.model.setAttribute(attributeName, aValue);
                        }
                    } else if (aValue == null || aValue.toString().length() == 0) {
                        this.model.clearAttribute(attributeName);
                    } else {
                        this.model.setAttribute(attributeName, aValue);
                    }
                }
                this.fireTableRowsUpdated(rowIndex, rowIndex);
            } else if (ad.isModifiable()) {
                Object attributeEditor = this.editorMap.get(ad);
                Object oldValue = this.model.getAttribute(attributeName);
                if (attributeEditor instanceof StringArrayValueEditorInterface) {
                    this.convertToStringArray(aValue, attributeName);
                } else if (Util.unequal((Object)aValue, (Object)this.noDefaultValueSetString)) {
                    if (attributeEditor instanceof ListLabelsInterface) {
                        if (aValue != null) {
                            if (aValue instanceof Date) {
                                SimpleDateFormat formatter = new SimpleDateFormat("ddMMMyyyy", Locale.US);
                                formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
                                String valueLabel = formatter.format(aValue);
                                this.model.setAttribute(attributeName, (Object)valueLabel);
                            } else {
                                String valueLabel = aValue.toString();
                                Object realValue = ((ListLabelsInterface)attributeEditor).getValueForLabel(valueLabel);
                                this.model.setAttribute(attributeName, realValue);
                            }
                        }
                    } else if (aValue == null || aValue.toString().length() == 0) {
                        this.model.clearAttribute(attributeName);
                    } else {
                        this.model.setAttribute(attributeName, aValue);
                    }
                }
                this.fireTableRowsUpdated(rowIndex, rowIndex);
            }
        }
        catch (RemoteException attributeName) {
        }
        catch (AttributeSetException pse) {
            throw new IllegalArgumentException(pse.getLocalizedMessage());
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.isTableEditable() && columnIndex == 1;
    }

    public void setModel(RemoteEntityInterface model) {
        RemoteEntityInterface oldModel = this.model;
        if (oldModel != model) {
            this.model = model;
            try {
                this.attributeGroup = model.getAttributeGroup();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.refresh();
            this.spcs.firePropertyChange("model", oldModel, model);
        }
    }

    public RemoteEntityInterface getModel() {
        return this.model;
    }

    public void setColumnName(String columnName, int columnIndex) {
        String oldColumnName = this.columnNames[columnIndex];
        if (Util.unequal((Object)oldColumnName, (Object)columnName)) {
            this.columnNames[columnIndex] = columnName;
            this.fireTableStructureChanged();
        }
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            if (this.columnNames[0] != null) {
                return this.columnNames[0];
            }
            return RB.getStringResource(RB_KEY, "attribute.pd.txt");
        }
        if (this.columnNames[1] != null) {
            return this.columnNames[1];
        }
        return RB.getStringResource(RB_KEY, "value.pd.txt");
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public boolean isTableEditable() {
        return this.tableEditable;
    }

    public void setTableEditable(boolean editable) {
        if (this.tableEditable != editable) {
            this.tableEditable = editable;
            this.spcs.firePropertyChange("tableEditable", !editable, editable);
        }
    }

    public void refresh() {
        if (this.attributeGroup != null) {
            this.extractAttributeNames(this.attributeGroup);
        }
        this.fireModelEvent(new TableModelEvent(this));
    }

    public boolean isDisplayExpertGroups() {
        return this.displayExpertGroups;
    }

    public void setDisplayExpertGroups(boolean displayExpertGroups) {
        this.displayExpertGroups = displayExpertGroups;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.spcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.spcs.removePropertyChangeListener(listener);
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listenerList.add(TableModelListener.class, l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listenerList.remove(TableModelListener.class, l);
    }

    public void fireModelEvent(EventObject event) {
        if (event instanceof TableModelEvent) {
            EventListener[] listeners = this.listenerList.getListeners(TableModelListener.class);
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                ((TableModelListener)listeners[i]).tableChanged((TableModelEvent)event);
            }
        }
    }

    public Map getEditorMappings() {
        return this.editorMap;
    }

    public void setEditorMappings(Map editorMappings) {
        this.editorMap.putAll(editorMappings);
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getNoDefaultValueSetString() {
        return this.noDefaultValueSetString;
    }

    public void setNoDefaultValueSetString(String noDefaultValueSetString) {
        if (noDefaultValueSetString != null) {
            this.noDefaultValueSetString = noDefaultValueSetString;
        }
    }

    protected void convertToStringArray(Object aValue, String attributeName) {
        try {
            ArrayList<String> listItems = null;
            if (aValue != null) {
                listItems = new ArrayList<String>();
                StringTokenizer tokenizer = new StringTokenizer(aValue.toString(), "\n", false);
                int tokenCount = tokenizer.countTokens();
                for (int i = 0; i < tokenCount; ++i) {
                    String theToken = tokenizer.nextToken().trim();
                    if (theToken.equals("\n") || theToken.equals(" ") || theToken.equals("")) continue;
                    listItems.add(theToken.trim());
                }
                String[] arrayItems = listItems.toArray(new String[listItems.size()]);
                this.model.setAttribute(attributeName, (Object)arrayItems);
                String[] stringArray = (String[])this.model.getAttribute(attributeName);
            } else {
                this.model.setAttribute(attributeName, (Object)new String[0]);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (AttributeSetException attributeSetException) {
            // empty catch block
        }
    }

    public boolean isRowUpdateAllowed() {
        return true;
    }
}

