/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.misc;

import EDU.oswego.cs.dl.util.concurrent.Rendezvous;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import EDU.oswego.cs.dl.util.concurrent.misc.UpdateCommand;
import java.io.Serializable;

abstract class RNG
implements Serializable,
Comparable {
    static final int firstSeed = 4321;
    static final int rmod = Integer.MAX_VALUE;
    static final int rmul = 16807;
    static int lastSeed = 4321;
    static final int smod = 32749;
    static final int smul = 3125;
    static final Object constructionLock;
    static final SynchronizedInt computeLoops;
    static final SynchronizedInt syncMode;
    static final SynchronizedInt producerMode;
    static final SynchronizedInt consumerMode;
    static final SynchronizedInt bias;
    static final SynchronizedLong timeout;
    static final SynchronizedInt exchangeParties;
    static final SynchronizedInt sequenceNumber;
    static final SynchronizedInt itersPerBarrier;
    static Rendezvous[] exchangers_;
    final int cloops = computeLoops.get();
    final int pcBias = bias.get();
    final int smode = syncMode.get();
    final int pmode = producerMode.get();
    final int cmode = consumerMode.get();
    final long waitTime = timeout.get();
    Rendezvous exchanger_ = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("EDU.oswego.cs.dl.util.concurrent.misc.RNG");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        constructionLock = clazz;
        computeLoops = new SynchronizedInt(16, constructionLock);
        syncMode = new SynchronizedInt(0, constructionLock);
        producerMode = new SynchronizedInt(0, constructionLock);
        consumerMode = new SynchronizedInt(0, constructionLock);
        bias = new SynchronizedInt(0, constructionLock);
        timeout = new SynchronizedLong(100L, constructionLock);
        exchangeParties = new SynchronizedInt(1, constructionLock);
        sequenceNumber = new SynchronizedInt(0, constructionLock);
        itersPerBarrier = new SynchronizedInt(0, constructionLock);
    }

    RNG() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reset(int nthreads) {
        Object object = constructionLock;
        synchronized (object) {
            sequenceNumber.set(-1);
            int parties = exchangeParties.get();
            if (nthreads < parties) {
                parties = nthreads;
            }
            if (nthreads % parties != 0) {
                throw new Error("need even multiple of parties");
            }
            exchangers_ = new Rendezvous[nthreads / parties];
            int i = 0;
            while (i < exchangers_.length) {
                RNG.exchangers_[i] = new Rendezvous(parties);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long nextSeed() {
        Object object = constructionLock;
        synchronized (object) {
            long s = lastSeed;
            lastSeed = lastSeed * 3125 % 32749;
            if (lastSeed == 0) {
                lastSeed = (int)System.currentTimeMillis();
            }
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Rendezvous getExchanger() {
        if (this.exchanger_ == null) {
            Object object = constructionLock;
            synchronized (object) {
                int idx = sequenceNumber.increment();
                this.exchanger_ = exchangers_[idx % exchangers_.length];
            }
        }
        return this.exchanger_;
    }

    public void exchange() throws InterruptedException {
        Rendezvous ex = this.getExchanger();
        Runnable r = (Runnable)ex.rendezvous(new UpdateCommand(this));
        if (r != null) {
            r.run();
        }
    }

    public int compareTo(Object other) {
        int h2;
        int h1 = this.hashCode();
        if (h1 < (h2 = other.hashCode())) {
            return -1;
        }
        if (h1 > h2) {
            return 1;
        }
        return 0;
    }

    protected final long compute(long l) {
        int loops = (int)((l & Integer.MAX_VALUE) % (long)(this.cloops * 2)) + 1;
        int i = 0;
        while (i < loops) {
            l = l * 16807L % Integer.MAX_VALUE;
            ++i;
        }
        return l == 0L ? 4321L : l;
    }

    protected abstract void set(long var1);

    protected abstract long internalGet();

    protected abstract void internalUpdate();

    public long get() {
        return this.internalGet();
    }

    public void update() {
        this.internalUpdate();
    }

    public long next() {
        this.internalUpdate();
        return this.internalGet();
    }
}

