/*
 * Decompiled with CFR 0.152.
 */
package com.sas.app;

import com.sas.app.FilePluginData;
import com.sas.app.NameVersion;
import com.sas.app.Plugin;
import com.sas.app.PluginRequest;
import com.sas.app.Repository;
import com.sas.app.RepositoryException;
import com.sas.app.RepositoryOptions;
import com.sas.app.Stringy;
import com.sas.app.Util;
import com.sas.app.VersionSpec;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class PluginsDirRepository
extends Repository {
    private static boolean RUN_DEAD_CODE = false;
    static final String REL_PATH_TO_PLUGINS = "plugins";
    private static final String INDEX_FILE_NAME = "com.sas.app.launcher.cacheFile";
    private static final int INDEX_FILE_FORMAT_VERSION = 5;
    private static final byte[] MAGIC;
    private final File m_eclipseDir;
    private final Map m_map;
    private final long m_timestamp;

    static Repository newChain(File[] eclipseDirs, boolean devLookThrough) throws IllegalArgumentException, RepositoryException {
        return PluginsDirRepository.newChain(eclipseDirs, devLookThrough, null);
    }

    static Repository newChain(File[] eclipseDirs, boolean devLookThrough, RepositoryOptions repositoryOptions) throws IllegalArgumentException, RepositoryException {
        if (eclipseDirs == null) {
            throw Util.illegalNull("eclipseDirs");
        }
        if (eclipseDirs.length <= 0) {
            throw Util.illegalArgument("eclipseDirs.length", new Integer(eclipseDirs.length));
        }
        if (repositoryOptions == null) {
            repositoryOptions = new RepositoryOptions();
        }
        PluginsDirRepository rc = null;
        for (int i = eclipseDirs.length - 1; i >= 0; --i) {
            File loc = eclipseDirs[i];
            if (loc == null) {
                throw Util.illegalNull("eclipseDirs[" + i + ']');
            }
            rc = new PluginsDirRepository(loc, rc, false, devLookThrough, repositoryOptions);
        }
        assert (rc != null);
        return rc;
    }

    private static boolean readMagic(DataInput d) throws IOException {
        byte[] temp = new byte[MAGIC.length];
        d.readFully(temp);
        for (int i = 0; i < temp.length; ++i) {
            if (temp[i] == MAGIC[i]) continue;
            return false;
        }
        return true;
    }

    private static Plugin[] readPlugins(DataInput s, String idName, File pluginsDir) throws IOException {
        int n = s.readInt();
        if (n <= 0) {
            throw new IOException();
        }
        Plugin[] rc = new Plugin[n];
        for (int i = 0; i < n; ++i) {
            Plugin p = FilePluginData.readPluginFrom(s, idName, pluginsDir);
            if (p == null) {
                throw new IOException();
            }
            rc[i] = p;
        }
        return rc;
    }

    private static Map readChosenFromIndex(DataInput dis, File pluginsDir) throws IOException {
        Stringy s = new Stringy(dis);
        s.readStringTable();
        int n = s.readInt();
        if (n < 0) {
            return null;
        }
        HashMap<String, Plugin[]> map = new HashMap<String, Plugin[]>();
        for (int i = 0; i < n; ++i) {
            String idName = s.readUTF();
            Plugin[] plugins = PluginsDirRepository.readPlugins(s, idName, pluginsDir);
            map.put(idName, plugins);
        }
        return map;
    }

    private static Map reindex(File indexFile, File pluginsDir, boolean useCurrentIndex, Boolean writeIndex, long[] rcTimestamp) {
        HashMap oldFiles;
        long timestamp = System.currentTimeMillis();
        if (FilePluginData.DEBUG_INDEX) {
            System.out.println("reindexing vjr at " + new Date() + ", plugins dir: " + pluginsDir);
        }
        HashMap hashMap = oldFiles = useCurrentIndex ? null : PluginsDirRepository.loadIndex(indexFile);
        if (oldFiles == null) {
            oldFiles = new HashMap();
        }
        String[] filenames = pluginsDir.list();
        HashMap<String, FilePluginData> updatedFiles = new HashMap<String, FilePluginData>();
        boolean anyChanges = false;
        if (filenames != null && filenames.length > 0) {
            FilePluginData.AttrScanner scanner = new FilePluginData.AttrScanner();
            if (FilePluginData.DEBUG_INDEX) {
                Object[] sort = new String[filenames.length];
                System.arraycopy(filenames, 0, sort, 0, filenames.length);
                Arrays.sort(sort);
                System.out.println("Directory listing of " + pluginsDir + ":");
                for (int i = 0; i < sort.length; ++i) {
                    System.out.println("\t" + i + ": " + (String)sort[i]);
                }
            }
            for (int i = 0; i < filenames.length; ++i) {
                String fname = filenames[i];
                FilePluginData oldData = (FilePluginData)oldFiles.get(fname);
                FilePluginData newData = FilePluginData.refresh(pluginsDir, fname, oldData, scanner);
                updatedFiles.put(fname, newData);
                anyChanges |= newData != oldData;
            }
        }
        anyChanges |= oldFiles.size() != updatedFiles.size();
        ArrayList<FilePluginData> unusedNoName = new ArrayList<FilePluginData>();
        ArrayList<FilePluginData> unused = new ArrayList<FilePluginData>();
        HashMap<String, ArrayList<FilePluginData>> index = new HashMap<String, ArrayList<FilePluginData>>();
        for (FilePluginData p : updatedFiles.values()) {
            String name = p.m_idName;
            if (name == null) {
                unusedNoName.add(p);
                continue;
            }
            if (p.m_version == null) {
                unused.add(p);
                continue;
            }
            ArrayList<FilePluginData> list = (ArrayList<FilePluginData>)index.get(name);
            if (list == null) {
                list = new ArrayList<FilePluginData>();
                index.put(name, list);
            }
            list.add(p);
        }
        HashMap<VersionSpec, FilePluginData> versions = new HashMap<VersionSpec, FilePluginData>();
        Iterator<Object> it = index.entrySet().iterator();
        while (it.hasNext()) {
            versions.clear();
            Map.Entry entry = (Map.Entry)it.next();
            String idName = (String)entry.getKey();
            List list = (List)entry.getValue();
            Iterator it2 = list.iterator();
            while (it2.hasNext()) {
                FilePluginData p = (FilePluginData)it2.next();
                VersionSpec v = p.m_version;
                FilePluginData curBest = (FilePluginData)versions.get(v);
                if (curBest == null || PluginsDirRepository.isBetterThan(p.m_filename, curBest.m_filename, idName, v)) {
                    versions.put(v, p);
                    continue;
                }
                it2.remove();
                unused.add(p);
            }
            assert (list.size() > 0);
            Object[] array = list.toArray(new FilePluginData[list.size()]);
            Arrays.sort(array);
            entry.setValue(array);
        }
        if (writeIndex == null ? anyChanges : writeIndex != false) {
            PluginsDirRepository.storeTo(indexFile, index, unused, unusedNoName, timestamp);
        }
        long t3 = System.currentTimeMillis();
        if (rcTimestamp != null && rcTimestamp.length > 0) {
            rcTimestamp[0] = timestamp;
        }
        if (FilePluginData.DEBUG_INDEX) {
            System.out.println("reindexing took " + (double)(t3 - timestamp) / 1000.0 + "s for vjr at plugins dir: " + pluginsDir);
        }
        return index;
    }

    /*
     * Exception decompiling
     */
    private static Map loadIndex(File indexFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 13[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean isBetterThan(String filename1, String filenameCurBest, String idName, VersionSpec version) {
        int score2;
        String vstring;
        int score1;
        if (filename1.endsWith(".jar")) {
            filename1 = filename1.substring(0, filename1.length() - 4);
        }
        if (filenameCurBest.endsWith(".jar")) {
            filenameCurBest = filenameCurBest.substring(0, filenameCurBest.length() - 4);
        }
        if ((score1 = NameVersion.scoreNameMatch(filename1, idName, vstring = version.toVersionString())) != (score2 = NameVersion.scoreNameMatch(filenameCurBest, idName, vstring))) {
            return score1 > score2;
        }
        return filename1.compareTo(filenameCurBest) < 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void storeTo(File indexFile, Map chosen, List unused, List unusedNoName, long timestamp) {
        FileOutputStream s = null;
        DataOutputStream os = null;
        try {
            s = new FileOutputStream(indexFile);
            BufferedOutputStream bos = new BufferedOutputStream(s);
            os = new DataOutputStream(bos);
            Stringy stringy = new Stringy(os);
            PluginsDirRepository.storeTo(stringy, chosen, unused, unusedNoName);
            stringy.finishGathering();
            os.write(MAGIC);
            os.writeInt(5);
            os.writeLong(timestamp);
            stringy.writeStringTable();
            PluginsDirRepository.storeTo(stringy, chosen, unused, unusedNoName);
        }
        catch (IOException iOException) {
            Util.close(os);
            Util.close(s);
            catch (Throwable throwable) {
                Util.close(os);
                Util.close(s);
                throw throwable;
            }
        }
        Util.close(os);
        Util.close(s);
    }

    private static void storeTo(DataOutput s, Map chosen, List unused, List unusedNoName) throws IOException {
        FilePluginData p;
        int i;
        int n = chosen.size();
        s.writeInt(n);
        Iterator it = chosen.entrySet().iterator();
        for (i = 0; i < n; ++i) {
            Map.Entry entry = it.next();
            s.writeUTF((String)entry.getKey());
            FilePluginData[] array = (FilePluginData[])entry.getValue();
            s.writeInt(array.length);
            for (int j = 0; j < array.length; ++j) {
                array[j].writeTo(s);
            }
        }
        n = unused.size();
        s.writeInt(n);
        it = unused.iterator();
        for (i = 0; i < n; ++i) {
            p = (FilePluginData)((Object)it.next());
            assert (p.m_idName != null);
            s.writeUTF(p.m_idName);
            p.writeTo(s);
        }
        n = unusedNoName.size();
        s.writeInt(n);
        it = unusedNoName.iterator();
        for (i = 0; i < n; ++i) {
            p = (FilePluginData)((Object)it.next());
            p.writeTo(s);
        }
    }

    @Override
    protected Plugin localFind(PluginRequest request) throws IllegalArgumentException {
        if (request == null) {
            throw Util.illegalNull("request");
        }
        Plugin[] plugins = (Plugin[])this.m_map.get(request.getName());
        if (plugins == null) {
            return null;
        }
        assert (plugins.length > 0);
        VersionSpec range = request.getRange();
        for (int i = 0; i < plugins.length; ++i) {
            Plugin p = plugins[i];
            VersionSpec v = p.getVersion();
            if (range.includes(v)) {
                return p;
            }
            if (range.compareTo(v) <= 0) continue;
            return null;
        }
        return null;
    }

    @Override
    protected Plugin[] localFindAll(PluginRequest request) throws IllegalArgumentException {
        if (request == null) {
            throw Util.illegalNull("request");
        }
        Plugin[] plugins = (Plugin[])this.m_map.get(request.getName());
        if (plugins == null) {
            return Plugin.ZERO_PLUGINS;
        }
        assert (plugins.length > 0);
        VersionSpec range = request.getRange();
        if (VersionSpec.ANY.equals(range)) {
            Plugin[] rc = new Plugin[plugins.length];
            System.arraycopy(plugins, 0, rc, 0, rc.length);
            return rc;
        }
        int first = -1;
        int last = 0;
        for (int i = 0; i < plugins.length; ++i) {
            Plugin p = plugins[i];
            VersionSpec v = p.getVersion();
            if (!range.includes(v)) {
                if (first < 0 && range.compareTo(v) <= 0) continue;
                break;
            }
            if (first < 0) {
                first = i;
            }
            last = i;
        }
        if (first < 0) {
            return Plugin.ZERO_PLUGINS;
        }
        Plugin[] rc = new Plugin[last - first + 1];
        System.arraycopy(plugins, first, rc, 0, rc.length);
        return rc;
    }

    @Override
    protected void localPutAllPlugins(Map map) throws IllegalArgumentException {
        if (map == null) {
            throw Util.illegalNull("map");
        }
        for (Plugin[] plugins : this.m_map.values()) {
            assert (plugins != null);
            assert (plugins.length > 0);
            for (int i = 0; i < plugins.length; ++i) {
                Plugin p = plugins[i];
                map.put(new NameVersion(p.getName(), p.getVersion()), p);
            }
        }
    }

    @Override
    protected long localGetTimestamp() {
        return this.m_timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    private PluginsDirRepository(File eclipseDir, Repository parent, boolean reindex, boolean devLookThrough, RepositoryOptions repositoryOptions) throws IllegalArgumentException {
        super(parent, devLookThrough, repositoryOptions);
        File baseLocation;
        if (eclipseDir == null) {
            throw Util.illegalNull("eclipseDir");
        }
        this.m_eclipseDir = baseLocation = Util.canonical(eclipseDir);
        File indexFile = new File(baseLocation, INDEX_FILE_NAME);
        File pluginsDir = new File(baseLocation, REL_PATH_TO_PLUGINS);
        long timestamp = 0L;
        Map map = null;
        if (!reindex && !repositoryOptions.m_noindex) {
            FileInputStream is;
            block13: {
                is = null;
                try {
                    is = new FileInputStream(indexFile);
                    DataInputStream dis = new DataInputStream(new BufferedInputStream(is));
                    if (!PluginsDirRepository.readMagic(dis) || dis.readInt() != 5) break block13;
                    timestamp = dis.readLong();
                    map = PluginsDirRepository.readChosenFromIndex(dis, pluginsDir);
                }
                catch (IOException dis) {
                    Util.close(is);
                    catch (Throwable throwable) {
                        Util.close(is);
                        throw throwable;
                    }
                }
            }
            Util.close(is);
        }
        if (map == null) {
            long[] rcTimestamp = new long[1];
            map = PluginsDirRepository.reindex(indexFile, pluginsDir, !reindex, repositoryOptions.m_noindex ? Boolean.FALSE : (reindex ? Boolean.TRUE : null), rcTimestamp);
            for (Map.Entry entry : map.entrySet()) {
                FilePluginData[] array = (FilePluginData[])entry.getValue();
                assert (array != null);
                assert (array.length > 0);
                Plugin[] plugins = new Plugin[array.length];
                for (int i = 0; i < array.length; ++i) {
                    Plugin p = array[i].toPlugin(pluginsDir);
                    if (p == null) {
                        assert (false);
                        throw new IllegalStateException();
                    }
                    plugins[i] = p;
                }
                entry.setValue(plugins);
            }
            timestamp = rcTimestamp[0];
        }
        this.m_map = map;
        this.m_timestamp = timestamp;
    }

    private PluginsDirRepository(File eclipseDir, Map map, long timestamp, Repository parent, boolean devLookThrough, RepositoryOptions repositoryOptions) {
        super(parent, devLookThrough, repositoryOptions);
        if (eclipseDir == null) {
            assert (false);
            throw Util.illegalNull("eclipseDir");
        }
        this.m_eclipseDir = eclipseDir;
        this.m_map = map;
        this.m_timestamp = timestamp;
    }

    @Override
    protected File getLocation() {
        return this.m_eclipseDir;
    }

    @Override
    public Repository reindex(long ifNotNewerThan) {
        Repository oldParent = this.getParent();
        Repository newParent = oldParent != null ? oldParent.reindex(ifNotNewerThan) : null;
        long timestamp = this.getTimestamp();
        if (timestamp <= ifNotNewerThan) {
            return new PluginsDirRepository(this.m_eclipseDir, newParent, true, this.isDevLookThrough(), this.getOptions());
        }
        if (newParent == oldParent) {
            return this;
        }
        return new PluginsDirRepository(this.m_eclipseDir, new HashMap(this.m_map), timestamp, newParent, this.isDevLookThrough(), this.getOptions());
    }

    public String toString() {
        long nLocalPlugins = 0L;
        for (Plugin[] plugins : this.m_map.values()) {
            assert (plugins != null);
            assert (plugins.length > 0);
            nLocalPlugins += (long)plugins.length;
        }
        StringBuffer b = new StringBuffer();
        b.append("PluginsDirRepository ");
        b.append(this.m_eclipseDir.toString());
        b.append("contains ").append(nLocalPlugins);
        b.append(" plugins with ").append(this.m_map.size());
        b.append(" distinct names");
        Repository parent = this.getParent();
        if (parent != null) {
            b.append(", parent: ").append(parent.toString());
        }
        return b.toString();
    }

    static {
        if (RUN_DEAD_CODE) {
            new FilePluginData();
        }
        try {
            MAGIC = "SASVJRIndex".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

