/*
 * Decompiled with CFR 0.152.
 */
package com.sas.app;

import com.sas.app.BundleNativeCode;
import com.sas.app.PickList;
import com.sas.app.PluginRequest;
import com.sas.app.RepositoryException;
import com.sas.app.Util;
import com.sas.app.VersionSpec;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class Plugin {
    static final Plugin[] ZERO_PLUGINS = new Plugin[0];
    private final String m_fileName;
    private final String m_idName;
    private final VersionSpec m_version;
    private final String m_propBundleClasspath;
    private final String m_propRequireBundles;
    private final String m_propBundleNativeCode;
    private final String m_propFragmentHost;
    private final File m_parent;
    private final boolean m_tainted;
    private File m_file;
    private Manifest m_bundleManifest;
    private URL[] m_bundleClasspath;
    private PickList m_requiredBundles;
    private Map m_selectedNativeLibs;

    Plugin(File parent, String filename, File f, String idName, VersionSpec version, String propBundleClasspath, String propRequireBundles, String propBundleNativeCode, String propFragmentHost, boolean tainted) {
        if (parent == null && f == null) {
            throw Util.illegalNull("parent");
        }
        if (version.isRange()) {
            throw Util.illegalArgument("version.isRange()", version.toString());
        }
        this.m_parent = parent;
        this.m_fileName = filename;
        this.m_file = f;
        this.m_idName = idName;
        this.m_version = version;
        this.m_propBundleClasspath = propBundleClasspath;
        this.m_propRequireBundles = propRequireBundles;
        if (propBundleNativeCode != null && (propBundleNativeCode = propBundleNativeCode.trim()).length() <= 0) {
            propBundleNativeCode = null;
        }
        this.m_propBundleNativeCode = propBundleNativeCode;
        if (propFragmentHost != null && propFragmentHost.trim().length() <= 0) {
            propFragmentHost = null;
        }
        this.m_propFragmentHost = propFragmentHost;
        this.m_tainted = tainted;
    }

    public String getName() {
        return this.m_idName;
    }

    public VersionSpec getVersion() {
        return this.m_version;
    }

    boolean isTainted() {
        return this.m_tainted;
    }

    public synchronized File getFile() {
        File f = this.m_file;
        if (f == null) {
            this.m_file = f = new File(this.m_parent, this.m_fileName);
        }
        return f;
    }

    public synchronized Manifest getBundleManifest() throws RepositoryException {
        Manifest rc = this.m_bundleManifest;
        if (rc == null) {
            File f = this.getFile();
            FileInputStream s = null;
            JarFile jf = null;
            try {
                if (f.isDirectory()) {
                    s = new FileInputStream(new File(f, "META-INF/MANIFEST.MF"));
                    rc = new Manifest(s);
                } else {
                    jf = new JarFile(f);
                    rc = jf.getManifest();
                    if (rc == null) {
                        throw new RepositoryException(Util.format("Plugin.loadBundleManifest.ex.txt"));
                    }
                }
            }
            catch (IOException e) {
                try {
                    throw new RepositoryException(Util.format("Plugin.loadBundleManifest.ex.txt"), e);
                }
                catch (Throwable throwable) {
                    Util.close(jf);
                    Util.close(s);
                    throw throwable;
                }
            }
            Util.close(jf);
            Util.close(s);
            this.m_bundleManifest = rc;
        }
        return new Manifest(rc);
    }

    public synchronized URL[] getBundleClasspath() {
        URL[] cachedValue = this.m_bundleClasspath;
        if (cachedValue == null) {
            URL u;
            String temp = this.m_propBundleClasspath;
            HashSet seenFiles = new HashSet();
            ArrayList<URL> rc = new ArrayList<URL>();
            if (temp != null && !".".equals(temp.trim())) {
                File plugin = null;
                StringTokenizer tok = new StringTokenizer(temp.trim(), ",");
                block0: while (tok.hasMoreTokens()) {
                    File f;
                    String s = tok.nextToken();
                    if (s == null || (s = s.trim()).length() <= 0) continue;
                    if (plugin == null) {
                        plugin = this.getFile();
                    }
                    for (File p = f = new File(plugin, s); p != null; p = p.getParentFile()) {
                        if (!plugin.equals(p) || (f = Util.canonical(new File(plugin, s))) == null || seenFiles.contains(f)) continue;
                        URL u2 = Util.toURL(f);
                        if (u2 == null) continue block0;
                        rc.add(u2);
                        continue block0;
                    }
                }
            }
            if (rc.size() <= 0 && (u = Util.toURL(this.getFile())) != null) {
                rc.add(u);
            }
            this.m_bundleClasspath = cachedValue = rc.toArray(new URL[rc.size()]);
        }
        URL[] rc = new URL[cachedValue.length];
        System.arraycopy(cachedValue, 0, rc, 0, cachedValue.length);
        return rc;
    }

    public synchronized PickList getRequiredBundles() throws RepositoryException {
        PickList cachedValue = this.m_requiredBundles;
        if (cachedValue == null) {
            if (this.m_propRequireBundles != null) {
                PluginRequest[] requests = PluginRequest.parseRequireBundle(this.m_propRequireBundles);
                if (requests == null) {
                    throw new RepositoryException(Util.format("Plugin.getRequireBundle.ex.fmt.txt", this.m_idName, this.m_version != null ? this.m_version.toVersionString() : null, this.getFile(), this.m_propRequireBundles));
                }
                cachedValue = new PickList(Arrays.asList(requests), true);
            } else {
                cachedValue = PickList.EMPTY;
            }
            this.m_requiredBundles = cachedValue;
        }
        return cachedValue;
    }

    public synchronized Map getSelectedNativeLibs() throws RepositoryException {
        Map cachedValue = this.m_selectedNativeLibs;
        if (cachedValue == null) {
            if (this.m_propBundleNativeCode != null) {
                Map rel = BundleNativeCode.calcSelectedNativeLibs(this.m_propBundleNativeCode);
                if (!rel.isEmpty()) {
                    File base = this.getFile();
                    if (!base.isDirectory()) {
                        throw new RepositoryException(Util.format("Plugin.bundleNativeCode.nonDir.ex.fmt.txt", base));
                    }
                    HashMap<String, File> rc = new HashMap<String, File>();
                    HashMap<File, String> canonicalTargetPaths = new HashMap<File, String>();
                    for (Map.Entry entry : rel.entrySet()) {
                        String libName = (String)entry.getKey();
                        String relPath = (String)entry.getValue();
                        if (relPath.equals("/")) {
                            throw new RepositoryException(Util.format("BundleNativeCode.Clause.rootPath.ex.fmt.txt", new Integer(-1), this.m_propBundleNativeCode));
                        }
                        if (relPath.startsWith("/")) {
                            relPath = relPath.substring(1);
                        }
                        if (rc.containsKey(libName)) {
                            throw new RepositoryException(Util.format("BundleNativeCode.select.collision.ex.fmt.txt", libName, canonicalTargetPaths.get(rc.get(libName)), relPath));
                        }
                        File lib = Util.canonical(new File(base, relPath));
                        if (!Plugin.isStrictDescendent(base, lib)) {
                            throw new RepositoryException(Util.format("Plugin.bundleNativeCode.path.ex.fmt.txt", relPath));
                        }
                        if (!lib.isFile()) {
                            throw new RepositoryException(Util.format("Plugin.bundleNativeCode.path.notFile.ex.fmt.txt", relPath, lib));
                        }
                        if (canonicalTargetPaths.containsKey(lib)) {
                            throw new RepositoryException(Util.format("Plugin.bundleNativeCode.path.collision.ex.fmt.txt", relPath, canonicalTargetPaths.get(lib), lib));
                        }
                        canonicalTargetPaths.put(lib, relPath);
                        rc.put(libName, lib);
                    }
                    cachedValue = Collections.unmodifiableMap(rc);
                } else {
                    cachedValue = Collections.EMPTY_MAP;
                }
            } else {
                cachedValue = Collections.EMPTY_MAP;
            }
            this.m_selectedNativeLibs = cachedValue;
        }
        return cachedValue;
    }

    private static boolean isStrictDescendent(File base, File descendent) {
        if (base == null || descendent == null) {
            assert (false);
            return false;
        }
        for (File p = descendent.getParentFile(); p != null; p = p.getParentFile()) {
            if (!base.equals(p)) continue;
            return true;
        }
        return false;
    }

    public String getFragmentHostValue() {
        return this.m_propFragmentHost;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("Plugin ");
        if (this.m_idName != null && this.m_version != null) {
            b.append(this.m_idName).append(' ').append(this.m_version.toVersionString());
        } else {
            b.append(this.m_file.getName());
        }
        if (this.m_tainted) {
            b.append(" (TAINTED)");
        }
        return b.toString();
    }
}

