/*
 * Decompiled with CFR 0.152.
 */
package com.sas.app;

import com.sas.app.Util;
import java.security.PrivilegedAction;

class GetSystemPropertyAction
implements PrivilegedAction {
    private String[] m_keys;
    private String[] m_rcValues;

    GetSystemPropertyAction(String key) throws IllegalArgumentException {
        if (key == null) {
            throw Util.illegalNull("key");
        }
        if (key.length() <= 0) {
            throw Util.illegalArgument("key", key);
        }
        this.m_keys = new String[]{key};
    }

    GetSystemPropertyAction(String[] keys) throws IllegalArgumentException {
        if (keys == null) {
            throw Util.illegalNull("keys");
        }
        if (keys.length <= 0) {
            throw Util.illegalArgument("keys.length", new Integer(keys.length));
        }
        String[] copy = new String[keys.length];
        System.arraycopy(keys, 0, copy, 0, keys.length);
        for (int i = 0; i < copy.length; ++i) {
            String key = copy[i];
            if (key == null) {
                throw Util.illegalNull("keys[" + i + ']');
            }
            if (key.length() > 0) continue;
            throw Util.illegalArgument("keys[" + i + ']', key);
        }
        this.m_keys = copy;
    }

    public String getValue() throws IllegalStateException {
        String[] values = this.m_rcValues;
        if (values == null || values.length <= 0) {
            throw new IllegalStateException();
        }
        return values[0];
    }

    public String[] getValues() {
        String[] values = this.m_rcValues;
        if (values == null || values.length <= 0) {
            throw new IllegalStateException();
        }
        String[] rc = new String[values.length];
        System.arraycopy(values, 0, rc, 0, values.length);
        return rc;
    }

    public Object run() {
        String[] keys = this.m_keys;
        String[] values = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            values[i] = System.getProperty(keys[i]);
        }
        this.m_rcValues = values;
        return values[0];
    }
}

