/*
 * Decompiled with CFR 0.152.
 */
package com.sas.jms.logging;

import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.util.Hashtable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

class JMSAppender {
    Hashtable environment = new Hashtable();
    String factoryName;
    String destinationName;
    String username;
    String sasPassword;
    int persistence = 2;
    int priority = -1;
    boolean prioritize = false;
    long timeToLive = 0L;
    Context context;
    ConnectionFactory factory;
    Destination destination;
    Connection connection;
    Session session;
    MessageProducer producer;
    TextMessage textMsg;

    public void setOption(String name, Object value) throws SasPasswordEncodingException {
        if (name.equalsIgnoreCase("factory")) {
            this.factoryName = value.toString();
        } else if (name.equalsIgnoreCase("queue") || name.equalsIgnoreCase("destination")) {
            this.destinationName = value.toString();
        } else if (name.equalsIgnoreCase("persistent") && value.toString().equalsIgnoreCase("false")) {
            this.persistence = 1;
        } else if (name.equalsIgnoreCase("prioritize") && value.toString().equalsIgnoreCase("true")) {
            this.prioritize = true;
        } else if (name.equalsIgnoreCase("priority")) {
            this.priority = Integer.parseInt(value.toString());
        } else if (name.equalsIgnoreCase("username")) {
            this.username = value.toString();
        } else if (name.equalsIgnoreCase("SasEncodedPassword")) {
            this.sasPassword = SasPasswordString.decode((String)value.toString());
        } else if (name.equalsIgnoreCase("timetolive")) {
            this.timeToLive = Long.parseLong(value.toString());
        } else {
            this.environment.put(name, value);
        }
    }

    public void activate() throws NamingException, JMSException {
        this.context = new InitialContext(this.environment);
        this.factory = (ConnectionFactory)this.context.lookup(this.factoryName);
        this.destination = (Destination)this.context.lookup(this.destinationName);
        if (null == this.username) {
            this.username = System.getProperty("user.name");
        }
        this.connection = this.factory.createConnection(this.username, this.sasPassword);
        this.session = this.connection.createSession(false, 1);
        this.producer = this.session.createProducer(this.destination);
        this.textMsg = this.session.createTextMessage();
    }

    public void append(int level, String logger, String msg) throws JMSException {
        this.textMsg.setText(msg);
        this.textMsg.setJMSPriority(level);
        this.textMsg.setLongProperty("Level", (long)level);
        this.textMsg.setStringProperty("Logger", logger);
        int actualPriority = this.producer.getPriority();
        if (this.priority >= 0) {
            actualPriority = this.priority;
        } else if (this.prioritize) {
            actualPriority = level;
        }
        this.producer.send((Message)this.textMsg, this.persistence, actualPriority, this.timeToLive);
    }

    public void destroy() throws JMSException {
        if (this.producer != null) {
            this.producer.close();
        }
        if (this.session != null) {
            this.session.close();
        }
        if (this.connection != null) {
            this.connection.close();
        }
    }
}

