/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.utilities;

import com.sas.scheduler.api.servers.sasjfs.engine.ClientLogger;
import com.sas.scheduler.api.servers.sasjfs.utilities.threadpool.ThreadPool;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.apache.commons.lang.SystemUtils;

public class OSCommand {
    public static final String GenericShellExitCommand = "exit";
    private ClientLogger m_logger;
    private Process m_process;
    private boolean m_killed = false;
    private String m_jobCommand;

    public OSCommand(String jobCommand, ClientLogger logger) {
        this.m_jobCommand = jobCommand;
        this.m_logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runJob(PrintStream outputStream, PrintStream errorStream) throws InterruptedException {
        InputStream errStream = null;
        InputStream oStream = null;
        try {
            String commandToRun = "";
            if (SystemUtils.IS_OS_WINDOWS) {
                commandToRun = "cmd.exe /c \"" + this.m_jobCommand + "\"";
            } else if (SystemUtils.IS_OS_LINUX) {
                commandToRun = "/bin/sh -x";
                this.m_jobCommand = this.m_jobCommand.replace("'", "\"");
            } else if (SystemUtils.IS_OS_AIX) {
                commandToRun = "/bin/sh -x -c";
            } else if (SystemUtils.IS_OS_SOLARIS || SystemUtils.IS_OS_SUN_OS) {
                commandToRun = "/bin/sh -x";
            } else if (SystemUtils.IS_OS_HP_UX) {
                commandToRun = "/bin/sh -x '";
                this.m_jobCommand = this.m_jobCommand.replace("'", "\\'") + "'";
            } else if (SystemUtils.IS_OS_UNIX) {
                commandToRun = "/bin/sh -x '";
                this.m_jobCommand = this.m_jobCommand.replace("'", "\\'") + "'";
            } else {
                commandToRun = "/bin/sh -x ";
            }
            this.m_process = Runtime.getRuntime().exec(commandToRun);
            if (!SystemUtils.IS_OS_WINDOWS) {
                PrintWriter commandWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.m_process.getOutputStream(), "UTF-8")), true);
                this.m_logger.logMessage(Level.FINE, String.format("piping job command %s to OS command processor", this.m_jobCommand));
                commandWriter.println(this.m_jobCommand);
                this.m_logger.logMessage(Level.FINE, "piping exit command to OS command processor");
                commandWriter.println(GenericShellExitCommand);
                commandWriter.close();
            }
            errStream = new BufferedInputStream(this.m_process.getErrorStream());
            oStream = new BufferedInputStream(this.m_process.getInputStream());
            AtomicInteger errorStreamFlag = new AtomicInteger(0);
            AtomicInteger outputStreamFlag = new AtomicInteger(0);
            this.grabStreamOutput(errStream, errorStream, errorStreamFlag);
            this.grabStreamOutput(oStream, outputStream, outputStreamFlag);
            this.m_killed = false;
            int exitValue = this.m_process.waitFor();
            OSCommand oSCommand = this;
            synchronized (oSCommand) {
                if (this.m_killed) {
                    throw new InterruptedException("Process killed by scheduler.");
                }
            }
            int outputWaitTicks = 0;
            while (errorStreamFlag.get() == 0 || outputStreamFlag.get() == 0) {
                Thread.sleep(500L);
                if (++outputWaitTicks <= 120) continue;
            }
            int n = exitValue;
            return n;
        }
        catch (InterruptedException e) {
            e.printStackTrace(errorStream);
            throw e;
        }
        catch (Exception e) {
            this.m_logger.logMessage(Level.WARNING, e);
            e.printStackTrace(errorStream);
            throw new RuntimeException(e);
        }
        finally {
            if (errStream != null) {
                try {
                    errStream.close();
                }
                catch (IOException e) {
                    this.m_logger.logMessage(Level.WARNING, e);
                }
            }
            if (oStream != null) {
                try {
                    oStream.close();
                }
                catch (IOException e) {
                    this.m_logger.logMessage(Level.WARNING, e);
                }
            }
        }
    }

    public Process getProcess() {
        return this.m_process;
    }

    public void killJob() {
        if (this.m_process != null) {
            this.m_process.destroy();
            this.m_process = null;
            this.m_killed = true;
        }
    }

    private void grabStreamOutput(final InputStream iStream, final PrintStream oStream, final AtomicInteger completeFlag) {
        ThreadPool.instance().executeAsynchronously(new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] buf = new byte[1024];
                    try {
                        int bytesRead;
                        while ((bytesRead = iStream.read(buf)) >= 0) {
                            oStream.write(buf, 0, bytesRead);
                        }
                    }
                    catch (IOException e) {
                        OSCommand.this.m_logger.logMessage(Level.FINE, e);
                    }
                }
                finally {
                    completeFlag.incrementAndGet();
                }
            }
        });
    }
}

