/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.utilities;

import com.sas.scheduler.api.servers.sasjfs.floworchestration.SocketFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JFSClient {
    private static final Logger logger = LogManager.getLogger(JFSClient.class);
    private final SocketFactory socketFactory;
    private final String m_host;
    private final int m_port;
    private final int m_bufSize;
    private final boolean isSSLEnabled;
    private static int minDefaultBufSize = 0xA00000;

    public JFSClient(SocketFactory socketFactory, String host, int port, boolean isSSLEnabled, int bufSize) {
        this.socketFactory = socketFactory;
        this.m_host = host;
        this.m_port = port;
        this.isSSLEnabled = isSSLEnabled;
        this.m_bufSize = bufSize > minDefaultBufSize ? bufSize : minDefaultBufSize;
    }

    protected JFOrchClientConnection connect() {
        JFOrchClientConnection connection = new JFOrchClientConnection();
        try {
            connection.socket = this.socketFactory.createSocket(this.m_host, this.m_port, this.isSSLEnabled);
            connection.outputStream = connection.socket.getOutputStream();
            connection.inputStream = connection.socket.getInputStream();
            logger.debug(String.format("host:[%s], port:[%s], ssl:[%s], bufSize:[%s]", this.m_host, this.m_port, this.isSSLEnabled, this.m_bufSize));
        }
        catch (Throwable cause) {
            logger.error(cause.getMessage());
        }
        return connection;
    }

    protected String sendRequestToServer(String requestString) {
        JFOrchClientConnection connection = null;
        String serverReturnMsg = "";
        connection = this.connect();
        logger.debug("Sending request to TCP Server");
        byte[] taskXmlMsgBuf = requestString.getBytes();
        byte[] msgBuf = new byte[this.m_bufSize];
        try {
            connection.outputStream.write(taskXmlMsgBuf);
            connection.outputStream.flush();
            Arrays.fill(msgBuf, (byte)0);
            connection.inputStream.read(msgBuf);
            serverReturnMsg = new String(msgBuf).trim();
            logger.debug("Received request back from TCP Server");
            connection.outputStream.close();
            logger.debug("Closing client socket...");
            connection.socket.close();
            logger.debug("TCP Client exiting.");
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            return serverReturnMsg;
        }
        catch (Throwable cause) {
            logger.error(cause.getMessage());
            return serverReturnMsg;
        }
        return serverReturnMsg;
    }

    private class JFOrchClientConnection {
        private Socket socket;
        private OutputStream outputStream;
        private InputStream inputStream;

        private JFOrchClientConnection() {
        }
    }
}

