/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.utilities;

import java.util.UUID;

public class CLIHelper {
    public static final String EMPTY = "";
    public static final String SPACE = " ";

    public static String genTriggerId() {
        String retval = UUID.randomUUID().toString();
        return retval;
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static String join(Iterable<?> iterable, char separator) {
        if (iterable == null) {
            return null;
        }
        return CLIHelper.join(iterable.iterator(), Character.valueOf(separator));
    }

    public static String join(Object[] array, String separator) {
        if (array == null) {
            return null;
        }
        return CLIHelper.join(array, separator, 0, array.length);
    }

    public static String join(Object[] array, String separator, int startIndex, int endIndex) {
        int noOfItems;
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = EMPTY;
        }
        if ((noOfItems = endIndex - startIndex) <= 0) {
            return EMPTY;
        }
        StringBuilder buf = CLIHelper.newStringBuilder(noOfItems);
        if (array[startIndex] != null) {
            buf.append(array[startIndex]);
        }
        for (int i = startIndex + 1; i < endIndex; ++i) {
            buf.append(separator);
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static <T> String join(T ... elements) {
        return CLIHelper.join((Object[])elements, null);
    }

    public static String normalizeSpace(String str) {
        if (CLIHelper.isEmpty(str)) {
            return str;
        }
        int size = str.length();
        char[] newChars = new char[size];
        int count = 0;
        int whitespacesCount = 0;
        boolean startWhitespaces = true;
        for (int i = 0; i < size; ++i) {
            char actualChar = str.charAt(i);
            boolean isWhitespace = Character.isWhitespace(actualChar);
            if (isWhitespace) {
                if (whitespacesCount == 0 && !startWhitespaces) {
                    newChars[count++] = SPACE.charAt(0);
                }
                ++whitespacesCount;
                continue;
            }
            startWhitespaces = false;
            newChars[count++] = actualChar == '\u00a0' ? 32 : (int)actualChar;
            whitespacesCount = 0;
        }
        if (startWhitespaces) {
            return EMPTY;
        }
        return new String(newChars, 0, count - (whitespacesCount > 0 ? 1 : 0)).trim();
    }

    private static StringBuilder newStringBuilder(int noOfItems) {
        return new StringBuilder(noOfItems * 16);
    }
}

