/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.trigger.serviceinterface;

import com.sas.scheduler.api.servers.sasjfs.trigger.OSTrigger;
import com.sas.scheduler.api.servers.sasjfs.trigger.serviceinterface.IUNIXTaskScheduler;
import com.sas.scheduler.model.DailyRecurrence;
import com.sas.scheduler.model.DateList;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.MonthlyRecurrence;
import com.sas.scheduler.model.TimeEventInfo;
import com.sas.scheduler.model.WeeklyRecurrence;
import com.sas.scheduler.model.YearlyRecurrence;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CronTriggers {
    List<TimeEventInfo> m_triggers;
    IUNIXTaskScheduler m_scheduler;
    protected String _scheduledCommand;

    public CronTriggers(List<TimeEventInfo> triggers, IUNIXTaskScheduler scheduler, String scheduledCommand) {
        this.m_triggers = triggers;
        this.m_scheduler = scheduler;
        this._scheduledCommand = scheduledCommand;
    }

    public List<String> getCrontabMap() {
        OSTrigger.LOGGER.debug("Creating crontab map structure from triggers.");
        ArrayList<String> crontabList = new ArrayList<String>();
        Map<String, String> crontabMap = null;
        OSTrigger.LOGGER.debug("triggers list size = " + this.m_triggers.size());
        for (int i = 0; i < this.m_triggers.size(); ++i) {
            TimeEventInfo timeEventInfo = this.m_triggers.get(i);
            String minutes = timeEventInfo.getMinutes();
            String hours = timeEventInfo.getHours();
            IRecurrenceInfo ir = timeEventInfo.getRecurrence();
            if (ir instanceof DailyRecurrence) {
                OSTrigger.LOGGER.debug("trigger is instanceof DailyRecurrence");
                crontabMap = this.setCronDaily(ir, minutes, hours);
            } else if (ir instanceof DateList) {
                OSTrigger.LOGGER.debug("trigger is instanceof DateList");
                crontabMap = this.setCronDate(ir, minutes, hours);
            } else if (ir instanceof WeeklyRecurrence) {
                OSTrigger.LOGGER.debug("trigger is instanceof WeeklyRecurrence");
                crontabMap = this.setCronWeekly(ir, minutes, hours);
            } else if (ir instanceof MonthlyRecurrence) {
                OSTrigger.LOGGER.debug("trigger is instanceof MonthlyRecurrence");
                crontabMap = this.setCronMonthly(ir, minutes, hours);
            } else if (ir instanceof YearlyRecurrence) {
                OSTrigger.LOGGER.debug("trigger is instanceof YearlyRecurrence");
                crontabMap = this.setCronYearly(ir, minutes, hours);
            } else {
                OSTrigger.LOGGER.debug("trigger instanceof is not supported, ignoring");
                continue;
            }
            if (crontabMap == null) {
                OSTrigger.LOGGER.debug("crontab map structure came back as null...ignoring. Check that skip count was set to 1 for any monthly recurrence triggers.");
                continue;
            }
            String crontabStr = this.m_scheduler.createCrontabString(crontabMap);
            crontabList.add(crontabStr + " " + this._scheduledCommand);
            OSTrigger.LOGGER.debug("Added: [" + crontabStr + " " + this._scheduledCommand + "] entry to crontabList");
        }
        OSTrigger.LOGGER.debug("crontabList size = " + crontabList.size());
        return crontabList;
    }

    private Map<String, String> setCronDaily(IRecurrenceInfo ir, String minutes, String hours) {
        Map<String, String> crontabMap = this.initCrontabMap();
        DailyRecurrence dr = (DailyRecurrence)ir;
        if (dr.getSkipCount() == 1) {
            if (dr.isWeekDays()) {
                crontabMap.put("weekday", "1-5");
            } else {
                crontabMap.put("weekday", "*");
            }
            crontabMap.put("day", "*");
            crontabMap.put("minute", minutes);
            crontabMap.put("hour", hours);
        } else {
            String[] tokens = hours.split("[,; -]");
            crontabMap.put("hour", tokens[0]);
            tokens = minutes.split("[,; -]");
            crontabMap.put("minute", tokens[0]);
        }
        return crontabMap;
    }

    private Map<String, String> setCronDate(IRecurrenceInfo ir, String minutes, String hours) {
        Map<String, String> crontabMap = this.initCrontabMap();
        DateList dl = (DateList)ir;
        Calendar startCal = null;
        List dlist = dl.getDatesToRun();
        if (dlist.size() > 0) {
            startCal = (Calendar)dlist.get(0);
        } else if (dl.getStartDate() != null) {
            startCal = dl.getStartDate();
        }
        if (startCal != null) {
            String[] tokens = hours.split("[,; -]");
            crontabMap.put("hour", tokens[0]);
            tokens = minutes.split("[,; -]");
            crontabMap.put("minute", tokens[0]);
            crontabMap.put("year", Integer.toString(startCal.get(1)));
            crontabMap.put("month", Integer.toString(startCal.get(2) + 1));
            crontabMap.put("day", Integer.toString(startCal.get(5)));
            crontabMap.put("weekday", "*");
        } else {
            crontabMap.put("hour", hours);
            crontabMap.put("minute", minutes);
        }
        return crontabMap;
    }

    private Map<String, String> setCronWeekly(IRecurrenceInfo ir, String minutes, String hours) {
        Map<String, String> crontabMap = this.initCrontabMap();
        WeeklyRecurrence w = (WeeklyRecurrence)ir;
        String wkdays = null;
        if (w.getSkipCount() == 1) {
            int mask = w.getDayOfWeekDataBinding();
            switch (mask) {
                case 64: {
                    wkdays = "0";
                    break;
                }
                case 1: {
                    wkdays = "1";
                    break;
                }
                case 2: {
                    wkdays = "2";
                    break;
                }
                case 4: {
                    wkdays = "3";
                    break;
                }
                case 8: {
                    wkdays = "4";
                    break;
                }
                case 16: {
                    wkdays = "5";
                    break;
                }
                case 32: {
                    wkdays = "6";
                    break;
                }
                case 96: {
                    wkdays = "0,6";
                    break;
                }
                case 31: {
                    wkdays = "1-5";
                    break;
                }
                case 127: {
                    wkdays = "*";
                    break;
                }
                default: {
                    if ((mask & 0x40) != 0) {
                        wkdays = "0";
                    }
                    if ((mask & 1) != 0) {
                        String string = wkdays = wkdays == null ? "1" : wkdays + ",1";
                    }
                    if ((mask & 2) != 0) {
                        String string = wkdays = wkdays == null ? "2" : wkdays + ",2";
                    }
                    if ((mask & 4) != 0) {
                        String string = wkdays = wkdays == null ? "3" : wkdays + ",3";
                    }
                    if ((mask & 8) != 0) {
                        String string = wkdays = wkdays == null ? "4" : wkdays + ",4";
                    }
                    if ((mask & 0x10) != 0) {
                        String string = wkdays = wkdays == null ? "5" : wkdays + ",5";
                    }
                    if ((mask & 0x20) == 0) break;
                    wkdays = wkdays + ",6";
                }
            }
            crontabMap.put("weekday", wkdays);
            String[] tokens = hours.split("[,; -]");
            crontabMap.put("hour", tokens[0]);
            tokens = minutes.split("[,; -]");
            crontabMap.put("minute", tokens[0]);
            crontabMap.put("day", "*");
        } else {
            int mask = w.getDayOfWeekDataBinding();
            switch (mask) {
                case 1: 
                case 2: 
                case 4: 
                case 8: 
                case 16: 
                case 32: 
                case 64: {
                    String[] tokens = hours.split("[,; -]");
                    crontabMap.put("hour", tokens[0]);
                    tokens = minutes.split("[,; -]");
                    crontabMap.put("minute", tokens[0]);
                    break;
                }
                default: {
                    throw new InvalidParameterException(w.toString());
                }
            }
        }
        return crontabMap;
    }

    private Map<String, String> setCronMonthly(IRecurrenceInfo ir, String minutes, String hours) {
        Map<String, String> crontabMap = this.initCrontabMap();
        MonthlyRecurrence m = (MonthlyRecurrence)ir;
        String dates = null;
        String wkdays = null;
        int skipCount = m.getSkipCount();
        if (skipCount != 1) {
            String msg = "A skip count value not equal to 1 is not supported for a monthly recurrence trigger...ignoring.";
            OSTrigger.LOGGER.debug(msg);
            return null;
        }
        if (m.getDayOfMonth() > 0) {
            dates = String.valueOf(m.getDayOfMonth());
        } else if (m.getDayOfWeek() > 0) {
            int week = m.getWhichWeek();
            int day = m.getDayOfWeek();
            if (day == 128) {
                dates = "L";
            } else {
                switch (day) {
                    case 64: {
                        wkdays = "0";
                        break;
                    }
                    case 1: {
                        wkdays = "1";
                        break;
                    }
                    case 2: {
                        wkdays = "2";
                        break;
                    }
                    case 4: {
                        wkdays = "3";
                        break;
                    }
                    case 8: {
                        wkdays = "4";
                        break;
                    }
                    case 16: {
                        wkdays = "5";
                        break;
                    }
                    case 32: {
                        wkdays = "6";
                    }
                }
                switch (week) {
                    case 1: {
                        wkdays = wkdays + "#1";
                        break;
                    }
                    case 2: {
                        wkdays = wkdays + "#2";
                        break;
                    }
                    case 3: {
                        wkdays = wkdays + "#3";
                        break;
                    }
                    case 4: {
                        wkdays = wkdays + "#4";
                        break;
                    }
                    case 6: {
                        wkdays = wkdays + "L";
                    }
                }
            }
        }
        crontabMap.put("weekday", CronTriggers.isEmpty(wkdays) ? "*" : wkdays);
        crontabMap.put("day", CronTriggers.isEmpty(dates) ? "*" : dates);
        crontabMap.put("minute", CronTriggers.isEmpty(minutes) ? "*" : minutes);
        crontabMap.put("hour", CronTriggers.isEmpty(hours) ? "*" : hours);
        return crontabMap;
    }

    private Map<String, String> setCronYearly(IRecurrenceInfo ir, String minutes, String hours) {
        Map<String, String> crontabMap = this.initCrontabMap();
        YearlyRecurrence y = (YearlyRecurrence)ir;
        String wkdays = null;
        String dates = null;
        String months = null;
        if (y.getSkipCount() != 1) {
            throw new InvalidParameterException(y.toString());
        }
        int month = y.getMonth();
        months = String.valueOf(month);
        if (y.getDayOfMonthDataBinding() > 0) {
            dates = String.valueOf(y.getDayOfMonthDataBinding());
        } else if (y.getDayOfWeek() > 0) {
            int week = y.getWhichWeek();
            int day = y.getDayOfWeek();
            if (day == 128) {
                dates = "L";
            } else {
                switch (day) {
                    case 64: {
                        wkdays = "0";
                        break;
                    }
                    case 1: {
                        wkdays = "1";
                        break;
                    }
                    case 2: {
                        wkdays = "2";
                        break;
                    }
                    case 4: {
                        wkdays = "3";
                        break;
                    }
                    case 8: {
                        wkdays = "4";
                        break;
                    }
                    case 16: {
                        wkdays = "5";
                        break;
                    }
                    case 32: {
                        wkdays = "6";
                    }
                }
                switch (week) {
                    case 1: {
                        wkdays = wkdays + "#1";
                        break;
                    }
                    case 2: {
                        wkdays = wkdays + "#2";
                        break;
                    }
                    case 3: {
                        wkdays = wkdays + "#3";
                        break;
                    }
                    case 4: {
                        wkdays = wkdays + "#4";
                        break;
                    }
                    case 6: {
                        wkdays = wkdays + "L";
                    }
                }
            }
        }
        crontabMap.put("weekday", CronTriggers.isEmpty(wkdays) ? "*" : wkdays);
        crontabMap.put("day", CronTriggers.isEmpty(dates) ? "*" : dates);
        crontabMap.put("month", CronTriggers.isEmpty(months) ? "*" : months);
        crontabMap.put("minute", CronTriggers.isEmpty(minutes) ? "*" : minutes);
        crontabMap.put("hour", CronTriggers.isEmpty(hours) ? "*" : hours);
        return crontabMap;
    }

    private Map<String, String> initCrontabMap() {
        OSTrigger.LOGGER.debug("Performing initCronMap()");
        HashMap<String, String> retval = new HashMap<String, String>();
        retval.put("second", "0");
        retval.put("minute", "*");
        retval.put("hour", "*");
        retval.put("day", "*");
        retval.put("month", "*");
        retval.put("weekday", "*");
        retval.put("year", "*");
        return retval;
    }

    public static boolean isEmpty(Object str) {
        return str == null || "".equals(str);
    }
}

