/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.trigger.serviceinterface;

import com.sas.scheduler.api.servers.ip.engine.mq.client.NullOutputStream;
import com.sas.scheduler.api.servers.sasjfs.SASJFScheduler;
import com.sas.scheduler.api.servers.sasjfs.utilities.CLIHelper;
import com.sas.scheduler.api.servers.sasjfs.utilities.OSCommand;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.Logger;

public class CronTab {
    private static Logger LOGGER = null;
    private static final String m_cronTabCommand = "/usr/bin/crontab";
    private static final String m_cronTabListCommand = "/usr/bin/crontab -l";
    private List<String> m_cronTabEntries;
    private String m_scheduledCommand;

    public CronTab(String scheduledCommand, Logger logger) {
        LOGGER = logger;
        this.m_cronTabEntries = new ArrayList<String>();
        this.m_scheduledCommand = scheduledCommand;
    }

    public String getScheduledCommand() {
        return this.m_scheduledCommand;
    }

    public List<String> getCronTabEntries() {
        return this.m_cronTabEntries;
    }

    public void setCronTabEntries(List<String> value) {
        this.m_cronTabEntries = value;
    }

    public int consumeCronTabFile(String filePath) {
        int retval;
        block2: {
            LOGGER.debug("Setting crontab from new crontab temp file.");
            retval = 0;
            OSCommand cronTabOSCommand = new OSCommand("/usr/bin/crontab " + filePath, SASJFScheduler.getLogger());
            PrintStream errorStream = new PrintStream(new NullOutputStream());
            PrintStream outputStream = new PrintStream(new NullOutputStream());
            try {
                retval = cronTabOSCommand.runJob(outputStream, errorStream);
            }
            catch (InterruptedException ie) {
                LOGGER.error((Object)ie);
                if (CLIHelper.isEmpty(ie.getMessage())) break block2;
                LOGGER.error(ie.getMessage());
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setExistingCronTabEntries() throws IOException {
        LOGGER.debug("Capturing existing user's crontab entries.");
        File tmpFile = File.createTempFile("sasjfs-", "-ostrigger");
        LOGGER.debug("Using OSCommand to exec: /usr/bin/crontab -l");
        OSCommand cronTabOSCommand = new OSCommand(m_cronTabListCommand, SASJFScheduler.getLogger());
        PrintStream errorStream = null;
        File tmpErr = null;
        if (LOGGER.isDebugEnabled()) {
            tmpErr = File.createTempFile("sasjfs-", "-ostrigger_error");
            errorStream = new PrintStream(tmpErr.getAbsolutePath());
        } else {
            errorStream = new PrintStream(new NullOutputStream());
        }
        PrintStream outputStream = new PrintStream(tmpFile.getAbsolutePath());
        int rc = 0;
        try {
            rc = cronTabOSCommand.runJob(outputStream, errorStream);
        }
        catch (InterruptedException ie) {
            LOGGER.error(ie.getMessage());
        }
        finally {
            outputStream.close();
            errorStream.close();
        }
        BufferedReader brCronTabEntries = null;
        BufferedReader brStdErr = null;
        try {
            String line;
            brCronTabEntries = new BufferedReader(new FileReader(tmpFile.getAbsolutePath()));
            while ((line = brCronTabEntries.readLine()) != null) {
                this.m_cronTabEntries.add(line);
            }
            if (tmpErr != null) {
                LOGGER.debug("===========STDERR=================");
                brStdErr = new BufferedReader(new FileReader(tmpErr.getAbsolutePath()));
                while ((line = brStdErr.readLine()) != null) {
                    LOGGER.debug(line);
                }
                LOGGER.debug("===========STDERR=================");
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        finally {
            if (brCronTabEntries != null) {
                brCronTabEntries.close();
            }
            if (brStdErr != null) {
                brStdErr.close();
            }
            if (tmpFile != null) {
                tmpFile.delete();
            }
            if (tmpErr != null) {
                tmpErr.delete();
            }
        }
        LOGGER.debug("Contents of crontab prior to modification:");
        String message = "";
        message = CollectionUtils.isEmpty(this.m_cronTabEntries) ? "existing crontab was empty" : CLIHelper.join(this.m_cronTabEntries, '\n');
        LOGGER.debug(message);
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createNewCronTabFile() {
        LOGGER.debug("Creating new crontab file in temp location.");
        String retval = null;
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("sasjfs-", "-ostrigger");
        }
        catch (IOException e) {
            LOGGER.error("IOException trying to create temp file for new crontab contents.");
            LOGGER.error(e.getMessage());
            String string = null;
            return string;
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
        LOGGER.debug("Writing out contents of original crontab - will append to this the new cron entries.");
        try (PrintWriter pw = null;){
            pw = new PrintWriter(new BufferedWriter(new FileWriter(tmpFile)));
            for (String ctEntry : this.m_cronTabEntries) {
                pw.println(ctEntry);
            }
        }
        LOGGER.debug("Created temp crontab file: " + tmpFile.getAbsolutePath());
        retval = tmpFile.getAbsolutePath();
        return retval;
    }

    public int deleteFromCronTab(String flowId) throws IOException {
        LOGGER.debug("Deleting all crontab entries for Flow ID: " + flowId);
        int retval = 0;
        ArrayList<String> newCtEntries = new ArrayList<String>(this.m_cronTabEntries.size());
        for (String ctLine : this.getCronTabEntries()) {
            String[] tokens = ctLine.split(" -execute ");
            if (tokens.length == 2) {
                String rightSide = tokens[1];
                String[] rightSideTokens = rightSide.split(" ");
                String ctFlowId = rightSideTokens[0];
                if (flowId.equals(ctFlowId)) continue;
                newCtEntries.add(ctLine);
                continue;
            }
            if (ctLine.trim().isEmpty()) continue;
            newCtEntries.add(ctLine);
        }
        this.setCronTabEntries(newCtEntries);
        String newCtFile = this.createNewCronTabFile();
        this.consumeCronTabFile(newCtFile);
        return retval;
    }
}

