/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.trigger;

import com.sas.launcher.client.Process;
import com.sas.launcher.client.ProcessState;
import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.sasjfs.mq.JMSUtilities;
import com.sas.scheduler.api.servers.sasjfs.trigger.OSTriggerClient;
import com.sas.scheduler.api.servers.sasjfs.trigger.OSTriggerUtilities;
import com.sas.scheduler.api.servers.sasjfs.utilities.CLIReturnCodes;
import com.sas.scheduler.api.servers.sasjfs.utilities.SASJFSLauncherClient;
import com.sas.scheduler.model.AbstractEventInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.GroupingEventInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.TimeEventInfo;
import com.sas.scheduler.model.TriggerEventInfo;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.springframework.jms.core.BrowserCallback;
import org.springframework.jms.core.JmsTemplate;

public class OSTriggerService {
    public static Logger LOGGER = null;
    private static String m_config = OSTriggerService.class.getProtectionDomain().getCodeSource().getLocation().getPath();
    private static String m_name = "SASJFS-OSTrigger-init-thread";
    private static String m_id;
    private static String m_launcherHost;
    private static int m_launcherPort;
    private static int m_bufSize;
    private static boolean m_launcherSSL;
    private static String m_jmsUrl;
    private static String m_jmsClass;
    private static SealedString m_key;
    private static String m_user;
    private static OSTriggerClient m_client;
    private static int m_command;

    public static void main(String[] args) throws InterruptedException {
        m_id = JMSUtilities.generatePrimaryId();
        OSTriggerService.processCommandLineArguments(args);
        OSTriggerService.initLogger();
        if (m_launcherHost == null || m_launcherHost.isEmpty()) {
            try {
                InetAddress addr = InetAddress.getLocalHost();
                m_launcherHost = addr.getHostName();
            }
            catch (UnknownHostException e) {
                m_launcherHost = "localhost";
            }
        }
        LOGGER.debug("Launcher host: " + m_launcherHost);
        OSTriggerService.getClient();
        String id = m_id;
        LOGGER.debug("Command: " + m_command);
        int status = -2;
        switch (m_command) {
            case 10: {
                m_id = UUID.randomUUID().toString();
                status = m_client.checkOSTriggerService(id);
                if (status == -1) {
                    status = m_client.checkOSTriggerService(id);
                }
                if (status == -1) {
                    OSTriggerService service;
                    LOGGER.debug("Starting the service.");
                    m_id = id;
                    OSTriggerService oSTriggerService = service = new OSTriggerService();
                    Objects.requireNonNull(oSTriggerService);
                    OSTriggerThread t = oSTriggerService.new OSTriggerThread(m_client);
                    t.start();
                    break;
                }
                if (status == 0) {
                    LOGGER.debug("Start command while already running, ignoring start.");
                    System.exit(-1);
                    break;
                }
                if (status < 1) break;
                LOGGER.debug("Start command while still initializing, ignoring start.");
                System.exit(0);
                break;
            }
            case 14: {
                m_id = UUID.randomUUID().toString();
                status = m_client.checkOSTriggerService(id);
                if (status == -1) {
                    LOGGER.warn("Currently not running, restart aborted. Use the start command.");
                    System.exit(-1);
                    break;
                }
                if (status == 1) {
                    LOGGER.info("Restart command while still initializing, ignoring restart.");
                    System.exit(0);
                    break;
                }
                if (status != 0) break;
                int rc = m_client.stopOSTriggerService(id);
                if (rc == 0) {
                    OSTriggerService service;
                    m_id = id;
                    OSTriggerService oSTriggerService = service = new OSTriggerService();
                    Objects.requireNonNull(oSTriggerService);
                    OSTriggerThread t = oSTriggerService.new OSTriggerThread(m_client);
                    t.start();
                    break;
                }
                LOGGER.debug("Unable to stop properly, restart aborted.");
                System.exit(rc);
                break;
            }
            case 11: {
                m_id = UUID.randomUUID().toString();
                int rc = m_client.stopOSTriggerService(id);
                LOGGER.debug("Stop is: " + rc);
                System.exit(rc);
                break;
            }
            default: {
                m_id = UUID.randomUUID().toString();
                status = m_client.checkOSTriggerService(id);
                LOGGER.debug("Status is: " + status);
                if (status < 0) {
                    System.exit(status);
                    break;
                }
                System.exit(0);
                break;
            }
            case 13: {
                m_client.clearQueue(m_id, m_client.getSchedulerRequestQueue());
                m_client.clearQueue(m_id, m_client.getSchedulerResultsQueue());
                m_client.clearQueue(m_id, m_client.getMidtierRequestQueue());
                m_client.clearQueue("ALL", m_client.getBytesQueue());
                m_client.clearQueue("ALL", m_client.getCheckQueue());
                m_client.clearQueue(m_id, m_client.getInstanceListQueue());
                m_client.clearQueue(m_id, m_client.getInstanceQueue());
                m_client.clearQueue("ALL", m_client.getStringQueue());
                System.exit(0);
            }
        }
    }

    private static void processCommandLineArguments(String[] saArgs) {
        int nArgs = saArgs.length;
        for (int iArg = 0; iArg < nArgs; ++iArg) {
            String buf;
            if (MetaUtilities.isDebug()) {
                String nextarg;
                String string = nextarg = iArg + 1 < nArgs ? saArgs[iArg + 1] : null;
                if (nextarg != null && !nextarg.startsWith("-")) {
                    System.out.println(saArgs[iArg] + " " + nextarg);
                } else {
                    System.out.println(saArgs[iArg]);
                }
            }
            if (saArgs[iArg].equalsIgnoreCase("-start")) {
                m_command = 10;
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-stop")) {
                m_command = 11;
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-status")) {
                m_command = 12;
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-restart")) {
                m_command = 14;
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-clearQueue")) {
                m_command = 13;
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-host")) {
                m_launcherHost = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-port")) {
                String port;
                if ((port = saArgs[++iArg]) == null) continue;
                m_launcherPort = Integer.valueOf(port);
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-ssl")) {
                m_launcherSSL = true;
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-config")) {
                m_config = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-jmsUrl")) {
                m_jmsUrl = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-jmsContextFactory")) {
                m_jmsClass = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-key")) {
                String key;
                m_key = (key = saArgs[++iArg]) != null ? new SealedString(key) : null;
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-user")) {
                m_user = saArgs[++iArg];
                continue;
            }
            if (!saArgs[iArg].equalsIgnoreCase("-bufSize") || (buf = saArgs[++iArg]) == null) continue;
            m_bufSize = Integer.valueOf(buf);
        }
    }

    private static OSTriggerClient getClient() {
        if (m_client == null) {
            Properties configProperties = new Properties();
            if (m_config != null) {
                configProperties.setProperty("sasjfs.commandLine.filePath", m_config);
            }
            if (m_jmsUrl != null) {
                configProperties.setProperty("java.naming.provider.url", m_jmsUrl);
            } else {
                configProperties.setProperty("java.naming.provider.url", "tcp://" + m_launcherHost + ":61616");
            }
            if (m_jmsClass != null) {
                configProperties.setProperty("java.naming.factory.initial", m_jmsClass);
            } else {
                configProperties.setProperty("java.naming.factory.initial", "org.apache.activemq.jndi.ActiveMQInitialContextFactory");
            }
            if (m_user != null) {
                configProperties.setProperty("JMSSecurityUserid", m_user);
            }
            if (m_key != null) {
                configProperties.setProperty("JMSSecurityPasswd", new String(m_key.getCharacters()));
            }
            try {
                m_client = new OSTriggerClient(m_id, configProperties);
            }
            catch (InterruptedException e) {
                LOGGER.debug("InterruptedException: unable to create client.");
            }
        }
        return m_client;
    }

    private static void initLogger() {
        block6: {
            try {
                System.setProperty("hostName", InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException e) {
                System.setProperty("hostName", "localhost");
            }
            System.setProperty("userName", System.getProperty("user.name"));
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss", Locale.US);
            String time = dateFormat.format(new Date());
            System.setProperty("timeStamp", time);
            if (!m_config.endsWith(File.separator)) {
                m_config = m_config + File.separator;
            }
            String log4jConfigFilePath = m_config + "log4j2.xml";
            File log4jConfigFile = new File(log4jConfigFilePath = OSTriggerService.handleSpacesInPath(log4jConfigFilePath));
            if (!log4jConfigFile.exists()) {
                throw new IllegalArgumentException("log4j2.xml not found in configDir: " + m_config);
            }
            try {
                LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
                context.setConfigLocation(log4jConfigFile.toURI());
            }
            catch (Exception e) {
                if (!MetaUtilities.isDebug()) break block6;
                e.printStackTrace();
            }
        }
        LOGGER = LogManager.getLogger(OSTriggerService.class);
        LOGGER.debug("initLogger() complete");
    }

    private static String handleSpacesInPath(String path) {
        String retval = null;
        if (-1 == path.indexOf(" ")) {
            return path;
        }
        if (OSTriggerService.pathIsQuoted(path)) {
            return path;
        }
        retval = "\"" + path + "\"";
        return retval;
    }

    private static boolean pathIsQuoted(String path) {
        return path.startsWith("\"") && path.endsWith("\"");
    }

    static {
        m_launcherHost = System.getProperty("hostName");
        m_launcherPort = 1981;
        m_bufSize = 0xA00000;
        m_launcherSSL = false;
        m_jmsUrl = System.getProperty("sas.sasjfs.jms.url");
        m_jmsClass = System.getProperty("sas.sasjfs.jms.factory");
        m_user = System.getProperty("userName");
        m_command = 12;
    }

    public class OSTriggerStartupThread
    implements Runnable {
        Thread mc_thread;
        OSTriggerClient mc_client;
        boolean mc_running = true;
        JmsTemplate mc_queue;

        public OSTriggerStartupThread(OSTriggerClient client) {
            this.mc_client = client;
            this.mc_queue = this.mc_client.getSchedulerRequestQueue();
        }

        public synchronized void start() {
            if (this.mc_thread != null) {
                return;
            }
            this.mc_thread = new Thread((Runnable)this, m_name);
            try {
                this.mc_thread.start();
            }
            catch (Exception ex) {
                LOGGER.debug((Object)ex);
            }
        }

        public synchronized void stop() {
            this.mc_running = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOGGER.debug("Ready to accept status commands...");
            try {
                LOGGER.debug("Service queue waiting for client queue inbound message during initialization.");
                while (this.mc_running) {
                    JmsTemplate jmsTemplate = this.mc_queue;
                    synchronized (jmsTemplate) {
                        Message message = (Message)this.mc_queue.browse((BrowserCallback)new BrowserCallback<Message>(){

                            public Message doInJms(Session arg0, QueueBrowser arg1) throws JMSException {
                                Enumeration items = arg1.getEnumeration();
                                while (items.hasMoreElements()) {
                                    Object o = items.nextElement();
                                    if (!(o instanceof Message)) continue;
                                    return (Message)o;
                                }
                                return null;
                            }
                        });
                        if (message != null) {
                            String inboundMsg = ((TextMessage)message).getText();
                            String callerId = message.getStringProperty("ID");
                            LOGGER.debug("Process message from service queue during initialization:" + inboundMsg);
                            if (inboundMsg.startsWith("status")) {
                                if (m_id.equals(callerId)) {
                                    String messageSelector = "(ID = '" + m_id + "')";
                                    this.mc_queue.receiveSelected(messageSelector);
                                }
                                LOGGER.debug("Status call received while still starting up the process.");
                                this.mc_client.sendResponseToClient(this.mc_client.getSchedulerResultsQueue(), 1, m_id, "status");
                            }
                        }
                    }
                }
                LOGGER.debug("Server queue m_SchedulerRequestQueue shutting down listening during initialization.");
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
            }
        }
    }

    public class OSTriggerThread
    implements Runnable {
        Thread mc_thread;
        OSTriggerClient mc_client;

        public OSTriggerThread(OSTriggerClient client) {
            this.mc_client = client;
        }

        public synchronized void start() {
            if (this.mc_thread != null) {
                return;
            }
            LOGGER.debug("Setting as primary node.");
            boolean rc = this.mc_client.setServiceId(m_id);
            int count = 0;
            while (!rc) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                LOGGER.debug("Unable to set as primary node, retrying.");
                rc = this.mc_client.setServiceId(m_id);
                if (count++ <= 10) continue;
                LOGGER.debug("Unable to set as primary node. Check the mid-tier process.");
                System.exit(CLIReturnCodes.TRY_AGAIN.getValue());
            }
            LOGGER.debug("Set id: " + m_id);
            LOGGER.debug("Starting thread");
            this.mc_thread = new Thread((Runnable)this, m_name);
            try {
                this.mc_thread.start();
            }
            catch (Exception ex) {
                LOGGER.debug((Object)ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Message msg = null;
            String id = "";
            String inboundMsg = "";
            LOGGER.debug("Starting init thread to handle status checks while initializing.");
            OSTriggerStartupThread st = new OSTriggerStartupThread(m_client);
            st.start();
            try {
                LOGGER.debug("Starting syncing triggers...");
                this.syncTriggers();
                LOGGER.debug("Finished syncing triggers!");
            }
            finally {
                LOGGER.debug("Initialized now. Stopping init thread.");
                st.stop();
            }
            LOGGER.debug("Ready to accept commands...");
            JmsTemplate queue = this.mc_client.getSchedulerRequestQueue();
            try {
                LOGGER.debug("Service queue ready for client queue inbound message.");
                while (!inboundMsg.equals("exit")) {
                    try {
                        ProcessState ps;
                        SASJFSLauncherClient launcherClient;
                        SealedString key;
                        char[] p;
                        String ssl;
                        String k;
                        String user;
                        int port;
                        String host;
                        String command;
                        String[] tokens;
                        JmsTemplate jmsTemplate = queue;
                        synchronized (jmsTemplate) {
                            msg = queue.receive();
                            if (msg != null) {
                                id = msg.getStringProperty("ID");
                                inboundMsg = ((TextMessage)msg).getText();
                            }
                            LOGGER.debug(String.format("m_midtierRequestQueue received: [%s]", inboundMsg));
                        }
                        if (id == null || !id.equals(m_id)) continue;
                        LOGGER.debug("Service queue processing inbound message.");
                        if (inboundMsg.startsWith("scheduleflow_;_")) {
                            char[] p2;
                            int retval = CLIReturnCodes.SUCCESS.getValue();
                            tokens = inboundMsg.split("_;_");
                            command = tokens[1];
                            host = tokens[2];
                            port = Integer.valueOf(tokens[3]);
                            user = tokens[4];
                            k = tokens[5];
                            if (user.isEmpty()) {
                                user = m_user;
                            }
                            SealedString key2 = k.isEmpty() ? ((p2 = OSTriggerUtilities.retrievePassword(host, user, this.mc_client)) != null ? new SealedString(p2) : m_key) : new SealedString(k);
                            SASJFSLauncherClient launcherClient2 = new SASJFSLauncherClient(m_launcherHost, port, m_bufSize, m_launcherSSL);
                            launcherClient2.getServerAuthentication(user, key2);
                            ProcessState ps2 = launcherClient2.sendToLauncher(command);
                            retval = ps2.compareTo((Enum)ProcessState.COMPLETED);
                            this.mc_client.sendResponseToClient(this.mc_client.getSchedulerResultsQueue(), retval, m_id, "ScheduleFlow");
                            continue;
                        }
                        if (inboundMsg.startsWith("executeflow_;_")) {
                            int retval = CLIReturnCodes.SUCCESS.getValue();
                            tokens = inboundMsg.split("_;_");
                            command = tokens[1];
                            host = tokens[2];
                            port = new Integer(tokens[3]);
                            user = tokens[4];
                            k = tokens[5];
                            ssl = tokens[6];
                            if (user.isEmpty()) {
                                user = m_user;
                            }
                            key = k.isEmpty() ? ((p = OSTriggerUtilities.retrievePassword(host, user, this.mc_client)) != null ? new SealedString(p) : m_key) : new SealedString(k);
                            launcherClient = new SASJFSLauncherClient(m_launcherHost, port, m_bufSize, Boolean.parseBoolean(ssl));
                            launcherClient.getServerAuthentication(user, key);
                            Process p3 = launcherClient.sendToLauncherNoPolling(command);
                            ProcessState ps3 = p3.getState();
                            if (ps3.compareTo((Enum)ProcessState.SERVER_ERROR) == 0) {
                                retval = CLIReturnCodes.TRY_AGAIN.getValue();
                            }
                            this.mc_client.sendResponseToClient(this.mc_client.getSchedulerResultsQueue(), retval, m_id, "ExecuteFlow");
                            continue;
                        }
                        if (inboundMsg.startsWith("rescheduleflow_;_")) {
                            int retval = CLIReturnCodes.SUCCESS.getValue();
                            tokens = inboundMsg.split("_;_");
                            command = tokens[1];
                            host = tokens[2];
                            port = Integer.valueOf(tokens[3]);
                            user = tokens[4];
                            k = tokens[5];
                            ssl = tokens[6];
                            if (user.isEmpty()) {
                                user = m_user;
                            }
                            key = k.isEmpty() ? ((p = OSTriggerUtilities.retrievePassword(host, user, this.mc_client)) != null ? new SealedString(p) : m_key) : new SealedString(k);
                            launcherClient = new SASJFSLauncherClient(m_launcherHost, port, m_bufSize, Boolean.parseBoolean(ssl));
                            launcherClient.getServerAuthentication(user, key);
                            ps = launcherClient.sendToLauncher(command);
                            retval = ps.compareTo((Enum)ProcessState.COMPLETED);
                            this.mc_client.sendResponseToClient(this.mc_client.getSchedulerResultsQueue(), retval, m_id, "RescheduleFlow");
                            continue;
                        }
                        if (inboundMsg.startsWith("unscheduleflow_;_")) {
                            int retval = CLIReturnCodes.SUCCESS.getValue();
                            tokens = inboundMsg.split("_;_");
                            command = tokens[1];
                            host = tokens[2];
                            port = Integer.valueOf(tokens[3]);
                            user = tokens[4];
                            k = tokens[5];
                            ssl = tokens[6];
                            if (user.isEmpty()) {
                                user = m_user;
                            }
                            key = k.isEmpty() ? ((p = OSTriggerUtilities.retrievePassword(host, user, this.mc_client)) != null ? new SealedString(p) : m_key) : new SealedString(k);
                            launcherClient = new SASJFSLauncherClient(m_launcherHost, port, m_bufSize, Boolean.parseBoolean(ssl));
                            launcherClient.getServerAuthentication(user, key);
                            ps = launcherClient.sendToLauncher(command);
                            retval = ps.compareTo((Enum)ProcessState.COMPLETED);
                            this.mc_client.sendResponseToClient(this.mc_client.getSchedulerResultsQueue(), retval, m_id, "UnscheduleFlow");
                            continue;
                        }
                        if (inboundMsg.startsWith("status")) {
                            this.mc_client.sendResponseToClient(this.mc_client.getSchedulerResultsQueue(), 0, m_id, "status");
                            continue;
                        }
                        if (inboundMsg.startsWith("exit")) break;
                        int retval = CLIReturnCodes.PERM_DENIED.getValue();
                        this.mc_client.sendResponseToClient(this.mc_client.getSchedulerResultsQueue(), retval, m_id, "UnknownAction");
                    }
                    catch (Exception e) {
                        LOGGER.error(e.toString());
                    }
                }
                LOGGER.debug("Client message 'exit' received. Server shutting down...");
                this.mc_client.sendResponseToClient(this.mc_client.getSchedulerResultsQueue(), 0, m_id, "exit");
                System.exit(0);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
            }
        }

        private void syncTriggers() {
            String osCommandPath = this.mc_client.getOSCommandPath();
            String flowOrchCmd = this.mc_client.getFlowOrchestratorCommand();
            List<FlowInfo> flows = this.mc_client.getAllScheduledFlows();
            LOGGER.debug("SyncTriggers: number of flows to process is: " + flows.size());
            for (FlowInfo flow : flows) {
                String flowName = flow.getName();
                LOGGER.debug("SyncTriggers: processing " + flowName);
                try {
                    String user = flow.getScheduledUserIdDataBinding();
                    if (user == null || user.length() == 0) {
                        LOGGER.debug("SyncTriggers: could not determined user for " + flowName);
                        LOGGER.debug("SyncTriggers: skipping processing " + flowName);
                        continue;
                    }
                    char[] p = OSTriggerUtilities.retrievePassword(m_launcherHost, user, this.mc_client);
                    SealedString key = p != null ? new SealedString(p) : m_key;
                    SASJFSLauncherClient launcherClient = new SASJFSLauncherClient(m_launcherHost, m_launcherPort, m_bufSize, m_launcherSSL);
                    try {
                        boolean connected = false;
                        if (key != null) {
                            connected = launcherClient.getServerAuthentication(user, key);
                        }
                        if (!connected) {
                            LOGGER.debug("SyncTriggers: Unable to connect to launcher for  " + flowName);
                            continue;
                        }
                    }
                    catch (SchedulerException e) {
                        LOGGER.debug("SyncTriggers: SASJFS not licensed.");
                    }
                    LOGGER.debug("SyncTriggers: removing trigger for " + flowName);
                    int rc = this.unscheduleTask(flow.getFlowDefinitionIdDataBinding(), osCommandPath, launcherClient);
                    List<Object> triggers = new ArrayList();
                    TriggerEventInfo te = flow.getTriggerEvent();
                    AbstractEventInfo aei = te != null ? te.getEvent() : null;
                    LOGGER.debug("SyncTriggers: trigger event is: " + aei);
                    if (aei instanceof GroupingEventInfo) {
                        triggers = OSTriggerUtilities.getTimeEventTriggers(te);
                    } else if (aei instanceof TimeEventInfo) {
                        triggers.add((TimeEventInfo)aei);
                    }
                    LOGGER.debug("SyncTriggers: number of triggers " + triggers.size());
                    if (triggers.size() > 0) {
                        if (rc == CLIReturnCodes.SUCCESS.getValue()) {
                            LOGGER.debug("SyncTriggers: setting trigger for " + flowName);
                            rc = this.scheduleTask(flow.getFlowDefinitionIdDataBinding(), triggers, flowOrchCmd, osCommandPath, launcherClient);
                        } else {
                            LOGGER.debug("SyncTriggers: resetting trigger for " + flowName);
                            String triggerId = flow.getTriggerId();
                            rc = this.rescheduleTask(flow.getFlowDefinitionIdDataBinding(), triggerId, triggers, flowOrchCmd, osCommandPath, launcherClient);
                            if (rc != CLIReturnCodes.SUCCESS.getValue()) {
                                LOGGER.debug("SyncTriggers: re-doing trigger for " + flowName);
                                rc = this.scheduleTask(flow.getFlowDefinitionIdDataBinding(), triggers, flowOrchCmd, osCommandPath, launcherClient);
                            }
                        }
                    } else {
                        LOGGER.debug("SyncTriggers: no time event triggers found for " + flowName);
                    }
                    if (rc == CLIReturnCodes.SUCCESS.getValue()) {
                        LOGGER.debug("SyncTriggers: Able to sync trigger for: " + flowName);
                    } else {
                        LOGGER.error("SyncTriggers: Cannot sync triggers for: " + flowName);
                    }
                    launcherClient.closeServerAuthentication();
                }
                catch (RuntimeException rte) {
                    LOGGER.error("SyncTriggers: A run-time exception processings: " + flowName, (Throwable)rte);
                    LOGGER.debug("SyncTriggers: " + rte.toString());
                }
            }
        }

        private int scheduleTask(String flowId, List<TimeEventInfo> triggers, String flowOrchCmd, String osCommandPath, SASJFSLauncherClient launcherClient) {
            int retval = CLIReturnCodes.SUCCESS.getValue();
            String osTriggerCmd = this.mc_client.getOSTriggerCommand();
            String flowOrchCommand = OSTriggerUtilities.buildFlowOrchestratorCommand(1, flowOrchCmd, flowId, m_jmsUrl, m_jmsClass);
            String command = OSTriggerUtilities.buildOSTriggerCommand(1, flowId, osTriggerCmd, m_jmsUrl, m_jmsClass, flowOrchCommand, osCommandPath);
            ProcessState ps = launcherClient.sendToLauncher(command);
            retval = ps.compareTo((Enum)ProcessState.COMPLETED);
            return retval;
        }

        private int unscheduleTask(String flowId, String oscommand, SASJFSLauncherClient launcherClient) {
            int retval = CLIReturnCodes.SUCCESS.getValue();
            String osTriggerCmd = this.mc_client.getOSTriggerCommand();
            String command = OSTriggerUtilities.buildOSTriggerCommand(3, flowId, osTriggerCmd, m_jmsUrl, m_jmsClass, null, oscommand);
            ProcessState ps = launcherClient.sendToLauncher(command);
            retval = ps.compareTo((Enum)ProcessState.COMPLETED);
            return retval;
        }

        private int rescheduleTask(String flowId, String triggerId, List<TimeEventInfo> triggers, String flowOrchCmd, String osCommandPath, SASJFSLauncherClient launcherClient) {
            int retval = CLIReturnCodes.SUCCESS.getValue();
            String osTriggerCmd = this.mc_client.getOSTriggerCommand();
            String flowOrchCommand = OSTriggerUtilities.buildFlowOrchestratorCommand(2, flowOrchCmd, flowId, m_jmsUrl, m_jmsClass);
            String command = OSTriggerUtilities.buildOSTriggerCommand(1, flowId, osTriggerCmd, m_jmsUrl, m_jmsClass, flowOrchCommand, osCommandPath);
            ProcessState ps = launcherClient.sendToLauncher(command);
            retval = ps.compareTo((Enum)ProcessState.COMPLETED);
            return retval;
        }
    }
}

