/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.ssl.client;

import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.servers.sasjfs.ssl.client.FileStreamFactory;
import com.sas.scheduler.api.servers.sasjfs.ssl.client.SSLObjectFactory;
import com.sas.scheduler.api.servers.sasjfs.ssl.client.SSLObjectUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;

public class SSLServerSocketFactoryBuilder {
    public static final String SSL_PROTOCOL_DEFAULT = "TLSv1.2";
    private final SSLObjectFactory sslObjectFactory = new SSLObjectFactory();
    private final SSLObjectUtils sslObjectUtils = new SSLObjectUtils();
    private final FileStreamFactory fileStreamFactory = new FileStreamFactory();

    public Instance getInstance() {
        return new Instance();
    }

    public class Instance {
        private String sslProtocol = "TLSv1.2";
        private String sslKeyManagerAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        private String sslKeyStoreType = KeyStore.getDefaultType();
        private String sslKeyStorePath = null;
        private SealedString sslKeyStorePassword = null;

        private Instance() {
        }

        public Instance sslProtocol(String sslProtocol) {
            this.sslProtocol = sslProtocol;
            return this;
        }

        public Instance sslKeyManagerAlgorithm(String sslKeyManagerAlgorithm) {
            this.sslKeyManagerAlgorithm = sslKeyManagerAlgorithm;
            return this;
        }

        public Instance sslKeyStoreType(String sslKeyStoreType) {
            this.sslKeyStoreType = sslKeyStoreType;
            return this;
        }

        public Instance sslKeyStorePath(String sslKeyStorePath) {
            this.sslKeyStorePath = sslKeyStorePath;
            return this;
        }

        public Instance sslKeyStorePassword(String sslKeyStorePassword) {
            return this.sslKeyStorePassword(sslKeyStorePassword != null ? new SealedString(sslKeyStorePassword) : null);
        }

        public Instance sslKeyStorePassword(SealedString sslKeyStorePassword) {
            this.sslKeyStorePassword = sslKeyStorePassword;
            return this;
        }

        public SSLServerSocketFactory build() throws IOException, NoSuchAlgorithmException, KeyStoreException, CertificateException, KeyManagementException {
            SSLContext sslContext = SSLServerSocketFactoryBuilder.this.sslObjectFactory.getSSLContext(this.sslProtocol);
            KeyManagerFactory keyManagerFactory = SSLServerSocketFactoryBuilder.this.sslObjectFactory.getKeyManagerFactory(this.sslKeyManagerAlgorithm);
            KeyStore keyStore = SSLServerSocketFactoryBuilder.this.sslObjectFactory.getKeyStore(this.sslKeyStoreType);
            if (this.sslKeyStorePath != null) {
                FileInputStream fileInputStream = SSLServerSocketFactoryBuilder.this.fileStreamFactory.getInputStream(this.sslKeyStorePath);
                SSLServerSocketFactoryBuilder.this.sslObjectUtils.keyStoreLoad(keyStore, (InputStream)fileInputStream, this.sslKeyStorePassword);
                fileInputStream.close();
            }
            SSLServerSocketFactoryBuilder.this.sslObjectUtils.keyFactoryManagerInit(keyManagerFactory, keyStore, this.sslKeyStorePassword);
            SSLServerSocketFactoryBuilder.this.sslObjectUtils.sslContextInit(sslContext, SSLServerSocketFactoryBuilder.this.sslObjectUtils.getKeyManagerFactoryKeyManagers(keyManagerFactory));
            return SSLServerSocketFactoryBuilder.this.sslObjectUtils.getSSLServerContextSocketFactory(sslContext);
        }
    }
}

