/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.floworchestration;

import com.sas.scheduler.api.servers.sasjfs.floworchestration.AbstractDepChecker;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.ExecutionItem;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.FlowOrchestrator;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.InvalidRecurrenceException;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.TimeEventInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TimeDepExpressionChecker
extends AbstractDepChecker {
    private static final Logger LOGGER = LogManager.getLogger(FlowOrchestrator.class);
    protected TimeEventInfo _timeEventInfo;
    protected Calendar _flowStartDate;

    public TimeDepExpressionChecker(String jobDepTargetName, TimeEventInfo tei, ArrayList<ExecutionItem> runningItems, ArrayList<ExecutionItem> completedItems, Calendar flowStartDate) {
        super(jobDepTargetName, tei.getName(), -1, runningItems, completedItems);
        this._timeEventInfo = tei;
        this._flowStartDate = flowStartDate;
    }

    public boolean evalTimeExpression() throws SchedulerException {
        IRecurrenceInfo recurrence = this._timeEventInfo.getRecurrence();
        if (recurrence == null) {
            throw new SchedulerException("recurrence must not be null in time event info for job dependencies.");
        }
        boolean isRecurrence = this.checkForRecurrence(recurrence);
        if (!isRecurrence) {
            return false;
        }
        boolean retval = false;
        try {
            retval = this.checkTeiHoursMinutes();
        }
        catch (InvalidRecurrenceException e) {
            LOGGER.debug(e.toString());
        }
        return retval;
    }

    private boolean checkTeiHoursMinutes() throws InvalidRecurrenceException {
        List<String> teiMinutesList;
        boolean retval = false;
        TimeZone tzId = this.getTimeZoneId();
        GregorianCalendar zonedCal = new GregorianCalendar(tzId);
        String zdtLocalHour = Integer.toString(zonedCal.get(10));
        String zdtLocalMinute = String.format("%02d", zonedCal.get(12));
        String teiHours = this._timeEventInfo.getHours();
        String teiMinutes = this._timeEventInfo.getMinutes();
        List<String> teiHoursList = this.buildTimesList(teiHours);
        if (teiHoursList.contains("*")) {
            for (int i = 0; i < 24; ++i) {
                teiHoursList.add(String.format("%02d", i));
            }
        }
        if ((teiMinutesList = this.buildTimesList(teiMinutes)).contains("*")) {
            for (int i = 0; i < 60; ++i) {
                teiMinutesList.add(String.format("%02d", i));
            }
        }
        if (this.checkHoursMinutes(teiHoursList, teiMinutesList, zdtLocalMinute, zdtLocalHour)) {
            retval = true;
        }
        return retval;
    }

    private boolean checkHoursMinutes(List<String> teiHoursList, List<String> teiMinutesList, String zdtLocalMinute, String zdtLocalHour) {
        boolean retval = false;
        int duration = this._timeEventInfo.getDuration();
        if (teiHoursList.size() == 24) {
            Collection<String> alteredMinutesSet;
            if (teiMinutesList.size() == 60) {
                retval = true;
            }
            if (teiMinutesList.contains(zdtLocalMinute)) {
                retval = true;
            }
            if (duration > 1 && this.checkAlteredMinutes(alteredMinutesSet = this.buildAlteredMinutesSet(teiMinutesList, duration), zdtLocalMinute)) {
                retval = true;
            }
        }
        if (duration == 1 && teiHoursList.contains(zdtLocalHour)) {
            if (teiMinutesList.contains(zdtLocalMinute)) {
                retval = true;
            }
            if (teiMinutesList.size() == 60) {
                retval = true;
            }
        }
        if (duration > 1) {
            Collection<String> alteredHoursSet = this.buildAlteredHoursSet(teiHoursList, teiMinutesList, duration);
            Collection<String> alteredMinutesSet = this.buildAlteredMinutesSet(teiMinutesList, duration);
            if (alteredHoursSet.contains(zdtLocalHour) && alteredMinutesSet.contains(zdtLocalMinute)) {
                retval = true;
            }
        }
        return retval;
    }

    private Collection<String> buildAlteredHoursSet(List<String> teiHoursList, List<String> teiMinutesList, int duration) {
        HashSet<String> retval = new HashSet<String>();
        for (String hour : teiHoursList) {
            retval.add(hour);
            if (!this.rolloverHourTriggered(teiMinutesList, duration)) continue;
            int rolloverHour = Integer.parseInt(hour) + 1;
            retval.add(Integer.toString(rolloverHour));
        }
        return retval;
    }

    private boolean rolloverHourTriggered(List<String> teiMinutesList, int duration) {
        boolean retval = false;
        if (teiMinutesList.size() == 60) {
            return true;
        }
        for (String minute : teiMinutesList) {
            int minuteInt = Integer.parseInt(minute);
            if ((minuteInt + duration) % 60 >= minuteInt) continue;
            retval = true;
            break;
        }
        return retval;
    }

    private Collection<String> buildAlteredMinutesSet(List<String> teiMinutesList, int duration) {
        HashSet<String> retval = new HashSet<String>(duration + 1);
        ArrayList listOfLists = new ArrayList(duration + 1);
        for (int i = 0; i <= duration; ++i) {
            ArrayList<String> ls = new ArrayList<String>(duration);
            for (String s : teiMinutesList) {
                ls.add(String.format("%02d", (Integer.parseInt(s) + i) % 60));
            }
            listOfLists.add(ls);
        }
        HashSet listSet = new HashSet();
        for (List list : listOfLists) {
            listSet.addAll(list);
        }
        retval = listSet;
        return retval;
    }

    private boolean checkAlteredMinutes(Collection<String> alteredMinutesSet, String zdtLocalMinute) {
        boolean retval = alteredMinutesSet.contains(zdtLocalMinute);
        return retval;
    }

    private boolean checkForRecurrence(IRecurrenceInfo recurrence) {
        boolean retval = false;
        try {
            retval = recurrence.includesDate(Calendar.getInstance());
        }
        catch (InvalidRecurrenceException e) {
            LOGGER.error("InvalidRecurrenceException");
            LOGGER.debug(e.getStackTrace()[0].toString());
        }
        return retval;
    }

    private TimeZone getTimeZoneId() {
        String teiTzString = this._timeEventInfo.getTimezone();
        TimeZone tzId = teiTzString == null ? TimeZone.getDefault() : TimeZone.getTimeZone(teiTzString);
        return tzId;
    }

    private List<String> buildTimesList(String timeString) {
        if (timeString.contains("*")) {
            return Arrays.asList("*");
        }
        ArrayList<String> retval = new ArrayList<String>();
        if (timeString.contains(",")) {
            ArrayList<String> timeStringList = new ArrayList<String>(Arrays.asList(timeString.split(",")));
            for (String time : timeStringList) {
                if (time.contains("-")) {
                    retval.addAll(this.buildIntRangeAsStringList(time));
                    continue;
                }
                retval.add(time);
            }
        } else if (timeString.contains("-")) {
            retval.addAll(this.buildIntRangeAsStringList(timeString));
        } else {
            retval.add(timeString);
        }
        return retval;
    }

    private List<String> buildIntRangeAsStringList(String intRangeString) {
        List<String> retval = Arrays.asList("");
        String[] intRanges = intRangeString.split("-");
        int lower = Integer.parseInt(intRanges[0]);
        int upper = Integer.parseInt(intRanges[1]);
        for (int i = lower; i < upper - lower + 1; ++i) {
            retval.add(intRanges[i]);
        }
        return retval;
    }
}

