/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.floworchestration;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SASJFSJobInfo {
    private int id = -1;
    private String name = "";
    private Date startTime = new Date();
    private Date finishTime = new Date();
    private String userName = "";
    protected int completionCode = -1;
    protected int jfsErrCode = 0;
    private String stderr = "";
    private String stdout = "";
    private static final Map<String, Integer> exitCodeTranslationMap = SASJFSJobInfo.createMap();
    public static char HistorySeparator = (char)124;
    private static final String Type_Tag = HistorySeparator + "Type=";
    private static final String UserName_Tag = HistorySeparator + "UserName=";
    private static final String StartTime_Tag = HistorySeparator + "StartTime=";
    private static final String FinishTime_Tag = HistorySeparator + "FinishTime=";
    private static final String FinishState_Tag = HistorySeparator + "FinishState=";
    private static final String StdOut_Tag = HistorySeparator + "StdOut=";
    private static final String StdErr_Tag = HistorySeparator + "StdErr=";
    private static final String JobId_Tag = HistorySeparator + "JobId=";
    private static final String JobName_Tag = HistorySeparator + "JobName=";
    private static final String JFSError_Tag = HistorySeparator + "JFSErrCode=";
    public static final int NOGRIDJOBCREATION = -1;

    private static Map<String, Integer> createMap() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("HOST-FAILED", 64);
        return Collections.unmodifiableMap(result);
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getFinishTime() {
        return this.finishTime;
    }

    public void setFinishTime(Date finishTime) {
        this.finishTime = finishTime;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public int getCompletionCode() {
        return this.completionCode;
    }

    public void setCompletionCode(int completionCode) {
        this.completionCode = completionCode;
    }

    public String getStderr() {
        return this.stderr;
    }

    public void setStderr(String stderr) {
        this.stderr = stderr;
    }

    public String getStdout() {
        return this.stdout;
    }

    public void setStdout(String stdout) {
        this.stdout = stdout;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getJfsErrCode() {
        return this.jfsErrCode;
    }

    public void setJfsErrCode(int jfsErrCode) {
        this.jfsErrCode = jfsErrCode;
    }

    public String toSerializedForm() {
        StringBuffer buffer = new StringBuffer();
        this.toJobSerializedForm(buffer);
        return buffer.toString();
    }

    protected void toJobSerializedForm(StringBuffer buffer) {
        buffer.append(Type_Tag);
        buffer.append("Job");
        buffer.append(JobId_Tag);
        buffer.append(this.id);
        buffer.append(JobName_Tag);
        buffer.append(this.name);
        buffer.append(UserName_Tag);
        buffer.append(this.userName);
        buffer.append(StartTime_Tag);
        buffer.append(this.startTime.getTime());
        buffer.append(FinishTime_Tag);
        buffer.append(this.finishTime != null ? Long.valueOf(this.finishTime.getTime()) : "");
        buffer.append(FinishState_Tag);
        buffer.append(this.completionCode);
        buffer.append(JFSError_Tag);
        buffer.append(this.jfsErrCode);
        buffer.append(StdOut_Tag);
        buffer.append(this.stdout);
        buffer.append(StdErr_Tag);
        buffer.append(this.stderr);
    }

    public static SASJFSJobInfo getPropertiesFromString(String data) {
        BufferedReader reader = new BufferedReader(new StringReader(data));
        SASJFSJobInfo properties = new SASJFSJobInfo();
        try {
            String flowLine = reader.readLine();
            properties.createFromData(flowLine, reader);
            reader.close();
            return properties;
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected void createFromData(String flowLine, BufferedReader reader) {
        this.id = this.getIntParameterFromHistoryLine(flowLine, JobId_Tag);
        this.name = this.getStringParameterFromHistoryLine(flowLine, JobName_Tag);
        this.startTime = this.getDateParameterFromHistoryLine(flowLine, StartTime_Tag);
        this.finishTime = this.getDateParameterFromHistoryLine(flowLine, FinishTime_Tag);
        this.userName = this.getStringParameterFromHistoryLine(flowLine, UserName_Tag);
        this.completionCode = this.getIntParameterFromHistoryLine(flowLine, FinishState_Tag);
        this.stderr = this.getStringParameterFromHistoryLine(flowLine, StdErr_Tag);
        this.stdout = this.getStringParameterFromHistoryLine(flowLine, StdOut_Tag);
        this.jfsErrCode = this.getIntParameterFromHistoryLine(flowLine, JFSError_Tag);
    }

    private String getStringParameterFromHistoryLine(String historyLine, String parmName) {
        int index = historyLine.indexOf(parmName);
        if (index < 0) {
            return "";
        }
        int separatorIndex = historyLine.indexOf(HistorySeparator, index + parmName.length());
        if (separatorIndex < 0) {
            separatorIndex = historyLine.length();
        }
        String dataString = historyLine.substring(index + parmName.length(), separatorIndex);
        return dataString;
    }

    private int getIntParameterFromHistoryLine(String historyLine, String parmName) {
        int rc = -1;
        int index = historyLine.indexOf(parmName);
        if (index < 0) {
            return rc;
        }
        int separatorIndex = historyLine.indexOf(HistorySeparator, index + parmName.length());
        if (separatorIndex < 0) {
            separatorIndex = historyLine.length();
        }
        String dataString = historyLine.substring(index + parmName.length(), separatorIndex);
        try {
            if (dataString.length() > 0) {
                rc = Integer.parseInt(dataString);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return rc;
    }

    public Date getDateParameterFromHistoryLine(String historyLine, String parmName) {
        int index = historyLine.indexOf(parmName);
        if (index < 0) {
            return null;
        }
        int separatorIndex = historyLine.indexOf(HistorySeparator, index + parmName.length());
        if (separatorIndex < 0) {
            separatorIndex = historyLine.length();
        }
        String dataString = historyLine.substring(index + parmName.length(), separatorIndex);
        try {
            return new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy").parse(dataString);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Map<String, Integer> getExitCodeTranslationMap() {
        return exitCodeTranslationMap;
    }
}

