/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.floworchestration;

import com.sas.scheduler.api.servers.sasjfs.floworchestration.AbstractDepChecker;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.ExecutionItem;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.FlowOrchestrator;
import com.sas.scheduler.model.JobEventInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JobDepChecker
extends AbstractDepChecker {
    private static final Logger LOGGER = LogManager.getLogger(FlowOrchestrator.class);
    protected JobEventInfo _jobEventInfo;

    public JobDepChecker(String depTargetName, JobEventInfo jei, ArrayList<ExecutionItem> runningItems, ArrayList<ExecutionItem> completedItems) {
        super(depTargetName, jei.getJobInfo().getName(), jei.getEventType(), runningItems, completedItems);
        this._jobEventInfo = jei;
    }

    public JobDepChecker(String depTargetName, String jobName, JobEventInfo jei, ArrayList<ExecutionItem> runningItems, ArrayList<ExecutionItem> completedItems) {
        super(depTargetName, jobName, jei.getEventType(), runningItems, completedItems);
        this._jobEventInfo = jei;
    }

    public boolean evalJobExpression(String jeiJobName) {
        if (this._depHistory == null) {
            return false;
        }
        boolean retval = false;
        LOGGER.debug("Checking dep for target: " + jeiJobName);
        boolean jobCompleted = this.jobNameInCompletedItems(jeiJobName);
        int exprType = this._jobEventInfo.getEventType();
        int exprOp = this._jobEventInfo.getOperator();
        int exprValue = this._jobEventInfo.getValue();
        int jhExitCode = this._depHistory.getCompletionCode();
        boolean depMet = false;
        switch (exprType) {
            case 0: 
            case 10: {
                retval = jobCompleted && jhExitCode == 0;
                break;
            }
            case 1: 
            case 11: {
                retval = jobCompleted;
                break;
            }
            case 2: {
                retval = this.startCheck();
                break;
            }
            case 3: 
            case 13: {
                retval = this.opCheck(exprOp, exprValue, jhExitCode);
                break;
            }
            case 4: 
            case 14: {
                depMet = false;
                if (this._depHistory.getStartTime() != null) {
                    long jobRunTimeInMinutes = JobDepChecker.getDateDiff(this._depHistory.getStartTime(), new Date(), TimeUnit.MINUTES);
                    depMet = jobRunTimeInMinutes > (long)exprValue;
                    LOGGER.debug("RunsMore:" + jobRunTimeInMinutes + ">" + exprValue + "=" + depMet);
                    System.err.println("RunsMore:" + jobRunTimeInMinutes + ">" + exprValue + "=" + depMet);
                }
                retval = depMet;
                break;
            }
            case 5: 
            case 15: {
                depMet = false;
                if (this._depHistory.getStartTime() != null && this._depHistory.getFinishTime() != null) {
                    long jobRunTimeInMinutes = JobDepChecker.getDateDiff(this._depHistory.getStartTime(), this._depHistory.getFinishTime(), TimeUnit.MINUTES);
                    depMet = jobRunTimeInMinutes < (long)exprValue;
                }
                retval = depMet;
                break;
            }
            case 6: 
            case 16: {
                LOGGER.info("\"Job misses scheduled time\" is an unsupported event type.");
                break;
            }
            case 7: {
                LOGGER.info("\"Job fails to start\" is an unsupported event type.");
                break;
            }
            case 8: 
            case 18: {
                LOGGER.info("\"Job cannot run\" is an unsupported event type.");
            }
        }
        return retval;
    }

    private static long getDateDiff(Date date1, Date date2, TimeUnit timeUnit) {
        long diffInMillies = date2.getTime() - date1.getTime();
        LOGGER.debug("date diff: " + diffInMillies + "##" + timeUnit.convert(diffInMillies, TimeUnit.MILLISECONDS));
        System.err.println("date diff: " + diffInMillies + "##" + timeUnit.convert(diffInMillies, TimeUnit.MILLISECONDS));
        return timeUnit.convert(diffInMillies, TimeUnit.MILLISECONDS);
    }

    private boolean startCheck() {
        return this._depHistory.getStartTime() != null;
    }

    private boolean opCheck(int exprOp, int exprValue, int valueToCheck) {
        switch (exprOp) {
            case 21: {
                return valueToCheck == exprValue;
            }
            case 23: {
                return valueToCheck > exprValue;
            }
            case 24: {
                return valueToCheck >= exprValue;
            }
            case 25: {
                return valueToCheck < exprValue;
            }
            case 26: {
                return valueToCheck <= exprValue;
            }
            case 22: {
                return valueToCheck != exprValue;
            }
        }
        return false;
    }
}

