/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.floworchestration;

import com.sas.scheduler.api.servers.sasjfs.SASJFSFlowHistory;
import com.sas.scheduler.api.servers.sasjfs.engine.SASJFSProperties;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.ExecutionItem;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.FlowDepChecker;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.FlowManager;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.FlowOrchestrator;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.GridRunnable;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.GridRunnableFactory;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.JobDepChecker;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.OSRunnable;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.OSRunnableFactory;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.RunnableItem;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.SASJFSJobInfo;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.TimeDepExpressionChecker;
import com.sas.scheduler.api.servers.sasjfs.utilities.CLIHelper;
import com.sas.scheduler.model.AbstractEventInfo;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.GroupingEventInfo;
import com.sas.scheduler.model.JobDependency;
import com.sas.scheduler.model.JobEventInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.model.TimeEventInfo;
import java.net.PasswordAuthentication;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FlowRunner
implements Runnable {
    private Object _syncLockObj;
    private static final Logger LOGGER = LogManager.getLogger(FlowOrchestrator.class);
    private int _quantumDurationSeconds;
    private final List<PasswordAuthentication> _authTokenList;
    private FlowInfo _flowInfo;
    private SASJFSFlowHistory _sasJFSFlowHistory;
    private SchedulerServerInfo _flowScheduler;
    private SASJFSJobInfo _historyOfLastJob;
    private boolean _completionCriteriaPresent;
    private boolean _flowCompletionCriteriaMet;
    private volatile boolean _exitCodeSummation;
    private volatile int _exitCodeSum;
    private volatile LinkedList<ExecutionItem> _executionItems;
    private volatile ArrayList<ExecutionItem> _completedItems;
    private volatile ArrayList<ExecutionItem> _waitingItems;
    private volatile ArrayList<ExecutionItem> _runningItems;
    private volatile ArrayList<ExecutionItem> _suspendedItems;
    private List<RunnableItem> _runnableItemsList;
    private List<FlowInfo> _subFlowList;
    private SASJFSProperties _jfeProps;
    private String _flowInstanceId;
    private Calendar _flowStartDate;
    protected volatile boolean _itemExitedNonZero;
    protected volatile ExecutionItem _itemWithNonZeroExitCode;
    private boolean _flowKilled;
    protected FlowManager.FlowManagerCallback _flowManagerCallback;
    protected boolean _hasDependencies = false;

    public FlowRunner(FlowInfo flowInfo, String flowInstanceId, SchedulerServerInfo scheduler, SASJFSProperties props, GridRunnableFactory grFactory, List<PasswordAuthentication> authToken, FlowManager.FlowManagerCallback callback) {
        this._jfeProps = props;
        this.initialize();
        this._flowInfo = flowInfo;
        this._authTokenList = authToken;
        this._flowInstanceId = flowInstanceId;
        this._flowManagerCallback = callback;
        this._flowScheduler = scheduler;
        this.setFlowCompletionAttributes(flowInfo);
    }

    public String getFlowInstanceId() {
        return this._flowInstanceId;
    }

    private void initialize() {
        this._syncLockObj = new Object();
        this._executionItems = new LinkedList();
        this._completedItems = new ArrayList();
        this._waitingItems = new ArrayList();
        this._runningItems = new ArrayList();
        this._suspendedItems = new ArrayList();
        this._runnableItemsList = new ArrayList<RunnableItem>();
        this._subFlowList = new ArrayList<FlowInfo>();
        this._sasJFSFlowHistory = new SASJFSFlowHistory(LOGGER);
        this._sasJFSFlowHistory.setState(5);
        try {
            FlowRunner flowRunner = this;
            this._quantumDurationSeconds = flowRunner._jfeProps.getQuantumDurationSeconds();
        }
        catch (NumberFormatException nex) {
            this._quantumDurationSeconds = 10;
        }
        catch (NullPointerException n) {
            this._quantumDurationSeconds = 10;
        }
        if (this._quantumDurationSeconds < 10) {
            this._quantumDurationSeconds = 10;
        }
        this._flowStartDate = Calendar.getInstance();
        this._flowKilled = false;
        this._itemExitedNonZero = false;
        this._itemWithNonZeroExitCode = null;
        this._flowCompletionCriteriaMet = false;
        this._exitCodeSum = 0;
    }

    @Override
    public void run() {
        LOGGER.debug(String.format("FlowRunner active for Thread ID: %s   Flow name is: %s", Thread.currentThread().getId(), this._flowInfo.getName()));
        LOGGER.debug(String.format("FlowRunner started for Flow named: %s", this._flowInfo.getName()));
        this._sasJFSFlowHistory.setState(3);
        this._sasJFSFlowHistory.setStartTime(new Date());
        this._sasJFSFlowHistory.setFlowName(this._flowInfo.getName());
        boolean suspendedFlow = false;
        if (this._hasDependencies) {
            boolean notDone = true;
            while (notDone) {
                int rc = this._flowManagerCallback.checkDependencies(this._flowInfo);
                switch (rc) {
                    case 1: {
                        notDone = false;
                        break;
                    }
                    case 0: {
                        LOGGER.debug("FlowRunner waiting on dependency to be met");
                        this.sleepThread(10000);
                        break;
                    }
                    case -1: {
                        notDone = false;
                        suspendedFlow = true;
                    }
                }
            }
        }
        List rawFlowItems = this._flowInfo.getJobs();
        List<DisplayInfo> nonFlowFlowItems = this.removeFlowInfoInstances(rawFlowItems);
        List<DisplayInfo> refinedFlowItems = this.removeItemsWithInvalidJobDepTypes(nonFlowFlowItems);
        this.buildWaitingItems(refinedFlowItems);
        try {
            this.buildExecutionItems();
        }
        catch (SchedulerException e) {
            LOGGER.error("Error building execution items list: " + e.getMessage());
            LOGGER.trace("", (Throwable)e);
        }
        int numCompletedItems = this._completedItems.size();
        int numFlowItems = refinedFlowItems.size();
        while (numCompletedItems != numFlowItems && !this._flowKilled && !suspendedFlow) {
            int numSuspendedItems = this._suspendedItems.size();
            LOGGER.debug(String.format("FlowRunner main execution loop begins. Flow name: %s   Number of Flow items is: %s    Number of completed items is: %s    Number of suspended items is: %s", this._flowInfo.getName(), numFlowItems, numCompletedItems, numSuspendedItems));
            this._runnableItemsList.clear();
            while (this._executionItems.size() != 0) {
                LOGGER.debug(String.format("Looping through execution items. Remaining execution items count: %s", this._executionItems.size()));
                ExecutionItem executionItem = this._executionItems.pop();
                if (executionItem._info instanceof JobInfo) {
                    JobInfo ji = (JobInfo)executionItem._info;
                    if (this._flowScheduler.getJobExecutionProviderDataBinding().equalsIgnoreCase("REST")) {
                        LOGGER.debug(String.format("Grid service job detected. Command line is: %s", ji.getCommandLine()));
                        this.processGridRunnableItem(executionItem);
                        continue;
                    }
                    if (this._flowScheduler.getJobExecutionProviderDataBinding().equalsIgnoreCase("operatingSystem")) {
                        LOGGER.debug(String.format("OS service job detected. Command line is: %s", ji.getCommandLine()));
                        this.processOSCall(executionItem);
                        continue;
                    }
                    LOGGER.error("Invalid job information in FlowRunner. Must have either commandLine or request field.");
                    this._suspendedItems.add(executionItem);
                    continue;
                }
                LOGGER.error(String.format("Invalid info type in execution item named: %s", executionItem._info.getName()));
                LOGGER.error(String.format("    This info type item has ID: %s", executionItem._info.getId()));
            }
            for (RunnableItem ri : this._runnableItemsList) {
                SecureRandom generator = new SecureRandom();
                int sleepTimeMs = generator.nextInt(5000) + 2000;
                this.sleepThread(sleepTimeMs);
                LOGGER.debug(String.format("Starting %s process using new Thread ID: %s", ri.get_runnableType().toString(), ri.get_runnableThread().getId()));
                ri.get_runnableThread().start();
            }
            try {
                TimeUnit.SECONDS.sleep(this._quantumDurationSeconds);
            }
            catch (InterruptedException e) {
                LOGGER.trace("", (Throwable)e);
            }
            this.buildWaitingItems(refinedFlowItems);
            try {
                this.buildExecutionItems();
            }
            catch (SchedulerException e) {
                LOGGER.error("Error building execution items list: " + e.getMessage());
                LOGGER.trace("", (Throwable)e);
            }
            numCompletedItems = this._completedItems.size() + this._suspendedItems.size();
            if (this._completionCriteriaPresent) {
                LOGGER.debug(String.format("Flow with name %s has completion criteria present", this._flowInfo.getName()));
                if (this.flowCompletionCriteriaMet()) {
                    LOGGER.debug(String.format("Flow with name %s has met its completion criteria", this._flowInfo.getName()));
                    this.handleCompletionCriteriaEvent();
                    LOGGER.debug("Exiting main Flow processing loop.");
                    break;
                }
                LOGGER.debug(String.format("Flow with name %s has not met its completion criteria", this._flowInfo.getName()));
                continue;
            }
            if (!this._itemExitedNonZero) continue;
            int endBehavior = this._flowInfo.getEndBehaviorDataBinding();
            if (endBehavior == 2) {
                this.handleSubFlowCompletionCriteriaEvent();
                this._flowManagerCallback.callbackFlowCompleted(this._flowInfo, this._sasJFSFlowHistory, this._exitCodeSum);
                continue;
            }
            if (endBehavior == 3) continue;
            this.handleDefaultNonZeroExitCodeEvent();
            LOGGER.debug("Exiting main Flow processing loop.");
            break;
        }
        if (this._subFlowList.size() > 0) {
            while (!this.subflowCompletionCriteriaMet()) {
                this.sleepThread(10);
            }
        }
        if (this._flowCompletionCriteriaMet) {
            String reasonMsg = String.format("Flow's completion criteria has been satisfied.", new Object[0]);
            this.quiesceFlow(reasonMsg, numFlowItems);
        } else if (this._itemExitedNonZero) {
            String reasonMsg = String.format("Flow item '%s' exited with non-zero exit code %d", this._itemWithNonZeroExitCode._info.getName(), this._itemWithNonZeroExitCode._sasJFSJobInfo.getCompletionCode());
            this.quiesceFlow(reasonMsg, numFlowItems);
        }
        this.handleSubFlowCompletionCriteriaEvent();
        this._sasJFSFlowHistory.setSuspended(suspendedFlow);
        this._flowManagerCallback.callbackFlowCompleted(this._flowInfo, this._sasJFSFlowHistory, this._exitCodeSum);
    }

    private void sleepThread(int i) {
        try {
            Thread.sleep(i);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void handleCompletionCriteriaEvent() {
        this._flowCompletionCriteriaMet = true;
        this.suspendAllWaitingItems();
        this._waitingItems.clear();
    }

    private void handleSubFlowCompletionCriteriaEvent() {
        HashMap<String, SASJFSFlowHistory> flowHistories = this._flowManagerCallback.getCompletedFlowHistories();
        if (this._exitCodeSummation) {
            for (FlowInfo flow : this._subFlowList) {
                SASJFSFlowHistory subFlowHistoryRecord;
                if (!flowHistories.containsKey(flow.getName()) || (subFlowHistoryRecord = flowHistories.get(flow.getName())).isSuspended()) continue;
                this._exitCodeSum += flowHistories.get(flow.getName()).getErrorCode();
            }
        } else {
            long timeOfGreatestRunningSubFlow = new Long(0L);
            int exitCodeOfGreatestRunningSubFlow = Integer.MIN_VALUE;
            for (FlowInfo flow : this._subFlowList) {
                SASJFSFlowHistory subFlowHistoryRecord;
                if (!flowHistories.containsKey(flow.getName()) || (subFlowHistoryRecord = flowHistories.get(flow.getName())).isSuspended() || subFlowHistoryRecord.getFinishTime().getTime() <= timeOfGreatestRunningSubFlow) continue;
                timeOfGreatestRunningSubFlow = subFlowHistoryRecord.getFinishTime().getTime();
                exitCodeOfGreatestRunningSubFlow = subFlowHistoryRecord.getErrorCode();
            }
            Long timeOfLastCompletedJob = this._historyOfLastJob.getFinishTime().getTime();
            this._exitCodeSum = timeOfLastCompletedJob > timeOfGreatestRunningSubFlow ? this._historyOfLastJob.getCompletionCode() : exitCodeOfGreatestRunningSubFlow;
        }
    }

    private boolean flowCompletionCriteriaMet() {
        boolean allSelected;
        boolean retval = false;
        boolean bl = allSelected = this._flowInfo.getCompletionLevelDataBinding() == 2;
        if (allSelected) {
            retval = true;
            List completionSelectedJobs = this._flowInfo.getCompletionSelectedJobNamesDataBinding();
            for (String completionSelectedJob : completionSelectedJobs) {
                String fullyQualifiedJobName = this.buildFullyQualifiedJobName(completionSelectedJob);
                if (this.checkJobOrFlowCompleted(fullyQualifiedJobName)) continue;
                retval = false;
                break;
            }
            if (retval) {
                retval = this.subflowCompletionCriteriaMet();
            }
        } else {
            List completionSelectedJobs = this._flowInfo.getCompletionSelectedJobNamesDataBinding();
            for (String completionSelectedJob : completionSelectedJobs) {
                String fullyQualifiedJobName = this.buildFullyQualifiedJobName(completionSelectedJob);
                if (!this.checkJobOrFlowCompleted(fullyQualifiedJobName)) continue;
                retval = true;
                break;
            }
            if (!retval) {
                retval = this.subflowCompletionCriteriaMet();
            }
        }
        return retval;
    }

    private boolean subflowCompletionCriteriaMet() {
        boolean retval = false;
        HashMap<String, SASJFSFlowHistory> flowHistories = this._flowManagerCallback.getCompletedFlowHistories();
        HashMap<String, FlowInfo> suspendedFlows = this._flowManagerCallback.getSuspendedFlows();
        List names = this._flowInfo.getCompletionSelectedJobNamesDataBinding();
        block0 : switch (this._flowInfo.getCompletionLevelDataBinding()) {
            case 3: {
                for (FlowInfo flow : this._subFlowList) {
                    String flowName = flow.getName();
                    if (!names.contains(flowName) || !flowHistories.containsKey(flowName)) continue;
                    retval = true;
                    break block0;
                }
                break;
            }
            case 2: {
                retval = true;
                for (FlowInfo flow : this._subFlowList) {
                    String flowName = flow.getName();
                    if (!names.contains(flowName) || flowHistories.containsKey(flowName) && !suspendedFlows.containsKey(flowName)) continue;
                    retval = false;
                    break block0;
                }
                break;
            }
            case 0: 
            case 1: {
                retval = true;
                for (FlowInfo flow : this._subFlowList) {
                    String flowName = flow.getName();
                    if (suspendedFlows.containsKey(flowName)) {
                        retval = true;
                        break block0;
                    }
                    if (flowHistories.containsKey(flowName)) continue;
                    retval = false;
                    break block0;
                }
                break;
            }
        }
        return retval;
    }

    private String buildFullyQualifiedJobName(String completionSelectedJob) {
        String retval = "";
        retval = this._flowInstanceId + ":" + this._flowInfo.getName() + ":" + completionSelectedJob;
        return retval;
    }

    private boolean checkJobOrFlowCompleted(String completionSelectedJob) {
        boolean retval = this._flowManagerCallback.isJobCompleted(completionSelectedJob) || this._flowManagerCallback.isFlowCompleted(completionSelectedJob);
        return retval;
    }

    private void processGridRunnableItem(ExecutionItem executionItem) {
        GridRunnableFactory gridFactory = new GridRunnableFactory();
        GridRunnable gr = gridFactory.getInstance(executionItem, this._flowScheduler.getRestAPIPath(), this._authTokenList, this._flowInfo.getSchedulerQueueDataBinding(), new FlowRunnerCallback());
        Thread runnableThread = new Thread(gr);
        RunnableItem ri = new RunnableItem(RunnableItem.RunnableType.Grid, runnableThread);
        this._runnableItemsList.add(ri);
        this._runningItems.add(executionItem);
    }

    private void processOSCall(ExecutionItem executionItem) {
        OSRunnableFactory gridFactory = new OSRunnableFactory();
        OSRunnable gr = gridFactory.getInstance(executionItem, this._flowScheduler.getRestAPIPath(), new FlowRunnerCallback());
        Thread runnableThread = new Thread(gr);
        RunnableItem ri = new RunnableItem(RunnableItem.RunnableType.OS, runnableThread);
        this._runnableItemsList.add(ri);
        this._runningItems.add(executionItem);
    }

    private void handleDefaultNonZeroExitCodeEvent() {
        LOGGER.debug("A Flow item has exited with a non-zero exit code. Suspending all remaining waiting items...");
        this.suspendAllWaitingItems();
        this._waitingItems.clear();
        LOGGER.debug("Waiting items have been cleared...");
    }

    private List<DisplayInfo> removeFlowInfoInstances(List<DisplayInfo> rawFlowItems) {
        ArrayList<DisplayInfo> nonFlowInfoItems = new ArrayList<DisplayInfo>();
        for (DisplayInfo info : rawFlowItems) {
            if (info instanceof FlowInfo) {
                this._subFlowList.add((FlowInfo)info);
                continue;
            }
            nonFlowInfoItems.add(info);
        }
        return nonFlowInfoItems;
    }

    private List<DisplayInfo> removeItemsWithInvalidJobDepTypes(List<DisplayInfo> rawFlowItems) {
        List<DisplayInfo> retval = rawFlowItems;
        List<Integer> invalidJobDepTypes = Arrays.asList(6, 7, 8);
        ArrayList<String> jobsWithUnsupportedDepTypes = new ArrayList<String>();
        List jobDeps = this._flowInfo.getJobDependenciesDataBinding();
        for (JobDependency jobDep : jobDeps) {
            JobEventInfo jobEventInfo;
            int eventType;
            boolean match;
            AbstractEventInfo jobDepEvent = jobDep.getEvent();
            if (!(jobDepEvent instanceof JobEventInfo) || !(match = invalidJobDepTypes.contains(eventType = (jobEventInfo = (JobEventInfo)jobDepEvent).getEventType()))) continue;
            jobsWithUnsupportedDepTypes.add(jobDep.getNodeId());
        }
        if (jobsWithUnsupportedDepTypes.size() > 0) {
            for (String jobWithUnsupportedDepType : jobsWithUnsupportedDepTypes) {
                DisplayInfo itemWithUnsupportedDepType = this.getItemByName(jobWithUnsupportedDepType, rawFlowItems);
                if (itemWithUnsupportedDepType == null) continue;
                LOGGER.debug(String.format("Removing item with unsupported job dependency type from Flow items list. Job with unsupported dependency type is named: %s", jobWithUnsupportedDepType));
                retval.remove(itemWithUnsupportedDepType);
            }
        }
        return retval;
    }

    private DisplayInfo getItemByName(String jobWithUnsupportedDepType, List<DisplayInfo> rawFlowItems) {
        DisplayInfo retval = null;
        for (DisplayInfo item : rawFlowItems) {
            if (!item.getName().equals(jobWithUnsupportedDepType)) continue;
            retval = item;
            break;
        }
        return retval;
    }

    private void quiesceFlow(String reasonMsg, int numFlowItems) {
        if (CLIHelper.isEmpty(reasonMsg)) {
            LOGGER.debug("Reason message was null or empty when calling quiesceFlow()...");
        } else {
            LOGGER.debug(reasonMsg);
        }
        LOGGER.debug(String.format("Beginning quiesce Flow procedures with number of Flow items = %d...", numFlowItems));
        LOGGER.debug(String.format("Size of execution items = %d", this._executionItems.size()));
        LOGGER.debug(String.format("Size of running items = %d", this._runningItems.size()));
        LOGGER.debug(String.format("Size of suspended items = %d", this._suspendedItems.size()));
        LOGGER.debug(String.format("Size of waiting items = %d", this._waitingItems.size()));
        if (this._waitingItems.size() != 0) {
            LOGGER.error("Cannot quiesce Flow when waiting items still exist.");
        }
        int numCompletedItems = this._completedItems.size() + this._suspendedItems.size();
        while (numCompletedItems != numFlowItems) {
            LOGGER.debug("Waiting for running Flow items to complete...");
            LOGGER.debug(String.format("Number of completed items: %s   Number of Flow items: %s", numCompletedItems, numFlowItems));
            this.sleepThread(30000);
            numCompletedItems = this._completedItems.size() + this._suspendedItems.size();
        }
    }

    private void suspendAllWaitingItems() {
        LOGGER.debug(String.format("Moving all waiting items over to suspended items. Number of waiting items to move: %s", this._waitingItems.size()));
        for (ExecutionItem waitingItem : this._waitingItems) {
            if (this._suspendedItems.contains(waitingItem)) continue;
            this._suspendedItems.add(waitingItem);
        }
    }

    private void buildWaitingItems(List<DisplayInfo> items) {
        this._waitingItems.clear();
        for (DisplayInfo item : items) {
            if (this.isItemCompleted(item) || this.isItemRunning(item) || this.isItemSuspended(item)) continue;
            String jobName = this.getFlowInstanceId() + ":" + this._flowInfo.getName() + ":" + item.getName();
            ExecutionItem execItem = new ExecutionItem(item, jobName, this._jfeProps);
            this._waitingItems.add(execItem);
        }
    }

    private boolean isItemSuspended(DisplayInfo info) {
        boolean retval = false;
        for (ExecutionItem item : this._suspendedItems) {
            if (!item._info.getName().equals(info.getName())) continue;
            retval = true;
            break;
        }
        return retval;
    }

    private void buildExecutionItems() throws SchedulerException {
        this._executionItems.clear();
        for (ExecutionItem item : this._waitingItems) {
            if (this.isItemRunning(item._info)) continue;
            if ((this.itemCanExecute(item) || this.isItemDepResolved(item)) && !item._depCannotResolve) {
                this._executionItems.add(item);
            }
            if (!item._depCannotResolve) continue;
            LOGGER.debug(String.format("Suspending item named: %s because its Job dependency cannot be met", item._info.getName()));
            this._suspendedItems.add(item);
        }
    }

    private boolean itemCanExecute(ExecutionItem item) {
        return !this.isItemRunning(item._info) && !this.itemHasDeps(item) && !this.isItemSuspended(item._info);
    }

    private boolean isItemRunning(DisplayInfo info) {
        boolean retval = false;
        for (ExecutionItem item : this._runningItems) {
            if (!item._info.getName().equals(info.getName())) continue;
            retval = true;
            break;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isItemCompleted(DisplayInfo info) {
        Object object = this._syncLockObj;
        synchronized (object) {
            boolean retval = false;
            for (ExecutionItem item : this._completedItems) {
                if (!item._info.getName().equals(info.getName())) continue;
                retval = true;
                break;
            }
            return retval;
        }
    }

    private boolean isItemDepResolved(ExecutionItem item) throws SchedulerException {
        JobEventInfo jei;
        LOGGER.debug(String.format("Checking dep resolution for item named: %s", item._info.getName()));
        boolean retval = false;
        String jobDepTargetName = item._info.getName();
        DisplayInfo event = null;
        DisplayInfo info = item._info;
        if (info instanceof JobInfo) {
            event = this._flowInfo.getEvent((JobInfo)info);
        } else if (info instanceof FlowInfo) {
            event = this._flowInfo.getEvent((FlowInfo)info);
        }
        if (event == null) {
            String msg = String.format("In isItemDepsResolved(): getEvent() returned null for item: %s", jobDepTargetName);
            LOGGER.error(msg);
            throw new SchedulerException(msg);
        }
        if (event instanceof JobEventInfo && !((JobEventInfo)event).getJobDataBinding().isSubFlowDataBinding()) {
            jei = (JobEventInfo)event;
            JobDepChecker jobDepChecker = new JobDepChecker(jobDepTargetName, jei, this._runningItems, this._completedItems);
            String jeiJobName = this.buildFullyQualifiedJobName(jei.getJobInfo().getName());
            boolean isCompleted = this.isItemJobDepCompleted(jei);
            retval = jobDepChecker.evalJobExpression(jeiJobName);
            if (!retval && isCompleted) {
                LOGGER.debug(String.format("Determined that item named: %s has a Job dependency that cannot be met. Setting depCannotResolve flag for that item.", item._info.getName()));
                item._depCannotResolve = true;
            } else if (!retval && this.isItemFlowDepCompleted(jei)) {
                retval = true;
            }
        }
        if (event instanceof JobEventInfo && ((JobEventInfo)event).getJobDataBinding().isSubFlowDataBinding()) {
            jei = (JobEventInfo)event;
            FlowDepChecker flowDepChecker = new FlowDepChecker(jobDepTargetName, jei, this._flowManagerCallback.getCompletedFlowHistories());
            retval = flowDepChecker.evalJobExpression();
            if (!retval && this.isItemJobDepCompleted(jei)) {
                LOGGER.debug(String.format("Determined that item named: %s has a Job dependency that cannot be met. Setting depCannotResolve flag for that item.", item._info.getName()));
                item._depCannotResolve = true;
            } else if (!retval && this.isItemFlowDepCompleted(jei)) {
                retval = true;
            }
        }
        if (event instanceof TimeEventInfo) {
            TimeEventInfo tei = (TimeEventInfo)event;
            TimeDepExpressionChecker timeDepChecker = new TimeDepExpressionChecker(jobDepTargetName, tei, this._runningItems, this._completedItems, this._flowStartDate);
            try {
                retval = timeDepChecker.evalTimeExpression();
            }
            catch (SchedulerException e) {
                LOGGER.error(e.getMessage());
                LOGGER.debug(e.getStackTrace()[0].toString());
            }
        }
        if (event instanceof GroupingEventInfo) {
            GroupingEventInfo gei = (GroupingEventInfo)event;
            retval = this.gateCheck(gei, item);
            if (gei.getDepCheckAlwaysFalse()) {
                item._depCannotResolve = true;
                return false;
            }
        }
        LOGGER.debug(String.format("Dep resolution for item named: %s is %s", item._info.getName(), retval));
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isItemJobDepCompleted(JobEventInfo jei) {
        Object object = this._syncLockObj;
        synchronized (object) {
            boolean retval = false;
            JobInfo job = jei.getJobInfo();
            if (job.isSubflow()) {
                retval = this._flowManagerCallback.isFlowCompleted(job.getName());
            } else {
                String jobEventName = job.getName();
                for (ExecutionItem item : this._completedItems) {
                    if (!item._info.getName().equals(jobEventName)) continue;
                    retval = true;
                    break;
                }
            }
            return retval;
        }
    }

    private boolean isItemFlowDepCompleted(JobEventInfo jei) {
        boolean retval = false;
        String jobEventName = jei.getName();
        retval = this._flowManagerCallback.isFlowCompleted(jobEventName);
        return retval;
    }

    private boolean itemHasDeps(ExecutionItem item) {
        boolean retval = false;
        DisplayInfo event = null;
        if (item._info instanceof JobInfo) {
            event = this._flowInfo.getEvent((JobInfo)item._info);
        }
        retval = event != null;
        return retval;
    }

    private boolean gateCheck(GroupingEventInfo gei, ExecutionItem item) {
        if (!this.hasSubGates(gei) && this.gateCannotOpen(gei, item)) {
            gei.setDepCheckAlwaysFalse(true);
            return false;
        }
        boolean depcheck = false;
        boolean accumulator = gei.getConditionDataBinding() == 0;
        String jobDepTargetName = item._info.getName();
        List gateEvents = gei.getEvents();
        for (AbstractEventInfo gateEvent : gateEvents) {
            if (gateEvent instanceof JobEventInfo) {
                JobEventInfo jei = (JobEventInfo)gateEvent;
                JobInfo job = jei.getJobInfo();
                if (job.isSubflow()) {
                    FlowDepChecker subflowDepChecker = new FlowDepChecker(jobDepTargetName, jei, this._flowManagerCallback.getCompletedFlowHistories());
                    depcheck = subflowDepChecker.evalJobExpression();
                } else {
                    JobDepChecker jobDepChecker = new JobDepChecker(jobDepTargetName, jei, this._runningItems, this._completedItems);
                    String jeiJobName = this.buildFullyQualifiedJobName(jei.getJobInfo().getName());
                    depcheck = jobDepChecker.evalJobExpression(jeiJobName);
                }
            }
            if (gateEvent instanceof TimeEventInfo) {
                TimeEventInfo tei = (TimeEventInfo)gateEvent;
                TimeDepExpressionChecker timeDepChecker = new TimeDepExpressionChecker(jobDepTargetName, tei, this._runningItems, this._completedItems, this._flowStartDate);
                try {
                    depcheck = timeDepChecker.evalTimeExpression();
                }
                catch (SchedulerException e) {
                    LOGGER.error(e.getMessage());
                    LOGGER.debug(e.getStackTrace()[0].toString());
                }
            }
            if (gateEvent instanceof GroupingEventInfo) {
                GroupingEventInfo g = (GroupingEventInfo)gateEvent;
                depcheck = this.gateCheck(g, item);
                if (gei.getConditionDataBinding() == 0 && g.getDepCheckAlwaysFalse()) {
                    gei.setDepCheckAlwaysFalse(true);
                }
            }
            if (gei.getConditionDataBinding() == 0 && !depcheck) {
                return false;
            }
            if (gei.getConditionDataBinding() == 1 && depcheck) {
                if (!depcheck) continue;
                return true;
            }
            if (gei.getConditionDataBinding() == 0) {
                accumulator = accumulator && depcheck;
                continue;
            }
            accumulator = accumulator || depcheck;
        }
        return accumulator;
    }

    private boolean gateCannotOpen(GroupingEventInfo gei, ExecutionItem item) {
        boolean gateIsAndGate;
        String jobDepTargetName = item._info.getName();
        List gateEvents = gei.getEvents();
        for (AbstractEventInfo gateEvent : gateEvents) {
            if (!(gateEvent instanceof JobEventInfo)) continue;
            JobEventInfo jei = (JobEventInfo)gateEvent;
            boolean isCompleted = this.isItemJobDepCompleted(jei);
            JobInfo job = jei.getJobInfo();
            boolean jobExprEval = false;
            if (job.isSubflow()) {
                FlowDepChecker subflowDepChecker = new FlowDepChecker(jobDepTargetName, jei, this._flowManagerCallback.getCompletedFlowHistories());
                jobExprEval = subflowDepChecker.evalJobExpression();
            } else {
                JobDepChecker jobDepChecker = new JobDepChecker(jobDepTargetName, jei, this._runningItems, this._completedItems);
                String jeiJobName = this.buildFullyQualifiedJobName(jei.getJobInfo().getName());
                jobExprEval = jobDepChecker.evalJobExpression(jeiJobName);
            }
            if (jobExprEval || !isCompleted) continue;
            jei.setDepCheckAlwaysFalse(true);
        }
        boolean retval = false;
        boolean bl = gateIsAndGate = gei.getConditionDataBinding() == 0;
        if (gateIsAndGate) {
            for (AbstractEventInfo gateEvent : gateEvents) {
                if (!gateEvent.getDepCheckAlwaysFalse()) continue;
                retval = true;
                break;
            }
        } else {
            boolean accumulator = true;
            for (AbstractEventInfo gateEvent : gateEvents) {
                if (accumulator = accumulator && gateEvent.getDepCheckAlwaysFalse()) continue;
                break;
            }
            retval = accumulator;
        }
        return retval;
    }

    private boolean hasSubGates(GroupingEventInfo gei) {
        boolean retval = false;
        List gateEvents = gei.getEvents();
        for (AbstractEventInfo gateEvent : gateEvents) {
            if (!(gateEvent instanceof GroupingEventInfo)) continue;
            retval = true;
            break;
        }
        return retval;
    }

    private boolean setFlowCompletionAttributes(FlowInfo flow) {
        List csjNames = flow.getCompletionSelectedJobNamesDataBinding();
        this._completionCriteriaPresent = !CollectionUtils.isEmpty((Collection)csjNames);
        try {
            int exitcode = flow.getExitcodeBehaviorDataBinding();
            switch (exitcode) {
                case 1: {
                    this._exitCodeSummation = false;
                    break;
                }
                default: {
                    this._exitCodeSummation = true;
                    break;
                }
            }
        }
        catch (NullPointerException npe) {
            this._exitCodeSummation = false;
        }
        return true;
    }

    protected class FlowRunnerCallback {
        protected FlowRunnerCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void callbackJobCompleted(ExecutionItem item) {
            Object object = FlowRunner.this._syncLockObj;
            synchronized (object) {
                LOGGER.debug(String.format("Received callback for completed execution item named: %s", item._jobName));
                FlowRunner.this._completedItems.add(item);
                FlowRunner.this._waitingItems.remove(item);
                FlowRunner.this._runningItems.remove(item);
                if (item._sasJFSJobInfo.getCompletionCode() != 0) {
                    if (this.noDepOnNonZeroExitItem(item)) {
                        FlowRunner.this._itemExitedNonZero = true;
                        FlowRunner.this._itemWithNonZeroExitCode = item;
                    }
                    if (FlowRunner.this._exitCodeSummation) {
                        FlowRunner.this._exitCodeSum += item._sasJFSJobInfo.getCompletionCode();
                    } else {
                        FlowRunner.this._historyOfLastJob = item._sasJFSJobInfo;
                    }
                }
                FlowRunner.this._flowManagerCallback.callbackJobCompleted(item, item._jobName);
            }
        }

        private boolean noDepOnNonZeroExitItem(ExecutionItem item) {
            boolean retval = true;
            List flowDeps = FlowRunner.this._flowInfo.getJobDependenciesDataBinding();
            DisplayInfo event = null;
            event = this.getItemEvent(item, flowDeps);
            retval = event == null;
            return retval;
        }

        private DisplayInfo getItemEvent(ExecutionItem item, List<JobDependency> flowDeps) {
            AbstractEventInfo retval = null;
            String itemName = item._info.getName();
            for (JobDependency jobDepInfo : flowDeps) {
                AbstractEventInfo event = jobDepInfo.getEvent();
                if (!(event instanceof JobEventInfo) || !((JobEventInfo)event).getName().equals(itemName)) continue;
                retval = event;
            }
            return retval;
        }

        public void callbackJobRunning(ExecutionItem _executionItem) {
            FlowRunner.this._flowManagerCallback.callbackJobRunning(_executionItem, _executionItem._jobName);
        }
    }
}

