/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.floworchestration;

import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.FlowManager;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.FlowManagerFactory;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.JFOrchClient;
import com.sas.scheduler.api.servers.sasjfs.mq.JMSUtilities;
import com.sas.scheduler.api.servers.sasjfs.trigger.OSTriggerUtilities;
import com.sas.scheduler.api.servers.sasjfs.trigger.serviceinterface.ITaskScheduler;
import com.sas.scheduler.api.servers.sasjfs.utilities.CLIReturnCodes;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;

public class FlowOrchestrator {
    public static Logger LOGGER = null;
    private static String m_flowId;
    private static boolean m_runNow;
    private static String m_config;
    private static String m_id;
    private static SealedString m_key;
    private static String m_user;
    private static String m_jmsUrl;
    private static String m_jmsClass;
    private static JFOrchClient m_client;

    public static void main(String[] args) {
        ITaskScheduler scheduler;
        String oscommand;
        m_id = JMSUtilities.generatePrimaryId();
        FlowOrchestrator.processCommandLineArguments(args);
        FlowOrchestrator.initLogger();
        JFOrchClient client = FlowOrchestrator.getClient();
        String id = client.getServiceId(m_id);
        if (id == null) {
            LOGGER.fatal("NOSERVICE");
            System.exit(CLIReturnCodes.TRY_AGAIN.getValue());
        } else if (!id.equals(m_id)) {
            if (client.isHA()) {
                LOGGER.fatal("NONPRIMARYNODE");
                oscommand = client.getOSCommandPath();
                scheduler = OSTriggerUtilities.initScheduler(null, null, oscommand, m_flowId, m_user, m_key, LOGGER);
                scheduler.deleteTask();
                System.exit(CLIReturnCodes.PERM_DENIED.getValue());
            }
        } else if (m_runNow) {
            LOGGER.debug("RunNow");
        } else {
            LOGGER.debug("Verifying triggers for: " + m_flowId);
            if (client.isHA() && !client.isScheduled(m_flowId)) {
                LOGGER.debug("Flow is not scheduled and has triggers. Removing the triggers for: " + m_flowId);
                oscommand = client.getOSCommandPath();
                scheduler = OSTriggerUtilities.initScheduler(null, null, oscommand, m_flowId, m_user, m_key, LOGGER);
                scheduler.deleteTask();
                System.exit(CLIReturnCodes.PERM_DENIED.getValue());
            }
            LOGGER.debug("Triggers verified for: " + m_flowId);
        }
        LOGGER.trace("Starting...");
        FlowManagerFactory fmFactory = new FlowManagerFactory();
        FlowManager fm = fmFactory.getInstance(m_flowId, m_client, m_runNow);
        Thread fmThread = new Thread(fm);
        fmThread.start();
        LOGGER.trace("Terminating.");
    }

    private static void initLogger() {
        block6: {
            try {
                System.setProperty("hostName", InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException e) {
                System.setProperty("hostName", "localhost");
            }
            System.setProperty("userName", System.getProperty("user.name"));
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss", Locale.US);
            String time = dateFormat.format(new Date());
            System.setProperty("timeStamp", time);
            if (!m_config.endsWith(File.separator)) {
                m_config = m_config + File.separator;
            }
            String log4jConfigFilePath = m_config + "log4j2.xml";
            File log4jConfigFile = new File(log4jConfigFilePath = FlowOrchestrator.handleSpacesInPath(log4jConfigFilePath));
            if (!log4jConfigFile.exists()) {
                throw new IllegalArgumentException("log4j2.xml not found in configDir: " + m_config);
            }
            try {
                LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
                context.setConfigLocation(log4jConfigFile.toURI());
            }
            catch (Exception e) {
                if (!MetaUtilities.isDebug()) break block6;
                e.printStackTrace();
            }
        }
        LOGGER = LogManager.getLogger(FlowOrchestrator.class);
        LOGGER.debug("initLogger() complete");
    }

    private static void processCommandLineArguments(String[] saArgs) {
        int nArgs = saArgs.length;
        for (int iArg = 0; iArg < nArgs; ++iArg) {
            if (MetaUtilities.isDebug()) {
                String nextarg;
                String string = nextarg = iArg + 1 < nArgs ? saArgs[iArg + 1] : null;
                if (nextarg != null && !nextarg.startsWith("-")) {
                    System.out.println(saArgs[iArg] + " " + nextarg);
                } else {
                    System.out.println(saArgs[iArg]);
                }
            }
            if (saArgs[iArg].equalsIgnoreCase("-execute")) {
                m_flowId = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-config")) {
                m_config = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-jmsUrl")) {
                m_jmsUrl = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-jmsContextFactory")) {
                m_jmsClass = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-runNow")) {
                m_runNow = true;
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-key")) {
                String key;
                m_key = (key = saArgs[++iArg]) != null ? new SealedString(key) : null;
                continue;
            }
            if (!saArgs[iArg].equalsIgnoreCase("-user")) continue;
            m_user = saArgs[++iArg];
        }
    }

    private static JFOrchClient getClient() {
        if (m_client == null) {
            try {
                String id = JMSUtilities.generatePrimaryId();
                Properties properties = new Properties();
                if (m_config != null) {
                    properties.setProperty("sasjfs.commandLine.filePath", m_config);
                }
                if (m_jmsUrl != null) {
                    properties.setProperty("java.naming.provider.url", m_jmsUrl);
                } else {
                    String value = "tcp://localhost:61616";
                    properties.setProperty("java.naming.provider.url", value);
                }
                if (m_jmsClass != null) {
                    properties.setProperty("java.naming.factory.initial", m_jmsClass);
                } else {
                    properties.setProperty("java.naming.factory.initial", "org.apache.activemq.jndi.ActiveMQInitialContextFactory");
                }
                if (m_user != null) {
                    properties.setProperty("JMSSecurityUserid", m_user);
                }
                if (m_key != null) {
                    properties.setProperty("JMSSecurityPasswd", new String(m_key.getCharacters()));
                }
                m_client = new JFOrchClient(id, properties);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return m_client;
    }

    private static String handleSpacesInPath(String path) {
        String retval = null;
        if (-1 == path.indexOf(" ")) {
            return path;
        }
        if (FlowOrchestrator.pathIsQuoted(path)) {
            return path;
        }
        retval = "\"" + path + "\"";
        return retval;
    }

    private static boolean pathIsQuoted(String path) {
        return path.startsWith("\"") && path.endsWith("\"");
    }

    static {
        m_runNow = false;
        m_config = FlowOrchestrator.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        m_user = System.getProperty("userName");
        m_jmsUrl = System.getProperty("sas.sasjfs.jms.url");
        m_jmsClass = System.getProperty("sas.sasjfs.jms.factory");
    }
}

