/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.engine;

import com.sas.scheduler.api.servers.sasjfs.engine.ClientLogger;
import com.sas.services.webdav.FileCleanup;
import com.sas.svcs.content.document.client.Document;
import com.sas.svcs.content.document.client.DocumentService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;

public class DAVOutputStream
extends OutputStream {
    private DocumentService mService;
    private Document mDoc;
    private File mTempFile;
    private BufferedOutputStream mOutputStream;
    private long mStartTime;
    private ClientLogger mLogger;

    public DAVOutputStream(DocumentService docService, Document doc, ClientLogger logger) throws FileNotFoundException {
        this.mService = docService;
        this.mDoc = doc;
        this.mTempFile = FileCleanup.getInstance().newTemporaryFile(0);
        this.mOutputStream = new BufferedOutputStream(new FileOutputStream(this.mTempFile));
        this.mStartTime = System.currentTimeMillis();
        this.mLogger = logger;
    }

    @Override
    public void close() throws IOException {
        int bytesRead;
        this.mOutputStream.close();
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.mTempFile));
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)this.mTempFile.length());
        byte[] buffer = new byte[4096];
        while ((bytesRead = ((InputStream)is).read(buffer)) >= 0) {
            bos.write(buffer, 0, bytesRead);
        }
        int size = bos.size();
        this.mDoc.setContentStream(bos.toByteArray());
        long updateStartTime = System.currentTimeMillis();
        try {
            this.mService.updateDocument(this.mDoc);
        }
        catch (Exception e) {
            IOException wrapper = new IOException("Error in DAVOutputStream");
            wrapper.initCause(e);
            throw wrapper;
        }
        finally {
            ((InputStream)is).close();
        }
        this.mTempFile = null;
        this.mOutputStream = null;
        this.mLogger.logMessage(Level.FINE, "Write (stream open) time for (" + this.mDoc.getPath() + "): " + (System.currentTimeMillis() - this.mStartTime) + " update only(" + (System.currentTimeMillis() - updateStartTime) + ") bytes=" + size);
    }

    @Override
    public void flush() throws IOException {
        this.mOutputStream.flush();
    }

    @Override
    public void write(int b) throws IOException {
        if (this.mOutputStream == null) {
            return;
        }
        this.mOutputStream.write(b);
    }
}

