/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs;

import com.sas.launcher.client.LauncherClientException;
import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.Calendar;
import com.sas.scheduler.api.servers.FlowHistory;
import com.sas.scheduler.api.servers.IConfiguration;
import com.sas.scheduler.api.servers.IConsole;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.api.servers.SchedulerIMPL;
import com.sas.scheduler.api.servers.sasjfs.SASJFSCalendar;
import com.sas.scheduler.api.servers.sasjfs.SASJFSClient;
import com.sas.scheduler.api.servers.sasjfs.SASJFSFlowHistory;
import com.sas.scheduler.api.servers.sasjfs.SASJFSJob;
import com.sas.scheduler.api.servers.sasjfs.engine.ClientLogger;
import com.sas.scheduler.api.servers.sasjfs.engine.HistorySearchOptions;
import com.sas.scheduler.api.servers.sasjfs.engine.JFSScheduleManager;
import com.sas.scheduler.api.servers.sasjfs.mq.JMSServiceSupport;
import com.sas.scheduler.api.servers.sasjfs.trigger.OSTriggerUtilities;
import com.sas.scheduler.api.servers.sasjfs.utilities.SASJFSLauncherClient;
import com.sas.scheduler.api.servers.sasjfs.utilities.SGMGConfigurationUtilities;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.JobRendererInfo;
import com.sas.scheduler.model.RunHistory;
import com.sas.scheduler.model.ScheduledFlowInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.model.XMLFactory;
import com.sas.util.BASE64;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SASJFScheduler
extends SchedulerIMPL
implements Scheduler,
IConsole,
IConfiguration {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(SASJFScheduler.class);
    private static final Logger LOGGER = LogManager.getLogger(SASJFScheduler.class);
    public static final String ARGSEPARATOR = "_;_";
    public static final String SCHEDULE = "scheduleflow_;_";
    public static final String EXECUTE = "executeflow_;_";
    public static final String RESCHEDULE = "rescheduleflow_;_";
    public static final String UNSCHEDULE = "unscheduleflow_;_";
    public static final String RESULTS = "rc_;_";
    public static final String STATUS = "status";
    public static final String EXIT = "exit";
    public static final String TAG_SCHEDULE = "ScheduleFlow";
    public static final String TAG_EXECUTE = "ExecuteFlow";
    public static final String TAG_RESCHEDULE = "RescheduleFlow";
    public static final String TAG_UNSCHEDULE = "UnscheduleFlow";
    private static ClientLogger mLogger;
    private static Level mDefaultLogLevel;
    private SASJFSCalendar m_cal;
    private static SASJFSClient sasjfsClient;
    private static SASJFSLauncherClient sasjfsLauncherClient;
    private static JMSServiceSupport m_jmsSupport;
    private static Properties m_config;
    private String m_id;
    private List<String> sgmgQueues = new ArrayList<String>();
    private List<String> sgmgLimits = new ArrayList<String>();
    private List<String> sgmgTags = new ArrayList<String>();
    private List<String> sgmgConResources = new ArrayList<String>();
    private List<String> sgmgReqResources = new ArrayList<String>();
    private boolean isLocalPropsConfig = false;
    public static final String JobTag = "SASJFSJobV1:";
    public static final String JobDefinitionSeparator = "||";
    public static final String Queue = "Queue:";
    public static final String Restartable = "Restartable:";
    public static final String EnvVars = "Variables:";
    public static final String Tags = "Tags:";
    public static final String RequiredResources = "RequiredResources:";
    public static final String ConsumedResources = "ConsumedResources:";

    public SASJFScheduler() {
    }

    public SASJFScheduler(SchedulerServerInfo info) {
        super(info);
        if (info.isUseHADataBinding()) {
            m_config.setProperty("java.naming.provider.url", info.getJavaNamingProviderUrlDataBinding());
            m_config.setProperty("java.naming.factory.initial", info.getJavaNamingFactoryDataBinding());
            m_jmsSupport = new JMSServiceSupport(mLogger, m_config);
            this.m_id = m_jmsSupport.getServiceId(info.getId());
        }
    }

    @Override
    public boolean isValidFlowName(String name) {
        int namelen = name.length();
        if (namelen == 0) {
            return false;
        }
        char firstChar = name.charAt(0);
        if (!Character.isUnicodeIdentifierStart(firstChar) && firstChar != SUBCHAR) {
            return false;
        }
        for (int i = 1; i < namelen; ++i) {
            if (Character.isUnicodeIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getClassId() {
        return "8b4dc45a-f7c7-11e7-8c3f-9a214cf093ae";
    }

    @Override
    public boolean isFlowScheduled(String id) {
        SASJFSFlowHistory history = this.getSASJFSClient().retrieveFlowHistoryforInstance(String.valueOf(id));
        return history != null;
    }

    @Override
    public boolean isFlowScheduled(FlowInfo flow) {
        return this.verifyFlowScheduled(flow);
    }

    @Override
    public boolean verifyFlowScheduled(FlowInfo flow) {
        return flow.isFlowSubmitted();
    }

    @Override
    public boolean isValidJobName(String name) {
        return SASJFSJob.isValidName(name);
    }

    @Override
    public String getInvalidChars(boolean flow) {
        if (flow) {
            return "][:;)(#$/";
        }
        return SASJFSJob.getInValidChars();
    }

    @Override
    public long getFlowInstance(FlowInfo flow) throws SchedulerException {
        return this.getSASJFSClient().getFlowInstance(flow.getScheduledUserIdDataBinding(), flow.getFlowDefinitionIdDataBinding());
    }

    @Override
    public int getMaxFlowHistoryCount() throws SchedulerException {
        return 3;
    }

    @Override
    public FlowHistory getFlowHistory(FlowInfo flow) {
        List flowHistories = this.getFlowHistoryList(flow, 1);
        if (flowHistories.size() == 0) {
            return null;
        }
        return (FlowHistory)flowHistories.get(0);
    }

    public List getFlowHistoryList(String userid, int count) {
        ArrayList flowHistories = new ArrayList();
        if (count < 0) {
            return flowHistories;
        }
        HistorySearchOptions searchOptions = new HistorySearchOptions();
        searchOptions.setCountPerFlow(count);
        searchOptions.setOwner(userid);
        return this.getSASJFSClient().getFlowHistory(searchOptions);
    }

    public List getFlowHistoryList(FlowInfo flow, int count) {
        List<Object> flowHistories = new ArrayList();
        if (count < 0) {
            return flowHistories;
        }
        String flowID = flow.getFlowDefinitionIdDataBinding();
        if (flowID.length() == 0) {
            flowID = this.getFlowDefinitionId(flow);
        }
        if (flowID != null) {
            flowHistories = this.getSASJFSClient().getFlowHistory(null, new String[]{flowID}, count);
        }
        return flowHistories;
    }

    public List getAllFlowHistory() {
        HistorySearchOptions searchOptions = new HistorySearchOptions();
        return this.getSASJFSClient().getFlowHistory(searchOptions);
    }

    public List getFlowHistoryList(String userid, List flowList, int count) {
        ArrayList flowHistories = new ArrayList();
        if (count < 0) {
            return flowHistories;
        }
        ArrayList<String> flowIDs = new ArrayList<String>();
        for (FlowInfo flow : flowList) {
            String flowID = flow.getScheduleDefinitionId();
            if (flowID.length() == 0) {
                flowID = this.genFlowName(flow);
            }
            flowIDs.add(flowID);
        }
        return this.getSASJFSClient().getFlowHistory(userid, flowIDs.toArray(new String[0]), count);
    }

    @Override
    public Date getFinishTime(long id) throws SchedulerException {
        return this.getSASJFSClient().retrieveFlowHistoryforInstance(String.valueOf(id)).getFinishTime();
    }

    @Override
    public Date getStartTime(long id) throws SchedulerException {
        return this.getSASJFSClient().retrieveFlowHistoryforInstance(String.valueOf(id)).getStartTime();
    }

    @Override
    public int getState(long id) throws SchedulerException {
        return this.getSASJFSClient().retrieveFlowHistoryforInstance(String.valueOf(id)).getState();
    }

    @Override
    public int getStatus(long id) throws SchedulerException {
        return this.getSASJFSClient().retrieveFlowHistoryforInstance(String.valueOf(id)).getState();
    }

    @Override
    @Deprecated
    protected boolean maketheConnection(String user, String pass) throws SchedulerException {
        return this.maketheConnection(user, pass != null ? new SealedString(pass) : null);
    }

    @Override
    protected boolean maketheConnection(String user, SealedString pass) throws SchedulerException {
        boolean isConnected = false;
        try {
            if (this.connectToLauncher(user, pass)) {
                this.m_schedulingServer.setUsername(user);
                if (MetaUtilities.isAllowPasswordCache()) {
                    this.m_schedulingServer.setPassword(pass != null ? String.valueOf(pass.getCharacters()) : null);
                }
                if (!this.getSASJFSLauncherClient().updateKey(this.m_schedulingServer.getTriggerCommandDataBinding(), this.m_schedulingServer.getUsernameDataBinding(), this.getSchServerInfoPasswordSealedString())) {
                    LOGGER.error("Unable to send command in Launcher to update windows task.");
                }
                String restApiPath = this.m_schedulingServer.getRestAPIPath();
                isConnected = true;
            }
        }
        catch (LauncherClientException e) {
            SchedulerException ex = new SchedulerException(m_bundle.getString("SASJFSScheduler.InvalidLauncher.txt"), SASJFScheduler.class, "SASJFSScheduler.InvalidLauncher.txt", null);
            throw ex;
        }
        catch (RuntimeException e) {
            LOGGER.debug(e.getMessage());
            return false;
        }
        return isConnected;
    }

    @Override
    public boolean scheduleFlow(FlowInfo flow) throws SchedulerException, UnsupportedOperationException, InvalidParameterException {
        boolean rc = false;
        String flowname = flow.getName();
        String userid = this.m_schedulingServer.getUsernameDataBinding();
        if (flow.getScheduledUserIdDataBinding() == null) {
            LOGGER.debug("Setting scheduled user field.");
            flow.setScheduledUserIdDataBinding(userid);
        }
        LOGGER.debug("Generating XML for flow (" + flowname + ") scheduled by: " + userid);
        flow.setFlowDefinitionIdDataBinding(JFSScheduleManager.genFlowDefinitionId(flowname, userid));
        String xml = XMLFactory.generateXML((FlowInfo)flow, (boolean)true, (boolean)true, (boolean)true);
        String flowDefId = this.getSASJFSClient().setFlowInfo(flowname, userid, xml, false);
        if (!flow.getFlowDefinitionIdDataBinding().equals(flowDefId)) {
            LOGGER.debug("Flow definition id changed on setFlowInfo call to mid-tier.");
            flow.setFlowDefinitionIdDataBinding(flowDefId);
        }
        if (flow.getTriggerType().equalsIgnoreCase("Manual") && !flowDefId.isEmpty()) {
            return true;
        }
        String flowOrchCmd = this.m_schedulingServer.getFlowOrchestrationCommand();
        String osTriggerCmd = this.m_schedulingServer.getTriggerCommand();
        String oscommand = this.m_schedulingServer.getOSCommandPath();
        String jmsUrl = this.m_schedulingServer.getJavaNamingProviderUrlDataBinding();
        String jmsClass = this.m_schedulingServer.getJavaNamingFactoryDataBinding();
        String flowOrchCommand = OSTriggerUtilities.buildFlowOrchestratorCommand(1, flowOrchCmd, flowDefId, jmsUrl, jmsClass);
        String command = OSTriggerUtilities.buildOSTriggerCommand(1, flowDefId, osTriggerCmd, jmsUrl, jmsClass, flowOrchCommand, oscommand);
        if (this.m_schedulingServer.isUseHADataBinding()) {
            try {
                this.m_id = m_jmsSupport.getServiceId(flow.getId());
                String host = this.m_schedulingServer.getFlowOrchestratorHost();
                int port = 1981;
                if (this.m_schedulingServer.getFlowOrchPortDataBinding() != null) {
                    port = new Integer(this.m_schedulingServer.getFlowOrchPortDataBinding());
                }
                String cmd = SCHEDULE + command + ARGSEPARATOR + host + ARGSEPARATOR + port + ARGSEPARATOR + this.m_schedulingServer.getUsername() + ARGSEPARATOR + this.m_schedulingServer.getPassword() + ARGSEPARATOR + this.m_schedulingServer.isSSLEnabled();
                m_jmsSupport.sendResponseToClient(m_jmsSupport.getSchedulerRequestQueue(), cmd, this.m_id, TAG_SCHEDULE);
                int exitcode = m_jmsSupport.getSchedulerResults(SCHEDULE, this.m_id, TAG_SCHEDULE);
                rc = exitcode == 0;
            }
            catch (RuntimeException rte) {
                SASJFScheduler.getLogger().logMessage(Level.FINE, rte);
            }
        } else {
            rc = this.getSASJFSLauncherClient().scheduleFlow(command, this.m_schedulingServer.getUsernameDataBinding(), this.getSchServerInfoPasswordSealedString());
        }
        if (rc) {
            flow.setFlowSubmitted(true, this.m_schedulingServer.getUsername());
        }
        return rc;
    }

    @Override
    public int rescheduleFlow(FlowInfo flow, boolean errorOnDelete) throws SchedulerException {
        int rc = 1;
        String flowDefId = flow.getFlowDefinitionIdDataBinding();
        String flowId = this.getSASJFSClient().rescheduleFlowInfo(XMLFactory.generateXML((FlowInfo)flow, (boolean)true, (boolean)true, (boolean)true), flowDefId);
        String flowOrchCmd = this.m_schedulingServer.getFlowOrchestrationCommand();
        String osTriggerCmd = this.m_schedulingServer.getTriggerCommand();
        String oscommand = this.m_schedulingServer.getOSCommandPath();
        String jmsUrl = this.m_schedulingServer.getJavaNamingProviderUrlDataBinding();
        String jmsClass = this.m_schedulingServer.getJavaNamingFactoryDataBinding();
        String flowOrchCommand = OSTriggerUtilities.buildFlowOrchestratorCommand(2, flowOrchCmd, flowDefId, jmsUrl, jmsClass);
        String command = OSTriggerUtilities.buildOSTriggerCommand(2, flowDefId, osTriggerCmd, jmsUrl, jmsClass, flowOrchCommand, oscommand);
        if (!flowId.isEmpty() && flow.getTriggerType().equalsIgnoreCase("Manual")) {
            if (this.unscheduleFlow(flowDefId)) {
                rc = 0;
            }
        } else if (this.m_schedulingServer.isUseHADataBinding()) {
            try {
                this.m_id = m_jmsSupport.getServiceId(flow.getId());
                String host = this.m_schedulingServer.getHost();
                int port = 1981;
                if (this.m_schedulingServer.getFlowOrchPortDataBinding() != null) {
                    port = new Integer(this.m_schedulingServer.getFlowOrchPortDataBinding());
                }
                String cmd = RESCHEDULE + command + ARGSEPARATOR + host + ARGSEPARATOR + port + ARGSEPARATOR + this.m_schedulingServer.getUsername() + ARGSEPARATOR + this.m_schedulingServer.getPassword() + ARGSEPARATOR + this.m_schedulingServer.isSSLEnabled();
                m_jmsSupport.sendResponseToClient(m_jmsSupport.getSchedulerRequestQueue(), cmd, this.m_id, TAG_RESCHEDULE);
                rc = m_jmsSupport.getSchedulerResults(RESCHEDULE, this.m_id, TAG_RESCHEDULE);
            }
            catch (RuntimeException rte) {
                SASJFScheduler.getLogger().logMessage(Level.FINE, rte);
            }
        } else if (!flowId.isEmpty() && this.maketheConnection(this.m_schedulingServer.getUsernameDataBinding(), new SealedString(this.m_schedulingServer.getPassword()))) {
            rc = this.getSASJFSLauncherClient().rescheduleFlow(command, this.m_schedulingServer.getUsernameDataBinding(), new SealedString(this.m_schedulingServer.getPassword()));
        }
        return rc;
    }

    @Override
    public boolean removeFlow(FlowInfo flow) throws SchedulerException {
        String flowDefId = flow.getFlowDefinitionIdDataBinding();
        if (flowDefId == null || flowDefId.isEmpty()) {
            flowDefId = this.getFlowDefinitionId(flow);
        }
        if (this.getSASJFSClient().deleteFlow(flowDefId)) {
            this.unscheduleFlow(flowDefId);
            flow.setFlowSubmitted(false, this.m_schedulingServer.getUsername());
            return true;
        }
        return false;
    }

    @Override
    public boolean scheduleFlowNow(FlowInfo flow) throws SchedulerException, UnsupportedOperationException, InvalidParameterException {
        boolean rc = false;
        String flowDefId = this.getSASJFSClient().setFlowInfo(flow.getName(), this.m_schedulingServer.getUsernameDataBinding(), XMLFactory.generateXML((FlowInfo)flow, (boolean)true), true);
        flow.setFlowDefinitionIdDataBinding(flowDefId);
        rc = this.executeFlow(flowDefId);
        return rc;
    }

    private boolean executeFlow(String flowDefId) throws SchedulerException, UnsupportedOperationException, InvalidParameterException {
        boolean rc = false;
        String flowOrchCmd = this.m_schedulingServer.getFlowOrchestrationCommand();
        String jmsUrl = this.m_schedulingServer.getJavaNamingProviderUrlDataBinding();
        String jmsClass = this.m_schedulingServer.getJavaNamingFactoryDataBinding();
        String flowOrchCommand = OSTriggerUtilities.buildFlowOrchestratorCommand(4, flowOrchCmd, flowDefId, jmsUrl, jmsClass);
        if (this.m_schedulingServer.isUseHADataBinding()) {
            try {
                this.m_id = m_jmsSupport.getServiceId(this.m_id);
                String host = this.m_schedulingServer.getFlowOrchestratorHost();
                int port = 1981;
                if (this.m_schedulingServer.getFlowOrchPortDataBinding() != null) {
                    port = new Integer(this.m_schedulingServer.getFlowOrchPortDataBinding());
                }
                String cmd = EXECUTE + flowOrchCommand + ARGSEPARATOR + host + ARGSEPARATOR + port + ARGSEPARATOR + this.m_schedulingServer.getUsername() + ARGSEPARATOR + this.m_schedulingServer.getPassword() + ARGSEPARATOR + this.m_schedulingServer.isSSLEnabled();
                m_jmsSupport.sendResponseToClient(m_jmsSupport.getSchedulerRequestQueue(), cmd, this.m_id, TAG_EXECUTE);
                int exitcode = m_jmsSupport.getSchedulerResults(EXECUTE, this.m_id, TAG_EXECUTE);
                rc = exitcode == 0;
            }
            catch (RuntimeException rte) {
                SASJFScheduler.getLogger().logMessage(Level.FINE, rte);
            }
        } else if (!flowDefId.isEmpty() && this.maketheConnection(this.m_schedulingServer.getUsernameDataBinding(), this.getSchServerInfoPasswordSealedString())) {
            rc = this.getSASJFSLauncherClient().execute(flowOrchCommand);
        }
        return rc;
    }

    public static ClientLogger getLogger() {
        if (mLogger != null) {
            return mLogger;
        }
        mLogger = new ClientLogger(){

            @Override
            public void logMessage(Level l, Throwable t) {
                if (l.intValue() >= mDefaultLogLevel.intValue()) {
                    LOGGER.warn("Exception occurred.", t);
                }
            }

            @Override
            public void logMessage(Level l, String message) {
                if (l.intValue() >= mDefaultLogLevel.intValue()) {
                    LOGGER.warn(message);
                }
            }
        };
        return mLogger;
    }

    @Override
    public Object getCalendarManager() {
        return null;
    }

    @Override
    public Calendar getCalendar(String schedulerCalenderName) {
        if (this.m_cal == null) {
            this.m_cal = new SASJFSCalendar(schedulerCalenderName, null, null);
        }
        return this.m_cal;
    }

    @Override
    public Calendar getCalendar(IRecurrenceInfo info) {
        try {
            SASJFSCalendar cal = new SASJFSCalendar(info, this);
            cal.setDays(info);
            cal.setDescription(info.toXML());
            return cal;
        }
        catch (SchedulerException se) {
            return null;
        }
    }

    @Override
    public Calendar createCalendar(IRecurrenceInfo info) {
        return this.getCalendar(info);
    }

    @Override
    public List<Calendar> getCalendars() {
        return null;
    }

    @Override
    public boolean removeCalendar(Calendar cal) {
        return true;
    }

    @Override
    public boolean addCalendar(Calendar cal) {
        return cal instanceof SASJFSCalendar;
    }

    @Override
    public String getCalAdminID() {
        String admin = this.getCurrentUserID();
        return admin;
    }

    protected static int getMaxHistoriesPerFlow() {
        return 5;
    }

    private SASJFSClient getSASJFSClient() {
        if (sasjfsClient == null) {
            try {
                Properties config = new Properties();
                String factory = this.m_schedulingServer.getJavaNamingFactoryDataBinding();
                if (factory == null || factory.length() == 0) {
                    factory = "org.apache.activemq.jndi.ActiveMQInitialContextFactory";
                }
                config.setProperty("java.naming.factory.initial", factory);
                String url = this.m_schedulingServer.getJavaNamingProviderUrlDataBinding();
                if (url == null || url.length() == 0) {
                    url = "tcp://" + this.m_schedulingServer.getHost() + ":61616";
                }
                config.setProperty("java.naming.provider.url", url);
                if (this.m_connected) {
                    config.setProperty("JMSSecurityUserid", this.m_schedulingServer.getUsername());
                    config.setProperty("JMSSecurityPasswd", this.m_schedulingServer.getPassword());
                }
                String id = this.m_schedulingServer.getConnectionId() != null ? this.m_schedulingServer.getConnectionId() : this.m_schedulingServer.getId();
                sasjfsClient = new SASJFSClient(id, this.m_schedulingServer, config);
            }
            catch (Exception e) {
                LOGGER.error("SASJFS unable to establish client connection to mid-tier server: " + e.getMessage());
            }
        }
        return sasjfsClient;
    }

    private SASJFSLauncherClient getSASJFSLauncherClient() {
        if (sasjfsLauncherClient == null) {
            String host = this.m_schedulingServer.getFlowOrchHostDataBinding();
            if (this.m_schedulingServer.isUseHADataBinding()) {
                this.m_id = m_jmsSupport.getServiceId(this.m_id);
                if (BASE64.decode((String)this.m_id) != null) {
                    host = new String(BASE64.decode((String)this.m_id));
                } else {
                    LOGGER.warn("Possible that the SASJFS OSTrigger Service needs to be restarted.");
                }
            }
            int port = 1981;
            if (this.m_schedulingServer.getFlowOrchPortDataBinding() != null) {
                port = new Integer(this.m_schedulingServer.getFlowOrchPortDataBinding());
            }
            int bufSize = 0xA00000;
            if (this.m_schedulingServer.getBufferSizeDataBinding() != null) {
                bufSize = new Integer(this.m_schedulingServer.getBufferSizeDataBinding());
            }
            boolean isSSLEnabled = this.m_schedulingServer.isSSLEnabled();
            sasjfsLauncherClient = new SASJFSLauncherClient(host, port, bufSize, isSSLEnabled);
        }
        return sasjfsLauncherClient;
    }

    private boolean connectToLauncher(String user, SealedString password) throws SchedulerException {
        return this.getSASJFSLauncherClient().getServerAuthentication(user, password);
    }

    @Override
    public boolean removeFlow(FlowInfo flow, String triggerType) throws UnsupportedOperationException, SchedulerException {
        try {
            boolean rc = this.removeFlow(flow);
            if (rc) {
                flow.setFlowSubmitted(false);
                flow.setScheduleDefinitionId("");
            } else if (triggerType != null && triggerType.equalsIgnoreCase("RunNow")) {
                return true;
            }
            return rc;
        }
        catch (SchedulerException ex) {
            return triggerType != null && triggerType.equalsIgnoreCase("RunNow");
        }
    }

    @Override
    public boolean removeFlow(String flowName) throws UnsupportedOperationException, SchedulerException {
        boolean rc = false;
        FlowInfo info = new FlowInfo();
        info.setName(flowName);
        info.setScheduledUserIdDataBinding(this.m_schedulingServer.getUsername());
        String flowDefId = this.genFlowName(info);
        if (flowName.contains("RunNow")) {
            flowDefId = this.getFlowDefinitionId(flowName);
        }
        if (this.getSASJFSClient().deleteFlow(flowDefId)) {
            this.unscheduleFlow(flowDefId);
        }
        return rc;
    }

    private boolean unscheduleFlow(String flowName) throws UnsupportedOperationException, SchedulerException {
        boolean rc = false;
        String osTriggerCmd = this.m_schedulingServer.getTriggerCommand();
        String oscommand = this.m_schedulingServer.getOSCommandPath();
        String jmsUrl = this.m_schedulingServer.getJavaNamingProviderUrlDataBinding();
        String jmsClass = this.m_schedulingServer.getJavaNamingFactoryDataBinding();
        String command = OSTriggerUtilities.buildOSTriggerCommand(3, flowName, osTriggerCmd, jmsUrl, jmsClass, null, oscommand);
        if (this.m_schedulingServer.isUseHADataBinding()) {
            try {
                this.m_id = m_jmsSupport.getServiceId(this.m_id);
                String host = this.m_schedulingServer.getFlowOrchestratorHost();
                int port = 1981;
                if (this.m_schedulingServer.getFlowOrchPortDataBinding() != null) {
                    port = new Integer(this.m_schedulingServer.getFlowOrchPortDataBinding());
                }
                String cmd = UNSCHEDULE + command + ARGSEPARATOR + host + ARGSEPARATOR + port + ARGSEPARATOR + this.m_schedulingServer.getUsername() + ARGSEPARATOR + this.m_schedulingServer.getPassword() + ARGSEPARATOR + this.m_schedulingServer.isSSLEnabled();
                m_jmsSupport.sendResponseToClient(m_jmsSupport.getSchedulerRequestQueue(), cmd, this.m_id, TAG_UNSCHEDULE);
                int exitcode = m_jmsSupport.getSchedulerResults(UNSCHEDULE, this.m_id, TAG_UNSCHEDULE);
                rc = exitcode == 0;
            }
            catch (RuntimeException rte) {
                SASJFScheduler.getLogger().logMessage(Level.FINE, rte);
            }
        } else if (this.maketheConnection(this.m_schedulingServer.getUsernameDataBinding(), this.getSchServerInfoPasswordSealedString())) {
            rc = this.getSASJFSLauncherClient().unschedule(command);
        }
        return rc;
    }

    @Override
    public boolean killFlowInstance(FlowHistory flowInstance) {
        return this.getSASJFSClient().killFlowInstance(flowInstance.getFlowName(), this.m_schedulingServer.getUsernameDataBinding(), this.getSchServerInfoPasswordSealedString());
    }

    @Override
    public boolean closeConnection() {
        if (this.m_connected) {
            this.getSASJFSClient().deleteSGMGConfiguration();
            if (sasjfsLauncherClient != null) {
                if (sasjfsLauncherClient.closeServerAuthentication()) {
                    sasjfsLauncherClient = null;
                    return super.closeConnection();
                }
                return false;
            }
            return super.closeConnection();
        }
        return true;
    }

    @Override
    public boolean isHistorySupported() throws InvalidParameterException {
        return true;
    }

    @Override
    public boolean isJobDependenciesEnabled() throws InvalidParameterException {
        return true;
    }

    @Override
    public boolean isTimeDependenciesEnabled() throws InvalidParameterException {
        return true;
    }

    @Override
    public boolean isConnectionNeededForAdvanceProperties() {
        return true;
    }

    @Override
    public boolean isFileDependenciesEnabled() throws InvalidParameterException {
        return false;
    }

    private String getFlowDefinitionId(FlowInfo flow) {
        return this.genFlowName(flow).replace(":", "_");
    }

    private String getFlowDefinitionId(String runNowFlowName) {
        String flowname = runNowFlowName.substring("RunNow".length() + 1, runNowFlowName.length());
        String username = this.m_schedulingServer.getUsername();
        flowname = runNowFlowName.contains(username + ":") ? flowname.replace(":", "_") : username + "_" + flowname.replace(":", "_");
        return flowname;
    }

    @Override
    public String runNowName(String flowname) {
        return "RunNow_" + flowname;
    }

    @Override
    public boolean checkVersion(SchedulerIMPL scheduler) throws SchedulerException {
        return false;
    }

    @Override
    public List<JobRendererInfo> getJobRenderers(String schId) {
        return null;
    }

    @Override
    public List<ScheduledFlowInfo> getScheduledFlows(String id, String user) {
        if (id != null) {
            if (id.equals(this.m_schedulingServer.getId())) {
                return this.getSASJFSClient().getScheduledFlows(user);
            }
            return null;
        }
        return this.getSASJFSClient().getScheduledFlows(user);
    }

    @Override
    public List<RunHistory> getRunningJobs(String id, String user) {
        if (id != null) {
            if (id.equals(this.m_schedulingServer.getId())) {
                return this.getSASJFSClient().getRunningJobs(user);
            }
            return null;
        }
        return this.getSASJFSClient().getRunningJobs(user);
    }

    @Override
    public boolean triggerFlow(String id) throws InvalidParameterException, UnsupportedOperationException {
        try {
            return this.executeFlow(id);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean deleteFlow(String id) {
        try {
            return this.removeFlow(id);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean killFlowInstance(String flowInstance) throws SchedulerException {
        return this.getSASJFSClient().killFlowInstance(flowInstance);
    }

    @Override
    public boolean pauseFlowInstance(String flowInstance) throws SchedulerException {
        return this.getSASJFSClient().suspendFlowInstance(flowInstance);
    }

    @Override
    public boolean resumeFlowInstance(String flowInstance) throws SchedulerException {
        return this.getSASJFSClient().resumeFlowInstance(flowInstance);
    }

    @Override
    public StringBuffer getStandardOut(String flowInstance, String jobInstance) throws SchedulerException {
        StringBuffer stdOut = new StringBuffer();
        stdOut.append(this.getSASJFSClient().getStdOut(flowInstance, jobInstance));
        return stdOut;
    }

    @Override
    public StringBuffer getStandardError(String flowInstance, String jobInstance) throws SchedulerException {
        return null;
    }

    @Override
    public List<String> getQueues() {
        return this.sgmgQueues;
    }

    @Override
    public boolean areQueues() {
        return this.sgmgQueues.size() > 1;
    }

    public List<String> getLimits() {
        if (!this.isLocalPropsConfig) {
            this.setSGMGResources();
        }
        return this.sgmgLimits;
    }

    public List<String> getTags() {
        if (!this.isLocalPropsConfig) {
            this.setSGMGResources();
        }
        return this.sgmgTags;
    }

    public List<String> getConResources() {
        if (!this.isLocalPropsConfig) {
            this.setSGMGResources();
        }
        return this.sgmgConResources;
    }

    public List<String> getReqResources() {
        if (!this.isLocalPropsConfig) {
            this.setSGMGResources();
        }
        return this.sgmgReqResources;
    }

    private void setSGMGResources() {
        SGMGConfigurationUtilities sgmgConfg = new SGMGConfigurationUtilities();
        String configurationString = this.getSASJFSClient().getSGMGResources();
        if (!configurationString.isEmpty() && sgmgConfg.createFromData(configurationString)) {
            this.sgmgQueues = sgmgConfg.getSGMGQueues();
            this.sgmgLimits = sgmgConfg.getSGMGLimits();
            this.sgmgTags = sgmgConfg.getSGMGTags();
            this.sgmgConResources = sgmgConfg.getSGMGConResources();
            this.sgmgReqResources = sgmgConfg.getSGMGReqResources();
            this.isLocalPropsConfig = true;
        }
    }

    public String getDefinitionString(String definition, String type) {
        if (definition == null) {
            return null;
        }
        int start = definition.indexOf(type, 0);
        if (start < 0) {
            return null;
        }
        int end = definition.indexOf(JobDefinitionSeparator, start);
        if (end < 0) {
            return null;
        }
        String result = definition.substring(start + type.length(), end).trim();
        return result;
    }

    public List<String> getStringListFromDefinitionString(String definition) {
        ArrayList<String> result = new ArrayList<String>();
        return result;
    }

    public Map<String, String> getStringMapFromDefinitionString(String definition) {
        HashMap<String, String> result = new HashMap<String, String>();
        return result;
    }

    public Map<String, Double> getDoubleMapFromDefinitionString(String definition) {
        HashMap<String, Double> result = new HashMap<String, Double>();
        return result;
    }

    public String createSchedulerResource(String queue, boolean restartable, Map<String, String> vars, List<String> tags, Map<String, Double> requiredResources, Map<String, Double> consumedResources, Map<String, Double> limits) {
        StringBuffer jobDefinition = new StringBuffer(JobTag);
        jobDefinition.append(JobDefinitionSeparator);
        if (queue != null) {
            jobDefinition.append(Queue);
            jobDefinition.append("<queue Value=\"" + queue + "\"/>");
            jobDefinition.append(JobDefinitionSeparator);
        }
        if (restartable) {
            jobDefinition.append(Restartable);
            jobDefinition.append("<restartable Value=\"true\"/>");
            jobDefinition.append(JobDefinitionSeparator);
        }
        if (vars != null && !vars.isEmpty()) {
            String varsString = "";
            jobDefinition.append(EnvVars);
            jobDefinition.append("<environmentVars Value=\"" + varsString + "\"/>");
            jobDefinition.append(JobDefinitionSeparator);
        }
        if (tags != null && tags.size() > 0) {
            String tagsString = "";
            jobDefinition.append(Tags);
            jobDefinition.append("tags Value=\"" + tagsString + "\"/>");
            jobDefinition.append(JobDefinitionSeparator);
        }
        return jobDefinition.toString();
    }

    private String makeStringVar(String name, String value) {
        return name + '=' + value;
    }

    private String makeDoubleVar(String name, Double value) {
        return name + '=' + value;
    }

    @Override
    public String getFlowDefinition(String flowDefId) throws SchedulerException {
        return null;
    }

    @Override
    public boolean holdFlow(String flowDefinition) throws SchedulerException {
        return this.getSASJFSClient().holdFlow(flowDefinition);
    }

    @Override
    public boolean releaseFlow(String flowDefinition) throws SchedulerException {
        return this.getSASJFSClient().releaseFlow(flowDefinition);
    }

    @Override
    public boolean killItemInstance(String flowInstance, String itemInstance) throws SchedulerException {
        return false;
    }

    @Override
    public List<FlowHistory> getFlowHistoryList(String flowname, String userid, int count) throws SchedulerException {
        return null;
    }

    @Override
    public List<String> getMessageQueues(String schId) {
        if (this.m_schedulingServer.getId().compareTo(schId) == 0) {
            return this.getSASJFSClient().getMessageQueues();
        }
        return null;
    }

    @Override
    public List<Object> browseMessageQueue(String queue, String selector) {
        return this.getSASJFSClient().getMessages(queue, selector);
    }

    static {
        mDefaultLogLevel = Level.WARNING;
        sasjfsClient = null;
        sasjfsLauncherClient = null;
        m_config = new Properties();
    }
}

