/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.oozie.job;

import com.sas.scheduler.api.servers.oozie.job.OozieAction;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.JobInfo;
import java.util.ArrayList;
import java.util.List;

public class JobDescriptor {
    String name;
    DisplayInfo deps;
    ACTIONS type;
    List<Package> packages;
    JobInfo info;
    boolean alreadyProcessed = false;
    String sourceDir;
    String sourceFile;
    List<DisplayInfo> okSuccessors = null;
    List<DisplayInfo> failSuccessors = null;
    FlowInfo flow;
    List<JobDescriptor> precursors = new ArrayList<JobDescriptor>();
    List<JobDescriptor> fromok = new ArrayList<JobDescriptor>();
    List<JobDescriptor> fromfail = new ArrayList<JobDescriptor>();
    OozieAction myAction = null;

    public String toString() {
        return this.name;
    }

    JobDescriptor(JobInfo job, FlowInfo flow) {
        this.name = job.getName();
        this.type = ACTIONS.SHELL;
        this.info = job;
        this.sourceDir = "/sas/jobs/";
        this.sourceFile = job.getSourceFile();
        this.flow = flow;
        this.failSuccessors = flow.getFailedSuccessors((DisplayInfo)job);
        this.okSuccessors = flow.getCompletesSuccessors((DisplayInfo)job);
        this.myAction = new OozieAction(this.name, null, null);
    }

    boolean isProcessed() {
        return this.alreadyProcessed;
    }

    void setProcessed(boolean flag) {
        this.alreadyProcessed = flag;
    }

    boolean hasDependencies() {
        return this.deps != null;
    }

    void setDependencies(DisplayInfo dep) {
        this.deps = dep;
    }

    void addFromOk(JobDescriptor node) {
        this.fromok.add(node);
    }

    void addFromFail(JobDescriptor node) {
        this.fromfail.add(node);
    }

    void addPrecursor(JobDescriptor node) {
        this.precursors.add(node);
    }

    boolean isOkFork() {
        return this.okSuccessors.size() > 1;
    }

    boolean isFailFork() {
        return this.failSuccessors.size() > 1;
    }

    boolean isOkJoin() {
        return this.fromok.size() > 1;
    }

    boolean isFailJoin() {
        return this.fromfail.size() > 1;
    }

    static enum ACTIONS {
        SHELL,
        MAP_REDUCE,
        PIG,
        FS,
        SUB_WORKFLOW,
        JAVA,
        OTHER;

    }
}

