/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.lsf;

import com.platform.LSFJobFlow.api.JFAdminManager;
import com.platform.LSFJobFlow.api.JFCalendar;
import com.platform.LSFJobFlow.api.JFCalendarManager;
import com.platform.LSFJobFlow.api.JFConfigManager;
import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFFileEvent;
import com.platform.LSFJobFlow.api.JFFilter;
import com.platform.LSFJobFlow.api.JFFlow;
import com.platform.LSFJobFlow.api.JFFlowDefinitionManager;
import com.platform.LSFJobFlow.api.JFFlowEvent;
import com.platform.LSFJobFlow.api.JFFlowManager;
import com.platform.LSFJobFlow.api.JFHandler;
import com.platform.LSFJobFlow.api.JFInvalidTemplateException;
import com.platform.LSFJobFlow.api.JFJIDInfo;
import com.platform.LSFJobFlow.api.JFJob;
import com.platform.LSFJobFlow.api.JFJobEvent;
import com.platform.LSFJobFlow.api.JFLinkEvent;
import com.platform.LSFJobFlow.api.JFLoginManager;
import com.platform.LSFJobFlow.api.JFPseudoFlowInstance;
import com.platform.LSFJobFlow.api.JFTemplateData;
import com.platform.LSFJobFlow.api.JFTemplateDef;
import com.platform.LSFJobFlow.api.JFTemplateJob;
import com.platform.LSFJobFlow.api.JFTemplateManager;
import com.platform.LSFJobFlow.api.JFTemplateParameter;
import com.platform.LSFJobFlow.api.JFTemplateParameterList;
import com.platform.LSFJobFlow.api.JFTimeEvent;
import com.platform.LSFJobFlow.api.JFUTFConverter;
import com.platform.LSFJobFlow.api.JFUser;
import com.platform.LSFJobFlow.api.JFVersion;
import com.platform.LSFJobFlow.ui.JFUtility;
import com.platform.SASLogin.ServerLoginException;
import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.oma.CommandUtilities;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.Calendar;
import com.sas.scheduler.api.servers.FlowHistory;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.api.servers.SchedulerIMPL;
import com.sas.scheduler.api.servers.lsf.LSFCalendar;
import com.sas.scheduler.api.servers.lsf.LSFFlowHistory;
import com.sas.scheduler.api.servers.lsf.LSFJob;
import com.sas.scheduler.api.servers.lsf.LSFJobEvent;
import com.sas.scheduler.model.AbstractEventInfo;
import com.sas.scheduler.model.DirectoryInfo;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FileEventInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.GeneralUtilities;
import com.sas.scheduler.model.GroupingEventInfo;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.JobEventInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.model.TimeEventInfo;
import com.sas.scheduler.model.TriggerEventInfo;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.PasswordAuthentication;
import java.rmi.RemoteException;
import java.security.InvalidParameterException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.login.LoginException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LSFScheduler
extends SchedulerIMPL
implements Scheduler {
    private static final ResourceBundle m_bundle;
    private static final Logger LOGGER;
    private static final String PRODUCTNAME = "Platform Process Manager";
    private HashMap<String, LSFCalendar> m_calendars = new HashMap();
    public static final String DEFAULTJOBNAME = "DEFAULTJOBNAME";
    public static final String Tzclient = "client";
    public static final String Tzserver = "server";
    private static String m_lastConnectedUser;
    private static ReentrantLock _userLock;
    private FlowInfo m_dflow;
    private JFFlow m_jfFlow;
    private JFFlowDefinitionManager m_flowDefManager;
    private JFFlowManager m_flowMgr;
    private JFCalendarManager m_calMgr;
    private JFAdminManager m_adminMgr;
    private boolean m_userConnected = false;
    private String m_outdir = null;
    private String m_timeZone = "client";
    private String m_stdout = null;
    private String m_stderr = null;
    private boolean m_scoping = false;
    private String m_jsHome;
    private String m_templatedir;
    private File m_templatefile = null;
    private String m_zos_user = null;
    private SealedString m_zos_password = null;
    public static final String EventListPropertyName_Event = "jsObject";
    public static final String ZOS_TEMPLATE = "zOS_Template.xml";
    private static final String cLatin1_HighASCIITo7BitASCII = "________________________________________________________________AAAAAAACEEEEIIIIDNOOOOOxOUUUUY_Saaaaaaaceeeeiiiionooooo_ouuuuy_y";

    public LSFScheduler(SchedulerServerInfo info) {
        super(info);
        try {
            this.m_jsHome = System.getenv("JS_HOME");
            int osType = -1;
            osType = this.m_jsHome.indexOf(92) < 0 ? 1 : 0;
            this.m_templatedir = System.getenv("JS_ENVDIR");
            if (this.m_templatedir != null) {
                this.m_templatedir = CommandUtilities.normalizePath(this.m_templatedir, osType);
                int index = this.m_templatedir.lastIndexOf("/conf");
                if (index > 0) {
                    this.m_templatedir = this.m_templatedir.substring(0, index);
                }
                this.m_templatedir = this.m_templatedir + "/work/templates/";
            } else if (this.m_jsHome != null) {
                this.m_templatedir = CommandUtilities.normalizePath(this.m_jsHome + "/work/templates/", osType);
            } else {
                try {
                    this.m_templatefile = File.createTempFile(ZOS_TEMPLATE, null);
                    this.m_templatedir = this.m_templatefile.getParent();
                }
                catch (IOException ioe) {
                    this.m_templatedir = "./";
                }
            }
            this.m_zos_user = System.getenv("JS_ZOS_USERNAME");
            if (this.m_zos_user != null && this.m_zos_user.length() > 0) {
                this.m_zos_password = System.getenv("JS_ZOS_PASSWORD") != null ? new SealedString(System.getenv("JS_ZOS_PASSWORD")) : null;
            } else {
                this.m_zos_user = null;
            }
        }
        catch (Exception ex) {
            this.m_jsHome = null;
            try {
                this.m_templatefile = File.createTempFile(ZOS_TEMPLATE, null);
                this.m_templatedir = this.m_templatefile.getParent();
            }
            catch (IOException ioe) {
                this.m_templatedir = "./";
            }
        }
    }

    @Override
    public void setAlternativeUserContext(UserContextInterface user, String domain) {
        UserIdentityInterface uI;
        block3: {
            uI = null;
            try {
                uI = user.getIdentityByDomain(domain != null ? domain : "");
            }
            catch (RemoteException e) {
                if (!this.isDebug()) break block3;
                e.printStackTrace();
            }
        }
        if (uI != null) {
            this.m_zos_user = uI.getPrincipal().toString();
            this.m_zos_password = uI.getCredential().toString() != null ? new SealedString(uI.getCredential().toString()) : null;
        }
    }

    @Override
    public int getMaxJobPriority() {
        try {
            JFAdminManager adminMgr = this.validateAdminManager();
            if (adminMgr == null) {
                return -1;
            }
            int max = adminMgr.getMaxUserPriority();
            if (max > 0) {
                return max;
            }
            return -1;
        }
        catch (IOException ioe) {
            return -1;
        }
        catch (NullPointerException npe) {
            return -1;
        }
        catch (JFException jfe) {
            return -1;
        }
        catch (SchedulerException se) {
            return -1;
        }
    }

    public String getTimeZoneOrientation() {
        return this.m_timeZone;
    }

    public void setTimeZoneOrientation(String perspective) {
        this.m_timeZone = perspective;
    }

    public void setOutputDirectory(String dir) {
        this.m_outdir = dir;
    }

    public String getStdout(String flowname, String jobname) {
        if (this.m_stdout != null) {
            String stdout = GeneralUtilities.replaceString((String)this.m_stdout, (String)"%f", (String)flowname);
            stdout = GeneralUtilities.replaceString((String)stdout, (String)"%j", (String)jobname);
            return stdout;
        }
        return this.m_stdout;
    }

    public void setStdout(String stdout) {
        this.m_stdout = stdout;
    }

    public String getStderr(String flowname, String jobname) {
        if (this.m_stderr != null) {
            String stderr = GeneralUtilities.replaceString((String)this.m_stderr, (String)"%f", (String)flowname);
            stderr = GeneralUtilities.replaceString((String)stderr, (String)"%j", (String)jobname);
            return stderr;
        }
        return this.m_stderr;
    }

    public void setStderr(String stderr) {
        this.m_stderr = stderr;
    }

    public void setScoping(boolean flag) {
        this.m_scoping = flag;
    }

    @Override
    public Object getCalendarManager() {
        try {
            JFCalendarManager calMgr = this.validateCalManager();
            return calMgr;
        }
        catch (SchedulerException se) {
            return null;
        }
    }

    private boolean makeUserConnection(SchedulerServerInfo schedulingServer) {
        return this.makeUserConnection(schedulingServer, "0");
    }

    private boolean makeUserConnection(SchedulerServerInfo schedulingServer, String timeout) {
        if (this.m_connected) {
            String chkHost = JFConfigManager.getConfig((String)"JS_HOST");
            if (chkHost.compareTo(this.m_schedulingServer.getHost()) != 0) {
                JFConfigManager.addConfig((String)"JS_HOST", (String)this.m_schedulingServer.getHost());
                JFConfigManager.addConfig((String)"JS_PORT", (String)this.m_schedulingServer.getPort());
            }
            return true;
        }
        boolean connected = false;
        String host = schedulingServer.getHost() != null ? schedulingServer.getHost() : "";
        String port = schedulingServer.getPort() != null ? schedulingServer.getPort() : "";
        boolean useGuestOnFailure = true;
        boolean loginRequired = LSFScheduler.getJSLoginRequired();
        boolean jsEncryption = LSFScheduler.getJSEncryptionRequired();
        PasswordAuthentication pa = LSFScheduler.getUserConnection(schedulingServer);
        if (pa != null) {
            try {
                String user = pa.getUserName();
                SealedString pass = pa.getPassword() != null ? new SealedString(pa.getPassword()) : null;
                LSFScheduler.__setConfig(user, pass, host, port, loginRequired, jsEncryption, timeout, this.m_timeZone, this.m_jsHome, this.m_templatedir);
                connected = LSFScheduler.__login(user, pass, useGuestOnFailure);
            }
            catch (SchedulerException ex) {
                ex.toString();
            }
            catch (ServerLoginException se) {
                se.toString();
            }
            catch (LoginException le) {
                le.toString();
            }
            catch (SecurityException e) {
                e.toString();
            }
            catch (JFException e) {
                e.toString();
            }
        } else {
            try {
                LSFScheduler.__setConfig(null, null, host, port, loginRequired, jsEncryption, "5", this.m_timeZone, this.m_jsHome, this.m_templatedir);
                JFLoginManager.login((String)"guest", (String)"");
                m_lastConnectedUser = "guest";
                connected = true;
            }
            catch (LoginException le) {
                le.toString();
            }
            catch (SchedulerException e) {
                e.printStackTrace();
                SchedulerException se = new SchedulerException(e.toString());
                se.initCause((Throwable)e);
            }
        }
        this.m_userConnected = connected;
        return connected;
    }

    public boolean calendarExists(String schedulerCalenderName) {
        try {
            JFCalendarManager calMgr = this.validateCalManager();
            return calMgr != null && calMgr.calendarExists(schedulerCalenderName);
        }
        catch (JFException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        catch (SchedulerException e) {
            return false;
        }
    }

    @Override
    public LSFCalendar getCalendar(String schedulerCalenderName) throws SchedulerException {
        JFCalendarManager calMgr = this.validateCalManager();
        if (calMgr == null) {
            return null;
        }
        LSFCalendar cal = new LSFCalendar();
        try {
            cal = cal.isValidCalendarName(schedulerCalenderName) && calMgr.calendarExists(schedulerCalenderName) ? new LSFCalendar(schedulerCalenderName, (Scheduler)this) : null;
        }
        catch (JFException e) {
            cal = null;
        }
        catch (IOException e) {
            cal = null;
        }
        return cal;
    }

    @Override
    public String getCalendarName(IRecurrenceInfo info) {
        Calendar cal = null;
        try {
            String display;
            JFCalendarManager calMgr = this.validateCalManager();
            if (calMgr == null) {
                return null;
            }
            String calName = LSFCalendar.getCalendarName(info, this);
            if (calMgr.calendarExists(calName)) {
                cal = new LSFCalendar(calName, (Scheduler)this);
            }
            if (cal == null && (cal = this.getCalendar(display = info.toString())) == null) {
                calName = LSFCalendar.makeValidName(info.toShortUniqueString());
                if (calMgr.calendarExists(calName)) {
                    cal = new LSFCalendar(calName, (Scheduler)this);
                } else {
                    String inputCalName = calName;
                    JFCalendar[] cals = calMgr.getAllCalendars();
                    if (calName.indexOf("@") >= 0) {
                        inputCalName = calName.substring(0, calName.indexOf("@"));
                    }
                    for (int i = 0; i < cals.length; ++i) {
                        String tryCalName = cals[i].getName();
                        if (!inputCalName.equals(tryCalName) || !cals[i].getDescription().equals(info.toXML())) continue;
                        cal = new LSFCalendar(cals[i]);
                        break;
                    }
                }
            }
            if (cal == null) {
                return LSFCalendar.getCalendarName(info, this);
            }
        }
        catch (JFException e) {
            cal = null;
        }
        catch (IOException e) {
            cal = null;
        }
        catch (SchedulerException e) {
            cal = null;
        }
        catch (NullPointerException e) {
            cal = null;
        }
        if (cal != null) {
            return cal.getName() + "@" + cal.getOwner();
        }
        return null;
    }

    @Override
    public Calendar getCalendar(IRecurrenceInfo info) throws SchedulerException {
        JFCalendarManager calMgr = this.validateCalManager();
        if (calMgr == null) {
            return null;
        }
        String calname = info.toString();
        LSFCalendar cal = null;
        try {
            String calName;
            cal = this.m_calendars.get(calname);
            if (cal == null) {
                cal = this.getCalendar(calname);
            }
            if (cal == null && (cal = this.m_calendars.get(calName = LSFCalendar.makeValidName(info.toShortUniqueString()))) == null) {
                if (calMgr.calendarExists(calName)) {
                    cal = new LSFCalendar(calName, (Scheduler)this);
                    calname = calName;
                } else {
                    String inputCalName = calName;
                    JFCalendar[] cals = calMgr.getAllCalendars();
                    if (calName.indexOf("@") >= 0) {
                        inputCalName = calName.substring(0, calName.indexOf("@"));
                    }
                    for (int i = 0; i < cals.length; ++i) {
                        String desc;
                        String tryCalName = cals[i].getName();
                        if (!inputCalName.equals(tryCalName) || (desc = cals[i].getDescription()) == null || !desc.equals(info.toXML())) continue;
                        cal = new LSFCalendar(cals[i]);
                        calname = calName;
                        break;
                    }
                }
            }
            if (cal == null) {
                cal = new LSFCalendar(info, (Scheduler)this);
                cal.setDays(info);
            }
        }
        catch (JFException jFException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_calendars.put(calname, cal);
        return cal;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public LSFCalendar createCalendar(String calname, String expression) throws SchedulerException {
        JFCalendarManager calMgr = this.validateCalManager();
        if (calMgr == null) {
            return null;
        }
        LSFCalendar cal = null;
        try {
            cal = new LSFCalendar(calname, expression, null);
        }
        catch (SchedulerException e) {
            cal = new LSFCalendar(expression, null, null);
        }
        if (cal == null) return cal;
        try {
            if (cal.getOwner().compareTo("Sys") == 0) {
                SchedulerException se = new SchedulerException(m_bundle.getString("LSFScheduler.Error.CannotUpdateSystemCalendars.txt"));
                throw se;
            }
            if (!calMgr.calendarExists(calname)) {
                calMgr.addCalendar(cal.getJFCalendar());
                return cal;
            }
            if (!calMgr.calendarInUse(calname)) {
                calMgr.deleteCalendar(calname);
                calMgr.addCalendar(cal.getJFCalendar());
                return cal;
            }
            SchedulerException se = new SchedulerException(m_bundle.getString("LSFScheduler.Error.CustomCalendarInUse.txt"));
            throw se;
        }
        catch (JFException jfe) {
            SchedulerException se = new SchedulerException(jfe.toString());
            se.initCause((Throwable)jfe);
            throw se;
        }
        catch (IOException e) {
            SchedulerException se = new SchedulerException(e.toString());
            se.initCause((Throwable)e);
            throw se;
        }
    }

    @Override
    public LSFCalendar createCalendar(IRecurrenceInfo info) throws SchedulerException {
        JFCalendarManager calMgr = this.validateCalManager();
        if (calMgr == null) {
            return null;
        }
        if (this.m_calMgr != null && calMgr.equals(this.m_calMgr)) {
            return new LSFCalendar(info, (Scheduler)this);
        }
        JFCalendarManager hold = this.m_calMgr;
        this.m_calMgr = calMgr;
        LSFCalendar cal = new LSFCalendar(info, (Scheduler)this);
        this.m_calMgr = hold;
        return cal;
    }

    @Override
    public List<Calendar> getCalendars() throws SchedulerException {
        JFCalendarManager calMgr = this.validateCalManager();
        if (calMgr == null) {
            return new ArrayList<Calendar>();
        }
        ArrayList<Calendar> cals = new ArrayList<Calendar>();
        try {
            JFCalendar[] lsfcals = calMgr.getAllCalendars();
            int calssize = lsfcals.length;
            for (int i = 0; i < calssize; ++i) {
                LSFCalendar cal = this.makeCalendar(lsfcals[i]);
                cals.add(cal);
            }
            return cals;
        }
        catch (JFException jfe) {
            SchedulerException ex = new SchedulerException(jfe.toString());
            throw ex;
        }
        catch (IOException ioe) {
            SchedulerException ex = new SchedulerException(ioe.getLocalizedMessage());
            throw ex;
        }
    }

    @Override
    public boolean removeCalendar(Calendar cal) throws SchedulerException {
        JFCalendarManager calMgr = this.validateCalManager();
        if (calMgr == null) {
            return false;
        }
        if (cal instanceof LSFCalendar) {
            try {
                LSFCalendar lsfcal = (LSFCalendar)cal;
                if (cal.isUserDefined()) {
                    calMgr.deleteCalendar(lsfcal.getName());
                    return true;
                }
                return false;
            }
            catch (JFException jfe) {
                SchedulerException ex = new SchedulerException(jfe.toString());
                throw ex;
            }
            catch (IOException ioe) {
                SchedulerException ex = new SchedulerException(ioe.getLocalizedMessage());
                throw ex;
            }
        }
        return false;
    }

    @Override
    public boolean addCalendar(Calendar cal) throws SchedulerException {
        if (cal instanceof LSFCalendar) {
            try {
                JFCalendarManager calMgr = this.validateCalManager();
                if (calMgr == null) {
                    return false;
                }
                calMgr.addCalendar(((LSFCalendar)cal).getJFCalendar());
                return true;
            }
            catch (JFException jfe) {
                SchedulerException ex = new SchedulerException(jfe.toString());
                throw ex;
            }
            catch (IOException ioe) {
                SchedulerException ex = new SchedulerException(ioe.getLocalizedMessage());
                throw ex;
            }
        }
        return false;
    }

    @Override
    public String getCalAdminID() {
        try {
            String admin = this.getCurrentUserID();
            JFAdminManager adminMgr = this.validateAdminManager();
            if (adminMgr == null || adminMgr.isAdmin()) {
                return null;
            }
            return admin;
        }
        catch (SchedulerException se) {
            return null;
        }
        catch (JFException jfe) {
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    @Override
    public String createConditionString(String calname, String username, String hour, String minutes, String duration) {
        return this.createConditionString(calname, username, hour, minutes, duration, null, null);
    }

    @Override
    public String createConditionString(String calname, String username, String hour, String minutes, String duration, String timezone) {
        return this.createConditionString(calname, username, hour, minutes, duration, null, timezone);
    }

    @Override
    public String createConditionString(String calname, String username, String hour, String minutes, String duration, String occur, String timezone) {
        Object[] a;
        Object[] args = new Object[]{calname, username, hour, minutes, duration};
        String condition = MessageFormat.format("{0}@{1}:{2}:{3}%{4}", args);
        if (occur != null) {
            a = new Object[]{condition, occur};
            condition = MessageFormat.format("{0}#{1}", a);
        }
        if (timezone != null) {
            a = new Object[]{condition, timezone};
            condition = MessageFormat.format("{0}+{1}", a);
        }
        return condition;
    }

    @Override
    public String getMinuteFromConditionString(String conditionString) {
        int startindex = conditionString.indexOf("@");
        if (startindex <= 0) {
            return null;
        }
        String temp = conditionString.substring(startindex);
        if ((startindex = temp.indexOf(":")) < 0) {
            return null;
        }
        if ((startindex = (temp = temp.substring(startindex + 1)).indexOf(":")) < 0) {
            return null;
        }
        int endindex = (temp = temp.substring(startindex + 1)).indexOf("%");
        if (endindex < 0) {
            endindex = temp.indexOf(":");
        }
        if (endindex < 0) {
            return null;
        }
        String minute = GeneralUtilities.replaceString((String)temp.substring(0, endindex), (String)";", (String)",");
        return minute;
    }

    @Override
    public String getDurationFromConditionString(String conditionString) {
        int startindex = conditionString.indexOf("@");
        if (startindex <= 0) {
            return null;
        }
        String duration = null;
        String temp = conditionString;
        startindex = temp.indexOf("%");
        if (startindex > 0) {
            int endindex = temp.indexOf("#");
            if (endindex < 0) {
                endindex = temp.indexOf("+");
            }
            duration = endindex < 0 ? temp.substring(startindex + 1) : temp.substring(startindex + 1, endindex);
        } else {
            startindex = temp.indexOf(":");
            if (startindex < 0) {
                return null;
            }
            if ((startindex = (temp = temp.substring(startindex + 1)).indexOf(":")) < 0) {
                return null;
            }
            if ((startindex = (temp = temp.substring(startindex + 1)).indexOf(":")) < 0) {
                return null;
            }
            int endindex = (temp = temp.substring(startindex + 1)).indexOf(":");
            duration = endindex < 0 ? temp : temp.substring(0, endindex);
        }
        return duration;
    }

    @Override
    public String getOccurrenceFromConditionString(String conditionString) {
        int startindex = conditionString.indexOf("@");
        if (startindex <= 0) {
            return null;
        }
        String occur = null;
        String temp = conditionString;
        startindex = temp.indexOf("#");
        if (startindex > 0) {
            int endindex = temp.indexOf("+");
            occur = endindex < 0 ? temp.substring(startindex + 1) : temp.substring(startindex + 1, endindex);
        }
        return occur;
    }

    @Override
    public String getTimezoneFromConditionString(String conditionString) {
        int startindex = conditionString.indexOf("@");
        if (startindex <= 0) {
            return null;
        }
        String timezone = null;
        String temp = conditionString;
        startindex = temp.indexOf("+");
        if (startindex < 0) {
            return null;
        }
        timezone = temp.substring(startindex + 1);
        return timezone;
    }

    @Override
    public String createFileConditionString(String filename, int type, int operator, long value) throws SchedulerException {
        if (filename != null) {
            JFFileEvent fe = null;
            Class<JFFileEvent> cls = JFFileEvent.class;
            Constructor con = null;
            Object[] parms = new Object[4];
            Number noValue = null;
            try {
                con = cls.getConstructor(String.class, String.class, String.class, Long.TYPE);
                parms[0] = filename;
                parms[3] = new Long(value);
                noValue = new Long(-1L);
            }
            catch (NoSuchMethodException nsme) {
                try {
                    con = cls.getConstructor(String.class, String.class, String.class, Integer.TYPE);
                    parms[0] = filename;
                    int ivalue = Integer.parseInt(String.valueOf(value));
                    parms[3] = new Integer(ivalue);
                    noValue = new Integer(-1);
                }
                catch (NoSuchMethodException ex) {
                    SchedulerException se = new SchedulerException();
                    se.initCause((Throwable)ex);
                    throw se;
                }
            }
            try {
                block3 : switch (type) {
                    case 0: {
                        parms[1] = "exist";
                        parms[2] = value == 1L ? null : "!";
                        parms[3] = noValue;
                        break;
                    }
                    case 1: {
                        parms[1] = "size";
                        switch (operator) {
                            case 21: {
                                parms[2] = "==";
                                break;
                            }
                            case 23: {
                                parms[2] = ">";
                                break;
                            }
                            case 24: {
                                parms[2] = ">=";
                                break;
                            }
                            case 25: {
                                parms[2] = "<";
                                break;
                            }
                            case 26: {
                                parms[2] = "<=";
                                break;
                            }
                            case 22: {
                                parms[2] = "!=";
                            }
                        }
                        break;
                    }
                    case 2: {
                        parms[1] = "arrival";
                        parms[2] = null;
                        parms[3] = noValue;
                        break;
                    }
                    case 3: {
                        parms[1] = "age";
                        switch (operator) {
                            case 21: {
                                parms[2] = "==";
                                break block3;
                            }
                            case 23: {
                                parms[2] = ">";
                                break block3;
                            }
                            case 24: {
                                parms[2] = ">=";
                                break block3;
                            }
                            case 25: {
                                parms[2] = "<";
                                break block3;
                            }
                            case 26: {
                                parms[2] = "<=";
                                break block3;
                            }
                            case 22: {
                                parms[2] = "!=";
                            }
                        }
                    }
                }
                fe = (JFFileEvent)con.newInstance(parms);
                if (fe != null) {
                    return fe.generateDefinition();
                }
            }
            catch (InvocationTargetException ie) {
                return null;
            }
            catch (IllegalAccessException ie) {
                return null;
            }
            catch (InstantiationException ie) {
                return null;
            }
            catch (RuntimeException ex) {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getFileNameFromConditionString(String conditionString) {
        try {
            return conditionString.substring(conditionString.indexOf(40) + 1, conditionString.indexOf(41));
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    @Override
    public int getFileTypeFromConditionString(String conditionString) {
        try {
            String type = conditionString.substring(0, conditionString.indexOf(32));
            if (type.compareTo("age") == 0) {
                return 3;
            }
            if (type.compareTo("arrival") == 0) {
                return 2;
            }
            if (type.compareTo("exist") == 0) {
                return 0;
            }
            if (type.compareTo("size") == 0) {
                return 1;
            }
            if (type.compareTo("!") == 0) {
                type = conditionString.substring(conditionString.indexOf("!") + 2);
                if ((type = type.substring(0, type.indexOf(32))).compareTo("age") == 0) {
                    return 3;
                }
                if (type.compareTo("arrival") == 0) {
                    return 2;
                }
                if (type.compareTo("exist") == 0) {
                    return 0;
                }
                if (type.compareTo("size") == 0) {
                    return 1;
                }
                return -1;
            }
            return -1;
        }
        catch (RuntimeException ex) {
            return -1;
        }
    }

    @Override
    public int getFileOperatorFromConditionString(String conditionString) {
        try {
            if (conditionString.indexOf("==") > 0) {
                return 21;
            }
            if (conditionString.indexOf(">=") > 0) {
                return 24;
            }
            if (conditionString.indexOf(">") > 0) {
                return 23;
            }
            if (conditionString.indexOf("<=") > 0) {
                return 26;
            }
            if (conditionString.indexOf("<") > 0) {
                return 25;
            }
            if (conditionString.indexOf("!=") > 0) {
                return 22;
            }
            if (conditionString.indexOf("!") >= 0) {
                return 27;
            }
            return -1;
        }
        catch (RuntimeException ex) {
            return -1;
        }
    }

    @Override
    public long getFileValueFromConditionString(String conditionString) {
        try {
            String value = null;
            int index = -1;
            index = conditionString.indexOf("==");
            if (index > 0) {
                value = conditionString.substring(index + 2);
            } else {
                index = conditionString.indexOf(">");
                if (index > 0) {
                    value = conditionString.substring(index + 2);
                } else {
                    index = conditionString.indexOf(">=");
                    if (index > 0) {
                        value = conditionString.substring(index + 2);
                    } else {
                        index = conditionString.indexOf("<");
                        if (index > 0) {
                            value = conditionString.substring(index + 2);
                        } else {
                            index = conditionString.indexOf("<=");
                            if (index > 0) {
                                value = conditionString.substring(index + 2);
                            } else {
                                index = conditionString.indexOf("!=");
                                if (index > 0) {
                                    value = conditionString.substring(index + 2);
                                } else {
                                    switch (this.getFileTypeFromConditionString(conditionString)) {
                                        case 0: {
                                            if (conditionString.indexOf("!") >= 0) {
                                                return 0L;
                                            }
                                            return 1L;
                                        }
                                    }
                                    return 0L;
                                }
                            }
                        }
                    }
                }
            }
            value = this.stripLeadingSpaces(value);
            return Integer.parseInt(value);
        }
        catch (RuntimeException ex) {
            return 0L;
        }
    }

    private String stripLeadingSpaces(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return str.substring(i);
        }
        return str;
    }

    @Override
    public String getClassId() {
        return "a1661499-5d7d-4fcc-8fc3-c6509853e116";
    }

    @Override
    public int rescheduleFlow(FlowInfo flow, boolean errorOnDelete) throws SchedulerException, UnsupportedOperationException {
        int rc = 1;
        int major = this.getMajorVersion();
        if (major < 8) {
            try {
                if (!this.removeFlow(flow)) {
                    rc = 1;
                }
            }
            catch (UnsupportedOperationException ex) {
                if (this.scheduleFlow(flow)) {
                    throw ex;
                }
                return 2;
            }
            catch (SchedulerException ex) {
                if (errorOnDelete) {
                    throw ex;
                }
                rc = 1;
            }
            if (errorOnDelete && rc == 1) {
                return rc;
            }
            if (!this.scheduleFlow(flow)) {
                rc = 2;
            }
            if (rc == 0) {
                flow.setScheduledUserIdDataBinding(this.m_schedulingServer.getUsername());
            }
        } else if (this._scheduleFlow(flow, true)) {
            flow.setScheduledUserIdDataBinding(this.m_schedulingServer.getUsername());
            rc = 0;
        } else {
            rc = 2;
        }
        return rc;
    }

    @Override
    public boolean scheduleFlow(FlowInfo flow) throws SchedulerException {
        return this._scheduleFlow(flow, false);
    }

    /*
     * Exception decompiling
     */
    private boolean _scheduleFlow(FlowInfo flow, boolean reschedule) throws SchedulerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean setFlowAttributes(JFFlow jfFlow, FlowInfo flow) throws SchedulerException {
        if (flow.hasAdvanceCompletion()) {
            this.setFlowComplete(jfFlow, flow.completionLevel(), flow.completionSelectedJobs());
        } else {
            jfFlow.removeExitCondition();
        }
        try {
            int afterstate = flow.getEndBehaviorDataBinding();
            switch (afterstate) {
                case 2: {
                    jfFlow.setAttribute("EndBehaviour", "FlowContinue");
                    break;
                }
                case 3: {
                    jfFlow.setAttribute("EndBehaviour", "FlowContinueDelay");
                    break;
                }
                default: {
                    jfFlow.setAttribute("EndBehaviour", "FlowStop");
                    break;
                }
            }
        }
        catch (NullPointerException npe) {
            jfFlow.setAttribute("EndBehaviour", "FlowStop");
        }
        try {
            int exitcode = flow.getExitcodeBehaviorDataBinding();
            switch (exitcode) {
                case 1: {
                    jfFlow.setAttribute("ExitCodeRule", "FromLastItem");
                    break;
                }
                default: {
                    jfFlow.setAttribute("ExitCodeRule", "FromSumOfItems");
                    break;
                }
            }
        }
        catch (NullPointerException npe) {
            jfFlow.setAttribute("ExitCodeRule", "FromSumOfItems");
        }
        if (flow.isNotifyEmail()) {
            switch (flow.emailNotificationLevel()) {
                case 0: {
                    jfFlow.setAttribute("FlowStateMailWhen", "Start");
                    break;
                }
                case 1: {
                    jfFlow.setAttribute("FlowStateMailWhen", "StartEnd");
                    break;
                }
                case 2: {
                    jfFlow.setAttribute("FlowStateMailWhen", "StartExit");
                    break;
                }
                case 3: {
                    jfFlow.setAttribute("FlowStateMailWhen", "Exit");
                    break;
                }
                case 4: {
                    jfFlow.setAttribute("FlowStateMailWhen", "End");
                }
            }
            jfFlow.setAttribute("MailDestination", flow.emailAddress());
        } else {
            jfFlow.setAttribute("FlowStateMailWhen", "None");
        }
        if (flow.hasExclusive()) {
            jfFlow.setAttribute("Exclusive", "Yes");
        } else {
            jfFlow.setAttribute("Exclusive", "No");
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean scheduleFlowNow(FlowInfo flow) throws SchedulerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static long submitRerunableBatchJobNow(String name, String cmdline, String host, String port, String user, SealedString pass) throws SchedulerException, LoginException, JFException, IOException {
        SealedString passwd = pass != null ? new SealedString(pass.getCharacters()) : null;
        boolean jsEncryption = LSFScheduler.getJSEncryptionRequired();
        LSFScheduler.__setConfig(user, passwd, host, port, false, jsEncryption, "0", null, null, null);
        LSFScheduler.__login(user, passwd, false);
        JFFlow flow = new JFFlow(user + ":" + name);
        JFJob object = new JFJob(name);
        object.setAttribute("JobCmdLine", cmdline);
        object.setAttribute("Rerunable", "Yes");
        flow.addJob(object);
        String SAS_ID = "SAS_JobScheduler_ID";
        JFFlowDefinitionManager flowDefManager = new JFFlowDefinitionManager();
        long id = flowDefManager.submitAndRunFlow(flow, null, "SAS_JobScheduler_ID");
        return id;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean removeFlow(FlowInfo flow, String triggerType) throws SchedulerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeFlow(String flowName) throws SchedulerException {
        try {
            _userLock.lock();
            if (!this.testConnection()) {
                boolean bl = false;
                return bl;
            }
            this.m_flowDefManager.removeFlow(flowName);
            boolean bl = true;
            return bl;
        }
        finally {
            _userLock.unlock();
        }
    }

    private boolean flowExists(String name) {
        try {
            JFFlowDefinitionManager flowDefManager = this.validateFlowDefinitionManager();
            if (flowDefManager == null) {
                return false;
            }
            JFFlow jfflow = flowDefManager.getFlow(name);
            return jfflow != null;
        }
        catch (JFException ex) {
            return false;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return true;
        }
        catch (SchedulerException ex) {
            ex.printStackTrace();
            return true;
        }
    }

    @Override
    public boolean killFlowInstance(FlowHistory flowInstance) throws SchedulerException {
        if (this.m_flowMgr == null) {
            return false;
        }
        if (flowInstance instanceof LSFFlowHistory) {
            try {
                this.m_flowMgr.killInstance(flowInstance.getID());
            }
            catch (JFException jfe) {
                throw new SchedulerException(jfe.toString());
            }
            catch (IOException ioe) {
                throw new SchedulerException(ioe.toString());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean pauseFlowInstance(FlowHistory flowInstance) throws SchedulerException {
        if (this.m_flowMgr == null) {
            return false;
        }
        if (flowInstance instanceof LSFFlowHistory) {
            try {
                this.m_flowMgr.suspendInstance(flowInstance.getID());
            }
            catch (JFException jfe) {
                throw new SchedulerException(jfe.toString());
            }
            catch (IOException ioe) {
                throw new SchedulerException(ioe.toString());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean resumeFlowInstance(FlowHistory flowInstance) throws SchedulerException {
        if (this.m_flowMgr == null) {
            return false;
        }
        if (flowInstance instanceof LSFFlowHistory) {
            try {
                this.m_flowMgr.resumeInstance(flowInstance.getID());
            }
            catch (JFException jfe) {
                throw new SchedulerException(jfe.toString());
            }
            catch (IOException ioe) {
                throw new SchedulerException(ioe.toString());
            }
            return true;
        }
        return false;
    }

    public JFHandler[] getFlowHandlers(String xml) {
        try {
            JFFlowDefinitionManager flowDefManager = this.validateFlowDefinitionManager();
            if (flowDefManager == null) {
                return null;
            }
            Document doc = GeneralUtilities.parseXML((String)xml);
            Node node = doc.getElementsByTagName("JFHandlers").item(0);
            NodeList cnodes = node.getChildNodes();
            int numCNodes = cnodes.getLength();
            JFHandler[] handlers = new JFHandler[numCNodes];
            int index = 0;
            for (int x = 0; x < numCNodes; ++x) {
                Node cnode = cnodes.item(x);
                String tagname = cnode.getNodeName();
                if (tagname.compareTo("JFHandler") != 0) continue;
                NamedNodeMap map = node.getAttributes();
                int action = Integer.parseInt(map.getNamedItem("Action").getNodeValue());
                int delay = Integer.parseInt(map.getNamedItem("Delay").getNodeValue());
                int numberRerun = Integer.parseInt(map.getNamedItem("NumberRerun").getNodeValue());
                String eventXML = map.getNamedItem("Event").getNodeValue();
                JFFlowEvent event = new JFFlowEvent();
                event.initFromDefinition(eventXML);
                JFHandler handler = new JFHandler();
                handler.setAction(action);
                handler.setDelay(delay);
                handler.setNumberRerun(numberRerun);
                handler.setEvent((JFEvent)event);
                handlers[index++] = handler;
            }
            return handlers;
        }
        catch (JFException ex) {
            if (this.isDebug()) {
                ex.printStackTrace();
            }
            return null;
        }
        catch (SchedulerException ex) {
            if (this.isDebug()) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public String genFlowHandlersXML(JFHandler[] handlers) {
        return "";
    }

    @Override
    public long getFlowInstance(FlowInfo flow) throws SchedulerException {
        if (!this.m_connected) {
            SchedulerException ex = new SchedulerException(m_bundle.getString("LSFScheduler.UnableToConnectToScheduler.txt"));
            throw ex;
        }
        long flowID = -2L;
        try {
            JFFilter userFilter = new JFFilter();
            userFilter.setUser(this.m_schedulingServer.getUsername());
            JFPseudoFlowInstance[] instances = this.m_flowMgr.getPseudoInstances(userFilter);
            int numInstances = instances.length;
            String flowname = this.genNormalizedFlowName(userFilter.getUser(), flow);
            for (int i = 0; i < numInstances; ++i) {
                long id;
                String fname = instances[i].getFlowName();
                if (!fname.equalsIgnoreCase(flowname) || (id = instances[i].getInstanceId()) <= flowID) continue;
                flowID = id;
            }
        }
        catch (JFException jfe) {
            SchedulerException ex = new SchedulerException(jfe.toString());
            throw ex;
        }
        catch (IOException ioe) {
            SchedulerException ex = new SchedulerException(ioe.getLocalizedMessage());
            throw ex;
        }
        return flowID;
    }

    @Override
    public int getMaxFlowHistoryCount() throws SchedulerException {
        String policy = JFConfigManager.getConfig((String)"JS_IM_ACTIVEPOLICY");
        if (policy.compareToIgnoreCase("JF_IM_IPolicy") == 0) {
            String countStr = JFConfigManager.getConfig((String)"JS_IM_POLICY_NOOFFLOWS");
            return Integer.valueOf(countStr);
        }
        return 5;
    }

    @Override
    public List<FlowHistory> getAllFlowHistory() throws SchedulerException {
        JFFlowManager flowMgr = this.validateFlowManager();
        return LSFScheduler.getFlowHistoryList(flowMgr, null, null, 0, false);
    }

    @Override
    public List<FlowHistory> getFlowHistoryList(FlowInfo flow) throws SchedulerException {
        return this.getFlowHistoryList(flow, 0);
    }

    @Override
    public FlowHistory getFlowHistory(FlowInfo flow) throws SchedulerException {
        try {
            if (!this.m_connected) {
                SchedulerException ex = new SchedulerException(m_bundle.getString("LSFScheduler.UnableToConnectToScheduler.txt"));
                throw ex;
            }
            String user = this.m_schedulingServer.getUsername();
            HashSet<String> flowNames = new HashSet<String>();
            String flowname = this.genNormalizedFlowName(user, flow);
            flowNames.add(flowname);
            JFFlowManager flowMgr = this.validateFlowManager();
            List<FlowHistory> list = LSFScheduler.getFlowHistoryList(flowMgr, user, flowNames, 1, true);
            if (list.size() > 0) {
                return (LSFFlowHistory)list.get(0);
            }
            return null;
        }
        catch (RuntimeException ioe) {
            SchedulerException ex = new SchedulerException(ioe.getLocalizedMessage());
            throw ex;
        }
    }

    @Override
    public List<FlowHistory> getFlowHistoryList(FlowInfo flow, int count) throws SchedulerException {
        try {
            if (!this.m_connected) {
                SchedulerException ex = new SchedulerException(m_bundle.getString("LSFScheduler.UnableToConnectToScheduler.txt"));
                throw ex;
            }
            String user = this.m_schedulingServer.getUsername();
            HashSet<String> flowNames = new HashSet<String>();
            String flowname = this.genNormalizedFlowName(user, flow);
            flowNames.add(flowname);
            JFFlowManager flowMgr = this.validateFlowManager();
            return LSFScheduler.getFlowHistoryList(flowMgr, user, flowNames, count, false);
        }
        catch (RuntimeException ioe) {
            SchedulerException ex = new SchedulerException(ioe.getLocalizedMessage());
            throw ex;
        }
    }

    @Override
    public List<FlowHistory> getFlowHistoryList(String userid, int count) throws SchedulerException {
        JFFlowManager flowMgr = this.validateFlowManager();
        return LSFScheduler.getFlowHistoryList(flowMgr, userid, null, count, false);
    }

    @Override
    public List<FlowHistory> getFlowHistoryList(String userid, List<FlowInfo> flowList, int count) throws SchedulerException {
        HashSet<String> flowNames = new HashSet<String>();
        Iterator<FlowInfo> flowListI = flowList.iterator();
        try {
            while (flowListI.hasNext()) {
                FlowInfo flow = flowListI.next();
                String flowname = this.genNormalizedFlowName(userid, flow);
                flowNames.add(flowname);
            }
            JFFlowManager flowMgr = this.validateFlowManager();
            return LSFScheduler.getFlowHistoryList(flowMgr, userid, flowNames, count, false);
        }
        catch (RuntimeException re) {
            SchedulerException ex = new SchedulerException(re.getLocalizedMessage());
            throw ex;
        }
    }

    @Override
    public Date getFinishTime(long id) throws SchedulerException {
        try {
            JFFlowManager flowMgr = this.validateFlowManager();
            if (flowMgr == null) {
                return null;
            }
            if (id >= 0L) {
                return flowMgr.getInstance(id).getFinishTime();
            }
            return null;
        }
        catch (JFException jfe) {
            SchedulerException ex = new SchedulerException(jfe.toString());
            throw ex;
        }
        catch (IOException ioe) {
            SchedulerException ex = new SchedulerException(ioe.getLocalizedMessage());
            throw ex;
        }
        catch (NullPointerException npe) {
            SchedulerException ex = new SchedulerException(npe.toString());
            throw ex;
        }
    }

    @Override
    public Date getStartTime(long id) throws SchedulerException {
        try {
            JFFlowManager flowMgr = this.validateFlowManager();
            if (flowMgr == null) {
                return null;
            }
            if (id >= 0L) {
                return flowMgr.getInstance(id).getStartTime();
            }
            return null;
        }
        catch (JFException jfe) {
            SchedulerException ex = new SchedulerException(jfe.toString());
            throw ex;
        }
        catch (IOException ioe) {
            SchedulerException ex = new SchedulerException(ioe.getLocalizedMessage());
            throw ex;
        }
    }

    @Override
    public int getState(long id) throws SchedulerException {
        try {
            JFFlowManager flowMgr = this.validateFlowManager();
            if (flowMgr == null) {
                return -1;
            }
            if (id >= 0L) {
                int state = flowMgr.getInstance(id).getState();
                switch (state) {
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        return 1;
                    }
                    case 4: {
                        return 2;
                    }
                    case 1: {
                        return 3;
                    }
                    case 5: {
                        return 4;
                    }
                    case 0: {
                        return 5;
                    }
                }
                return -1;
            }
            return -1;
        }
        catch (JFException jfe) {
            SchedulerException ex = new SchedulerException(jfe.toString());
            throw ex;
        }
        catch (IOException ioe) {
            SchedulerException ex = new SchedulerException(ioe.getLocalizedMessage());
            throw ex;
        }
    }

    @Override
    public int getStatus(long id) throws SchedulerException {
        try {
            JFFlowManager flowMgr = this.validateFlowManager();
            if (flowMgr == null) {
                return -1;
            }
            if (id >= 0L) {
                return flowMgr.getInstance(id).getStatus();
            }
            SchedulerException ex = new SchedulerException(m_bundle.getString("LSFScheduler.NoInstance.txt"), LSFScheduler.class, "LSFScheduler.NoInstance.txt", null);
            throw ex;
        }
        catch (JFException jfe) {
            SchedulerException ex = new SchedulerException(jfe.toString());
            throw ex;
        }
        catch (IOException ioe) {
            SchedulerException ex = new SchedulerException(ioe.getLocalizedMessage());
            throw ex;
        }
    }

    @Override
    public boolean closeConnection() {
        super.closeConnection();
        m_lastConnectedUser = "";
        this.m_flowDefManager = null;
        this.m_calMgr = null;
        this.m_flowMgr = null;
        this.m_adminMgr = null;
        return true;
    }

    public String getConnectedUser() {
        return m_lastConnectedUser;
    }

    @Override
    public boolean isConnected() {
        String chkHost = JFConfigManager.getConfig((String)"JS_HOST");
        if (chkHost != null && chkHost.compareTo(this.m_schedulingServer.getHost()) != 0) {
            JFConfigManager.addConfig((String)"JS_HOST", (String)this.m_schedulingServer.getHost());
            JFConfigManager.addConfig((String)"JS_PORT", (String)this.m_schedulingServer.getPort());
        }
        return this.m_connected;
    }

    @Override
    public String getCurrentUserID() {
        return this.m_schedulingServer.getUsername();
    }

    @Override
    public boolean isFlowScheduled(String id) {
        try {
            JFFlowDefinitionManager flowDefManager = this.validateFlowDefinitionManager();
            if (flowDefManager == null) {
                return false;
            }
            flowDefManager.getFlow(id);
            return true;
        }
        catch (NoSuchFieldError nsfe) {
            return false;
        }
        catch (JFException jfe) {
            return false;
        }
        catch (IOException ioe) {
            return false;
        }
        catch (SchedulerException se) {
            return false;
        }
    }

    @Override
    public boolean isFlowScheduled(FlowInfo flow) {
        try {
            JFFlowDefinitionManager flowDefManager = this.validateFlowDefinitionManager();
            String flowname = this.genNormalizedFlowName(flow);
            flowDefManager.getFlow(flowname);
            return true;
        }
        catch (NoSuchFieldError nsfe) {
            try {
                return flow.isFlowSubmitted();
            }
            catch (Exception mde) {
                return false;
            }
        }
        catch (Exception ex) {
            try {
                return flow.isFlowSubmitted();
            }
            catch (Exception mde) {
                return false;
            }
        }
    }

    @Override
    public boolean verifyFlowScheduled(FlowInfo flow) throws SchedulerException {
        try {
            JFFlowDefinitionManager flowDefManager = this.validateFlowDefinitionManager();
            String flowname = this.genNormalizedFlowName(flow);
            flowDefManager.getFlow(flowname);
            return true;
        }
        catch (NoSuchFieldError nsfe) {
            throw new SchedulerException(nsfe.toString());
        }
        catch (Exception ex) {
            throw new SchedulerException(ex.toString());
        }
    }

    @Override
    public String getName() throws SchedulerException {
        if (this.m_schedulingServer != null) {
            return this.m_schedulingServer.getName();
        }
        return m_bundle.getString("LSFScheduler.GeneralName.txt");
    }

    @Override
    public String getHost() {
        return this.m_schedulingServer.getHost();
    }

    private static char Latin1_HighASCIITo7BitASCII(int ch) {
        int c = ch - 128;
        try {
            return cLatin1_HighASCIITo7BitASCII.charAt(c);
        }
        catch (RuntimeException ex) {
            return SUBCHAR;
        }
    }

    @Override
    public String makeValidFlowname(String nameStr) {
        int major = this.getMajorVersion();
        int minor = this.getMinorVersion();
        if (major == 3 && minor == 0) {
            int slen = nameStr.length();
            for (int i = 0; i < slen; ++i) {
                char c = nameStr.charAt(i);
                if (c > '\u007f') {
                    if (c < '\u0100') {
                        nameStr = nameStr.replace(c, LSFScheduler.Latin1_HighASCIITo7BitASCII(c));
                        continue;
                    }
                    nameStr = nameStr.replace(c, this.getSubstitutionChar());
                    continue;
                }
                if (INVALIDFLOWNAMECHARACTERS.indexOf(c) == -1) continue;
                nameStr = nameStr.replace(c, this.getSubstitutionChar());
            }
            return nameStr;
        }
        return JFUtility.makeValidJobFlowIdentity((String)nameStr, (char)this.getSubstitutionChar());
    }

    public static boolean isValidFlowName2(String name) {
        return JFUtility.isValidJobFlowIdentity((String)name);
    }

    @Override
    public boolean isValidFlowName(String name) {
        return JFUtility.isValidJobFlowIdentity((String)name);
    }

    @Override
    public boolean isValidJobName(String name) {
        return LSFJob.isValidName(name);
    }

    @Override
    public String getInvalidChars(boolean flow) {
        if (flow) {
            return " ][:;)(#$/";
        }
        return LSFJob.getInValidChars();
    }

    @Override
    public boolean areQueues() {
        return true;
    }

    @Override
    public List<String> getQueues() {
        try {
            JFAdminManager adminMgr = this.validateAdminManager();
            if (adminMgr == null) {
                return null;
            }
            Vector<String> list = null;
            String[] tmpqueues = adminMgr.getQueues();
            int numqueues = tmpqueues.length + 1;
            if (numqueues > 0) {
                list = new Vector<String>();
                list.add(0, LSFJob.UseDefaultQueue);
                for (int i = 1; i < numqueues; ++i) {
                    list.add(i, tmpqueues[i - 1]);
                }
            }
            return list;
        }
        catch (IOException ioe) {
            return null;
        }
        catch (NullPointerException npe) {
            return null;
        }
        catch (JFException jfe) {
            return null;
        }
        catch (SchedulerException se) {
            return null;
        }
    }

    @Override
    public String genResourceSyntax(String resource) {
        return LSFJob.genResourceSyntax(resource);
    }

    @Override
    public boolean isHistorySupported() {
        return true;
    }

    @Override
    public boolean isJobDependenciesEnabled() {
        return true;
    }

    private boolean pre10version() {
        block4: {
            try {
                JFVersion version = JFConfigManager.getServerVersion((boolean)true);
                int value = version.compareTo("10.1");
                return value < 0;
            }
            catch (JFException e) {
                if (this.isDebug()) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                if (!this.isDebug()) break block4;
                e.printStackTrace();
            }
        }
        return true;
    }

    @Override
    public boolean checkVersion(SchedulerIMPL schedulingServer) throws SchedulerException {
        boolean update = false;
        try {
            String prodname = this.getProductName();
            int major = this.getMajorVersion();
            int minor = this.getMinorVersion();
            String softver = this.getSoftwareVersion();
            String host = this.m_schedulingServer.getHost();
            String port = this.m_schedulingServer.getPort();
            String user = this.m_schedulingServer.getUsername();
            SealedString passwd = this.getSchServerInfoPasswordSealedString();
            boolean loginReq = true;
            boolean jsEncryption = LSFScheduler.getJSEncryptionRequired();
            LSFScheduler.__setConfig(user, passwd, host, port, loginReq, jsEncryption, "5", null, null, null);
            boolean useGuestOnFailure = true;
            LSFScheduler.__login(user, passwd, useGuestOnFailure);
            JFVersion version = JFConfigManager.getServerVersion((boolean)true);
            if (version.compareTo("10.13") == 0) {
                if (prodname.compareTo(PRODUCTNAME) != 0) {
                    update = true;
                    schedulingServer.setProductName(PRODUCTNAME);
                }
                if (major != 10) {
                    update = true;
                    schedulingServer.setMajorVersion(10);
                }
                if (minor != 2) {
                    update = true;
                    schedulingServer.setMinorVersion(2);
                }
                if (softver.compareToIgnoreCase("10.2") != 0) {
                    update = true;
                    schedulingServer.setSoftwareVersion("10.2");
                }
            }
            if (version.compareTo("10.12") == 0) {
                if (prodname.compareTo(PRODUCTNAME) != 0) {
                    update = true;
                    schedulingServer.setProductName(PRODUCTNAME);
                }
                if (major != 10) {
                    update = true;
                    schedulingServer.setMajorVersion(10);
                }
                if (minor != 1) {
                    update = true;
                    schedulingServer.setMinorVersion(1);
                }
                if (softver.compareToIgnoreCase("10.1") != 0) {
                    update = true;
                    schedulingServer.setSoftwareVersion("10.1");
                }
            } else if (version.compareTo("9.13") == 0) {
                if (prodname.compareTo(PRODUCTNAME) != 0) {
                    update = true;
                    schedulingServer.setProductName(PRODUCTNAME);
                }
                if (major != 9) {
                    update = true;
                    schedulingServer.setMajorVersion(9);
                }
                if (minor != 13) {
                    update = true;
                    schedulingServer.setMinorVersion(13);
                }
                if (softver.compareToIgnoreCase("9.13") != 0) {
                    update = true;
                    schedulingServer.setSoftwareVersion("9.13");
                }
            } else if (version.compareTo("9.1") == 0) {
                if (prodname.compareTo(PRODUCTNAME) != 0) {
                    update = true;
                    schedulingServer.setProductName(PRODUCTNAME);
                }
                if (major != 9) {
                    update = true;
                    schedulingServer.setMajorVersion(9);
                }
                if (minor != 1) {
                    update = true;
                    schedulingServer.setMinorVersion(1);
                }
                if (softver.compareToIgnoreCase("9.1") != 0) {
                    update = true;
                    schedulingServer.setSoftwareVersion("9.1");
                }
            } else if (version.compareTo("8.31") == 0) {
                if (prodname.compareTo(PRODUCTNAME) != 0) {
                    update = true;
                    schedulingServer.setProductName(PRODUCTNAME);
                }
                if (major != 8) {
                    update = true;
                    schedulingServer.setMajorVersion(8);
                }
                if (minor != 2) {
                    update = true;
                    schedulingServer.setMinorVersion(2);
                }
                if (softver.compareToIgnoreCase("8.2") != 0) {
                    update = true;
                    schedulingServer.setSoftwareVersion("8.2");
                }
            } else if (version.compareTo("8.1") == 0) {
                if (prodname.compareTo(PRODUCTNAME) != 0) {
                    update = true;
                    schedulingServer.setProductName(PRODUCTNAME);
                }
                if (major != 8) {
                    update = true;
                    schedulingServer.setMajorVersion(8);
                }
                if (minor != 1) {
                    update = true;
                    schedulingServer.setMinorVersion(1);
                }
                if (softver.compareToIgnoreCase("8.1") != 0) {
                    update = true;
                    schedulingServer.setSoftwareVersion("8.1");
                }
            } else if (version.compareTo("7.1") == 0) {
                if (prodname.compareTo(PRODUCTNAME) != 0) {
                    update = true;
                    schedulingServer.setProductName(PRODUCTNAME);
                }
                if (major != 7) {
                    update = true;
                    schedulingServer.setMajorVersion(7);
                }
                if (minor != 1) {
                    update = true;
                    schedulingServer.setMinorVersion(1);
                }
                if (softver.compareToIgnoreCase("7.1") != 0) {
                    update = true;
                    schedulingServer.setSoftwareVersion("7.1");
                }
            } else if (version.compareTo("6.2") == 0) {
                if (prodname.compareTo(PRODUCTNAME) != 0) {
                    update = true;
                    schedulingServer.setProductName(PRODUCTNAME);
                }
                if (major != 7) {
                    update = true;
                    schedulingServer.setMajorVersion(7);
                }
                if (minor != 0) {
                    update = true;
                    schedulingServer.setMinorVersion(0);
                }
                if (softver.compareToIgnoreCase("7.0") != 0) {
                    update = true;
                    schedulingServer.setSoftwareVersion("7.0");
                }
            } else if (version.compareTo("6.1") == 0) {
                if (prodname.compareTo(PRODUCTNAME) != 0) {
                    update = true;
                    schedulingServer.setProductName(PRODUCTNAME);
                }
                if (major != 3) {
                    update = true;
                    schedulingServer.setMajorVersion(3);
                }
                if (minor != 1) {
                    update = true;
                    schedulingServer.setMinorVersion(1);
                }
                if (softver.compareToIgnoreCase("3.1") != 0) {
                    update = true;
                    schedulingServer.setSoftwareVersion("3.1");
                }
            } else if (version.compareTo("6.0") == 0) {
                if (prodname.compareTo(PRODUCTNAME) != 0) {
                    update = true;
                    schedulingServer.setProductName(PRODUCTNAME);
                }
                if (major != 3) {
                    update = true;
                    schedulingServer.setMajorVersion(3);
                }
                if (minor != 0) {
                    update = true;
                    schedulingServer.setMinorVersion(0);
                }
                if (softver.compareToIgnoreCase("3.0") != 0) {
                    update = true;
                    schedulingServer.setSoftwareVersion("3.0");
                }
            }
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (JFException ex) {
            ex.printStackTrace();
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (LoginException ex) {
            ex.printStackTrace();
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
        return update;
    }

    @Override
    public boolean isConnectionNeededForTimeEvents() {
        try {
            int major = this.getMajorVersion();
            int minor = this.getMinorVersion();
            return major == 3 && minor == 0;
        }
        catch (NullPointerException npe) {
            return false;
        }
    }

    private boolean isOccurrenceSupported() {
        int major = this.getMajorVersion();
        int minor = this.getMinorVersion();
        return major == 7 && minor >= 1 || major > 7;
    }

    private boolean isTimezoneSupported() {
        int major = this.getMajorVersion();
        int minor = this.getMinorVersion();
        return LSFScheduler.isTimezoneSupported(major, minor);
    }

    public static boolean isTimezoneSupported(int major, int minor) {
        return major == 7 && minor >= 1 || major > 7;
    }

    @Override
    public boolean isConnectionNeededForAdvanceProperties() {
        return true;
    }

    @Override
    public boolean isTimeDependenciesEnabled() {
        return true;
    }

    @Override
    public boolean isFileDependenciesEnabled() {
        return true;
    }

    @Override
    protected boolean __maketheconnection() throws SchedulerException {
        boolean connected = false;
        boolean useGuest = false;
        SchedulerException ex = null;
        InvalidParameterException ipe = null;
        String userid = null;
        SealedString password = null;
        String host = this.m_schedulingServer.getHost() != null ? this.m_schedulingServer.getHost() : "";
        String port = this.m_schedulingServer.getPort() != null ? this.m_schedulingServer.getPort() : "";
        boolean jsEncryption = LSFScheduler.getJSEncryptionRequired();
        boolean loginReq = LSFScheduler.getJSLoginRequired();
        try {
            if (!loginReq) {
                LSFScheduler.__setConfig(userid, password, host, port, loginReq, jsEncryption, "0", this.m_timeZone, this.m_jsHome, this.m_templatedir);
                String dir = LSFScheduler.getEAUTHLocation();
                if (dir != null) {
                    System.setProperty("JS_ENVDIR", dir);
                    System.setProperty("JS_SERVERDIR", dir);
                }
                JFLoginManager.login((boolean)true);
                userid = JFLoginManager.getUserName();
                this.m_schedulingServer.setUsername(userid);
                this.m_schedulingServer.setPassword(null);
                this.m_adminMgr = new JFAdminManager();
                JFJIDInfo jid = this.m_adminMgr.getJIDInfo();
                if (this.pre10version()) {
                    JFLoginManager.logout();
                    ipe = new InvalidParameterException(MessageFormat.format(m_bundle.getString("LSFScheduler.Error.Version.fmt"), "(JS_LOGIN_REQUIRED=false)"));
                    connected = false;
                } else {
                    connected = true;
                }
            } else {
                userid = this.m_schedulingServer.getUsername();
                password = this.getSchServerInfoPasswordSealedString();
                if (userid != null && userid.length() != 0) {
                    LSFScheduler.__setConfig(userid, password, host, port, loginReq, jsEncryption, "0", this.m_timeZone, this.m_jsHome, this.m_templatedir);
                    connected = LSFScheduler.__login(userid, password, useGuest);
                    if (connected) {
                        this.m_adminMgr = new JFAdminManager();
                    }
                }
            }
            if (connected) {
                this.m_userConnected = false;
                m_lastConnectedUser = userid;
                this.m_flowDefManager = new JFFlowDefinitionManager();
                this.m_calMgr = new JFCalendarManager();
                this.m_flowMgr = new JFFlowManager();
            }
        }
        catch (ServerLoginException se) {
            ipe = new InvalidParameterException(MessageFormat.format(m_bundle.getString("LSFScheduler.NoServerAvailable.fmt"), this.getHost()));
        }
        catch (LoginException le) {
            this.m_schedulingServer.setUsername(null);
            this.m_schedulingServer.setPassword(null);
            ex = new SchedulerException(MessageFormat.format(m_bundle.getString("LSFScheduler.LogonFailure.message.fmt"), this.getHost()), LSFScheduler.class, "LSFScheduler.LogonFailure.message.fmt", new Object[]{this.getHost()});
        }
        catch (SecurityException e) {
            this.m_schedulingServer.setUsername(null);
            this.m_schedulingServer.setPassword(null);
            ex = new SchedulerException(MessageFormat.format(m_bundle.getString("LSFScheduler.LogonFailure.message.fmt"), this.getHost()), LSFScheduler.class, "LSFScheduler.LogonFailure.message.fmt", new Object[]{this.getHost()});
        }
        catch (UnsupportedEncodingException e) {
            ex = new SchedulerException(MessageFormat.format(m_bundle.getString("LSFScheduler.LogonFailure.message.fmt"), this.getHost()), LSFScheduler.class, "LSFScheduler.LogonFailure.message.fmt", new Object[]{this.getHost()});
        }
        catch (IOException e) {
            ex = new SchedulerException(MessageFormat.format(m_bundle.getString("LSFScheduler.LogonFailure.message.fmt"), this.getHost()), LSFScheduler.class, "LSFScheduler.LogonFailure.message.fmt", new Object[]{this.getHost()});
        }
        catch (JFException e) {
            ex = new SchedulerException(MessageFormat.format(m_bundle.getString("LSFScheduler.LogonFailure.message.fmt"), this.getHost()), LSFScheduler.class, "LSFScheduler.LogonFailure.message.fmt", new Object[]{this.getHost()});
        }
        if (ex != null) {
            throw ex;
        }
        if (ipe != null) {
            throw ipe;
        }
        return connected;
    }

    protected String genFlowName(String flowname) {
        return this.genFlowName(flowname, this.m_schedulingServer.getUsername());
    }

    protected String genFlowName(String flowname, String user) {
        if (flowname.indexOf(":") <= 0) {
            if (user != null && user.length() > 0) {
                flowname = user + ":" + flowname;
            } else if (this.m_schedulingServer != null) {
                String userid = this.m_schedulingServer.getUsername();
                if (userid != null && userid.length() > 0) {
                    flowname = userid + ":" + flowname;
                } else {
                    PasswordAuthentication l = SchedulerIMPL.getUserConnection(this.m_schedulingServer);
                    if (l != null) {
                        block11: {
                            this.m_schedulingServer.setUsername(l.getUserName());
                            try {
                                if (MetaUtilities.isAllowPasswordCache()) {
                                    this.m_schedulingServer.setPassword(SasPasswordString.encode((String)new String(l.getPassword())));
                                }
                            }
                            catch (SasPasswordEncodingException e) {
                                if (!MetaUtilities.isAllowPasswordCache()) break block11;
                                this.m_schedulingServer.setPassword(new String(l.getPassword()));
                            }
                        }
                        userid = this.m_schedulingServer.getUsername();
                        if (userid != null && userid.length() > 0) {
                            flowname = userid + ":" + flowname;
                        }
                    }
                }
            }
        }
        return flowname;
    }

    private static List<FlowHistory> getFlowHistoryList(JFFlowManager flowMgr, String userid, Set<String> flowNames, int count, boolean noUnknownStates) throws SchedulerException {
        try {
            ArrayList<FlowHistory> returnList = new ArrayList<FlowHistory>();
            List list = JFUtility.getPseudoFlowInstanceList((String)userid, flowNames, (int)count, (boolean)noUnknownStates);
            for (JFPseudoFlowInstance jfinstance : list) {
                returnList.add(new LSFFlowHistory(jfinstance.getInstanceId(), jfinstance.getFlowName(), jfinstance.getInstanceName(), jfinstance.getState(), jfinstance.getStatus(), jfinstance.getStartTime(), jfinstance.getFinishTime()));
            }
            return returnList;
        }
        catch (JFException jfe) {
            SchedulerException ex = new SchedulerException(jfe.toString());
            throw ex;
        }
        catch (IOException ioe) {
            SchedulerException ex = new SchedulerException(ioe.getLocalizedMessage());
            throw ex;
        }
        catch (NullPointerException npe) {
            SchedulerException ex = new SchedulerException(npe.toString());
            throw ex;
        }
    }

    private LSFCalendar makeCalendar(JFCalendar lsfcal) throws SchedulerException {
        return new LSFCalendar(lsfcal);
    }

    private void setFlowComplete(JFFlow flow, int level, List<String> jobList) {
        JFJob[] jobs = flow.getJobs();
        JFFlow[] subflows = flow.getFlows();
        int size = jobs.length + subflows.length;
        String[] activities = new String[size];
        JFEvent[] events = new JFEvent[size];
        int count = 0;
        for (int i = 0; i < jobs.length; ++i) {
            String jobName = jobs[i].getName();
            int index = jobName.indexOf("{");
            String checkName = jobName;
            if (index > 0) {
                checkName = jobName.substring(0, index);
            }
            if (!jobList.contains(checkName)) continue;
            activities[count] = jobName;
            events[count] = new JFJobEvent(jobs[i], 1);
            ++count;
        }
        for (int k = 0; k < subflows.length; ++k) {
            String subflowName = subflows[k].getName();
            if (!jobList.contains(subflowName)) continue;
            activities[count] = subflowName;
            events[count] = new JFFlowEvent(subflows[k], 1);
            ++count;
        }
        int condition = 0;
        if (level == 3) {
            condition = 1;
        }
        JFLinkEvent exitEvent = new JFLinkEvent(events, condition);
        flow.setExitCondition(activities, (JFEvent)exitEvent);
    }

    private JFFlow processFlow(FlowInfo flow) throws JFException, IOException, InvalidParameterException, SchedulerException {
        String flowname;
        JFFlow holdFlow = null;
        if (this.m_jfFlow != null) {
            holdFlow = this.m_jfFlow;
        }
        try {
            flow.checkCircularDependencies();
        }
        catch (InvalidParameterException ex) {
            InvalidParameterException e = new InvalidParameterException(LSFScheduler.createCircularDependencyMessage(null, ex.getMessage(), flow));
            throw e;
        }
        if (holdFlow == null) {
            flowname = null;
            JFVersion version = JFConfigManager.getServerVersion((boolean)true);
            flowname = version.compareTo("8.31") < 0 ? this.genNormalizedFlowName(flow) : flow.getName();
            this.m_jfFlow = new JFFlow(flowname);
        } else {
            flowname = flow.getName();
            this.m_jfFlow = new JFFlow(flowname);
        }
        this.m_jfFlow.setAttribute("EndBehaviour", "FlowContinue");
        String desc = flow.getDescription() != null ? flow.getDescription() : "";
        this.m_jfFlow.setAttribute("Description", desc);
        List jobs = flow.getJobs();
        ArrayList<Object> jfjobs = new ArrayList<Object>();
        HashMap<String, Object> jobMap = new HashMap<String, Object>();
        for (int i = 0; i < jobs.size(); ++i) {
            DisplayInfo job = (DisplayInfo)jobs.get(i);
            if (job instanceof JobInfo) {
                JFJob lsfjob = this.processJob((JobInfo)job, flow);
                jfjobs.add(lsfjob);
                jobMap.put(job.getId(), lsfjob);
                continue;
            }
            if (!(job instanceof FlowInfo)) continue;
            JFFlow lsfflow = this.processSubflow((FlowInfo)job);
            jfjobs.add(lsfflow);
            jobMap.put(job.getId(), lsfflow);
        }
        HashMap<String, Cloneable> listOfJobs = new HashMap<String, Cloneable>();
        listOfJobs.putAll(jobMap);
        for (int i = 0; i < jobs.size(); ++i) {
            DisplayInfo job = (DisplayInfo)jobs.get(i);
            Object obj = jfjobs.get(i);
            if (obj instanceof JFJob) {
                this.processJobEvents(this.m_jfFlow, flow, (JFJob)obj, job, listOfJobs);
                continue;
            }
            if (!(obj instanceof JFFlow)) continue;
            this.processSubflowEvents(this.m_jfFlow, flow, (JFFlow)obj, job, listOfJobs);
        }
        if (holdFlow != null) {
            if (flow.hasAdvanceCompletion()) {
                this.setFlowComplete(this.m_jfFlow, flow.completionLevel(), flow.completionSelectedJobs());
            }
            int afterstate = flow.getEndBehaviorDataBinding();
            switch (afterstate) {
                case 2: {
                    this.m_jfFlow.setAttribute("EndBehaviour", "FlowContinue");
                    break;
                }
                case 3: {
                    this.m_jfFlow.setAttribute("EndBehaviour", "FlowContinueDelay");
                    break;
                }
                default: {
                    this.m_jfFlow.setAttribute("EndBehaviour", "FlowStop");
                }
            }
            int exitcode = flow.getExitcodeBehaviorDataBinding();
            switch (exitcode) {
                case 1: {
                    this.m_jfFlow.setAttribute("ExitCodeRule", "FromLastItem");
                    break;
                }
                default: {
                    this.m_jfFlow.setAttribute("ExitCodeRule", "FromSumOfItems");
                }
            }
            JFFlow returnJob = this.m_jfFlow;
            this.m_jfFlow = holdFlow;
            return returnJob;
        }
        return this.m_jfFlow;
    }

    public JFFlow getFlowJobsAndDependencies(FlowInfo flow) {
        JFFlow jfFlow = new JFFlow(flow.getName());
        FlowInfo hold = this.m_dflow;
        this.m_dflow = flow;
        List jobs = flow.getJobs();
        ArrayList<Object> jfjobs = new ArrayList<Object>();
        HashMap<String, Object> jobMap = new HashMap<String, Object>();
        for (int i = 0; i < jobs.size(); ++i) {
            DisplayInfo job = (DisplayInfo)jobs.get(i);
            try {
                if (job instanceof JobInfo) {
                    JFJob lsfjob = this.processJob((JobInfo)job, flow);
                    jfjobs.add(lsfjob);
                    jobMap.put(job.getId(), lsfjob);
                    continue;
                }
                if (!(job instanceof FlowInfo)) continue;
                JFFlow lsfflow = this.processSubflow((FlowInfo)job);
                jfjobs.add(lsfflow);
                jobMap.put(job.getId(), lsfflow);
                continue;
            }
            catch (Exception e) {
                System.err.println("Skipping: " + job.getName());
            }
        }
        HashMap<String, Cloneable> listOfJobs = new HashMap<String, Cloneable>();
        listOfJobs.putAll(jobMap);
        for (int i = 0; i < jobs.size(); ++i) {
            DisplayInfo job = (DisplayInfo)jobs.get(i);
            Object obj = jfjobs.get(i);
            try {
                if (obj instanceof JFJob) {
                    this.processJobEvents(jfFlow, flow, (JFJob)obj, job, listOfJobs);
                    continue;
                }
                if (!(obj instanceof JFFlow)) continue;
                this.processSubflowEvents(jfFlow, flow, (JFFlow)obj, job, listOfJobs);
                continue;
            }
            catch (Exception e) {
                System.err.println("Skipping: " + job.getName());
            }
        }
        this.m_dflow = hold;
        return jfFlow;
    }

    public static String cleanSchedulingDetails(String details) {
        JFJob jfJob = new JFJob();
        try {
            jfJob.initFromDefinition(details);
            jfJob.setAttribute("HostSelect", "");
            return jfJob.generateDefinition();
        }
        catch (JFException jfe) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private JFJob processJob(JobInfo job, FlowInfo flow) throws JFException, IOException, InvalidParameterException, SchedulerException {
        int os;
        Object schJob = null;
        int n = os = job.getBatchServer() != null ? job.getBatchServer().getOperatingSystem() : -1;
        schJob = 2 == os ? this.processMainframeJob(job) : (this.m_scoping ? this.processLSFJob(job, flow, this.m_stdout, this.m_stderr) : this.processLSFJob(job, this.m_dflow, this.m_stdout, this.m_stderr));
        return schJob;
    }

    private JFFlow processSubflow(FlowInfo subflow) throws InvalidParameterException, JFException, IOException, SchedulerException {
        return this.processFlow(subflow);
    }

    private void processJobEvents(JFFlow schFlow, FlowInfo flow, JFJob schJob, DisplayInfo job, HashMap<String, Cloneable> listOfJobs) throws SchedulerException {
        DisplayInfo info = null;
        if (job instanceof JobInfo) {
            info = flow.getEvent((JobInfo)job);
        } else if (job instanceof FlowInfo) {
            info = flow.getEvent((FlowInfo)job);
        }
        JFEvent event = this.processFlowEventInfo(flow, info, listOfJobs);
        if (event != null) {
            schFlow.addJob(schJob, event);
        } else {
            schFlow.addJob(schJob);
        }
    }

    private void processSubflowEvents(JFFlow schFlow, FlowInfo flow, JFFlow schSubflow, DisplayInfo job, HashMap<String, Cloneable> listOfJobs) throws SchedulerException {
        DisplayInfo info = null;
        if (job instanceof JobInfo) {
            info = flow.getEvent((JobInfo)job);
        } else if (job instanceof FlowInfo) {
            info = flow.getEvent((FlowInfo)job);
        }
        JFEvent event = this.processFlowEventInfo(flow, info, listOfJobs);
        if (event != null) {
            schFlow.addFlow(schSubflow, event);
        } else {
            schFlow.addFlow(schSubflow);
        }
    }

    private JFEvent processFlowEventInfo(FlowInfo flow, DisplayInfo info, HashMap<String, Cloneable> listOfJobs) throws SchedulerException {
        if (info == null) {
            return null;
        }
        if (info instanceof GroupingEventInfo) {
            GroupingEventInfo ginfo = (GroupingEventInfo)info;
            int condition = -1;
            switch (ginfo.getEventType()) {
                case 0: {
                    condition = 0;
                    break;
                }
                default: {
                    condition = 1;
                }
            }
            List list = ginfo.getDependencies2();
            int numEvents = list.size();
            JFEvent[] predecessorEvents = new JFEvent[numEvents];
            for (int x = 0; x < numEvents; ++x) {
                AbstractEventInfo ai = (AbstractEventInfo)list.get(x);
                if (ai instanceof GroupingEventInfo) {
                    predecessorEvents[x] = this.processFlowEventInfo(flow, (DisplayInfo)ai, listOfJobs);
                    continue;
                }
                if (ai instanceof JobEventInfo) {
                    JobEventInfo jei = (JobEventInfo)ai;
                    predecessorEvents[x] = this.createJobEvent(jei, listOfJobs);
                    continue;
                }
                if (ai instanceof TimeEventInfo) {
                    TimeEventInfo tei = (TimeEventInfo)ai;
                    predecessorEvents[x] = this.createTimeEvent(tei);
                    continue;
                }
                if (!(ai instanceof FileEventInfo)) continue;
                FileEventInfo fei = (FileEventInfo)ai;
                predecessorEvents[x] = this.createFileEvent(fei);
            }
            return new JFLinkEvent(predecessorEvents, condition);
        }
        if (info instanceof JobEventInfo) {
            JobEventInfo jei = (JobEventInfo)info;
            return this.createJobEvent(jei, listOfJobs);
        }
        if (info instanceof TimeEventInfo) {
            TimeEventInfo tei = (TimeEventInfo)info;
            return this.createTimeEvent(tei);
        }
        if (info instanceof FileEventInfo) {
            FileEventInfo fei = (FileEventInfo)info;
            return this.createFileEvent(fei);
        }
        return null;
    }

    public JFJob getJFJob(JobInfo job, FlowInfo flow) {
        block6: {
            try {
                return this.processLSFJob(job, flow, this.m_stdout, this.m_stderr);
            }
            catch (JFException e) {
                if (this.isDebug()) {
                    e.printStackTrace();
                }
            }
            catch (SchedulerException e) {
                if (this.isDebug()) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                if (!this.isDebug()) break block6;
                e.printStackTrace();
            }
        }
        return null;
    }

    private JFJob processLSFJob(JobInfo job, FlowInfo flow, String stdout, String stderr) throws IOException, SchedulerException, JFException {
        JFHandler[] hndlrs;
        String jobEnv;
        int i;
        String p;
        String end;
        String start;
        List<String> queues;
        String jobQueue;
        String cmdline;
        JFJob lsfjob = new JFJob(job.getName());
        String details = job.getSchedulerProperties();
        if (details != null) {
            try {
                lsfjob.initFromDefinition(details);
            }
            catch (JFException jfe) {
                System.err.println(details);
                SchedulerException ex = new SchedulerException(MessageFormat.format(m_bundle.getString("LSFScheduler.Error.JFE.fmt"), job.getName(), jfe.toString()));
                throw ex;
            }
            lsfjob.setName(job.getName());
            lsfjob.setAttribute("Description", job.getDescription());
        }
        if ((cmdline = job.getCommandLine()) == null) {
            throw new SchedulerException(MessageFormat.format(m_bundle.getString("LSFScheduler.SchedulingDetailsError.fmt"), job.getName()));
        }
        lsfjob.setAttribute("JobCmdLine", cmdline);
        String userid = job.getUserId();
        if (userid != null) {
            lsfjob.setAttribute("UserName", userid);
        } else {
            lsfjob.setAttribute("UserName", this.m_schedulingServer.getUsername());
        }
        String resources = job.getSchedulerResources();
        if (this.getAppServerResource()) {
            String appServerResource = CommandUtilities.getAppServerName(job).replace(' ', SUBCHAR);
            if (resources != null) {
                lsfjob.setAttribute("ResReqStr", resources + " && " + appServerResource);
            } else {
                lsfjob.setAttribute("ResReqStr", appServerResource);
            }
        } else if (resources != null) {
            lsfjob.setAttribute("ResReqStr", resources);
        } else {
            lsfjob.setAttribute("ResReqStr", "");
        }
        if (stdout != null) {
            stdout = GeneralUtilities.replaceString((String)stdout, (String)"%f", (String)flow.getName());
            stdout = GeneralUtilities.replaceString((String)stdout, (String)"%j", (String)job.getName());
            lsfjob.setAttribute("Stdout", stdout);
        }
        if (stderr != null) {
            stderr = GeneralUtilities.replaceString((String)stderr, (String)"%f", (String)flow.getName());
            stderr = GeneralUtilities.replaceString((String)stderr, (String)"%j", (String)job.getName());
            lsfjob.setAttribute("Stderr", stderr);
        }
        String queue = flow.getSchedulerQueue();
        String pqueue = this.m_dflow.getSchedulerQueue();
        if (queue != null && queue.compareTo(LSFJob.UseDefaultQueue) != 0) {
            jobQueue = lsfjob.getAttribute("QueueSelect");
            if ((jobQueue == null || jobQueue.compareTo(LSFJob.UseDefaultQueue) == 0) && (queues = this.getQueues()).contains(queue)) {
                lsfjob.setAttribute("QueueSelect", queue);
            }
        } else if (pqueue != null && pqueue.compareTo(LSFJob.UseDefaultQueue) != 0) {
            jobQueue = lsfjob.getAttribute("QueueSelect");
            if ((jobQueue == null || jobQueue.compareTo(LSFJob.UseDefaultQueue) == 0) && (queues = this.getQueues()).contains(pqueue)) {
                lsfjob.setAttribute("QueueSelect", pqueue);
            }
        } else if (this.useNLSDefaultQueue(lsfjob.getAttribute("JobCmdLine")) && ((jobQueue = lsfjob.getAttribute("QueueSelect")) == null || jobQueue.compareTo(LSFJob.UseDefaultQueue) == 0)) {
            lsfjob.setAttribute("QueueSelect", "unicodecmd");
        }
        if (flow.isJobDefaultNotifyEmail()) {
            start = lsfjob.getAttribute("MailWhenStart");
            end = lsfjob.getAttribute("MailWhenFinish");
            if (!(start != null && start.length() > 0 || end != null && end.length() > 0)) {
                lsfjob.setAttribute("MailDestination", flow.getJobDefaultEmailAddressDataBinding());
                switch (flow.getJobDefaultEmailNotificationDataBinding()) {
                    case 0: {
                        lsfjob.setAttribute("MailWhenStart", "Yes");
                        break;
                    }
                    case 4: {
                        lsfjob.setAttribute("MailWhenFinish", "Yes");
                        break;
                    }
                    case 1: {
                        lsfjob.setAttribute("MailWhenStart", "Yes");
                        lsfjob.setAttribute("MailWhenFinish", "Yes");
                    }
                }
            }
        } else if (this.m_dflow.isJobDefaultNotifyEmail()) {
            start = lsfjob.getAttribute("MailWhenStart");
            end = lsfjob.getAttribute("MailWhenFinish");
            if (!(start != null && start.length() > 0 || end != null && end.length() > 0)) {
                lsfjob.setAttribute("MailDestination", this.m_dflow.getJobDefaultEmailAddressDataBinding());
                switch (this.m_dflow.getJobDefaultEmailNotificationDataBinding()) {
                    case 0: {
                        lsfjob.setAttribute("MailWhenStart", "Yes");
                        break;
                    }
                    case 4: {
                        lsfjob.setAttribute("MailWhenFinish", "Yes");
                        break;
                    }
                    case 1: {
                        lsfjob.setAttribute("MailWhenStart", "Yes");
                        lsfjob.setAttribute("MailWhenFinish", "Yes");
                    }
                }
            }
        }
        int waterMark = this.getMaxJobPriority();
        if (waterMark == -1) {
            lsfjob.setAttribute("JobPriority", "");
        } else if (flow.getJobDefaultPriority() != -1) {
            p = lsfjob.getAttribute("JobPriority");
            if (p == null || p.length() <= 0) {
                if (job.getJobPriority() != -1) {
                    switch (job.getJobPriority()) {
                        case 0: {
                            p = String.valueOf(waterMark);
                            break;
                        }
                        case 1: {
                            p = String.valueOf((double)waterMark * 0.75);
                            break;
                        }
                        case 2: {
                            p = String.valueOf(waterMark / 2);
                            break;
                        }
                        case 3: {
                            p = String.valueOf(waterMark / 4);
                            break;
                        }
                        case 4: {
                            p = String.valueOf(waterMark / 100);
                            if (!p.equals("0")) break;
                            p = "1";
                        }
                    }
                } else {
                    switch (flow.getJobDefaultPriority()) {
                        case 0: {
                            p = String.valueOf(waterMark);
                            break;
                        }
                        case 1: {
                            p = String.valueOf((double)waterMark * 0.75);
                            break;
                        }
                        case 2: {
                            p = String.valueOf(waterMark / 2);
                            break;
                        }
                        case 3: {
                            p = String.valueOf(waterMark / 4);
                            break;
                        }
                        case 4: {
                            p = String.valueOf(waterMark / 100);
                            if (!p.equals("0")) break;
                            p = "1";
                        }
                    }
                }
            }
            if ((i = p.indexOf(46)) > 0) {
                p = p.substring(0, i);
            }
            lsfjob.setAttribute("JobPriority", p);
        } else if (this.m_dflow.getJobDefaultPriority() != -1) {
            p = lsfjob.getAttribute("JobPriority");
            if (p == null || p.length() <= 0) {
                if (job.getJobPriority() != -1) {
                    switch (job.getJobPriority()) {
                        case 0: {
                            p = String.valueOf(waterMark);
                            break;
                        }
                        case 1: {
                            p = String.valueOf((double)waterMark * 0.75);
                            break;
                        }
                        case 2: {
                            p = String.valueOf(waterMark / 2);
                            break;
                        }
                        case 3: {
                            p = String.valueOf(waterMark / 4);
                            break;
                        }
                        case 4: {
                            p = String.valueOf(waterMark / 100);
                            if (!p.equals("0")) break;
                            p = "1";
                        }
                    }
                } else {
                    switch (this.m_dflow.getJobDefaultPriority()) {
                        case 0: {
                            p = String.valueOf(waterMark);
                            break;
                        }
                        case 1: {
                            p = String.valueOf((double)waterMark * 0.75);
                            break;
                        }
                        case 2: {
                            p = String.valueOf(waterMark / 2);
                            break;
                        }
                        case 3: {
                            p = String.valueOf(waterMark / 4);
                            break;
                        }
                        case 4: {
                            p = String.valueOf(waterMark / 100);
                            if (!p.equals("0")) break;
                            p = "1";
                        }
                    }
                }
            }
            if ((i = p.indexOf(46)) > 0) {
                p = p.substring(0, i);
            }
            lsfjob.setAttribute("JobPriority", p);
        }
        String envVars = flow.getJobDefaultEnvironmentVariables();
        String penvVars = this.m_dflow.getJobDefaultEnvironmentVariables();
        if (envVars != null && envVars.length() > 0) {
            jobEnv = lsfjob.getAttribute("JobEnvVars");
            if (jobEnv == null || jobEnv.length() <= 0) {
                lsfjob.setAttribute("JobEnvVars", envVars);
            }
        } else if (penvVars != null && penvVars.length() > 0 && ((jobEnv = lsfjob.getAttribute("JobEnvVars")) == null || jobEnv.length() <= 0)) {
            lsfjob.setAttribute("JobEnvVars", penvVars);
        }
        String handlers = flow.getJobDefaultExceptionHandlers();
        String phandlers = this.m_dflow.getJobDefaultExceptionHandlers();
        if (handlers != null && handlers.length() > 0) {
            JFHandler[] hndlrs2 = lsfjob.getHandlers();
            if (hndlrs2 == null || hndlrs2.length <= 0) {
                String value = MetaUtilities.replaceString(handlers, DEFAULTJOBNAME, lsfjob.getName());
                lsfjob.initHandlersFromDefinition(value);
            }
        } else if (phandlers != null && phandlers.length() > 0 && ((hndlrs = lsfjob.getHandlers()) == null || hndlrs.length <= 0)) {
            String value = MetaUtilities.replaceString(phandlers, DEFAULTJOBNAME, lsfjob.getName());
            lsfjob.initHandlersFromDefinition(value);
        }
        job.setSchedulerProperties(lsfjob.generateDefinition());
        return lsfjob;
    }

    public JFTemplateJob getMainframeJob(JobInfo job) {
        block6: {
            try {
                return this.processMainframeJob(job);
            }
            catch (JFException e) {
                if (this.isDebug()) {
                    e.printStackTrace();
                }
            }
            catch (SchedulerException e) {
                if (this.isDebug()) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                if (!this.isDebug()) break block6;
                e.printStackTrace();
            }
        }
        return null;
    }

    private JFTemplateJob processMainframeJob(JobInfo job) throws SchedulerException, IOException, JFException {
        String errorMsgs;
        String cmdline;
        JFTemplateDef templateDef = this.getTemplateDef();
        JFTemplateJob templateJob = new JFTemplateJob(job.getName(), templateDef);
        templateJob.setAttribute("Description", job.getDescription());
        templateJob.setExecutionType("zos");
        String userid = job.getUserId();
        if (userid != null) {
            templateJob.setAttribute("UserName", userid);
        } else {
            templateJob.setAttribute("UserName", new JFUser(this.m_schedulingServer.getUsername()).toJSUserName());
        }
        String details = job.getSchedulerProperties();
        if (details != null) {
            try {
                templateJob.initFromDefinition(details);
            }
            catch (JFException jfe) {
                System.err.println(details);
                Object[] args = new Object[]{job.getName(), jfe.toString()};
                SchedulerException ex = new SchedulerException(MessageFormat.format(m_bundle.getString("LSFScheduler.Error.JFE.fmt"), args));
                throw ex;
            }
            templateJob.setName(job.getName());
            templateJob.setAttribute("Description", job.getDescription());
        }
        if ((cmdline = job.getCommandLine()) != null) {
            templateJob.setAttribute("JobCmdLine", cmdline);
        } else {
            String file = job.getSourceFile();
            if (file != null) {
                String fname = null;
                String filepath = null;
                int index = file.lastIndexOf(46);
                if (index > 0) {
                    fname = file.substring(0, index - 1);
                }
                fname = fname + ".jcl";
                DirectoryInfo dir = job.getSourceDir();
                filepath = dir != null ? dir.getPath() : "";
                String physicalName = CommandUtilities.createFullPath(filepath, fname, 2);
                PasswordAuthentication pa = this.getzOSUserPass(userid);
                this.writeJCLFile(job, physicalName, pa);
                templateJob.setAttribute("JobCmdLine", physicalName);
            }
        }
        JFTemplateData templateData = templateJob.getTemplateData();
        JFTemplateParameterList subParams = this.getzOSSubmissionParameters(job, userid, true);
        templateData.setSubmissionParameters(subParams);
        JFTemplateParameterList execParams = this.getzOSExecutionParameters(job);
        if (execParams != null) {
            templateData.setExecutionParameters(execParams);
        }
        templateJob.setTemplateData(templateData);
        templateJob.setAttribute("Stdout", "C:\\Public\\zos.%J");
        job.setSchedulerProperties(templateJob.generateDefinition());
        if ((LOGGER.isDebugEnabled() || this.isDebug()) && (errorMsgs = JFTemplateManager.getInstance().getErrorMsgs()) != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(errorMsgs);
            } else {
                System.out.println(errorMsgs);
            }
        }
        if (this.m_templatefile != null) {
            this.m_templatefile.delete();
            this.m_templatefile = null;
        }
        return templateJob;
    }

    public JFTemplateDef getTemplateDef() throws SchedulerException {
        JFTemplateDef templateDef = null;
        String template = null;
        try {
            template = this.m_templatedir + ZOS_TEMPLATE;
            templateDef = new JFTemplateDef(template);
        }
        catch (IllegalArgumentException iae) {
            try {
                InputStream instr = this.getClass().getClassLoader().getResourceAsStream("com/sas/scheduler/api/servers/lsf/zOS_Template.xml");
                InputStreamReader in = new InputStreamReader(instr);
                if (this.m_templatefile == null) {
                    this.m_templatefile = File.createTempFile(ZOS_TEMPLATE, null);
                }
                FileWriter out = new FileWriter(this.m_templatefile);
                boolean eof = false;
                while (!eof) {
                    char[] buffer = new char[512];
                    int rc = in.read(buffer);
                    if (rc == -1) {
                        eof = true;
                        continue;
                    }
                    out.write(buffer, 0, rc);
                }
                in.close();
                out.close();
                templateDef = new JFTemplateDef(this.m_templatefile.getAbsolutePath());
            }
            catch (JFInvalidTemplateException jfite) {
                SchedulerException ex = new SchedulerException(iae.toString());
                throw ex;
            }
            catch (IOException ioe) {
                SchedulerException ex = new SchedulerException(ioe.toString());
                throw ex;
            }
        }
        catch (JFInvalidTemplateException jfite) {
            SchedulerException ex = new SchedulerException(jfite.toString());
            throw ex;
        }
        return templateDef;
    }

    private boolean useNLSDefaultQueue(String command) throws SchedulerException, JFException, IOException {
        JFAdminManager adminMgr = this.validateAdminManager();
        if (adminMgr == null) {
            return false;
        }
        String[] queues = adminMgr.getQueuesCached();
        boolean found = false;
        for (int i = 0; i < queues.length; ++i) {
            String queue = queues[i];
            if (queue.compareTo("unicodecmd") != 0) continue;
            found = true;
            break;
        }
        if (found) {
            return JFUTFConverter.hasUnicode((String)command);
        }
        return false;
    }

    private JFTemplateParameterList getzOSSubmissionParameters(JobInfo job, String user, boolean jclOnMainframe) throws JFException, SchedulerException {
        JFTemplateParameterList subParams = new JFTemplateParameterList();
        String jclFile = null;
        String outFile = null;
        String userid = null;
        String host = job.getBatchServer().getHost();
        JFTemplateParameter param1 = new JFTemplateParameter("MFHost", "CaptionMFHost", host);
        subParams.addParameter(param1);
        PasswordAuthentication pa = this.getzOSUserPass(user);
        userid = pa.getUserName().toUpperCase();
        SealedString password = pa.getPassword() != null ? new SealedString(pa.getPassword()) : null;
        try {
            if (SasPasswordString.isEncodedChars((char[])(password != null ? password.getCharacters() : null))) {
                password = password != null ? new SealedString(SasPasswordString.decodeChars((char[])password.getCharacters())) : null;
            }
        }
        catch (SasPasswordEncodingException pe) {
            password = pa.getPassword() != null ? new SealedString(pa.getPassword()) : null;
        }
        jclFile = job.getCommandLine();
        outFile = job.getBatchServer().getJCLDirectory();
        outFile = outFile != null ? LSFScheduler.getOutfile(outFile, jclFile) : LSFScheduler.getOutfile(job.getBatchServer(), jclFile);
        JFTemplateParameter param2 = new JFTemplateParameter("LoginUser", "CaptionLoginUser", userid);
        subParams.addParameter(param2);
        JFTemplateParameter param3 = new JFTemplateParameter("Password", "CaptionPassword", password != null ? String.valueOf(password.getCharacters()) : null);
        param3.encryptInput();
        subParams.addParameter(param3);
        JFTemplateParameter param4 = new JFTemplateParameter("JCLFile", "CaptionJCLFile", jclFile);
        subParams.addParameter(param4);
        JFTemplateParameter param5 = new JFTemplateParameter("OutputFile", "CaptionOutputFile", outFile);
        subParams.addParameter(param5);
        JFTemplateParameter param6 = null;
        param6 = jclOnMainframe ? new JFTemplateParameter("JCLFileOnZOS", "CaptionJCLFileOnZOS", "Yes") : new JFTemplateParameter("JCLFileOnZOS", "CaptionJCLFileOnZOS", "No");
        subParams.addParameter(param6);
        return subParams;
    }

    private JFTemplateParameterList getzOSExecutionParameters(JobInfo job) {
        JFTemplateParameterList execParams = new JFTemplateParameterList();
        JFTemplateParameter param9 = new JFTemplateParameter("QueueSelect", "CaptionQueueSelect", "normal");
        execParams.addParameter(param9);
        return execParams;
    }

    private PasswordAuthentication getzOSUserPass(String user) throws SchedulerException {
        PasswordAuthentication pa = null;
        String userid = user;
        if (user != null) {
            PasswordAuthentication pa2 = LSFScheduler.getLoginIdentity(this.m_schedulingServer);
            pa = pa2.getUserName().compareTo(user) == 0 ? pa2 : new PasswordAuthentication(user, "".toCharArray());
        } else if (this.m_zos_user != null) {
            pa = new PasswordAuthentication(this.m_zos_user, this.m_zos_password != null ? this.m_zos_password.getCharacters() : null);
        } else {
            pa = MetaUtilities.getLoginIdentity(this.m_schedulingServer);
            if (pa == null) {
                userid = new JFUser(this.m_schedulingServer.getUsername()).toJSUserName();
                if (userid.indexOf("\\") > 0) {
                    int i = userid.indexOf("\\");
                    userid = userid.substring(i + 1);
                }
                try {
                    SealedString password = this.getSchServerInfoPasswordSealedString();
                    pa = new PasswordAuthentication(userid, password != null ? password.getCharacters() : null);
                }
                catch (RuntimeException ex) {
                    pa = new PasswordAuthentication(userid, "".toCharArray());
                }
            }
        }
        return pa;
    }

    private JFEvent JFprocessWaitEvent(DisplayInfo trigger) throws JFException, IOException, SchedulerException {
        Object event = null;
        event = trigger instanceof TriggerEventInfo ? ((TriggerEventInfo)trigger).getEvent() : trigger;
        if (event instanceof TimeEventInfo) {
            return this.createTimeEvent((TimeEventInfo)event);
        }
        if (event instanceof FileEventInfo) {
            return this.createFileEvent((FileEventInfo)event);
        }
        return null;
    }

    public JFEvent createJobEvent(JobEventInfo jei, HashMap<String, Cloneable> listOfJobs) {
        JFEvent event = null;
        int type = jei.getEventType();
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (listOfJobs.get(jei.getJobInfo().getId()) instanceof JFJob) {
                    JFJob dependJob = (JFJob)listOfJobs.get(jei.getJobInfo().getId());
                    LSFJobEvent jobEvent = new LSFJobEvent(dependJob, type, jei.getOperator(), jei.getValue());
                    event = jobEvent.getEvent();
                    break;
                }
                InvalidParameterException ipe = new InvalidParameterException("Dependent Job is not a JFJob object. Dependency is ignored: " + jei.toString());
                LOGGER.warn("INTERNAL ERROR", (Throwable)ipe);
                if (!this.isDebug()) break;
                ipe.printStackTrace();
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                if (listOfJobs.get(jei.getJobInfo().getId()) instanceof JFFlow) {
                    JFFlow dependSflow = (JFFlow)listOfJobs.get(jei.getJobInfo().getId());
                    LSFJobEvent flowEvent = new LSFJobEvent(dependSflow, type, jei.getOperator(), jei.getValue());
                    event = flowEvent.getEvent();
                    break;
                }
                InvalidParameterException ipe = new InvalidParameterException("Dependent subflow is not a JFFlow object. Dependency is ignored: " + jei.toString());
                LOGGER.warn("INTERNAL ERROR", (Throwable)ipe);
                if (!this.isDebug()) break;
                ipe.printStackTrace();
            }
        }
        return event;
    }

    public JFFileEvent createFileEvent(FileEventInfo event) throws SchedulerException {
        try {
            JFFileEvent object = new JFFileEvent();
            object.initFromCLIDefinition(this.createFileConditionString(event.getFileName(), event.getEventType(), event.getOperator(), event.getValue()));
            return object;
        }
        catch (JFException jfe) {
            SchedulerException se = new SchedulerException(jfe.toString());
            se.initCause((Throwable)jfe);
            throw se;
        }
    }

    public JFTimeEvent createTimeEvent(TimeEventInfo event) throws SchedulerException {
        JFTimeEvent object = null;
        try {
            String calendar = this.getCalendarName(event.getRecurrence());
            String calName = calendar.substring(0, calendar.indexOf("@"));
            String userName = calendar.substring(calendar.indexOf("@") + 1);
            String hours = event.getHours();
            String minutes = event.getMinutes();
            String duration = String.valueOf(event.getDuration());
            String occurrences = String.valueOf(event.getOccur());
            String timezone = event.getTimezone();
            if (userName == null || userName.equals("")) {
                JFUser currentJSUser = new JFUser(JFLoginManager.getUserName());
                userName = currentJSUser.toJSUserName();
            }
            if (this.isOccurrenceSupported() && this.isTimezoneSupported()) {
                if (event.getOccur() != -1 || timezone != null) {
                    String occur = event.getOccur() != -1 ? occurrences : null;
                    object = new JFTimeEvent(calName, userName, hours, minutes, duration, occur, timezone);
                } else {
                    object = new JFTimeEvent(calName, userName, hours, minutes, duration);
                }
            } else {
                object = new JFTimeEvent(calName, userName, hours, minutes, duration);
                if (LOGGER.isDebugEnabled() || this.isDebug()) {
                    String s = m_bundle.getString("LSFScheduler.Warning.AdvanceTimeEventAttributes.NotSupported.txt");
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(s);
                    } else {
                        System.out.println(s);
                    }
                }
            }
        }
        catch (JFException jfe) {
            SchedulerException se = new SchedulerException(jfe.toString());
            se.initCause((Throwable)jfe);
            throw se;
        }
        catch (NullPointerException npe) {
            try {
                object = new JFTimeEvent("", "", "", "", "1");
            }
            catch (JFException jfe) {
                SchedulerException se = new SchedulerException(jfe.toString());
                se.initCause((Throwable)jfe);
                throw se;
            }
        }
        return object;
    }

    private JFEvent[] getTriggeringEvent(FlowInfo flow) throws JFException, IOException, SchedulerException {
        JFEvent[] eventList = null;
        TriggerEventInfo trigger = flow.getTriggerEvent();
        AbstractEventInfo event = trigger.getEvent();
        if (event instanceof GroupingEventInfo) {
            List triggers = ((GroupingEventInfo)event).getDependencies2();
            int numTriggers = triggers.size();
            eventList = new JFEvent[numTriggers];
            int index = 0;
            for (int x = 0; x < numTriggers; ++x) {
                AbstractEventInfo t = (AbstractEventInfo)triggers.get(x);
                if (!(t instanceof TimeEventInfo) && !(t instanceof FileEventInfo)) continue;
                eventList[index++] = this.JFprocessWaitEvent((DisplayInfo)t);
            }
        } else {
            eventList = new JFEvent[1];
            String type = trigger.getType();
            if (type.compareTo("TimeEvent") == 0 || type.compareTo("FileEvent") == 0) {
                eventList[0] = this.JFprocessWaitEvent((DisplayInfo)trigger);
            }
        }
        return eventList;
    }

    private String genNormalizedFlowName(String user, FlowInfo flow) {
        String jsUserName;
        String flowname = flow.getName();
        if (flowname.indexOf(":") <= 0) {
            if (user == null) {
                user = flow.getScheduledUser();
            }
            flowname = user != null ? user + ":" + flowname : this.genFlowName(flowname);
        }
        if (user != null && (jsUserName = new JFUser(user).toJSUserName()).compareTo(user) != 0) {
            flowname = GeneralUtilities.replaceFirstString((String)flowname, (String)user, (String)jsUserName);
        }
        return flowname;
    }

    private String genNormalizedFlowName(FlowInfo flow) {
        String jsUserName;
        String user;
        String string = user = flow.getScheduler() != null ? flow.getScheduler().getUsername() : null;
        if (user == null) {
            user = this.m_schedulingServer.getUsername();
        }
        String name = flow.getName();
        String flowname = this.genFlowName(name, user);
        if (user != null && (jsUserName = new JFUser(user).toJSUserName()).compareTo(user) != 0) {
            flowname = GeneralUtilities.replaceFirstString((String)flowname, (String)user, (String)jsUserName);
        }
        return flowname;
    }

    @Override
    public String genFlowName(FlowInfo flow) {
        return this.genNormalizedFlowName(flow);
    }

    private JFCalendarManager validateCalManager() throws SchedulerException {
        if (this.m_calMgr == null) {
            if (!this.m_connected && !this.m_userConnected) {
                this.makeUserConnection(this.m_schedulingServer);
            } else {
                String chkHost = JFConfigManager.getConfig((String)"JS_HOST");
                if (chkHost.compareTo(this.m_schedulingServer.getHost()) != 0) {
                    JFConfigManager.addConfig((String)"JS_HOST", (String)this.m_schedulingServer.getHost());
                    JFConfigManager.addConfig((String)"JS_PORT", (String)this.m_schedulingServer.getPort());
                }
            }
            try {
                return new JFCalendarManager();
            }
            catch (JFException e) {
                return null;
            }
        }
        return this.m_calMgr;
    }

    private boolean testConnection() {
        if (this.m_flowDefManager == null || !this.m_connected) {
            return false;
        }
        String chkHost = JFConfigManager.getConfig((String)"JS_HOST");
        if (chkHost.compareTo(this.m_schedulingServer.getHost()) != 0) {
            JFConfigManager.addConfig((String)"JS_HOST", (String)this.m_schedulingServer.getHost());
            JFConfigManager.addConfig((String)"JS_PORT", (String)this.m_schedulingServer.getPort());
        }
        if (m_lastConnectedUser.compareTo(this.m_schedulingServer.getUsername()) == 0) {
            return true;
        }
        try {
            boolean loginReq = LSFScheduler.getJSLoginRequired();
            if (!loginReq) {
                return this.__maketheconnection();
            }
            String username = this.m_schedulingServer.getUsername();
            SealedString password = null;
            if (this.m_schedulingServer.getPassword() != null) {
                password = new SealedString(SasPasswordString.decodeChars((char[])this.m_schedulingServer.getPasswordDataBinding().toCharArray()));
            }
            if (username == null || username.length() <= 0 || password == null || (password != null ? password.getCharacters().length : 0) <= 0) {
                return true;
            }
            JFLoginManager.login((String)username, password != null ? String.valueOf(password.getCharacters()) : null);
            if (LOGGER.isDebugEnabled() || this.isDebug()) {
                String s = "LSFScheduler: JFLoginManager - from " + m_lastConnectedUser + " to " + username;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(s);
                } else {
                    System.out.println(s);
                }
            }
            m_lastConnectedUser = username;
            return true;
        }
        catch (SasPasswordEncodingException e) {
            if (this.isDebug()) {
                e.printStackTrace();
            }
            return false;
        }
        catch (LoginException e) {
            if (this.isDebug()) {
                e.printStackTrace();
            }
            return false;
        }
        catch (SchedulerException e) {
            if (this.isDebug()) {
                e.printStackTrace();
            }
            return false;
        }
    }

    public static boolean getJSLoginRequired() {
        String prop = System.getProperty("sas.sch.JSLoginRequired");
        return prop == null || prop.equals("true");
    }

    public static String getEAUTHLocation() {
        String prop = System.getProperty("sas.sch.JSLoginRequired");
        if (prop != null && !prop.equals("true")) {
            return prop;
        }
        return null;
    }

    private static boolean getJSEncryptionRequired() {
        String prop = System.getProperty("sas.sch.JSEncryptionRequired");
        return prop != null && prop.equals("true");
    }

    private static void __setConfig(String user, SealedString pass, String host, String port, boolean loginRequired, boolean jsEncryption, String timeout, String timezone, String jsHome, String templateDir) throws SchedulerException {
        Properties configs = new Properties();
        configs.setProperty("HOST", host);
        configs.setProperty("PORT", port);
        if (user != null) {
            configs.setProperty("UID", user);
        }
        if (pass != null) {
            try {
                configs.setProperty("PWD", String.valueOf(SasPasswordString.decodeChars((char[])(pass != null ? pass.getCharacters() : null))));
            }
            catch (SasPasswordEncodingException ex) {
                ex.printStackTrace();
                SchedulerException se = new SchedulerException(ex.toString());
                se.initCause((Throwable)ex);
                throw se;
            }
        }
        configs.setProperty("JS_HOST", host);
        configs.setProperty("JS_PORT", port);
        configs.setProperty("JS_CONN_TIMEOUT", timeout);
        configs.setProperty("JS_LOGIN_REQUIRED", String.valueOf(loginRequired));
        configs.setProperty("JS_ENCRYPTION", String.valueOf(jsEncryption));
        if (timezone != null) {
            configs.setProperty("JS_TIME_ZONE", timezone);
        }
        if (jsHome != null) {
            configs.setProperty("JS_HOME", jsHome);
        }
        if (templateDir != null) {
            configs.setProperty("JS_TEMPLATE_DIR", templateDir);
        }
        JFConfigManager.init((Properties)configs);
    }

    private static boolean __login(String user, SealedString pass, boolean useGuestOnFailure) throws SchedulerException, ServerLoginException, LoginException, SecurityException, JFException {
        boolean connected;
        block16: {
            connected = false;
            try {
                _userLock.lock();
                if (user != null && user.length() != 0) {
                    JFLoginManager.login((String)user, (String)String.valueOf(SasPasswordString.decodeChars((char[])(pass != null ? pass.getCharacters() : "".toCharArray()))));
                    connected = true;
                    m_lastConnectedUser = user;
                } else {
                    connected = false;
                }
            }
            catch (ServerLoginException se) {
                if (useGuestOnFailure) {
                    JFLoginManager.login((String)"guest", (String)"");
                    m_lastConnectedUser = "guest";
                    connected = true;
                    break block16;
                }
                throw se;
            }
            catch (LoginException le) {
                if (useGuestOnFailure) {
                    JFLoginManager.login((String)"guest", (String)"");
                    m_lastConnectedUser = "guest";
                    connected = true;
                    break block16;
                }
                throw le;
            }
            catch (SecurityException e) {
                if (useGuestOnFailure) {
                    JFLoginManager.login((String)"guest", (String)"");
                    m_lastConnectedUser = "guest";
                    connected = true;
                    break block16;
                }
                throw e;
            }
            catch (SasPasswordEncodingException ex) {
                ex.printStackTrace();
                SchedulerException se = new SchedulerException(ex.toString());
                se.initCause((Throwable)ex);
                throw se;
            }
            finally {
                _userLock.unlock();
            }
        }
        return connected;
    }

    private JFFlowDefinitionManager validateFlowDefinitionManager() throws SchedulerException {
        if (this.m_flowDefManager == null) {
            if (!this.m_connected && !this.m_userConnected) {
                this.makeUserConnection(this.m_schedulingServer);
            } else {
                String chkHost = JFConfigManager.getConfig((String)"JS_HOST");
                if (chkHost.compareTo(this.m_schedulingServer.getHost()) != 0) {
                    JFConfigManager.addConfig((String)"JS_HOST", (String)this.m_schedulingServer.getHost());
                    JFConfigManager.addConfig((String)"JS_PORT", (String)this.m_schedulingServer.getPort());
                }
            }
            try {
                return new JFFlowDefinitionManager();
            }
            catch (JFException e) {
                SchedulerException ex = new SchedulerException(m_bundle.getString("LSFScheduler.UnableToConnectToFlowMgr.txt"));
                ex.initCause((Throwable)e);
                throw ex;
            }
        }
        return this.m_flowDefManager;
    }

    private JFFlowManager validateFlowManager() throws SchedulerException {
        if (this.m_flowMgr == null) {
            if (!this.m_connected && !this.m_userConnected) {
                this.makeUserConnection(this.m_schedulingServer);
            } else {
                String chkHost = JFConfigManager.getConfig((String)"JS_HOST");
                if (chkHost.compareTo(this.m_schedulingServer.getHost()) != 0) {
                    JFConfigManager.addConfig((String)"JS_HOST", (String)this.m_schedulingServer.getHost());
                    JFConfigManager.addConfig((String)"JS_PORT", (String)this.m_schedulingServer.getPort());
                }
            }
            try {
                return new JFFlowManager();
            }
            catch (JFException e) {
                SchedulerException ex = new SchedulerException(m_bundle.getString("LSFScheduler.UnableToConnectToFlowMgr.txt"));
                ex.initCause((Throwable)e);
                throw ex;
            }
        }
        return this.m_flowMgr;
    }

    public JFAdminManager getAdminManager() throws SchedulerException {
        return this.validateAdminManager();
    }

    private JFAdminManager validateAdminManager() throws SchedulerException {
        if (this.m_adminMgr == null) {
            if (!this.m_connected && !this.m_userConnected) {
                this.makeUserConnection(this.m_schedulingServer, "5");
            } else {
                String chkHost = JFConfigManager.getConfig((String)"JS_HOST");
                if (chkHost.compareTo(this.m_schedulingServer.getHost()) != 0) {
                    JFConfigManager.addConfig((String)"JS_HOST", (String)this.m_schedulingServer.getHost());
                    JFConfigManager.addConfig((String)"JS_PORT", (String)this.m_schedulingServer.getPort());
                }
            }
            try {
                return new JFAdminManager();
            }
            catch (JFException e) {
                SchedulerException ex = new SchedulerException(m_bundle.getString("LSFScheduler.UnableToConnectToFlowMgr.txt"));
                ex.initCause((Throwable)e);
                throw ex;
            }
        }
        return this.m_adminMgr;
    }

    @Override
    public String clearJobPropertyOnMatch(String name, String details, String propertyName, String propertyValue) {
        JFJob lsfjob = new JFJob(name);
        if (propertyValue == null) {
            propertyValue = "";
        }
        try {
            lsfjob.initFromDefinition(details);
        }
        catch (JFException jfe) {
            SchedulerException ex = new SchedulerException(MessageFormat.format(m_bundle.getString("LSFScheduler.Error.JFE.fmt"), name, jfe.toString()));
            ex.printStackTrace();
            return details;
        }
        catch (IOException e) {
            SchedulerException ex = new SchedulerException(MessageFormat.format(m_bundle.getString("LSFScheduler.Error.JFE.fmt"), name, e.toString()));
            ex.printStackTrace();
            return details;
        }
        if (propertyName.equals("JobDefaultEmailNotification")) {
            try {
                String end;
                String start = lsfjob.getAttribute("MailWhenStart");
                if (start == null) {
                    start = "";
                }
                if ((end = lsfjob.getAttribute("MailWhenFinish")) == null) {
                    end = "";
                }
                switch (Integer.valueOf(propertyValue)) {
                    case 0: {
                        if (!start.equals("Yes") || end.equals("Yes")) break;
                        lsfjob.setAttribute("MailWhenStart", "");
                        break;
                    }
                    case 4: {
                        if (!end.equals("Yes") || start.equals("Yes")) break;
                        lsfjob.setAttribute("MailWhenFinish", "");
                        break;
                    }
                    case 1: {
                        if (!start.equals("Yes") || !end.equals("Yes")) break;
                        lsfjob.setAttribute("MailWhenStart", "");
                        lsfjob.setAttribute("MailWhenFinish", "");
                    }
                }
            }
            catch (NullPointerException npe) {
                if (MetaUtilities.isDebug()) {
                    npe.printStackTrace();
                }
            }
        } else if (propertyName.equals("JobDefaultEmailNotificationAddress")) {
            String v = lsfjob.getAttribute("MailDestination");
            if (v == null && propertyValue.length() == 0 || v != null && v.equals(propertyValue)) {
                lsfjob.setAttribute("MailDestination", "");
            }
        } else if (propertyName.equals("JobDefaultPriority")) {
            String v = lsfjob.getAttribute("JobEnvVars");
            if (v == null && propertyValue.length() == 0 || v != null && v.equals(propertyValue)) {
                lsfjob.setAttribute("JobEnvVars", "");
            }
        } else if (propertyName.equals("JobDefaultEnvironmentVariables")) {
            String v = lsfjob.getAttribute("JobEnvVars");
            if (v == null && propertyValue.length() == 0 || v != null && v.equals(propertyValue)) {
                lsfjob.setAttribute("JobEnvVars", "");
            }
        } else if (propertyName.equals("QUEUE")) {
            String v = lsfjob.getAttribute("JobPriority");
            if (v == null && propertyValue.length() == 0 || v != null && v.equals(propertyValue)) {
                lsfjob.setAttribute("JobPriority", "");
            }
        } else if (propertyName.equals("JobDefaultExceptionHandlers")) {
            String value;
            String v = lsfjob.convertHandlersToXML();
            if (v == null && propertyValue.length() == 0) {
                lsfjob.setHandlers(null);
            } else if (v != null && v.equals(value = MetaUtilities.replaceString(propertyValue, DEFAULTJOBNAME, lsfjob.getName()))) {
                lsfjob.setHandlers(null);
            }
        }
        return lsfjob.generateDefinition();
    }

    static {
        LOGGER = LogManager.getLogger(LSFScheduler.class);
        String strClassName = LSFScheduler.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
        m_lastConnectedUser = "";
        _userLock = new ReentrantLock();
    }
}

