/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.lsf;

import com.sas.scheduler.api.servers.FlowHistory;
import java.util.Date;

public class LSFFlowHistory
implements FlowHistory {
    private long m_instanceID = -1L;
    private String m_instanceName = null;
    private String m_flowName = null;
    private String m_schedulerFlowName = null;
    private int m_state = -1;
    private int m_status = -1;
    private Date m_startTime = null;
    private Date m_finishTime = null;
    private int m_errorCode = 0;

    public LSFFlowHistory() {
    }

    public LSFFlowHistory(long id, String flowName, String instanceName, int state, int status, Date startTime, Date finishTime) {
        this();
        int firstPos;
        this.m_instanceID = id;
        this.m_state = state;
        this.m_schedulerFlowName = flowName;
        this.m_flowName = flowName != null ? ((firstPos = flowName.indexOf(58)) > 0 ? flowName.substring(firstPos + 1) : flowName) : null;
        this.m_instanceName = instanceName;
        this.m_status = status;
        this.m_startTime = startTime;
        this.m_finishTime = finishTime;
    }

    @Override
    public long getID() {
        return this.m_instanceID;
    }

    @Override
    public Date getStartTime() {
        if (this.m_instanceID == -1L) {
            return null;
        }
        return this.m_startTime;
    }

    @Override
    public Date getFinishTime() {
        if (this.m_instanceID == -1L) {
            return null;
        }
        return this.m_finishTime;
    }

    @Override
    public int getState() {
        if (this.m_instanceID == -1L) {
            return -1;
        }
        return this.mapState(this.m_state);
    }

    @Override
    public int getStatus() {
        if (this.getState() == -1) {
            return -1;
        }
        return this.m_status;
    }

    @Override
    public String getInstanceName() {
        return this.m_instanceName;
    }

    @Override
    public String getFlowName() {
        return this.m_flowName;
    }

    @Override
    public String getSchedulerFlowName() {
        return this.m_schedulerFlowName;
    }

    private int mapState(int schedulerState) {
        int state = -1;
        switch (schedulerState) {
            case 2: {
                state = 0;
                break;
            }
            case 3: {
                state = 1;
                break;
            }
            case 4: {
                state = 2;
                break;
            }
            case 1: {
                state = 3;
                break;
            }
            case 5: {
                state = 4;
                break;
            }
            case 0: {
                state = 5;
                break;
            }
            default: {
                state = -1;
            }
        }
        return state;
    }

    @Override
    public int getErrorCode() {
        return this.m_errorCode;
    }
}

