/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine.mq.client;

import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.IPUtilities;
import com.sas.scheduler.api.servers.ip.engine.Job;
import com.sas.scheduler.api.servers.ip.engine.JobResourceRequirements;
import com.sas.scheduler.api.servers.ip.engine.mq.JMSClusterSupport;
import com.sas.scheduler.api.servers.ip.engine.mq.JMSExecutionProvider;
import com.sas.scheduler.api.servers.ip.engine.mq.client.ILoadBalancer;
import com.sas.scheduler.api.servers.ip.engine.mq.client.ILoadBalancerRunningJobsInfo;
import com.sas.scheduler.api.servers.ip.engine.mq.client.JobPrintStream2;
import com.sas.scheduler.api.servers.ip.engine.mq.client.JobRunner;
import com.sas.scheduler.api.servers.ip.engine.mq.client.NullOutputStream;
import com.sas.scheduler.api.servers.ip.engine.mq.client.QueueOutputStream;
import com.sas.scheduler.api.servers.ip.engine.mq.client.QueueWriter;
import com.sas.scheduler.api.servers.ip.engine.threadpool.ThreadPool;
import com.sas.scheduler.api.servers.ip.engine.threadpool.WorkerThreadInterface;
import java.io.BufferedReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.springframework.jms.JmsException;
import org.springframework.jms.core.BrowserCallback;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessagePostProcessor;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

public class JMSClientSupport
implements ILoadBalancerRunningJobsInfo {
    public static final String Config_PollFrequency = "PIP.JobPollFrequency";
    public static final String Config_ReceiveTimeout = "PIP.JMSReceiveTimeout";
    public static final String Config_OutputLimit = "PIP.OutputLimit";
    protected int mInstanceIndex;
    protected String[] mConfigFiles;
    protected List<String> mApplicationIDs;
    protected ClientLogger mLogger;
    protected JobRunner mRenderer;
    protected ILoadBalancer mLoadBalancer;
    protected long mDefaultSleep;
    protected long mReceiveTimeout;
    protected long mDefaultOutputLimit;
    protected boolean mShuttingdown;
    protected Thread mMainQueueThread;
    protected Map<String, JobRunner> mJobMap = new HashMap<String, JobRunner>();
    protected Timer mHeartbeatTimer;
    protected long mStartTime;
    protected int mCumulativeJobCount;
    protected Properties mConfigProperties;
    protected JmsTemplate mJobQueue;
    protected JmsTemplate mResultsQueue;
    protected JmsTemplate mOutputQueue;
    protected JmsTemplate mBroadcastTopic;
    protected TopicConnection mTopicConnection;
    protected TopicSession mTopicSession;
    protected MessageConsumer mTopicConsumer;
    protected DefaultMessageListenerContainer mTopicListener;
    protected MessageProducer mTopicProducer;
    protected ConnectionFactory mTopicFactory;
    protected ConnectionFactory mQueueFactory;

    public JMSClientSupport(Properties configProperties, ClientLogger logger, JobRunner runner, ILoadBalancer balancer) {
        this.mConfigProperties = configProperties;
        this.mLogger = logger;
        this.mStartTime = System.currentTimeMillis();
        this.mCumulativeJobCount = 0;
        this.mRenderer = runner;
        balancer.setClientSupport(this);
        List<String> applicationIDs = runner.getApplicationIDs();
        if (applicationIDs.size() == 0) {
            logger.logMessage(Level.SEVERE, "There are no application ids specified for \"" + runner.getName() + "\" renderer");
        }
        this.mApplicationIDs = new ArrayList<String>();
        for (String id : applicationIDs) {
            this.mApplicationIDs.add(id);
        }
        this.mLoadBalancer = balancer;
        this.mDefaultSleep = IPUtilities.getLongValue(configProperties, Config_PollFrequency, 10000L, logger);
        this.mReceiveTimeout = IPUtilities.getLongValue(configProperties, Config_ReceiveTimeout, 10000L, logger);
        this.mDefaultOutputLimit = IPUtilities.getLongValue(configProperties, Config_OutputLimit, 50000L, logger);
        this.mShuttingdown = false;
        this.mLogger.logMessage(Level.INFO, "JMS Factory: " + configProperties.getProperty("java.naming.factory.initial", "Not configured"));
        this.mLogger.logMessage(Level.INFO, "JMS URL: " + configProperties.getProperty("java.naming.provider.url", "Not configured"));
        this.mLogger.logMessage(Level.INFO, "JMS UserID: " + configProperties.getProperty("JMSSecurityUserid", "No user"));
        this.mLogger.logMessage(Level.FINEST, "JMS Password: " + configProperties.getProperty("JMSSecurityPasswd", "No password"));
        this.mLogger.logMessage(Level.INFO, "JobRunner-Default sleep: " + this.mDefaultSleep);
        this.mLogger.logMessage(Level.INFO, "JobRunner-Receive timeout: " + this.mReceiveTimeout);
        this.mLogger.logMessage(Level.INFO, "JobRunner-stdout/stderr output limit: " + this.mDefaultOutputLimit);
        this.mLogger.logMessage(Level.INFO, "JobRunner-Load balancer info: " + this.mLoadBalancer.toString());
        this.mLogger.logMessage(Level.INFO, "Job runner properties: " + this.mRenderer.toString());
        Runtime.getRuntime().addShutdownHook(new Thread("DIP-Auto Shutdown"){

            @Override
            public void run() {
                JMSClientSupport.this.shutdown(0L);
                JMSClientSupport.this.mLogger.logMessage(Level.INFO, "Scheduling jobserver " + JMSClientSupport.this.mRenderer.getID() + " gracefully shut down");
            }
        });
        this.initialize();
        this.mLogger.logMessage(Level.INFO, "Job renderer ready");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initJMS(int attempts) {
        if (attempts <= 0) {
            attempts = 1;
        }
        int SLEEP_TIME = 30;
        int LOG_MESSAGE_PER_TRIES = 4;
        int retryCount = 0;
        while (true) {
            block14: {
                this.cleanupJMSObjects();
                JMSClientSupport jMSClientSupport = this;
                synchronized (jMSClientSupport) {
                    if (this.mShuttingdown) {
                        break;
                    }
                }
                try {
                    InitialContext jmsContext = this.initJMSContext();
                    this.mJobQueue = new JmsTemplate(this.mQueueFactory);
                    JMSExecutionProvider.configureQueue(jmsContext, this.mJobQueue, "jms/scheduler.pip.jobQueue", this.mLogger);
                    this.mJobQueue.setReceiveTimeout(this.mReceiveTimeout);
                    this.mResultsQueue = new JmsTemplate(this.mQueueFactory);
                    JMSExecutionProvider.configureQueue(jmsContext, this.mResultsQueue, "jms/scheduler.pip.resultsQueue", this.mLogger);
                    this.mResultsQueue.setTimeToLive(604800000L);
                    this.mResultsQueue.setExplicitQosEnabled(true);
                    this.mResultsQueue.setDeliveryMode(2);
                    this.mOutputQueue = new JmsTemplate(this.mQueueFactory);
                    JMSExecutionProvider.configureQueue(jmsContext, this.mOutputQueue, "jms/scheduler.pip.outputQueue", this.mLogger);
                    this.mOutputQueue.setTimeToLive(604800000L);
                    this.mOutputQueue.setExplicitQosEnabled(true);
                    this.mOutputQueue.setDeliveryMode(2);
                    this.initJMSTopic(jmsContext);
                    break;
                }
                catch (NamingException e) {
                    if (++retryCount > attempts) {
                        throw new IllegalStateException("Failed to lookup required JMS objects in JNDI.", e);
                    }
                }
                catch (JMSException e) {
                    if (++retryCount > attempts) {
                        throw new IllegalStateException("Failed to initialize required JMS objects.", e);
                    }
                }
                catch (IllegalStateException e) {
                    if (++retryCount <= attempts) break block14;
                    throw e;
                }
            }
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (retryCount % 4 != 0) continue;
            this.mLogger.logMessage(Level.INFO, "Have received " + retryCount + " failures attempting to initialize required JMS objects for Distributed-IP scheduler job runner: " + this.mRenderer.getName());
        }
        this.mLogger.logMessage(Level.INFO, "Successfully initialized required JMS objects for Distributed-IP scheduler job runner: " + this.mRenderer.getID());
    }

    private InitialContext initJMSContext() throws NamingException {
        InitialContext jmsContext = JMSExecutionProvider.initializeJMSContext(this.mConfigProperties);
        this.mQueueFactory = JMSExecutionProvider.getFactory(jmsContext, "jms/QueueConnectionFactory", JMSExecutionProvider.Queue_Factory_Simple);
        this.mTopicFactory = JMSExecutionProvider.getFactory(jmsContext, "jms/TopicConnectionFactory", JMSExecutionProvider.Topic_Factory_Simple);
        if (JMSExecutionProvider.areCredentialsProvided(this.mConfigProperties)) {
            this.mQueueFactory = JMSExecutionProvider.configureSecurity(this.mQueueFactory, this.mConfigProperties);
            this.mTopicFactory = JMSExecutionProvider.configureSecurity(this.mTopicFactory, this.mConfigProperties);
        }
        return jmsContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initJMSTopic(InitialContext jmsContext) throws JMSException {
        Object object = JMSClusterSupport.GlobalJMSSyncObject;
        synchronized (object) {
            if (this.mTopicSession != null) {
                try {
                    MapMessage tempMessage = this.mTopicSession.createMapMessage();
                    return;
                }
                catch (Exception tempMessage) {
                    // empty catch block
                }
            }
            this.cleanupJMSTopic();
            this.mTopicConnection = (TopicConnection)this.mTopicFactory.createConnection();
            if (this.mTopicConnection == null) {
                throw new IllegalStateException("Failed to create JMS topic connection.");
            }
            this.mBroadcastTopic = new JmsTemplate(this.mTopicFactory);
            this.mTopicSession = (TopicSession)this.mTopicConnection.createSession(false, 1);
            if (this.mTopicSession == null) {
                throw new IllegalStateException("Failed to create JMS topic session.");
            }
            Topic broadcastTopic = JMSExecutionProvider.configureTopic(jmsContext, this.mBroadcastTopic, this.mTopicSession, "jms/scheduler.pip.broadcastTopic", this.mLogger);
            this.mTopicProducer = this.mTopicSession.createPublisher(broadcastTopic);
            if (this.mTopicProducer == null) {
                throw new IllegalStateException("Failed to create broadcast JMS topic publisher.");
            }
            this.mTopicProducer.setTimeToLive(600000L);
            this.mTopicProducer.setDeliveryMode(1);
            TopicSession consumerSession = (TopicSession)this.mTopicConnection.createSession(false, 1);
            if (consumerSession == null) {
                throw new IllegalStateException("Failed to create JMS topic session.");
            }
            Topic broadcastTopic2 = JMSExecutionProvider.configureTopic(jmsContext, this.mBroadcastTopic, consumerSession, "jms/scheduler.pip.broadcastTopic", this.mLogger);
            this.mTopicConsumer = consumerSession.createSubscriber(broadcastTopic2);
            if (this.mTopicConsumer == null) {
                throw new IllegalStateException("Failed to create broadcast JMS topic subscriber.");
            }
            this.mTopicListener = new DefaultMessageListenerContainer();
            this.mTopicListener.setConnectionFactory(this.mTopicFactory);
            this.mTopicListener.setDestination((Destination)broadcastTopic2);
            this.mTopicListener.setMessageListener((Object)new MessageListener(){

                public void onMessage(Message msg) {
                    JMSClientSupport.this.processBroadcastMessage(msg);
                }
            });
            this.mTopicListener.afterPropertiesSet();
            this.mTopicListener.start();
            this.mTopicConnection.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cleanupJMSTopic() {
        Object object = JMSClusterSupport.GlobalJMSSyncObject;
        synchronized (object) {
            try {
                if (this.mTopicConnection != null) {
                    this.mTopicConnection.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.mTopicListener != null) {
                    this.mTopicListener.stop();
                    this.mTopicListener.shutdown();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.mTopicProducer != null) {
                    this.mTopicProducer.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.mTopicConsumer != null) {
                    this.mTopicConsumer.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.mTopicSession != null) {
                    this.mTopicSession.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mTopicConsumer = null;
            this.mTopicConnection = null;
            this.mTopicProducer = null;
            this.mTopicListener = null;
            this.mTopicSession = null;
            this.mBroadcastTopic = null;
        }
    }

    private synchronized void cleanupJMSObjects() {
        this.cleanupJMSTopic();
        this.mJobQueue = null;
        this.mResultsQueue = null;
        this.mOutputQueue = null;
        this.mQueueFactory = null;
        this.mTopicFactory = null;
    }

    private synchronized MapMessage safeCreateMapMessage() throws JMSException, NamingException {
        if (this.mTopicSession == null) {
            this.mLogger.logMessage(Level.FINE, this.getClass().getName() + ": TopicSession is null.  Reconnecting to JMS.");
            this.initJMSTopic(this.initJMSContext());
        }
        MapMessage message = null;
        try {
            message = this.mTopicSession.createMapMessage();
        }
        catch (javax.jms.IllegalStateException e) {
            this.mLogger.logMessage(Level.FINE, this.getClass().getName() + ": TopicSession is closed.  Reconnecting to JMS.");
            this.initJMSTopic(this.initJMSContext());
            message = this.mTopicSession.createMapMessage();
        }
        return message;
    }

    protected void initialize() {
        this.initJMS(60000);
        this.mHeartbeatTimer = new Timer("PIP-Heartbeat");
        this.mHeartbeatTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    StringBuffer tempRendevousIDs = new StringBuffer();
                    Map<String, JobRunner> map = JMSClientSupport.this.mJobMap;
                    synchronized (map) {
                        for (String id : JMSClientSupport.this.mJobMap.keySet()) {
                            tempRendevousIDs.append(id);
                            tempRendevousIDs.append(",");
                        }
                    }
                    String currentRendevousIDs = tempRendevousIDs.toString();
                    JMSClientSupport jMSClientSupport = JMSClientSupport.this;
                    synchronized (jMSClientSupport) {
                        MapMessage message = JMSClientSupport.this.safeCreateMapMessage();
                        message.setStringProperty("resultType", "Heartbeat");
                        StringBuffer appIDs = new StringBuffer();
                        for (String id : JMSClientSupport.this.mApplicationIDs) {
                            appIDs.append(id);
                            appIDs.append(",");
                        }
                        message.setStringProperty("ApplicationIDList", appIDs.toString());
                        message.setStringProperty("rendererID", JMSClientSupport.this.mRenderer.getID());
                        message.setLongProperty("timeStamp", System.currentTimeMillis());
                        message.setStringProperty("rendevousIDList", currentRendevousIDs);
                        message.setLongProperty("upTime", System.currentTimeMillis() - JMSClientSupport.this.mStartTime);
                        message.setLongProperty("totalJobs", (long)JMSClientSupport.this.mCumulativeJobCount);
                        JMSClientSupport.this.mTopicProducer.send((Message)message);
                    }
                    String msg = "Heartbeat sent: JobIDs=" + currentRendevousIDs.toString() + " AppIDs=" + JMSClientSupport.this.mApplicationIDs.toString();
                    JMSClientSupport.this.mLogger.logMessage(Level.FINEST, msg);
                }
                catch (Exception e) {
                    JMSClientSupport.this.mLogger.logMessage(Level.WARNING, e);
                }
            }
        }, 0L, 60000L);
        this.mMainQueueThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean exceptionOccurred = false;
                StringBuffer buffer = new StringBuffer();
                boolean first = true;
                buffer.append("(");
                for (String appID : JMSClientSupport.this.mApplicationIDs) {
                    if (!first) {
                        buffer.append(" OR ");
                    }
                    buffer.append("applicationID='" + appID + "'");
                    first = false;
                }
                buffer.append(")");
                String messageSelector = buffer.toString();
                boolean inWaitState = true;
                block16: while (true) {
                    Object object;
                    try {
                        while (true) {
                            boolean shuttingDown = false;
                            object = JMSClientSupport.this;
                            synchronized (object) {
                                shuttingDown = JMSClientSupport.this.mShuttingdown;
                            }
                            if (shuttingDown) {
                                object = JMSClientSupport.this.mJobMap;
                                synchronized (object) {
                                    if (JMSClientSupport.this.mJobMap.size() == 0) {
                                        break block16;
                                    }
                                }
                                Thread.sleep(2000L);
                                continue;
                            }
                            if (!JMSClientSupport.this.mLoadBalancer.canTakeOnWork()) {
                                Thread.sleep(JMSClientSupport.this.mDefaultSleep);
                                inWaitState = false;
                                continue;
                            }
                            Message msg = (Message)JMSClientSupport.this.mJobQueue.browseSelected(messageSelector, (BrowserCallback)new BrowserCallback<Message>(){

                                public Message doInJms(Session arg0, QueueBrowser arg1) throws JMSException {
                                    Enumeration items = arg1.getEnumeration();
                                    int maxPriority = -1;
                                    Message bestMessage = null;
                                    long currentTime = System.currentTimeMillis();
                                    while (items.hasMoreElements()) {
                                        Object o = items.nextElement();
                                        if (!(o instanceof Message)) continue;
                                        try {
                                            int messagePriority = ((Message)o).getIntProperty("priority");
                                            long messagePosted = ((Message)o).getJMSTimestamp();
                                            messagePriority = (int)((long)messagePriority + (currentTime - messagePosted) / 1000L / 60L);
                                            try {
                                                JobResourceRequirements req;
                                                String tempJobReqXML = ((Message)o).getStringProperty("jobResourceRequirementsString");
                                                if (tempJobReqXML != null && !(req = JobResourceRequirements.createFromSerializedForm(tempJobReqXML)).matchesJobRunner(JMSClientSupport.this.mRenderer.getID())) {
                                                    String rendevousID = ((Message)o).getStringProperty("rendevousID");
                                                    JMSClientSupport.this.mLogger.logMessage(Level.FINEST, "Can't run job (" + rendevousID + ") on this job runner due to job runner id restriction; skipping.");
                                                    continue;
                                                }
                                            }
                                            catch (Throwable e) {
                                                JMSClientSupport.this.mLogger.logMessage(Level.WARNING, e);
                                            }
                                            if (messagePriority <= maxPriority) continue;
                                            bestMessage = (Message)o;
                                            maxPriority = messagePriority;
                                        }
                                        catch (JMSException jMSException) {}
                                    }
                                    return bestMessage;
                                }
                            });
                            if (msg == null) {
                                Thread.sleep(JMSClientSupport.this.mDefaultSleep);
                                inWaitState = false;
                                continue;
                            }
                            final String rendevousID = msg.getStringProperty("rendevousID");
                            if (rendevousID == null) continue;
                            final String callbackServerID = msg.getStringProperty("CallbackServer");
                            if (inWaitState) {
                                String tempJobXML = msg.getStringProperty("jobXML");
                                Job tempJob = Job.createFromXML(new BufferedReader(new StringReader(tempJobXML)), JMSClientSupport.this.mLogger);
                                long sleepTime = JMSClientSupport.this.mLoadBalancer.getWaitTime(tempJob);
                                if (sleepTime < 0L) {
                                    Thread.sleep(JMSClientSupport.this.mDefaultSleep);
                                    continue;
                                }
                                Thread.sleep(sleepTime);
                                inWaitState = false;
                            }
                            if ((msg = JMSClientSupport.this.mJobQueue.receiveSelected(messageSelector + " AND " + "rendevousID" + "='" + rendevousID + "'")) != null) {
                                inWaitState = true;
                                ++JMSClientSupport.this.mCumulativeJobCount;
                                String jobXML = msg.getStringProperty("jobXML");
                                final String outputAreaName = msg.getStringProperty("outputSavePath");
                                final Job j = Job.createFromXML(new BufferedReader(new StringReader(jobXML)), JMSClientSupport.this.mLogger);
                                JMSClientSupport.this.mLogger.logMessage(Level.FINE, "Grabbed job off job queue: " + j.getCommand() + " (" + rendevousID + ")");
                                WorkerThreadInterface workThread = ThreadPool.instance().executeAsynchronously(new Runnable(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void run() {
                                        Map<String, JobRunner> map = JMSClientSupport.this.mJobMap;
                                        synchronized (map) {
                                            JMSClientSupport.this.mJobMap.put(rendevousID, JMSClientSupport.this.mRenderer);
                                        }
                                        JMSClientSupport.this.mResultsQueue.convertAndSend((Object)new Object[0], new MessagePostProcessor(){

                                            public Message postProcessMessage(Message message) throws JMSException {
                                                message.setStringProperty("resultType", "START");
                                                message.setStringProperty("rendererID", JMSClientSupport.this.mRenderer.getID());
                                                message.setLongProperty("timeStamp", System.currentTimeMillis());
                                                message.setStringProperty("rendevousID", rendevousID);
                                                message.setStringProperty("CallbackServer", callbackServerID);
                                                return message;
                                            }
                                        });
                                        int exitCode = 0;
                                        int endStatus = 8;
                                        PrintStream outputStream = null;
                                        PrintStream errorStream = null;
                                        try {
                                            outputStream = j.isCaptureOutputStream() ? new PrintStream(new JobPrintStream2(new QueueOutputStream(new QueueWriter(JMSClientSupport.this.mOutputQueue, callbackServerID), "STDOUT", rendevousID, outputAreaName, 8192, JMSClientSupport.this.getDefaultOutputLimit()))) : new PrintStream(new NullOutputStream());
                                            errorStream = j.isCaptureErrorStream() ? new PrintStream(new JobPrintStream2(new QueueOutputStream(new QueueWriter(JMSClientSupport.this.mOutputQueue, callbackServerID), "STDERR", rendevousID, outputAreaName, 8192, JMSClientSupport.this.getDefaultOutputLimit()))) : new PrintStream(new NullOutputStream());
                                            JMSClientSupport.this.mLogger.logMessage(Level.FINE, "Rendering job: " + j.getCommand() + " (" + rendevousID + ")");
                                            exitCode = JMSClientSupport.this.mRenderer.runJob(j, rendevousID, outputStream, errorStream);
                                            JMSClientSupport.this.mLogger.logMessage(Level.FINE, "Rendering job complete: " + j.getCommand() + " (" + rendevousID + ") exitCode=" + exitCode);
                                            endStatus = 4;
                                        }
                                        catch (InterruptedException e) {
                                            endStatus = 1;
                                            JMSClientSupport.this.mLogger.logMessage(Level.FINE, "Rendering job killed: " + j.getCommand() + " (" + rendevousID + ")");
                                        }
                                        catch (Throwable e) {
                                            endStatus = 128;
                                            JMSClientSupport.this.mLogger.logMessage(Level.FINE, "Rendering job failed: " + j.getCommand() + " (" + rendevousID + ")");
                                        }
                                        finally {
                                            if (outputStream != null) {
                                                outputStream.close();
                                            }
                                            if (errorStream != null) {
                                                errorStream.close();
                                            }
                                        }
                                        Map<String, JobRunner> e = JMSClientSupport.this.mJobMap;
                                        synchronized (e) {
                                            JMSClientSupport.this.mJobMap.remove(rendevousID);
                                        }
                                        final int status = endStatus;
                                        final int rc = exitCode;
                                        JMSClientSupport.this.mResultsQueue.convertAndSend((Object)new Object[0], new MessagePostProcessor(){

                                            public Message postProcessMessage(Message message) throws JMSException {
                                                message.setStringProperty("resultType", "FINISH");
                                                message.setLongProperty("timeStamp", System.currentTimeMillis());
                                                message.setStringProperty("rendevousID", rendevousID);
                                                message.setIntProperty("status", status);
                                                message.setIntProperty("exitCode", rc);
                                                message.setStringProperty("CallbackServer", callbackServerID);
                                                return message;
                                            }
                                        });
                                    }
                                });
                                int priority = 5;
                                if (j.getPriority() >= 100) {
                                    priority = 10;
                                }
                                workThread.setPriority(priority);
                            }
                            exceptionOccurred = false;
                        }
                    }
                    catch (Exception e) {
                        if (exceptionOccurred) {
                            JMSClientSupport.this.mLogger.logMessage(Level.FINE, "JMS error occurred while trying to retrieve a potential job to run from the Job queue.  Is the JMS queue server running on the port specified in the configuration?");
                            JMSClientSupport.this.mLogger.logMessage(Level.FINE, e);
                        } else {
                            JMSClientSupport.this.mLogger.logMessage(Level.WARNING, "JMS error occurred while trying to retrieve a potential job to run from the Job queue.  Is the JMS queue server running on the port specified in the configuration?");
                            JMSClientSupport.this.mLogger.logMessage(Level.WARNING, e);
                            exceptionOccurred = true;
                        }
                        try {
                            Thread.sleep(30000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (!(e instanceof JMSException) && !(e instanceof JmsException)) continue;
                        try {
                            object = JMSClientSupport.this;
                            synchronized (object) {
                                JMSClientSupport.this.initJMS(1);
                                continue;
                            }
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    break;
                }
            }
        }, "DIP-Job receiver");
        this.mMainQueueThread.start();
    }

    public JobRunner getRenderer() {
        return this.mRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCurrentJobCount() {
        Map<String, JobRunner> map = this.mJobMap;
        synchronized (map) {
            return this.mJobMap.size();
        }
    }

    public long getDefaultOutputLimit() {
        return this.mDefaultOutputLimit;
    }

    public void setDefaultOutputLimit(long defaultOutputLimit) {
        this.mDefaultOutputLimit = defaultOutputLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(long timeout) {
        JMSClientSupport jMSClientSupport = this;
        synchronized (jMSClientSupport) {
            this.mShuttingdown = true;
        }
        try {
            this.cleanupJMSObjects();
            if (this.mHeartbeatTimer != null) {
                this.mHeartbeatTimer.cancel();
            }
            if (this.mMainQueueThread != null) {
                this.mMainQueueThread.join(timeout / 2L);
            }
            ThreadPool.instance().completeShutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void processBroadcastMessage(Message message) {
        try {
            String rendevousID = message.getStringProperty("rendevousID");
            if (rendevousID == null) {
                return;
            }
            String messageType = message.getStringProperty("resultType");
            if (messageType == null) {
                return;
            }
            if (messageType.equals("KillRequest")) {
                this.mLogger.logMessage(Level.FINE, "kill job request received for: " + rendevousID);
                boolean force = false;
                String forceFlag = message.getStringProperty("forceKill");
                if (forceFlag != null) {
                    force = Boolean.parseBoolean(forceFlag);
                }
                this.getRenderer().killJob(rendevousID, force);
            }
        }
        catch (Exception e) {
            this.mLogger.logMessage(Level.WARNING, e);
        }
    }
}

