/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine.jgroups;

import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.servers.ip.engine.AbstractUserSession;
import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.ClusterSupport;
import com.sas.scheduler.api.servers.ip.engine.DeferredManagerAction;
import com.sas.scheduler.api.servers.ip.engine.ExecutionContext;
import com.sas.scheduler.api.servers.ip.engine.ExecutionProviderBase;
import com.sas.scheduler.api.servers.ip.engine.FlowHistory;
import com.sas.scheduler.api.servers.ip.engine.FlowInstance;
import com.sas.scheduler.api.servers.ip.engine.FlowManager;
import com.sas.scheduler.api.servers.ip.engine.HistorySearchOptions;
import com.sas.scheduler.api.servers.ip.engine.Job;
import com.sas.scheduler.api.servers.ip.engine.JobRendererInfo;
import com.sas.scheduler.api.servers.ip.engine.JobResourceRequirements;
import com.sas.scheduler.api.servers.ip.engine.MasterServer;
import com.sas.scheduler.api.servers.ip.engine.RunningJob;
import com.sas.scheduler.api.servers.ip.engine.RunningJobResourceRequirements;
import com.sas.scheduler.api.servers.ip.engine.ShutdownException;
import com.sas.scheduler.api.servers.ip.engine.TopLevelFlow;
import com.sas.scheduler.api.servers.ip.engine.TopLevelFlowIDInfo;
import com.sas.scheduler.api.servers.ip.engine.UserInfo;
import com.sas.scheduler.api.servers.ip.engine.jgroups.JGroupsExecutionContext;
import com.sas.scheduler.api.servers.ip.engine.jgroups.JGroupsMasterServer;
import com.sas.scheduler.api.servers.ip.engine.jgroups.ResponseHolder;
import com.sas.scheduler.api.servers.ip.engine.threadpool.ThreadPool;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Level;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.ReplicatedHashtable;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

public class JGroupsClusterSupport
extends ClusterSupport {
    public static final String Default_Cluster_Name = "D-IPScheduler";
    public static final String Config_HashChannelPort = "PIP.JGroupsPort_HashChannelPort";
    public static final String Config_MainChannelPort = "PIP.JGroupsPort_MainChannelPort";
    public static final String Config_JGroupsAddress = "PIP.JGroupsMulticastAddress";
    protected static final String MasterKey = "MasterKey";
    protected static final String SessionKey = "SessionKey";
    protected static final String UserKey = "UserKey";
    protected static final String TriggerTimesKey = "TriggerTimesKey";
    protected String mGroupName;
    protected Channel mChannel;
    protected JChannel mHashChannel;
    protected JChannel mExecutionChannel;
    protected MessageDispatcher mDispatcher;
    protected MessageDispatcher mExecutionDispatcher;
    protected String mChannelPropertiesString;
    protected Random mRandom;
    protected ReplicatedHashtable mDataHash;
    protected volatile boolean mIsMaster;
    protected long mTimeOutMS;
    protected boolean mSchedulersAreJobServers = false;
    protected boolean mIsLimitingMasters;
    protected boolean mIsStaticMaster;
    protected boolean mIsEligibleMaster;
    protected Properties mServerProperties;
    protected int mMainPort;
    protected int mHashPort;
    protected ClientLogger mLogger;
    protected Map<String, ResponseHolder> mResponderMap;

    public JGroupsClusterSupport(String jgroupName, String channelProperties, long timeout, boolean jobServersAreSeparate, boolean limitingMasters, Properties serverProperties, int mainPort, int hashPort, ClientLogger logger) throws ChannelException {
        this.mChannelPropertiesString = channelProperties;
        this.mSchedulersAreJobServers = !jobServersAreSeparate;
        this.mIsStaticMaster = false;
        this.mIsLimitingMasters = limitingMasters;
        this.mIsEligibleMaster = false;
        this.mServerProperties = serverProperties;
        this.mLogger = logger;
        this.mMainPort = mainPort;
        this.mHashPort = hashPort;
        this.initialize(jgroupName, channelProperties, timeout);
    }

    public JGroupsClusterSupport(String jgroupName, String channelProperties, long timeout, int mainPort, int hashPort) throws ChannelException {
        this.mChannelPropertiesString = channelProperties;
        this.mIsStaticMaster = false;
        this.mIsLimitingMasters = false;
        this.mIsEligibleMaster = true;
        this.mSchedulersAreJobServers = true;
        this.mLogger = FlowManager.getDefaultLogger();
        this.mMainPort = mainPort;
        this.mHashPort = hashPort;
        this.initialize(jgroupName, channelProperties, timeout);
    }

    public JGroupsClusterSupport(String jgroupName, String channelProperties, long timeout) throws ChannelException {
        this.mChannelPropertiesString = channelProperties;
        this.mIsStaticMaster = false;
        this.mIsLimitingMasters = false;
        this.mIsEligibleMaster = true;
        this.mSchedulersAreJobServers = true;
        this.mLogger = FlowManager.getDefaultLogger();
        this.mMainPort = -1;
        this.mHashPort = -1;
        this.initialize(jgroupName, channelProperties, timeout);
    }

    protected void initialize(String jgroupName, String channelProperties, long timeout) throws ChannelException {
        if (this.mServerProperties == null) {
            this.mServerProperties = new Properties();
        }
        this.mLogger.logMessage(Level.INFO, "DIP: Initializing JGroups cluster support: " + jgroupName);
        this.mIsMaster = false;
        this.mRandom = new Random();
        this.mGroupName = jgroupName;
        this.mTimeOutMS = timeout;
        this.mResponderMap = new HashMap<String, ResponseHolder>();
        long startTime = System.currentTimeMillis();
        this.createMainChannel(channelProperties);
        this.initMainChannel();
        this.createHashChannel(channelProperties);
        this.initHashChannel();
        long endTime = System.currentTimeMillis();
        this.mLogger.logMessage(Level.FINE, "Time to create channels=" + (endTime - startTime));
        if (this.mSchedulersAreJobServers && this.mExecutionChannel == null) {
            this.createExecutionChannel(channelProperties);
            this.initExecutionChannel();
        }
        this.createDispatcher();
        if (this.mIsLimitingMasters) {
            this.becomeMaster(false);
        } else {
            Address masterAddress = (Address)this.mChannel.getView().getMembers().get(0);
            this.mDataHash.put((Object)MasterKey, (Object)masterAddress);
            this.updateMasterStatus(masterAddress, false);
        }
    }

    protected void initHashChannel() throws ChannelException {
        this.mHashChannel.setOpt(6, (Object)Boolean.TRUE);
        this.mHashChannel.setOpt(5, (Object)Boolean.TRUE);
        this.mHashChannel.connect(this.mGroupName + "Hash");
        this.mDataHash = new ReplicatedHashtable(this.mHashChannel, this.mTimeOutMS);
    }

    protected void initMainChannel() throws ChannelException {
        this.mChannel.setOpt(6, (Object)Boolean.TRUE);
        this.mChannel.setOpt(5, (Object)Boolean.TRUE);
        this.mChannel.connect(this.mGroupName);
    }

    protected void initExecutionChannel() throws ChannelException {
        this.mExecutionChannel.setOpt(6, (Object)Boolean.TRUE);
        this.mExecutionChannel.setOpt(5, (Object)Boolean.TRUE);
        this.mExecutionChannel.setOpt(4, (Object)Boolean.TRUE);
        this.mExecutionChannel.connect(this.mGroupName + "Execution");
    }

    protected void createHashChannel(String channelProperties) throws ChannelException {
        if (this.mHashPort > 0) {
            channelProperties = JGroupsClusterSupport.changeCurrentPort(channelProperties, this.mHashPort);
        }
        this.mHashChannel = new JChannel(channelProperties);
    }

    protected void createDispatcher() {
        this.mDispatcher = new MessageDispatcher(this.mChannel, null, null);
        this.mDispatcher.setRequestHandler((RequestHandler)new MyRequestHandler(this));
        this.mDispatcher.setMembershipListener((MembershipListener)new ClusterMembershipListener(this));
        if (this.mExecutionChannel != null) {
            this.mExecutionDispatcher = new MessageDispatcher((Channel)this.mExecutionChannel, null, null);
            this.mExecutionDispatcher.setRequestHandler((RequestHandler)new MyRequestHandler(this));
        }
    }

    protected void createExecutionChannel(String channelProperties) throws ChannelException {
        if (this.mMainPort > 0) {
            channelProperties = JGroupsClusterSupport.changeCurrentPort(channelProperties, this.mMainPort + 2);
        }
        this.mExecutionChannel = new JChannel(channelProperties);
        this.mExecutionChannel.setOpt(5, (Object)Boolean.TRUE);
        this.mExecutionChannel.connect(this.mGroupName + "Execution");
    }

    protected void createMainChannel(String channelProperties) throws ChannelException {
        if (this.mMainPort > 0) {
            channelProperties = JGroupsClusterSupport.changeCurrentPort(channelProperties, this.mMainPort);
        }
        this.mChannel = new JChannel(channelProperties);
        this.mChannel.setOpt(4, (Object)Boolean.TRUE);
        this.mChannel.setOpt(5, (Object)Boolean.TRUE);
        this.mChannel.connect(this.mGroupName);
    }

    protected RspList sendMessage(Address target, Message message) {
        Vector<Address> targetMasterNode = new Vector<Address>();
        targetMasterNode.add(target);
        RspList response = this.getExecutionDispatcher().castMessage(targetMasterNode, message, 2, this.mTimeOutMS);
        return response;
    }

    boolean executeJob(Job j, String flowID, String flowInstanceID, String rendevousID, JGroupsExecutionContext context, UserInfo user) {
        if (!this.mSchedulersAreJobServers) {
            return false;
        }
        try {
            Message message = new Message();
            Object[] data = new Object[6];
            data[0] = "ExecuteJobOnWorker";
            data[1] = j.toSerializedForm();
            data[2] = rendevousID;
            if (user != null) {
                data[3] = user.toSerializedForm();
            }
            data[4] = flowInstanceID;
            data[5] = flowID;
            message.setObject((Serializable)data);
            this.sendMessage(context.getWorker(), message);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public MessageDispatcher getDispatcher() {
        return this.mDispatcher;
    }

    public MessageDispatcher getExecutionDispatcher() {
        return this.mExecutionDispatcher;
    }

    public Channel getChannel() {
        return this.mChannel;
    }

    protected void updateMasterStatus(Address currentMasterAddress, boolean allowInit) {
        if (currentMasterAddress != null && this.mChannel.getLocalAddress().equals(currentMasterAddress)) {
            if (!this.mIsMaster && allowInit) {
                this.updateWithMasterServerData();
            }
            this.mIsMaster = true;
        } else {
            this.mIsMaster = false;
            if (this.mManager != null) {
                this.mManager.getExecutionProvider().loseMastership();
            }
        }
    }

    @Override
    public MasterServer getMasterServer() {
        Address masterAddress = (Address)this.mDataHash.get((Object)MasterKey);
        View currentView = this.mChannel.getView();
        if (currentView == null) {
            return null;
        }
        if (this.mIsLimitingMasters) {
            if (masterAddress != null && currentView.containsMember(masterAddress)) {
                return new JGroupsMasterServer(this, masterAddress, null);
            }
            if (this.mIsEligibleMaster) {
                this.becomeMaster(true);
                masterAddress = (Address)this.mDataHash.get((Object)MasterKey);
                if (masterAddress != null && masterAddress.equals(this.mChannel.getLocalAddress())) {
                    return new JGroupsMasterServer(this, masterAddress, null);
                }
            }
            if (masterAddress != null) {
                try {
                    this.reinitialize();
                    masterAddress = (Address)this.mDataHash.get((Object)MasterKey);
                    currentView = this.mChannel.getView();
                    if (currentView.containsMember(masterAddress)) {
                        return new JGroupsMasterServer(this, masterAddress, null);
                    }
                }
                catch (Exception e) {
                    this.mLogger.logMessage(Level.WARNING, e);
                }
            }
            return null;
        }
        Address realMasterAddress = (Address)currentView.getMembers().get(0);
        if (masterAddress != null && masterAddress.equals(realMasterAddress)) {
            this.updateMasterStatus(masterAddress, true);
        } else {
            Address oldMaster = masterAddress;
            masterAddress = realMasterAddress;
            this.mManager.setServerUninitialized();
            this.mDataHash.put((Object)MasterKey, (Object)masterAddress);
            this.getManager().getLogger().logMessage(Level.INFO, "Moving master from " + oldMaster + " to " + masterAddress);
            this.updateMasterStatus(masterAddress, true);
        }
        return new JGroupsMasterServer(this, masterAddress, this.mExecutionChannel == null ? null : (Address)this.mExecutionChannel.getView().getMembers().get(0));
    }

    protected void redeployFlowsFromExternalSource() {
    }

    protected void updateWithMasterServerData() {
        Map sessionMap = (Map)this.mDataHash.get((Object)SessionKey);
        Map userMap = (Map)this.mDataHash.get((Object)UserKey);
        HashMap<String, AbstractUserSession> realSessionMap = new HashMap<String, AbstractUserSession>();
        HashMap<String, UserInfo> realUserMap = new HashMap<String, UserInfo>();
        if (userMap != null) {
            for (String userData : userMap.values()) {
                UserInfo info = UserInfo.createFromData(userData);
                if (info == null) continue;
                realUserMap.put(info.getUserID(), info);
            }
        }
        if (sessionMap != null) {
            for (String sessionData : sessionMap.values()) {
                AbstractUserSession session = this.mManager.getExecutionProvider().constructSession(sessionData);
                if (session == null) continue;
                session.setFlowManager(this.getManager());
                realSessionMap.put(session.getSessionID(), session);
            }
        }
        try {
            this.mManager.getExecutionProvider().assumeMastership();
            ((ExecutionProviderBase)this.mManager.getExecutionProvider()).resetUserAndSessionMaps(realUserMap, realSessionMap);
            this.mManager.initialize();
            this.redeployFlowsFromExternalSource();
        }
        catch (IllegalArgumentException e) {
            this.mManager.getLogger().logMessage(Level.WARNING, e);
        }
    }

    @Override
    public boolean isMasterServer() {
        if (!this.mIsEligibleMaster) {
            return false;
        }
        Address masterAddress = (Address)this.mDataHash.get((Object)MasterKey);
        if (masterAddress == null) {
            return false;
        }
        return masterAddress.equals(this.mChannel.getLocalAddress());
    }

    @Override
    public void killJob(RunningJob rj, boolean force) {
        Message message = new Message();
        Object[] data = new Object[]{"KillJob", rj.getUniqueInstanceID(), force};
        message.setObject((Serializable)data);
        Address workerNode = ((JGroupsExecutionContext)rj.getExecutionContext()).getWorker();
        Vector<Address> targetNode = new Vector<Address>();
        targetNode.add(workerNode);
        this.getExecutionDispatcher().castMessage(targetNode, message, 6, this.mTimeOutMS);
    }

    protected int getAcceptJobScore(RunningJobResourceRequirements j) {
        int score = this.mRandom.nextInt(100) + 2;
        if (this.isMasterServer()) {
            score -= 15;
        }
        score = Math.max(score, 1);
        return score;
    }

    private void postReplyMessage(Message message, Address target) {
        Vector<Address> targetMasterNode = new Vector<Address>();
        targetMasterNode.add(target);
        JGroupsClusterSupport cluster = (JGroupsClusterSupport)this.getManager().getExecutionProvider().getClusteringServer();
        cluster.getDispatcher().castMessage(targetMasterNode, message, 6, cluster.getTimeout());
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this.mChannel != null) {
            this.mChannel.close();
        }
        if (this.mHashChannel != null) {
            this.mHashChannel.close();
        }
        if (this.mExecutionChannel != null) {
            this.mExecutionChannel.close();
        }
        if (this.mDispatcher != null) {
            this.mDispatcher.stop();
        }
        if (this.mExecutionDispatcher != null) {
            this.mExecutionDispatcher.stop();
        }
    }

    @Override
    public ExecutionContext assignExecutionContext(RunningJob rj) {
        Message message = new Message();
        Object[] data = new Object[2];
        data[0] = "GetAcceptJobScore";
        JobResourceRequirements requirements = rj.getJob().getJobResourceRequirements();
        RunningJobResourceRequirements runningRequirements = null;
        runningRequirements = requirements == null ? new RunningJobResourceRequirements() : new RunningJobResourceRequirements(requirements);
        runningRequirements.setUser(rj.getUserName());
        runningRequirements.setCommandLine(rj.getJob().getCommand());
        data[1] = runningRequirements.toSerializedForm();
        message.setObject((Serializable)data);
        Rsp bestRsp = null;
        RspList response = this.getExecutionDispatcher().castMessage(null, message, 2, this.mTimeOutMS);
        for (Rsp rsp : response.values()) {
            int score;
            if (rsp.getValue() == null || (score = ((Integer)rsp.getValue()).intValue()) <= 0 || bestRsp != null && score <= (Integer)bestRsp.getValue()) continue;
            bestRsp = rsp;
        }
        if (bestRsp == null) {
            return null;
        }
        return new JGroupsExecutionContext(this, bestRsp.getSender());
    }

    @Override
    public void persistSessionHook(UserInfo user, AbstractUserSession session) {
        HashMap<String, String> sessionMap = (HashMap<String, String>)this.mDataHash.get((Object)SessionKey);
        HashMap<String, String> userMap = (HashMap<String, String>)this.mDataHash.get((Object)UserKey);
        if (sessionMap == null) {
            sessionMap = new HashMap<String, String>();
            this.mDataHash.put((Object)SessionKey, sessionMap);
        }
        if (userMap == null) {
            userMap = new HashMap<String, String>();
            this.mDataHash.put((Object)UserKey, userMap);
        }
        sessionMap.put(session.getSessionID(), session.toSerializedForm());
        userMap.put(user.getUserID(), user.toSerializedForm());
        this.mDataHash.put((Object)SessionKey, sessionMap);
        this.mDataHash.put((Object)UserKey, userMap);
    }

    @Override
    public void saveUsedTimes(String flowID, Map<String, Long> usedTimes) {
        HashMap<String, Map<String, Long>> currentHashTable = (HashMap<String, Map<String, Long>>)this.mDataHash.get((Object)TriggerTimesKey);
        if (currentHashTable == null) {
            currentHashTable = new HashMap<String, Map<String, Long>>();
            this.mDataHash.put((Object)TriggerTimesKey, currentHashTable);
        }
        currentHashTable.put(flowID, usedTimes);
        this.mDataHash.put((Object)TriggerTimesKey, currentHashTable);
    }

    @Override
    public Map<String, Map<String, Long>> getUsedTimesImpl() {
        Map currentHashTable = (Map)this.mDataHash.get((Object)TriggerTimesKey);
        if (currentHashTable != null) {
            HashMap<String, Map<String, Long>> copy = new HashMap<String, Map<String, Long>>();
            copy.putAll(currentHashTable);
            return copy;
        }
        return new HashMap<String, Map<String, Long>>();
    }

    @Override
    public boolean isEligibleMaster() {
        return this.mIsEligibleMaster;
    }

    public void setIsEligibleMaster() {
        this.mIsEligibleMaster = true;
        this.becomeMaster(false);
    }

    public void becomeMaster(boolean reinit) {
        if (this.mIsEligibleMaster && this.mIsLimitingMasters && this.getManager() != null) {
            try {
                this.getManager().getExecutionProvider().assumeMastership();
                this.mDataHash.put((Object)MasterKey, (Object)this.mChannel.getLocalAddress());
                this.updateMasterStatus(this.mChannel.getLocalAddress(), reinit);
                this.mLogger.logMessage(Level.INFO, "This node is now the master");
            }
            catch (Exception e) {
                this.mLogger.logMessage(Level.FINE, "Node failed to become master: " + this.mChannel.getLocalAddress());
            }
        }
    }

    public long getTimeout() {
        return this.mTimeOutMS;
    }

    public void setTimeout(long timeoutMS) {
        this.mTimeOutMS = timeoutMS;
    }

    @Override
    protected void setManager(FlowManager manager) {
        super.setManager(manager);
        this.becomeMaster(false);
    }

    protected static String changeCurrentPort(String channelProperties, int newPort) {
        int nextSemi;
        int mc;
        String searchString = "mcast_port=";
        if (channelProperties == null || channelProperties.length() == 0) {
            channelProperties = "UDP(down_thread=false;mcast_send_buf_size=640000;mcast_port=45566;discard_incompatible_packets=true;ucast_recv_buf_size=20000000;mcast_addr=228.10.10.10;up_thread=false;loopback=false;mcast_recv_buf_size=25000000;max_bundle_size=64000;max_bundle_timeout=30;use_incoming_packet_handler=true;use_outgoing_packet_handler=false;ucast_send_buf_size=640000;tos=16;enable_bundling=true;ip_ttl=2):PING(timeout=2000;down_thread=false;num_initial_members=3;up_thread=false):MERGE2(max_interval=10000;down_thread=false;min_interval=5000;up_thread=false):FD(timeout=2000;max_tries=3;down_thread=false;up_thread=false):VERIFY_SUSPECT(timeout=1500;down_thread=false;up_thread=false):pbcast.NAKACK(max_xmit_size=60000;down_thread=false;use_mcast_xmit=false;gc_lag=0;discard_delivered_msgs=true;up_thread=false;retransmit_timeout=100,200,300,600,1200,2400,4800):UNICAST(timeout=300,600,1200,2400,3600;down_thread=false;up_thread=false):pbcast.STABLE(stability_delay=1000;desired_avg_gossip=50000;max_bytes=400000;down_thread=false;up_thread=false):VIEW_SYNC(down_thread=false;avg_send_interval=60000;up_thread=false):pbcast.GMS(print_local_addr=true;join_timeout=3000;down_thread=false;join_retry_timeout=2000;up_thread=false;shun=true):FC(max_credits=2000000;down_thread=false;up_thread=false;min_threshold=0.10):FRAG2(frag_size=60000;down_thread=false;up_thread=false):pbcast.STATE_TRANSFER(down_thread=false;up_thread=false)";
        }
        if ((mc = channelProperties.indexOf(searchString)) >= 0 && (nextSemi = channelProperties.indexOf(59, mc)) >= 0) {
            int portNum = newPort;
            channelProperties = channelProperties.substring(0, mc + searchString.length()) + portNum + channelProperties.substring(nextSemi);
        }
        return channelProperties;
    }

    public void reinitialize() throws Exception {
        this.cleanup();
        this.initialize(this.mGroupName, this.mChannelPropertiesString, this.mTimeOutMS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResponder(Thread waitingThread, String guid) {
        Map<String, ResponseHolder> map = this.mResponderMap;
        synchronized (map) {
            this.mResponderMap.put(guid, new ResponseHolder(waitingThread));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponse(String guid, Object result) {
        Map<String, ResponseHolder> map = this.mResponderMap;
        synchronized (map) {
            ResponseHolder holder = this.mResponderMap.get(guid);
            if (holder != null) {
                holder.setResult(result);
                holder.clearThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getResponse(String guid) {
        Map<String, ResponseHolder> map = this.mResponderMap;
        synchronized (map) {
            ResponseHolder holder = this.mResponderMap.remove(guid);
            if (holder != null) {
                return holder.getResult();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasResponse(String guid) {
        Map<String, ResponseHolder> map = this.mResponderMap;
        synchronized (map) {
            ResponseHolder holder = this.mResponderMap.get(guid);
            if (holder != null) {
                return holder.isValueSet();
            }
            return false;
        }
    }

    static class OutputHolder {
        private int mCharsRead;
        private String mData;

        public OutputHolder(int charsRead, String data) {
            this.mCharsRead = charsRead;
            this.mData = data;
        }

        public int getCharsRead() {
            return this.mCharsRead;
        }

        public String getData() {
            return this.mData;
        }
    }

    static class MyRequestHandler
    implements RequestHandler {
        private JGroupsClusterSupport mClusterSupport;

        public MyRequestHandler(JGroupsClusterSupport clusterObject) {
            this.mClusterSupport = clusterObject;
        }

        public Object handle(Message msg) {
            Object data = msg.getObject();
            if (!(data instanceof Object[])) {
                return null;
            }
            try {
                Object[] elements = (Object[])data;
                final Address caller = msg.getSrc();
                final String opName = (String)elements[0];
                if (opName.equals("GetMasterServerConfig")) {
                    final String operationGUID = (String)elements[1];
                    ThreadPool.instance().executeAsynchronously(new Runnable(){

                        @Override
                        public void run() {
                            ((MyRequestHandler)this).mClusterSupport.mLogger.logMessage(Level.FINEST, "Using thread to perform JGroups cluster operation: " + opName);
                            Properties props = mClusterSupport.getManager().getServerConfig();
                            if (props == null) {
                                props = new Properties();
                            }
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            try {
                                props.store(out, "");
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            String propString = out.toString();
                            Message message = new Message();
                            Object[] data = new Object[]{"GetMasterServerConfig_Response", operationGUID, propString};
                            message.setObject((Serializable)data);
                            mClusterSupport.postReplyMessage(message, caller);
                        }
                    });
                    return null;
                }
                if (opName.equals("GetMasterServerConfig_Response")) {
                    this.mClusterSupport.mLogger.logMessage(Level.FINEST, "Performing JGroups cluster response operation: " + opName);
                    String guid = (String)elements[1];
                    this.mClusterSupport.setResponse(guid, elements[2]);
                } else {
                    if (opName.equals("GetFlowHistories")) {
                        final String sessionID = (String)elements[1];
                        final String[] flowIDs = (String[])elements[2];
                        final Integer countPerFlow = (Integer)elements[3];
                        final String operationGUID = (String)elements[4];
                        ThreadPool.instance().executeAsynchronously(new Runnable(){

                            @Override
                            public void run() {
                                ((MyRequestHandler)this).mClusterSupport.mLogger.logMessage(Level.FINEST, "Using thread to perform JGroups cluster operation: " + opName);
                                FlowHistory[] histories = mClusterSupport.getManager().getFlowHistories(sessionID, flowIDs, countPerFlow);
                                ArrayList<String> resultList = new ArrayList<String>();
                                for (int i = 0; i < histories.length; ++i) {
                                    FlowHistory history = histories[i];
                                    resultList.add(history.toSerializedForm());
                                }
                                Message message = new Message();
                                Object[] data = new Object[]{"GetFlowHistories_Response", operationGUID, resultList.toArray(new String[0])};
                                message.setObject((Serializable)data);
                                mClusterSupport.postReplyMessage(message, caller);
                            }
                        });
                        return operationGUID;
                    }
                    if (opName.equals("GetFlowHistories_Response")) {
                        this.mClusterSupport.mLogger.logMessage(Level.FINEST, "Performing JGroups cluster response operation: " + opName);
                        String guid = (String)elements[1];
                        this.mClusterSupport.setResponse(guid, elements[2]);
                    } else {
                        if (opName.equals("SearchHistory")) {
                            final String sessionID = (String)elements[1];
                            final String searchOptionsString = (String)elements[2];
                            final String operationGUID = (String)elements[3];
                            ThreadPool.instance().executeAsynchronously(new Runnable(){

                                @Override
                                public void run() {
                                    ((MyRequestHandler)this).mClusterSupport.mLogger.logMessage(Level.FINEST, "Using thread to perform JGroups cluster operation: " + opName);
                                    HistorySearchOptions options = HistorySearchOptions.createFromSerializedForm(searchOptionsString);
                                    ArrayList<String> resultList = new ArrayList<String>();
                                    if (options != null) {
                                        FlowHistory[] histories = mClusterSupport.getManager().getFlowHistory(sessionID, options);
                                        for (int i = 0; i < histories.length; ++i) {
                                            FlowHistory history = histories[i];
                                            resultList.add(history.toSerializedForm());
                                        }
                                    }
                                    Message message = new Message();
                                    Object[] data = new Object[]{"SearchHistory_Response", operationGUID, resultList.toArray(new String[0])};
                                    message.setObject((Serializable)data);
                                    mClusterSupport.postReplyMessage(message, caller);
                                }
                            });
                            return operationGUID;
                        }
                        if (opName.equals("SearchHistory_Response")) {
                            this.mClusterSupport.mLogger.logMessage(Level.FINEST, "Performing JGroups cluster response operation: " + opName);
                            String guid = (String)elements[1];
                            this.mClusterSupport.setResponse(guid, elements[2]);
                        } else {
                            if (opName.equals("GetFlowDefinitions")) {
                                final String sessionID = (String)elements[1];
                                final String[] flowIDs = (String[])elements[2];
                                final String operationGUID = (String)elements[3];
                                ThreadPool.instance().executeAsynchronously(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((MyRequestHandler)this).mClusterSupport.mLogger.logMessage(Level.FINEST, "Using thread to perform JGroups cluster operation: " + opName);
                                        TopLevelFlow[] flows = mClusterSupport.getManager().getFlowDefinitions(sessionID, flowIDs);
                                        ArrayList<String> resultList = new ArrayList<String>();
                                        for (int i = 0; i < flows.length; ++i) {
                                            TopLevelFlow flow = flows[i];
                                            resultList.add(flow.toSerializedForm());
                                        }
                                        Message message = new Message();
                                        Object[] data = new Object[]{"GetFlowDefinitions_Response", operationGUID, resultList.toArray(new String[0])};
                                        message.setObject((Serializable)data);
                                        mClusterSupport.postReplyMessage(message, caller);
                                    }
                                });
                                return operationGUID;
                            }
                            if (opName.equals("GetFlowDefinitions_Response")) {
                                this.mClusterSupport.mLogger.logMessage(Level.FINEST, "Performing JGroups cluster response operation: " + opName);
                                String guid = (String)elements[1];
                                this.mClusterSupport.setResponse(guid, elements[2]);
                            } else {
                                if (opName.equals("GetInstanceDefinitions")) {
                                    final String sessionID = (String)elements[1];
                                    final String[] instanceIDs = (String[])elements[2];
                                    final String operationGUID = (String)elements[3];
                                    ThreadPool.instance().executeAsynchronously(new Runnable(){

                                        @Override
                                        public void run() {
                                            ((MyRequestHandler)this).mClusterSupport.mLogger.logMessage(Level.FINEST, "Using thread to perform JGroups cluster operation: " + opName);
                                            FlowInstance[] flows = mClusterSupport.getManager().getInstanceDefinitions(sessionID, instanceIDs);
                                            ArrayList<String> resultList = new ArrayList<String>();
                                            for (int i = 0; i < flows.length; ++i) {
                                                FlowInstance flowInstance = flows[i];
                                                resultList.add(flowInstance.toSerializedForm());
                                            }
                                            Message message = new Message();
                                            Object[] data = new Object[]{"GetInstanceDefinitions_Response", operationGUID, resultList.toArray(new String[0])};
                                            message.setObject((Serializable)data);
                                            mClusterSupport.postReplyMessage(message, caller);
                                        }
                                    });
                                    return operationGUID;
                                }
                                if (opName.equals("GetInstanceDefinitions_Response")) {
                                    this.mClusterSupport.mLogger.logMessage(Level.FINEST, "Performing JGroups cluster response operation: " + opName);
                                    String guid = (String)elements[1];
                                    this.mClusterSupport.setResponse(guid, elements[2]);
                                } else {
                                    if (opName.equals("GetFlowByName")) {
                                        final String sessionID = (String)elements[1];
                                        final String flowName = (String)elements[2];
                                        final String operationGUID = (String)elements[3];
                                        ThreadPool.instance().executeAsynchronously(new Runnable(){

                                            @Override
                                            public void run() {
                                                ((MyRequestHandler)this).mClusterSupport.mLogger.logMessage(Level.FINEST, "Using thread to perform JGroups cluster operation: " + opName);
                                                String flowID = mClusterSupport.getManager().getFlowID(sessionID, flowName);
                                                Message message = new Message();
                                                Object[] data = new Object[]{"GetFlowByName_Response", operationGUID, flowID};
                                                message.setObject((Serializable)data);
                                                mClusterSupport.postReplyMessage(message, caller);
                                            }
                                        });
                                        return null;
                                    }
                                    if (opName.equals("GetFlowByName_Response")) {
                                        this.mClusterSupport.mLogger.logMessage(Level.FINEST, "Performing JGroups cluster response operation: " + opName);
                                        String guid = (String)elements[1];
                                        this.mClusterSupport.setResponse(guid, elements[2]);
                                    } else {
                                        if (opName.equals("GetOutputData")) {
                                            final String sessionID = (String)elements[1];
                                            final String flowID = (String)elements[2];
                                            final String instanceID = (String)elements[3];
                                            final String jobID = (String)elements[4];
                                            final Long startPos = (Long)elements[5];
                                            final Integer maxChars = (Integer)elements[6];
                                            final String operationGUID = (String)elements[7];
                                            ThreadPool.instance().executeAsynchronously(new Runnable(){

                                                @Override
                                                public void run() {
                                                    ((MyRequestHandler)this).mClusterSupport.mLogger.logMessage(Level.FINEST, "Using thread to perform JGroups cluster operation: " + opName);
                                                    StringBuffer buffer = new StringBuffer();
                                                    int charsRead = mClusterSupport.getManager().getOutputStreamData(sessionID, flowID, instanceID, jobID, startPos, maxChars, buffer);
                                                    Message message = new Message();
                                                    Object[] data = new Object[]{"GetOutputData_Response", operationGUID, charsRead, buffer.toString()};
                                                    message.setObject((Serializable)data);
                                                    mClusterSupport.postReplyMessage(message, caller);
                                                }
                                            });
                                            return operationGUID;
                                        }
                                        if (opName.equals("GetOutputData_Response")) {
                                            this.mClusterSupport.mLogger.logMessage(Level.FINEST, "Performing JGroups cluster response operation: " + opName);
                                            String guid = (String)elements[1];
                                            int charsRead = (Integer)elements[2];
                                            String readData = (String)elements[3];
                                            OutputHolder holder = new OutputHolder(charsRead, readData);
                                            this.mClusterSupport.setResponse(guid, holder);
                                        } else {
                                            if (opName.equals("GetRendererSnapshots")) {
                                                final String operationGUID = (String)elements[1];
                                                ThreadPool.instance().executeAsynchronously(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        ((MyRequestHandler)this).mClusterSupport.mLogger.logMessage(Level.FINEST, "Using thread to perform JGroups cluster operation: " + opName);
                                                        Collection<JobRendererInfo> infos = mClusterSupport.getManager().getJobRendererSnapshots();
                                                        Message message = new Message();
                                                        Object[] data = new Object[3];
                                                        data[0] = "GetRendererSnapshots_Response";
                                                        data[1] = operationGUID;
                                                        ArrayList<String> serInfos = new ArrayList<String>();
                                                        for (JobRendererInfo info : infos) {
                                                            serInfos.add(info.serialize());
                                                        }
                                                        data[2] = serInfos.toArray(new String[0]);
                                                        message.setObject((Serializable)data);
                                                        mClusterSupport.postReplyMessage(message, caller);
                                                    }
                                                });
                                                return operationGUID;
                                            }
                                            if (opName.equals("GetRendererSnapshots_Response")) {
                                                this.mClusterSupport.mLogger.logMessage(Level.FINEST, "Performing JGroups cluster response operation: " + opName);
                                                String guid = (String)elements[1];
                                                this.mClusterSupport.setResponse(guid, elements[2]);
                                            } else {
                                                if (opName.equals("GetErrorData")) {
                                                    final String sessionID = (String)elements[1];
                                                    final String flowID = (String)elements[2];
                                                    final String instanceID = (String)elements[3];
                                                    final String jobID = (String)elements[4];
                                                    final Long startPos = (Long)elements[5];
                                                    final Integer maxChars = (Integer)elements[6];
                                                    final String operationGUID = (String)elements[7];
                                                    ThreadPool.instance().executeAsynchronously(new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            ((MyRequestHandler)this).mClusterSupport.mLogger.logMessage(Level.FINEST, "Using thread to perform JGroups cluster operation: " + opName);
                                                            StringBuffer buffer = new StringBuffer();
                                                            int charsRead = mClusterSupport.getManager().getErrorStreamData(sessionID, flowID, instanceID, jobID, startPos, maxChars, buffer);
                                                            Message message = new Message();
                                                            Object[] data = new Object[]{"GetErrorData_Response", operationGUID, charsRead, buffer.toString()};
                                                            message.setObject((Serializable)data);
                                                            mClusterSupport.postReplyMessage(message, caller);
                                                        }
                                                    });
                                                    return operationGUID;
                                                }
                                                if (opName.equals("GetErrorData_Response")) {
                                                    this.mClusterSupport.mLogger.logMessage(Level.FINEST, "Performing JGroups cluster response operation: " + opName);
                                                    String guid = (String)elements[1];
                                                    int charsRead = (Integer)elements[2];
                                                    String readData = (String)elements[3];
                                                    OutputHolder holder = new OutputHolder(charsRead, readData);
                                                    this.mClusterSupport.setResponse(guid, holder);
                                                } else {
                                                    if (opName.equals("CreateSession")) {
                                                        final String userID = (String)elements[1];
                                                        final SealedString password = (String)elements[2] != null ? new SealedString((String)elements[2]) : null;
                                                        final String operationGUID = (String)elements[3];
                                                        ThreadPool.instance().executeAsynchronously(new Runnable(){

                                                            @Override
                                                            public void run() {
                                                                ((MyRequestHandler)this).mClusterSupport.mLogger.logMessage(Level.FINEST, "Using thread to perform JGroups cluster operation: " + opName);
                                                                AbstractUserSession session = mClusterSupport.getManager().createSession(userID, password);
                                                                Message message = new Message();
                                                                Object[] data = new Object[]{"CreateSession_Response", operationGUID, session.toSerializedForm()};
                                                                message.setObject((Serializable)data);
                                                                mClusterSupport.postReplyMessage(message, caller);
                                                            }
                                                        });
                                                        return null;
                                                    }
                                                    if (opName.equals("CreateSession_Response")) {
                                                        this.mClusterSupport.mLogger.logMessage(Level.FINEST, "Performing JGroups cluster response operation: " + opName);
                                                        String guid = (String)elements[1];
                                                        this.mClusterSupport.setResponse(guid, elements[2]);
                                                    } else {
                                                        if (opName.equals("TerminateSession")) {
                                                            final String sessionID = (String)elements[1];
                                                            final String operationGUID = (String)elements[2];
                                                            ThreadPool.instance().executeAsynchronously(new Runnable(){

                                                                @Override
                                                                public void run() {
                                                                    ((MyRequestHandler)this).mClusterSupport.mLogger.logMessage(Level.FINEST, "Using thread to perform JGroups cluster operation: " + opName);
                                                                    boolean success = mClusterSupport.getManager().terminateSession(sessionID);
                                                                    Message message = new Message();
                                                                    Object[] data = new Object[]{"TerminateSession_Response", operationGUID, new Boolean(success)};
                                                                    message.setObject((Serializable)data);
                                                                    mClusterSupport.postReplyMessage(message, caller);
                                                                }
                                                            });
                                                            return null;
                                                        }
                                                        if (opName.equals("TerminateSession_Response")) {
                                                            this.mClusterSupport.mLogger.logMessage(Level.FINEST, "Performing JGroups cluster response operation: " + opName);
                                                            String guid = (String)elements[1];
                                                            this.mClusterSupport.setResponse(guid, elements[2]);
                                                        } else {
                                                            if (opName.equals("AddFlows")) {
                                                                final String sessionID = (String)elements[1];
                                                                final String[] flowDefs = (String[])elements[2];
                                                                final String operationGUID = (String)elements[3];
                                                                ThreadPool.instance().executeAsynchronously(new Runnable(){

                                                                    @Override
                                                                    public void run() {
                                                                        ((MyRequestHandler)this).mClusterSupport.mLogger.logMessage(Level.FINEST, "Using thread to perform JGroups cluster operation: " + opName);
                                                                        ArrayList<TopLevelFlow> newFlows = new ArrayList<TopLevelFlow>();
                                                                        for (int i = 0; i < flowDefs.length; ++i) {
                                                                            String flowString = flowDefs[i];
                                                                            try {
                                                                                TopLevelFlow flow = TopLevelFlow.createFromXML(new BufferedReader(new StringReader(flowString)), mClusterSupport.getManager().getLogger());
                                                                                newFlows.add(flow);
                                                                                continue;
                                                                            }
                                                                            catch (Exception e) {
                                                                                ((MyRequestHandler)this).mClusterSupport.mLogger.logMessage(Level.WARNING, e);
                                                                            }
                                                                        }
                                                                        String[] flowIDs = mClusterSupport.getManager().addFlows(sessionID, newFlows.toArray(new TopLevelFlow[0]));
                                                                        Message message = new Message();
                                                                        Object[] data = new Object[]{"AddFlows_Response", operationGUID, flowIDs};
                                                                        message.setObject((Serializable)data);
                                                                        mClusterSupport.postReplyMessage(message, caller);
                                                                    }
                                                                });
                                                                return operationGUID;
                                                            }
                                                            if (opName.equals("AddFlows_Response")) {
                                                                this.mClusterSupport.mLogger.logMessage(Level.FINEST, "Performing JGroups cluster response operation: " + opName);
                                                                String guid = (String)elements[1];
                                                                this.mClusterSupport.setResponse(guid, elements[2]);
                                                            } else {
                                                                if (opName.equals("UpdateFlow")) {
                                                                    final String sessionID = (String)elements[1];
                                                                    final String flowDef = (String)elements[2];
                                                                    final String operationGUID = (String)elements[3];
                                                                    ThreadPool.instance().executeAsynchronously(new Runnable(){

                                                                        @Override
                                                                        public void run() {
                                                                            ((MyRequestHandler)this).mClusterSupport.mLogger.logMessage(Level.FINEST, "Using thread to perform JGroups cluster operation: " + opName);
                                                                            boolean success = false;
                                                                            try {
                                                                                TopLevelFlow flow = TopLevelFlow.createFromXML(new BufferedReader(new StringReader(flowDef)), mClusterSupport.getManager().getLogger());
                                                                                success = mClusterSupport.getManager().updateFlow(sessionID, flow);
                                                                            }
                                                                            catch (Exception e) {
                                                                                ((MyRequestHandler)this).mClusterSupport.mLogger.logMessage(Level.WARNING, e);
                                                                            }
                                                                            Message message = new Message();
                                                                            Object[] data = new Object[]{"UpdateFlow_Response", operationGUID, success};
                                                                            message.setObject((Serializable)data);
                                                                            mClusterSupport.postReplyMessage(message, caller);
                                                                        }
                                                                    });
                                                                    return operationGUID;
                                                                }
                                                                if (opName.equals("UpdateFlow_Response")) {
                                                                    this.mClusterSupport.mLogger.logMessage(Level.FINEST, "Performing JGroups cluster response operation: " + opName);
                                                                    String guid = (String)elements[1];
                                                                    this.mClusterSupport.setResponse(guid, elements[2]);
                                                                } else {
                                                                    if (opName.equals("KillFlows")) {
                                                                        final String sessionID = (String)elements[1];
                                                                        final String[] flowInstanceIDs = (String[])elements[2];
                                                                        final Boolean force = (Boolean)elements[3];
                                                                        final String operationGUID = (String)elements[4];
                                                                        ThreadPool.instance().executeAsynchronously(new Runnable(){

                                                                            @Override
                                                                            public void run() {
                                                                                ((MyRequestHandler)this).mClusterSupport.mLogger.logMessage(Level.FINEST, "Using thread to perform JGroups cluster operation: " + opName);
                                                                                String[] failedIDs = mClusterSupport.getManager().killFlowInstances(sessionID, flowInstanceIDs, force);
                                                                                Message message = new Message();
                                                                                Object[] data = new Object[]{"KillFlows_Response", operationGUID, failedIDs};
                                                                                message.setObject((Serializable)data);
                                                                                mClusterSupport.postReplyMessage(message, caller);
                                                                            }
                                                                        });
                                                                        return operationGUID;
                                                                    }
                                                                    if (opName.equals("KillFlows_Response")) {
                                                                        this.mClusterSupport.mLogger.logMessage(Level.FINEST, "Performing JGroups cluster response operation: " + opName);
                                                                        String guid = (String)elements[1];
                                                                        this.mClusterSupport.setResponse(guid, elements[2]);
                                                                    } else {
                                                                        if (opName.equals("HoldFlows")) {
                                                                            final String sessionID = (String)elements[1];
                                                                            final String[] flowIDs = (String[])elements[2];
                                                                            final String operationGUID = (String)elements[3];
                                                                            ThreadPool.instance().executeAsynchronously(new Runnable(){

                                                                                @Override
                                                                                public void run() {
                                                                                    ((MyRequestHandler)this).mClusterSupport.mLogger.logMessage(Level.FINEST, "Using thread to perform JGroups cluster operation: " + opName);
                                                                                    String[] successfulIDs = mClusterSupport.getManager().holdFlows(sessionID, flowIDs);
                                                                                    Message message = new Message();
                                                                                    Object[] data = new Object[]{"HoldFlows_Response", operationGUID, successfulIDs};
                                                                                    message.setObject((Serializable)data);
                                                                                    mClusterSupport.postReplyMessage(message, caller);
                                                                                }
                                                                            });
                                                                            return operationGUID;
                                                                        }
                                                                        if (opName.equals("HoldFlows_Response")) {
                                                                            this.mClusterSupport.mLogger.logMessage(Level.FINEST, "Performing JGroups cluster response operation: " + opName);
                                                                            String guid = (String)elements[1];
                                                                            this.mClusterSupport.setResponse(guid, elements[2]);
                                                                        } else {
                                                                            if (opName.equals("ReleaseFlows")) {
                                                                                final String sessionID = (String)elements[1];
                                                                                final String[] flowIDs = (String[])elements[2];
                                                                                final String operationGUID = (String)elements[3];
                                                                                ThreadPool.instance().executeAsynchronously(new Runnable(){

                                                                                    @Override
                                                                                    public void run() {
                                                                                        ((MyRequestHandler)this).mClusterSupport.mLogger.logMessage(Level.FINEST, "Using thread to perform JGroups cluster operation: " + opName);
                                                                                        String[] successfulIDs = mClusterSupport.getManager().releaseFlows(sessionID, flowIDs);
                                                                                        Message message = new Message();
                                                                                        Object[] data = new Object[]{"ReleaseFlows_Response", operationGUID, successfulIDs};
                                                                                        message.setObject((Serializable)data);
                                                                                        mClusterSupport.postReplyMessage(message, caller);
                                                                                    }
                                                                                });
                                                                                return operationGUID;
                                                                            }
                                                                            if (opName.equals("ReleaseFlows_Response")) {
                                                                                this.mClusterSupport.mLogger.logMessage(Level.FINEST, "Performing JGroups cluster response operation: " + opName);
                                                                                String guid = (String)elements[1];
                                                                                this.mClusterSupport.setResponse(guid, elements[2]);
                                                                            } else {
                                                                                if (opName.equals("KillExecutionItem")) {
                                                                                    final String sessionID = (String)elements[1];
                                                                                    final String flowInstanceID = (String)elements[2];
                                                                                    final String subItemID = (String)elements[3];
                                                                                    final Boolean force = (Boolean)elements[4];
                                                                                    final String operationGUID = (String)elements[5];
                                                                                    ThreadPool.instance().executeAsynchronously(new Runnable(){

                                                                                        @Override
                                                                                        public void run() {
                                                                                            ((MyRequestHandler)this).mClusterSupport.mLogger.logMessage(Level.FINEST, "Using thread to perform JGroups cluster operation: " + opName);
                                                                                            boolean success = mClusterSupport.getManager().killExecutionItem(sessionID, flowInstanceID, subItemID, force);
                                                                                            Message message = new Message();
                                                                                            Object[] data = new Object[]{"KillExecutionItem_Response", operationGUID, success};
                                                                                            message.setObject((Serializable)data);
                                                                                            mClusterSupport.postReplyMessage(message, caller);
                                                                                        }
                                                                                    });
                                                                                    return operationGUID;
                                                                                }
                                                                                if (opName.equals("KillExecutionItem_Response")) {
                                                                                    this.mClusterSupport.mLogger.logMessage(Level.FINEST, "Performing JGroups cluster response operation: " + opName);
                                                                                    String guid = (String)elements[1];
                                                                                    this.mClusterSupport.setResponse(guid, elements[2]);
                                                                                } else {
                                                                                    if (opName.equals("TriggerExecutionItem")) {
                                                                                        final String sessionID = (String)elements[1];
                                                                                        final String flowInstanceID = (String)elements[2];
                                                                                        final String subItemID = (String)elements[3];
                                                                                        final String operationGUID = (String)elements[4];
                                                                                        ThreadPool.instance().executeAsynchronously(new Runnable(){

                                                                                            @Override
                                                                                            public void run() {
                                                                                                ((MyRequestHandler)this).mClusterSupport.mLogger.logMessage(Level.FINEST, "Using thread to perform JGroups cluster operation: " + opName);
                                                                                                boolean success = mClusterSupport.getManager().triggerExecutionItem(sessionID, flowInstanceID, subItemID);
                                                                                                Message message = new Message();
                                                                                                Object[] data = new Object[]{"TriggerExecutionItem_Response", operationGUID, success};
                                                                                                message.setObject((Serializable)data);
                                                                                                mClusterSupport.postReplyMessage(message, caller);
                                                                                            }
                                                                                        });
                                                                                        return operationGUID;
                                                                                    }
                                                                                    if (opName.equals("TriggerExecutionItem_Response")) {
                                                                                        this.mClusterSupport.mLogger.logMessage(Level.FINEST, "Performing JGroups cluster response operation: " + opName);
                                                                                        String guid = (String)elements[1];
                                                                                        this.mClusterSupport.setResponse(guid, elements[2]);
                                                                                    } else {
                                                                                        if (opName.equals("DeleteFlows")) {
                                                                                            final String sessionID = (String)elements[1];
                                                                                            final String[] flowIDs = (String[])elements[2];
                                                                                            final String operationGUID = (String)elements[3];
                                                                                            ThreadPool.instance().executeAsynchronously(new Runnable(){

                                                                                                @Override
                                                                                                public void run() {
                                                                                                    ((MyRequestHandler)this).mClusterSupport.mLogger.logMessage(Level.FINEST, "Using thread to perform JGroups cluster operation: " + opName);
                                                                                                    String[] failedIDs = mClusterSupport.getManager().deleteFlows(sessionID, flowIDs);
                                                                                                    Message message = new Message();
                                                                                                    Object[] data = new Object[]{"DeleteFlows_Response", operationGUID, failedIDs};
                                                                                                    message.setObject((Serializable)data);
                                                                                                    mClusterSupport.postReplyMessage(message, caller);
                                                                                                }
                                                                                            });
                                                                                            return operationGUID;
                                                                                        }
                                                                                        if (opName.equals("DeleteFlows_Response")) {
                                                                                            this.mClusterSupport.mLogger.logMessage(Level.FINEST, "Performing JGroups cluster response operation: " + opName);
                                                                                            String guid = (String)elements[1];
                                                                                            this.mClusterSupport.setResponse(guid, elements[2]);
                                                                                        } else {
                                                                                            if (opName.equals("RunFlows")) {
                                                                                                final String sessionID = (String)elements[1];
                                                                                                final String[] flowIDs = (String[])elements[2];
                                                                                                final String operationGUID = (String)elements[3];
                                                                                                ThreadPool.instance().executeAsynchronously(new Runnable(){

                                                                                                    @Override
                                                                                                    public void run() {
                                                                                                        ((MyRequestHandler)this).mClusterSupport.mLogger.logMessage(Level.FINEST, "Using thread to perform JGroups cluster operation: " + opName);
                                                                                                        String[] newInstanceIDs = mClusterSupport.getManager().runFlows(sessionID, flowIDs);
                                                                                                        Message message = new Message();
                                                                                                        Object[] data = new Object[]{"RunFlows_Response", operationGUID, newInstanceIDs};
                                                                                                        message.setObject((Serializable)data);
                                                                                                        mClusterSupport.postReplyMessage(message, caller);
                                                                                                    }
                                                                                                });
                                                                                                return operationGUID;
                                                                                            }
                                                                                            if (opName.equals("RunFlows_Response")) {
                                                                                                this.mClusterSupport.mLogger.logMessage(Level.FINEST, "Performing JGroups cluster response operation: " + opName);
                                                                                                String guid = (String)elements[1];
                                                                                                this.mClusterSupport.setResponse(guid, elements[2]);
                                                                                            } else {
                                                                                                if (opName.equals("IsAdministrator")) {
                                                                                                    final String sessionID = (String)elements[1];
                                                                                                    final String operationGUID = (String)elements[2];
                                                                                                    ThreadPool.instance().executeAsynchronously(new Runnable(){

                                                                                                        @Override
                                                                                                        public void run() {
                                                                                                            ((MyRequestHandler)this).mClusterSupport.mLogger.logMessage(Level.FINEST, "Using thread to perform JGroups cluster operation: " + opName);
                                                                                                            Boolean result = new Boolean(mClusterSupport.getManager().isAdministrator(sessionID));
                                                                                                            Message message = new Message();
                                                                                                            Object[] data = new Object[]{"IsAdministrator_Response", operationGUID, result};
                                                                                                            message.setObject((Serializable)data);
                                                                                                            mClusterSupport.postReplyMessage(message, caller);
                                                                                                        }
                                                                                                    });
                                                                                                    return null;
                                                                                                }
                                                                                                if (opName.equals("IsAdministrator_Response")) {
                                                                                                    this.mClusterSupport.mLogger.logMessage(Level.FINEST, "Performing JGroups cluster response operation: " + opName);
                                                                                                    String guid = (String)elements[1];
                                                                                                    this.mClusterSupport.setResponse(guid, elements[2]);
                                                                                                } else {
                                                                                                    if (opName.equals("GetAllFlowIDs")) {
                                                                                                        final String sessionID = (String)elements[1];
                                                                                                        final String operationGUID = (String)elements[2];
                                                                                                        ThreadPool.instance().executeAsynchronously(new Runnable(){

                                                                                                            @Override
                                                                                                            public void run() {
                                                                                                                ((MyRequestHandler)this).mClusterSupport.mLogger.logMessage(Level.FINEST, "Using thread to perform JGroups cluster operation: " + opName);
                                                                                                                TopLevelFlowIDInfo[] idInfos = mClusterSupport.getManager().getAllFlowIDs(sessionID);
                                                                                                                ArrayList<String> results = new ArrayList<String>();
                                                                                                                for (int i = 0; i < idInfos.length; ++i) {
                                                                                                                    TopLevelFlowIDInfo info = idInfos[i];
                                                                                                                    results.add(info.toSerializedForm());
                                                                                                                }
                                                                                                                Message message = new Message();
                                                                                                                Object[] data = new Object[]{"GetAllFlowIDs_Response", operationGUID, results.toArray(new String[0])};
                                                                                                                message.setObject((Serializable)data);
                                                                                                                mClusterSupport.postReplyMessage(message, caller);
                                                                                                            }
                                                                                                        });
                                                                                                        return operationGUID;
                                                                                                    }
                                                                                                    if (opName.equals("GetAllFlowIDs_Response")) {
                                                                                                        this.mClusterSupport.mLogger.logMessage(Level.FINEST, "Performing JGroups cluster response operation: " + opName);
                                                                                                        String guid = (String)elements[1];
                                                                                                        this.mClusterSupport.setResponse(guid, elements[2]);
                                                                                                    } else {
                                                                                                        if (opName.equals("GetNextTriggerTimes")) {
                                                                                                            final String[] flowIDs = (String[])elements[1];
                                                                                                            final String operationGUID = (String)elements[2];
                                                                                                            final long startTime = (Long)elements[3];
                                                                                                            ThreadPool.instance().executeAsynchronously(new Runnable(){

                                                                                                                @Override
                                                                                                                public void run() {
                                                                                                                    ((MyRequestHandler)this).mClusterSupport.mLogger.logMessage(Level.FINEST, "Using thread to perform JGroups cluster operation: " + opName);
                                                                                                                    ArrayList<String> inputs = new ArrayList<String>();
                                                                                                                    inputs.addAll(Arrays.asList(flowIDs));
                                                                                                                    Calendar startCal = Calendar.getInstance();
                                                                                                                    startCal.setTimeInMillis(startTime);
                                                                                                                    List<Long> results = mClusterSupport.getManager().getNextTriggerTimes(inputs, startCal);
                                                                                                                    Long[] numbers = results.toArray(new Long[0]);
                                                                                                                    Message message = new Message();
                                                                                                                    Object[] data = new Object[]{"GetNextTriggerTimes_Response", operationGUID, numbers};
                                                                                                                    message.setObject((Serializable)data);
                                                                                                                    mClusterSupport.postReplyMessage(message, caller);
                                                                                                                }
                                                                                                            });
                                                                                                            return operationGUID;
                                                                                                        }
                                                                                                        if (opName.equals("GetNextTriggerTimes_Response")) {
                                                                                                            this.mClusterSupport.mLogger.logMessage(Level.FINEST, "Performing JGroups cluster response operation: " + opName);
                                                                                                            String guid = (String)elements[1];
                                                                                                            this.mClusterSupport.setResponse(guid, elements[2]);
                                                                                                        } else {
                                                                                                            if (opName.equals("KillJob")) {
                                                                                                                final String rendevousID = (String)elements[1];
                                                                                                                boolean force = false;
                                                                                                                if (elements.length >= 2 && elements[0] instanceof Boolean) {
                                                                                                                    force = (Boolean)elements[0];
                                                                                                                }
                                                                                                                final boolean finalForce = force;
                                                                                                                ThreadPool.instance().executeAsynchronously(new Runnable(){

                                                                                                                    @Override
                                                                                                                    public void run() {
                                                                                                                        if (mClusterSupport.getManager() != null) {
                                                                                                                            ((MyRequestHandler)this).mClusterSupport.mLogger.logMessage(Level.FINEST, "Using thread to perform JGroups cluster operation: " + opName);
                                                                                                                            mClusterSupport.getManager().getExecutionProvider().killJob(rendevousID, finalForce);
                                                                                                                        }
                                                                                                                    }
                                                                                                                });
                                                                                                                return null;
                                                                                                            }
                                                                                                            if (opName.equals("GetAcceptJobScore")) {
                                                                                                                this.mClusterSupport.mLogger.logMessage(Level.FINEST, "Performing JGroups cluster operation: " + opName);
                                                                                                                String requirements = (String)elements[1];
                                                                                                                RunningJobResourceRequirements runningReq = RunningJobResourceRequirements.createObjectFromSerializedForm(requirements);
                                                                                                                return new Integer(this.mClusterSupport.getAcceptJobScore(runningReq));
                                                                                                            }
                                                                                                            if (opName.equals("MarkJobFinished")) {
                                                                                                                final String runningJobID = (String)elements[1];
                                                                                                                final int statusCode = (Integer)elements[2];
                                                                                                                final int exitCode = (Integer)elements[3];
                                                                                                                this.mClusterSupport.getManager().addActionToNoPersistenceAsyncQueue(new DeferredManagerAction(this.mClusterSupport.getManager()){

                                                                                                                    @Override
                                                                                                                    public void execute() throws ShutdownException {
                                                                                                                        ((MyRequestHandler)this).mClusterSupport.mLogger.logMessage(Level.FINEST, "Using thread to perform JGroups cluster operation: " + opName);
                                                                                                                        mClusterSupport.getManager().markJobFinished(runningJobID, statusCode, exitCode);
                                                                                                                    }
                                                                                                                });
                                                                                                                return null;
                                                                                                            }
                                                                                                            if (opName.equals("ExecuteJobOnWorker")) {
                                                                                                                this.mClusterSupport.mLogger.logMessage(Level.FINEST, "Performing JGroups cluster operation: " + opName);
                                                                                                                String jobDef = (String)elements[1];
                                                                                                                Job job = Job.createFromXML(new BufferedReader(new StringReader(jobDef)), this.mClusterSupport.mLogger);
                                                                                                                String rendevousID = (String)elements[2];
                                                                                                                String userString = (String)elements[3];
                                                                                                                String flowInstanceID = (String)elements[4];
                                                                                                                String flowID = (String)elements[5];
                                                                                                                UserInfo userInfo = null;
                                                                                                                if (userString != null) {
                                                                                                                    userInfo = UserInfo.createFromData(userString);
                                                                                                                }
                                                                                                                Boolean returnVal = this.mClusterSupport.getManager().getExecutionProvider().execute(job, flowID, flowInstanceID, rendevousID, userInfo);
                                                                                                                return returnVal;
                                                                                                            }
                                                                                                            if (opName.equals("UpdateJobStart")) {
                                                                                                                final String runningJobID = (String)elements[1];
                                                                                                                final long startTime = (Long)elements[2];
                                                                                                                final String renderer = (String)elements[3];
                                                                                                                String tempRunQueue = null;
                                                                                                                if (elements.length > 4) {
                                                                                                                    tempRunQueue = (String)elements[4];
                                                                                                                }
                                                                                                                final String jobQueue = tempRunQueue;
                                                                                                                this.mClusterSupport.getManager().addActionToNoPersistenceAsyncQueue(new DeferredManagerAction(this.mClusterSupport.getManager()){

                                                                                                                    @Override
                                                                                                                    public void execute() throws ShutdownException {
                                                                                                                        ((MyRequestHandler)this).mClusterSupport.mLogger.logMessage(Level.FINEST, "Using thread to perform JGroups cluster operation: " + opName);
                                                                                                                        mClusterSupport.getManager().updateJobStartInfo(runningJobID, startTime, renderer, jobQueue);
                                                                                                                    }
                                                                                                                });
                                                                                                                return null;
                                                                                                            }
                                                                                                            this.mClusterSupport.mLogger.logMessage(Level.WARNING, "Unknown operation attempted: " + opName);
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                this.mClusterSupport.mLogger.logMessage(Level.WARNING, e);
            }
            return null;
        }
    }

    static class ClusterMembershipListener
    implements MembershipListener {
        private JGroupsClusterSupport mSupport;

        public ClusterMembershipListener(JGroupsClusterSupport support) {
            this.mSupport = support;
        }

        public void block() {
        }

        public void suspect(Address arg0) {
            if (this.mSupport.mManager != null) {
                this.mSupport.mManager.getLogger().logMessage(Level.INFO, "Address is suspect: " + arg0);
            }
        }

        public void viewAccepted(View arg0) {
            if (this.mSupport.mManager != null) {
                this.mSupport.getMasterServer();
            }
        }
    }
}

