/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.net.crypto.SealedString;

public class UserInfo {
    private static char Separator = (char)124;
    private String mUserID;
    private SealedString mPassword;
    private boolean mIsAdmin;

    @Deprecated
    public UserInfo(String userName, String password, boolean isAdmin) {
        this.mUserID = userName;
        this.mPassword = password != null ? new SealedString(password) : null;
        this.mIsAdmin = isAdmin;
    }

    public UserInfo(String userName, SealedString password, boolean isAdmin) {
        this.mUserID = userName;
        this.mPassword = password;
        this.mIsAdmin = isAdmin;
    }

    public String getUserID() {
        return this.mUserID;
    }

    @Deprecated
    public String getPassword() {
        return this.mPassword != null ? String.valueOf(this.mPassword.getCharacters()) : null;
    }

    public SealedString getPasswordSealedString() {
        return this.mPassword;
    }

    public boolean isAdmin() {
        return this.mIsAdmin;
    }

    public String toSerializedForm() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Integer.toString(this.mUserID.length()));
        buffer.append(Separator);
        buffer.append(this.mUserID);
        buffer.append(this.mPassword != null ? Integer.toString(this.mPassword.getCharacters().length) : Integer.valueOf(0));
        buffer.append(Separator);
        buffer.append(this.mPassword != null ? String.valueOf(this.mPassword.getCharacters()) : null);
        buffer.append(Boolean.toString(this.mIsAdmin));
        return buffer.toString();
    }

    public static UserInfo createFromData(String data) {
        int firstSeparator = data.indexOf(Separator);
        if (firstSeparator < 0) {
            return null;
        }
        String userID = "";
        SealedString password = new SealedString("");
        boolean admin = false;
        try {
            String firstNum = data.substring(0, firstSeparator);
            int length = Integer.parseInt(firstNum);
            if (length < 0) {
                return null;
            }
            int endIndex = firstSeparator + 1 + length;
            userID = data.substring(firstSeparator + 1, endIndex);
            int secondSeparator = data.indexOf(Separator, endIndex);
            if (secondSeparator < 0) {
                return null;
            }
            String secondNum = data.substring(endIndex, secondSeparator);
            length = Integer.parseInt(secondNum);
            if (length < 0) {
                return null;
            }
            endIndex = secondSeparator + 1 + length;
            password = new SealedString(data.substring(secondSeparator + 1, endIndex));
            String adminString = data.substring(endIndex);
            admin = Boolean.valueOf(adminString);
        }
        catch (NumberFormatException firstNum) {
            // empty catch block
        }
        UserInfo userInfo = new UserInfo(userID, password, admin);
        return userInfo;
    }

    public String toString() {
        return this.toSerializedForm();
    }
}

