/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.FlowManager;
import com.sas.scheduler.api.servers.ip.engine.JobDependency;
import com.sas.scheduler.api.servers.ip.engine.RunCondition;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RunItemStatusDependency
extends JobDependency {
    private int mStatusMask = 4;
    private transient int mMaxMaskPriority;
    static final String XML_RunItemStatusDependency_Tag = "RunItemStatusDependency";
    private static final String XML_Status_Tag = "Status";

    public RunItemStatusDependency(ClientLogger logger) {
        super(logger);
    }

    @Override
    public RunCondition copy() {
        RunItemStatusDependency dep = new RunItemStatusDependency(this.mLogger);
        dep.setStatusMask(this.mStatusMask);
        dep.copyFrom(this);
        return dep;
    }

    @Override
    public void serialize(Document doc, Node parent) {
        Element tag = doc.createElement(XML_RunItemStatusDependency_Tag);
        parent.appendChild(tag);
        this.injectXML(doc, tag);
    }

    @Override
    protected void injectXML(Document doc, Element tag) {
        super.injectXML(doc, tag);
        tag.setAttribute(XML_Status_Tag, Integer.toString(this.mStatusMask));
        tag.setAttribute("JobID", this.getJobID());
    }

    public int getStatusMask() {
        return this.mStatusMask;
    }

    public void setStatusMask(int status) {
        if (status >= 0) {
            this.mStatusMask = status;
            this.mMaxMaskPriority = 0;
            if ((this.mStatusMask & 0x40) > 0) {
                this.mStatusMask &= 0xFFFFFFBF;
            }
            if ((this.mStatusMask & 0x10) > 0) {
                this.mMaxMaskPriority = Math.max(this.mMaxMaskPriority, this.getStatusPriority(16));
            }
            if ((this.mStatusMask & 8) > 0) {
                this.mMaxMaskPriority = Math.max(this.mMaxMaskPriority, this.getStatusPriority(8));
            }
            if ((this.mStatusMask & 4) > 0) {
                this.mMaxMaskPriority = Math.max(this.mMaxMaskPriority, this.getStatusPriority(4));
            }
            if ((this.mStatusMask & 2) > 0) {
                this.mMaxMaskPriority = Math.max(this.mMaxMaskPriority, this.getStatusPriority(2));
            }
            if ((this.mStatusMask & 1) > 0) {
                this.mMaxMaskPriority = Math.max(this.mMaxMaskPriority, this.getStatusPriority(1));
            }
            if ((this.mStatusMask & 0x20) > 0) {
                this.mMaxMaskPriority = Math.max(this.mMaxMaskPriority, this.getStatusPriority(32));
            }
            if ((this.mStatusMask & 0x80) > 0) {
                this.mMaxMaskPriority = Math.max(this.mMaxMaskPriority, this.getStatusPriority(128));
            }
        }
    }

    @Override
    public String toString() {
        StringBuffer printString = new StringBuffer();
        printString.append("Waits for job: " + this.getJobID() + " to finish with one of the following completion codes: ");
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(new Integer(4), "Done");
        map.put(new Integer(2), "Exited");
        map.put(new Integer(1), "Killed");
        map.put(new Integer(32), "NotRun");
        map.put(new Integer(8), "Running");
        map.put(new Integer(16), "Waiting");
        map.put(new Integer(128), "Run Failed");
        for (Map.Entry entry : map.entrySet()) {
            Integer statusValue = (Integer)entry.getKey();
            if ((statusValue & this.mStatusMask) <= 0) continue;
            printString.append((String)entry.getValue() + " ");
        }
        return printString.toString();
    }

    private int getStatusPriority(int statusCode) {
        switch (statusCode) {
            case 64: {
                return 1;
            }
            case 16: {
                return 2;
            }
            case 8: {
                return 4;
            }
            case 32: {
                return 5;
            }
            case 128: {
                return 5;
            }
            case 4: {
                return 5;
            }
            case 2: {
                return 5;
            }
            case 1: {
                return 5;
            }
        }
        return 0;
    }

    @Override
    public int canExecute(FlowManager manager, Calendar currentTime, Map<String, Long> usedTimes, Map<String, Long> outputUsedTimes, Calendar outputNextTriggerTime, boolean defaultValue) {
        this.setTimeForFutureCheck(currentTime, outputNextTriggerTime);
        if (this.getDependentItem() == null) {
            return defaultValue ? 56 : 58;
        }
        int completionCode = this.getDependentItem().getCompletionCode();
        if ((completionCode & this.mStatusMask) > 0) {
            return 56;
        }
        int currentCompletionPriority = this.getStatusPriority(completionCode);
        if (currentCompletionPriority >= this.mMaxMaskPriority) {
            return 58;
        }
        return 57;
    }

    static RunCondition processStatusCondition(Node node, ClientLogger logger) {
        Node statusNode;
        RunItemStatusDependency dependency = new RunItemStatusDependency(logger);
        NamedNodeMap attributes = node.getAttributes();
        dependency.processAttributes(attributes);
        Node jobIDNode = attributes.getNamedItem("JobID");
        if (jobIDNode != null) {
            dependency.setDependentJobID(jobIDNode.getNodeValue());
        }
        if ((statusNode = attributes.getNamedItem(XML_Status_Tag)) != null) {
            try {
                dependency.setStatusMask(Integer.valueOf(statusNode.getNodeValue()));
            }
            catch (NumberFormatException e) {
                logger.logMessage(Level.WARNING, e);
            }
        }
        return dependency;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RunItemStatusDependency)) {
            return false;
        }
        RunItemStatusDependency other = (RunItemStatusDependency)obj;
        if (other.mStatusMask != this.mStatusMask) {
            return false;
        }
        if (other.mMaxMaskPriority != this.mMaxMaskPriority) {
            return false;
        }
        return super.equals(obj);
    }
}

