/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.FlowManager;
import com.sas.scheduler.api.servers.ip.engine.JobDependency;
import com.sas.scheduler.api.servers.ip.engine.RunCondition;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RunItemStartedDependency
extends JobDependency {
    private int mSecondsSinceStart = 0;
    static final String XML_RunItemStartedDependency_Tag = "RunItemStartedDependency";
    private static final String XML_SecondsSinceStart_Tag = "SecondsSinceStart";

    public RunItemStartedDependency(ClientLogger logger) {
        super(logger);
    }

    public int getSecondsSinceStart() {
        return this.mSecondsSinceStart;
    }

    public void setSecondsSinceStart(int secondsSinceJobStart) {
        if (secondsSinceJobStart >= 0) {
            this.mSecondsSinceStart = secondsSinceJobStart;
        }
    }

    @Override
    public RunCondition copy() {
        RunItemStartedDependency dep = new RunItemStartedDependency(this.mLogger);
        dep.setSecondsSinceStart(this.mSecondsSinceStart);
        dep.copyFrom(this);
        return dep;
    }

    @Override
    public void serialize(Document doc, Node parent) {
        Element tag = doc.createElement(XML_RunItemStartedDependency_Tag);
        parent.appendChild(tag);
        this.injectXML(doc, tag);
    }

    @Override
    protected void injectXML(Document doc, Element tag) {
        super.injectXML(doc, tag);
        tag.setAttribute(XML_SecondsSinceStart_Tag, Integer.toString(this.mSecondsSinceStart));
        tag.setAttribute("JobID", this.getJobID());
    }

    @Override
    public String toString() {
        StringBuffer printString = new StringBuffer();
        printString.append("Waits for job: " + this.getJobID() + " to have started running and then at least ");
        printString.append(this.mSecondsSinceStart + " seconds.");
        return printString.toString();
    }

    @Override
    boolean isTimeDominant() {
        return super.isTimeDominant();
    }

    @Override
    public int canExecute(FlowManager manager, Calendar currentTime, Map<String, Long> usedTimes, Map<String, Long> outputUsedTimes, Calendar outputNextTriggerTime, boolean defaultValue) {
        this.setTimeForFutureCheck(currentTime, outputNextTriggerTime);
        if (this.getDependentItem() == null) {
            return defaultValue ? 56 : 58;
        }
        if (this.getDependentItem().getStartTime() != null) {
            if (this.mSecondsSinceStart > 0) {
                long secondsAfterStart = (currentTime.getTimeInMillis() - this.getDependentItem().getStartTime().getTimeInMillis()) / 1000L;
                if (secondsAfterStart >= (long)this.mSecondsSinceStart) {
                    return 56;
                }
                outputNextTriggerTime.setTimeInMillis(this.getDependentItem().getStartTime().getTimeInMillis());
                outputNextTriggerTime.add(13, this.mSecondsSinceStart + 1);
                return 57;
            }
            return 56;
        }
        return 57;
    }

    static RunCondition processStartedCondition(Node node, ClientLogger logger) {
        Node secondsNode;
        RunItemStartedDependency dependency = new RunItemStartedDependency(logger);
        NamedNodeMap attributes = node.getAttributes();
        dependency.processAttributes(attributes);
        Node jobIDNode = attributes.getNamedItem("JobID");
        if (jobIDNode != null) {
            dependency.setDependentJobID(jobIDNode.getNodeValue());
        }
        if ((secondsNode = attributes.getNamedItem(XML_SecondsSinceStart_Tag)) != null) {
            try {
                dependency.setSecondsSinceStart(Integer.valueOf(secondsNode.getNodeValue()));
            }
            catch (NumberFormatException e) {
                logger.logMessage(Level.WARNING, e);
            }
        }
        return dependency;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RunItemStartedDependency)) {
            return false;
        }
        RunItemStartedDependency other = (RunItemStartedDependency)obj;
        if (other.mSecondsSinceStart != this.mSecondsSinceStart) {
            return false;
        }
        return super.equals(obj);
    }
}

