/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.AbstractUserSession;
import java.io.IOException;
import java.io.Reader;

public class ProcessOutputReader
extends Reader {
    private AbstractUserSession mSession;
    private String mInstanceID;
    private String mFlowID;
    private String mJobID;
    private boolean mIsOutputStream;
    private StringBuffer mBuffer;
    private long mCurrentSeekPos;

    public ProcessOutputReader(AbstractUserSession session, String flowID, String flowInstanceID, String jobID, boolean outputStream) {
        this.mSession = session;
        this.mInstanceID = flowInstanceID;
        this.mJobID = jobID;
        this.mIsOutputStream = outputStream;
        this.mCurrentSeekPos = 0L;
        this.mFlowID = flowID;
        this.mBuffer = new StringBuffer();
    }

    @Override
    public void close() throws IOException {
        this.mInstanceID = "";
        this.mJobID = "";
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.mInstanceID.length() == 0) {
            return -1;
        }
        if (this.mBuffer.length() == 0) {
            this.fillBuffer();
            if (this.mBuffer.length() == 0) {
                return -1;
            }
        }
        int charsCopied = 0;
        for (int i = 0; i < len && i < this.mBuffer.length(); ++i) {
            cbuf[off + i] = this.mBuffer.charAt(i);
            ++charsCopied;
        }
        this.mBuffer.delete(0, charsCopied);
        return charsCopied;
    }

    private void fillBuffer() {
        StringBuffer tempBuffer = new StringBuffer();
        int charsRead = this.mIsOutputStream ? this.mSession.getFlowManager().getOutputStreamData(this.mSession.getSessionID(), this.mFlowID, this.mInstanceID, this.mJobID, this.mCurrentSeekPos, 2048, tempBuffer) : this.mSession.getFlowManager().getErrorStreamData(this.mSession.getSessionID(), this.mFlowID, this.mInstanceID, this.mJobID, this.mCurrentSeekPos, 2048, tempBuffer);
        if (charsRead > 0) {
            this.mCurrentSeekPos += (long)charsRead;
            this.mBuffer.append(tempBuffer);
        }
    }
}

