/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.ExecutionItem;
import com.sas.scheduler.api.servers.ip.engine.FlowManager;
import com.sas.scheduler.api.servers.ip.engine.RunCondition;
import com.sas.scheduler.api.servers.ip.engine.RunConditions;
import com.sas.scheduler.api.servers.ip.engine.RunningItem;
import java.util.Calendar;
import java.util.List;

public abstract class JobDependency
extends RunCondition {
    private String mJobID = "";
    public static final String XML_JobID_Tag = "JobID";
    private transient RunningItem mDependentItem = null;

    public JobDependency(ClientLogger logger) {
        super(logger);
    }

    public void setExecutionItem(ExecutionItem item) {
        if (item != null) {
            this.setDependentJobID(item.getUniqueID());
        }
    }

    protected void setDependentJobID(String jobID) {
        if (jobID != null && jobID.length() > 0) {
            this.mJobID = jobID;
        }
    }

    void copyFrom(JobDependency source) {
        this.mJobID = source.mJobID;
        super.copyFrom(source);
    }

    RunningItem getDependentItem() {
        return this.mDependentItem;
    }

    protected void setDependentItem(RunningItem dependentItem) {
        if (dependentItem != null) {
            this.mDependentItem = dependentItem;
        }
    }

    protected void setTimeForFutureCheck(Calendar currentTime, Calendar nextCheckTime) {
        if (nextCheckTime != null) {
            nextCheckTime.setTimeInMillis(currentTime.getTimeInMillis() + 3600000L);
            nextCheckTime.set(13, 0);
            nextCheckTime.set(14, 0);
            nextCheckTime.setTimeInMillis(nextCheckTime.getTimeInMillis());
        }
    }

    public String getJobID() {
        return this.mJobID;
    }

    public static void findJobDependencies(RunCondition condition, List<JobDependency> output) {
        if (condition instanceof JobDependency) {
            output.add((JobDependency)condition);
        } else if (condition instanceof RunConditions) {
            for (RunCondition subCondition : ((RunConditions)condition).getSubConditions()) {
                JobDependency.findJobDependencies(subCondition, output);
            }
        }
    }

    @Override
    public boolean willNotRun(FlowManager manager, Calendar startTime, Calendar deadlineTime) {
        return this.canRunNow(manager, null, null) == 58;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof JobDependency)) {
            return false;
        }
        JobDependency other = (JobDependency)obj;
        if (!other.mJobID.equals(this.mJobID)) {
            return false;
        }
        return super.equals(obj);
    }
}

