/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.servers.ip.engine.AbstractUserSession;
import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.ClusterSupport;
import com.sas.scheduler.api.servers.ip.engine.ExecutionProviderBase;
import com.sas.scheduler.api.servers.ip.engine.FlowManager;
import com.sas.scheduler.api.servers.ip.engine.InProcessUserSession;
import com.sas.scheduler.api.servers.ip.engine.UserInfo;

public abstract class InProcessExecutionProviderBase
extends ExecutionProviderBase {
    public InProcessExecutionProviderBase(ClientLogger logger, ClusterSupport support) {
        super(logger, support);
    }

    @Override
    public AbstractUserSession createNewSession(FlowManager manager, UserInfo user) {
        String id = this.createNewSessionID();
        InProcessUserSession session = InProcessUserSession.CreateUserSession(manager, id, user.getUserID());
        return session;
    }

    @Override
    public AbstractUserSession constructSession(String serializedUserSession) {
        AbstractUserSession session = InProcessUserSession.CreateFromSerializedForm(serializedUserSession);
        return session;
    }

    @Override
    protected boolean isUserIDAdministrator(String canonicalUserID) {
        return true;
    }

    @Override
    @Deprecated
    protected boolean validateUser(String userID, String password) {
        return this.validateUserSealedString(userID, password != null ? new SealedString(password) : null);
    }

    @Override
    protected boolean validateUserSealedString(String userID, SealedString password) {
        return true;
    }
}

