/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.servers.ip.engine.AbstractUserSession;
import com.sas.scheduler.api.servers.ip.engine.AccessException;
import com.sas.scheduler.api.servers.ip.engine.AssociatedAction;
import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.DeferredManagerAction;
import com.sas.scheduler.api.servers.ip.engine.ExecutionContext;
import com.sas.scheduler.api.servers.ip.engine.ExecutionItem;
import com.sas.scheduler.api.servers.ip.engine.ExecutionProvider;
import com.sas.scheduler.api.servers.ip.engine.FileDependency;
import com.sas.scheduler.api.servers.ip.engine.FileStatusListener;
import com.sas.scheduler.api.servers.ip.engine.Flow;
import com.sas.scheduler.api.servers.ip.engine.FlowHistory;
import com.sas.scheduler.api.servers.ip.engine.FlowInstance;
import com.sas.scheduler.api.servers.ip.engine.HistorySearchOptions;
import com.sas.scheduler.api.servers.ip.engine.JobRendererInfo;
import com.sas.scheduler.api.servers.ip.engine.PersistenceAction;
import com.sas.scheduler.api.servers.ip.engine.PredefinedCalendar;
import com.sas.scheduler.api.servers.ip.engine.RetryCondition;
import com.sas.scheduler.api.servers.ip.engine.RunCondition;
import com.sas.scheduler.api.servers.ip.engine.RunConditions;
import com.sas.scheduler.api.servers.ip.engine.RunningFlow;
import com.sas.scheduler.api.servers.ip.engine.RunningItem;
import com.sas.scheduler.api.servers.ip.engine.RunningJob;
import com.sas.scheduler.api.servers.ip.engine.ScheduleIDInfo;
import com.sas.scheduler.api.servers.ip.engine.ShutdownException;
import com.sas.scheduler.api.servers.ip.engine.TaskEventInterface;
import com.sas.scheduler.api.servers.ip.engine.TimeDependency;
import com.sas.scheduler.api.servers.ip.engine.TopLevelFlow;
import com.sas.scheduler.api.servers.ip.engine.TopLevelFlowIDInfo;
import com.sas.scheduler.api.servers.ip.engine.UserInfo;
import com.sas.scheduler.api.servers.ip.engine.threadpool.ThreadPool;
import com.sas.svcs.mail.client.MailServiceInterface;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FlowManager
implements TaskEventInterface {
    private static final Logger LOGGER = LogManager.getLogger(FlowManager.class);
    private Map<String, TopLevelFlow> mAllFlows;
    private Map<String, RunningFlow> mRunningFlows;
    private Map<String, Map<String, Long>> mUsedTriggerTimeMap;
    private Map<String, PredefinedCalendar> mPredefinedSchedules;
    protected Map<String, RunningJob> mRunningJobMap = new HashMap<String, RunningJob>();
    protected ExecutionProvider mExecutionProvider;
    protected ClientLogger mLogger;
    protected final Object mJobExecutionSyncObject = new Object();
    private Properties mConfig;
    private long mOverheadTime;
    private long mMaxTimerRecheckGap = 300000L;
    private Timer mUtilityTimer;
    private boolean mServerInitialized = false;
    private boolean mShuttingDown;
    private Timer mFileDependencyTimer;
    private Timer mTriggerTimer;
    private FileTriggerTimerTask mFileUpdateTask;
    private Timer mConditionTimer;
    private Timer mMaintenanceTimer;
    private MaintenanceTimerTask mMaintenanceTask;
    private Map<Long, TimeTriggerTimerTask> mTimeTriggerTimerMap;
    private Map<Long, TimeConditionTimerTask> mTimeConditionTimerMap;
    private BlockingQueue<DeferredManagerAction> mAsyncQueue;
    private Thread mAsyncThread;
    private static final String ClosingExceptionText = "Normal shutdown of FlowManager async queue";
    private boolean mRunningFlowsDirty = false;
    private boolean mAllFlowDefsDirty = false;
    private boolean mUsedTimesDirty = false;
    private static SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss:SSSS");
    static final String AnonymousUserID = "#Anonymous";
    private static Level mDefaultLogLevel = Level.INFO;
    private static ClientLogger mDefaultLogger = null;
    private int mFlowExitCalcMode = -1;
    public static final String Prop_RunningFlowExitCodeCalcStyle = "sas.dip.flowExitCodeCalcStyle";
    private MailServiceInterface mMailService;

    public static FlowManager createFlowManager(ExecutionProvider executionProvider, final ClientLogger logger) throws SecurityException {
        final FlowManager manager = new FlowManager(executionProvider, logger);
        executionProvider.setFlowManager(manager);
        manager.initialize();
        Runtime.getRuntime().addShutdownHook(new Thread("PIP Engine-Auto Shutdown"){

            @Override
            public void run() {
                manager.shutdown(null);
                logger.logMessage(Level.INFO, "Scheduling server engine (FlowManager) gracefully shut down");
            }
        });
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RunningFlow> getCurrentRunningFlows() {
        FlowManager flowManager = this;
        synchronized (flowManager) {
            ArrayList<RunningFlow> results = new ArrayList<RunningFlow>();
            for (RunningFlow rFlow : this.mRunningFlows.values()) {
                results.add((RunningFlow)rFlow.copy());
            }
            return results;
        }
    }

    boolean isRunningFlowsDirty() {
        return this.mRunningFlowsDirty || this.mRunningFlows.size() > 0;
    }

    void setRunningFlowsDirty(boolean dirty) {
        this.mRunningFlowsDirty = dirty;
    }

    boolean isAllFlowDefsDirty() {
        return this.mAllFlowDefsDirty;
    }

    void setAllFlowDefsDirty(boolean dirty) {
        this.mAllFlowDefsDirty = dirty;
    }

    boolean isUsedTimesDirty() {
        return this.mUsedTimesDirty;
    }

    void setUseTimesDirty(boolean dirty) {
        this.mUsedTimesDirty = dirty;
    }

    public Collection<RunningFlow> getLiveRunningFlows() {
        return this.mRunningFlows.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FlowTimeHolder> getCurrentTriggerWaitQueue() {
        FlowManager flowManager = this;
        synchronized (flowManager) {
            ArrayList<FlowTimeHolder> results = new ArrayList<FlowTimeHolder>();
            for (TimeTriggerTimerTask task : this.mTimeTriggerTimerMap.values()) {
                Set flows = task.mFlows;
                for (String flowID : flows) {
                    TopLevelFlow flow = this.mAllFlows.get(flowID);
                    if (flow == null) continue;
                    TopLevelFlow flowCopy = (TopLevelFlow)flow.copy(true);
                    results.add(new FlowTimeHolder(flowCopy, task.scheduledExecutionTime()));
                }
            }
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String addFlow(TopLevelFlow newFlow, boolean persist, boolean addTriggers) {
        boolean saved;
        FlowManager flowManager = this;
        synchronized (flowManager) {
            if (newFlow.getID().length() == 0) {
                newFlow.setID(this.mExecutionProvider.getNewFlowID(newFlow));
                if (newFlow.getID() == null || newFlow.getID().length() == 0) {
                    this.mLogger.logMessage(Level.WARNING, FlowManager.generateLogString("Add Flow", newFlow, "Null flow ID created."));
                    return null;
                }
                TopLevelFlow existingFlow = this.mAllFlows.get(newFlow.getID());
                if (existingFlow != null && !existingFlow.isRestoredFlow()) {
                    this.mLogger.logMessage(Level.WARNING, FlowManager.generateLogString("Add Flow", newFlow, "Duplicate flow ID created"));
                    return null;
                }
            }
        }
        if (persist && !(saved = this.mExecutionProvider.saveFlowDefinitionAsync(newFlow))) {
            return null;
        }
        FlowManager flowManager2 = this;
        synchronized (flowManager2) {
            this.mLogger.logMessage(Level.FINE, FlowManager.generateLogString("Add Flow", newFlow, "Flow added to system."));
            this.mAllFlows.put(newFlow.getID(), newFlow);
            this.setAllFlowDefsDirty(true);
            if (addTriggers) {
                this.addTriggersForFlow(newFlow);
            }
        }
        return newFlow.getID();
    }

    private void addTriggersForFlow(TopLevelFlow flow) {
        ArrayList<TopLevelFlow> tempFlows = new ArrayList<TopLevelFlow>();
        tempFlows.add(flow);
        this.processFlowTriggers(tempFlows);
        ArrayList<FileStatusListener> requiredTimers = new ArrayList<FileStatusListener>();
        flow.findRequiredFileTimers(requiredTimers);
        for (FileStatusListener listener : requiredTimers) {
            this.addFileStatusTrigger(listener, flow);
        }
    }

    protected FlowManager(ExecutionProvider executionProvider, ClientLogger logger) {
        this.mExecutionProvider = executionProvider;
        this.mLogger = logger;
        this.mAsyncQueue = new LinkedBlockingQueue<DeferredManagerAction>();
        this.mAsyncThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            DeferredManagerAction nextAction;
                            if ((nextAction = (DeferredManagerAction)FlowManager.this.mAsyncQueue.take()) == null) {
                                continue;
                            }
                            nextAction.execute();
                        }
                    }
                    catch (ShutdownException e) {
                        FlowManager.this.mLogger.logMessage(Level.FINE, e.getMessage());
                    }
                    catch (Throwable t) {
                        FlowManager.this.mLogger.logMessage(Level.WARNING, t);
                        continue;
                    }
                    break;
                }
            }
        }, "IP-FlowManager async queue");
        this.mAsyncThread.start();
    }

    public synchronized void initialize() throws SecurityException {
        this.mServerInitialized = false;
        this.mOverheadTime = 0L;
        if (this.mExecutionProvider.isMaster()) {
            this.mLogger.logMessage(Level.INFO, FlowManager.generateLogString("Init", "Schedule engine initializing."));
        }
        this.mShuttingDown = false;
        this.mAllFlows = new HashMap<String, TopLevelFlow>();
        this.mRunningFlows = new HashMap<String, RunningFlow>();
        if (this.mExecutionProvider.isMaster()) {
            this.mUsedTriggerTimeMap = this.mExecutionProvider.getUsedTimes();
        }
        if (this.mUsedTriggerTimeMap == null) {
            this.mUsedTriggerTimeMap = new HashMap<String, Map<String, Long>>();
        }
        this.mPredefinedSchedules = new HashMap<String, PredefinedCalendar>();
        if (this.mUtilityTimer != null) {
            this.mUtilityTimer.cancel();
        }
        this.mUtilityTimer = new Timer();
        if (this.mTriggerTimer != null) {
            this.mTriggerTimer.cancel();
        }
        this.mTriggerTimer = new Timer();
        if (this.mFileDependencyTimer != null) {
            this.mFileDependencyTimer.cancel();
        }
        this.mFileDependencyTimer = new Timer();
        this.mFileUpdateTask = new FileTriggerTimerTask(this);
        if (this.mConditionTimer != null) {
            this.mConditionTimer.cancel();
        }
        this.mConditionTimer = new Timer();
        this.mTimeTriggerTimerMap = new HashMap<Long, TimeTriggerTimerTask>();
        this.mTimeConditionTimerMap = new HashMap<Long, TimeConditionTimerTask>();
        if (this.mMaintenanceTimer != null) {
            this.mMaintenanceTimer.cancel();
        }
        this.mMaintenanceTimer = new Timer();
        this.mMaintenanceTask = new MaintenanceTimerTask(this);
        long maintenancePeriod = 21600000L;
        if (this.mExecutionProvider.isFullPersistenceRequired()) {
            maintenancePeriod = 900000L;
        }
        this.mMaintenanceTimer.schedule((TimerTask)this.mMaintenanceTask, maintenancePeriod, maintenancePeriod);
        if (this.mExecutionProvider.isMaster()) {
            this.readCalendarsFromStorage();
        }
        if (this.mExecutionProvider.isMaster()) {
            List<TopLevelFlow> allFlows = this.mExecutionProvider.getPersistedFlows();
            for (TopLevelFlow flow : allFlows) {
                this.addFlow(flow, false, false);
            }
            FlowInstance[] runningFlows = this.mExecutionProvider.getRunningFlowInstances();
            ArrayList<RunningFlow> restoredFlows = new ArrayList<RunningFlow>();
            for (FlowInstance flowInstance : runningFlows) {
                if (!(flowInstance.getFlow() instanceof TopLevelFlow)) continue;
                TopLevelFlow tfl = (TopLevelFlow)flowInstance.getFlow();
                RunningFlow rFlow = new RunningFlow(this, tfl, tfl.getOwner());
                flowInstance.restoreFlowState(rFlow);
                if (rFlow.areAllSubItemsFinished()) continue;
                rFlow.addTaskEventListener(this, true);
                this.mRunningFlows.put(rFlow.getID(), rFlow);
                restoredFlows.add(rFlow);
                if (this.mAllFlows.containsKey(tfl.getID())) continue;
                tfl.markAsRestoredFlow();
                this.addFlow(tfl, false, false);
                allFlows.add(tfl);
            }
            this.mExecutionProvider.restoreRunningJobState(restoredFlows);
            this.processFlowConditions(restoredFlows);
            for (TopLevelFlow flow : allFlows) {
                this.addTriggersForFlow(flow);
            }
        }
        this.mFileDependencyTimer.schedule((TimerTask)this.mFileUpdateTask, 30000L, this.mExecutionProvider.getFileTriggerPeriod());
        if (this.mExecutionProvider.isMaster()) {
            this.mLogger.logMessage(Level.INFO, "File timer has a period of: " + this.mExecutionProvider.getFileTriggerPeriod());
            this.mLogger.logMessage(Level.INFO, FlowManager.generateLogString("Init", "Schedule engine started."));
        }
        this.mServerInitialized = true;
    }

    public void setMaxRecheckGap(long recheckGapMS) {
        this.mMaxTimerRecheckGap = recheckGapMS;
    }

    private synchronized void addToTimeTriggerMap(TopLevelFlow flow, long time) {
        TimeTriggerTimerTask task;
        Long wrappedTime = new Long(time);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(time);
        if (cal.get(13) != 0 || cal.get(14) != 0) {
            this.mLogger.logMessage(Level.FINE, "Trigger event generated with finer than minute granularity.");
        }
        if ((task = this.mTimeTriggerTimerMap.get(wrappedTime)) == null) {
            task = new TimeTriggerTimerTask(this, wrappedTime);
            this.mTimeTriggerTimerMap.put(wrappedTime, task);
            this.mTriggerTimer.schedule((TimerTask)task, new Date(time));
        }
        if (this.mServerInitialized) {
            this.mLogger.logMessage(Level.FINEST, FlowManager.generateLogString("Trigger timer", flow, "Next trigger check at: " + mSimpleDateFormat.format(new Date(time))));
        }
        task.addFlow(flow);
    }

    private synchronized void addToTimeConditionMap(RunningFlow flow, long time) {
        Long wrappedTime = new Long(time);
        TimeConditionTimerTask task = this.mTimeConditionTimerMap.get(wrappedTime);
        if (task == null) {
            task = new TimeConditionTimerTask(this);
            this.mTimeConditionTimerMap.put(wrappedTime, task);
            this.mConditionTimer.schedule((TimerTask)task, new Date(time));
        }
        this.mLogger.logMessage(Level.FINEST, FlowManager.generateLogString("Condition timer", flow, "Next condition check at: " + mSimpleDateFormat.format(new Date(time))));
        task.addFlow(flow);
    }

    private synchronized void readCalendarsFromStorage() {
        List<PredefinedCalendar> allSchedules = this.mExecutionProvider.getPredefinedCalendars();
        for (PredefinedCalendar schedule : allSchedules) {
            this.addSchedule(schedule, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String addSchedule(PredefinedCalendar newSchedule, boolean writeToDisk) {
        FlowManager flowManager = this;
        synchronized (flowManager) {
            if (newSchedule.getID().length() == 0) {
                newSchedule.setID(this.mExecutionProvider.getNextCalendarID());
            }
        }
        if (writeToDisk) {
            this.mExecutionProvider.saveCalendarAsync(newSchedule);
        }
        flowManager = this;
        synchronized (flowManager) {
            this.mPredefinedSchedules.put(newSchedule.getID(), newSchedule);
        }
        return newSchedule.getID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToRunningFlows(List<RunningFlow> l) {
        FlowManager flowManager = this;
        synchronized (flowManager) {
            for (RunningFlow rFlow : l) {
                this.mRunningFlows.put(rFlow.getID(), rFlow);
                this.setRunningFlowsDirty(true);
                this.mFileDependencyTimer.schedule((TimerTask)new FileConditionTimerTask(this, ((TopLevelFlow)rFlow.getFlow()).getID(), rFlow.getID()), 100L, this.getExecutionProvider().getFileConditionPeriod());
            }
        }
        this.processFlowConditions(l);
    }

    @Override
    public void started(RunningItem targetItem) {
        this.addActionToNoPersistenceAsyncQueue(new PerformAssociatedTasksAction(this, targetItem, true));
        if (targetItem.getParent() != null) {
            this.processRunItemStartOrFinishEvent(targetItem, true);
        }
    }

    private void processRunItemStartOrFinishEvent(final RunningItem targetItem, final boolean started) {
        if (targetItem.getParent() != null) {
            RunningItem item = targetItem;
            while (item.getParent() != null) {
                item = item.getParent();
            }
            if (item instanceof RunningFlow) {
                final RunningFlow rFlow = (RunningFlow)item;
                this.saveRunningFlowInfo(rFlow);
                this.addActionToNoPersistenceAsyncQueue(new DeferredManagerAction(this){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void execute() throws ShutdownException {
                        FlowManager manager = targetItem.getFlowManager();
                        ArrayList<RunningFlow> processList = new ArrayList<RunningFlow>();
                        FlowManager flowManager = manager;
                        synchronized (flowManager) {
                            manager.getLogger().logMessage(Level.FINER, FlowManager.generateLogString(started ? "Job Started" : "Job Completed", rFlow, "Job=" + targetItem.getName() + " " + targetItem.getUniqueID() + " Finished State: " + targetItem.getCompletionCode() + "(" + targetItem.getCompletionString() + ")"));
                            processList.add(rFlow);
                        }
                        if (processList.size() > 0) {
                            FlowManager.this.processFlowConditions(processList);
                        }
                    }
                });
            }
        }
    }

    static String generateLogString(String operation, String message) {
        return FlowManager.generateLogString(operation, null, null, null, null, message);
    }

    static String generateLogString(String operation, TopLevelFlow flow, String message) {
        String userName = flow.getUserName();
        if (userName.length() == 0) {
            userName = flow.getOwner();
        }
        return FlowManager.generateLogString(operation, flow.getID(), null, flow.getName(), userName, message);
    }

    static String generateLogString(String operation, RunningFlow flow, String message) {
        Flow flowDef = flow.getFlow();
        String flowID = "";
        flowID = flowDef instanceof TopLevelFlow ? ((TopLevelFlow)flow.getFlow()).getID() : "";
        return FlowManager.generateLogString(operation, flowID, flow.getID(), flow.getName(), flow.getInvokingUser(), message);
    }

    static String generateLogString(String operation, String flowID, String instanceID, String flowName, String userName, String message) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('(');
        buffer.append(operation);
        buffer.append(")  ");
        if (userName != null && userName.length() > 0) {
            buffer.append("User=");
            buffer.append(userName);
            buffer.append(" ");
        }
        if (flowID != null) {
            buffer.append("FlowID=");
            buffer.append(flowID);
        }
        if (instanceID != null) {
            buffer.append('(');
            buffer.append(instanceID);
            buffer.append(')');
        }
        if (flowName != null) {
            buffer.append(" [");
            buffer.append(flowName);
            buffer.append("] ");
        }
        buffer.append(" -- ");
        buffer.append(message);
        return buffer.toString();
    }

    @Override
    public void completed(RunningItem completedItem) {
        if (this.mShuttingDown) {
            return;
        }
        this.addActionToNoPersistenceAsyncQueue(new PerformAssociatedTasksAction(this, completedItem, false));
        if (completedItem.getParent() != null) {
            this.processRunItemStartOrFinishEvent(completedItem, false);
            return;
        }
        this.addActionToNoPersistenceAsyncQueue(new CompletedFlowAction(this, completedItem));
    }

    public void addActionToNoPersistenceAsyncQueue(DeferredManagerAction action) {
        try {
            this.mAsyncQueue.put(action);
        }
        catch (InterruptedException e) {
            this.mLogger.logMessage(Level.WARNING, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] deleteFlows(String sessionID, String[] flowIDs) {
        if (this.mExecutionProvider.isClusteringServer() && !this.mExecutionProvider.isMaster()) {
            return this.mExecutionProvider.getClusteringServer().deleteFlows(sessionID, flowIDs);
        }
        if (this.mShuttingDown) {
            return new String[0];
        }
        HashSet<String> failedItems = new HashSet<String>();
        FlowManager flowManager = this;
        synchronized (flowManager) {
            int i;
            UserInfo userInfo = this.checkSessionAndGetUser(sessionID);
            HashSet<String> flowSet = new HashSet<String>();
            for (i = 0; i < flowIDs.length; ++i) {
                flowSet.add(flowIDs[i]);
            }
            for (i = 0; i < flowIDs.length; ++i) {
                TopLevelFlow flow = this.mAllFlows.get(flowIDs[i]);
                if (flow != null) {
                    if (userInfo.isAdmin() || flow.isPublicDeletable() || flow.getOwner().equals(userInfo.getUserID())) {
                        this.mAllFlows.remove(flow.getID());
                        this.setAllFlowDefsDirty(true);
                        this.mExecutionProvider.deleteFlowAsync(flow);
                        this.mFileUpdateTask.removeTriggersFor(flow);
                        this.mUsedTriggerTimeMap.remove(flow.getID());
                        this.setUseTimesDirty(true);
                        this.getLogger().logMessage(Level.FINE, FlowManager.generateLogString("Delete Flow", flow, "Removed flow from Master flow list."));
                        continue;
                    }
                    failedItems.add(flowIDs[i]);
                    this.getLogger().logMessage(Level.WARNING, FlowManager.generateLogString("Delete Flow", "User " + userInfo.getUserID() + " does not have authority to delete flow: " + flow.getID()));
                    continue;
                }
                failedItems.add(flowIDs[i]);
            }
            for (RunningFlow runningFlow : this.mRunningFlows.values()) {
                String testFlowID = ((TopLevelFlow)runningFlow.getFlow()).getID();
                if (!flowSet.contains(testFlowID)) continue;
                TopLevelFlow topFlow = (TopLevelFlow)runningFlow.getFlow();
                if (!userInfo.isAdmin() && !topFlow.isPublicDeletable() && !topFlow.getOwner().equals(userInfo.getUserID())) continue;
                runningFlow.setDeleted(true);
                runningFlow.kill(true);
                this.mExecutionProvider.removeRunningFlowInstanceAsync(runningFlow.getID());
                this.mLogger.logMessage(Level.FINE, FlowManager.generateLogString("Delete Flow", runningFlow, "Issued kill command to flow that was running."));
            }
        }
        return failedItems.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] killFlowInstances(String sessionID, String[] instanceIDs, boolean force) {
        if (this.mExecutionProvider.isClusteringServer() && !this.mExecutionProvider.isMaster()) {
            return this.mExecutionProvider.getClusteringServer().killFlowInstances(sessionID, instanceIDs, force);
        }
        if (this.mShuttingDown) {
            return new String[0];
        }
        HashSet<String> failedKillIDs = new HashSet<String>();
        FlowManager flowManager = this;
        synchronized (flowManager) {
            UserInfo userInfo = this.checkSessionAndGetUser(sessionID);
            int foundCount = 0;
            for (int i = 0; i < instanceIDs.length; ++i) {
                RunningFlow flow = this.mRunningFlows.get(instanceIDs[i]);
                if (flow != null) {
                    TopLevelFlow topFlow = (TopLevelFlow)flow.getFlow();
                    if (userInfo.isAdmin() || topFlow.getOwner().equals(userInfo.getUserID()) || topFlow.isPublicKillable() || topFlow.isInvokerKillable() && flow.getInvokingUser().equals(userInfo.getUserID())) {
                        flow.kill(force);
                        flow.completed(null);
                        ++foundCount;
                        continue;
                    }
                    failedKillIDs.add(instanceIDs[i]);
                    continue;
                }
                this.mLogger.logMessage(Level.FINE, "Attempted to kill unknown flow.  ID=" + instanceIDs[i]);
                failedKillIDs.add(instanceIDs[i]);
            }
        }
        return failedKillIDs.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowHistory[] getFlowHistory(String sessionID, HistorySearchOptions options) {
        if (this.mExecutionProvider.isClusteringServer() && !this.mExecutionProvider.isMaster()) {
            return this.mExecutionProvider.getClusteringServer().getFlowHistory(sessionID, options);
        }
        if (this.mShuttingDown) {
            return new FlowHistory[0];
        }
        ArrayList<FlowHistory> results = new ArrayList<FlowHistory>();
        ArrayList<String> flowsToQuery = new ArrayList<String>();
        ArrayList<FlowHistory> capturedHistory = new ArrayList<FlowHistory>();
        FlowManager flowManager = this;
        synchronized (flowManager) {
            this.checkSessionAndGetUser(sessionID);
            HashSet<String> flowsOfInterest = new HashSet<String>();
            if (options.getFlowIDs().size() == 0) {
                flowsOfInterest.addAll(this.mAllFlows.keySet());
            }
            for (String flowID : flowsOfInterest) {
                TopLevelFlow aFlow = this.mAllFlows.get(flowID);
                if (!flowsOfInterest.contains(aFlow.getID()) || options.getOwner().length() != 0 && !options.getOwner().equals(aFlow.getOwner())) continue;
                flowsToQuery.add(aFlow.getID());
            }
            if (options.getCompletionStatusMask() == 8) {
                for (RunningFlow rFlow : this.mRunningFlows.values()) {
                    capturedHistory.add(new FlowHistory(rFlow, this.getLogger()));
                }
            }
        }
        if (options.getCompletionStatusMask() != 8) {
            FlowHistory[] histories = this.getFlowHistories(sessionID, flowsToQuery.toArray(new String[0]), 0);
            capturedHistory.addAll(Arrays.asList(histories));
        }
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        for (FlowHistory record : capturedHistory) {
            if (options.getStartTime() != null) {
                // empty if block
            }
            if (options.getEndTime() != null) {
                // empty if block
            }
            if (options.getCompletionStatusMask() != 0) {
                // empty if block
            }
            if (options.getCountPerFlow() > 0) {
                String flowID;
                flowID = record.getFlowID();
                Integer currentCount = (Integer)countMap.get(flowID);
                if (currentCount == null) {
                    currentCount = new Integer(0);
                }
                if (currentCount >= options.getCountPerFlow()) continue;
                countMap.put(flowID, new Integer(currentCount + 1));
            }
            results.add(record);
        }
        return results.toArray(new FlowHistory[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopLevelFlow[] getFlowDefinitions(String sessionID, String[] flowIDs) {
        if (this.mExecutionProvider.isClusteringServer() && !this.mExecutionProvider.isMaster()) {
            return this.mExecutionProvider.getClusteringServer().getFlowDefinitions(sessionID, flowIDs);
        }
        if (this.mShuttingDown) {
            return new TopLevelFlow[0];
        }
        FlowManager flowManager = this;
        synchronized (flowManager) {
            UserInfo userInfo = this.checkSessionAndGetUser(sessionID);
            ArrayList<TopLevelFlow> returnList = new ArrayList<TopLevelFlow>();
            for (int i = 0; i < flowIDs.length; ++i) {
                TopLevelFlow flow = this.mAllFlows.get(flowIDs[i]);
                if (flow == null || !userInfo.isAdmin() && !flow.isPublicViewable() && !flow.getOwner().equals(userInfo.getUserID())) continue;
                returnList.add(flow);
            }
            return returnList.toArray(new TopLevelFlow[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean killExecutionItem(String sessionID, String flowInstanceID, String subItemID, boolean force) {
        if (this.mExecutionProvider.isClusteringServer() && !this.mExecutionProvider.isMaster()) {
            return this.mExecutionProvider.getClusteringServer().killExecutionItem(sessionID, flowInstanceID, subItemID, force);
        }
        if (this.mShuttingDown) {
            return false;
        }
        FlowManager flowManager = this;
        synchronized (flowManager) {
            UserInfo userInfo = this.checkSessionAndGetUser(sessionID);
            boolean found = false;
            RunningFlow flow = this.mRunningFlows.get(flowInstanceID);
            if (flow != null) {
                TopLevelFlow topFlow = (TopLevelFlow)flow.getFlow();
                if (userInfo.isAdmin() || topFlow.getOwner().equals(userInfo.getUserID()) || topFlow.isPublicKillable() || topFlow.isInvokerKillable() && flow.getInvokingUser().equals(userInfo.getUserID())) {
                    found = flow.kill(subItemID, force);
                }
            }
            return found;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] runFlows(String sessionID, String[] flowIDs) {
        if (this.mExecutionProvider.isClusteringServer() && !this.mExecutionProvider.isMaster()) {
            return this.mExecutionProvider.getClusteringServer().runFlows(sessionID, flowIDs);
        }
        String[] returnIDs = new String[flowIDs.length];
        if (this.mShuttingDown) {
            return returnIDs;
        }
        ArrayList<RunningFlow> triggerList = new ArrayList<RunningFlow>();
        FlowManager flowManager = this;
        synchronized (flowManager) {
            UserInfo userInfo = this.checkSessionAndGetUser(sessionID);
            for (int i = 0; i < flowIDs.length; ++i) {
                TopLevelFlow flow = this.mAllFlows.get(flowIDs[i]);
                if (flow != null) {
                    if (!userInfo.isAdmin() && !flow.isPublicRunnable() && !flow.getOwner().equals(userInfo.getUserID())) continue;
                    int maxLimit = this.mExecutionProvider.getMaxRunningFlowLimit();
                    if (maxLimit > 0 && this.mRunningFlows.size() >= maxLimit) {
                        this.mLogger.logMessage(Level.FINE, FlowManager.generateLogString("Run Flow", flow, "Unable to trigger flow.  Max running flows reached=" + maxLimit));
                        continue;
                    }
                    if (flow.getInstanceLimit() > 0) {
                        int count = 0;
                        for (RunningFlow rFlow : this.mRunningFlows.values()) {
                            Flow f = rFlow.getFlow();
                            if (!(f instanceof TopLevelFlow) || !((TopLevelFlow)f).getID().equals(flow.getID())) continue;
                            ++count;
                        }
                        if (count >= flow.getInstanceLimit()) {
                            this.mLogger.logMessage(Level.FINE, "Can't trigger flow because instance limit exceeded: " + flow.getID());
                            continue;
                        }
                    }
                    RunningFlow rFlow = new RunningFlow(this, flow, userInfo.getUserID());
                    rFlow.getFlow().incrementPriority(1, true);
                    rFlow.addTaskEventListener(this, true);
                    this.mLogger.logMessage(Level.FINE, FlowManager.generateLogString("Run Flow", rFlow, "Triggering flow."));
                    rFlow.trigger();
                    triggerList.add(rFlow);
                    returnIDs[i] = rFlow.getID();
                    continue;
                }
                this.getLogger().logMessage(Level.WARNING, FlowManager.generateLogString("Run Flow", "Flow ID not found in master list: " + flowIDs[i]));
            }
        }
        this.addToRunningFlows(triggerList);
        return returnIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean triggerExecutionItem(String sessionID, String flowInstanceID, String subItemID) {
        if (this.mExecutionProvider.isClusteringServer() && !this.mExecutionProvider.isMaster()) {
            return this.mExecutionProvider.getClusteringServer().triggerExecutionItem(sessionID, flowInstanceID, subItemID);
        }
        if (this.mShuttingDown) {
            return false;
        }
        ArrayList<RunningFlow> tempList = new ArrayList<RunningFlow>();
        FlowManager flowManager = this;
        synchronized (flowManager) {
            UserInfo userInfo = this.checkSessionAndGetUser(sessionID);
            RunningFlow flow = this.mRunningFlows.get(flowInstanceID);
            if (flow != null) {
                TopLevelFlow topFlow = (TopLevelFlow)flow.getFlow();
                if (userInfo.isAdmin() || topFlow.isPublicTriggerable() || topFlow.getOwner().equals(userInfo.getUserID()) || topFlow.isInvokerTriggerable() && flow.getInvokingUser().equals(userInfo.getUserID())) {
                    flow.trigger(subItemID);
                    tempList.add(flow);
                    this.processFlowConditions(tempList);
                }
            }
        }
        return tempList.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowInstance[] getInstanceDefinitions(String sessionID, String[] instanceIDs) {
        TopLevelFlow topFlow;
        if (this.mExecutionProvider.isClusteringServer() && !this.mExecutionProvider.isMaster()) {
            return this.mExecutionProvider.getClusteringServer().getInstanceDefinitions(sessionID, instanceIDs);
        }
        if (this.mShuttingDown) {
            return new FlowInstance[0];
        }
        ArrayList<FlowInstance> resultList = new ArrayList<FlowInstance>();
        HashSet<String> instanceIDSet = new HashSet<String>();
        UserInfo userInfo = null;
        FlowManager flowManager = this;
        synchronized (flowManager) {
            int i;
            userInfo = this.checkSessionAndGetUser(sessionID);
            for (i = 0; i < instanceIDs.length; ++i) {
                instanceIDSet.add(instanceIDs[i]);
            }
            for (i = 0; i < instanceIDs.length; ++i) {
                RunningFlow runningFlow = this.mRunningFlows.get(instanceIDs[i]);
                if (runningFlow == null) continue;
                topFlow = (TopLevelFlow)runningFlow.getFlow();
                if (userInfo.isAdmin() || topFlow.isPublicViewable() || topFlow.getOwner().equals(userInfo.getUserID()) || runningFlow.getInvokingUser().equals(userInfo.getUserID())) {
                    FlowInstance flowInstance = new FlowInstance(runningFlow.getFlow(), new FlowHistory(runningFlow, this.getLogger()));
                    resultList.add(flowInstance);
                }
                instanceIDSet.remove(runningFlow.getID());
            }
        }
        for (String instanceID : instanceIDSet) {
            FlowInstance instance = this.mExecutionProvider.getFlowInstance(instanceID);
            if (instance == null) continue;
            topFlow = (TopLevelFlow)instance.getFlow();
            if (!userInfo.isAdmin() && !topFlow.isPublicViewable() && !topFlow.getOwner().equals(userInfo.getUserID()) && !instance.getFlowHistory().getInvoker().equals(userInfo.getUserID())) continue;
            resultList.add(instance);
        }
        return resultList.toArray(new FlowInstance[0]);
    }

    public boolean terminateSession(String sessionID) {
        if (this.mExecutionProvider.isClusteringServer() && !this.mExecutionProvider.isMaster()) {
            return this.mExecutionProvider.getClusteringServer().terminateSession(sessionID);
        }
        if (this.mShuttingDown) {
            return false;
        }
        return this.mExecutionProvider.terminateSession(this, sessionID);
    }

    @Deprecated
    public AbstractUserSession createSession(String userID, String password) {
        return this.createSession(userID, password != null ? new SealedString(password) : null);
    }

    public AbstractUserSession createSession(String userID, SealedString password) {
        if (this.mExecutionProvider.isClusteringServer() && !this.mExecutionProvider.isMaster()) {
            return this.mExecutionProvider.getClusteringServer().createSession(userID, password);
        }
        if (this.mShuttingDown) {
            return null;
        }
        UserInfo user = this.mExecutionProvider.getUserSealedString(userID, password);
        if (user == null) {
            this.mLogger.logMessage(Level.WARNING, FlowManager.generateLogString("Create Session", "User failed to log in: " + userID));
            return null;
        }
        AbstractUserSession session = this.mExecutionProvider.createSession(this, user);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(String sessionID) {
        FlowManager flowManager = this;
        synchronized (flowManager) {
            block8: {
                UserInfo userInfo;
                if (this.mShuttingDown) {
                    return;
                }
                if (sessionID != null && !(userInfo = this.checkSessionAndGetUser(sessionID)).isAdmin()) {
                    throw new AccessException("Not an admin");
                }
                this.mShuttingDown = true;
                if (this.mExecutionProvider.isMaster()) {
                    this.mLogger.logMessage(Level.INFO, FlowManager.generateLogString("Shutdown", "Shutting down server..."));
                }
                try {
                    this.mAsyncQueue.put(new ShutdownAction(this));
                }
                catch (InterruptedException e) {
                    if (e.getMessage().equals(ClosingExceptionText)) break block8;
                    this.mLogger.logMessage(Level.WARNING, e);
                }
            }
            this.mConditionTimer.cancel();
            this.mTriggerTimer.cancel();
            this.mMaintenanceTimer.cancel();
            this.mFileDependencyTimer.cancel();
            this.mUtilityTimer.cancel();
            ThreadPool.instance().completeShutdown();
            this.mExecutionProvider.performOnTheFlyPersistedDataCleanup();
            this.mRunningFlows.clear();
        }
        long timeout = 0L;
        this.mExecutionProvider.shutdown(timeout);
    }

    public void shutDownServer(String sessionID) {
        if (this.mExecutionProvider.isClusteringServer() && !this.mExecutionProvider.isMaster()) {
            this.mExecutionProvider.getClusteringServer().shutDownServer(sessionID);
            return;
        }
        this.shutdown(sessionID);
        this.mLogger.logMessage(Level.INFO, FlowManager.generateLogString("Shutdown", "Server shutdown complete"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopLevelFlowIDInfo[] getAllFlowIDs(String sessionID) {
        if (this.mExecutionProvider.isClusteringServer() && !this.mExecutionProvider.isMaster()) {
            return this.mExecutionProvider.getClusteringServer().getAllFlowIDs(sessionID);
        }
        if (this.mShuttingDown) {
            return new TopLevelFlowIDInfo[0];
        }
        FlowManager flowManager = this;
        synchronized (flowManager) {
            UserInfo userInfo = this.checkSessionAndGetUser(sessionID);
            ArrayList<TopLevelFlowIDInfo> results = new ArrayList<TopLevelFlowIDInfo>();
            for (TopLevelFlow flow : this.mAllFlows.values()) {
                if (!userInfo.isAdmin() && !flow.isPublicViewable() && !flow.getOwner().equals(userInfo.getUserID())) continue;
                TopLevelFlowIDInfo info = new TopLevelFlowIDInfo();
                info.setDescription(flow.getDescription());
                info.setName(flow.getName());
                info.setID(flow.getID());
                info.setHeld(flow.isHeld());
                results.add(info);
            }
            return results.toArray(new TopLevelFlowIDInfo[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOutputStreamData(String sessionID, String flowID, String instanceID, String uniqueSubitemID, long startPos, int maxCharacters, StringBuffer buffer) {
        if (this.mExecutionProvider.isClusteringServer() && !this.mExecutionProvider.isMaster()) {
            return this.mExecutionProvider.getClusteringServer().getOutputStreamData(sessionID, flowID, instanceID, uniqueSubitemID, startPos, maxCharacters, buffer);
        }
        if (this.mShuttingDown) {
            return -1;
        }
        FlowManager flowManager = this;
        synchronized (flowManager) {
            this.checkSessionAndGetUser(sessionID);
        }
        return this.mExecutionProvider.getOutputStreamData(flowID, instanceID, uniqueSubitemID, startPos, maxCharacters, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getErrorStreamData(String sessionID, String flowID, String instanceID, String uniqueSubitemID, long startPos, int maxCharacters, StringBuffer buffer) {
        if (this.mExecutionProvider.isClusteringServer() && !this.mExecutionProvider.isMaster()) {
            return this.mExecutionProvider.getClusteringServer().getErrorStreamData(sessionID, flowID, instanceID, uniqueSubitemID, startPos, maxCharacters, buffer);
        }
        if (this.mShuttingDown) {
            return -1;
        }
        FlowManager flowManager = this;
        synchronized (flowManager) {
            this.checkSessionAndGetUser(sessionID);
        }
        return this.mExecutionProvider.getErrorStreamData(flowID, instanceID, uniqueSubitemID, startPos, maxCharacters, buffer);
    }

    public Collection<JobRendererInfo> getJobRendererSnapshots() {
        if (this.mExecutionProvider.isClusteringServer() && !this.mExecutionProvider.isMaster()) {
            return this.mExecutionProvider.getClusteringServer().getJobRendererSnapshots();
        }
        if (this.mShuttingDown) {
            return new ArrayList<JobRendererInfo>();
        }
        return this.mExecutionProvider.getJobRendererSnapshots();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setJobRoutingRulesXML(String sessionID, String xml) {
        if (this.mExecutionProvider.isClusteringServer() && !this.mExecutionProvider.isMaster()) {
            return this.mExecutionProvider.getClusteringServer().setJobRoutingRulesXML(sessionID, xml);
        }
        if (this.mShuttingDown) {
            return false;
        }
        FlowManager flowManager = this;
        synchronized (flowManager) {
            this.checkSessionAndGetUser(sessionID);
        }
        return this.mExecutionProvider.setJobRoutingRulesXML(xml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJobRoutingRulesXML(String sessionID) {
        if (this.mExecutionProvider.isClusteringServer() && !this.mExecutionProvider.isMaster()) {
            return this.mExecutionProvider.getClusteringServer().getJobRoutingRulesXML(sessionID);
        }
        if (this.mShuttingDown) {
            return "";
        }
        FlowManager flowManager = this;
        synchronized (flowManager) {
            this.checkSessionAndGetUser(sessionID);
        }
        return this.mExecutionProvider.getJobRoutingRulesXML();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateFlow(String sessionID, TopLevelFlow flow) {
        if (flow == null) {
            return false;
        }
        if (this.mExecutionProvider.isClusteringServer() && !this.mExecutionProvider.isMaster()) {
            return this.mExecutionProvider.getClusteringServer().updateFlow(sessionID, flow);
        }
        if (this.mShuttingDown) {
            return false;
        }
        FlowManager flowManager = this;
        synchronized (flowManager) {
            UserInfo userInfo = this.checkSessionAndGetUser(sessionID);
            if (flow.getID().length() == 0) {
                return false;
            }
            TopLevelFlow existingFlow = this.mAllFlows.get(flow.getID());
            if (existingFlow != null) {
                if (!(userInfo.isAdmin() || existingFlow.isPublicEditable() || existingFlow.getOwner().equals(userInfo.getUserID()))) {
                    this.mLogger.logMessage(Level.WARNING, FlowManager.generateLogString("Update Flow", existingFlow, "You do not have permission to update flow"));
                    return false;
                }
                if (!userInfo.isAdmin()) {
                    flow.setOwner(existingFlow.getOwner());
                }
                this.mAllFlows.remove(flow.getID());
                this.setAllFlowDefsDirty(true);
            }
            this.mFileUpdateTask.removeTriggersFor(flow);
            if (!userInfo.isAdmin()) {
                this.clearRunAsUsers(flow);
            }
        }
        this.assignConditionIDs(flow);
        boolean success = this.addFlow(flow, true, true) != null;
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAdministrator(String sessionID) {
        if (this.mExecutionProvider.isClusteringServer() && !this.mExecutionProvider.isMaster()) {
            return this.mExecutionProvider.getClusteringServer().isAdministrator(sessionID);
        }
        if (this.mShuttingDown) {
            return false;
        }
        FlowManager flowManager = this;
        synchronized (flowManager) {
            UserInfo userInfo = this.checkSessionAndGetUser(sessionID);
            return userInfo.isAdmin();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] addFlows(String sessionID, TopLevelFlow[] newFlows) {
        if (this.mExecutionProvider.isClusteringServer() && !this.mExecutionProvider.isMaster()) {
            return this.mExecutionProvider.getClusteringServer().addFlows(sessionID, newFlows);
        }
        if (this.mShuttingDown) {
            return new String[newFlows.length];
        }
        UserInfo userInfo = null;
        FlowManager flowManager = this;
        synchronized (flowManager) {
            userInfo = this.checkSessionAndGetUser(sessionID);
        }
        String[] returnIDs = new String[newFlows.length];
        for (int i = 0; i < newFlows.length; ++i) {
            TopLevelFlow newFlow = newFlows[i];
            if (newFlow == null || newFlow.getID().length() > 0) continue;
            if (!userInfo.isAdmin() || newFlow.getOwner().length() == 0) {
                newFlow.setOwner(userInfo.getUserID());
            } else {
                newFlow.setOwner(this.mExecutionProvider.getCanonicalUserID(newFlow.getOwner()));
            }
            if (!userInfo.isAdmin()) {
                this.clearRunAsUsers(newFlow);
            }
            this.assignConditionIDs(newFlow);
            String newID = this.addFlow(newFlow, true, true);
            if (newID == null) continue;
            returnIDs[i] = newID;
        }
        return returnIDs;
    }

    private void assignConditionIDs(TopLevelFlow flow) {
        RunCondition triggers = flow.getTriggerConditions();
        triggers.recalculateID(null);
    }

    public static boolean canSeeHistoryRecord(UserInfo userInfo, FlowHistory history) {
        return userInfo.isAdmin() || history.getOwner().equals(userInfo.getUserID()) || history.isPublicHistory() || history.isInvokerHistory() && history.getInvoker().equals(userInfo.getUserID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowHistory[] getFlowHistories(String sessionID, String[] flowIDs, int countPerFlow) {
        if (this.mExecutionProvider.isClusteringServer() && !this.mExecutionProvider.isMaster()) {
            return this.mExecutionProvider.getClusteringServer().getFlowHistories(sessionID, flowIDs, countPerFlow);
        }
        if (this.mShuttingDown) {
            return new FlowHistory[0];
        }
        List<Object> resultHistories = new ArrayList();
        ArrayList<FlowHistory> runningFlowHistories = new ArrayList<FlowHistory>();
        HashMap<TopLevelFlow, Integer> historyRequestMap = new HashMap<TopLevelFlow, Integer>();
        UserInfo userInfo = null;
        FlowManager flowManager = this;
        synchronized (flowManager) {
            userInfo = this.checkSessionAndGetUser(sessionID);
            if (countPerFlow < 0) {
                return resultHistories.toArray(new FlowHistory[0]);
            }
            HashSet<String> flowSearchIDs = new HashSet<String>();
            for (int i = 0; i < flowIDs.length; ++i) {
                flowSearchIDs.add(flowIDs[i]);
            }
            for (RunningFlow runningFlow : this.mRunningFlows.values()) {
                Integer currentRemaining;
                if (!flowSearchIDs.contains(((TopLevelFlow)runningFlow.getFlow()).getID())) continue;
                TopLevelFlow topFlow = (TopLevelFlow)runningFlow.getFlow();
                if (!userInfo.isAdmin() && !topFlow.isPublicHistory() && !topFlow.getOwner().equals(userInfo.getUserID()) && (!topFlow.isInvokerHistory() || !runningFlow.getInvokingUser().equals(userInfo.getUserID())) || (currentRemaining = (Integer)historyRequestMap.get(topFlow)) != null && currentRemaining <= 0) continue;
                FlowHistory fh = new FlowHistory(runningFlow, this.getLogger());
                runningFlowHistories.add(fh);
                if (currentRemaining == null) {
                    if (countPerFlow == 0) continue;
                    historyRequestMap.put(topFlow, new Integer(countPerFlow - 1));
                    continue;
                }
                historyRequestMap.put(topFlow, new Integer(currentRemaining - 1));
            }
            for (int i = 0; i < flowIDs.length; ++i) {
                TopLevelFlow topLevelFlow = this.mAllFlows.get(flowIDs[i]);
                if (topLevelFlow == null) continue;
                Integer currentRemaining = (Integer)historyRequestMap.get(topLevelFlow);
                if (currentRemaining == null) {
                    historyRequestMap.put(topLevelFlow, new Integer(countPerFlow));
                    continue;
                }
                if (currentRemaining > 0) continue;
                historyRequestMap.remove(topLevelFlow);
            }
        }
        try {
            resultHistories = this.mExecutionProvider.getFlowHistory(historyRequestMap, userInfo);
        }
        catch (RuntimeException e) {
            this.getLogger().logMessage(Level.WARNING, e);
        }
        ArrayList<FlowHistory> finalFlowHistories = new ArrayList<FlowHistory>();
        runningFlowHistories.addAll(resultHistories);
        HashSet<String> instanceIDs = new HashSet<String>();
        for (FlowHistory flowHistory : runningFlowHistories) {
            if (instanceIDs.contains(flowHistory.getID())) {
                this.getLogger().logMessage(Level.FINER, FlowManager.generateLogString("Get History", "Extra history record removed for: " + flowHistory.getID()));
                continue;
            }
            instanceIDs.add(flowHistory.getID());
            finalFlowHistories.add(flowHistory);
        }
        return finalFlowHistories.toArray(new FlowHistory[0]);
    }

    public int getMaxHistoryRecordsPerFlow() {
        return this.mExecutionProvider.getMaxHistoryRecordsPerFlow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] holdFlows(String sessionID, String[] flowIDs) {
        if (this.mExecutionProvider.isClusteringServer() && !this.mExecutionProvider.isMaster()) {
            return this.mExecutionProvider.getClusteringServer().holdFlows(sessionID, flowIDs);
        }
        if (this.mShuttingDown) {
            return new String[flowIDs.length];
        }
        String[] returnIDs = new String[flowIDs.length];
        FlowManager flowManager = this;
        synchronized (flowManager) {
            UserInfo userInfo = this.checkSessionAndGetUser(sessionID);
            for (int i = 0; i < flowIDs.length; ++i) {
                TopLevelFlow flow = this.mAllFlows.get(flowIDs[i]);
                if (flow == null || !userInfo.isAdmin() && !flow.isPublicEditable() && !flow.getOwner().equals(userInfo.getUserID())) continue;
                flow.setHeld(true);
                this.setAllFlowDefsDirty(true);
                returnIDs[i] = flowIDs[i];
                this.mExecutionProvider.saveFlowDefinitionAsync(flow);
            }
        }
        return returnIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] releaseFlows(String sessionID, String[] flowIDs) {
        if (this.mExecutionProvider.isClusteringServer() && !this.mExecutionProvider.isMaster()) {
            return this.mExecutionProvider.getClusteringServer().releaseFlows(sessionID, flowIDs);
        }
        String[] returnIDs = new String[flowIDs.length];
        if (this.mShuttingDown) {
            return returnIDs;
        }
        ArrayList<TopLevelFlow> flowsToTrigger = new ArrayList<TopLevelFlow>();
        FlowManager flowManager = this;
        synchronized (flowManager) {
            UserInfo userInfo = this.checkSessionAndGetUser(sessionID);
            for (int i = 0; i < flowIDs.length; ++i) {
                TopLevelFlow flow = this.mAllFlows.get(flowIDs[i]);
                if (flow == null || !userInfo.isAdmin() && !flow.isPublicEditable() && !flow.getOwner().equals(userInfo.getUserID())) continue;
                flow.setHeld(false);
                this.setAllFlowDefsDirty(true);
                flowsToTrigger.add(flow);
                returnIDs[i] = flowIDs[i];
            }
        }
        for (TopLevelFlow flow : flowsToTrigger) {
            this.mExecutionProvider.saveFlowDefinitionAsync(flow);
        }
        this.processFlowTriggers(flowsToTrigger);
        return returnIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFlowID(String sessionID, String flowName) {
        if (this.mExecutionProvider.isClusteringServer() && !this.mExecutionProvider.isMaster()) {
            return this.mExecutionProvider.getClusteringServer().getFlowID(sessionID, flowName);
        }
        if (this.mShuttingDown) {
            return null;
        }
        FlowManager flowManager = this;
        synchronized (flowManager) {
            for (TopLevelFlow topFlow : this.mAllFlows.values()) {
                if (!topFlow.getName().equals(flowName)) continue;
                return topFlow.getID();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[][] isPredefinedCalendarInUse(String sessionID, String scheduleID) {
        if (this.mExecutionProvider.isClusteringServer() && !this.mExecutionProvider.isMaster()) {
            return this.mExecutionProvider.getClusteringServer().isPredefinedCalendarInUse(sessionID, scheduleID);
        }
        if (this.mShuttingDown) {
            return new String[0][];
        }
        FlowManager flowManager = this;
        synchronized (flowManager) {
            UserInfo userInfo = this.checkSessionAndGetUser(sessionID);
            ArrayList<String> schedulesInUse = new ArrayList<String>();
            HashSet<String> usersInUse = new HashSet<String>();
            PredefinedCalendar schedule = this.mPredefinedSchedules.get(scheduleID);
            if (userInfo.isAdmin() || schedule.getOwnerID().equals(userInfo.getUserID())) {
                block3: for (TopLevelFlow topFlow : this.mAllFlows.values()) {
                    ArrayList<TimeDependency> output = new ArrayList<TimeDependency>();
                    RunCondition trigger = topFlow.getTriggerConditions();
                    RunCondition runCondition = topFlow.getRunConditions();
                    TimeDependency.findTimeDependencies(trigger, output);
                    TimeDependency.findTimeDependencies(runCondition, output);
                    ArrayList<ExecutionItem> flattenedList = new ArrayList<ExecutionItem>();
                    topFlow.getAllSubItems(flattenedList);
                    for (ExecutionItem executionItem : flattenedList) {
                        RunCondition itemCondition = executionItem.getRunConditions();
                        TimeDependency.findTimeDependencies(itemCondition, output);
                    }
                    for (TimeDependency timeDep : output) {
                        if (timeDep.getCalendarID() == null || !timeDep.getCalendarID().equals(scheduleID)) continue;
                        if (userInfo.isAdmin() || topFlow.isPublicViewable() || userInfo.getUserID().equals(topFlow.getOwner())) {
                            schedulesInUse.add(topFlow.getID());
                            continue block3;
                        }
                        usersInUse.add(topFlow.getOwner());
                        continue block3;
                    }
                }
            }
            String[] schedulesArray = schedulesInUse.toArray(new String[0]);
            String[] usersArray = usersInUse.toArray(new String[0]);
            String[][] returnArray = new String[][]{schedulesArray, usersArray};
            return returnArray;
        }
    }

    public String[] addPredefinedCalendars(String sessionID, PredefinedCalendar[] calendars) {
        if (this.mExecutionProvider.isClusteringServer() && !this.mExecutionProvider.isMaster()) {
            return this.mExecutionProvider.getClusteringServer().addPredefinedCalendars(sessionID, calendars);
        }
        if (this.mShuttingDown) {
            return new String[calendars.length];
        }
        UserInfo userInfo = this.checkSessionAndGetUser(sessionID);
        String[] returnIDs = new String[calendars.length];
        for (int i = 0; i < calendars.length; ++i) {
            String newID;
            PredefinedCalendar schedule = calendars[i];
            if (schedule == null || schedule.getID().length() > 0) continue;
            if (!userInfo.isAdmin() || schedule.getOwnerID().length() == 0) {
                schedule.setOwnerID(userInfo.getUserID());
            } else {
                schedule.setOwnerID(this.mExecutionProvider.getCanonicalUserID(schedule.getOwnerID()));
            }
            returnIDs[i] = newID = this.addSchedule(schedule, true);
        }
        return returnIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PredefinedCalendar[] getPredefinedCalendars(String sessionID, String[] calendarIDs) {
        if (this.mExecutionProvider.isClusteringServer() && !this.mExecutionProvider.isMaster()) {
            return this.mExecutionProvider.getClusteringServer().getPredefinedCalendars(sessionID, calendarIDs);
        }
        if (this.mShuttingDown) {
            return new PredefinedCalendar[0];
        }
        FlowManager flowManager = this;
        synchronized (flowManager) {
            UserInfo userInfo = this.checkSessionAndGetUser(sessionID);
            ArrayList<PredefinedCalendar> returnList = new ArrayList<PredefinedCalendar>();
            for (int i = 0; i < calendarIDs.length; ++i) {
                PredefinedCalendar schedule = this.mPredefinedSchedules.get(calendarIDs[i]);
                if (!userInfo.isAdmin() && !schedule.isPubliclyUsable() && !schedule.getOwnerID().equals(userInfo.getUserID())) continue;
                returnList.add(schedule);
            }
            return returnList.toArray(new PredefinedCalendar[0]);
        }
    }

    public ExecutionProvider getExecutionProvider() {
        return this.mExecutionProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduleIDInfo[] getPredefinedCalendarIDInfos(String sessionID) {
        if (this.mExecutionProvider.isClusteringServer() && !this.mExecutionProvider.isMaster()) {
            return this.mExecutionProvider.getClusteringServer().getPredefinedCalendarIDInfos(sessionID);
        }
        if (this.mShuttingDown) {
            return new ScheduleIDInfo[0];
        }
        FlowManager flowManager = this;
        synchronized (flowManager) {
            UserInfo userInfo = this.checkSessionAndGetUser(sessionID);
            ArrayList<ScheduleIDInfo> results = new ArrayList<ScheduleIDInfo>();
            for (PredefinedCalendar schedule : this.mPredefinedSchedules.values()) {
                if (!userInfo.isAdmin() && !schedule.isPubliclyUsable() && !schedule.getOwnerID().equals(userInfo.getUserID())) continue;
                ScheduleIDInfo info = new ScheduleIDInfo();
                info.setDescription(schedule.getDescription());
                info.setName(schedule.getName());
                info.setID(schedule.getID());
                info.setOwnerID(schedule.getOwnerID());
                info.setPubliclyUsable(schedule.isPubliclyUsable());
                results.add(info);
            }
            return results.toArray(new ScheduleIDInfo[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updatePredefinedCalendar(String sessionID, PredefinedCalendar newCalendarDef) {
        boolean success;
        if (this.mExecutionProvider.isClusteringServer() && !this.mExecutionProvider.isMaster()) {
            return this.mExecutionProvider.getClusteringServer().updatePredefinedCalendar(sessionID, newCalendarDef);
        }
        if (this.mShuttingDown) {
            return false;
        }
        UserInfo userInfo = this.checkSessionAndGetUser(sessionID);
        if (newCalendarDef == null) {
            return false;
        }
        if (newCalendarDef.getID().length() == 0) {
            return false;
        }
        PredefinedCalendar existingSchedule = null;
        FlowManager flowManager = this;
        synchronized (flowManager) {
            existingSchedule = this.mPredefinedSchedules.get(newCalendarDef.getID());
            if (existingSchedule == null) {
                return false;
            }
        }
        if (!userInfo.isAdmin() && !existingSchedule.getOwnerID().equals(userInfo.getUserID())) {
            this.mLogger.logMessage(Level.WARNING, FlowManager.generateLogString("Update Predefined Schedule", "You do not have permission to update this schedule"));
            return false;
        }
        if (!userInfo.isAdmin()) {
            newCalendarDef.setOwnerID(existingSchedule.getOwnerID());
        }
        flowManager = this;
        synchronized (flowManager) {
            this.mPredefinedSchedules.remove(existingSchedule.getID());
        }
        boolean bl = success = this.addSchedule(newCalendarDef, true) != null;
        if (!(!success || newCalendarDef.isPubliclyUsable() == existingSchedule.isPubliclyUsable() && newCalendarDef.getOwnerID().equals(existingSchedule.getOwnerID()) && newCalendarDef.getRecurrence().toXML().equals(existingSchedule.getRecurrence().toXML()))) {
            this.updateTriggersForSchedule(newCalendarDef.getID());
        }
        return success;
    }

    private synchronized void updateTriggersForSchedule(String scheduleID) {
        ArrayList<TopLevelFlow> flowsToProcess = new ArrayList<TopLevelFlow>();
        ArrayList<TimeDependency> output = new ArrayList<TimeDependency>();
        for (TopLevelFlow flow : this.mAllFlows.values()) {
            RunCondition trigger = flow.getTriggerConditions();
            output.clear();
            TimeDependency.findTimeDependencies(trigger, output);
            boolean foundScheduleUse = false;
            for (TimeDependency timeDep : output) {
                if (timeDep.getCalendarID() == null || !timeDep.getCalendarID().equals(scheduleID)) continue;
                foundScheduleUse = true;
                break;
            }
            if (!foundScheduleUse) continue;
            flowsToProcess.add(flow);
        }
        this.processFlowTriggers(flowsToProcess);
    }

    private synchronized UserInfo checkSessionAndGetUser(String sessionID) {
        return this.mExecutionProvider.getUserForSession(this, sessionID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PredefinedCalendar getCalendarForID(String calendarID) {
        if (this.mExecutionProvider.isClusteringServer() && !this.mExecutionProvider.isMaster()) {
            return this.mExecutionProvider.getClusteringServer().getCalendarForID(calendarID);
        }
        if (this.mShuttingDown) {
            return null;
        }
        FlowManager flowManager = this;
        synchronized (flowManager) {
            PredefinedCalendar schedule = this.mPredefinedSchedules.get(calendarID);
            return schedule;
        }
    }

    public synchronized boolean isJobLive(String uniqueJobID) {
        return this.mRunningJobMap.containsKey(uniqueJobID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFlowConditions(Collection<RunningFlow> flows) {
        if (flows.size() == 0) {
            return;
        }
        GregorianCalendar serverTime = new GregorianCalendar();
        final ArrayList<PriorityJobWrapper> jobsToDeploy = new ArrayList<PriorityJobWrapper>();
        FlowManager flowManager = this;
        synchronized (flowManager) {
            for (RunningFlow flow : flows) {
                this.mLogger.logMessage(Level.FINEST, FlowManager.generateLogString("Running flow items", flow, "Checking to see if we can run subitems"));
                Calendar nextConditionTime = (Calendar)((Calendar)serverTime).clone();
                nextConditionTime.setTimeInMillis(0L);
                ArrayList<RunningJob> runningJobsToDeploy = new ArrayList<RunningJob>();
                flow.execute(serverTime, flow.getID(), nextConditionTime, runningJobsToDeploy);
                for (RunningJob rJob : runningJobsToDeploy) {
                    PriorityJobWrapper wrapper = new PriorityJobWrapper(rJob, flow);
                    jobsToDeploy.add(wrapper);
                }
                if (nextConditionTime.getTimeInMillis() > serverTime.getTimeInMillis()) {
                    if (this.mMaxTimerRecheckGap > 0L && serverTime.getTimeInMillis() + this.mMaxTimerRecheckGap + 60000L < nextConditionTime.getTimeInMillis()) {
                        nextConditionTime.setTimeInMillis(serverTime.getTimeInMillis() + this.mMaxTimerRecheckGap);
                        nextConditionTime.set(13, 0);
                        nextConditionTime.set(14, 0);
                    }
                    this.addToTimeConditionMap(flow, nextConditionTime.getTimeInMillis());
                    continue;
                }
                nextConditionTime.setTimeInMillis(serverTime.getTimeInMillis());
                nextConditionTime.add(12, 1);
                this.addToTimeConditionMap(flow, nextConditionTime.getTimeInMillis());
            }
        }
        if (jobsToDeploy.size() > 0) {
            Collections.sort(jobsToDeploy, new Comparator<PriorityJobWrapper>(){

                @Override
                public int compare(PriorityJobWrapper o1, PriorityJobWrapper o2) {
                    return RunningItem.adjustPriority(o1.getTargetJob().getJob().getPriority(), o1.getTargetJob().getPriorityAddition()) - RunningItem.adjustPriority(o2.getTargetJob().getJob().getPriority(), o2.getTargetJob().getPriorityAddition());
                }
            });
            this.addActionToNoPersistenceAsyncQueue(new DeferredManagerAction(this){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void execute() throws ShutdownException {
                    for (final PriorityJobWrapper jobWrapper : jobsToDeploy) {
                        RunningJob runningJob = jobWrapper.getTargetJob();
                        synchronized (runningJob) {
                            if (jobWrapper.getTargetJob().getCompletionCode() != 16) {
                                continue;
                            }
                            final ExecutionContext context = FlowManager.this.mExecutionProvider.assignExecutionContext(jobWrapper.getTargetJob());
                            if (context != null) {
                                FlowManager flowManager = FlowManager.this;
                                synchronized (flowManager) {
                                    if (jobWrapper.getTargetJob().isDeleted()) {
                                        continue;
                                    }
                                    if (jobWrapper.getTargetJob().getCompletionCode() != 16) {
                                        continue;
                                    }
                                    jobWrapper.getTargetJob().setExecutionContext(context);
                                    jobWrapper.getTargetJob().markJobInRunningState();
                                    FlowManager.this.mRunningJobMap.put(jobWrapper.getTargetJob().getUniqueInstanceID(), jobWrapper.getTargetJob());
                                }
                                FlowManager.this.addActionToNoPersistenceAsyncQueue(new DeferredManagerAction(FlowManager.this){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void execute() throws ShutdownException {
                                        Object object = FlowManager.this.getJobExecutionSyncObject();
                                        synchronized (object) {
                                            if (jobWrapper.getTargetJob().getCompletionCode() == 8) {
                                                jobWrapper.getTargetJob().markDispatched();
                                                context.execute(jobWrapper.getTargetJob().getJob(), ((TopLevelFlow)jobWrapper.getOutermostFlow().getFlow()).getID(), jobWrapper.getOutermostFlow().getID(), jobWrapper.getTargetJob().getUniqueInstanceID(), FlowManager.this.mExecutionProvider.getUserInfoForID(jobWrapper.getTargetJob().getUserName()));
                                            } else {
                                                FlowManager.this.getLogger().logMessage(Level.FINER, "Job killed before dispatch: " + jobWrapper.getTargetJob().getUniqueInstanceID());
                                            }
                                        }
                                        FlowManager.this.getLogger().logMessage(Level.FINEST, FlowManager.generateLogString("Dispatch", "Job: " + jobWrapper.getTargetJob().getUniqueInstanceID() + " on " + context.getWorkerNodePrintString()));
                                    }
                                });
                            } else {
                                jobWrapper.getTargetJob().incrementPriorityAddition(1);
                                GregorianCalendar currentTime = new GregorianCalendar();
                                Calendar nextConditionTime = (Calendar)((Calendar)currentTime).clone();
                                nextConditionTime.add(12, 2);
                                nextConditionTime.set(14, 0);
                                nextConditionTime.set(13, 0);
                                FlowManager.this.addToTimeConditionMap(jobWrapper.getOutermostFlow(), nextConditionTime.getTimeInMillis());
                            }
                        }
                    }
                }
            });
        }
        GregorianCalendar doneTime = new GregorianCalendar();
        this.mOverheadTime += doneTime.getTimeInMillis() - serverTime.getTimeInMillis();
    }

    protected synchronized void processFlowTriggers(Collection<TopLevelFlow> flows) {
        if (flows.size() == 0) {
            return;
        }
        this.mLogger.logMessage(Level.FINE, "Current running flows: " + this.mRunningFlows.size() + " jobs: " + this.mRunningJobMap.size());
        ArrayList<RunningFlow> flowsToTrigger = new ArrayList<RunningFlow>();
        HashSet<String> flowIDSet = new HashSet<String>();
        GregorianCalendar serverTime = new GregorianCalendar();
        block0: for (TopLevelFlow flow : flows) {
            if (this.mAllFlows.get(flow.getID()) == null || flowIDSet.contains(flow.getID())) continue;
            flowIDSet.add(flow.getID());
            if (flow.isHeld()) continue;
            Map<String, Long> usedTimes = this.mUsedTriggerTimeMap.get(flow.getID());
            if (usedTimes == null) {
                usedTimes = new HashMap<String, Long>();
                this.mUsedTriggerTimeMap.put(flow.getID(), usedTimes);
                this.setUseTimesDirty(true);
            }
            while (true) {
                HashMap<String, Long> usedTimesCopy = new HashMap<String, Long>();
                usedTimesCopy.putAll(usedTimes);
                Calendar nextTriggerTime = (Calendar)((Calendar)serverTime).clone();
                nextTriggerTime.setTimeInMillis(0L);
                boolean canTriggerNow = flow.needsToTriggerNow(this, serverTime, usedTimesCopy, nextTriggerTime);
                if (nextTriggerTime.getTimeInMillis() > serverTime.getTimeInMillis() + 30000L) {
                    if (this.mMaxTimerRecheckGap > 0L && serverTime.getTimeInMillis() + this.mMaxTimerRecheckGap + 60000L < nextTriggerTime.getTimeInMillis()) {
                        nextTriggerTime.setTimeInMillis(serverTime.getTimeInMillis() + this.mMaxTimerRecheckGap);
                        nextTriggerTime.set(13, 0);
                        nextTriggerTime.set(14, 0);
                    }
                    this.addToTimeTriggerMap(flow, nextTriggerTime.getTimeInMillis());
                } else if (!(flow.getTriggerConditions() instanceof RunConditions) || !((RunConditions)flow.getTriggerConditions()).isEmpty()) {
                    this.addRetryTrigger(flow, serverTime);
                }
                if (!canTriggerNow) continue block0;
                int maxRunningFlows = this.mExecutionProvider.getMaxRunningFlowLimit();
                if (maxRunningFlows > 0 && this.mRunningFlows.size() > maxRunningFlows) {
                    this.mLogger.logMessage(Level.WARNING, "Unable to trigger flow: " + flow.getID() + "/" + flow.getName() + ". Max running flows reached=" + this.mExecutionProvider.getMaxRunningFlowLimit());
                    this.addRetryTrigger(flow, serverTime);
                    continue block0;
                }
                int foundCount = 0;
                boolean triggeredThisCycle = false;
                if (flow.getInstanceLimit() > 0) {
                    for (RunningFlow runningFlow : this.mRunningFlows.values()) {
                        if (!((TopLevelFlow)runningFlow.getFlow()).getID().equals(flow.getID())) continue;
                        ++foundCount;
                    }
                    for (RunningFlow rFlow : flowsToTrigger) {
                        if (!((TopLevelFlow)rFlow.getFlow()).getID().equals(flow.getID())) continue;
                        ++foundCount;
                        triggeredThisCycle = true;
                    }
                }
                if (flow.getInstanceLimit() > 0 && foundCount >= flow.getInstanceLimit()) {
                    if (triggeredThisCycle) {
                        this.mLogger.logMessage(Level.FINER, "Unable to trigger flow: " + flow.getID() + "/" + flow.getName() + ". Max running instances reached (but already triggered during this cycle)=" + flow.getInstanceLimit());
                    } else {
                        this.mLogger.logMessage(Level.WARNING, "Unable to trigger flow: " + flow.getID() + "/" + flow.getName() + ". Max running instances reached=" + flow.getInstanceLimit());
                    }
                    this.addRetryTrigger(flow, serverTime);
                    continue block0;
                }
                if (!usedTimes.equals(usedTimesCopy)) {
                    this.mExecutionProvider.saveUsedTimesAsync(flow.getID(), usedTimesCopy);
                    usedTimes.clear();
                    usedTimes.putAll(usedTimesCopy);
                    this.setUseTimesDirty(true);
                }
                RunningFlow rFlow = new RunningFlow(this, flow, flow.getOwner());
                rFlow.addTaskEventListener(this, true);
                this.mLogger.logMessage(Level.FINE, FlowManager.generateLogString("Flow Triggering", rFlow, "Triggering now"));
                rFlow.trigger();
                flowsToTrigger.add(rFlow);
                flow.getTriggerConditions().triggerHasBeenUsed();
            }
        }
        this.addToRunningFlows(flowsToTrigger);
        GregorianCalendar doneTime = new GregorianCalendar();
        this.mOverheadTime += doneTime.getTimeInMillis() - serverTime.getTimeInMillis();
    }

    private void addRetryTrigger(TopLevelFlow flow, Calendar currentServerTime) {
        Calendar nextTriggerTime = Calendar.getInstance();
        nextTriggerTime.setTimeInMillis(currentServerTime.getTimeInMillis());
        nextTriggerTime.add(12, 1);
        nextTriggerTime.set(13, 0);
        nextTriggerTime.set(14, 0);
        this.addToTimeTriggerMap(flow, nextTriggerTime.getTimeInMillis());
    }

    synchronized void saveRunningFlowInfo(RunningFlow rFlow) {
        FlowHistory fh = new FlowHistory(rFlow, this.getLogger());
        FlowInstance instanceData = new FlowInstance(rFlow.getFlow(), fh);
        this.mExecutionProvider.saveRunningFlowInstanceAsync(instanceData);
    }

    private synchronized void addFileStatusTrigger(FileStatusListener listener, TopLevelFlow owningFlow) {
        this.mFileUpdateTask.addFileDependency(listener, owningFlow);
    }

    protected void filterOutOldTriggers(Map<String, Map<String, Long>> triggerMap) {
        long diffTime = 10080000L;
        long lastKeepTime = System.currentTimeMillis() - diffTime;
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(triggerMap.keySet());
        for (String flowID : keys) {
            Map<String, Long> usedTimes = triggerMap.get(flowID);
            boolean newEnoughTimeFound = false;
            Long lastTimeUsed = null;
            for (Long time : usedTimes.values()) {
                if (lastTimeUsed == null || lastTimeUsed < time) {
                    lastTimeUsed = time;
                }
                if (time <= lastKeepTime) continue;
                newEnoughTimeFound = true;
                break;
            }
            if (newEnoughTimeFound) continue;
            triggerMap.remove(flowID);
            if (lastTimeUsed == null) continue;
            this.mLogger.logMessage(Level.FINE, "Removed defunct used time map entry for flow:" + flowID + ".  Last time used was " + SimpleDateFormat.getDateTimeInstance().format(new Date(lastTimeUsed)));
        }
    }

    public synchronized boolean isServerInitialized() {
        return this.mServerInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerFileEvents(String filePath) {
        FlowManager flowManager = this;
        synchronized (flowManager) {
            if (this.isServerInitialized()) {
                HashMap<String, TopLevelFlow> flowsToTrigger = new HashMap<String, TopLevelFlow>();
                for (TopLevelFlow flow : this.mAllFlows.values()) {
                    ArrayList<FileStatusListener> deps = new ArrayList<FileStatusListener>();
                    flow.getTriggerConditions().findRequiredFileTimers(false, deps);
                    for (FileStatusListener listener : deps) {
                        FileDependency dep;
                        if (!(listener instanceof FileDependency) || !(dep = (FileDependency)listener).getFilePath().equals(filePath)) continue;
                        dep.manuallyMakeConditionValid(true);
                        flowsToTrigger.put(flow.getID(), flow);
                    }
                }
                this.processFlowTriggers(flowsToTrigger.values());
                HashMap<String, RunningFlow> flowsToTest = new HashMap<String, RunningFlow>();
                for (RunningFlow rFlow : this.mRunningFlows.values()) {
                    List<FileDependency> deps = rFlow.findActiveFileConditions();
                    if (deps == null) continue;
                    for (FileDependency fileDependency : deps) {
                        if (!fileDependency.getFilePath().equals(filePath)) continue;
                        fileDependency.manuallyMakeConditionValid(false);
                        flowsToTest.put(rFlow.getID(), rFlow);
                    }
                }
                this.processFlowConditions(flowsToTest.values());
            }
        }
    }

    private void clearRunAsUsers(Flow newFlow) {
        newFlow.setUserName("");
        List<ExecutionItem> subItems = newFlow.getSubItems();
        for (ExecutionItem item : subItems) {
            item.setUserName("");
            if (!(item instanceof Flow)) continue;
            this.clearRunAsUsers((Flow)item);
        }
    }

    public synchronized void setUsedTimeTriggerMap(Map<String, Map<String, Long>> triggerMap) {
        this.mUsedTriggerTimeMap = triggerMap;
    }

    public synchronized Map<String, Map<String, Long>> getUseTimeTriggermap() {
        HashMap<String, Map<String, Long>> results = new HashMap<String, Map<String, Long>>();
        for (String key : this.mUsedTriggerTimeMap.keySet()) {
            Map<String, Long> sourceMap = this.mUsedTriggerTimeMap.get(key);
            HashMap<String, Long> copyMap = new HashMap<String, Long>();
            copyMap.putAll(sourceMap);
            results.put(key, copyMap);
        }
        return results;
    }

    public ClientLogger getLogger() {
        return this.mLogger;
    }

    public static void setDefaultLogLevel(Level logLevel) {
        mDefaultLogLevel = logLevel;
    }

    public static ClientLogger getDefaultLogger() {
        if (mDefaultLogger == null) {
            mDefaultLogger = new ClientLogger(){

                @Override
                public void logMessage(Level l, Throwable t) {
                    if (l.intValue() >= mDefaultLogLevel.intValue()) {
                        LOGGER.warn(mSimpleDateFormat.format(new Date(System.currentTimeMillis())) + ": Exception occurred.", t);
                    }
                }

                @Override
                public void logMessage(Level l, String message) {
                    if (l.intValue() >= mDefaultLogLevel.intValue()) {
                        LOGGER.warn(mSimpleDateFormat.format(new Date(System.currentTimeMillis())) + ": " + message);
                    }
                }
            };
        }
        return mDefaultLogger;
    }

    public static ClientLogger getDefaultStdLogger() {
        return new ClientLogger(){

            @Override
            public void logMessage(Level l, Throwable t) {
                if (l.intValue() >= mDefaultLogLevel.intValue()) {
                    System.err.println(mSimpleDateFormat.format(new Date(System.currentTimeMillis())) + ": Exception occurred.");
                    t.printStackTrace(System.err);
                }
            }

            @Override
            public void logMessage(Level l, String message) {
                if (l.intValue() >= mDefaultLogLevel.intValue()) {
                    System.out.println(mSimpleDateFormat.format(new Date(System.currentTimeMillis())) + ": " + message);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateJobStartInfo(String rendevousID, long startTime, String rendererID, String jobQueue) {
        this.getLogger().logMessage(Level.FINER, "Job start (updated): " + rendevousID + " on renderer: " + rendererID);
        RunningJob rj = null;
        FlowManager flowManager = this;
        synchronized (flowManager) {
            rj = this.mRunningJobMap.get(rendevousID);
            if (rj == null) {
                this.getLogger().logMessage(Level.WARNING, "Job start (updated): RendevousID not found in system: " + rendevousID);
            } else {
                if (startTime == 0L) {
                    rj.setStartTime(null);
                } else if (startTime > 0L) {
                    Calendar startCal = Calendar.getInstance();
                    startCal.setTimeInMillis(startTime);
                    rj.setStartTime(startCal);
                }
                if (rendererID != null) {
                    rj.setRendererID(rendererID);
                }
                if (jobQueue != null) {
                    rj.setRunQueue(jobQueue);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markJobFinished(String rendevousID, int statusCode, int exitCode) {
        this.getLogger().logMessage(Level.FINER, "MarkJobFinished: " + rendevousID + " status: " + statusCode + " exit: " + exitCode);
        RunningJob rj = null;
        FlowManager flowManager = this;
        synchronized (flowManager) {
            rj = this.mRunningJobMap.remove(rendevousID);
            if (rj == null) {
                this.getLogger().logMessage(Level.WARNING, "MarkJobFinished: RendevousID not found in system: " + rendevousID);
            }
        }
        if (rj != null) {
            switch (statusCode) {
                case 4: {
                    rj.markDone();
                    break;
                }
                case 2: {
                    boolean retrying = false;
                    if (rj.getRetryAttempts() < rj.getJob().getMaxRetryCount()) {
                        try {
                            RunningFlow topParent;
                            this.getLogger().logMessage(Level.FINE, "MarkJobFinished: Checking job to see if we should rerun it (current retries=" + Integer.toString(rj.getRetryAttempts()) + "/" + Integer.toString(rj.getJob().getMaxRetryCount()) + "): " + rendevousID);
                            RetryCondition retryCondition = rj.getJob().getRetryCondition();
                            boolean shouldRetry = retryCondition.isMatchesCondition(rj, exitCode);
                            if (shouldRetry && (topParent = rj.getTopParent()) != null) {
                                this.getLogger().logMessage(Level.FINE, "MarkJobFinished: Rerunning job that exited: " + rendevousID);
                                rj.incrementRetryAttempts();
                                ArrayList<RunningFlow> flowContainingJob = new ArrayList<RunningFlow>();
                                flowContainingJob.add(rj.getTopParent());
                                rj.markJobInInitialState();
                                this.processFlowConditions(flowContainingJob);
                                retrying = true;
                            }
                        }
                        catch (Exception e) {
                            this.getLogger().logMessage(Level.WARNING, e);
                        }
                    }
                    if (retrying) break;
                    this.getLogger().logMessage(Level.FINE, "MarkJobFinished: Job will not be rerun: " + rendevousID);
                    rj.markExited(exitCode);
                    break;
                }
                case 1: {
                    rj.markKilled();
                    break;
                }
                case 128: {
                    rj.markFailedToRun();
                    break;
                }
                default: {
                    this.getLogger().logMessage(Level.WARNING, "MarkJobFinished: Invalid statusCode: " + statusCode);
                }
            }
        }
    }

    Object getJobExecutionSyncObject() {
        return this.mJobExecutionSyncObject;
    }

    public long getReluctantKillWait() {
        return 600000L;
    }

    public void setServerUninitialized() {
        this.mServerInitialized = false;
    }

    public synchronized void restoreRunningJobToServer(RunningJob job) {
        this.mRunningJobMap.put(job.getUniqueInstanceID(), job);
    }

    public synchronized Collection<TopLevelFlow> getAllFlows() {
        return this.mAllFlows.values();
    }

    public Properties getServerConfig() {
        return this.mConfig;
    }

    public void setServerConfig(Properties properties) {
        this.mConfig = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public List<Long> getScheduleOfTriggerTimes(String sessionID, String flowID, Calendar startTime, Calendar endTime, int count) {
        TopLevelFlow flow;
        TopLevelFlow[] flowDefs;
        ArrayList<Long> results = new ArrayList<Long>();
        if (this.mShuttingDown) {
            return results;
        }
        RunCondition trigger = null;
        if (this.mExecutionProvider.isClusteringServer() && !this.mExecutionProvider.isMaster()) {
            flowDefs = this.mExecutionProvider.getClusteringServer().getFlowDefinitions(sessionID, new String[]{flowID});
            flow = flowDefs[0];
            if (flow != null) {
                trigger = flow.getTriggerConditions();
            }
        } else {
            flowDefs = this;
            // MONITORENTER : this
            this.checkSessionAndGetUser(sessionID);
            flow = this.mAllFlows.get(flowID);
            if (flow != null) {
                trigger = flow.getTriggerConditions();
            }
            // MONITOREXIT : flowDefs
        }
        if (trigger == null) {
            return results;
        }
        TopLevelFlow dummyFlow = new TopLevelFlow(FlowManager.getDefaultLogger());
        dummyFlow.setTriggerConditions(trigger);
        if (startTime == null || startTime.getTimeInMillis() == 0L) {
            startTime = new GregorianCalendar();
        }
        Calendar checkTime = (Calendar)startTime.clone();
        if (endTime == null || endTime.getTimeInMillis() == 0L) {
            endTime = (Calendar)startTime.clone();
            endTime.add(1, 2);
        }
        HashMap<String, Long> usedTimes = new HashMap<String, Long>();
        do {
            if (checkTime.getTimeInMillis() > endTime.getTimeInMillis()) return results;
            Calendar nextTriggerTime = (Calendar)checkTime.clone();
            nextTriggerTime.setTimeInMillis(0L);
            boolean canTrigger = dummyFlow.needsToTriggerNow((FlowManager)this, checkTime, usedTimes, nextTriggerTime);
            if (canTrigger) {
                results.add(checkTime.getTimeInMillis());
            }
            checkTime.setTimeInMillis(nextTriggerTime.getTimeInMillis());
            if (count <= 0) continue;
            if (results.size() >= count) return results;
        } while (checkTime.getTimeInMillis() != 0L);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getNextTriggerTimes(List<String> flowIDs, Calendar overrideServerTime) {
        ArrayList<Long> results = new ArrayList<Long>();
        if (this.mShuttingDown) {
            return results;
        }
        if (this.mExecutionProvider.isClusteringServer() && !this.mExecutionProvider.isMaster()) {
            return this.mExecutionProvider.getClusteringServer().getNextTriggerTimes(flowIDs, overrideServerTime);
        }
        HashMap<String, Long> resultMap = new HashMap<String, Long>();
        for (String id : flowIDs) {
            resultMap.put(id, 0L);
        }
        Calendar serverTime = overrideServerTime;
        if (serverTime == null || serverTime.getTimeInMillis() == 0L) {
            serverTime = new GregorianCalendar();
        }
        FlowManager flowManager = this;
        synchronized (flowManager) {
            Map<String, Map<String, Long>> usedTimeMap = this.getUseTimeTriggermap();
            block4: for (String id : flowIDs) {
                RunCondition trigger;
                TopLevelFlow flow = this.mAllFlows.get(id);
                if (flow == null || (trigger = flow.getTriggerConditions()) == null) continue;
                Map<String, Long> usedTimes = usedTimeMap.get(flow.getID());
                if (usedTimes == null) {
                    usedTimes = new HashMap<String, Long>();
                }
                Calendar checkTime = (Calendar)serverTime.clone();
                for (int checkCount = 100; checkCount >= 0; --checkCount) {
                    Calendar nextTriggerTime = (Calendar)serverTime.clone();
                    nextTriggerTime.setTimeInMillis(0L);
                    boolean canTrigger = flow.needsToTriggerNow(this, checkTime, usedTimes, nextTriggerTime);
                    if (canTrigger) {
                        resultMap.put(flow.getID(), checkTime.getTimeInMillis());
                        continue block4;
                    }
                    checkTime.setTimeInMillis(nextTriggerTime.getTimeInMillis());
                    if (checkTime.getTimeInMillis() == 0L) continue block4;
                }
            }
        }
        for (String id : flowIDs) {
            results.add((Long)resultMap.get(id));
        }
        return results;
    }

    int getFlowExitCodeCalcStyle() {
        if (this.mFlowExitCalcMode < 0) {
            String styleCode = System.getProperty(Prop_RunningFlowExitCodeCalcStyle, null);
            this.mFlowExitCalcMode = 2;
            if (styleCode != null && styleCode.length() > 0) {
                try {
                    this.mFlowExitCalcMode = Integer.parseInt(styleCode);
                }
                catch (Exception e) {
                    this.getLogger().logMessage(Level.INFO, e);
                }
            }
        }
        return this.mFlowExitCalcMode;
    }

    public Timer getUtilityTimer() {
        return this.mUtilityTimer;
    }

    public void setMailService(MailServiceInterface msi) {
        this.mMailService = msi;
    }

    public MailServiceInterface getMailService() {
        return this.mMailService;
    }

    static class PerformAssociatedTasksAction
    extends DeferredManagerAction {
        private RunningItem mExecutionItem;
        private boolean mAtStart;

        public PerformAssociatedTasksAction(FlowManager manager, RunningItem item, boolean atStart) {
            super(manager);
            this.mExecutionItem = item;
            this.mAtStart = atStart;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() throws ShutdownException {
            FlowManager flowManager = this.mManager;
            synchronized (flowManager) {
                ExecutionItem definition = null;
                if (this.mExecutionItem instanceof RunningFlow) {
                    definition = ((RunningFlow)this.mExecutionItem).getFlow();
                } else if (this.mExecutionItem instanceof RunningJob) {
                    definition = ((RunningJob)this.mExecutionItem).getJob();
                }
                if (definition != null && definition.getAssociatedTasks().size() > 0) {
                    this.mManager.getLogger().logMessage(Level.FINE, "Executing associated tasks for: " + definition.getName() + "/" + definition.getUniqueID());
                    for (AssociatedAction action : definition.getAssociatedTasks()) {
                        if (action.isExecuted || !action.willExecute(this.mExecutionItem, this.mAtStart)) continue;
                        final AssociatedAction finalAction = action;
                        this.mManager.mExecutionProvider.addToAsyncQueue(new PersistenceAction(this.mManager.mExecutionProvider){

                            @Override
                            public void execute() throws ShutdownException {
                                finalAction.execute(mExecutionItem, mAtStart);
                            }
                        });
                        action.isExecuted = true;
                    }
                }
            }
        }
    }

    static class CompletedFlowAction
    extends DeferredManagerAction {
        private RunningItem mCompletedItem;

        public CompletedFlowAction(FlowManager manager, RunningItem completedItem) {
            super(manager);
            this.mCompletedItem = completedItem;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() throws ShutdownException {
            FlowInstance flowInstance = null;
            FlowHistory fh = null;
            TopLevelFlow topFlow = null;
            FlowManager flowManager = this.mManager;
            synchronized (flowManager) {
                boolean found;
                if (!(this.mCompletedItem instanceof RunningFlow)) {
                    this.mManager.getLogger().logMessage(Level.WARNING, "Internal error: completed() called with invalid argument");
                    return;
                }
                topFlow = (TopLevelFlow)((RunningFlow)this.mCompletedItem).getFlow();
                if (!((RunningFlow)this.mCompletedItem).areAllSubItemsFinished()) {
                    this.mManager.getLogger().logMessage(Level.FINEST, FlowManager.generateLogString("Flow Completed", topFlow, "Flow still has items running."));
                    return;
                }
                String instanceID = ((RunningFlow)this.mCompletedItem).getID();
                boolean bl = found = this.mManager.mRunningFlows.remove(instanceID) != null;
                if (!found) {
                    this.mManager.getLogger().logMessage(Level.FINE, FlowManager.generateLogString("Flow Completed", topFlow, "Possible error: Completed flow not found.  However, this could be the result of a kill."));
                    return;
                }
                this.mManager.getLogger().logMessage(Level.FINEST, FlowManager.generateLogString("Flow Completed", topFlow, "Flow removed from run queue with status: " + this.mCompletedItem.getCompletionCode() + "(" + this.mCompletedItem.getCompletionString() + ")"));
                this.mManager.setRunningFlowsDirty(true);
                if (((RunningFlow)this.mCompletedItem).isDeleted()) {
                    return;
                }
                fh = new FlowHistory((RunningFlow)this.mCompletedItem, this.mManager.getLogger());
                flowInstance = new FlowInstance(((RunningFlow)this.mCompletedItem).getFlow(), fh);
                this.mManager.mExecutionProvider.removeRunningFlowInstanceAsync(flowInstance.getFlowHistory().getID());
                this.mManager.mExecutionProvider.addFlowHistoryItemAsync(topFlow, fh);
                this.mManager.mExecutionProvider.saveFlowInstanceAsync(flowInstance);
            }
        }
    }

    static class ShutdownAction
    extends DeferredManagerAction {
        public ShutdownAction(FlowManager manager) {
            super(manager);
        }

        @Override
        public void execute() throws ShutdownException {
            throw new ShutdownException(FlowManager.ClosingExceptionText);
        }
    }

    static class FileTriggerTimerTask
    extends TimerTask {
        Map<FileStatusListener, String> mListenersMap = new WeakHashMap<FileStatusListener, String>();
        private FlowManager mManager;

        public FileTriggerTimerTask(FlowManager manager) {
            this.mManager = manager;
        }

        public void removeTriggersFor(TopLevelFlow flow) {
            ArrayList<FileStatusListener> itemsToRemove = new ArrayList<FileStatusListener>();
            for (Map.Entry<FileStatusListener, String> entry : this.mListenersMap.entrySet()) {
                String id = entry.getValue();
                if (!id.equals(flow.getID())) continue;
                itemsToRemove.add(entry.getKey());
            }
            for (FileStatusListener statusListener : itemsToRemove) {
                this.mListenersMap.remove(statusListener);
            }
        }

        public void addFileDependency(FileStatusListener listener, TopLevelFlow containingFlow) {
            if (this.mManager.isServerInitialized()) {
                this.mManager.getLogger().logMessage(Level.FINEST, "File listener added for " + containingFlow.getID() + "=" + listener.toString());
            }
            this.mListenersMap.put(listener, containingFlow.getID());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                FlowManager flowManager = this.mManager;
                HashMap<FileStatusListener, String> fileListeners = new HashMap<FileStatusListener, String>();
                FlowManager flowManager2 = flowManager;
                synchronized (flowManager2) {
                    if (!flowManager.getExecutionProvider().isMaster()) {
                        this.mManager.getLogger().logMessage(Level.FINEST, "FileTriggerTimerTask: Node is not master, returning.");
                        return;
                    }
                    fileListeners.putAll(this.mListenersMap);
                }
                HashSet<String> flowsToRun = new HashSet<String>();
                for (Map.Entry entry : fileListeners.entrySet()) {
                    FileStatusListener dependency = (FileStatusListener)entry.getKey();
                    boolean statusValid = dependency.updateStatus();
                    if (!statusValid) continue;
                    flowsToRun.add((String)entry.getValue());
                }
                FlowManager flowManager3 = flowManager;
                synchronized (flowManager3) {
                    ArrayList<TopLevelFlow> flowsToTrigger = new ArrayList<TopLevelFlow>();
                    for (String id : flowsToRun) {
                        TopLevelFlow flow = (TopLevelFlow)flowManager.mAllFlows.get(id);
                        if (flow == null) continue;
                        flowsToTrigger.add(flow);
                    }
                    if (flowsToTrigger.size() > 0) {
                        flowManager.processFlowTriggers(flowsToTrigger);
                    }
                }
            }
            catch (Exception e) {
                this.mManager.getLogger().logMessage(Level.WARNING, e);
            }
        }
    }

    static class FileConditionTimerTask
    extends TimerTask {
        List<RunningJob> mJobs = new ArrayList<RunningJob>();
        private FlowManager mManager;
        private String mFlowID;
        private String mInstanceID;

        public FileConditionTimerTask(FlowManager manager, String flowID, String instanceID) {
            this.mManager = manager;
            this.mFlowID = flowID;
            this.mInstanceID = instanceID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block13: {
                try {
                    List<FileDependency> fileDeps = null;
                    FlowManager flowManager = this.mManager;
                    synchronized (flowManager) {
                        Object o = this.mManager.mAllFlows.get(this.mFlowID);
                        if (o == null) {
                            this.cancel();
                            return;
                        }
                        RunningFlow rf = (RunningFlow)this.mManager.mRunningFlows.get(this.mInstanceID);
                        if (rf == null) {
                            this.cancel();
                            return;
                        }
                        fileDeps = rf.findActiveFileConditions();
                    }
                    if (fileDeps == null || fileDeps.size() == 0) {
                        this.cancel();
                        break block13;
                    }
                    boolean someTrue = false;
                    for (FileDependency fileDependency : fileDeps) {
                        someTrue |= fileDependency.updateStatus();
                    }
                    if (!someTrue) break block13;
                    FlowManager flowManager2 = this.mManager;
                    synchronized (flowManager2) {
                        ArrayList<RunningFlow> tempList = new ArrayList<RunningFlow>();
                        RunningFlow rf = (RunningFlow)this.mManager.mRunningFlows.get(this.mInstanceID);
                        if (rf == null) {
                            this.cancel();
                            return;
                        }
                        tempList.add(rf);
                        this.mManager.processFlowConditions(tempList);
                    }
                }
                catch (Exception e) {
                    this.mManager.getLogger().logMessage(Level.WARNING, e);
                }
            }
        }
    }

    public static class MaintenanceTimerTask
    extends TimerTask {
        private FlowManager mManager;

        public MaintenanceTimerTask(FlowManager manager) {
            this.mManager = manager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                FlowManager flowManager = this.mManager;
                synchronized (flowManager) {
                    this.mManager.filterOutOldTriggers(this.mManager.mUsedTriggerTimeMap);
                    if (this.mManager.mExecutionProvider.isMaster()) {
                        this.mManager.mExecutionProvider.performOnTheFlyPersistedDataCleanup();
                    }
                    this.mManager.mFileDependencyTimer.purge();
                }
            }
            catch (Exception e) {
                this.mManager.getLogger().logMessage(Level.WARNING, e);
            }
        }
    }

    static class TimeConditionTimerTask
    extends TimerTask {
        private List<String> mFlows = new ArrayList<String>();
        private FlowManager mManager;

        public TimeConditionTimerTask(FlowManager manager) {
            this.mManager = manager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                FlowManager flowManager;
                FlowManager flowManager2 = flowManager = this.mManager;
                synchronized (flowManager2) {
                    if (!flowManager.getExecutionProvider().isMaster()) {
                        this.mManager.getLogger().logMessage(Level.FINEST, "TimeConditionTimerTask: Node is not master, returning.");
                        return;
                    }
                    ArrayList<RunningFlow> tempList = new ArrayList<RunningFlow>();
                    for (String id : this.mFlows) {
                        RunningFlow topFlow = (RunningFlow)flowManager.mRunningFlows.get(id);
                        if (topFlow == null) continue;
                        tempList.add(topFlow);
                    }
                    flowManager.processFlowConditions(tempList);
                }
            }
            catch (Exception e) {
                this.mManager.getLogger().logMessage(Level.WARNING, e);
            }
        }

        public void addFlow(RunningFlow flow) {
            for (String flowID : this.mFlows) {
                if (!flow.getID().equals(flowID)) continue;
                return;
            }
            this.mFlows.add(flow.getID());
        }
    }

    protected static class TimeTriggerTimerTask
    extends TimerTask {
        private Set<String> mFlows = new HashSet<String>();
        private FlowManager mFlowManager;
        private Long mTriggerTime;

        public TimeTriggerTimerTask(FlowManager manager, Long triggerTime) {
            this.mFlowManager = manager;
            this.mTriggerTime = triggerTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                FlowManager flowManager;
                FlowManager flowManager2 = flowManager = this.mFlowManager;
                synchronized (flowManager2) {
                    if (!flowManager.getExecutionProvider().isMaster()) {
                        this.mFlowManager.getLogger().logMessage(Level.FINEST, "TimeTriggerTimerTask: Node is not master, returning.");
                        return;
                    }
                    Object removedItem = flowManager.mTimeTriggerTimerMap.remove(this.mTriggerTime);
                    if (removedItem != this) {
                        flowManager.getLogger().logMessage(Level.WARNING, "Time trigger map inconsistent.");
                    }
                    ArrayList<TopLevelFlow> tempList = new ArrayList<TopLevelFlow>();
                    for (String id : this.mFlows) {
                        TopLevelFlow topFlow = (TopLevelFlow)flowManager.mAllFlows.get(id);
                        if (topFlow == null) continue;
                        tempList.add(topFlow);
                    }
                    flowManager.processFlowTriggers(tempList);
                }
            }
            catch (Exception e) {
                this.mFlowManager.getLogger().logMessage(Level.WARNING, e);
            }
        }

        public void addFlow(TopLevelFlow flow) {
            String flowID = flow.getID();
            if (this.mFlows.contains(flowID)) {
                return;
            }
            this.mFlows.add(flowID);
        }
    }

    private static class PriorityJobWrapper {
        private RunningJob mTargetJob;
        private RunningFlow mOutermostFlow;

        public PriorityJobWrapper(RunningJob targetJob, RunningFlow mainFlow) {
            this.mTargetJob = targetJob;
            this.mOutermostFlow = mainFlow;
        }

        public RunningFlow getOutermostFlow() {
            return this.mOutermostFlow;
        }

        public RunningJob getTargetJob() {
            return this.mTargetJob;
        }
    }

    public static class FlowTimeHolder {
        private TopLevelFlow mFlow;
        private long mTime;

        public FlowTimeHolder(TopLevelFlow flow, long time) {
            this.mFlow = flow;
            this.mTime = time;
        }

        public TopLevelFlow getFlow() {
            return this.mFlow;
        }

        public long getTime() {
            return this.mTime;
        }
    }
}

