/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.ExecutionItem;
import com.sas.scheduler.api.servers.ip.engine.Job;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Flow
extends ExecutionItem {
    static final String XML_Flow_Tag = "Flow";
    static final String XML_SubItems_Tag = "SubItems";
    static final String XML_KillRemainingItems_Tag = "KillRemainingItems";
    static final String XML_AllMustComplete_Tag = "AllMustComplete";
    static final String XML_RequiredItems_Tag = "RequiredItems";
    private List<ExecutionItem> mSubItems = new ArrayList<ExecutionItem>();
    private boolean mKillRunningItemsWhenComplete = false;
    private List<String> mRequiredSubItems = null;
    private boolean mAllMustComplete = true;

    public Flow(ClientLogger logger) {
        super(logger);
    }

    public List<ExecutionItem> getSubItems() {
        return this.mSubItems;
    }

    public void addSubItem(ExecutionItem item) {
        if (item != null) {
            this.mSubItems.add(item);
        }
    }

    public void removeSubItem(ExecutionItem item) {
        if (item != null) {
            this.mSubItems.remove(item);
        }
    }

    public List<String> getRequiredSubItems() {
        return this.mRequiredSubItems;
    }

    public boolean getAllMustComplete() {
        return this.mAllMustComplete;
    }

    public void setCompletionCondition(List<String> executionItems, boolean all) {
        this.mRequiredSubItems = null;
        if (executionItems != null) {
            this.mRequiredSubItems = new ArrayList<String>();
            for (String item : executionItems) {
                this.mRequiredSubItems.add(item);
            }
        }
        this.mAllMustComplete = all;
    }

    public void removeCompletionCondition() {
        this.mRequiredSubItems = null;
        this.mAllMustComplete = false;
    }

    public void setKillRunningItemsWhenComplete(boolean kill) {
        this.mKillRunningItemsWhenComplete = kill;
    }

    public boolean getKillRunningItemsWhenComplete() {
        return this.mKillRunningItemsWhenComplete;
    }

    public Flow copy(boolean copySubItems) {
        Flow tempFlow = new Flow(this.mLogger);
        tempFlow.copyFrom(this, copySubItems);
        return tempFlow;
    }

    public void copyFrom(Flow flow, boolean copySubItems) {
        super.copyFrom(flow);
        this.mSubItems.clear();
        if (copySubItems) {
            for (ExecutionItem item : flow.mSubItems) {
                if (item instanceof Flow) {
                    Flow tempFlow = ((Flow)item).copy(true);
                    this.mSubItems.add(tempFlow);
                    continue;
                }
                if (!(item instanceof Job)) continue;
                Job tempJob = ((Job)item).copy();
                this.mSubItems.add(tempJob);
            }
        }
        this.mKillRunningItemsWhenComplete = flow.mKillRunningItemsWhenComplete;
        this.mAllMustComplete = flow.mAllMustComplete;
        if (flow.mRequiredSubItems == null) {
            this.mRequiredSubItems = null;
        } else {
            this.mRequiredSubItems = new ArrayList<String>();
            this.mRequiredSubItems.addAll(flow.mRequiredSubItems);
        }
    }

    void getAllSubItems(List<ExecutionItem> flattenedSubItems) {
        for (ExecutionItem item : this.mSubItems) {
            if (item instanceof Job) {
                flattenedSubItems.add(item);
                continue;
            }
            if (!(item instanceof Flow)) continue;
            flattenedSubItems.add(item);
            ((Flow)item).getAllSubItems(flattenedSubItems);
        }
    }

    protected static void processFlowTag(Flow flow, Node flowNode, ClientLogger logger) {
        Flow.processExecutionItemTag(flow, flowNode);
        NamedNodeMap attributes = flowNode.getAttributes();
        Node killNode = attributes.getNamedItem(XML_KillRemainingItems_Tag);
        if (killNode != null) {
            flow.setKillRunningItemsWhenComplete(Boolean.valueOf(killNode.getNodeValue()));
        }
        Node allMustCompleteNode = attributes.getNamedItem(XML_AllMustComplete_Tag);
        boolean allMustComplete = false;
        if (allMustCompleteNode != null) {
            allMustComplete = Boolean.valueOf(allMustCompleteNode.getNodeValue());
        }
        boolean seenRequiredItems = false;
        NodeList children = flowNode.getChildNodes();
        int listLength = children.getLength();
        for (int i = 0; i < listLength; ++i) {
            Node child = children.item(i);
            String tagName = child.getNodeName();
            if (tagName.equals(XML_RequiredItems_Tag)) {
                String tagValue = ExecutionItem.getCData(child);
                String[] requiredItemIDs = tagValue.split("\n");
                seenRequiredItems = true;
                ArrayList<String> requiredIDs = new ArrayList<String>();
                for (int k = 0; k < requiredItemIDs.length; ++k) {
                    String itemID = requiredItemIDs[k].trim();
                    if (itemID.length() <= 0) continue;
                    requiredIDs.add(itemID);
                }
                flow.setCompletionCondition(requiredIDs, allMustComplete);
                continue;
            }
            if (!tagName.equals(XML_SubItems_Tag)) continue;
            NodeList subItems = child.getChildNodes();
            int subItemCount = subItems.getLength();
            for (int k = 0; k < subItemCount; ++k) {
                Node subItem = subItems.item(k);
                String itemName = subItem.getNodeName();
                if (itemName.equals(XML_Flow_Tag)) {
                    Flow newFlow = new Flow(logger);
                    Flow.processFlowTag(newFlow, subItem, logger);
                    flow.addSubItem(newFlow);
                    continue;
                }
                if (!itemName.equals("Job")) continue;
                Job newJob = new Job(logger);
                Job.processJobTag(newJob, subItem);
                flow.addSubItem(newJob);
            }
        }
        if (!seenRequiredItems) {
            flow.setCompletionCondition(null, allMustComplete);
        }
    }

    public String toString() {
        return this.toSerializedForm();
    }

    public void setPriority(int priority, boolean recursive) {
        super.setPriority(priority);
        if (recursive) {
            for (ExecutionItem child : this.mSubItems) {
                if (child instanceof Flow) {
                    ((Flow)child).setPriority(priority, true);
                    continue;
                }
                child.setPriority(priority);
            }
        }
    }

    public void incrementPriority(int extra, boolean recursive) {
        super.incrementPriority(extra);
        if (recursive) {
            for (ExecutionItem child : this.mSubItems) {
                if (child instanceof Flow) {
                    ((Flow)child).incrementPriority(extra, true);
                    continue;
                }
                child.incrementPriority(extra);
            }
        }
    }

    @Override
    protected void serialize(Document doc, Node parent) {
        Element tag = doc.createElement(XML_Flow_Tag);
        parent.appendChild(tag);
        this.injectXML(doc, tag);
    }

    @Override
    protected void injectXML(Document doc, Element flowElement) {
        super.injectXML(doc, flowElement);
        flowElement.setAttribute(XML_KillRemainingItems_Tag, Boolean.toString(this.mKillRunningItemsWhenComplete));
        flowElement.setAttribute(XML_AllMustComplete_Tag, Boolean.toString(this.mAllMustComplete));
        if (this.mSubItems.size() > 0) {
            Element subItems = doc.createElement(XML_SubItems_Tag);
            flowElement.appendChild(subItems);
            for (ExecutionItem runItem : this.mSubItems) {
                if (runItem instanceof Job) {
                    Job job = (Job)runItem;
                    job.serialize(doc, subItems);
                    continue;
                }
                if (!(runItem instanceof Flow)) continue;
                Flow flow = (Flow)runItem;
                flow.serialize(doc, subItems);
            }
        }
        if (this.mRequiredSubItems != null) {
            Element requiredItems = doc.createElement(XML_RequiredItems_Tag);
            flowElement.appendChild(requiredItems);
            StringWriter sw = new StringWriter();
            BufferedWriter writer = new BufferedWriter(sw);
            for (String itemID : this.mRequiredSubItems) {
                try {
                    writer.write(itemID);
                    writer.newLine();
                }
                catch (IOException iOException) {}
            }
            try {
                writer.close();
            }
            catch (IOException flow) {
                // empty catch block
            }
            String itemData = sw.toString();
            requiredItems.setTextContent(itemData);
        }
    }

    @Override
    public boolean equals(Object obj) {
        int i;
        if (!(obj instanceof Flow)) {
            return false;
        }
        Flow other = (Flow)obj;
        if (other.mAllMustComplete != this.mAllMustComplete) {
            return false;
        }
        if (other.mKillRunningItemsWhenComplete != this.mKillRunningItemsWhenComplete) {
            return false;
        }
        if (other.mSubItems.size() != this.mSubItems.size()) {
            return false;
        }
        for (i = 0; i < this.mSubItems.size(); ++i) {
            if (this.mSubItems.get(i).equals(other.mSubItems.get(i))) continue;
            return false;
        }
        if (this.mRequiredSubItems != null && other.mRequiredSubItems != null) {
            if (other.mRequiredSubItems.size() != this.mRequiredSubItems.size()) {
                return false;
            }
            for (i = 0; i < this.mRequiredSubItems.size(); ++i) {
                if (this.mRequiredSubItems.get(i).equals(other.mRequiredSubItems.get(i))) continue;
                return false;
            }
        } else if (this.mRequiredSubItems != other.mRequiredSubItems) {
            return false;
        }
        return super.equals(obj);
    }
}

