/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.ExecutionItem;
import com.sas.scheduler.api.servers.ip.engine.FileDependency;
import com.sas.scheduler.api.servers.ip.engine.FileStatusListener;
import com.sas.scheduler.api.servers.ip.engine.RunCondition;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileSizeDependency
extends FileDependency
implements FileStatusListener {
    static final String XML_FileSizeDependency_Tag = "FileSizeDependency";
    private static final String XML_Size_Tag = "Size";
    private int mComparisonCode;
    private long mComparisonSize;
    private transient boolean mPreviousStatus;

    public FileSizeDependency(String filePath, int comparisonCode, long size, ClientLogger logger) {
        super(filePath, logger);
        this.mComparisonCode = comparisonCode;
        this.mComparisonSize = size;
        this.mPreviousStatus = false;
    }

    public FileSizeDependency(ClientLogger logger) {
        super(logger);
        this.mComparisonCode = 10;
        this.mComparisonSize = 100000L;
        this.mPreviousStatus = false;
    }

    public int getComparisonCode() {
        return this.mComparisonCode;
    }

    public void setComparisonCode(int comparisonCode) {
        if (comparisonCode == 12 || comparisonCode == 15 || comparisonCode == 10 || comparisonCode == 13 || comparisonCode == 11 || comparisonCode == 14) {
            this.mComparisonCode = comparisonCode;
        }
    }

    public long getSize() {
        return this.mComparisonSize;
    }

    public void setSize(long size) {
        if (size >= 0L) {
            this.mComparisonSize = size;
        }
    }

    @Override
    protected boolean isConditionSatisfied(boolean[] outputDataChanged) {
        boolean oldStatus = this.mPreviousStatus;
        File f = new File(this.getFilePath());
        if (!this.fileExists(f)) {
            this.mPreviousStatus = false;
            outputDataChanged[0] = this.mPreviousStatus != oldStatus;
            return false;
        }
        long fileSize = this.fileLength(f);
        this.mPreviousStatus = this.checkSize(fileSize);
        outputDataChanged[0] = this.mPreviousStatus != oldStatus;
        return this.mPreviousStatus;
    }

    private boolean checkSize(long fileSize) {
        switch (this.mComparisonCode) {
            case 10: {
                if (fileSize <= this.mComparisonSize) break;
                return true;
            }
            case 11: {
                if (fileSize >= this.mComparisonSize) break;
                return true;
            }
            case 12: {
                if (fileSize != this.mComparisonSize) break;
                return true;
            }
            case 15: {
                if (fileSize == this.mComparisonSize) break;
                return true;
            }
            case 13: {
                if (fileSize < this.mComparisonSize) break;
                return true;
            }
            case 14: {
                if (fileSize > this.mComparisonSize) break;
                return true;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    @Override
    public void serialize(Document doc, Node parent) {
        Element tag = doc.createElement(XML_FileSizeDependency_Tag);
        parent.appendChild(tag);
        this.injectXML(doc, tag);
    }

    @Override
    protected void injectXML(Document doc, Element tag) {
        super.injectXML(doc, tag);
        tag.setAttribute(XML_Size_Tag, Long.toString(this.mComparisonSize));
        tag.setAttribute("ComparisonCode", Integer.toString(this.mComparisonCode));
    }

    @Override
    public RunCondition copy() {
        FileSizeDependency dep = new FileSizeDependency(this.getFilePath(), this.getComparisonCode(), this.getSize(), this.mLogger);
        dep.setTriggerRestriction(this.getTriggerRestriction());
        dep.copyFrom(this);
        return dep;
    }

    @Override
    public String toString() {
        StringBuffer printString = new StringBuffer();
        printString.append("Runs if file: " + this.getFilePath() + " ");
        switch (this.mComparisonCode) {
            case 12: {
                printString.append("=");
                break;
            }
            case 15: {
                printString.append("!=");
                break;
            }
            case 10: {
                printString.append(">");
                break;
            }
            case 13: {
                printString.append(">=");
                break;
            }
            case 11: {
                printString.append("<");
                break;
            }
            case 14: {
                printString.append("<=");
            }
        }
        printString.append(this.mComparisonSize);
        printString.append(" bytes.");
        if (!this.getTriggerRestriction()) {
            printString.append("Trigger valid whenever the condition is true.");
        } else {
            printString.append("Trigger valid only when condition becomes true.");
        }
        return printString.toString();
    }

    public static RunCondition processSizeCondition(Node node, ClientLogger logger) {
        Node triggerRestrictionNode;
        Node comparisonNode;
        FileSizeDependency dependency = new FileSizeDependency(logger);
        NamedNodeMap attributes = node.getAttributes();
        dependency.processAttributes(attributes);
        Node sizeNode = attributes.getNamedItem(XML_Size_Tag);
        if (sizeNode != null) {
            dependency.setSize(Long.valueOf(sizeNode.getNodeValue()));
        }
        if ((comparisonNode = attributes.getNamedItem("ComparisonCode")) != null) {
            dependency.setComparisonCode(Integer.valueOf(comparisonNode.getNodeValue()));
        }
        if ((triggerRestrictionNode = attributes.getNamedItem("RestrictTrigger")) != null) {
            dependency.setTriggerRestriction(Boolean.valueOf(triggerRestrictionNode.getNodeValue()));
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String tagName = child.getNodeName();
            if (!tagName.equals("FilePath")) continue;
            String filePath = ExecutionItem.getCData(child);
            dependency.setFilePath(filePath);
        }
        return dependency;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof FileSizeDependency)) {
            return false;
        }
        FileSizeDependency other = (FileSizeDependency)obj;
        if (other.mComparisonSize != this.mComparisonSize) {
            return false;
        }
        if (other.mComparisonCode != this.mComparisonCode) {
            return false;
        }
        return super.equals(obj);
    }
}

